'''OpenGL extension MESA.sampler_objects

This module customises the behaviour of the 
OpenGL.raw.GLES2.MESA.sampler_objects to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension makes the sampler object subset of OpenGL ES 3.0 available
	in OpenGL ES 2.0 contexts. As the intent is to allow access to the API
	without necessarily requiring additional renderer functionality, some
	sampler state that would be mandatory in GLES 3 is dependent on the
	presence of additional extensions. Under GLES 3.0 or above this extension's
	name string may be exposed for compatibility, but it is otherwise without
	effect.
	
	Refer to the OpenGL ES 3.0 specification for API details not covered here.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/MESA/sampler_objects.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.MESA.sampler_objects import *
from OpenGL.raw.GLES2.MESA.sampler_objects import _EXTENSION_NAME

def glInitSamplerObjectsMESA():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glGenSamplers=wrapper.wrapper(glGenSamplers).setOutput(
    'samplers',size=lambda x:(x,),pnameArg='count',orPassIn=True
)
# INPUT glDeleteSamplers.samplers size not checked against count
glDeleteSamplers=wrapper.wrapper(glDeleteSamplers).setInputArraySize(
    'samplers', None
)
# INPUT glSamplerParameteriv.param size not checked against 'pname'
glSamplerParameteriv=wrapper.wrapper(glSamplerParameteriv).setInputArraySize(
    'param', None
)
# INPUT glSamplerParameterfv.param size not checked against 'pname'
glSamplerParameterfv=wrapper.wrapper(glSamplerParameterfv).setInputArraySize(
    'param', None
)
glGetSamplerParameteriv=wrapper.wrapper(glGetSamplerParameteriv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetSamplerParameterfv=wrapper.wrapper(glGetSamplerParameterfv).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
### END AUTOGENERATED SECTION