% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DisplayPars-class.R
\docType{class}
\name{DisplayPars-class}
\alias{DisplayPars-class}
\alias{.DisplayPars}
\alias{DisplayPars}
\alias{getPar}
\alias{getPar,DisplayPars,character-method}
\alias{getPar,DisplayPars,missing-method}
\alias{displayPars}
\alias{displayPars,DisplayPars,missing-method}
\alias{displayPars,DisplayPars,character-method}
\alias{as.list,DisplayPars-method}
\alias{setPar}
\alias{setPar,DisplayPars,list-method}
\alias{setPar,DisplayPars,character-method}
\alias{displayPars<-}
\alias{displayPars<-,DisplayPars,list-method}
\alias{show,DisplayPars-method}
\alias{as.list,InferredDisplayPars-method}
\alias{show,InferredDisplayPars-method}
\alias{availableDisplayPars}
\title{DisplayPars: A class to control the plotting parameters for GdObjects}
\usage{
DisplayPars(...)

getPar(x, name, ...)

\S4method{getPar}{DisplayPars,character}(x, name, asIs = FALSE)

\S4method{getPar}{DisplayPars,missing}(x, hideInternal = TRUE)

displayPars(x, name, ...)

\S4method{displayPars}{DisplayPars,missing}(x, hideInternal = TRUE)

\S4method{displayPars}{DisplayPars,character}(x, name)

\S4method{as.list}{DisplayPars}(x)

setPar(x, value, ...)

\S4method{setPar}{DisplayPars,list}(x, value, interactive = TRUE)

\S4method{setPar}{DisplayPars,character}(x, name, value, interactive = TRUE)

displayPars(x, recursive = FALSE) <- value

\S4method{displayPars}{DisplayPars,list}(x, recursive = FALSE) <- value

\S4method{show}{DisplayPars}(object)

\S4method{as.list}{InferredDisplayPars}(x)

\S4method{show}{InferredDisplayPars}(object)

availableDisplayPars(class)
}
\arguments{
\item{\dots}{All named arguments are stored in the object's environment as
individual parameters, regardless of their type.}

\item{x}{object to set the displayPar value on}

\item{name}{Name of the retrieved parameter.}

\item{asIs}{\code{logical}}

\item{hideInternal}{\code{logical}}

\item{value}{named value to be set}

\item{interactive}{\code{logical}}

\item{recursive}{\code{logical}}

\item{object}{object}

\item{class}{Either character scalar or object. Supported classes are:
\code{GdObject}, \code{GenomeAxisTrack}, \code{RangeTrack}, \code{NumericTrack}, \code{DataTrack},
\code{IdeogramTrack}, \code{StackedTrack}, \code{AnnotationTrack}, \code{DetailsAnnotationTrack},
\code{GeneRegionTrack}, \code{BiomartGeneRegionTrack}, \code{AlignmentsTrack},
\code{SequenceTrack}, \code{SequenceBSgenomeTrack}, \code{SequenceDNAStringSetTrack},
\code{SequenceRNAStringSetTrack}}
}
\value{
The return value of the constructor function is a new object of class
\code{DisplayPars}.

\code{availableDisplayPars} returns a list of the default display
parameters.
}
\description{
All tracks within this package are highly customizable. The
\code{DisplayPars} class facilitates this and provides a unified API to the
customization parameters.

The individual parameters in a \code{DisplayParameters} class are stored as
pointers in an environment. This has the upshot of not having to copy the
whole track object when changing parameters, and parameters can be updated
without the need to explicitly reassign the track to a symbol (i.e.,
updating of parameters happens in place). The downside is that upon copying
of track objects, the parameter environment needs to be re-instantiated.

Objects can be created using the constructor function \code{DisplayPars}.

The default display parameters for a track object class can be queried using
the \code{availableDisplayPars} function.
}
\section{Functions}{
\itemize{
\item \code{DisplayPars()}: Constructor function.

\item \code{getPar()}: Generics for \code{getPar}.

\item \code{getPar(x = DisplayPars, name = character)}: Alias for the \code{displayPars} method.

\item \code{getPar(x = DisplayPars, name = missing)}: Alias for the \code{displayPars} method.

\item \code{displayPars()}: Generics for \code{displayPars}.

\item \code{displayPars(x = DisplayPars, name = missing)}: Returns all available display parameters.

\item \code{displayPars(x = DisplayPars, name = character)}: Returns the value of a subset of display parameters, as identified by \code{name}.

\item \code{as.list(DisplayPars)}: Converts \code{DisplayPars} to \code{list}.

\item \code{setPar()}: Generics for \code{SetPar}.

SetPar generic function

\item \code{setPar(x = DisplayPars, value = list)}: Sets display parameters by the values of the
named \code{list} in value. Note that display parameters in the \code{DisplayPars-class}
are pass-by-reference, so no re-assignment to the symbol \code{obj} is necessary.

\item \code{setPar(x = DisplayPars, value = character)}: set the single display parameter name to value.
Note that display parameters in the DisplayPars class are pass-by-reference,
so no re-assignment to the symbol \code{obj} is necessary.

\item \code{displayPars(x, recursive = FALSE) <- value}: Generics for \verb{displayPars<-}.

\item \code{displayPars(x = DisplayPars) <- value}: Replaces or adds display parameters as provided by the named \code{list} items.

\item \code{show(DisplayPars)}: Show method.

\item \code{as.list(InferredDisplayPars)}: Return \code{InferredDisplayPars} as a \code{list}.

\item \code{show(InferredDisplayPars)}: Show method.

\item \code{availableDisplayPars()}: Get default display parameters.

}}
\section{Slots}{

\describe{
\item{\code{pars}}{an environment or a list containing parameter key value pairs.}
}}

\examples{
## Construct object
dp <- DisplayPars(col = "red", lwd = 2, transformation = log2)
dp

## Query parameters
displayPars(dp)
displayPars(dp, "col")
getPar(dp, c("col", "transformation"))

## Modify parameters
displayPars(dp) <- list(lty = 1, fontsize = 3)
setPar(dp, "pch", 20)
dp
## Default parameters
availableDisplayPars("GenomeAxisTrack")
}
\author{
Florian Hahne
}
