% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/343-extractDrugVABC.R
\name{extractDrugVABC}
\alias{extractDrugVABC}
\title{Descriptor that Calculates the Volume of A Molecule}
\usage{
extractDrugVABC(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{VABC}.
}
\description{
Descriptor that Calculates the Volume of A Molecule
}
\details{
This descriptor calculates the volume of a molecule.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugVABC(mol)
head(dat)}
}
