% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MuraroPancreasData.R
\name{MuraroPancreasData}
\alias{MuraroPancreasData}
\title{Obtain the Muraro pancreas data}
\usage{
MuraroPancreasData(ensembl = FALSE, location = TRUE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the human pancreas single-cell RNA-seq data from Muraro et al. (2016).
}
\details{
Row data contains fields for the symbol and chromosomal location of each gene.

Column metadata is derived from the columns of the count matrix provided in GSE85241,
with additional cell type labels obtained from the authors (indirectly, via the Hemberg group).
Some cells have \code{NA} labels and were presumably removed prior to downstream analyses.

Count data for ERCC spike-ins are stored in the \code{"ERCC"} entry of the \code{\link{altExps}}.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/muraro-pancreas}.
}
\examples{
sce <- MuraroPancreasData()

}
\references{
Muraro MJ et al. (2016). 
A single-cell transcriptome atlas of the human pancreas.
\emph{Cell Syst.} 3(4), 385-394.
}
\author{
Aaron Lun,
using additional metadata obtained by Vladimir Kiselev.
}
