% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions-VCF.R
\name{isStructural}
\alias{isStructural}
\alias{isStructural,CollapsedVCF-method}
\alias{isStructural,ExpandedVCF-method}
\alias{isStructural,VCF-method}
\title{Determining whether the variant is a structural variant}
\usage{
isStructural(x, ...)

\S4method{isStructural}{CollapsedVCF}(x, ..., singleAltOnly = TRUE)

\S4method{isStructural}{ExpandedVCF}(x, ...)

\S4method{isStructural}{VCF}(x, ...)
}
\arguments{
\item{x}{A VCF object.}

\item{...}{Internal parameters.}

\item{singleAltOnly}{Whether only single ALT values are accepted. Default is
set to TRUE.}
}
\value{
A logical list of which the length is the same with the input object.
}
\description{
Determining whether the variant is a structural variant
}
\details{
The function takes a VCF object as input, and returns a logical
value for each row, determining whether the variant is a structural variant.
}
\section{Methods (by class)}{
\itemize{
\item \code{CollapsedVCF}: Determining whether a CollapsedVCF object is a 
strucrual variant. Only single ALT values are accepted.

\item \code{ExpandedVCF}: Determining whether a ExpandedVCF object is a 
structural variant.

\item \code{VCF}: Determining whether a VCF object is a structural
variant.
}}

\examples{
vcf.file <- system.file("extdata", "gridss.vcf", package = "StructuralVariantAnnotation")
vcf <- VariantAnnotation::readVcf(vcf.file, "hg19")
isStructural(vcf)
}
