% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstalk.R
\name{ClientValue}
\alias{ClientValue}
\title{ClientValue object}
\description{
An object that can be used in a \href{https://shiny.rstudio.com/}{Shiny} server
function to get or set a crosstalk variable that exists on the client. The
client copy of the variable is the canonical copy, so there is no direct
"set" method that immediately changes the value; instead, there is a
`sendUpdate` method that sends a request to the browser to change the value,
which will then cause the new value to be relayed back to the server.

This object is used to implement \code{\link{SharedData}} and should not need
to be used directly by users.
}
\examples{
library(shiny)

server <- function(input, output, session) {
  cv <- ClientValue$new("var1", "group1")

  r <- reactive({
    # Don't proceed unless cv$get() is a non-NULL value
    validate(need(cv$get(), message = FALSE))

    runif(cv$get())
  })

  observeEvent(input$click, {
    cv$sendUpdate(NULL)
  })
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ClientValue$new()}}
\item \href{#method-get}{\code{ClientValue$get()}}
\item \href{#method-sendUpdate}{\code{ClientValue$sendUpdate()}}
\item \href{#method-clone}{\code{ClientValue$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new ClientValue object to reflect the crosstalk variable
specified by `group` and `name`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClientValue$new(
  name,
  group = "default",
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the crosstalk variable.}

\item{\code{group}}{The name of the crosstalk variable group.}

\item{\code{session}}{The Shiny session to connect to; defaults to the current
session.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Read the value. This is a reactive operation akin to reading a reactive
value, and so can only be done in a reactive context (e.g. in a
`shiny::reactive()`, `shiny::observe()`, or `shiny::isolate()` block).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClientValue$get()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sendUpdate"></a>}}
\if{latex}{\out{\hypertarget{method-sendUpdate}{}}}
\subsection{Method \code{sendUpdate()}}{
Send a message to the browser asking it to update the crosstalk var to
the given value. This update does not happen synchronously, that is, a
call to `get()` immediately following `sendUpdate(value)` will not
reflect the new value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClientValue$sendUpdate(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The new value for the crosstalk variable. Must be
serializable as JSON using `jsonlite`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClientValue$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
