% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-oo-api.R
\name{desc_add_orcid}
\alias{desc_add_orcid}
\title{Add an ORCID to one or more authors in Authors@R, in DESCRIPTION}
\usage{
desc_add_orcid(
  orcid,
  given = NULL,
  family = NULL,
  email = NULL,
  comment = NULL,
  role = NULL,
  file = ".",
  normalize = FALSE
)
}
\arguments{
\item{orcid}{orcid to add.}

\item{given}{Given name to filter on. Regular expression.}

\item{family}{Family name to filter on. Regular expression.}

\item{email}{Email address to filter on. Regular expression.}

\item{comment}{Comment field to filter on. Regular expression.}

\item{role}{Role field to filter on.}

\item{file}{DESCRIPTION file to use. By default the DESCRIPTION
file of the current package (i.e. the package the working directory
is part of) is used.}

\item{normalize}{Whether to "normalize" (reorder and reformat) the fields when writing back
the result. See \code{\link[=desc_normalize]{desc_normalize()}}.}
}
\description{
The author(s) can be specified by a combination of the \code{given},
\code{family}, \code{email}, \code{comment} and \code{role} fields.
If multiple filters are specified, then all must match
to identify the author(s).
}
\seealso{
Other Authors@R: 
\code{\link{desc_add_author_gh}()},
\code{\link{desc_add_author}()},
\code{\link{desc_add_me}()},
\code{\link{desc_add_role}()},
\code{\link{desc_change_maintainer}()},
\code{\link{desc_coerce_authors_at_r}()},
\code{\link{desc_del_author}()},
\code{\link{desc_del_role}()},
\code{\link{desc_get_authors}()},
\code{\link{desc_get_author}()},
\code{\link{desc_get_maintainer}()},
\code{\link{desc_set_authors}()}
}
\concept{Authors@R}
