#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 4;

use CGI;
use CGIParameters qw( read_cgi_parameters );

my $cgi = CGI->new( { sessid => '0123456789abcdef',
                      method => 'direct',
                      smiles => 'c1ccccc1',
                      value  => '' } );
my( $param, $changed ) =
    read_cgi_parameters( $cgi,
                         { sessid => { re => '[0-9a-f]+',
                                       errmsg => 'session %s does not exist' },
                           method => { re => 'direct|babel|immediate',
                                       default => 'babel' },
                           smiles => { re => '[^\s\;\'"]+' },
                           value  => { re => '.*',
                                       default => '' } } );

ok( $param->{sessid} eq '0123456789abcdef' );
ok( $param->{method} eq 'direct' );
ok( $param->{smiles} eq 'c1ccccc1' );
ok( $param->{value}  eq '' );
