# 2022-09-27 Triage Log

Overall a fairly quiet week in terms of new changes; the majority of the delta
this week was due to reverting
[#101620](https://github.com/rust-lang/rust/pull/101620), which was a
regression noted in last week's report.

Triage done by **@simulacrum**.
Revision range: [8fd6d03e22fba2930ad377b87299de6a37076074..d9297d22ad9edc2b56f0dd8734c1187a0c88be69](https://perf.rust-lang.org/?start=8fd6d03e22fba2930ad377b87299de6a37076074&end=d9297d22ad9edc2b56f0dd8734c1187a0c88be69&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 5.6% | [0.4%, 32.9%] | 32    |
| Regressions ❌ <br /> (secondary) | 7.4% | [0.7%, 25.3%] | 22    |
| Improvements ✅ <br /> (primary) | -4.0% | [-13.4%, -0.3%] | 135   |
| Improvements ✅ <br /> (secondary) | -4.3% | [-19.4%, -0.1%] | 123   |
| All ❌✅ (primary) | -2.2% | [-13.4%, 32.9%] | 167   |


2 Regressions, 7 Improvements, 3 Mixed; 3 of them in rollups
53 artifact comparisons made in total

#### Regressions

a fn pointer doesn't implement `Fn`/`FnMut`/`FnOnce` if its return type isn't sized [#100096](https://github.com/rust-lang/rust/pull/100096) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4ecfdfac51b159f68fce608792affb34a70e6f73&end=1de00d1ac5247a02184ef7ad044f6521ade7e0cc&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 23.0% | [21.3%, 25.2%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -    | -     | 0     |

Perf regression is being investigated by @compiler-errors. No positive fix yet
though; due to the reported regression
([#102289](https://github.com/rust-lang/rust/pull/102289)) we are thinking that
just reverting may be the better option. This is a soundness fix though so the
perf regression may be OK, but further investigation is warranted.


Require `#[const_trait]` on `Trait` for `impl const Trait` [#100982](https://github.com/rust-lang/rust/pull/100982) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=626b02a8f97a9e35a647aa18fcdb67cbcb3b09c8&end=7a8636c843bd24038fe1d1f69b4a8e4b0ea55d4e&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.4% | [0.4%, 0.5%] | 6     |
| Regressions ❌ <br /> (secondary) | 1.5% | [1.5%, 1.5%] | 1     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.4% | [0.4%, 0.5%] | 6     |

This regression was known prior to merging the PR, but the reviewer concluded
that the small wall-clock delta wasn't worth further investigation. Left a
comment asking for a better justification of the regression.

#### Improvements

use partition_point instead of binary_search when looking up source lines [#101999](https://github.com/rust-lang/rust/pull/101999) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7a8636c843bd24038fe1d1f69b4a8e4b0ea55d4e&end=3e50038a2d4029bd1484af75dbf144c4b0da6c74&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.3% | [-0.7%, -0.2%] | 62    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.6%, -0.2%] | 41    |
| All ❌✅ (primary) | -0.3% | [-0.7%, -0.2%] | 62    |


Rollup of 10 pull requests [#102150](https://github.com/rust-lang/rust/pull/102150) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=77e7e88567691068f5fba288618023368882d60b&end=bc4d574ff2ffcfe76db36116cc4f193384065985&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -0.3% | [-0.4%, -0.2%] | 4     |


Use internal iteration in `Iterator` comparison methods [#100845](https://github.com/rust-lang/rust/pull/100845) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e1c28e0c857280ce829beab16ef6082cd518db98&end=06968954f7e11454d49377629bb57d13253384b9&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -1.1% | [-1.1%, -1.1%] | 1     |


Move DepKindStruct from rustc_middle to rustc_query_system [#101710](https://github.com/rust-lang/rust/pull/101710) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f5193a9fcc73dc09e41a90c5a2c97fc9acc16032&end=ff40f2ec95923c4d45366e85bcff17d75df68d68&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.5% | [-0.9%, -0.2%] | 66    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 18    |
| All ❌✅ (primary) | -0.5% | [-0.9%, -0.2%] | 66    |


Rollup of 5 pull requests [#102297](https://github.com/rust-lang/rust/pull/102297) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fe217c28ffc6955f0927d8e8715d43d727debe5a&end=72f4923979979abb5d6b975353e9b3053d257e60&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.7% | [-0.7%, -0.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.5%, -1.2%] | 6     |
| All ❌✅ (primary) | -0.7% | [-0.7%, -0.7%] | 1     |


Fix lint scoping for let-else. [#102257](https://github.com/rust-lang/rust/pull/102257) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e1d7dec558d863fb76f98453088b36cb1a926d48&end=1d1f1426604b7d79138cdfbb31f82f7f44756fba&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.7% | [-0.7%, -0.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.6%, -1.2%] | 6     |
| All ❌✅ (primary) | -0.7% | [-0.7%, -0.7%] | 1     |


Improve code example for Option::unwrap_or_default [#102283](https://github.com/rust-lang/rust/pull/102283) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8b705839cd656d202e920efa8769cbe43a5ee269&end=f3a6fbf2f2e898ca4d788b3e686726fa9770c676&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.7% | [-0.7%, -0.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.6%, -1.2%] | 6     |
| All ❌✅ (primary) | -0.7% | [-0.7%, -0.7%] | 1     |


#### Mixed

Revert perf-regression 101620 [#102064](https://github.com/rust-lang/rust/pull/102064) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=199fe1d169b5aeeca0e527ded26542b7a05ebd79&end=bb5a01617589b5e3ece5a36435fc285bfd13c9a4&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 5.6% | [0.3%, 33.5%] | 33    |
| Regressions ❌ <br /> (secondary) | 1.1% | [0.3%, 1.5%] | 11    |
| Improvements ✅ <br /> (primary) | -3.7% | [-12.3%, -0.3%] | 129   |
| Improvements ✅ <br /> (secondary) | -4.1% | [-19.0%, -0.2%] | 121   |
| All ❌✅ (primary) | -1.8% | [-12.3%, 33.5%] | 162   |

This fixes a perf regression from last week and the overall trend is an improvement, so as expected.

Use function pointers instead of macro-unrolled loops in rustc_query_impl [#101785](https://github.com/rust-lang/rust/pull/101785) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ff40f2ec95923c4d45366e85bcff17d75df68d68&end=3288d3a305ad15cfcdcd9ef72404be6d2a2887b5&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.2% | [1.2%, 1.2%] | 2     |
| Improvements ✅ <br /> (primary) | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.5%, -0.6%] | 9     |
| All ❌✅ (primary) | -0.4% | [-0.4%, -0.4%] | 1     |

Overall mixed results and generally a slight improvement. The seemingly more
important goal of reducing bootstrap times isn't really achieved by this PR
though it may help future iteration on these functions by avoiding some LLVM sensitivity.

Rollup of 5 pull requests [#102324](https://github.com/rust-lang/rust/pull/102324) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1d1f1426604b7d79138cdfbb31f82f7f44756fba&end=8b705839cd656d202e920efa8769cbe43a5ee269&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | [0.7%, 0.7%] | 1     |
| Regressions ❌ <br /> (secondary) | 1.4% | [1.3%, 1.6%] | 6     |
| Improvements ✅ <br /> (primary) | -0.7% | [-0.9%, -0.6%] | 6     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -0.5% | [-0.9%, 0.7%] | 7     |

keccak, the primary regression, is within its suspected noise level bar.
