// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - DIGITEO - Pierre MARECHAL
// Copyright (C) 2009-2012 - DIGITEO - Allan CORNET
// Copyright (C) 2016 - Scilab Enterprises - Pierre-Aimé AGNEL
// Copyright (C) 2016 - Samuel GOUGEON
//
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.

// Generate a cleaner.sce script for the toolbox

function tbx_build_cleaner(name, path)
    // tbx_build_cleaner(name, path)   // deprecated (6.0)
    // tbx_build_cleaner(name)         // deprecated (6.0)
    // tbx_build_cleaner(path)         // 6.0
    // tbx_build_cleaner()             // 6.0  path = pwd()

    fname = "tbx_build_cleaner"
    rhs = argn(2);

    // CHECKING INPUT PARAMETERS
    // -------------------------
    if and(rhs <> [0 1 2]) then
        msg = _("%s: Wrong number of input arguments: %d to %d expected.\n")
        error(msprintf(msg, fname, 0, 1))
    end

    if rhs==2
        msg = "%s: %s(name, path) is obsolete. Please use %s(path) instead.\n"
        warning(msprintf(msg, fname, fname, fname))  // no translation

    elseif rhs==0
        path = pwd()
    else
        path = name
        if type(path) <> 10 then
            msg = _("%s: Argument #%d: Text(s) expected.\n")
            error(msprintf(msg, fname, rhs))
        end
        path = path(1)
        // May be
        //  * either the former tbx_build_cleaner(name) (until 5.5.2)
        //  * or the new        tbx_build_cleaner(path) (from 6.0.0)
        if grep(path,["/" "\"])==[] && ~isdir(path) then // only name was provided
            path = pwd()
        end
        if ~isdir(path) then
            msg = _("%s: The directory ''%s'' doesn''t exist or is not read accessible.\n")
            error(msprintf(msg, fname, path))
        end
    end

    // Build the cleaner file
    // ----------------------
    mprintf(gettext("Generating cleaner.sce...\n"))

    cleanertxt = [
    "// This file is released under the 3-clause BSD license. See COPYING-BSD."
    "// Generated by builder.sce: Please, do not edit this file"
    ""
    "oldmode = mode();"
    "oldlines = lines()(2);"
    "lines(0);"
    ""
    "function perform_clean()"
    "    root_tlbx = get_absolute_file_path(''cleaner.sce'');"
    ""
    "    if isfile(root_tlbx + ''/macros/cleanmacros.sce'') then"
    "        exec(root_tlbx+''/macros/cleanmacros.sce'');"
    "    else"
    "        if isdir(root_tlbx + ""/macros/"") then"
    "            deletefile(root_tlbx + ""/macros/lib"");"
    "            binfiles = findfiles(root_tlbx + ""/macros/"", ""*.bin"");"
    "            if ~isempty(binfiles) then"
    "                deletefile(root_tlbx + ""/macros/"" + binfiles);"
    "            end"
    "        end"
    "    end"
    ""
    "    if isfile(root_tlbx + ""/src/cleaner_src.sce"") then"
    "        exec(root_tlbx + ""/src/cleaner_src.sce"");"
    "        mdelete(root_tlbx + ""/src/cleaner_src.sce"");"
    "     end"
    ""
    "    if isfile(root_tlbx + ""/sci_gateway/cleaner_gateway.sce"") then"
    "        exec(root_tlbx + ""/sci_gateway/cleaner_gateway.sce"");"
    "        mdelete(root_tlbx + ""/sci_gateway/cleaner_gateway.sce"");"
    "     end"
    ""
    "    if isfile(root_tlbx + ""/help/cleaner_help.sce"") then"
    "        exec(root_tlbx + ""/help/cleaner_help.sce"");"
    "    else"
    "        if isdir(root_tlbx + ""/jar/"") then"
    "            rmdir(root_tlbx + ""/jar/"", ""s"");"
    "        end"
    "    end"
    ""
    "    if isfile(root_tlbx + ""/loader.sce"") then"
    "        mdelete(root_tlbx + ""/loader.sce"");"
    "    end"
    ""
    "    if isfile(root_tlbx + ""/unloader.sce"") then"
    "        mdelete(root_tlbx + ""/unloader.sce"");"
    "    end"
    "endfunction"
    ""
    "try"
    "    perform_clean();"
    "catch"
    "    [errmsg, tmp, nline, func] = lasterror();"
    "    msg = ""%s: error on line #%d: """"%s""""\n"";"
    "    msg = msprintf(msg, func, nline, errmsg);"
    "    lines(oldlines);"
    "    mode(oldmode);"
    "    clear perform_clean oldlines oldmode tmp nline func errmsg;"
    "    error(msg);"
    "end"
    ""
    "lines(oldlines)"
    "mode(oldmode);"
    "clear perform_clean oldlines oldmode;"
    ]

    cleanerfile = pathconvert(path+"/cleaner.sce", %F);

    if ~mputl(cleanertxt, cleanerfile) then
        msg = _("%s: The file ""%s"" cannot been created, please check if you have write access on this file.\n")
        error(msprintf(msg, fname, cleanerfile))
    end

endfunction
