'\"
'\" Generated from file 'record\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Brett Schwarz <brett_schwarz@yahoo\&.com>
'\"
.TH "struct::record" n 1\&.2\&.2 tcllib "Tcl Data Structures"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
struct::record \- Define and create records (similar to 'C' structures)
.SH SYNOPSIS
package require \fBTcl  8\&.2\fR
.sp
package require \fBstruct::record  ?1\&.2\&.2?\fR
.sp
\fBrecord define\fR \fIrecordName\fR \fIrecordMembers\fR ?\fIinstanceName1 instanceName2 \&.\&.\&.\fR?
.sp
\fBrecord show\fR \fIrecord\fR
.sp
\fBrecord show\fR \fIinstances\fR \fIrecordName\fR
.sp
\fBrecord show\fR \fImembers\fR \fIrecordName\fR
.sp
\fBrecord show\fR \fIvalues\fR \fIinstanceName\fR
.sp
\fBrecord exists\fR \fIrecord\fR \fIrecordName\fR
.sp
\fBrecord exists\fR \fIinstance\fR \fIinstanceName\fR
.sp
\fBrecord delete\fR \fIrecord\fR \fIrecordName\fR
.sp
\fBrecord delete\fR \fIinstance\fR \fIinstanceName\fR
.sp
\fIinstanceName\fR \fBcget\fR -\fImember\fR
.sp
\fIinstanceName\fR \fBcget\fR -\fImember1\fR -\fImember2\fR
.sp
\fIinstanceName\fR \fBcget\fR
.sp
\fIinstanceName\fR \fBconfigure\fR
.sp
\fIinstanceName\fR
.sp
\fIinstanceName\fR \fBconfigure\fR -\fImember\fR \fIvalue\fR
.sp
\fIinstanceName\fR \fBconfigure\fR -\fImember1\fR \fIvalue1\fR -\fImember2\fR \fIvalue2\fR
.sp
\fIrecordName\fR \fIinstanceName\fR|\fB#auto\fR ?\fI-member1 value1 -member2 value2 \&.\&.\&.\fR?
.sp
\fIinstanceName\fR \fBcget\fR ?\fI-member1 -member2 \&.\&.\&.\fR?
.sp
\fIinstanceName\fR \fBconfigure\fR ?\fI-member1 value1 -member2 value2 \&.\&.\&.\fR?
.sp
.BE
.SH DESCRIPTION
The \fB::struct::record\fR package provides a mechanism to group
variables together as one data structure, similar to a \fIC\fR
structure\&. The members of a record can be variables or other
records\&. However, a record can not contain circular records,
i\&.e\&. records that contain the same record as a member\&.
.PP
This package was structured so that it is very similar to how
Tk objects work\&. Each record definition creates a record object that
encompasses that definition\&. Subsequently, that record object can
create instances of that record\&. These instances can then be
manipulated with the \fBcget\fR and \fBconfigure\fR methods\&.
.PP
The package only contains one top level command, but several
sub commands (see below)\&. It also obeys the namespace in which the
record was defined, hence the objects returned are fully qualified\&.
.TP
\fBrecord define\fR \fIrecordName\fR \fIrecordMembers\fR ?\fIinstanceName1 instanceName2 \&.\&.\&.\fR?
Defines a record\&. \fIrecordName\fR is the name of the record, and is
also used as an object command\&. This object command is used to create
instances of the record definition\&. The \fIrecordMembers\fR are the
members of the record that make up the record definition\&. These are
variables and other records\&. If optional \fIinstanceName\fR args are
specified, then an instance is generated after the definition is
created for each \fIinstanceName\fR\&.
.TP
\fBrecord show\fR \fIrecord\fR
Returns a list of records that have been defined\&.
.TP
\fBrecord show\fR \fIinstances\fR \fIrecordName\fR
Returns the instances that have been instantiated by
\fIrecordName\fR\&.
.TP
\fBrecord show\fR \fImembers\fR \fIrecordName\fR
Returns the members that are defined for record \fIrecordName\fR\&.
It returns the same format as how the records were defined\&.
.TP
\fBrecord show\fR \fIvalues\fR \fIinstanceName\fR
Returns a list of values that are set for the instance
\fIinstanceName\fR\&. The output is a list of key/value pairs\&. If there
are nested records, then the values of the nested records will
itself be a list\&.
.TP
\fBrecord exists\fR \fIrecord\fR \fIrecordName\fR
Tests for the existence of a \fIrecord\fR with the
name \fIrecordName\fR\&.
.TP
\fBrecord exists\fR \fIinstance\fR \fIinstanceName\fR
Tests for the existence of a \fIinstance\fR with the
name \fIinstanceName\fR\&.
.TP
\fBrecord delete\fR \fIrecord\fR \fIrecordName\fR
Deletes \fIrecordName\fR, and all instances of \fIrecordName\fR\&.
It will return an error if the record does not exist\&.
.TP
\fBrecord delete\fR \fIinstance\fR \fIinstanceName\fR
Deletes \fIinstance\fR with the name of \fIinstanceName\fR\&. It will
return an error if the instance does not exist\&. Note that this
recursively deletes any nested instances as well\&.
.PP
.SH "RECORD MEMBERS"
Record members can either be variables, or other records, However, the
same record can not be nested witin itself (circular)\&. To define a
nested record, you need to specify the \fBrecord\fR keyword, along
the with name of the record, and the name of the instance of that
nested record (within the container)\&. For example, it would look like
this:
.PP
.CS


# this is the nested record
record define mynestedrecord {
    nest1
    nest2
}

# This is the main record
record define myrecord {
    mem1
    mem2
    {record mynestedrecord mem3}
}

.CE
You can also assign default or initial values to the members of a
record, by enclosing the member entry in braces:
.PP
.CS


record define myrecord {
    mem1
    {mem2 5}
}

.CE
All instances created from this record definition will initially have
\fB5\fR as the value for member \fImem2\fR\&. If no default is given,
then the value will be the empty string\&.
.SS "GETTING VALUES"
To get a value of a member, there are several ways to do this\&.
.TP
\fIinstanceName\fR \fBcget\fR -\fImember\fR
In this form the built-in \fBcget\fR instance method returns the
value of the specified \fImember\fR\&. Note the leading dash\&.
.sp
To reach a nested member use \fIdot notation\fR:
.CS


\fIinstanceName\fR \fBcget\fR -mem3\&.nest1

.CE
.TP
\fIinstanceName\fR \fBcget\fR -\fImember1\fR -\fImember2\fR
In this form the built-in \fBcget\fR instance method returns a list
containing the values of both specified members, in the order of specification\&.
.TP
\fIinstanceName\fR \fBcget\fR
.TP
\fIinstanceName\fR \fBconfigure\fR
.TP
\fIinstanceName\fR
These forms are all equivalent\&. They return a dictionary of all
members and the associated values\&.
.PP
.SS "SETTING VALUES"
To set a value of a member, there are several ways to do this\&.
.TP
\fIinstanceName\fR \fBconfigure\fR -\fImember\fR \fIvalue\fR
In this form the built-in \fBconfigure\fR instance method sets the
specified \fImember\fR to the given \fIvalue\fR\&. Note the leading
dash\&.
.sp
To reach a nested member use \fIdot notation\fR:
.CS


\fIinstanceName\fR \fBconfigure\fR -mem3\&.nest1 value

.CE
.TP
\fIinstanceName\fR \fBconfigure\fR -\fImember1\fR \fIvalue1\fR -\fImember2\fR \fIvalue2\fR
In this form the built-in \fBconfigure\fR instance method sets all
specified members to the associated values\&.
.PP
.SS "ALIAS ACCESS"
In the original implementation, access was done by using dot notation
similar to how \fIC\fR structures are accessed\&. However, there was a
concensus to make the interface more Tcl like, which made sense\&.
However, the original alias access still exists\&. It might prove to be
helpful to some\&.
.PP
Basically, for every member of every instance, an alias is
created\&. This alias is used to get and set values for that member\&.
An example will illustrate the point, using the above defined records:
.PP
.CS


% # Create an instance first
% myrecord inst1
::inst1

% # To get a member of an instance, just use the alias\&. It behaves
% # like a Tcl command:
% inst1\&.mem1

% # To set a member via the alias, just include a value\&. And optionally
% # the equal sign - syntactic sugar\&.
% inst1\&.mem1 = 5
5

% inst1\&.mem1
5

% # For nested records, just continue with the dot notation\&.
% # note, no equal sign\&.
% inst1\&.mem3\&.nest1 10
10

% inst1\&.mem3\&.nest1
10

% # just the instance by itself gives all member/values pairs for that
% # instance
% inst1
-mem1 5 -mem2 {} -mem3 {-nest1 10 -nest2 {}}

% # and to get all members within the nested record
% inst1\&.mem3
-nest1 10 -nest2 {}


.CE
.SH "RECORD COMMAND"
The following subcommands and corresponding arguments are available to
any record command:
.TP
\fIrecordName\fR \fIinstanceName\fR|\fB#auto\fR ?\fI-member1 value1 -member2 value2 \&.\&.\&.\fR?
Using the \fIrecordName\fR object command that was created from the
record definition, instances of the record definition can be
created\&.
Once an instance is created, it inherits the members of the record
definition, very similar to how objects work\&.
During instance generation, an object command for the instance is
created as well, using \fIinstanceName\fR\&.
.sp
This object command is used to access the data members of the
instance\&.
During the instantiation, while values for that instance may be given,
when done, \fIall\fR values must be given, and be given as
key/value pairs, like for method \fBconfigure\fR\&. Nested records
have to be in list format\&.
.sp
Optionally, \fB#auto\fR can be used in place of
\fIinstanceName\fR\&. When \fB#auto\fR is used, the instance name will
be automatically generated, and of the form
\fBrecordName\fBN\fR\fR, where \fBN\fR is a unique integer (starting
at 0) that is generated\&.
.PP
.PP
.SH "INSTANCE COMMAND"
The following subcommands and corresponding arguments are available to
any record instance command:
.TP
\fIinstanceName\fR \fBcget\fR ?\fI-member1 -member2 \&.\&.\&.\fR?
Each instance has the method \fBcget\fR\&. This is very similar to
how Tk widget's \fBcget\fR command works\&. It queries the values of
the members for that particular instance\&. If no arguments are given,
then a dictionary is returned\&.
.TP
\fIinstanceName\fR \fBconfigure\fR ?\fI-member1 value1 -member2 value2 \&.\&.\&.\fR?
Each instance has the method \fBconfigure\fR\&. This is very similar
to how Tk widget's \fBconfigure\fR command works\&. It sets the
values of the particular members for that particular instance\&. If no
arguments are given, then a dictionary list is returned\&.
.PP
.SH EXAMPLES
Two examples are provided to give a good illustration on how to use
this package\&.
.SS "EXAMPLE 1 - CONTACT INFORMATION"
Probably the most obvious example would be to hold contact
information, such as addresses, phone numbers, comments, etc\&. Since a
person can have multiple phone numbers, multiple email addresses, etc,
we will use nested records to define these\&. So, the first thing we do
is define the nested records:
.PP
.CS



##
##  This is an interactive example, to see what is returned by
##  each command as well\&.
##

% namespace import ::struct::record::*

% # define a nested record\&. Notice that country has default 'USA'\&.
% record define locations {
    street
    street2
    city
    state
    zipcode
    {country USA}
    phone
}
::locations
% # Define the main record\&. Notice that it uses the location record twice\&.
% record define contacts {
    first
    middle
    last
    {record locations home}
    {record locations work}
}
::contacts
% # Create an instance for the contacts record\&.
% contacts cont1
::cont1
% # Display some introspection values
% record show records
::contacts ::locations
% #
% record show values cont1
-first {} -middle {} -last {} -home {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}} -work {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}}
% #
% record show instances contacts
::cont1
% #
% cont1 config
-first {} -middle {} -last {} -home {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}} -work {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}}
% #
% cont1 cget
-first {} -middle {} -last {} -home {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}} -work {-street {} -street2 {} -city {} -state {} -zipcode {} -country USA -phone {}}
% # copy one record to another record
% record define contacts2 [record show members contacts]
::contacts2
% record show members contacts2
first middle last {record locations home} {record locations work}
% record show members contacts
first middle last {record locations home} {record locations work}
%

.CE
.SS "EXAMPLE 2 - LINKED LIST"
This next example just illustrates a simple linked list
.PP
.CS


% # define a very simple record for linked list
% record define linkedlist {
    value
    next
}
::linkedlist
% linkedlist lstart
::lstart
% lstart config -value 1 -next [linkedlist #auto]
% [lstart cget -next] config -value 2 -next [linkedlist #auto]
% [[lstart cget -next] cget -next] config -value 3 -next "end"
% set next lstart
lstart
% while 1 {
    lappend values [$next cget -value]
    set next [$next cget -next]
    if {[string match "end" $next]} break
}
% puts "$values"
1 2 3
% # cleanup linked list
% # We could just use delete record linkedlist also
% foreach I [record show instances linkedlist] {
    record delete instance $I
}
% record show instances linkedlist
%

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIstruct :: record\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
data structures, record, struct
.SH CATEGORY
Data structures
.SH COPYRIGHT
.nf
Copyright (c) 2002, Brett Schwarz <brett_schwarz@yahoo\&.com>

.fi
