# Метаданные путей

При определении пути можно указывать метаданные в поле `meta`:

``` js
const router = new VueRouter({
  routes: [
    {
      path: '/foo',
      component: Foo,
      children: [
        {
          path: 'bar',
          component: Bar,
          // метаданные
          meta: { requiresAuth: true }
        }
      ]
    }
  ]
})
```

Как получить к нему доступ?

Прежде всего, каждый объект пути в конфигурации `routes` называется **записью пути**. Записи путей могут быть вложенными. Поэтому, при совпадении пути, потенциально могут быть активированы несколько записей путей.

Например, для конфигурации выше, URL `/foo/bar` совпадёт как с родительской, так и с дочерней записями путей.

Все совпавшие записи путей оказываются доступны через объект `$route` (а также через объекты пути в сторожевых хуках), в виде массива `$route.matched`. Таким образом, для проверки метаданных в записях путей нам понадобится обойти `$route.matched` в цикле.

В качестве примера можно привести проверку метаданных в глобальном сторожевом хуке:

``` js
router.beforeEach((to, from, next) => {
  if (to.matched.some(record => record.meta.requiresAuth)) {
    // этот путь требует авторизации, проверяем залогинен ли
    // пользователь, и если нет, перенаправляем на страницу логина
    if (!auth.loggedIn()) {
      next({
        path: '/login',
        query: { redirect: to.fullPath }
      })
    } else {
      next()
    }
  } else {
    next() // всегда так или иначе нужно вызвать next()!
  }
})
```
