# Начало работы

::: tip Примечание
Мы будем использовать синтаксис [ES2015](https://github.com/lukehoban/es6features) в примерах кода в этом руководстве.

Кроме того, все примеры будут использовать полную сборку Vue, чтобы позволить компиляцию шаблонов на лету. Подробнее о различиях сборок читайте [здесь](https://ru.vuejs.org/v2/guide/installation.html#Runtime-Компилятор-vs-Runtime-only).
:::

Создавать одностраничные приложения (SPA) используя Vue + Vue Router очень просто. С помощью Vue.js, мы уже компонуем своё приложение из компонентов. Добавляя Vue Router, мы просто сопоставляем наши компоненты с маршрутами и объясняем Vue Router где их отображать. Вот простой пример:

## HTML

```html
<script src="https://unpkg.com/vue/dist/vue.js"></script>
<script src="https://unpkg.com/vue-router/dist/vue-router.js"></script>

<div id="app">
  <h1>Первое приложение!</h1>
  <p>
    <!-- используем компонент router-link для навигации -->
    <!-- входной параметр `to` определяет URL для перехода -->
    <!-- `<router-link>` по умолчанию отображается тегом `<a>` -->
    <router-link to="/foo">Перейти к Foo</router-link>
    <router-link to="/bar">Перейти к Bar</router-link>
  </p>
  <!-- отображаем тут компонент, для которого совпадает маршрут -->
  <router-view></router-view>
</div>
```

## JavaScript

```js
// 0. Если используем модульную систему (например через vue-cli),
// импортируем Vue и VueRouter и затем вызываем `Vue.use(VueRouter)`.

// 1. Определяем компоненты для маршрутов.
// Они могут быть импортированы из других файлов
const Foo = { template: '<div>foo</div>' }
const Bar = { template: '<div>bar</div>' }

// 2. Определяем несколько маршрутов
// Каждый маршрут должен указывать на компонент.
// "Компонентом" может быть как конструктор компонента, созданный
// через `Vue.extend()`, так и просто объект с опциями компонента.
// Мы поговорим о вложенных маршрутах позднее.
const routes = [
  { path: '/foo', component: Foo },
  { path: '/bar', component: Bar }
]

// 3. Создаём экземпляр маршрутизатора и передаём маршруты в опции `routes`
// Вы можете передавать и дополнительные опции, но пока не будем усложнять.
const router = new VueRouter({
  routes // сокращённая запись для `routes: routes`
})

// 4. Создаём и монтируем корневой экземпляр приложения.
// Убедитесь, что передали экземпляр маршрутизатора в опции
// `router`, чтобы позволить приложению знать о его наличии.
const app = new Vue({
  router
}).$mount('#app')

// Всё, приложение работает! ;)
```

Внедряя маршрутизатор, мы сможем получить к нему доступ через `this.$router`, а также к текущему маршруту через `this.$route` внутри любого компонента:

```js
// Home.vue
export default {
  computed: {
    username() {
      // Мы скоро разберём что такое `params`
      return this.$route.params.username
    }
  },
  methods: {
    goBack() {
      window.history.length > 1 ? this.$router.go(-1) : this.$router.push('/')
    }
  }
}
```

В документации мы будем часто использовать экземпляр `router` (маршрутизатора). Имейте ввиду, что `this.$router` в точности то же самое, что и `router`. Причина, почему используем `this.$router` заключается в том, что мы не хотим импортировать маршрутизатор в каждом компоненте, в котором потребуется управлять маршрутизацией.

Вы также можете увидеть этот пример вживую [здесь](https://jsfiddle.net/yyx990803/xgrjzsup/).

Обратите внимание, что `<router-link>` автоматически получает класс `.router-link-active` при совпадении маршрута. Подробнее об этом можно узнать в [справочнике API](../api/#router-link).
