/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ArrayInitializationMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.PartialEvaluator;

public class ArrayInitializationReplacer
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InstructionVisitor {
    private final ValueFactory valueFactory = new ParticularValueFactory(new BasicValueFactory());
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.valueFactory, new BasicInvocationUnit(this.valueFactory), true);
    private final ArrayInitializationMatcher arrayInitializationMatcher = new ArrayInitializationMatcher(this.partialEvaluator);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private ConstantPoolEditor constantPoolEditor;
    private int lastInstructionOffset;
    private int lastInstructionStackPushCount;
    private int arrayInitializationStart;
    private int arrayInitializationEnd;

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
        programClass.methodsAccept(new AllAttributeVisitor(new ArrayInitializationFilter(this)));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        this.lastInstructionOffset = -1;
        this.lastInstructionStackPushCount = -1;
        this.arrayInitializationStart = -1;
        this.arrayInitializationEnd = -1;
        codeAttribute.instructionsAccept(clazz, method, this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        if (instruction.opcode == -68 && this.lastInstructionStackPushCount == 1 && this.arrayInitializationMatcher.matchesArrayInitialization(clazz, method, codeAttribute, n, (SimpleInstruction)instruction)) {
            Object object = this.arrayInitializationMatcher.array();
            int n2 = this.constantPoolEditor.addPrimitiveArrayConstant(object);
            this.codeAttributeEditor.replaceInstruction(this.lastInstructionOffset, new ConstantInstruction(18, n2));
            this.codeAttributeEditor.deleteInstruction(n);
            this.arrayInitializationStart = this.arrayInitializationMatcher.arrayInitializationStart();
            this.arrayInitializationEnd = this.arrayInitializationMatcher.arrayInitializationEnd();
        }
        if (this.arrayInitializationEnd != -1 && n >= this.arrayInitializationStart && n <= this.arrayInitializationEnd) {
            this.codeAttributeEditor.deleteInstruction(n);
        }
        this.lastInstructionOffset = n;
        this.lastInstructionStackPushCount = instruction.stackPushCount(clazz);
    }

    private static class ArrayInitializationFilter
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private final AttributeVisitor acceptedVisitor;

        public ArrayInitializationFilter(AttributeVisitor attributeVisitor) {
            this.acceptedVisitor = attributeVisitor;
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            Instruction instruction;
            boolean bl = false;
            for (int i = 0; i < codeAttribute.u4codeLength; i += instruction.length(i)) {
                instruction = InstructionFactory.create(codeAttribute.code, i);
                if (instruction.opcode != -68) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.acceptedVisitor.visitCodeAttribute(clazz, method, codeAttribute);
            }
        }
    }
}

