/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;

public class WrapperClassMarker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final Constant[] INITIALIZER_CONSTANTS = new Constant[]{new FieldrefConstant(0x40000003, 0x40000004, null, null)};
    private final Instruction[] INITIALIZER_INSTRUCTIONS = new Instruction[]{new VariableInstruction(42, 0), new VariableInstruction(43, 1), new ConstantInstruction(-75, 0), new VariableInstruction(42, 0), new ConstantInstruction(-73, 0x40000000), new SimpleInstruction(-79)};
    private final InstructionSequenceMatcher INITIALIZER_MATCHER = new InstructionSequenceMatcher(this.INITIALIZER_CONSTANTS, this.INITIALIZER_INSTRUCTIONS);
    private Clazz wrappedClass;
    private int wrapCounter;

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.subClasses == null || programClass.subClasses.length == 0) {
            this.wrappedClass = null;
            this.wrapCounter = 0;
            programClass.fieldsAccept(this);
            if (this.wrapCounter == 1) {
                this.wrapCounter = 0;
                programClass.methodsAccept(this);
                if (this.wrapCounter == 1) {
                    WrapperClassMarker.setWrappedClass(programClass, this.wrappedClass);
                }
            }
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if ((programField.getAccessFlags() & 8) == 0 && ClassUtil.isInternalClassType(programField.getDescriptor(programClass)) && !ClassUtil.isInternalArrayType(programField.getDescriptor(programClass))) {
            this.wrappedClass = programField.referencedClass;
            this.wrapCounter = this.wrappedClass != null ? ++this.wrapCounter : Integer.MIN_VALUE;
        } else {
            this.wrapCounter = Integer.MIN_VALUE;
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (ClassUtil.isInitializer(programMethod.getName(programClass))) {
            if (ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass)) == 1) {
                Value value = StoringInvocationUnit.getMethodParameterValue(programMethod, 1);
                if (value != null && value.computationalType() == 5 && value.referenceValue().isNotNull() == 1) {
                    programMethod.attributesAccept(programClass, this);
                } else {
                    this.wrapCounter = Integer.MIN_VALUE;
                }
            } else {
                this.wrapCounter = Integer.MIN_VALUE;
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (codeAttribute.u4codeLength == 10) {
            this.INITIALIZER_MATCHER.reset();
            codeAttribute.instructionsAccept(clazz, method, this.INITIALIZER_MATCHER);
            if (this.INITIALIZER_MATCHER.isMatching()) {
                String string = clazz.getName();
                String string2 = clazz.getClassName(this.INITIALIZER_MATCHER.matchedConstantIndex(0x40000003));
                this.wrapCounter = string2.equals(string) ? ++this.wrapCounter : Integer.MIN_VALUE;
            } else {
                this.wrapCounter = Integer.MIN_VALUE;
            }
        } else {
            this.wrapCounter = Integer.MIN_VALUE;
        }
    }

    private static void setWrappedClass(Clazz clazz, Clazz clazz2) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setWrappedClass(clazz2);
    }

    public static Clazz getWrappedClass(Clazz clazz) {
        return ClassOptimizationInfo.getClassOptimizationInfo(clazz).getWrappedClass();
    }
}

