/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Copyright (C) 2006 Carlos Garnacho.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Authors: Carlos Garnacho Parro <carlosg@gnome.org>.
 */

#ifndef __GST_SERVICE_ROLE_H__
#define __GST_SERVICE_ROLE_H__

#include <glib.h>
#include <oobs/oobs.h>

G_BEGIN_DECLS

typedef enum _GstServiceRole GstServiceRole;

enum _GstServiceRole {
	GST_ROLE_WEB_SERVER,
	GST_ROLE_COMMAND_SCHEDULER,
	GST_ROLE_PRINTER_SERVICE,
	GST_ROLE_MTA,
	GST_ROLE_MTA_AUTH,
	GST_ROLE_MAIL_FETCHER,
	GST_ROLE_DISPLAY_MANAGER,
	GST_ROLE_DATABASE_SERVER,
	GST_ROLE_FILE_SERVER_SMB,
	GST_ROLE_FILE_SERVER_NFS,
	GST_ROLE_FILE_SERVER_FTP,
	GST_ROLE_FILE_SERVER_TFTP,
	GST_ROLE_NTP_SERVER,
	GST_ROLE_ANTIVIRUS,
	GST_ROLE_FIREWALL_MANAGEMENT,
	GST_ROLE_DICTIONARY_SERVER,
	GST_ROLE_SPEECH_SYNTHESIS,
	GST_ROLE_SYSTEM_LOGGER,
	GST_ROLE_REMOTE_BACKUP,
	GST_ROLE_SPAM_FILTER,
	GST_ROLE_SECURE_SHELL_SERVER,
	GST_ROLE_APPLICATION_SERVER,
	GST_ROLE_AUTOMATED_CRASH_REPORTS_MANAGEMENT,
	GST_ROLE_DBUS,
	GST_ROLE_SYSTEM_CONFIGURATION_MANAGEMENT,
	GST_ROLE_SCHOOL_MANAGEMENT_PLATFORM,
	GST_ROLE_SECURITY_AUDITING,
	GST_ROLE_WEB_CALENDAR_SERVER,
	GST_ROLE_OEM_CONFIGURATION_MANAGEMENT,
	GST_ROLE_TERMINAL_MULTIPLEXOR,
	GST_ROLE_QUOTA_MANAGEMENT,
	GST_ROLE_PACKAGE_INDEX_MONITORING,
	GST_ROLE_NETWORK,
	GST_ROLE_DYNAMIC_DNS_SERVICE,
	GST_ROLE_DHCP_SERVER,
	GST_ROLE_DNS,
	GST_ROLE_PROXY_CACHE,
	GST_ROLE_LDAP_SERVER,
	GST_ROLE_MAILING_LISTS_MANAGER,
	GST_ROLE_RENDEZVOUS,
	GST_ROLE_NSS,
	GST_ROLE_VPN_SERVER,
	GST_ROLE_ROUTER_ADVERTISEMENT_SERVER,
	GST_ROLE_IPSEC_KEY_EXCHANGE_SERVER,
	GST_ROLE_DISK_SERVER,
	GST_ROLE_DISK_CLIENT,
	GST_ROLE_ROUTE_SERVER,
	GST_ROLE_RPC_MAPPER,
	GST_ROLE_SNMP_SERVER,
	GST_ROLE_LTSP_CLIENT,
	GST_ROLE_AUDIO_MANAGEMENT,
	GST_ROLE_AUTOMOUNTER,
	GST_ROLE_INFRARED_MANAGEMENT,
	GST_ROLE_BRAILLE_DISPLAY_MANAGEMENT,
	GST_ROLE_BLUETOOTH_MANAGEMENT,
	GST_ROLE_HDD_MANAGEMENT,
	GST_ROLE_HOTKEYS_MANAGEMENT,
	GST_ROLE_POWER_MANAGEMENT,
	GST_ROLE_LVM_MANAGEMENT,
	GST_ROLE_CLUSTER_MANAGEMENT,
	GST_ROLE_FAX_MANAGEMENT,
	GST_ROLE_RAID_MANAGEMENT,
	GST_ROLE_GRAPHIC_TABLETS_MANAGEMENT,
	GST_ROLE_CPUFREQ_MANAGEMENT,
	GST_ROLE_EAGLE_USB_MODEMS_MANAGEMENT,
	GST_ROLE_SERIAL_PORTS_MANAGEMENT,
	GST_ROLE_ISDN_MANAGEMENT,
	GST_ROLE_TELSTRA_BIGPOND_NETWORK_CLIENT,
	GST_ROLE_HARDWARE_MONITORING,
	GST_ROLE_SYSTEM_MONITORING,
	GST_ROLE_VIRTUAL_MACHINE_MANAGEMENT,
	GST_ROLE_NONE
};

GstServiceRole   gst_service_get_role (OobsService *service);


G_END_DECLS

#endif /* __GST_SERVICE_ROLE_H__ */
