/*
 * get_device_id.c - Example program using libblockdeviceid
 *
 * Usage: ./get_device_id /dev/mmcblk0
 *
 * This program retrieves the hardware-innate identifier for a block device,
 * such as the CID for MMC devices or the controller serial for NVMe devices.
 */

#include <stdio.h>
#include <stdlib.h>
#include <block_device_id.h>

int main(int argc, char *argv[])
{
    char id[256];
    int ret;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s <block-device-path>\n", argv[0]);
        fprintf(stderr, "Example: %s /dev/mmcblk0\n", argv[0]);
        return EXIT_FAILURE;
    }

    printf("libblockdeviceid version: %s\n", bdi_version());

    ret = bdi_get_id(argv[1], id, sizeof(id));
    if (ret < 0) {
        fprintf(stderr, "Error: failed to get device ID for %s (error %d)\n",
                argv[1], ret);
        return EXIT_FAILURE;
    }

    printf("Device: %s\n", argv[1]);
    printf("ID: %s\n", id);

    return EXIT_SUCCESS;
}
