// CLI argument definitions for block-device-id.
//
// This file is included by both src/bin/main.rs and build.rs to ensure
// the man page stays in sync with the CLI.

/// Retrieve the innate unique identifier for a block device
///
/// Outputs the hardware-innate identifier, suitable for use in scripts
/// or cryptographic key derivation.
#[derive(clap::Parser)]
#[command(name = "block-device-id")]
#[command(version)]
pub struct Args {
    /// Path to a block device or symlink (e.g., /dev/nvme0n1, /dev/disk/by-label/rootfs)
    pub device: std::path::PathBuf,
}
