import fourletterphat
import sys

def fail(message):
    print("One or more tests failed...")
    print("Error: {}".format(message))
    sys.exit(1)

def assert_raises(action, expect, message):
    try:
        action()
    except expect as e:
        return

    fail(message)

def assert_not_raises(action, expect, message):
    try:
        action()
    except expect as e:
        print(e)
        fail(message)

def assert_has_method(module, method):
    assert hasattr(module, method), "Missing method: {}".format(method)

fourletterphat.setup()

assert_has_method(fourletterphat, "set_blink")
assert_has_method(fourletterphat, "set_brightness")
assert_has_method(fourletterphat, "set_digit_raw")
assert_has_method(fourletterphat, "set_decimal")
assert_has_method(fourletterphat, "set_digit")
assert_has_method(fourletterphat, "print_str")
assert_has_method(fourletterphat, "print_number_str")
assert_has_method(fourletterphat, "print_float")
assert_has_method(fourletterphat, "print_hex")
assert_has_method(fourletterphat, "show")
assert_has_method(fourletterphat, "clear")
assert_has_method(fourletterphat, "glow")
assert_has_method(fourletterphat, "scroll_print")

assert_raises(lambda: fourletterphat.print_float(100.44, decimal_digits=2), ValueError, "Expected ValueError")
assert_not_raises(lambda: fourletterphat.print_float(100.4, decimal_digits=1), ValueError, "Unexpected ValueError")

