/*
 * Decompiled with CFR 0.152.
 */
package apParams;

import apParams.fb.FBApParams;
import apParams.fb.FBDimension;
import apParams.fb.FBInputTensor;
import apParams.fb.FBNetwork;
import apParams.fb.FBOutputTensor;
import com.google.flatbuffers.FlatBufferBuilder;
import dnnParams.xml.DnnParams;
import dnnParams.xml.InputTensorInfo;
import dnnParams.xml.Network;
import dnnParams.xml.TensorFormatType;
import dnnParams.xml.TensorInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ApParamsTool {
    public static final int MAX_NAME_LENGTH = 20;

    public static void createApParamsFlatBuffer(String inFileName, String outFileName) {
        try {
            File file = new File(inFileName);
            JAXBContext jaxbContext = JAXBContext.newInstance(DnnParams.class);
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException e2) {
                e2.printStackTrace();
            }
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                try {
                    Document document = db.parse(file);
                    DnnParams dnnParams = (DnnParams)jaxbUnmarshaller.unmarshal(document);
                    FlatBufferBuilder fbb = new FlatBufferBuilder(0);
                    int numNetworks = dnnParams.getNetworks().getNetwork().size();
                    System.out.println("Num of Networks = " + numNetworks);
                    System.out.println("================================");
                    int[] networkOffsets = new int[numNetworks];
                    int i = 0;
                    while (i < numNetworks) {
                        int[] dimArray;
                        Network network = dnnParams.getNetworks().getNetwork().get(i);
                        System.out.println("   ID: " + String.valueOf(network.getOrdinal()));
                        System.out.println("   Name: " + network.getName());
                        System.out.println("   Type: " + network.getType());
                        if (network.getOrdinal() >= numNetworks) {
                            System.out.println("Invalid network Enumeration");
                        }
                        int numInputTensors = network.getInputTensors().getInputTensor().size();
                        System.out.println("  Num of Input Tensors :" + numInputTensors);
                        int[] inputTensorsOffsets = new int[numInputTensors];
                        int j = 0;
                        while (j < numInputTensors) {
                            InputTensorInfo inputTensorInfo = network.getInputTensors().getInputTensor().get(j);
                            System.out.println("      Input Tensor" + j);
                            System.out.println("         Name = " + inputTensorInfo.getName());
                            System.out.println("         ID = " + inputTensorInfo.getOrdinal());
                            System.out.println("         Num of Dimensions  = " + inputTensorInfo.getNumOfDimensions());
                            int numDims = inputTensorInfo.getDimensions().getDimension().size();
                            if (numDims != inputTensorInfo.getNumOfDimensions()) {
                                System.out.println("Error: numOfDimensions mismatch in InputTensor " + j);
                            }
                            dimArray = new int[numDims];
                            int k = 0;
                            while (k < numDims) {
                                short ordinal = inputTensorInfo.getDimensions().getDimension().get(k).getOrdinal();
                                int size = inputTensorInfo.getDimensions().getDimension().get(k).getSize();
                                short serOrder = inputTensorInfo.getDimensions().getDimension().get(k).getSerializationOrder();
                                short padding = inputTensorInfo.getDimensions().getDimension().get(k).getPadding();
                                dimArray[k] = FBDimension.createFBDimension(fbb, ordinal, size, serOrder, padding);
                                if (serOrder != 0 && padding > 1) {
                                    System.out.println("Error: Padding caanot be > 1 for dimension with SerializationOrder > 0 ");
                                }
                                System.out.println("         Dimension" + k + " = (size/serOrder/padding)" + size + "/" + serOrder + "/" + padding);
                                ++k;
                            }
                            int dimArrayOffset = FBInputTensor.createDimensionsVector(fbb, dimArray);
                            String inputTensorName = inputTensorInfo.getName();
                            if (inputTensorName.length() > 20) {
                                inputTensorName = inputTensorName.substring(inputTensorName.length() - 20);
                            }
                            int format = 0;
                            if (inputTensorInfo.getFormat().value().equals(TensorFormatType.SIGNED.value())) {
                                format = 0;
                            } else if (inputTensorInfo.getFormat().value().equals(TensorFormatType.UNSIGNED.value())) {
                                format = 1;
                            } else {
                                System.out.println("Error : Invalid Input Tensor type");
                            }
                            int tensorsOffset = FBInputTensor.createFBInputTensor(fbb, inputTensorInfo.getOrdinal(), fbb.createString(inputTensorName), inputTensorInfo.getNumOfDimensions(), dimArrayOffset, inputTensorInfo.getShift(), inputTensorInfo.getScale(), format);
                            short inputOrdinal = inputTensorInfo.getOrdinal();
                            if (inputOrdinal >= numInputTensors) {
                                System.out.println("Error : Invalid Input Tensor Ordinal");
                            }
                            inputTensorsOffsets[inputOrdinal] = tensorsOffset;
                            ++j;
                        }
                        int numOutputTensors = network.getOutputTensors().getOutputTensor().size();
                        int[] outputTensorsOffsets = new int[numOutputTensors];
                        int j2 = 0;
                        while (j2 < numOutputTensors) {
                            TensorInfo outputTensorInfo = dnnParams.getNetworks().getNetwork().get(i).getOutputTensors().getOutputTensor().get(j2);
                            String outputTensorName = outputTensorInfo.getName();
                            if (outputTensorName.length() > 20) {
                                outputTensorName = outputTensorName.substring(outputTensorName.length() - 20);
                            }
                            System.out.println("      Output Tensor" + outputTensorInfo.getOrdinal());
                            System.out.println("         ID = " + outputTensorInfo.getOrdinal());
                            System.out.println("         Name = " + outputTensorName);
                            System.out.println("         bitsPerElement = " + outputTensorInfo.getBitsPerElement());
                            System.out.println("         shift = " + outputTensorInfo.getShift());
                            System.out.println("         scale = " + outputTensorInfo.getScale());
                            System.out.println("         Num of Dimensions  = " + outputTensorInfo.getNumOfDimensions());
                            int numDims = outputTensorInfo.getDimensions().getDimension().size();
                            if (numDims != outputTensorInfo.getNumOfDimensions()) {
                                System.out.println("Error: numOfDimensions mismatch in OutputTensor " + j2);
                            }
                            dimArray = new int[numDims];
                            int format = 0;
                            int k = 0;
                            while (k < numDims) {
                                short ordinal = outputTensorInfo.getDimensions().getDimension().get(k).getOrdinal();
                                int size = outputTensorInfo.getDimensions().getDimension().get(k).getSize();
                                short serOrder = outputTensorInfo.getDimensions().getDimension().get(k).getSerializationOrder();
                                short padding = outputTensorInfo.getDimensions().getDimension().get(k).getPadding();
                                dimArray[k] = FBDimension.createFBDimension(fbb, ordinal, size, serOrder, padding);
                                if (serOrder != 0 && padding != 0) {
                                    System.out.println("Error: Padding must be 0 for dimension with SerializationOrder > 0 ");
                                }
                                System.out.println("         Dimension" + ordinal + " = (size/serOrder/padding)" + size + "/" + serOrder + "/" + padding);
                                ++k;
                            }
                            int dimArrayOffset = FBOutputTensor.createDimensionsVector(fbb, dimArray);
                            if (outputTensorInfo.getFormat().value().equals(TensorFormatType.SIGNED.value())) {
                                format = 0;
                            } else if (outputTensorInfo.getFormat().value().equals(TensorFormatType.UNSIGNED.value())) {
                                format = 1;
                            } else {
                                System.out.println("Error : Invalid Output Tensor type");
                            }
                            int tensorsOffset = FBOutputTensor.createFBOutputTensor(fbb, outputTensorInfo.getOrdinal(), fbb.createString(outputTensorName), outputTensorInfo.getNumOfDimensions(), dimArrayOffset, outputTensorInfo.getBitsPerElement(), outputTensorInfo.getShift(), outputTensorInfo.getScale(), format);
                            short ordinal = outputTensorInfo.getOrdinal();
                            if (ordinal >= numOutputTensors) {
                                System.out.println("Error : Invalid Output Tensor Ordinal");
                            }
                            outputTensorsOffsets[ordinal] = tensorsOffset;
                            ++j2;
                        }
                        networkOffsets[network.getOrdinal().shortValue()] = FBNetwork.createFBNetwork(fbb, network.getOrdinal().shortValue(), fbb.createString(network.getName()), fbb.createString(network.getType()), FBNetwork.createInputTensorsVector(fbb, inputTensorsOffsets), FBNetwork.createOutputTensorsVector(fbb, outputTensorsOffsets));
                        ++i;
                    }
                    int networksOffset = FBApParams.createNetworksVector(fbb, networkOffsets);
                    fbb.finish(FBApParams.createFBApParams(fbb, networksOffset));
                    FileOutputStream stream = null;
                    try {
                        stream = new FileOutputStream(outFileName);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        try {
                            byte[] buffer = fbb.sizedByteArray();
                            stream.write(buffer);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException | SAXException e2) {
                    e2.printStackTrace();
                }
            }
            catch (ParserConfigurationException e2) {
                e2.printStackTrace();
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

