/*
 * Decompiled with CFR 0.152.
 */
package dnnParams.fb;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class FBL2Memory
extends Table {
    public static FBL2Memory getRootAsFBL2Memory(ByteBuffer _bb) {
        return FBL2Memory.getRootAsFBL2Memory(_bb, new FBL2Memory());
    }

    public static FBL2Memory getRootAsFBL2Memory(ByteBuffer _bb, FBL2Memory obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public FBL2Memory __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long totalSize() {
        int o = this.__offset(4);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public long reservedMemorySize() {
        int o = this.__offset(6);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public long networksRuntimeSize() {
        int o = this.__offset(8);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public long coefficientsSize() {
        int o = this.__offset(10);
        return o != 0 ? (long)this.bb.getInt(o + this.bb_pos) & 0xFFFFFFFFL : 0L;
    }

    public static int createFBL2Memory(FlatBufferBuilder builder, long totalSize, long reservedMemorySize, long networksRuntimeSize, long coefficientsSize) {
        builder.startObject(4);
        FBL2Memory.addCoefficientsSize(builder, coefficientsSize);
        FBL2Memory.addNetworksRuntimeSize(builder, networksRuntimeSize);
        FBL2Memory.addReservedMemorySize(builder, reservedMemorySize);
        FBL2Memory.addTotalSize(builder, totalSize);
        return FBL2Memory.endFBL2Memory(builder);
    }

    public static void startFBL2Memory(FlatBufferBuilder builder) {
        builder.startObject(4);
    }

    public static void addTotalSize(FlatBufferBuilder builder, long totalSize) {
        builder.addInt(0, (int)totalSize, 0);
    }

    public static void addReservedMemorySize(FlatBufferBuilder builder, long reservedMemorySize) {
        builder.addInt(1, (int)reservedMemorySize, 0);
    }

    public static void addNetworksRuntimeSize(FlatBufferBuilder builder, long networksRuntimeSize) {
        builder.addInt(2, (int)networksRuntimeSize, 0);
    }

    public static void addCoefficientsSize(FlatBufferBuilder builder, long coefficientsSize) {
        builder.addInt(3, (int)coefficientsSize, 0);
    }

    public static int endFBL2Memory(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

