/*
 * Decompiled with CFR 0.152.
 */
package packer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import packer.FileDesc;

public class DeployManifest {
    @SerializedName(value="PostConverter Version")
    private String postConverterVersion;
    @SerializedName(value="Converter Version")
    private String converterVersion;
    @SerializedName(value="Conversion Date Info")
    private String conversionDateInfo;
    @SerializedName(value="Network ID")
    private String networkId;
    @SerializedName(value="Major Version")
    private String majorVersion;
    @SerializedName(value="Minor Version")
    private String minorVersion;
    @SerializedName(value="DnnModelVersion")
    private String dnnModelVersion;
    @SerializedName(value="Target")
    private String target;
    @SerializedName(value="Date Info")
    private String dateInfo;
    @SerializedName(value="SdspA")
    private FileDesc sdspa;
    @SerializedName(value="SdspC")
    private FileDesc sdspc;
    @SerializedName(value="CfgBank1")
    private FileDesc cfgbank1;
    @SerializedName(value="CfgBank2")
    private FileDesc cfgbank2;
    @SerializedName(value="coef")
    private FileDesc coef;
    @SerializedName(value="apParams")
    private FileDesc apParams;
    @SerializedName(value="dnnParams")
    private FileDesc dnnParams;
    @SerializedName(value="NetworkInfo")
    private FileDesc networkInfo;

    public DeployManifest(String postConverterVersion, String converterVersion, String conversionDateInfo, String networkId, String majorVersion, String minorVersion, String dnnModelVersion, String target, String dateInfo, Map<String, FileDesc> fileDescMap) {
        this.postConverterVersion = postConverterVersion;
        this.converterVersion = converterVersion;
        this.conversionDateInfo = conversionDateInfo;
        this.networkId = networkId;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.dnnModelVersion = dnnModelVersion;
        this.target = target;
        this.dateInfo = dateInfo;
        for (Map.Entry<String, FileDesc> entry : fileDescMap.entrySet()) {
            String curKey = entry.getKey();
            FileDesc curFileDesc = entry.getValue();
            switch (curKey) {
                case "SdspA": {
                    this.sdspa = curFileDesc;
                }
                case "SdspC": {
                    this.sdspc = curFileDesc;
                }
                case "CfgBank1": {
                    this.cfgbank1 = curFileDesc;
                }
                case "CfgBank2": {
                    this.cfgbank2 = curFileDesc;
                }
                case "coef": {
                    this.coef = curFileDesc;
                }
                case "apParams": {
                    this.apParams = curFileDesc;
                }
                case "dnnParams": {
                    this.dnnParams = curFileDesc;
                }
                case "NetworkInfo": {
                    this.networkInfo = curFileDesc;
                }
            }
        }
    }

    public String getPostConverterVersion() {
        return this.postConverterVersion;
    }

    public String getConverterVersion() {
        return this.converterVersion;
    }

    public String getConversionDateInfo() {
        return this.conversionDateInfo;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getDnnModelVersion() {
        return this.dnnModelVersion;
    }

    public String getTarget() {
        return this.target;
    }

    public String getDateInfo() {
        return this.dateInfo;
    }

    public FileDesc getSdspa() {
        return this.sdspa;
    }

    public FileDesc getSdspc() {
        return this.sdspc;
    }

    public FileDesc getCfgbank1() {
        return this.cfgbank1;
    }

    public FileDesc getCfgbank2() {
        return this.cfgbank2;
    }

    public FileDesc getCoef() {
        return this.coef;
    }

    public FileDesc getApParams() {
        return this.apParams;
    }

    public FileDesc getDnnParams() {
        return this.dnnParams;
    }

    public FileDesc getNetworkInfo() {
        return this.networkInfo;
    }

    public void toJson(String filePath) throws RuntimeException {
        String jsonStr = DeployManifest.toJsonString(this);
        try (PrintWriter out = null;){
            try {
                out = new PrintWriter(filePath);
                out.println(jsonStr);
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static String toJsonString(DeployManifest deployManifest) throws RuntimeException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        String jsonStr = gson.toJson(deployManifest);
        return jsonStr;
    }
}

