/*
 * Decompiled with CFR 0.152.
 */
package packer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import packer.FileDesc;

public class Manifest {
    @SerializedName(value="Release Version")
    private String releaseVersion;
    @SerializedName(value="Description")
    private String description;
    @SerializedName(value="Target")
    private String target;
    @SerializedName(value="Network ID")
    private String networkId;
    @SerializedName(value="Network Name")
    private String networkName;
    @SerializedName(value="Date Info")
    private String dateInfo;
    @SerializedName(value="SdspA")
    private FileDesc sdspa;
    @SerializedName(value="SdspC")
    private FileDesc sdspc;
    @SerializedName(value="CfgBank1")
    private FileDesc cfgbank1;
    @SerializedName(value="CfgBank2")
    private FileDesc cfgbank2;
    @SerializedName(value="xmlSchema")
    private FileDesc xmlschema;
    @SerializedName(value="xml")
    private FileDesc xml;
    @SerializedName(value="coef")
    private FileDesc coef;
    @SerializedName(value="Versions")
    private FileDesc versions;

    public Manifest(String releaseVersion, String description, String target, String networkId, String networkName, String dateInfo, Map<String, FileDesc> fileDescMap) {
        this.releaseVersion = releaseVersion;
        this.description = description;
        this.target = target;
        this.networkId = networkId;
        this.networkName = networkName;
        this.dateInfo = dateInfo;
        for (Map.Entry<String, FileDesc> entry : fileDescMap.entrySet()) {
            String curKey = entry.getKey();
            FileDesc curFileDesc = entry.getValue();
            switch (curKey) {
                case "SdspA": {
                    this.sdspa = curFileDesc;
                }
                case "SdspC": {
                    this.sdspc = curFileDesc;
                }
                case "CfgBank1": {
                    this.cfgbank1 = curFileDesc;
                }
                case "CfgBank2": {
                    this.cfgbank2 = curFileDesc;
                }
                case "xmlSchema": {
                    this.xmlschema = curFileDesc;
                }
                case "xml": {
                    this.xml = curFileDesc;
                }
                case "coef": {
                    this.coef = curFileDesc;
                }
                case "Versions": {
                    this.versions = curFileDesc;
                }
            }
        }
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTarget() {
        return this.target;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public String getDateInfo() {
        return this.dateInfo;
    }

    public FileDesc getSdspa() {
        return this.sdspa;
    }

    public FileDesc getSdspc() {
        return this.sdspc;
    }

    public FileDesc getCfgbank1() {
        return this.cfgbank1;
    }

    public FileDesc getCfgbank2() {
        return this.cfgbank2;
    }

    public FileDesc getXmlschema() {
        return this.xmlschema;
    }

    public FileDesc getXml() {
        return this.xml;
    }

    public FileDesc getCoef() {
        return this.coef;
    }

    public FileDesc getVersions() {
        return this.versions;
    }

    public void toJson(String filePath) throws RuntimeException {
        String jsonStr = Manifest.toJsonString(this);
        try (PrintWriter out = null;){
            try {
                out = new PrintWriter(filePath);
                out.println(jsonStr);
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static String toJsonString(Manifest etdModel) throws RuntimeException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        String jsonStr = gson.toJson(etdModel);
        return jsonStr;
    }
}

