/*
 * Decompiled with CFR 0.152.
 */
package packer;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.xml.bind.DatatypeConverter;
import packer.DeployManifest;
import packer.FileDesc;
import packer.Manifest;

public class Packer {
    private static final String SDSP_A = "SdspA";
    private static final String SDSP_C = "SdspC";
    private static final String CFG_BANK1 = "CfgBank1";
    private static final String CFG_BANK2 = "CfgBank2";
    private static final String COEF = "coef";
    private static final String AP_PARAMS = "apParams";
    private static final String DNN_PARAMS = "dnnParams";
    private static final String NETWORK_INFO = "NetworkInfo";
    private static final String AP_PARAMS_LOAD_ADDRESS = "0x8000f000";
    private static final String DNN_PARAMS_LOAD_ADDRESS = "0x80010400";
    private static final String NW_INFO_LOAD_ADDRESS = "NA";
    private static final String DEPLOY_MANIFEST_NAME = "deployManifest.json";

    public static void generateDeployManifest(String manifestJson, String networkID, String majorVersion, String minorVersion) {
        try {
            System.out.println("filename: " + manifestJson);
            BufferedReader reader = Files.newBufferedReader(Paths.get(manifestJson, new String[0]));
            Manifest manifest = new Gson().fromJson((Reader)reader, Manifest.class);
            ((Reader)reader).close();
            LinkedHashMap<String, FileDesc> fileDescMap = new LinkedHashMap<String, FileDesc>();
            fileDescMap.put(SDSP_A, manifest.getSdspa());
            fileDescMap.put(SDSP_C, manifest.getSdspc());
            fileDescMap.put(CFG_BANK1, manifest.getCfgbank1());
            fileDescMap.put(CFG_BANK2, manifest.getCfgbank2());
            fileDescMap.put(COEF, manifest.getCoef());
            String key = AP_PARAMS;
            File apParamBin = new File("ap_params.bin");
            if (!apParamBin.exists()) {
                System.err.println("ap_params.bin :File doesnot exist!!");
                System.exit(-1);
            }
            long imageSize = apParamBin.length();
            String md5 = Packer.getMD5Checksum(apParamBin);
            FileDesc fileDesc = new FileDesc(AP_PARAMS_LOAD_ADDRESS, apParamBin.getName(), md5, manifest.getXml().version, imageSize);
            fileDescMap.put(key, fileDesc);
            key = DNN_PARAMS;
            File dnnParamBin = new File("dnn_params.bin");
            if (!dnnParamBin.exists()) {
                System.err.println("dnn_params.bin :File doesnot exist!!");
                System.exit(-1);
            }
            imageSize = dnnParamBin.length();
            md5 = Packer.getMD5Checksum(dnnParamBin);
            fileDesc = new FileDesc(DNN_PARAMS_LOAD_ADDRESS, dnnParamBin.getName(), md5, manifest.getXml().version, imageSize);
            fileDescMap.put(key, fileDesc);
            key = NETWORK_INFO;
            File networkInfo = new File("network_info.txt");
            if (!networkInfo.exists()) {
                System.err.println("network_info.txt :File doesnot exist!!");
                System.exit(-1);
            }
            imageSize = networkInfo.length();
            md5 = Packer.getMD5Checksum(networkInfo);
            fileDesc = new FileDesc(NW_INFO_LOAD_ADDRESS, networkInfo.getName(), md5, "2.4.0", imageSize);
            fileDescMap.put(key, fileDesc);
            String dateInfo = new Date().toString();
            Object dnnModelVersion = "";
            String converterVersion = "";
            String[] versions = manifest.getReleaseVersion().split("\\.", 3);
            int i = 0;
            while (i < versions.length) {
                try {
                    String str = versions[i];
                    if (str.length() > 2) {
                        str = str.substring(0, 1);
                    }
                    Integer n = Integer.parseInt(str);
                    converterVersion = converterVersion.concat(String.format("%02d", n));
                }
                catch (NumberFormatException e) {
                    System.out.println("Version is not a valid decimal");
                }
                ++i;
            }
            dnnModelVersion = converterVersion + networkID + majorVersion + minorVersion;
            System.out.println("dnnModelVersion = " + (String)dnnModelVersion);
            DeployManifest deployManifest = new DeployManifest("2.4.0", manifest.getReleaseVersion(), manifest.getDateInfo(), networkID, majorVersion, minorVersion, (String)dnnModelVersion, manifest.getTarget(), dateInfo, fileDescMap);
            deployManifest.toJson(DEPLOY_MANIFEST_NAME);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getMD5Checksum(File input) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream in = new FileInputStream(input);){
                int length;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] block = new byte[4096];
                while ((length = ((InputStream)in).read(block)) > 0) {
                    digest.update(block, 0, length);
                }
                byte[] checkSumBytes = digest.digest();
                return DatatypeConverter.printHexBinary(checkSumBytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

