/*
 * Decompiled with CFR 0.152.
 */
package xml2fb;

import apParams.ApParamsTool;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dnnParams.DnnParamsTool;
import dnnParams.xml.DnnParams;
import dnnParams.xml.InputTensorInfo;
import dnnParams.xml.Network;
import dnnParams.xml.TensorInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import xml2fb.InputFormatInfo;

public class Xml2Fb {
    public static final int MAX_NUM_OF_NETWORKS = 3;
    public static final String DNN_PARAM_BIN_NAME = "dnn_params.bin";
    public static final String AP_PARAM_BIN_NAME = "ap_params.bin";
    public static final String NW_INFO_TXT_NAME = "network_info.txt";

    public static void createNwInfoFile(String dnnParamFileName, String networkId, String networkType, boolean hasInputFormatInfo, String inputFormatFileName) {
        List<InputFormatInfo> inputFormatList = new ArrayList();
        float[] tmp_kscale = new float[3];
        float[] tmp_kshift = new float[3];
        float[] tmp_rggb_scale = new float[4];
        float[] tmp_rggb_shift = new float[4];
        float tmp_yscale = 0.0f;
        float tmp_yshift = 0.0f;
        int[] kscale = new int[3];
        int[] kshift = new int[3];
        int ygain = 0;
        int yadd = 0;
        int[] clip_min = new int[3];
        int[] clip_max = new int[3];
        int[] rggb_bitshift = new int[4];
        int[] rggb_add = new int[4];
        int[] rggb_clip_min = new int[4];
        int[] rggb_clip_max = new int[4];
        try {
            File file = new File(dnnParamFileName);
            JAXBContext jaxbContext = JAXBContext.newInstance(DnnParams.class);
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException e2) {
                e2.printStackTrace();
            }
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                try {
                    Document document = db.parse(file);
                    DnnParams dnnParams = (DnnParams)jaxbUnmarshaller.unmarshal(document);
                    File apParamBinFile = new File(AP_PARAM_BIN_NAME);
                    if (!apParamBinFile.exists()) {
                        System.err.println("ap_params.bin :File doesnot exist!!");
                        System.exit(-1);
                    }
                    int apParamSize = (int)apParamBinFile.length();
                    System.out.println("AP Param size:" + apParamSize);
                    int numOfNetworks = dnnParams.getNetworks().getNetwork().size();
                    int[] networkOffsets = new int[numOfNetworks];
                    int index = 0;
                    while (index < numOfNetworks) {
                        short ordinal = dnnParams.getNetworks().getNetwork().get(index).getOrdinal();
                        networkOffsets[ordinal] = index++;
                    }
                    if (hasInputFormatInfo) {
                        try {
                            System.out.println("filename: " + inputFormatFileName);
                            BufferedReader reader = Files.newBufferedReader(Paths.get(inputFormatFileName, new String[0]));
                            inputFormatList = (List)new Gson().fromJson((Reader)reader, new TypeToken<ArrayList<InputFormatInfo>>(){}.getType());
                            for (InputFormatInfo inputFormatInfo : inputFormatList) {
                                if (inputFormatInfo.getOrdinal() < 0 || inputFormatInfo.getOrdinal() > 2) {
                                    System.err.println("Invalid ordinal value! Valid range[0 ~ 2]");
                                    System.exit(-1);
                                }
                                if (inputFormatInfo.getFormat() == null) {
                                    System.err.println("Invalid Json! input format not specified!");
                                    System.exit(-1);
                                } else if (!(inputFormatInfo.getFormat().equals("RGB") || inputFormatInfo.getFormat().equals("BGR") || inputFormatInfo.getFormat().equals("Y") || inputFormatInfo.getFormat().equals("BayerRGB"))) {
                                    System.err.println("Invalid input format! " + inputFormatInfo.getFormat() + "Valid formats: RGB, BGR, Y, BayerRGB");
                                    System.exit(-1);
                                }
                                System.out.println(inputFormatInfo.toString());
                            }
                            ((Reader)reader).close();
                            int listSize = inputFormatList.size();
                            if (listSize > 3 || listSize != numOfNetworks) {
                                System.err.println(" Error InputNormalization array size(" + listSize + ") doesnot match num of networks(" + numOfNetworks + ")");
                                System.exit(-1);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        System.out.println("input_format json not specified. Setting default values to input format");
                        int i = 0;
                        while (i < numOfNetworks) {
                            Network network = dnnParams.getNetworks().getNetwork().get(networkOffsets[i]);
                            InputTensorInfo inputTensorInfo = network.getInputTensors().getInputTensor().get(0);
                            int channelSize = inputTensorInfo.getDimensions().getDimension().get(2).getSize();
                            String format = "";
                            if (channelSize == 1) {
                                format = "Y";
                            } else if (channelSize == 3) {
                                format = "RGB";
                            } else if (channelSize == 4) {
                                format = "BayerRGB";
                            }
                            InputFormatInfo inputFormatInfo = new InputFormatInfo(i, format);
                            inputFormatList.add(inputFormatInfo);
                            ++i;
                        }
                        System.out.println("Input format info:");
                        for (InputFormatInfo inputFormatInfo : inputFormatList) {
                            System.out.println(inputFormatInfo.toString());
                        }
                    }
                    try {
                        FileWriter txtWriter = new FileWriter(NW_INFO_TXT_NAME);
                        String postConverterVersion = "2.4.0";
                        String networkInfoVersion = "";
                        String[] splitArr = postConverterVersion.split("[.]");
                        int i = 0;
                        while (i < splitArr.length) {
                            String formattedString = String.format("%02d", Integer.parseInt(splitArr[i]));
                            networkInfoVersion = networkInfoVersion.concat(formattedString);
                            ++i;
                        }
                        System.out.println("networkInfoVersion:" + networkInfoVersion);
                        txtWriter.append("version=" + networkInfoVersion + "\r\n");
                        txtWriter.append("networkID=" + networkId + "\r\n");
                        txtWriter.append("networkType=" + networkType + "\r\n");
                        txtWriter.append("apParamSize=" + String.valueOf(apParamSize) + "\r\n");
                        txtWriter.append("networkNum=" + String.valueOf(numOfNetworks) + "\r\n");
                        i = 0;
                        while (i < numOfNetworks) {
                            Network network = dnnParams.getNetworks().getNetwork().get(networkOffsets[i]);
                            txtWriter.append("networkOrdinal=" + String.valueOf(i) + "\r\n");
                            int numInputTensors = network.getInputTensors().getInputTensor().size();
                            if (numInputTensors != 1) {
                                System.err.println("Invalid number of input Tensors. Only one input tensor is supported");
                                System.exit(-1);
                            }
                            InputTensorInfo inputTensorInfo = network.getInputTensors().getInputTensor().get(0);
                            int inputTensorWidth = 0;
                            int inputTensorHeight = 0;
                            int dimIndex = 0;
                            while (dimIndex < inputTensorInfo.getNumOfDimensions()) {
                                short serOrder = inputTensorInfo.getDimensions().getDimension().get(dimIndex).getSerializationOrder();
                                if (serOrder == 0) {
                                    inputTensorWidth = inputTensorInfo.getDimensions().getDimension().get(dimIndex).getSize();
                                } else if (serOrder == 1) {
                                    inputTensorHeight = inputTensorInfo.getDimensions().getDimension().get(dimIndex).getSize();
                                }
                                ++dimIndex;
                            }
                            txtWriter.append("inputTensorWidth=" + String.valueOf(inputTensorWidth) + "\r\n");
                            txtWriter.append("inputTensorHeight=" + String.valueOf(inputTensorHeight) + "\r\n");
                            InputFormatInfo inputFormatInfo = (InputFormatInfo)inputFormatList.get(i);
                            float input_tensor_scale = 1.0f;
                            float input_tensor_shift = 0.0f;
                            String inputTensorType = inputTensorInfo.getFormat().value();
                            if (inputTensorType.equals("signed")) {
                                input_tensor_shift = -128.0f;
                            }
                            if (inputFormatInfo.getFormat().contentEquals("RGB")) {
                                tmp_kscale[0] = input_tensor_scale;
                                tmp_kshift[0] = input_tensor_shift;
                                tmp_kscale[1] = input_tensor_scale;
                                tmp_kshift[1] = input_tensor_shift;
                                tmp_kscale[2] = input_tensor_scale;
                                tmp_kshift[2] = input_tensor_shift;
                                tmp_rggb_scale[0] = input_tensor_scale;
                                tmp_rggb_shift[0] = input_tensor_shift;
                                tmp_rggb_scale[1] = input_tensor_scale;
                                tmp_rggb_shift[1] = input_tensor_shift;
                                tmp_rggb_scale[2] = input_tensor_scale;
                                tmp_rggb_shift[2] = input_tensor_shift;
                            } else if (inputFormatInfo.getFormat().contentEquals("BGR")) {
                                tmp_kscale[0] = input_tensor_scale;
                                tmp_kshift[0] = input_tensor_shift;
                                tmp_kscale[1] = input_tensor_scale;
                                tmp_kshift[1] = input_tensor_shift;
                                tmp_kscale[2] = input_tensor_scale;
                                tmp_kshift[2] = input_tensor_shift;
                                tmp_rggb_scale[0] = input_tensor_scale;
                                tmp_rggb_shift[0] = input_tensor_shift;
                                tmp_rggb_scale[1] = input_tensor_scale;
                                tmp_rggb_shift[1] = input_tensor_shift;
                                tmp_rggb_scale[2] = input_tensor_scale;
                                tmp_rggb_shift[2] = input_tensor_shift;
                            } else if (inputFormatInfo.getFormat().contentEquals("Y")) {
                                tmp_yscale = input_tensor_scale;
                                tmp_yshift = input_tensor_shift;
                                tmp_rggb_scale[0] = input_tensor_scale;
                                tmp_rggb_shift[0] = input_tensor_shift;
                            } else if (inputFormatInfo.getFormat().contentEquals("BayerRGB")) {
                                tmp_rggb_scale[0] = input_tensor_scale;
                                tmp_rggb_shift[0] = input_tensor_shift;
                                tmp_rggb_scale[1] = input_tensor_scale;
                                tmp_rggb_shift[1] = input_tensor_shift;
                                tmp_rggb_scale[2] = input_tensor_scale;
                                tmp_rggb_shift[2] = input_tensor_shift;
                                tmp_rggb_scale[3] = input_tensor_scale;
                                tmp_rggb_shift[3] = input_tensor_shift;
                            } else {
                                System.err.println("Invalid Input Format\n");
                            }
                            if (inputFormatInfo.getFormat().contentEquals("BayerRGB")) {
                                idx = 0;
                                while (idx < tmp_rggb_scale.length) {
                                    rggb_bitshift[idx] = 0;
                                    if ((double)tmp_rggb_scale[idx] == 1.0) {
                                        rggb_bitshift[idx] = 0;
                                    } else if ((double)tmp_rggb_scale[idx] == 0.5) {
                                        tmp_rggb_shift[idx] = tmp_rggb_shift[idx] * 2.0f;
                                        rggb_bitshift[idx] = 1;
                                    } else {
                                        System.err.println("ERROR :Invalid value - Quantized Scale value should be either 1.0 or 0.5\n");
                                    }
                                    rggb_add[idx] = Math.round(tmp_rggb_shift[idx]) & 0x1FF;
                                    rggb_clip_min[idx] = Math.round(tmp_rggb_shift[idx]) & 0x1FF;
                                    rggb_clip_max[idx] = Math.round(tmp_rggb_scale[idx] * 255.0f + tmp_rggb_shift[idx]) & 0x1FF;
                                    ++idx;
                                }
                                ygain = Math.round(tmp_rggb_scale[0] * 32.0f) & 0xFF;
                                yadd = Math.round(tmp_rggb_shift[0]) & 0x1FF;
                            } else {
                                idx = 0;
                                while (idx < tmp_kscale.length) {
                                    kscale[idx] = Math.round(tmp_kscale[idx] * 1024.0f);
                                    kscale[idx] = kscale[idx] & 0xFFF;
                                    System.out.println("tmp_kscale[" + idx + "] =" + tmp_kscale[idx]);
                                    System.out.println("kscale[" + idx + "] =" + kscale[idx]);
                                    kshift[idx] = Math.round(tmp_kshift[idx] * 16.0f);
                                    kshift[idx] = kshift[idx] & 0x1FFF;
                                    System.out.println("tmp_kshift[" + idx + "] =" + tmp_kshift[idx]);
                                    System.out.println("kshift[" + idx + "] =" + kshift[idx]);
                                    clip_min[idx] = Math.round(tmp_kshift[idx]) & 0x1FF;
                                    clip_max[idx] = Math.round(tmp_kscale[idx] * 255.0f + tmp_kshift[idx]) & 0x1FF;
                                    System.out.println("clip_min[" + idx + "] =" + clip_min[idx] + "clip_max[" + idx + "] =" + clip_max[idx]);
                                    ++idx;
                                }
                                idx = 0;
                                while (idx < 3) {
                                    rggb_bitshift[idx] = 0;
                                    rggb_add[idx] = Math.round(tmp_rggb_shift[idx]) & 0x1FF;
                                    rggb_clip_min[idx] = Math.round(tmp_rggb_shift[idx]) & 0x1FF;
                                    rggb_clip_max[idx] = Math.round(tmp_rggb_scale[idx] * 255.0f + tmp_rggb_shift[idx]) & 0x1FF;
                                    ++idx;
                                }
                                if (inputFormatInfo.getFormat().contentEquals("RGB")) {
                                    ygain = Math.round(tmp_kscale[0] * 32.0f) & 0xFF;
                                    yadd = Math.round(tmp_kshift[0]) & 0x1FF;
                                } else if (inputFormatInfo.getFormat().contentEquals("BGR")) {
                                    ygain = Math.round(tmp_kscale[0] * 32.0f) & 0xFF;
                                    yadd = Math.round(tmp_kshift[0]) & 0x1FF;
                                } else if (inputFormatInfo.getFormat().contentEquals("Y")) {
                                    clip_min[0] = Math.round(tmp_yshift) & 0x1FF;
                                    clip_max[0] = Math.round(tmp_yscale * 255.0f + tmp_yshift) & 0x1FF;
                                    ygain = Math.round(tmp_yscale * 32.0f) & 0xFF;
                                    yadd = Math.round(tmp_yshift) & 0x1FF;
                                }
                            }
                            txtWriter.append("inputTensorFormat=" + inputFormatInfo.getFormat() + "\r\n");
                            int j = 0;
                            while (j < 3) {
                                switch (j) {
                                    case 0: {
                                        if (inputFormatInfo.getFormat().contentEquals("RGB") || inputFormatInfo.getFormat().contentEquals("Y") || inputFormatInfo.getFormat().contentEquals("BayerRGB")) {
                                            txtWriter.append("inputTensorNorm_K" + j + j + "=0x" + String.format("%04X", kscale[j]) + "\r\n");
                                            txtWriter.append("inputTensorNorm_K" + j + (j + 2) + "=0x0000\r\n");
                                            break;
                                        }
                                        if (!inputFormatInfo.getFormat().contentEquals("BGR")) break;
                                        txtWriter.append("inputTensorNorm_K" + j + j + "=0x0000\r\n");
                                        txtWriter.append("inputTensorNorm_K" + j + (j + 2) + "=0x" + String.format("%04X", kscale[j]) + "\r\n");
                                        break;
                                    }
                                    case 1: {
                                        txtWriter.append("inputTensorNorm_K" + j + j + "=0x" + String.format("%04X", kscale[j]) + "\r\n");
                                        break;
                                    }
                                    case 2: {
                                        if (inputFormatInfo.getFormat().contentEquals("RGB") || inputFormatInfo.getFormat().contentEquals("Y") || inputFormatInfo.getFormat().contentEquals("BayerRGB")) {
                                            txtWriter.append("inputTensorNorm_K" + j + (j - 2) + "=0x0000\r\n");
                                            txtWriter.append("inputTensorNorm_K" + j + j + "=0x" + String.format("%04X", kscale[j]) + "\r\n");
                                            break;
                                        }
                                        if (!inputFormatInfo.getFormat().contentEquals("BGR")) break;
                                        txtWriter.append("inputTensorNorm_K" + j + (j - 2) + "=0x" + String.format("%04X", kscale[j]) + "\r\n");
                                        txtWriter.append("inputTensorNorm_K" + j + j + "=0x0000\r\n");
                                    }
                                }
                                txtWriter.append("inputTensorNorm_K" + j + "3=0x" + String.format("%04X", kshift[j]) + "\r\n");
                                ++j;
                            }
                            txtWriter.append("yClip=0x" + String.format("%04X", clip_max[0]) + String.format("%04X", clip_min[0]) + "\r\n");
                            txtWriter.append("cbClip=0x" + String.format("%04X", clip_max[1]) + String.format("%04X", clip_min[1]) + "\r\n");
                            txtWriter.append("crClip=0x" + String.format("%04X", clip_max[2]) + String.format("%04X", clip_min[2]) + "\r\n");
                            j = 0;
                            while (j < 4) {
                                txtWriter.append("inputNorm_CH" + j + "=0x" + String.format("%04X", rggb_add[j]) + "\r\n");
                                txtWriter.append("inputNormShift_CH" + j + "=0x" + String.format("%02X", rggb_bitshift[j]) + "\r\n");
                                txtWriter.append("inputNormClip_CH" + j + "=0x" + String.format("%04X", rggb_clip_max[j]) + String.format("%04X", rggb_clip_min[j]) + "\r\n");
                                ++j;
                            }
                            txtWriter.append("inputTensorNorm_YGain=0x" + String.format("%04X", ygain) + "\r\n");
                            txtWriter.append("inputTensorNorm_YAdd=0x" + String.format("%04X", yadd) + "\r\n");
                            int numOfOutputTensor = network.getOutputTensors().getOutputTensor().size();
                            txtWriter.append("outputTensorNum=" + numOfOutputTensor + "\r\n");
                            int[] size_array = new int[numOfOutputTensor];
                            int[] bpe_array = new int[numOfOutputTensor];
                            int[] padding_array = new int[numOfOutputTensor];
                            int outIndex = 0;
                            while (outIndex < numOfOutputTensor) {
                                TensorInfo outputTensorInfo = network.getOutputTensors().getOutputTensor().get(outIndex);
                                short ordinal = outputTensorInfo.getOrdinal();
                                if (ordinal >= numOfOutputTensor) {
                                    System.err.println("Error : Invalid Output Tensor Ordinal");
                                }
                                int numDims = outputTensorInfo.getDimensions().getDimension().size();
                                short bitsPerElement = outputTensorInfo.getBitsPerElement();
                                int totalSize = 1;
                                int totalPadding = 0;
                                int[] serOrder_array = new int[numDims];
                                int k = 0;
                                while (k < numDims) {
                                    int size = outputTensorInfo.getDimensions().getDimension().get(k).getSize();
                                    totalSize *= size;
                                    serOrder_array[k] = outputTensorInfo.getDimensions().getDimension().get(k).getSerializationOrder();
                                    ++k;
                                }
                                int serIdx = 0;
                                while (serIdx < numDims) {
                                    totalPadding = serIdx == 0 ? outputTensorInfo.getDimensions().getDimension().get(serOrder_array[serIdx]).getPadding() : (totalPadding *= outputTensorInfo.getDimensions().getDimension().get(serOrder_array[serIdx]).getSize());
                                    ++serIdx;
                                }
                                size_array[ordinal] = totalSize;
                                bpe_array[ordinal] = bitsPerElement / 8;
                                padding_array[ordinal] = totalPadding;
                                ++outIndex;
                            }
                            int j2 = 0;
                            while (j2 < numOfOutputTensor) {
                                txtWriter.append("outputTensorDimSize" + (j2 + 1) + "=" + size_array[j2] + "\r\n");
                                ++j2;
                            }
                            j2 = 0;
                            while (j2 < numOfOutputTensor) {
                                txtWriter.append("outputTensorPadding" + (j2 + 1) + "=" + padding_array[j2] + "\r\n");
                                ++j2;
                            }
                            j2 = 0;
                            while (j2 < numOfOutputTensor) {
                                txtWriter.append("outputTensorBytesPerElement" + (j2 + 1) + "=" + bpe_array[j2] + "\r\n");
                                ++j2;
                            }
                            ++i;
                        }
                        txtWriter.flush();
                        txtWriter.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException | SAXException e2) {
                    e2.printStackTrace();
                }
            }
            catch (ParserConfigurationException e2) {
                e2.printStackTrace();
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public static void convertXml2Fb(String dnnParamsXml, String networkID, String networkType, boolean hasCustomNormalization, String inputFormatFileName) {
        try {
            File inFile = new File(dnnParamsXml);
            if (!inFile.exists()) {
                System.err.println("File doesnot exist!!");
                System.exit(-1);
            }
            System.out.println("Creating DNN Params from XML");
            String dnnOutFileName = DNN_PARAM_BIN_NAME;
            DnnParamsTool.createDnnParamsFlatBuffer(dnnParamsXml, dnnOutFileName);
            System.out.println(dnnOutFileName + " generated!!");
            System.out.println("=======================");
            System.out.println("Creating AP Params from XML");
            String apOutFileName = AP_PARAM_BIN_NAME;
            ApParamsTool.createApParamsFlatBuffer(dnnParamsXml, apOutFileName);
            System.out.println(apOutFileName + " generated!!");
            Xml2Fb.createNwInfoFile(dnnParamsXml, networkID, networkType, hasCustomNormalization, inputFormatFileName);
            System.out.println("Network Info generated!!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class FBTensorFormatType {
        static final int SIGNED = 0;
        static final int UNSIGNED = 1;

        FBTensorFormatType() {
        }
    }
}

