#!/bin/bash
set -e
set -x

IMX500_TOOLS=${HOME}/imx500-tools

POSTCONVERTER=${IMX500_TOOLS}/postconverter
POSTCONVERTER_SRC=./sw_packages/PostConverter_v020400.zip
PCONV_EXT=${POSTCONVERTER}/$(basename "${POSTCONVERTER_SRC%.zip}")

PACKAGER=${IMX500_TOOLS}/packager
PACKAGER_SRC=./sw_packages/RPK_Packager_v010101.zip
PACK_EXT=${PACKAGER}/$(basename "${PACKAGER_SRC%.zip}")
PACKAGE_SCRIPT_SRC=./scripts/imx500-package.sh

sudo apt install -y openjdk-17-jdk musl jq bc

[ -d "${IMX500_TOOLS}" ] || mkdir -p $IMX500_TOOLS

[ -d "${POSTCONVERTER}" ] && rm -rf "${POSTCONVERTER}"
unzip -q -o ${POSTCONVERTER_SRC} -d ${POSTCONVERTER}
test ! -d ${PCONV_EXT} || (mv ${PCONV_EXT}/* ${POSTCONVERTER} && rmdir ${PCONV_EXT})
chmod a+x ${POSTCONVERTER}/CustomNetwork/*.sh

[ -d "${PACKAGER}" ] && rm -rf "${PACKAGER}"
unzip -q -o ${PACKAGER_SRC} -d ${PACKAGER}
test ! -d ${PACK_EXT} || (mv ${PACK_EXT}/* ${PACKAGER} && rmdir ${PACK_EXT})
chmod a+x ${PACKAGER}/CustomNetwork/*.sh
cp -r ${PACKAGER}/RaspberryPiOSfor64bit/* ${PACKAGER}/tool/rpk_packager/
chmod a+x ${PACKAGER}/tool/rpk_packager/rpk_packager

chmod a+x ${PACKAGE_SCRIPT_SRC}
cp ${PACKAGE_SCRIPT_SRC} ${PACKAGER}

