#! /bin/bash

set -e

IMX500_TOOLS="$HOME/imx500-tools"

# Network ID
DEF_VERSION_NETWORK_ID="000000"

# Model major and minor version
DEF_VERSION_MODEL_MAJOR="00"
DEF_VERSION_MODEL_MINOR="00"

# Network Type
DEF_NETWORK_TYPE="0"

# Input Tensor Format File Path
INPUT_FORMAT_FILE_PATH="$IMX500_TOOLS/postconverter/CustomNetwork/input_format.json"

# Function to display usage message
usage() {
    echo "Usage: $0 -i <packer_out_path> -o <output_directory> [-f <input_format_json_path>]"
    echo "       $0 --input <packer_out_path> --output <output_directory>  [--format <input_format_json_path>]"
    exit 1
}

# Parse command-line options
while [[ $# -gt 0 ]]; do
    case $1 in
        # Input directory
        -i|--input)
            PACKER_OUT_PATH=$2
            shift
            shift
            ;;
        # Output directory
        -o|--output)
            OUTPUT_DIR=$2 
            shift
            shift
            ;;
        # Input Tensor Normalization File Path
        -f|--format)
            INPUT_FORMAT_FILE_PATH=$2
            shift
            shift
            ;;
        # Unknown option
        *)
            echo "Warning: Unknown command line argument: $1"
            usage
            ;;
    esac
done

# Check if both input and output are provided
if test -z "$PACKER_OUT_PATH" || test -z "$OUTPUT_DIR"; then
    echo "Error: Both input and output must be provided"
    usage
fi

PACKER_OUT_PATH=$(realpath "$PACKER_OUT_PATH")
OUTPUT_DIR=$(realpath "$OUTPUT_DIR")

test -z $INPUT_FORMAT_FILE_PATH || INPUT_FORMAT_FILE_PATH=$(realpath "$INPUT_FORMAT_FILE_PATH")
test -f $PACKER_OUT_PATH || { echo "Error: $PACKER_OUT_PATH not found"; usage; }
test -d $OUTPUT_DIR || mkdir -p $OUTPUT_DIR

# Post Converter
unzip $PACKER_OUT_PATH -d $IMX500_TOOLS/postconverter/CustomNetwork/packer_output
pushd $IMX500_TOOLS/postconverter/CustomNetwork/
./post_converter.sh  ${DEF_VERSION_NETWORK_ID} ${DEF_NETWORK_TYPE} ${DEF_VERSION_MODEL_MAJOR} ${DEF_VERSION_MODEL_MINOR} ${INPUT_FORMAT_FILE_PATH}

# Packager
unzip post_conv_output.zip -d $IMX500_TOOLS/packager/CustomNetwork
popd
pushd $IMX500_TOOLS/packager/CustomNetwork/
./mk_rpk_pkg_sample.sh
popd

# Move output to mapped host folder
cp $IMX500_TOOLS/packager/CustomNetwork/package/* $OUTPUT_DIR

# Clean-up
pushd $IMX500_TOOLS/postconverter/CustomNetwork
rm -rf post_conv_output packer_output *zip
popd

pushd $IMX500_TOOLS/packager/CustomNetwork
rm -rf package post_conv_output
popd

# Final output
echo Packaged model is in:
echo $OUTPUT_DIR
