#!/bin/bash -e

# ====================
#  check arguments
# ====================

USAGE_MESSAGE="usage: $0"

SCRIPT_DIR=$(cd $(dirname $0); pwd)

if [ $# -ne 0 ] ; then
  echo $USAGE_MESSAGE
  exit
fi

# ====================
#  script settings
# ====================

# Network ID
DEF_VERSION_NETWORK_ID="000000"

# Model major and minor version
DEF_VERSION_MODEL_MAJOR="00"
DEF_VERSION_MODEL_MINOR="00"

# Network Type
DEF_NETWORK_TYPE="0"

# Input Tensor Normalization File Path
DEF_INPUT_FORMAT_FILE_PATH=""

if [ -e ./version_overwrite.sh ] ; then
  source ./version_overwrite.sh
fi

echo "Input Parameters: "
echo "NetworkID : $DEF_VERSION_NETWORK_ID"
echo "Model Major Version : $DEF_VERSION_MODEL_MAJOR" 
echo "Model Minor Version : $DEF_VERSION_MODEL_MINOR"                        
echo "NetworkType : $DEF_NETWORK_TYPE"                                
echo "input_format file path : $DEF_INPUT_FORMAT_FILE_PATH"

# ====================
#  script settings (which have default value)
# ====================

# Path to output directory
#export PKG_POST_CONV_OUT_DIR=post_conv_output

# Path to packer_output directory
#export PKG_PACKER_OUTPUT_DIR=packer_output

# Path to PostConvertor directory
#export PKG_TOOL_DIR="../../tool"

# ====================
#  execute scripts
# ====================
if [ -z "${DEF_INPUT_FORMAT_FILE_PATH}" ]; then
  echo "Input format file path empty "
  ${SCRIPT_DIR}/post_converter.sh  ${DEF_VERSION_NETWORK_ID} ${DEF_NETWORK_TYPE}  ${DEF_VERSION_MODEL_MAJOR} ${DEF_VERSION_MODEL_MINOR}
else
  echo "Input fornat file path not empty "
  ${SCRIPT_DIR}/post_converter.sh  ${DEF_VERSION_NETWORK_ID} ${DEF_NETWORK_TYPE}  ${DEF_VERSION_MODEL_MAJOR} ${DEF_VERSION_MODEL_MINOR} ${DEF_INPUT_FORMAT_FILE_PATH}
fi
