#!/bin/bash -e

# ====================
#  check arguments
# ====================

USAGE_MESSAGE="usage: $0 output_filename"

# argument num
if [ $# -eq 1 ] ; then
  ARG_OUTPUT_FILE_PATH=$1
else
  echo $USAGE_MESSAGE
fi


# ====================
#  check environment variables
# ====================

if [ "$PKG_POST_CONV_OUTPUT_DIR" = "" ] ; then
  PKG_POST_CONV_OUTPUT_DIR=post_conv_output
fi

if [ "$PKG_TOOL_DIR" = "" ] ; then
  PKG_TOOL_DIR="../../tool"
fi

if [ "$PKG_DEPLOY_MANIFEST_JSON" = "" ] ; then
  PKG_DEPLOY_MANIFEST_JSON=deployManifest.json
fi

# ====================
#  functions to parse deployManifest.json
# ====================

function has_target_from_manifest_json() {
  local manifest_dir=$1
  local field_name=$2

  local target=`cat ${manifest_dir}/${PKG_DEPLOY_MANIFEST_JSON} | jq "${field_name} // empty"`

  if [ -n "$target" ] ; then
    rtn=1
  else
    rtn=0
  fi

  echo ${rtn}
}

function get_target_addr_from_manifest_json() {
  local manifest_dir=$1
  local field_name=$2
  local dec_base_addr=$3

  local offset=`cat ${manifest_dir}/${PKG_DEPLOY_MANIFEST_JSON} | jq ${field_name} | awk '{if (gsub(/"/,"")) print}'`
  local dec_offset=`printf "%d" $offset`
  local addr=`printf "0x%08x" $(($dec_base_addr + $dec_offset))`

  echo ${addr}
}

function get_file_path_from_manifest_json() {
  local manifest_dir=$1
  local field_name=$2

  local tmp_file_name=(`cat ${manifest_dir}/${PKG_DEPLOY_MANIFEST_JSON} | jq ${field_name} | awk '{if (gsub(/"/,"")) print}'`)

  echo ${manifest_dir}/${tmp_file_name}
}

function get_version_str_from_manifest_json() {
  local manifest_dir=$1
  local field_name=$2

  local version_str=`cat ${manifest_dir}/${PKG_DEPLOY_MANIFEST_JSON} | jq ${field_name} | awk '{if (gsub(/"/,"")) print}' | perl -pe '($_)=/([0-9]+([.][0-9]+)+)/' | awk '{split($0,a,"."); out=sprintf("%02d",a[3]); print out}'`

  echo ${version_str}
}

function get_version_str_12digits_from_manifest_json() {
  local manifest_dir=$1
  local field_name=$2

  local version_str=`cat ${manifest_dir}/${PKG_DEPLOY_MANIFEST_JSON} | jq ${field_name} | awk '{if (gsub(/"/,"")) print}' | perl -pe '($_)=/([0-9]+([.][0-9]+)+)/' | awk '{split($0,a,"."); out=sprintf("%02d%02d%02d%02d%02d%02d",a[1],a[2],a[3],a[4],a[5],a[6]); print out}'`

  echo ${version_str}
}

# ====================
#  gather parameters
# ====================

echo "[Parameters for Packager]" > $ARG_OUTPUT_FILE_PATH

dcpu_base=`echo "ibase=16; 40000000" | bc`

##### AP Params #####
target_id+=(0x04)
target_name="apParams"
target_base_offset=0

tmp_target_addr=`get_target_addr_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.LoadAddr" ${target_base_offset}`
target_addr+=($tmp_target_addr)
tmp_file_name=`get_file_path_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.File"`
file_name+=($tmp_file_name)
tmp_version_str=`get_version_str_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.Version"`
version_str+=($tmp_version_str)

##### DNN Params #####
target_id+=(0x08)
target_name="dnnParams"
target_base_offset=0

tmp_target_addr=`get_target_addr_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.LoadAddr" ${target_base_offset}`
target_addr+=($tmp_target_addr)
tmp_file_name=`get_file_path_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.File"`
file_name+=($tmp_file_name)
tmp_version_str=`get_version_str_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.Version"`
version_str+=($tmp_version_str)

##### CFG Blob1 #####
target_id+=(0x09)
target_name="CfgBank1"
target_base_offset=$dcpu_base

tmp_target_addr=`get_target_addr_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.LoadAddr" ${target_base_offset}`
target_addr+=($tmp_target_addr)
tmp_file_name=`get_file_path_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.File"`
file_name+=($tmp_file_name)
tmp_version_str=`get_version_str_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.Version"`
version_str+=($tmp_version_str)

##### CFG Blob2 #####
target_id+=(0x0A)
target_name="CfgBank2"
target_base_offset=$dcpu_base

tmp_target_addr=`get_target_addr_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.LoadAddr" ${target_base_offset}`
target_addr+=($tmp_target_addr)
tmp_file_name=`get_file_path_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.File"`
file_name+=($tmp_file_name)
tmp_version_str=`get_version_str_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.Version"`
version_str+=($tmp_version_str)

##### SDSP-A Program #####
target_id+=(0x0B)
target_name="SdspA"
target_base_offset=$dcpu_base

tmp_target_addr=`get_target_addr_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.LoadAddr" ${target_base_offset}`
target_addr+=($tmp_target_addr)
tmp_file_name=`get_file_path_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.File"`
file_name+=($tmp_file_name)
tmp_version_str=`get_version_str_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.Version"`
version_str+=($tmp_version_str)

##### SDSP-C Program #####
target_id+=(0x0C)
target_name="SdspC"
target_base_offset=$dcpu_base

tmp_target_addr=`get_target_addr_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.LoadAddr" ${target_base_offset}`
target_addr+=($tmp_target_addr)
tmp_file_name=`get_file_path_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.File"`
file_name+=($tmp_file_name)
tmp_version_str=`get_version_str_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.Version"`
version_str+=($tmp_version_str)

##### coef #####
target_id+=(0x10)
target_name="coef"
target_base_offset=$dcpu_base

tmp_target_addr=`get_target_addr_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.LoadAddr" ${target_base_offset}`
target_addr+=($tmp_target_addr)
tmp_file_name=`get_file_path_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.File"`
file_name+=($tmp_file_name)
tmp_version_str=`get_version_str_from_manifest_json ${PKG_POST_CONV_OUTPUT_DIR} ".${target_name}.Version"`
version_str+=($tmp_version_str)

# ====================
#  generate parameter file
# ====================
for index in ${!target_id[@]}
do
  echo "[IMAGE_FILE]" >> $ARG_OUTPUT_FILE_PATH
  printf "target_id: %s\n" ${target_id[$index]} >> $ARG_OUTPUT_FILE_PATH
  printf "file_name: %s\n" ${file_name[$index]} >> $ARG_OUTPUT_FILE_PATH
  printf "target_addr: %s\n" ${target_addr[$index]} >> $ARG_OUTPUT_FILE_PATH
  printf "version_str: %s\n" ${version_str[$index]} >> $ARG_OUTPUT_FILE_PATH
done

