#!/bin/bash -e

# ====================
#  check arguments
# ====================

USAGE_MESSAGE="usage: $0"

SCRIPT_DIR=$(cd $(dirname $0); pwd)

# argument num


# ====================
#  script settings
# ====================

# Path to parameter file (intermediate output file)
PARAM_FILE_PATH="./param.txt"

# Path to zip file from PostConverter
#   - If this parameter is empty, skip unzip process
#   - ex. ZIPPED_POST_CONV_OUT_FILE="./post_conv_output.zip"
ZIPPED_POST_CONV_OUT_FILE=""

# Top directory of the archived files in ZIPPED_POST_CONV_OUT_FILE
#   - This parameter is valid only if ZIPPED_POST_CONV_OUT_FILE is not empty
ZIPPED_POST_CONV_OUT_TOP_DIR="post_conv_output"

# Path to target directory to unzip ZIPPED_POST_CONV_OUT_FILE
#   - This parameter is valid only if ZIPPED_POST_CONV_OUT_FILE is not empty
#   - You should also set PKG_POST_CONV_OUTPUT_DIR properly.
#     ex. PKG_POST_CONV_OUTPUT_DIR="${ZIPPED_POST_CONV_OUT_UNZIP_DIR}/${ZIPPED_POST_CONV_OUT_TOP_DIR}"
ZIPPED_POST_CONV_OUT_UNZIP_DIR="."

# ====================
#  script settings (which have default value)
# ====================

# Path to output directory
#export PKG_DIR="./package"

# Path to post converter output directory
#export PKG_POST_CONV_OUTPUT_DIR=post_conv_output

# File name of manifest json
#export PKG_DEPLOY_MANIFEST_JSON=deployManifest.json

# Path to Xml2FbConvertor directory
#export PKG_TOOL_DIR="../../tool"

# Path to rpk_packager executable
export PKG_PACKAGER_DIR="../tool/rpk_packager"

# ====================
#  extract archived files from zip file (ZIPPED_POST_CONV_OUT_FILE)
# ====================
echo "Starting...Please wait a few seconds."

if [ "$ZIPPED_POST_CONV_OUT_FILE" != "" ] ; then
  if [ -e ${ZIPPED_POST_CONV_OUT_UNZIP_DIR}/${ZIPPED_POST_CONV_OUT_TOP_DIR} ]; then
    echo "${ZIPPED_POST_CONV_OUT_UNZIP_DIR}/${ZIPPED_POST_CONV_OUT_TOP_DIR} already exists."
    exit
  fi

  unzip -o ${ZIPPED_POST_CONV_OUT_FILE} -d ${ZIPPED_POST_CONV_OUT_UNZIP_DIR}
fi

# ====================
#  execute scripts
# ====================
${SCRIPT_DIR}/mk_param_file_common_network.sh ${PARAM_FILE_PATH}
${SCRIPT_DIR}/mk_network_pkg_rpk.sh ${PARAM_FILE_PATH}

rm -f ${PARAM_FILE_PATH}

