# FPK2RPK tool
 - FPK2RPK tool is a tool to convert network fpk file (IMX500 AI model) to rpk format
  
## Change History
 - v1.0.0
   - initial version

## Environment
- Ubuntu 22.04 LTS
  - libarchive-dev: 3.6.0-1ubuntu1.3 amd64
- raspios_lite_arm64:2022-04-04 (64bit)
  - libarchive-dev: 3.4.3-2+deb11u2
- raspios_lite_armhf:2022-04-04 (32bit)
  - libarchive-dev: 3.4.3-2+deb11u2

## Resources
 - readme.md
 - fpk2rpk (executable)
 - script/mk_rpk_from_fpk.sh

## Usage
### execute via script
```bash
# INPUT_ZIP_FILE_NAME: e.g., <IMX500_CHIP_ID>.zip
# It must contains files below.
#  - network_info.txt
#  - network.fpk

# usage
./script/mk_rpk_from_fpk.sh ${INPUT_ZIP_FILE_NAME}.zip
# it will do below command
# ./fpk2rpk -r network_info.txt -o ${INPUT_ZIP_FILE_NAME}$.rpk network.fpk
```

### execute bin directly
```bash
# usage
./fpk2rpk -r $network_info_txt [ -o $output_name] input_fpk_file
# example
./fpk2rpk -r network_info.txt -o output_network.rpk input_network.fpk
```

Parameter description 
 - input_fpk_file
   - input IMX500 network file in fpk format
   - mandatory parameter
 - o: output package Name
   - default: network.rpk
   - optional paramater
 - r: network info file name
   - input IMX500 network_info_txt file
   - mandatory parameter

Utility Option
 - v: Version
   - version number
 - h: Help
   - help info
