/*
 * This file is auto-generated by running 'make debug_defines' in
 * https://github.com/riscv/riscv-debug-spec/ (40b9a05)
 */

#include "debug_defines.h"
#include <stddef.h>
#include <assert.h>
static riscv_debug_reg_field_list_t dtm_idcode_get_version(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "Version",
			.lsb = 0x1c,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_idcode_get_partnumber(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "PartNumber",
			.lsb = 0xc,
			.msb = 0x1b,
			.values = NULL
		},
		.get_next = dtm_idcode_get_version
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_idcode_get_manufid(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ManufId",
			.lsb = 1,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = dtm_idcode_get_partnumber
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_idcode_get_1(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "1",
			.lsb = 0,
			.msb = 0,
			.values = NULL
		},
		.get_next = dtm_idcode_get_manufid
	};
	return result;
}

static const char *dtm_dtmcs_errinfo_values[8] = {
	[0] = "not_implemented",
	[1] = "dmi_error",
	[2] = "communication_error",
	[3] = "device_error",
	[4] = "unknown"
};
static const char *dtm_dtmcs_version_values[16] = {
	[0] = "0_11",
	[1] = "1_0",
	[15] = "custom"
};
static riscv_debug_reg_field_list_t dtm_dtmcs_get_abits(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "abits",
			.lsb = 4,
			.msb = 9,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dtmcs_get_errinfo(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "errinfo",
			.lsb = 0x12,
			.msb = 0x14,
			.values = dtm_dtmcs_errinfo_values
		},
		.get_next = dtm_dtmcs_get_abits
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dtmcs_get_dtmhardreset(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dtmhardreset",
			.lsb = 0x11,
			.msb = 0x11,
			.values = NULL
		},
		.get_next = dtm_dtmcs_get_errinfo
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dtmcs_get_dmireset(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmireset",
			.lsb = 0x10,
			.msb = 0x10,
			.values = NULL
		},
		.get_next = dtm_dtmcs_get_dtmhardreset
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dtmcs_get_idle(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "idle",
			.lsb = 0xc,
			.msb = 0xe,
			.values = NULL
		},
		.get_next = dtm_dtmcs_get_dmireset
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dtmcs_get_dmistat(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmistat",
			.lsb = 0xa,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = dtm_dtmcs_get_idle
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dtmcs_get_version(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "version",
			.lsb = 0,
			.msb = 3,
			.values = dtm_dtmcs_version_values
		},
		.get_next = dtm_dtmcs_get_dmistat
	};
	return result;
}

static const char *dtm_dmi_op_values[4] = {};
static riscv_debug_reg_field_list_t dtm_dmi_get_address(riscv_debug_reg_ctx_t context)
{
	assert(context.abits.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "address",
			.lsb = 0x22,
			.msb = (context.abits.value + 0x21),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dmi_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 2,
			.msb = 0x21,
			.values = NULL
		},
		.get_next = dtm_dmi_get_address
	};
	return result;
}

static riscv_debug_reg_field_list_t dtm_dmi_get_op(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "op",
			.lsb = 0,
			.msb = 1,
			.values = dtm_dmi_op_values
		},
		.get_next = dtm_dmi_get_data
	};
	return result;
}


static const char *csr_dcsr_debugver_values[16] = {
	[0] = "none",
	[4] = "1_0",
	[15] = "custom"
};
static const char *csr_dcsr_ebreakvs_values[2] = {
	[0] = "exception",
	[1] = "debug_mode"
};
static const char *csr_dcsr_ebreakvu_values[2] = {
	[0] = "exception",
	[1] = "debug_mode"
};
static const char *csr_dcsr_ebreakm_values[2] = {
	[0] = "exception",
	[1] = "debug_mode"
};
static const char *csr_dcsr_ebreaks_values[2] = {
	[0] = "exception",
	[1] = "debug_mode"
};
static const char *csr_dcsr_ebreaku_values[2] = {
	[0] = "exception",
	[1] = "debug_mode"
};
static const char *csr_dcsr_stepie_values[2] = {
	[0] = "interrupts_disabled",
	[1] = "interrupts_enabled"
};
static const char *csr_dcsr_stopcount_values[2] = {
	[0] = "normal",
	[1] = "freeze"
};
static const char *csr_dcsr_stoptime_values[2] = {
	[0] = "normal",
	[1] = "freeze"
};
static const char *csr_dcsr_cause_values[8] = {
	[1] = "ebreak",
	[2] = "trigger",
	[3] = "haltreq",
	[4] = "step",
	[5] = "resethaltreq",
	[6] = "group"
};
static const char *csr_dcsr_mprven_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static riscv_debug_reg_field_list_t csr_dcsr_get_stoptime(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "stoptime",
			.lsb = 9,
			.msb = 9,
			.values = csr_dcsr_stoptime_values
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_cause(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "cause",
			.lsb = 6,
			.msb = 8,
			.values = csr_dcsr_cause_values
		},
		.get_next = csr_dcsr_get_stoptime
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_v(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "v",
			.lsb = 5,
			.msb = 5,
			.values = NULL
		},
		.get_next = csr_dcsr_get_cause
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_mprven(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "mprven",
			.lsb = 4,
			.msb = 4,
			.values = csr_dcsr_mprven_values
		},
		.get_next = csr_dcsr_get_v
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_nmip(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "nmip",
			.lsb = 3,
			.msb = 3,
			.values = NULL
		},
		.get_next = csr_dcsr_get_mprven
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_debugver(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "debugver",
			.lsb = 0x1c,
			.msb = 0x1f,
			.values = csr_dcsr_debugver_values
		},
		.get_next = csr_dcsr_get_nmip
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_step(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "step",
			.lsb = 2,
			.msb = 2,
			.values = NULL
		},
		.get_next = csr_dcsr_get_debugver
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_ebreakvs(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ebreakvs",
			.lsb = 0x11,
			.msb = 0x11,
			.values = csr_dcsr_ebreakvs_values
		},
		.get_next = csr_dcsr_get_step
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_ebreakvu(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ebreakvu",
			.lsb = 0x10,
			.msb = 0x10,
			.values = csr_dcsr_ebreakvu_values
		},
		.get_next = csr_dcsr_get_ebreakvs
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_ebreakm(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ebreakm",
			.lsb = 0xf,
			.msb = 0xf,
			.values = csr_dcsr_ebreakm_values
		},
		.get_next = csr_dcsr_get_ebreakvu
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_ebreaks(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ebreaks",
			.lsb = 0xd,
			.msb = 0xd,
			.values = csr_dcsr_ebreaks_values
		},
		.get_next = csr_dcsr_get_ebreakm
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_ebreaku(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ebreaku",
			.lsb = 0xc,
			.msb = 0xc,
			.values = csr_dcsr_ebreaku_values
		},
		.get_next = csr_dcsr_get_ebreaks
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_stepie(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "stepie",
			.lsb = 0xb,
			.msb = 0xb,
			.values = csr_dcsr_stepie_values
		},
		.get_next = csr_dcsr_get_ebreaku
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_stopcount(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "stopcount",
			.lsb = 0xa,
			.msb = 0xa,
			.values = csr_dcsr_stopcount_values
		},
		.get_next = csr_dcsr_get_stepie
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dcsr_get_prv(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "prv",
			.lsb = 0,
			.msb = 1,
			.values = NULL
		},
		.get_next = csr_dcsr_get_stopcount
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dpc_get_dpc(riscv_debug_reg_ctx_t context)
{
	assert(context.DXLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dpc",
			.lsb = 0,
			.msb = (context.DXLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dscratch0_get_dscratch0(riscv_debug_reg_ctx_t context)
{
	assert(context.DXLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dscratch0",
			.lsb = 0,
			.msb = (context.DXLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_dscratch1_get_dscratch1(riscv_debug_reg_ctx_t context)
{
	assert(context.DXLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dscratch1",
			.lsb = 0,
			.msb = (context.DXLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tselect_get_index(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "index",
			.lsb = 0,
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *csr_tdata1_type_values[16] = {
	[0] = "none",
	[1] = "legacy",
	[2] = "mcontrol",
	[3] = "icount",
	[4] = "itrigger",
	[5] = "etrigger",
	[6] = "mcontrol6",
	[7] = "tmexttrigger",
	[15] = "disabled"
};
static const char *csr_tdata1_dmode_values[2] = {
	[0] = "both",
	[1] = "dmode"
};
static riscv_debug_reg_field_list_t csr_tdata1_get_dmode(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmode",
			.lsb = (context.XLEN.value + -5),
			.msb = (context.XLEN.value + -5),
			.values = csr_tdata1_dmode_values
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tdata1_get_type(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "type",
			.lsb = (context.XLEN.value + -4),
			.msb = (context.XLEN.value + -1),
			.values = csr_tdata1_type_values
		},
		.get_next = csr_tdata1_get_dmode
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tdata1_get_data(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = (context.XLEN.value + -6),
			.values = NULL
		},
		.get_next = csr_tdata1_get_type
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tdata2_get_data(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tdata3_get_data(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *csr_tinfo_version_values[256] = {
	[0] = "0",
	[1] = "1"
};
static riscv_debug_reg_field_list_t csr_tinfo_get_version(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "version",
			.lsb = 0x18,
			.msb = 0x1f,
			.values = csr_tinfo_version_values
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tinfo_get_info(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "info",
			.lsb = 0,
			.msb = 0xf,
			.values = NULL
		},
		.get_next = csr_tinfo_get_version
	};
	return result;
}

static const char *csr_tcontrol_mte_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static riscv_debug_reg_field_list_t csr_tcontrol_get_mpte(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "mpte",
			.lsb = 7,
			.msb = 7,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tcontrol_get_mte(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "mte",
			.lsb = 3,
			.msb = 3,
			.values = csr_tcontrol_mte_values
		},
		.get_next = csr_tcontrol_get_mpte
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_scontext_get_data(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontext_get_hcontext(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hcontext",
			.lsb = 0,
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *csr_mcontrol_select_values[2] = {
	[0] = "address",
	[1] = "data"
};
static const char *csr_mcontrol_timing_values[2] = {
	[0] = "before",
	[1] = "after"
};
static const char *csr_mcontrol_sizelo_values[4] = {};
static const char *csr_mcontrol_action_values[16] = {
	[0] = "breakpoint",
	[1] = "debug_mode",
	[2] = "trace_on",
	[3] = "trace_off",
	[4] = "trace_notify",
	[8] = "external0",
	[9] = "external1"
};
static const char *csr_mcontrol_chain_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static const char *csr_mcontrol_match_values[16] = {
	[0] = "equal",
	[1] = "napot",
	[2] = "ge",
	[3] = "lt",
	[4] = "mask_low",
	[5] = "mask_high",
	[8] = "not_equal",
	[9] = "not_napot",
	[12] = "not_mask_low",
	[13] = "not_mask_high"
};
static riscv_debug_reg_field_list_t csr_mcontrol_get_dmode(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmode",
			.lsb = (context.XLEN.value + -5),
			.msb = (context.XLEN.value + -5),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_type(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "type",
			.lsb = (context.XLEN.value + -4),
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = csr_mcontrol_get_dmode
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_maskmax(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "maskmax",
			.lsb = (context.XLEN.value + -0xb),
			.msb = (context.XLEN.value + -6),
			.values = NULL
		},
		.get_next = csr_mcontrol_get_type
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_match(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "match",
			.lsb = 7,
			.msb = 0xa,
			.values = csr_mcontrol_match_values
		},
		.get_next = csr_mcontrol_get_maskmax
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_m(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "m",
			.lsb = 6,
			.msb = 6,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_match
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_s(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "s",
			.lsb = 4,
			.msb = 4,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_m
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_u(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "u",
			.lsb = 3,
			.msb = 3,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_s
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_sizehi(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sizehi",
			.lsb = 0x15,
			.msb = 0x16,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_u
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_hit(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hit",
			.lsb = 0x14,
			.msb = 0x14,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_sizehi
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_execute(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "execute",
			.lsb = 2,
			.msb = 2,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_hit
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_select(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "select",
			.lsb = 0x13,
			.msb = 0x13,
			.values = csr_mcontrol_select_values
		},
		.get_next = csr_mcontrol_get_execute
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_timing(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "timing",
			.lsb = 0x12,
			.msb = 0x12,
			.values = csr_mcontrol_timing_values
		},
		.get_next = csr_mcontrol_get_select
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_sizelo(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sizelo",
			.lsb = 0x10,
			.msb = 0x11,
			.values = csr_mcontrol_sizelo_values
		},
		.get_next = csr_mcontrol_get_timing
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_action(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "action",
			.lsb = 0xc,
			.msb = 0xf,
			.values = csr_mcontrol_action_values
		},
		.get_next = csr_mcontrol_get_sizelo
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_chain(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "chain",
			.lsb = 0xb,
			.msb = 0xb,
			.values = csr_mcontrol_chain_values
		},
		.get_next = csr_mcontrol_get_action
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_store(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "store",
			.lsb = 1,
			.msb = 1,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_chain
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol_get_load(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "load",
			.lsb = 0,
			.msb = 0,
			.values = NULL
		},
		.get_next = csr_mcontrol_get_store
	};
	return result;
}

static const char *csr_mcontrol6_uncertain_values[2] = {
	[0] = "certain",
	[1] = "uncertain"
};
static const char *csr_mcontrol6_hit0_values[2] = {};
static const char *csr_mcontrol6_select_values[2] = {
	[0] = "address",
	[1] = "data"
};
static const char *csr_mcontrol6_size_values[8] = {
	[0] = "any",
	[1] = "8bit",
	[2] = "16bit",
	[3] = "32bit",
	[4] = "48bit",
	[5] = "64bit",
	[6] = "128bit"
};
static const char *csr_mcontrol6_action_values[16] = {
	[0] = "breakpoint",
	[1] = "debug_mode",
	[2] = "trace_on",
	[3] = "trace_off",
	[4] = "trace_notify",
	[8] = "external0",
	[9] = "external1"
};
static const char *csr_mcontrol6_chain_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static const char *csr_mcontrol6_match_values[16] = {
	[0] = "equal",
	[1] = "napot",
	[2] = "ge",
	[3] = "lt",
	[4] = "mask_low",
	[5] = "mask_high",
	[8] = "not_equal",
	[9] = "not_napot",
	[12] = "not_mask_low",
	[13] = "not_mask_high"
};
static const char *csr_mcontrol6_uncertainen_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static riscv_debug_reg_field_list_t csr_mcontrol6_get_dmode(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmode",
			.lsb = (context.XLEN.value + -5),
			.msb = (context.XLEN.value + -5),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_type(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "type",
			.lsb = (context.XLEN.value + -4),
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_dmode
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_match(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "match",
			.lsb = 7,
			.msb = 0xa,
			.values = csr_mcontrol6_match_values
		},
		.get_next = csr_mcontrol6_get_type
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_m(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "m",
			.lsb = 6,
			.msb = 6,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_match
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_uncertainen(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "uncertainen",
			.lsb = 5,
			.msb = 5,
			.values = csr_mcontrol6_uncertainen_values
		},
		.get_next = csr_mcontrol6_get_m
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_s(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "s",
			.lsb = 4,
			.msb = 4,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_uncertainen
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_u(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "u",
			.lsb = 3,
			.msb = 3,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_s
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_uncertain(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "uncertain",
			.lsb = 0x1a,
			.msb = 0x1a,
			.values = csr_mcontrol6_uncertain_values
		},
		.get_next = csr_mcontrol6_get_u
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_hit1(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hit1",
			.lsb = 0x19,
			.msb = 0x19,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_uncertain
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_vs(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vs",
			.lsb = 0x18,
			.msb = 0x18,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_hit1
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_vu(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vu",
			.lsb = 0x17,
			.msb = 0x17,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_vs
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_hit0(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hit0",
			.lsb = 0x16,
			.msb = 0x16,
			.values = csr_mcontrol6_hit0_values
		},
		.get_next = csr_mcontrol6_get_vu
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_select(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "select",
			.lsb = 0x15,
			.msb = 0x15,
			.values = csr_mcontrol6_select_values
		},
		.get_next = csr_mcontrol6_get_hit0
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_execute(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "execute",
			.lsb = 2,
			.msb = 2,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_select
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_size(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "size",
			.lsb = 0x10,
			.msb = 0x12,
			.values = csr_mcontrol6_size_values
		},
		.get_next = csr_mcontrol6_get_execute
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_action(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "action",
			.lsb = 0xc,
			.msb = 0xf,
			.values = csr_mcontrol6_action_values
		},
		.get_next = csr_mcontrol6_get_size
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_chain(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "chain",
			.lsb = 0xb,
			.msb = 0xb,
			.values = csr_mcontrol6_chain_values
		},
		.get_next = csr_mcontrol6_get_action
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_store(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "store",
			.lsb = 1,
			.msb = 1,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_chain
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_mcontrol6_get_load(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "load",
			.lsb = 0,
			.msb = 0,
			.values = NULL
		},
		.get_next = csr_mcontrol6_get_store
	};
	return result;
}

static const char *csr_icount_action_values[64] = {
	[0] = "breakpoint",
	[1] = "debug_mode",
	[2] = "trace_on",
	[3] = "trace_off",
	[4] = "trace_notify",
	[8] = "external0",
	[9] = "external1"
};
static riscv_debug_reg_field_list_t csr_icount_get_dmode(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmode",
			.lsb = (context.XLEN.value + -5),
			.msb = (context.XLEN.value + -5),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_type(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "type",
			.lsb = (context.XLEN.value + -4),
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = csr_icount_get_dmode
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_m(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "m",
			.lsb = 9,
			.msb = 9,
			.values = NULL
		},
		.get_next = csr_icount_get_type
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_pending(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "pending",
			.lsb = 8,
			.msb = 8,
			.values = NULL
		},
		.get_next = csr_icount_get_m
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_s(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "s",
			.lsb = 7,
			.msb = 7,
			.values = NULL
		},
		.get_next = csr_icount_get_pending
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_u(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "u",
			.lsb = 6,
			.msb = 6,
			.values = NULL
		},
		.get_next = csr_icount_get_s
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_vs(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vs",
			.lsb = 0x1a,
			.msb = 0x1a,
			.values = NULL
		},
		.get_next = csr_icount_get_u
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_vu(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vu",
			.lsb = 0x19,
			.msb = 0x19,
			.values = NULL
		},
		.get_next = csr_icount_get_vs
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_hit(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hit",
			.lsb = 0x18,
			.msb = 0x18,
			.values = NULL
		},
		.get_next = csr_icount_get_vu
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_count(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "count",
			.lsb = 0xa,
			.msb = 0x17,
			.values = NULL
		},
		.get_next = csr_icount_get_hit
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_icount_get_action(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "action",
			.lsb = 0,
			.msb = 5,
			.values = csr_icount_action_values
		},
		.get_next = csr_icount_get_count
	};
	return result;
}

static const char *csr_itrigger_action_values[64] = {
	[0] = "breakpoint",
	[1] = "debug_mode",
	[2] = "trace_on",
	[3] = "trace_off",
	[4] = "trace_notify",
	[8] = "external0",
	[9] = "external1"
};
static riscv_debug_reg_field_list_t csr_itrigger_get_hit(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hit",
			.lsb = (context.XLEN.value + -6),
			.msb = (context.XLEN.value + -6),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_dmode(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmode",
			.lsb = (context.XLEN.value + -5),
			.msb = (context.XLEN.value + -5),
			.values = NULL
		},
		.get_next = csr_itrigger_get_hit
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_type(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "type",
			.lsb = (context.XLEN.value + -4),
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = csr_itrigger_get_dmode
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_m(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "m",
			.lsb = 9,
			.msb = 9,
			.values = NULL
		},
		.get_next = csr_itrigger_get_type
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_s(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "s",
			.lsb = 7,
			.msb = 7,
			.values = NULL
		},
		.get_next = csr_itrigger_get_m
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_u(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "u",
			.lsb = 6,
			.msb = 6,
			.values = NULL
		},
		.get_next = csr_itrigger_get_s
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_vs(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vs",
			.lsb = 0xc,
			.msb = 0xc,
			.values = NULL
		},
		.get_next = csr_itrigger_get_u
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_vu(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vu",
			.lsb = 0xb,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = csr_itrigger_get_vs
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_nmi(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "nmi",
			.lsb = 0xa,
			.msb = 0xa,
			.values = NULL
		},
		.get_next = csr_itrigger_get_vu
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_itrigger_get_action(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "action",
			.lsb = 0,
			.msb = 5,
			.values = csr_itrigger_action_values
		},
		.get_next = csr_itrigger_get_nmi
	};
	return result;
}

static const char *csr_etrigger_action_values[64] = {
	[0] = "breakpoint",
	[1] = "debug_mode",
	[2] = "trace_on",
	[3] = "trace_off",
	[4] = "trace_notify",
	[8] = "external0",
	[9] = "external1"
};
static riscv_debug_reg_field_list_t csr_etrigger_get_hit(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hit",
			.lsb = (context.XLEN.value + -6),
			.msb = (context.XLEN.value + -6),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_dmode(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmode",
			.lsb = (context.XLEN.value + -5),
			.msb = (context.XLEN.value + -5),
			.values = NULL
		},
		.get_next = csr_etrigger_get_hit
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_type(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "type",
			.lsb = (context.XLEN.value + -4),
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = csr_etrigger_get_dmode
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_m(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "m",
			.lsb = 9,
			.msb = 9,
			.values = NULL
		},
		.get_next = csr_etrigger_get_type
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_s(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "s",
			.lsb = 7,
			.msb = 7,
			.values = NULL
		},
		.get_next = csr_etrigger_get_m
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_u(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "u",
			.lsb = 6,
			.msb = 6,
			.values = NULL
		},
		.get_next = csr_etrigger_get_s
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_vs(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vs",
			.lsb = 0xc,
			.msb = 0xc,
			.values = NULL
		},
		.get_next = csr_etrigger_get_u
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_vu(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "vu",
			.lsb = 0xb,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = csr_etrigger_get_vs
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_etrigger_get_action(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "action",
			.lsb = 0,
			.msb = 5,
			.values = csr_etrigger_action_values
		},
		.get_next = csr_etrigger_get_vu
	};
	return result;
}

static const char *csr_tmexttrigger_action_values[64] = {
	[0] = "breakpoint",
	[1] = "debug_mode",
	[2] = "trace_on",
	[3] = "trace_off",
	[4] = "trace_notify",
	[8] = "external0",
	[9] = "external1"
};
static riscv_debug_reg_field_list_t csr_tmexttrigger_get_hit(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hit",
			.lsb = (context.XLEN.value + -6),
			.msb = (context.XLEN.value + -6),
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tmexttrigger_get_dmode(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmode",
			.lsb = (context.XLEN.value + -5),
			.msb = (context.XLEN.value + -5),
			.values = NULL
		},
		.get_next = csr_tmexttrigger_get_hit
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tmexttrigger_get_type(riscv_debug_reg_ctx_t context)
{
	assert(context.XLEN.is_set);
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "type",
			.lsb = (context.XLEN.value + -4),
			.msb = (context.XLEN.value + -1),
			.values = NULL
		},
		.get_next = csr_tmexttrigger_get_dmode
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tmexttrigger_get_select(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "select",
			.lsb = 6,
			.msb = 0x15,
			.values = NULL
		},
		.get_next = csr_tmexttrigger_get_type
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tmexttrigger_get_intctl(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "intctl",
			.lsb = 0x16,
			.msb = 0x16,
			.values = NULL
		},
		.get_next = csr_tmexttrigger_get_select
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_tmexttrigger_get_action(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "action",
			.lsb = 0,
			.msb = 5,
			.values = csr_tmexttrigger_action_values
		},
		.get_next = csr_tmexttrigger_get_intctl
	};
	return result;
}

static const char *csr_textra32_mhselect_values[8] = {
	[0] = "ignore",
	[4] = "mcontext"
};
static const char *csr_textra32_sselect_values[4] = {
	[0] = "ignore",
	[1] = "scontext",
	[2] = "asid"
};
static riscv_debug_reg_field_list_t csr_textra32_get_mhvalue(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "mhvalue",
			.lsb = 0x1a,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra32_get_mhselect(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "mhselect",
			.lsb = 0x17,
			.msb = 0x19,
			.values = csr_textra32_mhselect_values
		},
		.get_next = csr_textra32_get_mhvalue
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra32_get_svalue(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "svalue",
			.lsb = 2,
			.msb = 0x11,
			.values = NULL
		},
		.get_next = csr_textra32_get_mhselect
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra32_get_sbytemask(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbytemask",
			.lsb = 0x12,
			.msb = 0x13,
			.values = NULL
		},
		.get_next = csr_textra32_get_svalue
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra32_get_sselect(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sselect",
			.lsb = 0,
			.msb = 1,
			.values = csr_textra32_sselect_values
		},
		.get_next = csr_textra32_get_sbytemask
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra64_get_mhvalue(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "mhvalue",
			.lsb = 0x33,
			.msb = 0x3f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra64_get_mhselect(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "mhselect",
			.lsb = 0x30,
			.msb = 0x32,
			.values = NULL
		},
		.get_next = csr_textra64_get_mhvalue
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra64_get_sbytemask(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbytemask",
			.lsb = 0x24,
			.msb = 0x28,
			.values = NULL
		},
		.get_next = csr_textra64_get_mhselect
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra64_get_svalue(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "svalue",
			.lsb = 2,
			.msb = 0x23,
			.values = NULL
		},
		.get_next = csr_textra64_get_sbytemask
	};
	return result;
}

static riscv_debug_reg_field_list_t csr_textra64_get_sselect(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sselect",
			.lsb = 0,
			.msb = 1,
			.values = NULL
		},
		.get_next = csr_textra64_get_svalue
	};
	return result;
}

static const char *dm_dmstatus_ndmresetpending_values[2] = {
	[0] = "false",
	[1] = "true"
};
static const char *dm_dmstatus_stickyunavail_values[2] = {
	[0] = "current",
	[1] = "sticky"
};
static const char *dm_dmstatus_authenticated_values[2] = {
	[0] = "false",
	[1] = "true"
};
static const char *dm_dmstatus_authbusy_values[2] = {
	[0] = "ready",
	[1] = "busy"
};
static const char *dm_dmstatus_confstrptrvalid_values[2] = {
	[0] = "invalid",
	[1] = "valid"
};
static const char *dm_dmstatus_version_values[16] = {
	[0] = "none",
	[1] = "0_11",
	[2] = "0_13",
	[3] = "1_0",
	[15] = "custom"
};
static riscv_debug_reg_field_list_t dm_dmstatus_get_allhalted(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "allhalted",
			.lsb = 9,
			.msb = 9,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_anyhalted(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "anyhalted",
			.lsb = 8,
			.msb = 8,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_allhalted
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_authenticated(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "authenticated",
			.lsb = 7,
			.msb = 7,
			.values = dm_dmstatus_authenticated_values
		},
		.get_next = dm_dmstatus_get_anyhalted
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_authbusy(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "authbusy",
			.lsb = 6,
			.msb = 6,
			.values = dm_dmstatus_authbusy_values
		},
		.get_next = dm_dmstatus_get_authenticated
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_hasresethaltreq(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hasresethaltreq",
			.lsb = 5,
			.msb = 5,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_authbusy
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_confstrptrvalid(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "confstrptrvalid",
			.lsb = 4,
			.msb = 4,
			.values = dm_dmstatus_confstrptrvalid_values
		},
		.get_next = dm_dmstatus_get_hasresethaltreq
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_ndmresetpending(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ndmresetpending",
			.lsb = 0x18,
			.msb = 0x18,
			.values = dm_dmstatus_ndmresetpending_values
		},
		.get_next = dm_dmstatus_get_confstrptrvalid
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_stickyunavail(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "stickyunavail",
			.lsb = 0x17,
			.msb = 0x17,
			.values = dm_dmstatus_stickyunavail_values
		},
		.get_next = dm_dmstatus_get_ndmresetpending
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_impebreak(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "impebreak",
			.lsb = 0x16,
			.msb = 0x16,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_stickyunavail
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_allhavereset(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "allhavereset",
			.lsb = 0x13,
			.msb = 0x13,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_impebreak
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_anyhavereset(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "anyhavereset",
			.lsb = 0x12,
			.msb = 0x12,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_allhavereset
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_allresumeack(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "allresumeack",
			.lsb = 0x11,
			.msb = 0x11,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_anyhavereset
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_anyresumeack(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "anyresumeack",
			.lsb = 0x10,
			.msb = 0x10,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_allresumeack
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_allnonexistent(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "allnonexistent",
			.lsb = 0xf,
			.msb = 0xf,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_anyresumeack
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_anynonexistent(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "anynonexistent",
			.lsb = 0xe,
			.msb = 0xe,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_allnonexistent
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_allunavail(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "allunavail",
			.lsb = 0xd,
			.msb = 0xd,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_anynonexistent
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_anyunavail(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "anyunavail",
			.lsb = 0xc,
			.msb = 0xc,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_allunavail
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_allrunning(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "allrunning",
			.lsb = 0xb,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_anyunavail
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_anyrunning(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "anyrunning",
			.lsb = 0xa,
			.msb = 0xa,
			.values = NULL
		},
		.get_next = dm_dmstatus_get_allrunning
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmstatus_get_version(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "version",
			.lsb = 0,
			.msb = 3,
			.values = dm_dmstatus_version_values
		},
		.get_next = dm_dmstatus_get_anyrunning
	};
	return result;
}

static const char *dm_dmcontrol_ackhavereset_values[2] = {
	[0] = "nop",
	[1] = "ack"
};
static const char *dm_dmcontrol_ackunavail_values[2] = {
	[0] = "nop",
	[1] = "ack"
};
static const char *dm_dmcontrol_hasel_values[2] = {
	[0] = "single",
	[1] = "multiple"
};
static const char *dm_dmcontrol_dmactive_values[2] = {
	[0] = "inactive",
	[1] = "active"
};
static riscv_debug_reg_field_list_t dm_dmcontrol_get_hartselhi(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hartselhi",
			.lsb = 6,
			.msb = 0xf,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_setkeepalive(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "setkeepalive",
			.lsb = 5,
			.msb = 5,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_hartselhi
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_clrkeepalive(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "clrkeepalive",
			.lsb = 4,
			.msb = 4,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_setkeepalive
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_haltreq(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "haltreq",
			.lsb = 0x1f,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_clrkeepalive
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_resumereq(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "resumereq",
			.lsb = 0x1e,
			.msb = 0x1e,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_haltreq
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_setresethaltreq(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "setresethaltreq",
			.lsb = 3,
			.msb = 3,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_resumereq
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_hartreset(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hartreset",
			.lsb = 0x1d,
			.msb = 0x1d,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_setresethaltreq
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_ackhavereset(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ackhavereset",
			.lsb = 0x1c,
			.msb = 0x1c,
			.values = dm_dmcontrol_ackhavereset_values
		},
		.get_next = dm_dmcontrol_get_hartreset
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_ackunavail(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ackunavail",
			.lsb = 0x1b,
			.msb = 0x1b,
			.values = dm_dmcontrol_ackunavail_values
		},
		.get_next = dm_dmcontrol_get_ackhavereset
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_hasel(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hasel",
			.lsb = 0x1a,
			.msb = 0x1a,
			.values = dm_dmcontrol_hasel_values
		},
		.get_next = dm_dmcontrol_get_ackunavail
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_clrresethaltreq(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "clrresethaltreq",
			.lsb = 2,
			.msb = 2,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_hasel
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_hartsello(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hartsello",
			.lsb = 0x10,
			.msb = 0x19,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_clrresethaltreq
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_ndmreset(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "ndmreset",
			.lsb = 1,
			.msb = 1,
			.values = NULL
		},
		.get_next = dm_dmcontrol_get_hartsello
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcontrol_get_dmactive(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmactive",
			.lsb = 0,
			.msb = 0,
			.values = dm_dmcontrol_dmactive_values
		},
		.get_next = dm_dmcontrol_get_ndmreset
	};
	return result;
}

static const char *dm_hartinfo_dataaccess_values[2] = {
	[0] = "csr",
	[1] = "memory"
};
static riscv_debug_reg_field_list_t dm_hartinfo_get_nscratch(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "nscratch",
			.lsb = 0x14,
			.msb = 0x17,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_hartinfo_get_dataaccess(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dataaccess",
			.lsb = 0x10,
			.msb = 0x10,
			.values = dm_hartinfo_dataaccess_values
		},
		.get_next = dm_hartinfo_get_nscratch
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_hartinfo_get_datasize(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "datasize",
			.lsb = 0xc,
			.msb = 0xf,
			.values = NULL
		},
		.get_next = dm_hartinfo_get_dataaccess
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_hartinfo_get_dataaddr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dataaddr",
			.lsb = 0,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = dm_hartinfo_get_datasize
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_hawindowsel_get_hawindowsel(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hawindowsel",
			.lsb = 0,
			.msb = 0xe,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_hawindow_get_maskdata(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "maskdata",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *dm_abstractcs_busy_values[2] = {
	[0] = "ready",
	[1] = "busy"
};
static const char *dm_abstractcs_relaxedpriv_values[2] = {
	[0] = "full_checks",
	[1] = "relaxed_checks"
};
static const char *dm_abstractcs_cmderr_values[8] = {
	[0] = "none",
	[1] = "busy",
	[2] = "not_supported",
	[3] = "exception",
	[4] = "halt_resume",
	[5] = "bus",
	[6] = "reserved",
	[7] = "other"
};
static riscv_debug_reg_field_list_t dm_abstractcs_get_cmderr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "cmderr",
			.lsb = 8,
			.msb = 0xa,
			.values = dm_abstractcs_cmderr_values
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_abstractcs_get_progbufsize(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "progbufsize",
			.lsb = 0x18,
			.msb = 0x1c,
			.values = NULL
		},
		.get_next = dm_abstractcs_get_cmderr
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_abstractcs_get_busy(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "busy",
			.lsb = 0xc,
			.msb = 0xc,
			.values = dm_abstractcs_busy_values
		},
		.get_next = dm_abstractcs_get_progbufsize
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_abstractcs_get_relaxedpriv(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "relaxedpriv",
			.lsb = 0xb,
			.msb = 0xb,
			.values = dm_abstractcs_relaxedpriv_values
		},
		.get_next = dm_abstractcs_get_busy
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_abstractcs_get_datacount(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "datacount",
			.lsb = 0,
			.msb = 3,
			.values = NULL
		},
		.get_next = dm_abstractcs_get_relaxedpriv
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_command_get_cmdtype(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "cmdtype",
			.lsb = 0x18,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_command_get_control(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "control",
			.lsb = 0,
			.msb = 0x17,
			.values = NULL
		},
		.get_next = dm_command_get_cmdtype
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_abstractauto_get_autoexecprogbuf(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "autoexecprogbuf",
			.lsb = 0x10,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_abstractauto_get_autoexecdata(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "autoexecdata",
			.lsb = 0,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = dm_abstractauto_get_autoexecprogbuf
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_confstrptr0_get_addr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "addr",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_confstrptr1_get_addr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "addr",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_confstrptr2_get_addr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "addr",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_confstrptr3_get_addr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "addr",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_nextdm_get_addr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "addr",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_data0_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_progbuf0_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_authdata_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *dm_dmcs2_grouptype_values[2] = {
	[0] = "halt",
	[1] = "resume"
};
static const char *dm_dmcs2_hgselect_values[2] = {
	[0] = "harts",
	[1] = "triggers"
};
static riscv_debug_reg_field_list_t dm_dmcs2_get_dmexttrigger(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "dmexttrigger",
			.lsb = 7,
			.msb = 0xa,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcs2_get_group(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "group",
			.lsb = 2,
			.msb = 6,
			.values = NULL
		},
		.get_next = dm_dmcs2_get_dmexttrigger
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcs2_get_grouptype(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "grouptype",
			.lsb = 0xb,
			.msb = 0xb,
			.values = dm_dmcs2_grouptype_values
		},
		.get_next = dm_dmcs2_get_group
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcs2_get_hgwrite(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hgwrite",
			.lsb = 1,
			.msb = 1,
			.values = NULL
		},
		.get_next = dm_dmcs2_get_grouptype
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_dmcs2_get_hgselect(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "hgselect",
			.lsb = 0,
			.msb = 0,
			.values = dm_dmcs2_hgselect_values
		},
		.get_next = dm_dmcs2_get_hgwrite
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_haltsum0_get_haltsum0(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "haltsum0",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_haltsum1_get_haltsum1(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "haltsum1",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_haltsum2_get_haltsum2(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "haltsum2",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_haltsum3_get_haltsum3(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "haltsum3",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *dm_sbcs_sbversion_values[8] = {
	[0] = "legacy",
	[1] = "1_0"
};
static const char *dm_sbcs_sbaccess_values[8] = {
	[0] = "8bit",
	[1] = "16bit",
	[2] = "32bit",
	[3] = "64bit",
	[4] = "128bit"
};
static const char *dm_sbcs_sberror_values[8] = {
	[0] = "none",
	[1] = "timeout",
	[2] = "address",
	[3] = "alignment",
	[4] = "size",
	[7] = "other"
};
static riscv_debug_reg_field_list_t dm_sbcs_get_sbasize(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbasize",
			.lsb = 5,
			.msb = 0xb,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbaccess128(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbaccess128",
			.lsb = 4,
			.msb = 4,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbasize
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbaccess64(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbaccess64",
			.lsb = 3,
			.msb = 3,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbaccess128
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbversion(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbversion",
			.lsb = 0x1d,
			.msb = 0x1f,
			.values = dm_sbcs_sbversion_values
		},
		.get_next = dm_sbcs_get_sbaccess64
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbbusyerror(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbbusyerror",
			.lsb = 0x16,
			.msb = 0x16,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbversion
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbbusy(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbbusy",
			.lsb = 0x15,
			.msb = 0x15,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbbusyerror
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbreadonaddr(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbreadonaddr",
			.lsb = 0x14,
			.msb = 0x14,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbbusy
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbaccess32(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbaccess32",
			.lsb = 2,
			.msb = 2,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbreadonaddr
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbaccess(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbaccess",
			.lsb = 0x11,
			.msb = 0x13,
			.values = dm_sbcs_sbaccess_values
		},
		.get_next = dm_sbcs_get_sbaccess32
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbautoincrement(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbautoincrement",
			.lsb = 0x10,
			.msb = 0x10,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbaccess
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbreadondata(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbreadondata",
			.lsb = 0xf,
			.msb = 0xf,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbautoincrement
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sberror(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sberror",
			.lsb = 0xc,
			.msb = 0xe,
			.values = dm_sbcs_sberror_values
		},
		.get_next = dm_sbcs_get_sbreadondata
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbaccess16(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbaccess16",
			.lsb = 1,
			.msb = 1,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sberror
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbcs_get_sbaccess8(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "sbaccess8",
			.lsb = 0,
			.msb = 0,
			.values = NULL
		},
		.get_next = dm_sbcs_get_sbaccess16
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbaddress0_get_address(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "address",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbaddress1_get_address(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "address",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbaddress2_get_address(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "address",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbaddress3_get_address(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "address",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbdata0_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbdata1_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbdata2_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t dm_sbdata3_get_data(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "data",
			.lsb = 0,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t shortname_get_field(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "field",
			.lsb = 0,
			.msb = 7,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *ac_access_register_aarsize_values[8] = {
	[2] = "32bit",
	[3] = "64bit",
	[4] = "128bit"
};
static const char *ac_access_register_aarpostincrement_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static const char *ac_access_register_postexec_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static const char *ac_access_register_transfer_values[2] = {
	[0] = "disabled",
	[1] = "enabled"
};
static const char *ac_access_register_write_values[2] = {
	[0] = "arg0",
	[1] = "register"
};
static riscv_debug_reg_field_list_t ac_access_register_get_cmdtype(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "cmdtype",
			.lsb = 0x18,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_register_get_aarsize(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "aarsize",
			.lsb = 0x14,
			.msb = 0x16,
			.values = ac_access_register_aarsize_values
		},
		.get_next = ac_access_register_get_cmdtype
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_register_get_aarpostincrement(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "aarpostincrement",
			.lsb = 0x13,
			.msb = 0x13,
			.values = ac_access_register_aarpostincrement_values
		},
		.get_next = ac_access_register_get_aarsize
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_register_get_postexec(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "postexec",
			.lsb = 0x12,
			.msb = 0x12,
			.values = ac_access_register_postexec_values
		},
		.get_next = ac_access_register_get_aarpostincrement
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_register_get_transfer(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "transfer",
			.lsb = 0x11,
			.msb = 0x11,
			.values = ac_access_register_transfer_values
		},
		.get_next = ac_access_register_get_postexec
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_register_get_write(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "write",
			.lsb = 0x10,
			.msb = 0x10,
			.values = ac_access_register_write_values
		},
		.get_next = ac_access_register_get_transfer
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_register_get_regno(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "regno",
			.lsb = 0,
			.msb = 0xf,
			.values = NULL
		},
		.get_next = ac_access_register_get_write
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_quick_access_get_cmdtype(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "cmdtype",
			.lsb = 0x18,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static const char *ac_access_memory_aamvirtual_values[2] = {
	[0] = "physical",
	[1] = "virtual"
};
static const char *ac_access_memory_aamsize_values[8] = {
	[0] = "8bit",
	[1] = "16bit",
	[2] = "32bit",
	[3] = "64bit",
	[4] = "128bit"
};
static const char *ac_access_memory_write_values[2] = {
	[0] = "arg0",
	[1] = "memory"
};
static riscv_debug_reg_field_list_t ac_access_memory_get_cmdtype(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "cmdtype",
			.lsb = 0x18,
			.msb = 0x1f,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_memory_get_aamvirtual(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "aamvirtual",
			.lsb = 0x17,
			.msb = 0x17,
			.values = ac_access_memory_aamvirtual_values
		},
		.get_next = ac_access_memory_get_cmdtype
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_memory_get_aamsize(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "aamsize",
			.lsb = 0x14,
			.msb = 0x16,
			.values = ac_access_memory_aamsize_values
		},
		.get_next = ac_access_memory_get_aamvirtual
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_memory_get_aampostincrement(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "aampostincrement",
			.lsb = 0x13,
			.msb = 0x13,
			.values = NULL
		},
		.get_next = ac_access_memory_get_aamsize
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_memory_get_write(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "write",
			.lsb = 0x10,
			.msb = 0x10,
			.values = ac_access_memory_write_values
		},
		.get_next = ac_access_memory_get_aampostincrement
	};
	return result;
}

static riscv_debug_reg_field_list_t ac_access_memory_get_target_specific(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "target-specific",
			.lsb = 0xe,
			.msb = 0xf,
			.values = NULL
		},
		.get_next = ac_access_memory_get_write
	};
	return result;
}

static riscv_debug_reg_field_list_t virt_priv_get_v(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "v",
			.lsb = 2,
			.msb = 2,
			.values = NULL
		},
		.get_next = NULL
	};
	return result;
}

static riscv_debug_reg_field_list_t virt_priv_get_prv(riscv_debug_reg_ctx_t context)
{
	riscv_debug_reg_field_list_t result = {
		.field = {
			.name = "prv",
			.lsb = 0,
			.msb = 1,
			.values = NULL
		},
		.get_next = virt_priv_get_v
	};
	return result;
}

riscv_debug_reg_info_t get_riscv_debug_reg_info(enum riscv_debug_reg_ordinal reg_ordinal)
{
	static const riscv_debug_reg_info_t debug_reg_info[] = {
		[DTM_IDCODE_ORDINAL] = {
			.name = "idcode",
			.get_fields_head = dtm_idcode_get_1
		},
		[DTM_DTMCS_ORDINAL] = {
			.name = "dtmcs",
			.get_fields_head = dtm_dtmcs_get_version
		},
		[DTM_DMI_ORDINAL] = {
			.name = "dmi",
			.get_fields_head = dtm_dmi_get_op
		},
		[DTM_BYPASS_ORDINAL] = {
			.name = "bypass",
			.get_fields_head = NULL
		},
		[CSR_DCSR_ORDINAL] = {
			.name = "dcsr",
			.get_fields_head = csr_dcsr_get_prv
		},
		[CSR_DPC_ORDINAL] = {
			.name = "dpc",
			.get_fields_head = csr_dpc_get_dpc
		},
		[CSR_DSCRATCH0_ORDINAL] = {
			.name = "dscratch0",
			.get_fields_head = csr_dscratch0_get_dscratch0
		},
		[CSR_DSCRATCH1_ORDINAL] = {
			.name = "dscratch1",
			.get_fields_head = csr_dscratch1_get_dscratch1
		},
		[CSR_TSELECT_ORDINAL] = {
			.name = "tselect",
			.get_fields_head = csr_tselect_get_index
		},
		[CSR_TDATA1_ORDINAL] = {
			.name = "tdata1",
			.get_fields_head = csr_tdata1_get_data
		},
		[CSR_TDATA2_ORDINAL] = {
			.name = "tdata2",
			.get_fields_head = csr_tdata2_get_data
		},
		[CSR_TDATA3_ORDINAL] = {
			.name = "tdata3",
			.get_fields_head = csr_tdata3_get_data
		},
		[CSR_TINFO_ORDINAL] = {
			.name = "tinfo",
			.get_fields_head = csr_tinfo_get_info
		},
		[CSR_TCONTROL_ORDINAL] = {
			.name = "tcontrol",
			.get_fields_head = csr_tcontrol_get_mte
		},
		[CSR_SCONTEXT_ORDINAL] = {
			.name = "scontext",
			.get_fields_head = csr_scontext_get_data
		},
		[CSR_MCONTEXT_ORDINAL] = {
			.name = "mcontext",
			.get_fields_head = csr_mcontext_get_hcontext
		},
		[CSR_MCONTROL_ORDINAL] = {
			.name = "mcontrol",
			.get_fields_head = csr_mcontrol_get_load
		},
		[CSR_MCONTROL6_ORDINAL] = {
			.name = "mcontrol6",
			.get_fields_head = csr_mcontrol6_get_load
		},
		[CSR_ICOUNT_ORDINAL] = {
			.name = "icount",
			.get_fields_head = csr_icount_get_action
		},
		[CSR_ITRIGGER_ORDINAL] = {
			.name = "itrigger",
			.get_fields_head = csr_itrigger_get_action
		},
		[CSR_ETRIGGER_ORDINAL] = {
			.name = "etrigger",
			.get_fields_head = csr_etrigger_get_action
		},
		[CSR_TMEXTTRIGGER_ORDINAL] = {
			.name = "tmexttrigger",
			.get_fields_head = csr_tmexttrigger_get_action
		},
		[CSR_TEXTRA32_ORDINAL] = {
			.name = "textra32",
			.get_fields_head = csr_textra32_get_sselect
		},
		[CSR_TEXTRA64_ORDINAL] = {
			.name = "textra64",
			.get_fields_head = csr_textra64_get_sselect
		},
		[DM_DMSTATUS_ORDINAL] = {
			.name = "dmstatus",
			.get_fields_head = dm_dmstatus_get_version
		},
		[DM_DMCONTROL_ORDINAL] = {
			.name = "dmcontrol",
			.get_fields_head = dm_dmcontrol_get_dmactive
		},
		[DM_HARTINFO_ORDINAL] = {
			.name = "hartinfo",
			.get_fields_head = dm_hartinfo_get_dataaddr
		},
		[DM_HAWINDOWSEL_ORDINAL] = {
			.name = "hawindowsel",
			.get_fields_head = dm_hawindowsel_get_hawindowsel
		},
		[DM_HAWINDOW_ORDINAL] = {
			.name = "hawindow",
			.get_fields_head = dm_hawindow_get_maskdata
		},
		[DM_ABSTRACTCS_ORDINAL] = {
			.name = "abstractcs",
			.get_fields_head = dm_abstractcs_get_datacount
		},
		[DM_COMMAND_ORDINAL] = {
			.name = "command",
			.get_fields_head = dm_command_get_control
		},
		[DM_ABSTRACTAUTO_ORDINAL] = {
			.name = "abstractauto",
			.get_fields_head = dm_abstractauto_get_autoexecdata
		},
		[DM_CONFSTRPTR0_ORDINAL] = {
			.name = "confstrptr0",
			.get_fields_head = dm_confstrptr0_get_addr
		},
		[DM_CONFSTRPTR1_ORDINAL] = {
			.name = "confstrptr1",
			.get_fields_head = dm_confstrptr1_get_addr
		},
		[DM_CONFSTRPTR2_ORDINAL] = {
			.name = "confstrptr2",
			.get_fields_head = dm_confstrptr2_get_addr
		},
		[DM_CONFSTRPTR3_ORDINAL] = {
			.name = "confstrptr3",
			.get_fields_head = dm_confstrptr3_get_addr
		},
		[DM_NEXTDM_ORDINAL] = {
			.name = "nextdm",
			.get_fields_head = dm_nextdm_get_addr
		},
		[DM_DATA0_ORDINAL] = {
			.name = "data0",
			.get_fields_head = dm_data0_get_data
		},
		[DM_PROGBUF0_ORDINAL] = {
			.name = "progbuf0",
			.get_fields_head = dm_progbuf0_get_data
		},
		[DM_AUTHDATA_ORDINAL] = {
			.name = "authdata",
			.get_fields_head = dm_authdata_get_data
		},
		[DM_DMCS2_ORDINAL] = {
			.name = "dmcs2",
			.get_fields_head = dm_dmcs2_get_hgselect
		},
		[DM_HALTSUM0_ORDINAL] = {
			.name = "haltsum0",
			.get_fields_head = dm_haltsum0_get_haltsum0
		},
		[DM_HALTSUM1_ORDINAL] = {
			.name = "haltsum1",
			.get_fields_head = dm_haltsum1_get_haltsum1
		},
		[DM_HALTSUM2_ORDINAL] = {
			.name = "haltsum2",
			.get_fields_head = dm_haltsum2_get_haltsum2
		},
		[DM_HALTSUM3_ORDINAL] = {
			.name = "haltsum3",
			.get_fields_head = dm_haltsum3_get_haltsum3
		},
		[DM_SBCS_ORDINAL] = {
			.name = "sbcs",
			.get_fields_head = dm_sbcs_get_sbaccess8
		},
		[DM_SBADDRESS0_ORDINAL] = {
			.name = "sbaddress0",
			.get_fields_head = dm_sbaddress0_get_address
		},
		[DM_SBADDRESS1_ORDINAL] = {
			.name = "sbaddress1",
			.get_fields_head = dm_sbaddress1_get_address
		},
		[DM_SBADDRESS2_ORDINAL] = {
			.name = "sbaddress2",
			.get_fields_head = dm_sbaddress2_get_address
		},
		[DM_SBADDRESS3_ORDINAL] = {
			.name = "sbaddress3",
			.get_fields_head = dm_sbaddress3_get_address
		},
		[DM_SBDATA0_ORDINAL] = {
			.name = "sbdata0",
			.get_fields_head = dm_sbdata0_get_data
		},
		[DM_SBDATA1_ORDINAL] = {
			.name = "sbdata1",
			.get_fields_head = dm_sbdata1_get_data
		},
		[DM_SBDATA2_ORDINAL] = {
			.name = "sbdata2",
			.get_fields_head = dm_sbdata2_get_data
		},
		[DM_SBDATA3_ORDINAL] = {
			.name = "sbdata3",
			.get_fields_head = dm_sbdata3_get_data
		},
		[SHORTNAME_ORDINAL] = {
			.name = "shortname",
			.get_fields_head = shortname_get_field
		},
		[AC_ACCESS_REGISTER_ORDINAL] = {
			.name = "access register",
			.get_fields_head = ac_access_register_get_regno
		},
		[AC_QUICK_ACCESS_ORDINAL] = {
			.name = "quick access",
			.get_fields_head = ac_quick_access_get_cmdtype
		},
		[AC_ACCESS_MEMORY_ORDINAL] = {
			.name = "access memory",
			.get_fields_head = ac_access_memory_get_target_specific
		},
		[VIRT_PRIV_ORDINAL] = {
			.name = "priv",
			.get_fields_head = virt_priv_get_prv
		},
	};
	return debug_reg_info[reg_ordinal];
}
