#include <stdio.h>
#include <glib.h>
#include <X11/Xlib.h>

#define MAX_ICON 36
#define MIN_ICON 16

#define DEFAULT_SES "LXDE-pi"

static int icon_size, barpos;

static void load_lxpanel_settings (void)
{
	const char *session_name;
	const char * const *sys_dirs;
	char *user_config_file;
	char linbuf[256], posbuf[16];
	FILE *fp;
	int val;

	// construct the file path
	session_name = g_getenv ("DESKTOP_SESSION");
	if (!session_name) session_name = DEFAULT_SES;
	user_config_file = g_build_filename (g_get_user_config_dir (), "lxpanel/", session_name, "/panels/panel", NULL);

	// open the file
	fp = fopen (user_config_file, "rb");
	g_free (user_config_file);
	if (!fp) 
	{
	    // set defaults if not read from file
	    icon_size = MAX_ICON;
	    barpos = 0;
	    return;
    }
    
	// read data from the file
	barpos = 0;
	while (1)
	{
		if (!fgets (linbuf, 256, fp)) break;
		if (sscanf (linbuf, "%*[ \t]iconsize=%d", &val) == 1) icon_size = val;
		if (sscanf (linbuf, "%*[ \t]edge=%s", posbuf) == 1)
		{
			if (!strcmp (posbuf, "bottom")) barpos = 1;
		}
	}
	fclose (fp);
}

void main (void)
{
    int x, y;
    unsigned int w, h, d, b;
    Window root;
    
    // read in the taskbar position and size
    load_lxpanel_settings ();

    // get the screen dimensions
	Display *xdisplay = XOpenDisplay (NULL);
	XGetGeometry (xdisplay, DefaultRootWindow (xdisplay), &root, &x, &y, &w, &h, &b, &d);
	
	// set the pointer position to the corner of the launch menu button
	x = icon_size + 2;
	y = icon_size - 2;
	if (barpos == 1) y = h - y;
	XWarpPointer (xdisplay, 0, root, 0, 0, 0, 0, x, y);
	
	XCloseDisplay (xdisplay);
}
