/**
 * Copyright (c) 2020-2022 Hailo Technologies Ltd. All rights reserved.
 * Distributed under the MIT license (https://opensource.org/licenses/MIT)
 **/
/**
 * @file string_utils.hpp
 * @brief Defines utilities methods for string.
 **/

#ifndef _HAILO_STRING_UTILS_HPP_
#define _HAILO_STRING_UTILS_HPP_

#include "hailo/expected.hpp"
#include <string>
#include <algorithm>

namespace hailort
{

class StringUtils {
public:
    static Expected<int32_t> to_int32(const std::string &str, int base);
    static Expected<uint8_t> to_uint8(const std::string &str, int base);
    static Expected<uint32_t> to_uint32(const std::string &str, int base);

    static std::string to_lower(const std::string &str)
    {
        std::string lower_str = str;
        std::transform(lower_str.begin(), lower_str.end(), lower_str.begin(),
            [](auto ch) { return static_cast<char>(::tolower(ch)); });
        return lower_str;
    }

    static std::string to_hex_string(const uint8_t *array, size_t size, bool uppercase, const std::string &delimiter="");
};

} /* namespace hailort */

#endif /* _HAILO_STRING_UTILS_HPP_ */
