# RPI-ANALYSE-BOOT.SERVICE(8)

## NAME
rpi-analyse-boot.service, rpi-analyse-boot - Boot analysis service

## SYNOPSIS
rpi-analyse-boot.service

/sbin/rpi-analyse-boot

## DESCRIPTION
rpi-analyse-boot is a system service that gathers boot-up performance
information and collates it into a single report shortly after boot.

A variety of information sources are used including data generated by
`systemd-analyze`(1), and `rpi-trace-boot.service`(8) (if installed/available).

The service also collects Pressure Stall Information (PSI) statistics if
available. PSI provides insights into resource contention (CPU, memory, and I/O)
during the boot process. Note that PSI may not be available by default on all
systems. To ensure PSI data is collected, add `psi=1` to
`/boot/firmware/cmdline.txt`.

## FILES
__/run/rpi-analyse-boot.service/index.html__
: The boot-up analysis report generated by the service.

## SEE ALSO
`systemd-analyze`(1), `rpi-trace-boot.service`(8)
