#!/bin/bash
# Configure build with AddressSanitizer
set -e
cd "$(dirname "$0")/.."

meson setup builddir-asan \
    --buildtype=debug \
    -Db_sanitize=address \
    -Db_lundef=false \
    "$@"

echo ""
echo "Build with: meson compile -C builddir-asan"
echo "Run with:   ASAN_OPTIONS=detect_leaks=1 ./builddir-asan/rpi-modcopy ..."
