/* annotation.c generated by valac 0.24.0, the Vala compiler
 * generated from annotation.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: annotation.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ANNOTATION (annotation_get_type ())
#define ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANNOTATION, Annotation))
#define ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANNOTATION, AnnotationClass))
#define IS_ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANNOTATION))
#define IS_ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANNOTATION))
#define ANNOTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANNOTATION, AnnotationClass))

typedef struct _Annotation Annotation;
typedef struct _AnnotationClass AnnotationClass;
typedef struct _AnnotationPrivate AnnotationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _annotation_unref0(var) ((var == NULL) ? NULL : (var = (annotation_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _ParamSpecAnnotation ParamSpecAnnotation;

/**
 * Annotation load from file errors.
 */
typedef enum  {
	ANNOTATION_LOAD_ERROR_EMPTY
} AnnotationLoadError;
#define ANNOTATION_LOAD_ERROR annotation_load_error_quark ()
struct _Annotation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AnnotationPrivate * priv;
	gint xPosition;
	gint yPosition;
	gchar* _text;
	gdouble _fontSize;
	gint width;
	gint height;
	gboolean selected;
};

struct _AnnotationClass {
	GTypeClass parent_class;
	void (*finalize) (Annotation *self);
};

struct _ParamSpecAnnotation {
	GParamSpec parent_instance;
};


static gpointer annotation_parent_class = NULL;

GQuark annotation_load_error_quark (void);
gpointer annotation_ref (gpointer instance);
void annotation_unref (gpointer instance);
GParamSpec* param_spec_annotation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_annotation (GValue* value, gpointer v_object);
void value_take_annotation (GValue* value, gpointer v_object);
gpointer value_get_annotation (const GValue* value);
GType annotation_get_type (void) G_GNUC_CONST;
enum  {
	ANNOTATION_DUMMY_PROPERTY
};
Annotation* annotation_new (gint x, gint y, const gchar* text, gdouble fontSize);
Annotation* annotation_construct (GType object_type, gint x, gint y, const gchar* text, gdouble fontSize);
void annotation_set_text (Annotation* self, const gchar* value);
void annotation_set_fontSize (Annotation* self, gdouble value);
Annotation* annotation_new_load (xmlNode* xmlnode, GError** error);
Annotation* annotation_construct_load (GType object_type, xmlNode* xmlnode, GError** error);
const gchar* annotation_get_text (Annotation* self);
gint annotation_find (Annotation* self, gint x, gint y);
void annotation_move (Annotation* self, gint x, gint y, gboolean ignoreSelect);
void annotation_try_select (Annotation* self, gint x, gint y, gboolean toggle);
void annotation_save (Annotation* self, xmlTextWriter* xmlWriter);
gdouble annotation_get_fontSize (Annotation* self);
void annotation_calculate_size (Annotation* self);
void annotation_render (Annotation* self, cairo_t* context, gboolean showHints);
static void annotation_finalize (Annotation* obj);


GQuark annotation_load_error_quark (void) {
	return g_quark_from_static_string ("annotation_load_error-quark");
}


/**
 * Construct an annotation at (//x//, //y//) with text //text// of
 * font size //fontSize//.
 */
Annotation* annotation_construct (GType object_type, gint x, gint y, const gchar* text, gdouble fontSize) {
	Annotation* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (text != NULL, NULL);
	self = (Annotation*) g_type_create_instance (object_type);
	_tmp0_ = x;
	self->xPosition = _tmp0_;
	_tmp1_ = y;
	self->yPosition = _tmp1_;
	_tmp2_ = text;
	annotation_set_text (self, _tmp2_);
	_tmp3_ = fontSize;
	annotation_set_fontSize (self, _tmp3_);
	return self;
}


Annotation* annotation_new (gint x, gint y, const gchar* text, gdouble fontSize) {
	return annotation_construct (TYPE_ANNOTATION, x, y, text, fontSize);
}


/**
 * Load an annotation from a file using libxml.
 * Throws AnnotationLoadError.EMPTY when the text is empty.
 */
static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


Annotation* annotation_construct_load (GType object_type, xmlNode* xmlnode, GError** error) {
	Annotation* self = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Annotation*) g_type_create_instance (object_type);
	self->xPosition = 0;
	self->yPosition = 0;
	annotation_set_text (self, "");
	annotation_set_fontSize (self, (gdouble) 12);
	{
		xmlAttr* xmlattr = NULL;
		xmlNode* _tmp0_ = NULL;
		xmlAttr* _tmp1_ = NULL;
		_tmp0_ = xmlnode;
		_tmp1_ = _tmp0_->properties;
		xmlattr = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp5_ = NULL;
				xmlAttr* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				GQuark _tmp10_ = 0U;
				static GQuark _tmp9_label0 = 0;
				static GQuark _tmp9_label1 = 0;
				static GQuark _tmp9_label2 = 0;
				static GQuark _tmp9_label3 = 0;
				if (!_tmp2_) {
					xmlAttr* _tmp3_ = NULL;
					xmlAttr* _tmp4_ = NULL;
					_tmp3_ = xmlattr;
					_tmp4_ = _tmp3_->next;
					xmlattr = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = xmlattr;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = xmlattr;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = _tmp7_;
				_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
				if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("x")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp11_ = NULL;
							xmlNode* _tmp12_ = NULL;
							const gchar* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							_tmp11_ = xmlattr;
							_tmp12_ = _tmp11_->children;
							_tmp13_ = _tmp12_->content;
							_tmp14_ = atoi (_tmp13_);
							self->xPosition = _tmp14_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("y")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp15_ = NULL;
							xmlNode* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							_tmp15_ = xmlattr;
							_tmp16_ = _tmp15_->children;
							_tmp17_ = _tmp16_->content;
							_tmp18_ = atoi (_tmp17_);
							self->yPosition = _tmp18_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("text")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp19_ = NULL;
							xmlNode* _tmp20_ = NULL;
							const gchar* _tmp21_ = NULL;
							_tmp19_ = xmlattr;
							_tmp20_ = _tmp19_->children;
							_tmp21_ = _tmp20_->content;
							annotation_set_text (self, _tmp21_);
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("fontsize")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp22_ = NULL;
							xmlNode* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
							gdouble _tmp25_ = 0.0;
							_tmp22_ = xmlattr;
							_tmp23_ = _tmp22_->children;
							_tmp24_ = _tmp23_->content;
							_tmp25_ = double_parse (_tmp24_);
							annotation_set_fontSize (self, _tmp25_);
							break;
						}
					}
				}
			}
		}
	}
	_tmp26_ = annotation_get_text (self);
	_tmp27_ = _tmp26_;
	if (g_strcmp0 (_tmp27_, "") == 0) {
		GError* _tmp28_ = NULL;
		_tmp28_ = g_error_new_literal (ANNOTATION_LOAD_ERROR, ANNOTATION_LOAD_ERROR_EMPTY, "The annotation has no text.");
		_inner_error_ = _tmp28_;
		if (_inner_error_->domain == ANNOTATION_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_annotation_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


Annotation* annotation_new_load (xmlNode* xmlnode, GError** error) {
	return annotation_construct_load (TYPE_ANNOTATION, xmlnode, error);
}


/**
 * Returns 1 if the annotation is on the point (//x//, //y//).
 */
gint annotation_find (Annotation* self, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp3_ = x;
	_tmp4_ = self->xPosition;
	if (_tmp3_ >= _tmp4_) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp5_ = x;
		_tmp6_ = self->xPosition;
		_tmp7_ = self->width;
		_tmp2_ = _tmp5_ <= (_tmp6_ + _tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = y;
		_tmp9_ = self->yPosition;
		_tmp1_ = _tmp8_ >= _tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp10_ = y;
		_tmp11_ = self->yPosition;
		_tmp12_ = self->height;
		_tmp0_ = _tmp10_ <= (_tmp11_ + _tmp12_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}


/**
 * Translates the annotation //x// right, //y// down.
 * If //ignoreSelect// is true, it will move without being selected.
 */
void annotation_move (Annotation* self, gint x, gint y, gboolean ignoreSelect) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = ignoreSelect;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->selected;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp3_ = self->xPosition;
		_tmp4_ = x;
		self->xPosition = _tmp3_ + _tmp4_;
		_tmp5_ = self->yPosition;
		_tmp6_ = y;
		self->yPosition = _tmp5_ + _tmp6_;
	}
}


/**
 * Selects if the annotation is on the point (//x//, //y//), else it
 * deselects.
 * If //toggle// is true, it toggles if on (//x//, //y//) instead.
 */
void annotation_try_select (Annotation* self, gint x, gint y, gboolean toggle) {
	gboolean affect = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp3_ = x;
	_tmp4_ = self->xPosition;
	if (_tmp3_ >= _tmp4_) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp5_ = x;
		_tmp6_ = self->xPosition;
		_tmp7_ = self->width;
		_tmp2_ = _tmp5_ <= (_tmp6_ + _tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = y;
		_tmp9_ = self->yPosition;
		_tmp1_ = _tmp8_ >= _tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp10_ = y;
		_tmp11_ = self->yPosition;
		_tmp12_ = self->height;
		_tmp0_ = _tmp10_ <= (_tmp11_ + _tmp12_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		affect = TRUE;
	} else {
		affect = FALSE;
	}
	_tmp13_ = toggle;
	if (_tmp13_) {
		gboolean _tmp14_ = FALSE;
		_tmp14_ = affect;
		if (_tmp14_) {
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			_tmp16_ = self->selected;
			if (_tmp16_) {
				_tmp15_ = FALSE;
			} else {
				_tmp15_ = TRUE;
			}
			self->selected = _tmp15_;
		}
	} else {
		gboolean _tmp17_ = FALSE;
		_tmp17_ = affect;
		if (_tmp17_) {
			self->selected = TRUE;
		} else {
			self->selected = FALSE;
		}
	}
}


/**
 * Saves all information about the annotation to an xml document
 * using libxml.
 */
static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


void annotation_save (Annotation* self, xmlTextWriter* xmlWriter) {
	xmlTextWriter* _tmp0_ = NULL;
	xmlTextWriter* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	xmlTextWriter* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	xmlTextWriter* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	xmlTextWriter* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	xmlTextWriter* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (xmlWriter != NULL);
	_tmp0_ = xmlWriter;
	xmlTextWriterStartElement (_tmp0_, (xmlChar*) "annotation");
	_tmp1_ = xmlWriter;
	_tmp2_ = self->xPosition;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	xmlTextWriterWriteAttribute (_tmp1_, (xmlChar*) "x", (xmlChar*) _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = xmlWriter;
	_tmp6_ = self->yPosition;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	xmlTextWriterWriteAttribute (_tmp5_, (xmlChar*) "y", (xmlChar*) _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = xmlWriter;
	_tmp10_ = annotation_get_text (self);
	_tmp11_ = _tmp10_;
	xmlTextWriterWriteAttribute (_tmp9_, (xmlChar*) "text", (xmlChar*) _tmp11_);
	_tmp12_ = xmlWriter;
	_tmp13_ = annotation_get_fontSize (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = double_to_string (_tmp14_);
	_tmp16_ = _tmp15_;
	xmlTextWriterWriteAttribute (_tmp12_, (xmlChar*) "fontsize", (xmlChar*) _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = xmlWriter;
	xmlTextWriterEndElement (_tmp17_);
}


void annotation_calculate_size (Annotation* self) {
	cairo_text_extents_t textExtents = {0};
	cairo_surface_t* imageSurface = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* context = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	cairo_text_extents_t _tmp6_ = {0};
	cairo_text_extents_t _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	cairo_text_extents_t _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 0, 0);
	imageSurface = _tmp0_;
	_tmp1_ = cairo_create (imageSurface);
	context = _tmp1_;
	_tmp2_ = annotation_get_fontSize (self);
	_tmp3_ = _tmp2_;
	cairo_set_font_size (context, _tmp3_);
	_tmp4_ = annotation_get_text (self);
	_tmp5_ = _tmp4_;
	cairo_text_extents (context, _tmp5_, &_tmp6_);
	textExtents = _tmp6_;
	_tmp7_ = textExtents;
	_tmp8_ = _tmp7_.width;
	self->width = ((gint) _tmp8_) + 4;
	_tmp9_ = textExtents;
	_tmp10_ = _tmp9_.height;
	self->height = ((gint) _tmp10_) + 4;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (imageSurface);
}


/**
 * Renders the annotation onto the Cairo context passed.
 * If //showHints// is true, selection is shown as blue, and their
 * will be a small dot to mark the annotation's position.
 */
void annotation_render (Annotation* self, cairo_t* context, gboolean showHints) {
	cairo_text_extents_t textExtents = {0};
	cairo_matrix_t oldMatrix = {0};
	cairo_t* _tmp0_ = NULL;
	cairo_matrix_t _tmp1_ = {0};
	cairo_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp10_ = FALSE;
	cairo_t* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	cairo_t* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_ = NULL;
	cairo_text_extents_t _tmp27_ = {0};
	gdouble _tmp28_ = 0.0;
	cairo_t* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_matrix_t _tmp34_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	cairo_get_matrix (_tmp0_, &_tmp1_);
	oldMatrix = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = self->xPosition;
	_tmp4_ = self->yPosition;
	cairo_translate (_tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
	_tmp6_ = self->selected;
	if (_tmp6_) {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = showHints;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		cairo_t* _tmp8_ = NULL;
		_tmp8_ = context;
		cairo_set_source_rgb (_tmp8_, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	} else {
		cairo_t* _tmp9_ = NULL;
		_tmp9_ = context;
		cairo_set_source_rgb (_tmp9_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	}
	_tmp10_ = showHints;
	if (_tmp10_) {
		cairo_line_cap_t oldLineCap = 0;
		cairo_t* _tmp11_ = NULL;
		cairo_line_cap_t _tmp12_ = 0;
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		cairo_t* _tmp15_ = NULL;
		cairo_t* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		cairo_line_cap_t _tmp18_ = 0;
		_tmp11_ = context;
		_tmp12_ = cairo_get_line_cap (_tmp11_);
		oldLineCap = _tmp12_;
		_tmp13_ = context;
		cairo_set_line_cap (_tmp13_, CAIRO_LINE_CAP_ROUND);
		_tmp14_ = context;
		cairo_move_to (_tmp14_, (gdouble) 0, (gdouble) 0);
		_tmp15_ = context;
		cairo_line_to (_tmp15_, (gdouble) 0, (gdouble) 0);
		_tmp16_ = context;
		cairo_stroke (_tmp16_);
		_tmp17_ = context;
		_tmp18_ = oldLineCap;
		cairo_set_line_cap (_tmp17_, _tmp18_);
	}
	_tmp19_ = context;
	_tmp20_ = annotation_get_fontSize (self);
	_tmp21_ = _tmp20_;
	cairo_set_font_size (_tmp19_, _tmp21_);
	_tmp22_ = context;
	_tmp23_ = annotation_get_text (self);
	_tmp24_ = _tmp23_;
	cairo_text_extents (_tmp22_, _tmp24_, &_tmp25_);
	textExtents = _tmp25_;
	_tmp26_ = context;
	_tmp27_ = textExtents;
	_tmp28_ = _tmp27_.height;
	cairo_translate (_tmp26_, (gdouble) 2, _tmp28_ + 2);
	_tmp29_ = context;
	_tmp30_ = annotation_get_text (self);
	_tmp31_ = _tmp30_;
	cairo_show_text (_tmp29_, _tmp31_);
	_tmp32_ = context;
	cairo_stroke (_tmp32_);
	_tmp33_ = context;
	_tmp34_ = oldMatrix;
	cairo_set_matrix (_tmp33_, &_tmp34_);
}


const gchar* annotation_get_text (Annotation* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_text;
	result = _tmp0_;
	return result;
}


void annotation_set_text (Annotation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->_text);
	self->_text = _tmp1_;
	annotation_calculate_size (self);
}


gdouble annotation_get_fontSize (Annotation* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->_fontSize;
	result = _tmp0_;
	return result;
}


void annotation_set_fontSize (Annotation* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->_fontSize = _tmp0_;
	annotation_calculate_size (self);
}


static void value_annotation_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_annotation_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		annotation_unref (value->data[0].v_pointer);
	}
}


static void value_annotation_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = annotation_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_annotation_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_annotation_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Annotation* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = annotation_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_annotation_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Annotation** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = annotation_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_annotation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAnnotation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ANNOTATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_annotation (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ANNOTATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_annotation (GValue* value, gpointer v_object) {
	Annotation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ANNOTATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ANNOTATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		annotation_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		annotation_unref (old);
	}
}


void value_take_annotation (GValue* value, gpointer v_object) {
	Annotation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ANNOTATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ANNOTATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		annotation_unref (old);
	}
}


static void annotation_class_init (AnnotationClass * klass) {
	annotation_parent_class = g_type_class_peek_parent (klass);
	ANNOTATION_CLASS (klass)->finalize = annotation_finalize;
}


static void annotation_instance_init (Annotation * self) {
	self->selected = FALSE;
	self->ref_count = 1;
}


static void annotation_finalize (Annotation* obj) {
	Annotation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANNOTATION, Annotation);
	_g_free0 (self->_text);
}


/**
 * Design object which displays text.
 * 
 * Used to label a part of a circuit with user defined text. It has no
 * effect on the behaviour of the logic circuit. It's a comment.
 */
GType annotation_get_type (void) {
	static volatile gsize annotation_type_id__volatile = 0;
	if (g_once_init_enter (&annotation_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_annotation_init, value_annotation_free_value, value_annotation_copy_value, value_annotation_peek_pointer, "p", value_annotation_collect_value, "p", value_annotation_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AnnotationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) annotation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Annotation), 0, (GInstanceInitFunc) annotation_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType annotation_type_id;
		annotation_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Annotation", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&annotation_type_id__volatile, annotation_type_id);
	}
	return annotation_type_id__volatile;
}


gpointer annotation_ref (gpointer instance) {
	Annotation* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void annotation_unref (gpointer instance) {
	Annotation* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ANNOTATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



