/* circuitinformation.c generated by valac 0.24.0, the Vala compiler
 * generated from circuitinformation.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: circuitinformation.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;
typedef struct _CircuitInformationPrivate CircuitInformationPrivate;

#define CIRCUIT_INFORMATION_TYPE_COMPONENT_COUNT (circuit_information_component_count_get_type ())

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _CircuitInformationComponentCount CircuitInformationComponentCount;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;
#define _project_unref0(var) ((var == NULL) ? NULL : (var = (project_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ProjectPrivate ProjectPrivate;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecCircuitInformation ParamSpecCircuitInformation;

struct _CircuitInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CircuitInformationPrivate * priv;
};

struct _CircuitInformationClass {
	GTypeClass parent_class;
	void (*finalize) (CircuitInformation *self);
};

struct _CircuitInformationComponentCount {
	ComponentDef* componentDef;
	gint count;
};

struct _CircuitInformationPrivate {
	CircuitInformationComponentCount* componentCounts;
	gint componentCounts_length1;
	gint _componentCounts_size_;
	Project* project;
	gchar* _summary;
};

struct _Project {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectPrivate * priv;
	gboolean running;
	CustomComponentDef** customComponentDefs;
	gint customComponentDefs_length1;
	PluginComponentDef** pluginComponentDefs;
	gint pluginComponentDefs_length1;
	PluginComponentManager** pluginComponentManagers;
	gint pluginComponentManagers_length1;
	CustomComponentDef* rootComponent;
	gint myID;
	gchar* description;
	gchar* filename;
};

struct _ProjectClass {
	GTypeClass parent_class;
	void (*finalize) (Project *self);
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _ParamSpecCircuitInformation {
	GParamSpec parent_instance;
};


static gpointer circuit_information_parent_class = NULL;

gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
GType circuit_information_component_count_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
CircuitInformationComponentCount* circuit_information_component_count_dup (const CircuitInformationComponentCount* self);
void circuit_information_component_count_free (CircuitInformationComponentCount* self);
void circuit_information_component_count_copy (const CircuitInformationComponentCount* self, CircuitInformationComponentCount* dest);
void circuit_information_component_count_destroy (CircuitInformationComponentCount* self);
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
#define CIRCUIT_INFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CIRCUIT_INFORMATION, CircuitInformationPrivate))
enum  {
	CIRCUIT_INFORMATION_DUMMY_PROPERTY
};
static void _vala_CircuitInformationComponentCount_array_free (CircuitInformationComponentCount* array, gint array_length);
CircuitInformation* circuit_information_new (Project* project);
CircuitInformation* circuit_information_construct (GType object_type, Project* project);
static void circuit_information_set_summary (CircuitInformation* self, const gchar* value);
GType custom_component_def_get_type (void) G_GNUC_CONST;
GType plugin_component_def_get_type (void) G_GNUC_CONST;
gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
CustomComponentDef** custom_component_def_validate_dependencies (CustomComponentDef* self, CustomComponentDef** componentChain, int componentChain_length1, int* result_length1);
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
void component_def_create_information (ComponentDef* self, CircuitInformation* circuitInformation);
const gchar* circuit_information_get_summary (CircuitInformation* self);
void circuit_information_count_component (CircuitInformation* self, ComponentDef* componentDef);
static void _vala_array_add23 (CircuitInformationComponentCount** array, int* length, int* size, const CircuitInformationComponentCount* value);
static void circuit_information_finalize (CircuitInformation* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_CircuitInformationComponentCount_array_free (CircuitInformationComponentCount* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			circuit_information_component_count_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gpointer _project_ref0 (gpointer self) {
	return self ? project_ref (self) : NULL;
}


static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


CircuitInformation* circuit_information_construct (GType object_type, Project* project) {
	CircuitInformation* self = NULL;
	Project* _tmp0_ = NULL;
	Project* _tmp1_ = NULL;
	CircuitInformationComponentCount* _tmp2_ = NULL;
	Project* _tmp3_ = NULL;
	CustomComponentDef* _tmp4_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	self = (CircuitInformation*) g_type_create_instance (object_type);
	circuit_information_set_summary (self, "");
	_tmp0_ = project;
	_tmp1_ = _project_ref0 (_tmp0_);
	_project_unref0 (self->priv->project);
	self->priv->project = _tmp1_;
	_tmp2_ = g_new0 (CircuitInformationComponentCount, 0);
	self->priv->componentCounts = (_vala_CircuitInformationComponentCount_array_free (self->priv->componentCounts, self->priv->componentCounts_length1), NULL);
	self->priv->componentCounts = _tmp2_;
	self->priv->componentCounts_length1 = 0;
	self->priv->_componentCounts_size_ = self->priv->componentCounts_length1;
	_tmp3_ = project;
	_tmp4_ = _tmp3_->rootComponent;
	if (_tmp4_ != NULL) {
		CustomComponentDef** componentChain = NULL;
		Project* _tmp5_ = NULL;
		CustomComponentDef* _tmp6_ = NULL;
		CustomComponentDef** _tmp7_ = NULL;
		CustomComponentDef** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gint _tmp9_ = 0;
		CustomComponentDef** _tmp10_ = NULL;
		CustomComponentDef** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint componentChain_length1 = 0;
		gint _componentChain_size_ = 0;
		CustomComponentDef** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		Project* _tmp30_ = NULL;
		CustomComponentDef* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		CircuitInformationComponentCount* _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		_tmp5_ = project;
		_tmp6_ = _tmp5_->rootComponent;
		_tmp7_ = g_new0 (CustomComponentDef*, 0 + 1);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 0;
		_tmp10_ = custom_component_def_validate_dependencies (_tmp6_, _tmp8_, 0, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp9_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) component_def_unref), NULL);
		componentChain = _tmp11_;
		componentChain_length1 = _tmp11__length1;
		_componentChain_size_ = componentChain_length1;
		_tmp12_ = componentChain;
		_tmp12__length1 = componentChain_length1;
		if (_tmp12_ != NULL) {
			gchar* errorMessage = NULL;
			gchar* _tmp13_ = NULL;
			CustomComponentDef** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			GtkMessageDialog* messageDialog = NULL;
			const gchar* _tmp26_ = NULL;
			GtkMessageDialog* _tmp27_ = NULL;
			GtkMessageDialog* _tmp28_ = NULL;
			GtkMessageDialog* _tmp29_ = NULL;
			_tmp13_ = g_strdup ("Circuit failed cyclic dependency test. Failed ancestry:\n");
			errorMessage = _tmp13_;
			_tmp14_ = componentChain;
			_tmp14__length1 = componentChain_length1;
			{
				CustomComponentDef** customComponentDef_collection = NULL;
				gint customComponentDef_collection_length1 = 0;
				gint _customComponentDef_collection_size_ = 0;
				gint customComponentDef_it = 0;
				customComponentDef_collection = _tmp14_;
				customComponentDef_collection_length1 = _tmp14__length1;
				for (customComponentDef_it = 0; customComponentDef_it < _tmp14__length1; customComponentDef_it = customComponentDef_it + 1) {
					CustomComponentDef* _tmp15_ = NULL;
					CustomComponentDef* customComponentDef = NULL;
					_tmp15_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
					customComponentDef = _tmp15_;
					{
						const gchar* _tmp16_ = NULL;
						CustomComponentDef* _tmp17_ = NULL;
						const gchar* _tmp18_ = NULL;
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_ = NULL;
						_tmp16_ = errorMessage;
						_tmp17_ = customComponentDef;
						_tmp18_ = ((ComponentDef*) _tmp17_)->name;
						_tmp19_ = g_strconcat ("  ", _tmp18_, NULL);
						_tmp20_ = _tmp19_;
						_tmp21_ = g_strconcat (_tmp20_, ".\n", NULL);
						_tmp22_ = _tmp21_;
						_tmp23_ = g_strconcat (_tmp16_, _tmp22_, NULL);
						_g_free0 (errorMessage);
						errorMessage = _tmp23_;
						_g_free0 (_tmp22_);
						_g_free0 (_tmp20_);
						_component_def_unref0 (customComponentDef);
					}
				}
			}
			_tmp24_ = errorMessage;
			_tmp25_ = g_strconcat (_tmp24_, "\n" \
"For statistics to be created, your circuit must not contain any cyclic" \
" dependencies.", NULL);
			_g_free0 (errorMessage);
			errorMessage = _tmp25_;
			_tmp26_ = errorMessage;
			_tmp27_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not create project statistics:\n%s", _tmp26_);
			g_object_ref_sink (_tmp27_);
			messageDialog = _tmp27_;
			_tmp28_ = messageDialog;
			gtk_dialog_run ((GtkDialog*) _tmp28_);
			_tmp29_ = messageDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp29_);
			_g_object_unref0 (messageDialog);
			_g_free0 (errorMessage);
			componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
			return self;
		}
		_tmp30_ = project;
		_tmp31_ = _tmp30_->rootComponent;
		component_def_create_information ((ComponentDef*) _tmp31_, self);
		_tmp32_ = self->priv->_summary;
		_tmp33_ = g_strconcat (_tmp32_, "Total Component Counts:\n", NULL);
		_tmp34_ = _tmp33_;
		circuit_information_set_summary (self, _tmp34_);
		_g_free0 (_tmp34_);
		_tmp35_ = self->priv->componentCounts;
		_tmp35__length1 = self->priv->componentCounts_length1;
		{
			CircuitInformationComponentCount* componentCount_collection = NULL;
			gint componentCount_collection_length1 = 0;
			gint _componentCount_collection_size_ = 0;
			gint componentCount_it = 0;
			componentCount_collection = _tmp35_;
			componentCount_collection_length1 = _tmp35__length1;
			for (componentCount_it = 0; componentCount_it < _tmp35__length1; componentCount_it = componentCount_it + 1) {
				CircuitInformationComponentCount _tmp36_ = {0};
				CircuitInformationComponentCount componentCount = {0};
				circuit_information_component_count_copy (&componentCount_collection[componentCount_it], &_tmp36_);
				componentCount = _tmp36_;
				{
					const gchar* _tmp37_ = NULL;
					CircuitInformationComponentCount _tmp38_ = {0};
					ComponentDef* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					CircuitInformationComponentCount _tmp45_ = {0};
					gint _tmp46_ = 0;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					gchar* _tmp54_ = NULL;
					_tmp37_ = self->priv->_summary;
					_tmp38_ = componentCount;
					_tmp39_ = _tmp38_.componentDef;
					_tmp40_ = _tmp39_->name;
					_tmp41_ = g_strconcat ("  ", _tmp40_, NULL);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strconcat (_tmp42_, ": ", NULL);
					_tmp44_ = _tmp43_;
					_tmp45_ = componentCount;
					_tmp46_ = _tmp45_.count;
					_tmp47_ = g_strdup_printf ("%i", _tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strconcat (_tmp44_, _tmp48_, NULL);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strconcat (_tmp50_, "\n", NULL);
					_tmp52_ = _tmp51_;
					_tmp53_ = g_strconcat (_tmp37_, _tmp52_, NULL);
					_tmp54_ = _tmp53_;
					circuit_information_set_summary (self, _tmp54_);
					_g_free0 (_tmp54_);
					_g_free0 (_tmp52_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp44_);
					_g_free0 (_tmp42_);
					circuit_information_component_count_destroy (&componentCount);
				}
			}
		}
		componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
	} else {
		GtkMessageDialog* messageDialog = NULL;
		GtkMessageDialog* _tmp55_ = NULL;
		GtkMessageDialog* _tmp56_ = NULL;
		GtkMessageDialog* _tmp57_ = NULL;
		_tmp55_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "You cannot generate circuit statistics without a root component.");
		g_object_ref_sink (_tmp55_);
		messageDialog = _tmp55_;
		_tmp56_ = messageDialog;
		gtk_dialog_run ((GtkDialog*) _tmp56_);
		_tmp57_ = messageDialog;
		gtk_widget_destroy ((GtkWidget*) _tmp57_);
		_g_object_unref0 (messageDialog);
	}
	return self;
}


CircuitInformation* circuit_information_new (Project* project) {
	return circuit_information_construct (TYPE_CIRCUIT_INFORMATION, project);
}


static void _vala_array_add23 (CircuitInformationComponentCount** array, int* length, int* size, const CircuitInformationComponentCount* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CircuitInformationComponentCount, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


void circuit_information_count_component (CircuitInformation* self, ComponentDef* componentDef) {
	gint i = 0;
	gint _tmp12_ = 0;
	CircuitInformationComponentCount* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (componentDef != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_ = 0;
			CircuitInformationComponentCount* _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
			CircuitInformationComponentCount* _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			gint _tmp5_ = 0;
			CircuitInformationComponentCount _tmp6_ = {0};
			ComponentDef* _tmp7_ = NULL;
			ComponentDef* _tmp8_ = NULL;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = self->priv->componentCounts;
			_tmp3__length1 = self->priv->componentCounts_length1;
			if (!(_tmp2_ < _tmp3__length1)) {
				break;
			}
			_tmp4_ = self->priv->componentCounts;
			_tmp4__length1 = self->priv->componentCounts_length1;
			_tmp5_ = i;
			_tmp6_ = _tmp4_[_tmp5_];
			_tmp7_ = _tmp6_.componentDef;
			_tmp8_ = componentDef;
			if (_tmp7_ == _tmp8_) {
				CircuitInformationComponentCount* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				_tmp9_ = self->priv->componentCounts;
				_tmp9__length1 = self->priv->componentCounts_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_].count;
				_tmp9_[_tmp10_].count = _tmp11_ + 1;
				break;
			}
		}
	}
	_tmp12_ = i;
	_tmp13_ = self->priv->componentCounts;
	_tmp13__length1 = self->priv->componentCounts_length1;
	if (_tmp12_ == _tmp13__length1) {
		CircuitInformationComponentCount componentCount = {0};
		ComponentDef* _tmp14_ = NULL;
		ComponentDef* _tmp15_ = NULL;
		CircuitInformationComponentCount* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		CircuitInformationComponentCount _tmp17_ = {0};
		CircuitInformationComponentCount _tmp18_ = {0};
		memset (&componentCount, 0, sizeof (CircuitInformationComponentCount));
		_tmp14_ = componentDef;
		_tmp15_ = _component_def_ref0 (_tmp14_);
		_component_def_unref0 (componentCount.componentDef);
		componentCount.componentDef = _tmp15_;
		componentCount.count = 1;
		_tmp16_ = self->priv->componentCounts;
		_tmp16__length1 = self->priv->componentCounts_length1;
		_tmp17_ = componentCount;
		circuit_information_component_count_copy (&_tmp17_, &_tmp18_);
		_vala_array_add23 (&self->priv->componentCounts, &self->priv->componentCounts_length1, &self->priv->_componentCounts_size_, &_tmp18_);
		circuit_information_component_count_destroy (&componentCount);
	}
}


const gchar* circuit_information_get_summary (CircuitInformation* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary;
	result = _tmp0_;
	return result;
}


static void circuit_information_set_summary (CircuitInformation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_summary);
	self->priv->_summary = _tmp1_;
}


void circuit_information_component_count_copy (const CircuitInformationComponentCount* self, CircuitInformationComponentCount* dest) {
	ComponentDef* _tmp0_ = NULL;
	ComponentDef* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	_tmp0_ = (*self).componentDef;
	_tmp1_ = _component_def_ref0 (_tmp0_);
	_component_def_unref0 ((*dest).componentDef);
	(*dest).componentDef = _tmp1_;
	_tmp2_ = (*self).count;
	(*dest).count = _tmp2_;
}


void circuit_information_component_count_destroy (CircuitInformationComponentCount* self) {
	_component_def_unref0 ((*self).componentDef);
}


CircuitInformationComponentCount* circuit_information_component_count_dup (const CircuitInformationComponentCount* self) {
	CircuitInformationComponentCount* dup;
	dup = g_new0 (CircuitInformationComponentCount, 1);
	circuit_information_component_count_copy (self, dup);
	return dup;
}


void circuit_information_component_count_free (CircuitInformationComponentCount* self) {
	circuit_information_component_count_destroy (self);
	g_free (self);
}


GType circuit_information_component_count_get_type (void) {
	static volatile gsize circuit_information_component_count_type_id__volatile = 0;
	if (g_once_init_enter (&circuit_information_component_count_type_id__volatile)) {
		GType circuit_information_component_count_type_id;
		circuit_information_component_count_type_id = g_boxed_type_register_static ("CircuitInformationComponentCount", (GBoxedCopyFunc) circuit_information_component_count_dup, (GBoxedFreeFunc) circuit_information_component_count_free);
		g_once_init_leave (&circuit_information_component_count_type_id__volatile, circuit_information_component_count_type_id);
	}
	return circuit_information_component_count_type_id__volatile;
}


static void value_circuit_information_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_circuit_information_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		circuit_information_unref (value->data[0].v_pointer);
	}
}


static void value_circuit_information_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = circuit_information_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_circuit_information_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_circuit_information_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		CircuitInformation* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = circuit_information_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_circuit_information_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CircuitInformation** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = circuit_information_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCircuitInformation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CIRCUIT_INFORMATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_circuit_information (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CIRCUIT_INFORMATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_circuit_information (GValue* value, gpointer v_object) {
	CircuitInformation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CIRCUIT_INFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CIRCUIT_INFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		circuit_information_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		circuit_information_unref (old);
	}
}


void value_take_circuit_information (GValue* value, gpointer v_object) {
	CircuitInformation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CIRCUIT_INFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CIRCUIT_INFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		circuit_information_unref (old);
	}
}


static void circuit_information_class_init (CircuitInformationClass * klass) {
	circuit_information_parent_class = g_type_class_peek_parent (klass);
	CIRCUIT_INFORMATION_CLASS (klass)->finalize = circuit_information_finalize;
	g_type_class_add_private (klass, sizeof (CircuitInformationPrivate));
}


static void circuit_information_instance_init (CircuitInformation * self) {
	self->priv = CIRCUIT_INFORMATION_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void circuit_information_finalize (CircuitInformation* obj) {
	CircuitInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CIRCUIT_INFORMATION, CircuitInformation);
	self->priv->componentCounts = (_vala_CircuitInformationComponentCount_array_free (self->priv->componentCounts, self->priv->componentCounts_length1), NULL);
	_project_unref0 (self->priv->project);
	_g_free0 (self->priv->_summary);
}


GType circuit_information_get_type (void) {
	static volatile gsize circuit_information_type_id__volatile = 0;
	if (g_once_init_enter (&circuit_information_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_circuit_information_init, value_circuit_information_free_value, value_circuit_information_copy_value, value_circuit_information_peek_pointer, "p", value_circuit_information_collect_value, "p", value_circuit_information_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CircuitInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) circuit_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CircuitInformation), 0, (GInstanceInitFunc) circuit_information_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType circuit_information_type_id;
		circuit_information_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CircuitInformation", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&circuit_information_type_id__volatile, circuit_information_type_id);
	}
	return circuit_information_type_id__volatile;
}


gpointer circuit_information_ref (gpointer instance) {
	CircuitInformation* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void circuit_information_unref (gpointer instance) {
	CircuitInformation* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CIRCUIT_INFORMATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



