/* compiledcircuit.c generated by valac 0.24.0, the Vala compiler
 * generated from compiledcircuit.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: compiledcircuit.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;
typedef struct _CompiledCircuitPrivate CompiledCircuitPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_UPDATE_QUEUE (update_queue_get_type ())
#define UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPDATE_QUEUE, UpdateQueue))
#define UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UPDATE_QUEUE, UpdateQueueClass))
#define IS_UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPDATE_QUEUE))
#define IS_UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UPDATE_QUEUE))
#define UPDATE_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UPDATE_QUEUE, UpdateQueueClass))

typedef struct _UpdateQueue UpdateQueue;
typedef struct _UpdateQueueClass UpdateQueueClass;

#define TYPE_WIRE_STATE (wire_state_get_type ())
#define WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_STATE, WireState))
#define WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_STATE, WireStateClass))
#define IS_WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_STATE))
#define IS_WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_STATE))
#define WIRE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_STATE, WireStateClass))

typedef struct _WireState WireState;
typedef struct _WireStateClass WireStateClass;

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _project_unref0(var) ((var == NULL) ? NULL : (var = (project_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _update_queue_unref0(var) ((var == NULL) ? NULL : (var = (update_queue_unref (var), NULL)))
typedef struct _ProjectPrivate ProjectPrivate;

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
typedef struct _CustomComponentDefPrivate CustomComponentDefPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;

#define TYPE_ANNOTATION (annotation_get_type ())
#define ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANNOTATION, Annotation))
#define ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANNOTATION, AnnotationClass))
#define IS_ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANNOTATION))
#define IS_ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANNOTATION))
#define ANNOTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANNOTATION, AnnotationClass))

typedef struct _Annotation Annotation;
typedef struct _AnnotationClass AnnotationClass;
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))
typedef struct _WireInstPrivate WireInstPrivate;

#define WIRE_INST_TYPE_REGISTERED_COMPONENT (wire_inst_registered_component_get_type ())

#define WIRE_INST_TYPE_MARKER (wire_inst_marker_get_type ())
typedef struct _WireInstMarker WireInstMarker;
typedef struct _WireInstRegisteredComponent WireInstRegisteredComponent;

#define TYPE_PATH (path_get_type ())
#define PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH, Path))
#define PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH, PathClass))
#define IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH))
#define IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH))
#define PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH, PathClass))

typedef struct _Path Path;
typedef struct _PathClass PathClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define WIRE_INST_TYPE_PRESET_SIGNAL (wire_inst_preset_signal_get_type ())
typedef struct _TagPrivate TagPrivate;

#define TYPE_FLOW (flow_get_type ())
typedef struct _ConnectionPrivate ConnectionPrivate;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))
typedef struct _WireStatePrivate WireStatePrivate;
#define _wire_state_unref0(var) ((var == NULL) ? NULL : (var = (wire_state_unref (var), NULL)))
typedef struct _ComponentStatePrivate ComponentStatePrivate;
#define _path_unref0(var) ((var == NULL) ? NULL : (var = (path_unref (var), NULL)))
typedef struct _UpdateQueuePrivate UpdateQueuePrivate;
typedef struct _ParamSpecCompiledCircuit ParamSpecCompiledCircuit;

struct _CompiledCircuit {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompiledCircuitPrivate * priv;
	CustomComponentDef* rootComponent;
	Project* project;
	UpdateQueue* renderWireStates;
	UpdateQueue* renderComponentStates;
	UpdateQueue* processWireStates;
	UpdateQueue* processComponentStates;
	CustomComponentDef* viewedComponent;
	gint iterationCount;
};

struct _CompiledCircuitClass {
	GTypeClass parent_class;
	void (*finalize) (CompiledCircuit *self);
};

struct _CompiledCircuitPrivate {
	gchar* _errorMessage;
	gchar* _warningMessage;
	gboolean _errorOccurred;
	gboolean _warningOccurred;
	WireState** wireStates;
	gint wireStates_length1;
	gint _wireStates_size_;
	ComponentState** componentStates;
	gint componentStates_length1;
	gint _componentStates_size_;
	WireState** watchedWireStates;
	gint watchedWireStates_length1;
	gint _watchedWireStates_size_;
	ComponentInst** viewedAncestry;
	gint viewedAncestry_length1;
	gint _viewedAncestry_size_;
};

struct _Project {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectPrivate * priv;
	gboolean running;
	CustomComponentDef** customComponentDefs;
	gint customComponentDefs_length1;
	PluginComponentDef** pluginComponentDefs;
	gint pluginComponentDefs_length1;
	PluginComponentManager** pluginComponentManagers;
	gint pluginComponentManagers_length1;
	CustomComponentDef* rootComponent;
	gint myID;
	gchar* description;
	gchar* filename;
};

struct _ProjectClass {
	GTypeClass parent_class;
	void (*finalize) (Project *self);
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _CustomComponentDef {
	ComponentDef parent_instance;
	CustomComponentDefPrivate * priv;
	ComponentInst** componentInsts;
	gint componentInsts_length1;
	WireInst** wireInsts;
	gint wireInsts_length1;
	Annotation** annotations;
	gint annotations_length1;
	ComponentDef** immediateDependencies;
	gint immediateDependencies_length1;
};

struct _CustomComponentDefClass {
	ComponentDefClass parent_class;
};

struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _WireInstMarker {
	gint x;
	gint y;
	gboolean display;
};

struct _WireInstRegisteredComponent {
	ComponentInst* componentInst;
	WireInstMarker marker;
};

typedef enum  {
	WIRE_INST_PRESET_SIGNAL_DEFAULT,
	WIRE_INST_PRESET_SIGNAL_FALSE,
	WIRE_INST_PRESET_SIGNAL_TRUE
} WireInstPresetSignal;

struct _WireInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireInstPrivate * priv;
	WireInstRegisteredComponent* registeredComponents;
	gint registeredComponents_length1;
	gint myID;
	gboolean selected;
	WireInstMarker* markers;
	gint markers_length1;
	Path** paths;
	gint paths_length1;
	Tag* interfaceTag;
	WireInstPresetSignal presetSignal;
};

struct _WireInstClass {
	GTypeClass parent_class;
	void (*finalize) (WireInst *self);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

struct _Tag {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagPrivate * priv;
	gchar* text;
	gint xTag;
	gint yTag;
	gint xWire;
	gint yWire;
	gint pinid;
	Flow flow;
	Direction direction;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
};

struct _TagClass {
	GTypeClass parent_class;
	void (*finalize) (Tag *self);
};

struct _Connection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ConnectionPrivate * priv;
	WireState* wireState;
	gboolean invert;
	gboolean isFake;
	gboolean active;
};

struct _ConnectionClass {
	GTypeClass parent_class;
	void (*finalize) (Connection *self);
};

struct _WireState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireStatePrivate * priv;
	gint renderQueueID;
	gint processQueueID;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	gboolean display;
	gboolean errorMark;
	WireInst* wireInst;
	gint users;
	gint previousUsers;
};

struct _WireStateClass {
	GTypeClass parent_class;
	void (*finalize) (WireState *self);
};

struct _ComponentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentStatePrivate * priv;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	ComponentInst* componentInst;
	gint renderQueueID;
	gint processQueueID;
	gboolean display;
};

struct _ComponentStateClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentState *self);
	void (*update) (ComponentState* self);
	void (*click) (ComponentState* self);
	void (*render) (ComponentState* self, cairo_t* context);
	gboolean (*get_alwaysUpdate) (ComponentState* self);
};

struct _UpdateQueue {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UpdateQueuePrivate * priv;
	gpointer* elements;
	gint elements_length1;
};

struct _UpdateQueueClass {
	GTypeClass parent_class;
	void (*finalize) (UpdateQueue *self);
};

struct _ParamSpecCompiledCircuit {
	GParamSpec parent_instance;
};


static gpointer compiled_circuit_parent_class = NULL;

gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer update_queue_ref (gpointer instance);
void update_queue_unref (gpointer instance);
GParamSpec* param_spec_update_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_update_queue (GValue* value, gpointer v_object);
void value_take_update_queue (GValue* value, gpointer v_object);
gpointer value_get_update_queue (const GValue* value);
GType update_queue_get_type (void) G_GNUC_CONST;
gpointer wire_state_ref (gpointer instance);
void wire_state_unref (gpointer instance);
GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_state (GValue* value, gpointer v_object);
void value_take_wire_state (GValue* value, gpointer v_object);
gpointer value_get_wire_state (const GValue* value);
GType wire_state_get_type (void) G_GNUC_CONST;
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
#define COMPILED_CIRCUIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPILED_CIRCUIT, CompiledCircuitPrivate))
enum  {
	COMPILED_CIRCUIT_DUMMY_PROPERTY
};
CompiledCircuit* compiled_circuit_new (Project* project, CustomComponentDef* rootComponent);
CompiledCircuit* compiled_circuit_construct (GType object_type, Project* project, CustomComponentDef* rootComponent);
void compiled_circuit_appendError (CompiledCircuit* self, const gchar* errorString);
static void compiled_circuit_set_errorOccurred (CompiledCircuit* self, gboolean value);
const gchar* compiled_circuit_get_errorMessage (CompiledCircuit* self);
static void compiled_circuit_set_errorMessage (CompiledCircuit* self, const gchar* value);
void compiled_circuit_appendWarning (CompiledCircuit* self, const gchar* warningString);
static void compiled_circuit_set_warningOccurred (CompiledCircuit* self, gboolean value);
const gchar* compiled_circuit_get_warningMessage (CompiledCircuit* self);
static void compiled_circuit_set_warningMessage (CompiledCircuit* self, const gchar* value);
gint compiled_circuit_check_validity (CompiledCircuit* self);
GType plugin_component_def_get_type (void) G_GNUC_CONST;
gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
gpointer annotation_ref (gpointer instance);
void annotation_unref (gpointer instance);
GParamSpec* param_spec_annotation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_annotation (GValue* value, gpointer v_object);
void value_take_annotation (GValue* value, gpointer v_object);
gpointer value_get_annotation (const GValue* value);
GType annotation_get_type (void) G_GNUC_CONST;
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
CustomComponentDef** custom_component_def_validate_dependencies (CustomComponentDef* self, CustomComponentDef** componentChain, int componentChain_length1, int* result_length1);
void custom_component_def_update_ids (CustomComponentDef* self);
gint custom_component_def_validate_pins (CustomComponentDef* self);
gint custom_component_def_validate_interfaces (CustomComponentDef* self);
gint custom_component_def_validate_overlaps (CustomComponentDef* self);
gint compiled_circuit_compile (CompiledCircuit* self);
void component_def_compile_component (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
void compiled_circuit_update_displayed (CompiledCircuit* self);
gboolean component_state_get_alwaysUpdate (ComponentState* self);
static void _vala_array_add24 (ComponentState*** array, int* length, int* size, ComponentState* value);
UpdateQueue* update_queue_new (GType elementtype_type, GBoxedCopyFunc elementtype_dup_func, GDestroyNotify elementtype_destroy_func, gpointer* elements, int elements_length1, gpointer* permanentElements, int permanentElements_length1);
UpdateQueue* update_queue_construct (GType object_type, GType elementtype_type, GBoxedCopyFunc elementtype_dup_func, GDestroyNotify elementtype_destroy_func, gpointer* elements, int elements_length1, gpointer* permanentElements, int permanentElements_length1);
void update_queue_full_update (UpdateQueue* self);
WireState* compiled_circuit_compile_wire (CompiledCircuit* self, WireInst* wireInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
WireState* wire_state_new (WireInst* wireInst, ComponentInst** ancestry, int ancestry_length1);
WireState* wire_state_construct (GType object_type, WireInst* wireInst, ComponentInst** ancestry, int ancestry_length1);
GType wire_inst_registered_component_get_type (void) G_GNUC_CONST;
GType wire_inst_marker_get_type (void) G_GNUC_CONST;
WireInstMarker* wire_inst_marker_dup (const WireInstMarker* self);
void wire_inst_marker_free (WireInstMarker* self);
WireInstRegisteredComponent* wire_inst_registered_component_dup (const WireInstRegisteredComponent* self);
void wire_inst_registered_component_free (WireInstRegisteredComponent* self);
gpointer path_ref (gpointer instance);
void path_unref (gpointer instance);
GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_path (GValue* value, gpointer v_object);
void value_take_path (GValue* value, gpointer v_object);
gpointer value_get_path (const GValue* value);
GType path_get_type (void) G_GNUC_CONST;
gpointer tag_ref (gpointer instance);
void tag_unref (gpointer instance);
GParamSpec* param_spec_tag (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag (GValue* value, gpointer v_object);
void value_take_tag (GValue* value, gpointer v_object);
gpointer value_get_tag (const GValue* value);
GType tag_get_type (void) G_GNUC_CONST;
GType wire_inst_preset_signal_get_type (void) G_GNUC_CONST;
GType flow_get_type (void) G_GNUC_CONST;
void wire_state_add_interface (WireState* self, Connection* connection);
Connection* connection_new (WireState* wireState, gboolean invert);
Connection* connection_construct (GType object_type, WireState* wireState, gboolean invert);
static void _vala_array_add25 (WireState*** array, int* length, int* size, WireState* value);
void compiled_circuit_add_component (CompiledCircuit* self, ComponentState* componentState);
static void _vala_array_add26 (ComponentState*** array, int* length, int* size, ComponentState* value);
void compiled_circuit_add_watch (CompiledCircuit* self, WireState* wireState);
static gboolean _vala_wire_state_array_contains (WireState** stack, int stack_length, WireState* needle);
static void _vala_array_add27 (WireState*** array, int* length, int* size, WireState* value);
void compiled_circuit_remove_watch (CompiledCircuit* self, WireState* wireState);
static void _vala_array_add28 (WireState*** array, int* length, int* size, WireState* value);
static WireState** _vala_array_dup4 (WireState** self, int length);
gint compiled_circuit_update_cycle (CompiledCircuit* self);
void update_queue_swap (UpdateQueue* self, gint newTime);
gpointer update_queue_get_next_element (UpdateQueue* self);
void component_state_update (ComponentState* self);
void wire_state_swap_buffers (WireState* self);
void wire_state_record (WireState* self);
void compiled_circuit_shrink_component (CompiledCircuit* self);
gint compiled_circuit_expand_component (CompiledCircuit* self, gint x, gint y);
ComponentInst* custom_component_def_find_inst (CustomComponentDef* self, gint x, gint y);
static void _vala_array_add29 (ComponentInst*** array, int* length, int* size, ComponentInst* value);
static gint compiled_circuit_check_ancestry (CompiledCircuit* self, ComponentInst** ancestry, int ancestry_length1);
static void _vala_array_add30 (ComponentState*** array, int* length, int* size, ComponentState* value);
static void _vala_array_add31 (WireState*** array, int* length, int* size, WireState* value);
void compiled_circuit_interact_components (CompiledCircuit* self, gint xInteract, gint yInteract);
gint component_inst_find (ComponentInst* self, gint x, gint y);
void component_state_click (ComponentState* self);
void update_queue_add_element (UpdateQueue* self, gint elementNumber);
WireState* compiled_circuit_find_wire (CompiledCircuit* self, gint x, gint y);
Path* wire_inst_find (WireInst* self, gint x, gint y);
gint wire_inst_find_tag (WireInst* self, gint x, gint y);
void compiled_circuit_render (CompiledCircuit* self, cairo_t* context, gboolean fullRender, gfloat zoom);
void custom_component_def_render_insts (CustomComponentDef* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
void component_state_render (ComponentState* self, cairo_t* context);
void wire_state_render (WireState* self, cairo_t* context);
gboolean compiled_circuit_get_errorOccurred (CompiledCircuit* self);
gboolean compiled_circuit_get_warningOccurred (CompiledCircuit* self);
static void compiled_circuit_finalize (CompiledCircuit* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Prepares for tasks within the project //project// and sets the
 * Root Component as //rootComponent//.
 */
static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


static gpointer _project_ref0 (gpointer self) {
	return self ? project_ref (self) : NULL;
}


CompiledCircuit* compiled_circuit_construct (GType object_type, Project* project, CustomComponentDef* rootComponent) {
	CompiledCircuit* self = NULL;
	CustomComponentDef* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	Project* _tmp2_ = NULL;
	Project* _tmp3_ = NULL;
	CustomComponentDef* _tmp4_ = NULL;
	CustomComponentDef* _tmp5_ = NULL;
	ComponentInst** _tmp6_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	g_return_val_if_fail (rootComponent != NULL, NULL);
	self = (CompiledCircuit*) g_type_create_instance (object_type);
	_tmp0_ = rootComponent;
	_tmp1_ = _component_def_ref0 (_tmp0_);
	_component_def_unref0 (self->rootComponent);
	self->rootComponent = _tmp1_;
	_tmp2_ = project;
	_tmp3_ = _project_ref0 (_tmp2_);
	_project_unref0 (self->project);
	self->project = _tmp3_;
	self->iterationCount = 0;
	_tmp4_ = rootComponent;
	_tmp5_ = _component_def_ref0 (_tmp4_);
	_component_def_unref0 (self->viewedComponent);
	self->viewedComponent = _tmp5_;
	_tmp6_ = g_new0 (ComponentInst*, 0 + 1);
	self->priv->viewedAncestry = (_vala_array_free (self->priv->viewedAncestry, self->priv->viewedAncestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	self->priv->viewedAncestry = _tmp6_;
	self->priv->viewedAncestry_length1 = 0;
	self->priv->_viewedAncestry_size_ = self->priv->viewedAncestry_length1;
	return self;
}


CompiledCircuit* compiled_circuit_new (Project* project, CustomComponentDef* rootComponent) {
	return compiled_circuit_construct (TYPE_COMPILED_CIRCUIT, project, rootComponent);
}


/**
 * Appends a message to //errorMessage// and sets //errorOccurred//
 * to true.
 */
void compiled_circuit_appendError (CompiledCircuit* self, const gchar* errorString) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (errorString != NULL);
	compiled_circuit_set_errorOccurred (self, TRUE);
	_tmp0_ = self->priv->_errorMessage;
	_tmp1_ = errorString;
	_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp0_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	compiled_circuit_set_errorMessage (self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


/**
 * Appends a message to //warningMessage// and sets //warningOccurred//
 * to true.
 */
void compiled_circuit_appendWarning (CompiledCircuit* self, const gchar* warningString) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (warningString != NULL);
	compiled_circuit_set_warningOccurred (self, TRUE);
	_tmp0_ = self->priv->_warningMessage;
	_tmp1_ = warningString;
	_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp0_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	compiled_circuit_set_warningMessage (self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


/**
 * Checks that the circuit can be compiled, and warns about
 * situations which could cause problems.
 * 
 * A circuit cannot be compiled if:
 * * a subcomponent contains itself,
 * * any required pins do not have a connection,
 * * pins on custom components without matching interface tags.
 * <<BR>>
 * Warnings include:
 * * overlapping components,
 * * interface tags in custom components without matching pins.
 */
static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


gint compiled_circuit_check_validity (CompiledCircuit* self) {
	gint result = 0;
	CustomComponentDef** componentChain = NULL;
	gint componentChain_length1 = 0;
	gint _componentChain_size_ = 0;
	gint pinErrorCountTotal = 0;
	gint returnState = 0;
	Project* _tmp0_ = NULL;
	CustomComponentDef** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	FILE* _tmp7_ = NULL;
	CustomComponentDef* _tmp8_ = NULL;
	CustomComponentDef** _tmp9_ = NULL;
	CustomComponentDef** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp11_ = 0;
	CustomComponentDef** _tmp12_ = NULL;
	CustomComponentDef** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	FILE* _tmp24_ = NULL;
	Project* _tmp25_ = NULL;
	CustomComponentDef** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gint _tmp48_ = 0;
	FILE* _tmp50_ = NULL;
	gboolean interfaceFailure = FALSE;
	Project* _tmp51_ = NULL;
	CustomComponentDef** _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	gboolean _tmp63_ = FALSE;
	Project* _tmp65_ = NULL;
	CustomComponentDef** _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	pinErrorCountTotal = 0;
	compiled_circuit_set_errorMessage (self, "");
	compiled_circuit_set_warningMessage (self, "");
	returnState = 0;
	_tmp0_ = self->project;
	_tmp1_ = _tmp0_->customComponentDefs;
	_tmp1__length1 = _tmp0_->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp1_;
		customComponentDef_collection_length1 = _tmp1__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp1__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp2_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp2_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp2_;
			{
				CustomComponentDef* _tmp3_ = NULL;
				ComponentInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				_tmp3_ = customComponentDef;
				_tmp4_ = _tmp3_->componentInsts;
				_tmp4__length1 = _tmp3_->componentInsts_length1;
				{
					ComponentInst** componentInst_collection = NULL;
					gint componentInst_collection_length1 = 0;
					gint _componentInst_collection_size_ = 0;
					gint componentInst_it = 0;
					componentInst_collection = _tmp4_;
					componentInst_collection_length1 = _tmp4__length1;
					for (componentInst_it = 0; componentInst_it < _tmp4__length1; componentInst_it = componentInst_it + 1) {
						ComponentInst* _tmp5_ = NULL;
						ComponentInst* componentInst = NULL;
						_tmp5_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
						componentInst = _tmp5_;
						{
							ComponentInst* _tmp6_ = NULL;
							_tmp6_ = componentInst;
							_tmp6_->errorMark = FALSE;
							_component_inst_unref0 (componentInst);
						}
					}
				}
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	_tmp7_ = stdout;
	fprintf (_tmp7_, "Checking circuit for cyclic dependences.\n");
	_tmp8_ = self->rootComponent;
	_tmp9_ = g_new0 (CustomComponentDef*, 0 + 1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 0;
	_tmp12_ = custom_component_def_validate_dependencies (_tmp8_, _tmp10_, 0, &_tmp11_);
	componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
	componentChain = _tmp12_;
	componentChain_length1 = _tmp11_;
	_componentChain_size_ = componentChain_length1;
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) component_def_unref), NULL);
	_tmp13_ = componentChain;
	_tmp13__length1 = componentChain_length1;
	if (_tmp13_ != NULL) {
		FILE* _tmp14_ = NULL;
		CustomComponentDef** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp23_ = 0;
		_tmp14_ = stdout;
		fprintf (_tmp14_, "Component Failed Cyclic Dependency Test\n");
		compiled_circuit_appendError (self, "Circuit failed cyclic dependency test. Failed ancestry:");
		_tmp15_ = componentChain;
		_tmp15__length1 = componentChain_length1;
		{
			CustomComponentDef** customComponentDef_collection = NULL;
			gint customComponentDef_collection_length1 = 0;
			gint _customComponentDef_collection_size_ = 0;
			gint customComponentDef_it = 0;
			customComponentDef_collection = _tmp15_;
			customComponentDef_collection_length1 = _tmp15__length1;
			for (customComponentDef_it = 0; customComponentDef_it < _tmp15__length1; customComponentDef_it = customComponentDef_it + 1) {
				CustomComponentDef* _tmp16_ = NULL;
				CustomComponentDef* customComponentDef = NULL;
				_tmp16_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
				customComponentDef = _tmp16_;
				{
					CustomComponentDef* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					_tmp17_ = customComponentDef;
					_tmp18_ = ((ComponentDef*) _tmp17_)->name;
					_tmp19_ = g_strconcat ("  ", _tmp18_, NULL);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat (_tmp20_, ".", NULL);
					_tmp22_ = _tmp21_;
					compiled_circuit_appendError (self, _tmp22_);
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
					_component_def_unref0 (customComponentDef);
				}
			}
		}
		compiled_circuit_appendError (self, "");
		_tmp23_ = returnState;
		returnState = _tmp23_ + 1;
	}
	_tmp24_ = stdout;
	fprintf (_tmp24_, "Checking circuit for unsatisfied connections.\n");
	_tmp25_ = self->project;
	_tmp26_ = _tmp25_->customComponentDefs;
	_tmp26__length1 = _tmp25_->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp26_;
		customComponentDef_collection_length1 = _tmp26__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp26__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp27_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp27_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp27_;
			{
				gint pinErrorCount = 0;
				CustomComponentDef* _tmp28_ = NULL;
				CustomComponentDef* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				pinErrorCount = 0;
				_tmp28_ = customComponentDef;
				custom_component_def_update_ids (_tmp28_);
				_tmp29_ = customComponentDef;
				_tmp30_ = custom_component_def_validate_pins (_tmp29_);
				pinErrorCount = _tmp30_;
				_tmp31_ = pinErrorCountTotal;
				_tmp32_ = pinErrorCount;
				pinErrorCountTotal = _tmp31_ + _tmp32_;
				_tmp33_ = pinErrorCount;
				if (_tmp33_ > 0) {
					FILE* _tmp34_ = NULL;
					CustomComponentDef* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					_tmp34_ = stdout;
					fprintf (_tmp34_, "Component Failed Connection Test\n");
					_tmp35_ = customComponentDef;
					_tmp36_ = ((ComponentDef*) _tmp35_)->name;
					_tmp37_ = g_strconcat ("Component \"", _tmp36_, NULL);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strconcat (_tmp38_, "\" has ", NULL);
					_tmp40_ = _tmp39_;
					_tmp41_ = pinErrorCount;
					_tmp42_ = g_strdup_printf ("%i", _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strconcat (_tmp40_, _tmp43_, NULL);
					_tmp45_ = _tmp44_;
					_tmp46_ = g_strconcat (_tmp45_, " pin errors.", NULL);
					_tmp47_ = _tmp46_;
					compiled_circuit_appendError (self, _tmp47_);
					_g_free0 (_tmp47_);
					_g_free0 (_tmp45_);
					_g_free0 (_tmp43_);
					_g_free0 (_tmp40_);
					_g_free0 (_tmp38_);
				}
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	_tmp48_ = pinErrorCountTotal;
	if (_tmp48_ > 0) {
		gint _tmp49_ = 0;
		_tmp49_ = returnState;
		returnState = _tmp49_ + 2;
	}
	_tmp50_ = stdout;
	fprintf (_tmp50_, "Checking custom components for unsatisfied interfaces.\n");
	interfaceFailure = FALSE;
	_tmp51_ = self->project;
	_tmp52_ = _tmp51_->customComponentDefs;
	_tmp52__length1 = _tmp51_->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp52_;
		customComponentDef_collection_length1 = _tmp52__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp52__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp53_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp53_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp53_;
			{
				CustomComponentDef* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				_tmp54_ = customComponentDef;
				_tmp55_ = custom_component_def_validate_interfaces (_tmp54_);
				if (_tmp55_ != 0) {
					FILE* _tmp56_ = NULL;
					CustomComponentDef* _tmp57_ = NULL;
					const gchar* _tmp58_ = NULL;
					gchar* _tmp59_ = NULL;
					gchar* _tmp60_ = NULL;
					gchar* _tmp61_ = NULL;
					gchar* _tmp62_ = NULL;
					interfaceFailure = TRUE;
					_tmp56_ = stdout;
					fprintf (_tmp56_, "Component Failed Interface Test\n");
					_tmp57_ = customComponentDef;
					_tmp58_ = ((ComponentDef*) _tmp57_)->name;
					_tmp59_ = g_strconcat ("Component \"", _tmp58_, NULL);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strconcat (_tmp60_, "\" has unsatisfied interfaces.", NULL);
					_tmp62_ = _tmp61_;
					compiled_circuit_appendError (self, _tmp62_);
					_g_free0 (_tmp62_);
					_g_free0 (_tmp60_);
				}
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	_tmp63_ = interfaceFailure;
	if (_tmp63_) {
		gint _tmp64_ = 0;
		_tmp64_ = returnState;
		returnState = _tmp64_ + 4;
	}
	_tmp65_ = self->project;
	_tmp66_ = _tmp65_->customComponentDefs;
	_tmp66__length1 = _tmp65_->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp66_;
		customComponentDef_collection_length1 = _tmp66__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp66__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp67_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp67_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp67_;
			{
				gint errorCount = 0;
				CustomComponentDef* _tmp68_ = NULL;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				_tmp68_ = customComponentDef;
				_tmp69_ = custom_component_def_validate_overlaps (_tmp68_);
				errorCount = _tmp69_;
				_tmp70_ = errorCount;
				if (_tmp70_ != 0) {
					FILE* _tmp71_ = NULL;
					CustomComponentDef* _tmp72_ = NULL;
					const gchar* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
					gchar* _tmp75_ = NULL;
					gchar* _tmp76_ = NULL;
					gchar* _tmp77_ = NULL;
					gint _tmp78_ = 0;
					gchar* _tmp79_ = NULL;
					gchar* _tmp80_ = NULL;
					gchar* _tmp81_ = NULL;
					gchar* _tmp82_ = NULL;
					gchar* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
					_tmp71_ = stdout;
					fprintf (_tmp71_, "Component Failed Overlap Test\n");
					_tmp72_ = customComponentDef;
					_tmp73_ = ((ComponentDef*) _tmp72_)->name;
					_tmp74_ = g_strconcat ("Component \"", _tmp73_, NULL);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strconcat (_tmp75_, "\" has ", NULL);
					_tmp77_ = _tmp76_;
					_tmp78_ = errorCount;
					_tmp79_ = g_strdup_printf ("%i", _tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = g_strconcat (_tmp77_, _tmp80_, NULL);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strconcat (_tmp82_, " overlapping components.", NULL);
					_tmp84_ = _tmp83_;
					compiled_circuit_appendWarning (self, _tmp84_);
					_g_free0 (_tmp84_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp80_);
					_g_free0 (_tmp77_);
					_g_free0 (_tmp75_);
				}
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	result = returnState;
	componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
	return result;
}


/**
 * High level compilation.
 * 
 * Calls lower level components and wires to compile themselves into
 * the CompiledCircuit. Also presets the CompiledCircuit.
 */
static gpointer _component_state_ref0 (gpointer self) {
	return self ? component_state_ref (self) : NULL;
}


static void _vala_array_add24 (ComponentState*** array, int* length, int* size, ComponentState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint compiled_circuit_compile (CompiledCircuit* self) {
	gint result = 0;
	CustomComponentDef* _tmp0_ = NULL;
	Connection** _tmp1_ = NULL;
	Connection** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	ComponentInst** _tmp3_ = NULL;
	ComponentInst** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	ComponentState** permanentComponentStates = NULL;
	ComponentState** _tmp5_ = NULL;
	gint permanentComponentStates_length1 = 0;
	gint _permanentComponentStates_size_ = 0;
	ComponentState** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	ComponentState** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	ComponentState** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	UpdateQueue* _tmp16_ = NULL;
	UpdateQueue* _tmp17_ = NULL;
	WireState** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	UpdateQueue* _tmp19_ = NULL;
	UpdateQueue* _tmp20_ = NULL;
	WireState** _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->rootComponent;
	_tmp1_ = g_new0 (Connection*, 0 + 1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 0;
	_tmp3_ = g_new0 (ComponentInst*, 0 + 1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 0;
	component_def_compile_component ((ComponentDef*) _tmp0_, self, NULL, _tmp2_, 0, _tmp4_, 0);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) component_inst_unref), NULL);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) connection_unref), NULL);
	compiled_circuit_update_displayed (self);
	_tmp5_ = g_new0 (ComponentState*, 0 + 1);
	permanentComponentStates = _tmp5_;
	permanentComponentStates_length1 = 0;
	_permanentComponentStates_size_ = permanentComponentStates_length1;
	_tmp6_ = self->priv->componentStates;
	_tmp6__length1 = self->priv->componentStates_length1;
	{
		ComponentState** componentState_collection = NULL;
		gint componentState_collection_length1 = 0;
		gint _componentState_collection_size_ = 0;
		gint componentState_it = 0;
		componentState_collection = _tmp6_;
		componentState_collection_length1 = _tmp6__length1;
		for (componentState_it = 0; componentState_it < _tmp6__length1; componentState_it = componentState_it + 1) {
			ComponentState* _tmp7_ = NULL;
			ComponentState* componentState = NULL;
			_tmp7_ = _component_state_ref0 (componentState_collection[componentState_it]);
			componentState = _tmp7_;
			{
				ComponentState* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = componentState;
				_tmp9_ = component_state_get_alwaysUpdate (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					ComponentState** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					ComponentState* _tmp12_ = NULL;
					ComponentState* _tmp13_ = NULL;
					_tmp11_ = permanentComponentStates;
					_tmp11__length1 = permanentComponentStates_length1;
					_tmp12_ = componentState;
					_tmp13_ = _component_state_ref0 (_tmp12_);
					_vala_array_add24 (&permanentComponentStates, &permanentComponentStates_length1, &_permanentComponentStates_size_, _tmp13_);
				}
				_component_state_unref0 (componentState);
			}
		}
	}
	_tmp14_ = self->priv->componentStates;
	_tmp14__length1 = self->priv->componentStates_length1;
	_tmp15_ = permanentComponentStates;
	_tmp15__length1 = permanentComponentStates_length1;
	_tmp16_ = update_queue_new (TYPE_COMPONENT_STATE, (GBoxedCopyFunc) component_state_ref, component_state_unref, _tmp14_, _tmp14__length1, _tmp15_, _tmp15__length1);
	_update_queue_unref0 (self->processComponentStates);
	self->processComponentStates = _tmp16_;
	_tmp17_ = self->processComponentStates;
	update_queue_full_update (_tmp17_);
	_tmp18_ = self->priv->wireStates;
	_tmp18__length1 = self->priv->wireStates_length1;
	_tmp19_ = update_queue_new (TYPE_WIRE_STATE, (GBoxedCopyFunc) wire_state_ref, wire_state_unref, _tmp18_, _tmp18__length1, NULL, 0);
	_update_queue_unref0 (self->processWireStates);
	self->processWireStates = _tmp19_;
	_tmp20_ = self->processWireStates;
	update_queue_full_update (_tmp20_);
	_tmp21_ = g_new0 (WireState*, 0 + 1);
	self->priv->watchedWireStates = (_vala_array_free (self->priv->watchedWireStates, self->priv->watchedWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	self->priv->watchedWireStates = _tmp21_;
	self->priv->watchedWireStates_length1 = 0;
	self->priv->_watchedWireStates_size_ = self->priv->watchedWireStates_length1;
	result = 0;
	permanentComponentStates = (_vala_array_free (permanentComponentStates, permanentComponentStates_length1, (GDestroyNotify) component_state_unref), NULL);
	return result;
}


/**
 * Called by WireInsts. Used to add a wire to the CompiledCircuit,
 * and interfaces it with the higher level if needed.
 */
static gpointer _wire_state_ref0 (gpointer self) {
	return self ? wire_state_ref (self) : NULL;
}


static void _vala_array_add25 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


WireState* compiled_circuit_compile_wire (CompiledCircuit* self, WireInst* wireInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	WireState* result = NULL;
	WireState* wireState = NULL;
	WireInst* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	WireState* _tmp2_ = NULL;
	WireInst* _tmp3_ = NULL;
	Tag* _tmp4_ = NULL;
	WireState* _tmp47_ = NULL;
	WireState** _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	WireState* _tmp49_ = NULL;
	WireState** _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	WireState* _tmp51_ = NULL;
	WireState* _tmp52_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (wireInst != NULL, NULL);
	_tmp0_ = wireInst;
	_tmp1_ = ancestry;
	_tmp1__length1 = ancestry_length1;
	_tmp2_ = wire_state_new (_tmp0_, _tmp1_, _tmp1__length1);
	wireState = _tmp2_;
	_tmp3_ = wireInst;
	_tmp4_ = _tmp3_->interfaceTag;
	if (_tmp4_ != NULL) {
		WireInst* _tmp5_ = NULL;
		Tag* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		Connection** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		_tmp5_ = wireInst;
		_tmp6_ = _tmp5_->interfaceTag;
		_tmp7_ = _tmp6_->pinid;
		_tmp8_ = connections;
		_tmp8__length1 = connections_length1;
		if (_tmp7_ < _tmp8__length1) {
			WireState* _tmp9_ = NULL;
			Connection** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			WireInst* _tmp11_ = NULL;
			Tag* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			Connection* _tmp14_ = NULL;
			Connection** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			WireInst* _tmp16_ = NULL;
			Tag* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			Connection* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp9_ = wireState;
			_tmp10_ = connections;
			_tmp10__length1 = connections_length1;
			_tmp11_ = wireInst;
			_tmp12_ = _tmp11_->interfaceTag;
			_tmp13_ = _tmp12_->pinid;
			_tmp14_ = _tmp10_[_tmp13_];
			wire_state_add_interface (_tmp9_, _tmp14_);
			_tmp15_ = connections;
			_tmp15__length1 = connections_length1;
			_tmp16_ = wireInst;
			_tmp17_ = _tmp16_->interfaceTag;
			_tmp18_ = _tmp17_->pinid;
			_tmp19_ = _tmp15_[_tmp18_];
			_tmp20_ = _tmp19_->isFake;
			if (!_tmp20_) {
				Connection* reflectedConnection = NULL;
				WireState* _tmp21_ = NULL;
				Connection** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				WireInst* _tmp23_ = NULL;
				Tag* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				Connection* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
				Connection* _tmp28_ = NULL;
				Connection** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				WireInst* _tmp30_ = NULL;
				Tag* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				Connection* _tmp33_ = NULL;
				WireState* _tmp34_ = NULL;
				Connection* _tmp35_ = NULL;
				_tmp21_ = wireState;
				_tmp22_ = connections;
				_tmp22__length1 = connections_length1;
				_tmp23_ = wireInst;
				_tmp24_ = _tmp23_->interfaceTag;
				_tmp25_ = _tmp24_->pinid;
				_tmp26_ = _tmp22_[_tmp25_];
				_tmp27_ = _tmp26_->invert;
				_tmp28_ = connection_new (_tmp21_, _tmp27_);
				reflectedConnection = _tmp28_;
				_tmp29_ = connections;
				_tmp29__length1 = connections_length1;
				_tmp30_ = wireInst;
				_tmp31_ = _tmp30_->interfaceTag;
				_tmp32_ = _tmp31_->pinid;
				_tmp33_ = _tmp29_[_tmp32_];
				_tmp34_ = _tmp33_->wireState;
				_tmp35_ = reflectedConnection;
				wire_state_add_interface (_tmp34_, _tmp35_);
				_connection_unref0 (reflectedConnection);
			}
		} else {
			FILE* _tmp36_ = NULL;
			ComponentInst** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			_tmp36_ = stdout;
			fprintf (_tmp36_, "Warning: Cannot link tagged wire.\n");
			_tmp37_ = ancestry;
			_tmp37__length1 = ancestry_length1;
			if (_tmp37__length1 == 0) {
				compiled_circuit_appendWarning (self, "Found interface tag in the root component.");
			} else {
				ComponentInst** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				ComponentInst** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				ComponentInst* _tmp40_ = NULL;
				ComponentDef* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				_tmp38_ = ancestry;
				_tmp38__length1 = ancestry_length1;
				_tmp39_ = ancestry;
				_tmp39__length1 = ancestry_length1;
				_tmp40_ = _tmp38_[_tmp39__length1 - 1];
				_tmp41_ = _tmp40_->componentDef;
				_tmp42_ = _tmp41_->name;
				_tmp43_ = g_strconcat ("Cannot link tagged wire in component \"", _tmp42_, NULL);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strconcat (_tmp44_, "\".", NULL);
				_tmp46_ = _tmp45_;
				compiled_circuit_appendWarning (self, _tmp46_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
			}
		}
	}
	_tmp47_ = wireState;
	_tmp48_ = self->priv->wireStates;
	_tmp48__length1 = self->priv->wireStates_length1;
	_tmp47_->processQueueID = _tmp48__length1;
	_tmp49_ = wireState;
	_tmp49_->compiledCircuit = self;
	_tmp50_ = self->priv->wireStates;
	_tmp50__length1 = self->priv->wireStates_length1;
	_tmp51_ = wireState;
	_tmp52_ = _wire_state_ref0 (_tmp51_);
	_vala_array_add25 (&self->priv->wireStates, &self->priv->wireStates_length1, &self->priv->_wireStates_size_, _tmp52_);
	result = wireState;
	return result;
}


static void _vala_array_add26 (ComponentState*** array, int* length, int* size, ComponentState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void compiled_circuit_add_component (CompiledCircuit* self, ComponentState* componentState) {
	ComponentState* _tmp0_ = NULL;
	ComponentState** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ComponentState* _tmp2_ = NULL;
	ComponentState** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	ComponentState* _tmp4_ = NULL;
	ComponentState* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (componentState != NULL);
	_tmp0_ = componentState;
	_tmp1_ = self->priv->componentStates;
	_tmp1__length1 = self->priv->componentStates_length1;
	_tmp0_->processQueueID = _tmp1__length1;
	_tmp2_ = componentState;
	_tmp2_->compiledCircuit = self;
	_tmp3_ = self->priv->componentStates;
	_tmp3__length1 = self->priv->componentStates_length1;
	_tmp4_ = componentState;
	_tmp5_ = _component_state_ref0 (_tmp4_);
	_vala_array_add26 (&self->priv->componentStates, &self->priv->componentStates_length1, &self->priv->_componentStates_size_, _tmp5_);
}


static gboolean _vala_wire_state_array_contains (WireState** stack, int stack_length, WireState* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add27 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void compiled_circuit_add_watch (CompiledCircuit* self, WireState* wireState) {
	WireState* _tmp0_ = NULL;
	WireState** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wireState != NULL);
	_tmp0_ = wireState;
	_tmp1_ = self->priv->watchedWireStates;
	_tmp1__length1 = self->priv->watchedWireStates_length1;
	if (!_vala_wire_state_array_contains (_tmp1_, _tmp1__length1, _tmp0_)) {
		WireState** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		WireState* _tmp3_ = NULL;
		WireState* _tmp4_ = NULL;
		_tmp2_ = self->priv->watchedWireStates;
		_tmp2__length1 = self->priv->watchedWireStates_length1;
		_tmp3_ = wireState;
		_tmp4_ = _wire_state_ref0 (_tmp3_);
		_vala_array_add27 (&self->priv->watchedWireStates, &self->priv->watchedWireStates_length1, &self->priv->_watchedWireStates_size_, _tmp4_);
	}
}


static void _vala_array_add28 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireState** _vala_array_dup4 (WireState** self, int length) {
	WireState** result;
	int i;
	result = g_new0 (WireState*, length + 1);
	for (i = 0; i < length; i++) {
		WireState* _tmp0_ = NULL;
		_tmp0_ = _wire_state_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void compiled_circuit_remove_watch (CompiledCircuit* self, WireState* wireState) {
	WireState** newWatchedWireStates = NULL;
	WireState** _tmp0_ = NULL;
	gint newWatchedWireStates_length1 = 0;
	gint _newWatchedWireStates_size_ = 0;
	WireState** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	WireState** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	WireState** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wireState != NULL);
	_tmp0_ = g_new0 (WireState*, 0 + 1);
	newWatchedWireStates = _tmp0_;
	newWatchedWireStates_length1 = 0;
	_newWatchedWireStates_size_ = newWatchedWireStates_length1;
	_tmp1_ = self->priv->watchedWireStates;
	_tmp1__length1 = self->priv->watchedWireStates_length1;
	{
		WireState** watchedWireState_collection = NULL;
		gint watchedWireState_collection_length1 = 0;
		gint _watchedWireState_collection_size_ = 0;
		gint watchedWireState_it = 0;
		watchedWireState_collection = _tmp1_;
		watchedWireState_collection_length1 = _tmp1__length1;
		for (watchedWireState_it = 0; watchedWireState_it < _tmp1__length1; watchedWireState_it = watchedWireState_it + 1) {
			WireState* _tmp2_ = NULL;
			WireState* watchedWireState = NULL;
			_tmp2_ = _wire_state_ref0 (watchedWireState_collection[watchedWireState_it]);
			watchedWireState = _tmp2_;
			{
				WireState* _tmp3_ = NULL;
				WireState* _tmp4_ = NULL;
				_tmp3_ = watchedWireState;
				_tmp4_ = wireState;
				if (_tmp3_ != _tmp4_) {
					WireState** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					WireState* _tmp6_ = NULL;
					WireState* _tmp7_ = NULL;
					_tmp5_ = newWatchedWireStates;
					_tmp5__length1 = newWatchedWireStates_length1;
					_tmp6_ = watchedWireState;
					_tmp7_ = _wire_state_ref0 (_tmp6_);
					_vala_array_add28 (&newWatchedWireStates, &newWatchedWireStates_length1, &_newWatchedWireStates_size_, _tmp7_);
				}
				_wire_state_unref0 (watchedWireState);
			}
		}
	}
	_tmp8_ = newWatchedWireStates;
	_tmp8__length1 = newWatchedWireStates_length1;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup4 (_tmp8_, _tmp8__length1) : ((gpointer) _tmp8_);
	_tmp9__length1 = _tmp8__length1;
	self->priv->watchedWireStates = (_vala_array_free (self->priv->watchedWireStates, self->priv->watchedWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	self->priv->watchedWireStates = _tmp9_;
	self->priv->watchedWireStates_length1 = _tmp9__length1;
	self->priv->_watchedWireStates_size_ = self->priv->watchedWireStates_length1;
	newWatchedWireStates = (_vala_array_free (newWatchedWireStates, newWatchedWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
}


/**
 * Goes through one iteration of the simulation (high level).
 */
gint compiled_circuit_update_cycle (CompiledCircuit* self) {
	gint result = 0;
	gboolean multiOutputError = FALSE;
	WireState** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	multiOutputError = FALSE;
	{
		UpdateQueue* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		ComponentState* componentState = NULL;
		_tmp0_ = self->processComponentStates;
		_tmp1_ = self->iterationCount;
		update_queue_swap (_tmp0_, _tmp1_);
		while (TRUE) {
			UpdateQueue* _tmp2_ = NULL;
			gpointer _tmp3_ = NULL;
			ComponentState* _tmp4_ = NULL;
			ComponentState* _tmp5_ = NULL;
			_tmp2_ = self->processComponentStates;
			_tmp3_ = update_queue_get_next_element (_tmp2_);
			_component_state_unref0 (componentState);
			componentState = (ComponentState*) _tmp3_;
			_tmp4_ = componentState;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = componentState;
			component_state_update (_tmp5_);
		}
		_component_state_unref0 (componentState);
	}
	{
		UpdateQueue* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		WireState* wireState = NULL;
		_tmp6_ = self->processWireStates;
		_tmp7_ = self->iterationCount;
		update_queue_swap (_tmp6_, _tmp7_);
		while (TRUE) {
			UpdateQueue* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			WireState* _tmp10_ = NULL;
			WireState* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			WireState* _tmp14_ = NULL;
			_tmp8_ = self->processWireStates;
			_tmp9_ = update_queue_get_next_element (_tmp8_);
			_wire_state_unref0 (wireState);
			wireState = (WireState*) _tmp9_;
			_tmp10_ = wireState;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = wireState;
			_tmp12_ = _tmp11_->users;
			if (_tmp12_ > 1) {
				WireState* _tmp13_ = NULL;
				multiOutputError = TRUE;
				_tmp13_ = wireState;
				_tmp13_->errorMark = TRUE;
			}
			_tmp14_ = wireState;
			wire_state_swap_buffers (_tmp14_);
		}
		_wire_state_unref0 (wireState);
	}
	_tmp15_ = self->priv->watchedWireStates;
	_tmp15__length1 = self->priv->watchedWireStates_length1;
	{
		WireState** wireState_collection = NULL;
		gint wireState_collection_length1 = 0;
		gint _wireState_collection_size_ = 0;
		gint wireState_it = 0;
		wireState_collection = _tmp15_;
		wireState_collection_length1 = _tmp15__length1;
		for (wireState_it = 0; wireState_it < _tmp15__length1; wireState_it = wireState_it + 1) {
			WireState* _tmp16_ = NULL;
			WireState* wireState = NULL;
			_tmp16_ = _wire_state_ref0 (wireState_collection[wireState_it]);
			wireState = _tmp16_;
			{
				WireState* _tmp17_ = NULL;
				_tmp17_ = wireState;
				wire_state_record (_tmp17_);
				_wire_state_unref0 (wireState);
			}
		}
	}
	_tmp18_ = self->iterationCount;
	self->iterationCount = _tmp18_ + 1;
	_tmp19_ = multiOutputError;
	if (_tmp19_) {
		compiled_circuit_appendError (self, "Multiple Output Error: Two or more components are using the same wire " \
"at once.");
		result = 1;
		return result;
	}
	result = 0;
	return result;
}


/**
 * Return to viewing the higher level component.
 */
void compiled_circuit_shrink_component (CompiledCircuit* self) {
	ComponentInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->viewedAncestry;
	_tmp0__length1 = self->priv->viewedAncestry_length1;
	if (_tmp0__length1 > 0) {
		ComponentInst** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->viewedAncestry;
		_tmp1__length1 = self->priv->viewedAncestry_length1;
		_tmp2_ = _tmp1__length1 - 1;
		self->priv->viewedAncestry = g_renew (ComponentInst*, self->priv->viewedAncestry, _tmp1__length1 - 1);
		(_tmp2_ > self->priv->viewedAncestry_length1) ? memset (self->priv->viewedAncestry + self->priv->viewedAncestry_length1, 0, sizeof (ComponentInst*) * (_tmp2_ - self->priv->viewedAncestry_length1)) : NULL;
		self->priv->viewedAncestry_length1 = _tmp2_;
		self->priv->_viewedAncestry_size_ = _tmp2_;
		compiled_circuit_update_displayed (self);
	}
}


/**
 * Change the view to look at what is going on inside a subcomponent.
 */
static void _vala_array_add29 (ComponentInst*** array, int* length, int* size, ComponentInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint compiled_circuit_expand_component (CompiledCircuit* self, gint x, gint y) {
	gint result = 0;
	ComponentInst* foundComponentInst = NULL;
	CustomComponentDef* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ComponentInst* _tmp3_ = NULL;
	ComponentInst* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->viewedComponent;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = custom_component_def_find_inst (_tmp0_, _tmp1_, _tmp2_);
	foundComponentInst = _tmp3_;
	_tmp4_ = foundComponentInst;
	if (_tmp4_ != NULL) {
		ComponentInst* _tmp5_ = NULL;
		ComponentDef* _tmp6_ = NULL;
		_tmp5_ = foundComponentInst;
		_tmp6_ = _tmp5_->componentDef;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_CUSTOM_COMPONENT_DEF)) {
			ComponentInst** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			ComponentInst* _tmp8_ = NULL;
			ComponentInst* _tmp9_ = NULL;
			_tmp7_ = self->priv->viewedAncestry;
			_tmp7__length1 = self->priv->viewedAncestry_length1;
			_tmp8_ = foundComponentInst;
			_tmp9_ = _component_inst_ref0 (_tmp8_);
			_vala_array_add29 (&self->priv->viewedAncestry, &self->priv->viewedAncestry_length1, &self->priv->_viewedAncestry_size_, _tmp9_);
			compiled_circuit_update_displayed (self);
			result = 0;
			_component_inst_unref0 (foundComponentInst);
			return result;
		}
		result = 2;
		_component_inst_unref0 (foundComponentInst);
		return result;
	}
	result = 1;
	_component_inst_unref0 (foundComponentInst);
	return result;
}


/**
 * Figure out what components need to be displayed.
 * Used After changing which custom component is being viewed.
 */
static void _vala_array_add30 (ComponentState*** array, int* length, int* size, ComponentState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add31 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void compiled_circuit_update_displayed (CompiledCircuit* self) {
	ComponentState** displayedComponentStates = NULL;
	ComponentState** _tmp0_ = NULL;
	gint displayedComponentStates_length1 = 0;
	gint _displayedComponentStates_size_ = 0;
	WireState** displayedWireStates = NULL;
	WireState** _tmp1_ = NULL;
	gint displayedWireStates_length1 = 0;
	gint _displayedWireStates_size_ = 0;
	ComponentInst** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	WireState** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	UpdateQueue* _tmp35_ = NULL;
	ComponentState** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	UpdateQueue* _tmp37_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (ComponentState*, 0 + 1);
	displayedComponentStates = _tmp0_;
	displayedComponentStates_length1 = 0;
	_displayedComponentStates_size_ = displayedComponentStates_length1;
	_tmp1_ = g_new0 (WireState*, 0 + 1);
	displayedWireStates = _tmp1_;
	displayedWireStates_length1 = 0;
	_displayedWireStates_size_ = displayedWireStates_length1;
	_tmp2_ = self->priv->viewedAncestry;
	_tmp2__length1 = self->priv->viewedAncestry_length1;
	if (_tmp2__length1 > 0) {
		ComponentInst** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ComponentInst** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		ComponentInst* _tmp5_ = NULL;
		ComponentDef* _tmp6_ = NULL;
		CustomComponentDef* _tmp7_ = NULL;
		_tmp3_ = self->priv->viewedAncestry;
		_tmp3__length1 = self->priv->viewedAncestry_length1;
		_tmp4_ = self->priv->viewedAncestry;
		_tmp4__length1 = self->priv->viewedAncestry_length1;
		_tmp5_ = _tmp3_[_tmp4__length1 - 1];
		_tmp6_ = _tmp5_->componentDef;
		_tmp7_ = _component_def_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef));
		_component_def_unref0 (self->viewedComponent);
		self->viewedComponent = _tmp7_;
	} else {
		CustomComponentDef* _tmp8_ = NULL;
		CustomComponentDef* _tmp9_ = NULL;
		_tmp8_ = self->rootComponent;
		_tmp9_ = _component_def_ref0 (_tmp8_);
		_component_def_unref0 (self->viewedComponent);
		self->viewedComponent = _tmp9_;
	}
	{
		gint i = 0;
		ComponentState** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		i = 0;
		_tmp10_ = self->priv->componentStates;
		_tmp10__length1 = self->priv->componentStates_length1;
		{
			ComponentState** componentState_collection = NULL;
			gint componentState_collection_length1 = 0;
			gint _componentState_collection_size_ = 0;
			gint componentState_it = 0;
			componentState_collection = _tmp10_;
			componentState_collection_length1 = _tmp10__length1;
			for (componentState_it = 0; componentState_it < _tmp10__length1; componentState_it = componentState_it + 1) {
				ComponentState* _tmp11_ = NULL;
				ComponentState* componentState = NULL;
				_tmp11_ = _component_state_ref0 (componentState_collection[componentState_it]);
				componentState = _tmp11_;
				{
					ComponentState* _tmp12_ = NULL;
					ComponentInst** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gint _tmp14_ = 0;
					_tmp12_ = componentState;
					_tmp13_ = _tmp12_->ancestry;
					_tmp13__length1 = _tmp12_->ancestry_length1;
					_tmp14_ = compiled_circuit_check_ancestry (self, _tmp13_, _tmp13__length1);
					if (_tmp14_ == 1) {
						ComponentState* _tmp15_ = NULL;
						ComponentState* _tmp16_ = NULL;
						gint _tmp17_ = 0;
						ComponentState** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						ComponentState* _tmp19_ = NULL;
						ComponentState* _tmp20_ = NULL;
						_tmp15_ = componentState;
						_tmp15_->display = TRUE;
						_tmp16_ = componentState;
						_tmp17_ = i;
						i = _tmp17_ + 1;
						_tmp16_->renderQueueID = _tmp17_;
						_tmp18_ = displayedComponentStates;
						_tmp18__length1 = displayedComponentStates_length1;
						_tmp19_ = componentState;
						_tmp20_ = _component_state_ref0 (_tmp19_);
						_vala_array_add30 (&displayedComponentStates, &displayedComponentStates_length1, &_displayedComponentStates_size_, _tmp20_);
					} else {
						ComponentState* _tmp21_ = NULL;
						_tmp21_ = componentState;
						_tmp21_->display = FALSE;
					}
					_component_state_unref0 (componentState);
				}
			}
		}
	}
	{
		gint i = 0;
		WireState** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		i = 0;
		_tmp22_ = self->priv->wireStates;
		_tmp22__length1 = self->priv->wireStates_length1;
		{
			WireState** wireState_collection = NULL;
			gint wireState_collection_length1 = 0;
			gint _wireState_collection_size_ = 0;
			gint wireState_it = 0;
			wireState_collection = _tmp22_;
			wireState_collection_length1 = _tmp22__length1;
			for (wireState_it = 0; wireState_it < _tmp22__length1; wireState_it = wireState_it + 1) {
				WireState* _tmp23_ = NULL;
				WireState* wireState = NULL;
				_tmp23_ = _wire_state_ref0 (wireState_collection[wireState_it]);
				wireState = _tmp23_;
				{
					WireState* _tmp24_ = NULL;
					ComponentInst** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					_tmp24_ = wireState;
					_tmp25_ = _tmp24_->ancestry;
					_tmp25__length1 = _tmp24_->ancestry_length1;
					_tmp26_ = compiled_circuit_check_ancestry (self, _tmp25_, _tmp25__length1);
					if (_tmp26_ == 1) {
						WireState* _tmp27_ = NULL;
						WireState* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						WireState** _tmp30_ = NULL;
						gint _tmp30__length1 = 0;
						WireState* _tmp31_ = NULL;
						WireState* _tmp32_ = NULL;
						_tmp27_ = wireState;
						_tmp27_->display = TRUE;
						_tmp28_ = wireState;
						_tmp29_ = i;
						i = _tmp29_ + 1;
						_tmp28_->renderQueueID = _tmp29_;
						_tmp30_ = displayedWireStates;
						_tmp30__length1 = displayedWireStates_length1;
						_tmp31_ = wireState;
						_tmp32_ = _wire_state_ref0 (_tmp31_);
						_vala_array_add31 (&displayedWireStates, &displayedWireStates_length1, &_displayedWireStates_size_, _tmp32_);
					} else {
						WireState* _tmp33_ = NULL;
						_tmp33_ = wireState;
						_tmp33_->display = FALSE;
					}
					_wire_state_unref0 (wireState);
				}
			}
		}
	}
	_tmp34_ = displayedWireStates;
	_tmp34__length1 = displayedWireStates_length1;
	_tmp35_ = update_queue_new (TYPE_WIRE_STATE, (GBoxedCopyFunc) wire_state_ref, wire_state_unref, _tmp34_, _tmp34__length1, NULL, 0);
	_update_queue_unref0 (self->renderWireStates);
	self->renderWireStates = _tmp35_;
	_tmp36_ = displayedComponentStates;
	_tmp36__length1 = displayedComponentStates_length1;
	_tmp37_ = update_queue_new (TYPE_COMPONENT_STATE, (GBoxedCopyFunc) component_state_ref, component_state_unref, _tmp36_, _tmp36__length1, NULL, 0);
	_update_queue_unref0 (self->renderComponentStates);
	self->renderComponentStates = _tmp37_;
	displayedWireStates = (_vala_array_free (displayedWireStates, displayedWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	displayedComponentStates = (_vala_array_free (displayedComponentStates, displayedComponentStates_length1, (GDestroyNotify) component_state_unref), NULL);
}


/**
 * Check whether //ancestry// is the same as //viewedAncestry//.
 */
static gint compiled_circuit_check_ancestry (CompiledCircuit* self, ComponentInst** ancestry, int ancestry_length1) {
	gint result = 0;
	ComponentInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = ancestry;
	_tmp0__length1 = ancestry_length1;
	_tmp1_ = self->priv->viewedAncestry;
	_tmp1__length1 = self->priv->viewedAncestry_length1;
	if (_tmp0__length1 == _tmp1__length1) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					gint _tmp4_ = 0;
					ComponentInst** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					ComponentInst** _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					gint _tmp7_ = 0;
					ComponentInst* _tmp8_ = NULL;
					ComponentInst** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					ComponentInst* _tmp11_ = NULL;
					if (!_tmp2_) {
						gint _tmp3_ = 0;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = ancestry;
					_tmp5__length1 = ancestry_length1;
					if (!(_tmp4_ < _tmp5__length1)) {
						break;
					}
					_tmp6_ = ancestry;
					_tmp6__length1 = ancestry_length1;
					_tmp7_ = i;
					_tmp8_ = _tmp6_[_tmp7_];
					_tmp9_ = self->priv->viewedAncestry;
					_tmp9__length1 = self->priv->viewedAncestry_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					if (_tmp8_ != _tmp11_) {
						result = 0;
						return result;
					}
				}
			}
		}
		result = 1;
		return result;
	} else {
		result = 0;
		return result;
	}
}


/**
 * Interact with any components which are on the point
 * (//xInteract//, //yInteract//).
 */
void compiled_circuit_interact_components (CompiledCircuit* self, gint xInteract, gint yInteract) {
	FILE* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ComponentState** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = xInteract;
	_tmp2_ = yInteract;
	fprintf (_tmp0_, "Simulation Interaction @ (%i, %i)\n", _tmp1_, _tmp2_);
	_tmp3_ = self->priv->componentStates;
	_tmp3__length1 = self->priv->componentStates_length1;
	{
		ComponentState** componentState_collection = NULL;
		gint componentState_collection_length1 = 0;
		gint _componentState_collection_size_ = 0;
		gint componentState_it = 0;
		componentState_collection = _tmp3_;
		componentState_collection_length1 = _tmp3__length1;
		for (componentState_it = 0; componentState_it < _tmp3__length1; componentState_it = componentState_it + 1) {
			ComponentState* _tmp4_ = NULL;
			ComponentState* componentState = NULL;
			_tmp4_ = _component_state_ref0 (componentState_collection[componentState_it]);
			componentState = _tmp4_;
			{
				ComponentState* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				_tmp5_ = componentState;
				_tmp6_ = _tmp5_->display;
				if (_tmp6_) {
					ComponentState* _tmp7_ = NULL;
					ComponentInst* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					_tmp7_ = componentState;
					_tmp8_ = _tmp7_->componentInst;
					_tmp9_ = xInteract;
					_tmp10_ = yInteract;
					_tmp11_ = component_inst_find (_tmp8_, _tmp9_, _tmp10_);
					if (_tmp11_ == 1) {
						ComponentState* _tmp12_ = NULL;
						UpdateQueue* _tmp13_ = NULL;
						ComponentState* _tmp14_ = NULL;
						gint _tmp15_ = 0;
						_tmp12_ = componentState;
						component_state_click (_tmp12_);
						_tmp13_ = self->renderComponentStates;
						_tmp14_ = componentState;
						_tmp15_ = _tmp14_->renderQueueID;
						update_queue_add_element (_tmp13_, _tmp15_);
					}
				}
				_component_state_unref0 (componentState);
			}
		}
	}
}


WireState* compiled_circuit_find_wire (CompiledCircuit* self, gint x, gint y) {
	WireState* result = NULL;
	FILE* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	WireState** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = stdout;
	_tmp1_ = x;
	_tmp2_ = y;
	fprintf (_tmp0_, "Simulation Find Wire @ (%i, %i)\n", _tmp1_, _tmp2_);
	_tmp3_ = self->priv->wireStates;
	_tmp3__length1 = self->priv->wireStates_length1;
	{
		WireState** wireState_collection = NULL;
		gint wireState_collection_length1 = 0;
		gint _wireState_collection_size_ = 0;
		gint wireState_it = 0;
		wireState_collection = _tmp3_;
		wireState_collection_length1 = _tmp3__length1;
		for (wireState_it = 0; wireState_it < _tmp3__length1; wireState_it = wireState_it + 1) {
			WireState* _tmp4_ = NULL;
			WireState* wireState = NULL;
			_tmp4_ = _wire_state_ref0 (wireState_collection[wireState_it]);
			wireState = _tmp4_;
			{
				WireState* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				_tmp5_ = wireState;
				_tmp6_ = _tmp5_->display;
				if (_tmp6_) {
					gboolean _tmp7_ = FALSE;
					WireState* _tmp8_ = NULL;
					WireInst* _tmp9_ = NULL;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					Path* _tmp12_ = NULL;
					Path* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					_tmp8_ = wireState;
					_tmp9_ = _tmp8_->wireInst;
					_tmp10_ = x;
					_tmp11_ = y;
					_tmp12_ = wire_inst_find (_tmp9_, _tmp10_, _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = _tmp13_ != NULL;
					_path_unref0 (_tmp13_);
					if (_tmp14_) {
						_tmp7_ = TRUE;
					} else {
						WireState* _tmp15_ = NULL;
						WireInst* _tmp16_ = NULL;
						gint _tmp17_ = 0;
						gint _tmp18_ = 0;
						gint _tmp19_ = 0;
						_tmp15_ = wireState;
						_tmp16_ = _tmp15_->wireInst;
						_tmp17_ = x;
						_tmp18_ = y;
						_tmp19_ = wire_inst_find_tag (_tmp16_, _tmp17_, _tmp18_);
						_tmp7_ = _tmp19_ == 1;
					}
					if (_tmp7_) {
						result = wireState;
						return result;
					}
				}
				_wire_state_unref0 (wireState);
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * High level render method which calls the viewedComponent and
 * displayed objects to render. If //fullRender// is false, the
 * viewedComponent's design is not rerendered.
 */
void compiled_circuit_render (CompiledCircuit* self, cairo_t* context, gboolean fullRender, gfloat zoom) {
	gboolean _tmp0_ = FALSE;
	gfloat _tmp4_ = 0.0F;
	gboolean _tmp8_ = FALSE;
	UpdateQueue* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	cairo_t* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	UpdateQueue* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = fullRender;
	if (_tmp0_) {
		cairo_t* _tmp1_ = NULL;
		CustomComponentDef* _tmp2_ = NULL;
		cairo_t* _tmp3_ = NULL;
		_tmp1_ = context;
		cairo_set_line_width (_tmp1_, 1.0);
		_tmp2_ = self->viewedComponent;
		_tmp3_ = context;
		custom_component_def_render_insts (_tmp2_, _tmp3_, FALSE, TRUE, TRUE);
	}
	_tmp4_ = zoom;
	if (((gdouble) _tmp4_) < 1.0) {
		cairo_t* _tmp5_ = NULL;
		gfloat _tmp6_ = 0.0F;
		_tmp5_ = context;
		_tmp6_ = zoom;
		cairo_set_line_width (_tmp5_, 1.0 / _tmp6_);
	} else {
		cairo_t* _tmp7_ = NULL;
		_tmp7_ = context;
		cairo_set_line_width (_tmp7_, 1.0);
	}
	_tmp8_ = fullRender;
	if (_tmp8_) {
		UpdateQueue* _tmp9_ = NULL;
		gpointer* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		_tmp9_ = self->renderComponentStates;
		_tmp10_ = _tmp9_->elements;
		_tmp10__length1 = _tmp9_->elements_length1;
		{
			ComponentState** componentState_collection = NULL;
			gint componentState_collection_length1 = 0;
			gint _componentState_collection_size_ = 0;
			gint componentState_it = 0;
			componentState_collection = _tmp10_;
			componentState_collection_length1 = _tmp10__length1;
			for (componentState_it = 0; componentState_it < _tmp10__length1; componentState_it = componentState_it + 1) {
				ComponentState* _tmp11_ = NULL;
				ComponentState* componentState = NULL;
				_tmp11_ = _component_state_ref0 (componentState_collection[componentState_it]);
				componentState = _tmp11_;
				{
					ComponentState* _tmp12_ = NULL;
					cairo_t* _tmp13_ = NULL;
					_tmp12_ = componentState;
					_tmp13_ = context;
					component_state_render (_tmp12_, _tmp13_);
					_component_state_unref0 (componentState);
				}
			}
		}
	} else {
		ComponentState* componentState = NULL;
		while (TRUE) {
			UpdateQueue* _tmp14_ = NULL;
			gpointer _tmp15_ = NULL;
			ComponentState* _tmp16_ = NULL;
			ComponentState* _tmp17_ = NULL;
			cairo_t* _tmp18_ = NULL;
			_tmp14_ = self->renderComponentStates;
			_tmp15_ = update_queue_get_next_element (_tmp14_);
			_component_state_unref0 (componentState);
			componentState = (ComponentState*) _tmp15_;
			_tmp16_ = componentState;
			if (!(_tmp16_ != NULL)) {
				break;
			}
			_tmp17_ = componentState;
			_tmp18_ = context;
			component_state_render (_tmp17_, _tmp18_);
		}
		_component_state_unref0 (componentState);
	}
	_tmp19_ = self->renderComponentStates;
	_tmp20_ = self->iterationCount;
	update_queue_swap (_tmp19_, _tmp20_);
	_tmp21_ = context;
	cairo_set_antialias (_tmp21_, CAIRO_ANTIALIAS_NONE);
	_tmp22_ = fullRender;
	if (_tmp22_) {
		UpdateQueue* _tmp23_ = NULL;
		gpointer* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		_tmp23_ = self->renderWireStates;
		_tmp24_ = _tmp23_->elements;
		_tmp24__length1 = _tmp23_->elements_length1;
		{
			WireState** wireState_collection = NULL;
			gint wireState_collection_length1 = 0;
			gint _wireState_collection_size_ = 0;
			gint wireState_it = 0;
			wireState_collection = _tmp24_;
			wireState_collection_length1 = _tmp24__length1;
			for (wireState_it = 0; wireState_it < _tmp24__length1; wireState_it = wireState_it + 1) {
				WireState* _tmp25_ = NULL;
				WireState* wireState = NULL;
				_tmp25_ = _wire_state_ref0 (wireState_collection[wireState_it]);
				wireState = _tmp25_;
				{
					WireState* _tmp26_ = NULL;
					cairo_t* _tmp27_ = NULL;
					_tmp26_ = wireState;
					_tmp27_ = context;
					wire_state_render (_tmp26_, _tmp27_);
					_wire_state_unref0 (wireState);
				}
			}
		}
	} else {
		WireState* wireState = NULL;
		while (TRUE) {
			UpdateQueue* _tmp28_ = NULL;
			gpointer _tmp29_ = NULL;
			WireState* _tmp30_ = NULL;
			WireState* _tmp31_ = NULL;
			cairo_t* _tmp32_ = NULL;
			_tmp28_ = self->renderWireStates;
			_tmp29_ = update_queue_get_next_element (_tmp28_);
			_wire_state_unref0 (wireState);
			wireState = (WireState*) _tmp29_;
			_tmp30_ = wireState;
			if (!(_tmp30_ != NULL)) {
				break;
			}
			_tmp31_ = wireState;
			_tmp32_ = context;
			wire_state_render (_tmp31_, _tmp32_);
		}
		_wire_state_unref0 (wireState);
	}
	_tmp33_ = self->renderWireStates;
	_tmp34_ = self->iterationCount;
	update_queue_swap (_tmp33_, _tmp34_);
}


const gchar* compiled_circuit_get_errorMessage (CompiledCircuit* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_errorMessage;
	result = _tmp0_;
	return result;
}


static void compiled_circuit_set_errorMessage (CompiledCircuit* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_errorMessage);
	self->priv->_errorMessage = _tmp1_;
}


const gchar* compiled_circuit_get_warningMessage (CompiledCircuit* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_warningMessage;
	result = _tmp0_;
	return result;
}


static void compiled_circuit_set_warningMessage (CompiledCircuit* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_warningMessage);
	self->priv->_warningMessage = _tmp1_;
}


gboolean compiled_circuit_get_errorOccurred (CompiledCircuit* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_errorOccurred;
	result = _tmp0_;
	return result;
}


static void compiled_circuit_set_errorOccurred (CompiledCircuit* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_errorOccurred = _tmp0_;
}


gboolean compiled_circuit_get_warningOccurred (CompiledCircuit* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_warningOccurred;
	result = _tmp0_;
	return result;
}


static void compiled_circuit_set_warningOccurred (CompiledCircuit* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_warningOccurred = _tmp0_;
}


static void value_compiled_circuit_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_compiled_circuit_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		compiled_circuit_unref (value->data[0].v_pointer);
	}
}


static void value_compiled_circuit_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = compiled_circuit_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_compiled_circuit_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_compiled_circuit_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		CompiledCircuit* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = compiled_circuit_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_compiled_circuit_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CompiledCircuit** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = compiled_circuit_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCompiledCircuit* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_COMPILED_CIRCUIT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_compiled_circuit (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPILED_CIRCUIT), NULL);
	return value->data[0].v_pointer;
}


void value_set_compiled_circuit (GValue* value, gpointer v_object) {
	CompiledCircuit* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPILED_CIRCUIT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPILED_CIRCUIT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		compiled_circuit_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		compiled_circuit_unref (old);
	}
}


void value_take_compiled_circuit (GValue* value, gpointer v_object) {
	CompiledCircuit* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPILED_CIRCUIT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPILED_CIRCUIT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		compiled_circuit_unref (old);
	}
}


static void compiled_circuit_class_init (CompiledCircuitClass * klass) {
	compiled_circuit_parent_class = g_type_class_peek_parent (klass);
	COMPILED_CIRCUIT_CLASS (klass)->finalize = compiled_circuit_finalize;
	g_type_class_add_private (klass, sizeof (CompiledCircuitPrivate));
}


static void compiled_circuit_instance_init (CompiledCircuit * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self->priv = COMPILED_CIRCUIT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_errorMessage = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_warningMessage = _tmp1_;
	self->priv->_errorOccurred = FALSE;
	self->priv->_warningOccurred = FALSE;
	self->ref_count = 1;
}


static void compiled_circuit_finalize (CompiledCircuit* obj) {
	CompiledCircuit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPILED_CIRCUIT, CompiledCircuit);
	_component_def_unref0 (self->rootComponent);
	_project_unref0 (self->project);
	_g_free0 (self->priv->_errorMessage);
	_g_free0 (self->priv->_warningMessage);
	self->priv->wireStates = (_vala_array_free (self->priv->wireStates, self->priv->wireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	self->priv->componentStates = (_vala_array_free (self->priv->componentStates, self->priv->componentStates_length1, (GDestroyNotify) component_state_unref), NULL);
	self->priv->watchedWireStates = (_vala_array_free (self->priv->watchedWireStates, self->priv->watchedWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	_update_queue_unref0 (self->renderWireStates);
	_update_queue_unref0 (self->renderComponentStates);
	_update_queue_unref0 (self->processWireStates);
	_update_queue_unref0 (self->processComponentStates);
	self->priv->viewedAncestry = (_vala_array_free (self->priv->viewedAncestry, self->priv->viewedAncestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	_component_def_unref0 (self->viewedComponent);
}


/**
 * Handles the back-end for simulation tasks.
 * 
 * Used for high-level validation, compilation, and simulation.
 */
GType compiled_circuit_get_type (void) {
	static volatile gsize compiled_circuit_type_id__volatile = 0;
	if (g_once_init_enter (&compiled_circuit_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_compiled_circuit_init, value_compiled_circuit_free_value, value_compiled_circuit_copy_value, value_compiled_circuit_peek_pointer, "p", value_compiled_circuit_collect_value, "p", value_compiled_circuit_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CompiledCircuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) compiled_circuit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompiledCircuit), 0, (GInstanceInitFunc) compiled_circuit_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType compiled_circuit_type_id;
		compiled_circuit_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CompiledCircuit", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&compiled_circuit_type_id__volatile, compiled_circuit_type_id);
	}
	return compiled_circuit_type_id__volatile;
}


gpointer compiled_circuit_ref (gpointer instance) {
	CompiledCircuit* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void compiled_circuit_unref (gpointer instance) {
	CompiledCircuit* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		COMPILED_CIRCUIT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



