/* componentdef.c generated by valac 0.24.0, the Vala compiler
 * generated from componentdef.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentdef.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <libxml/parser.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
#define _graphic_unref0(var) ((var == NULL) ? NULL : (var = (graphic_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

#define TYPE_VERSION_COMPARISON (version_comparison_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pin_def_unref0(var) ((var == NULL) ? NULL : (var = (pin_def_unref (var), NULL)))
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _PinInstPrivate PinInstPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
typedef struct _PinDefPrivate PinDefPrivate;

#define TYPE_FLOW (flow_get_type ())

#define PIN_DEF_TYPE_LABEL_TYPE (pin_def_label_type_get_type ())
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))
typedef struct _ParamSpecComponentDef ParamSpecComponentDef;

/**
 * ComponentDef load from file errors.
 */
typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
typedef enum  {
	VERSION_COMPARISON_EQUAL,
	VERSION_COMPARISON_LESS,
	VERSION_COMPARISON_GREATER
} VersionComparison;

typedef enum  {
	GRAPHIC_LOAD_ERROR_FILE
} GraphicLoadError;
#define GRAPHIC_LOAD_ERROR graphic_load_error_quark ()
struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

typedef enum  {
	PIN_DEF_LABEL_TYPE_NONE,
	PIN_DEF_LABEL_TYPE_TEXT,
	PIN_DEF_LABEL_TYPE_TEXTBAR,
	PIN_DEF_LABEL_TYPE_CLOCK
} PinDefLabelType;

struct _PinDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinDefPrivate * priv;
	gint x;
	gint y;
	gint xLabel;
	gint yLabel;
	gint xConnect;
	gint yConnect;
	Direction direction;
	gint length;
	gboolean array;
	Flow flow;
	gint defaultArraySize;
	gint idealSpace;
	gfloat minSpace;
	gchar* label;
	gboolean required;
	gboolean userArrayResize;
	gboolean showDefault;
	PinDefLabelType labelType;
};

struct _PinDefClass {
	GTypeClass parent_class;
	void (*finalize) (PinDef *self);
};

struct _ParamSpecComponentDef {
	GParamSpec parent_instance;
};


static gpointer component_def_parent_class = NULL;

GQuark component_def_load_error_quark (void);
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
enum  {
	COMPONENT_DEF_DUMMY_PROPERTY
};
GQuark custom_component_def_load_error_quark (void);
GQuark plugin_component_def_load_error_quark (void);
void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error);
GType plugin_component_def_get_type (void) G_GNUC_CONST;
GType version_comparison_get_type (void) G_GNUC_CONST;
VersionComparison core_compare_versions (const gchar* whatVersion, const gchar* withVersion);
#define CORE_shortVersionString PACKAGE_VERSION
gboolean core_version_ignored (const gchar* extra);
gchar* core_absolute_filename (const gchar* filename, const gchar* pwd);
GQuark graphic_load_error_quark (void);
Graphic* graphic_new_from_file (const gchar* filename, GError** error);
Graphic* graphic_construct_from_file (GType object_type, const gchar* filename, GError** error);
PinDef* pin_def_new_load (xmlNode* xmlnode);
PinDef* pin_def_construct_load (GType object_type, xmlNode* xmlnode);
static void _vala_array_add32 (PinDef*** array, int* length, int* size, PinDef* value);
static PinDef** _vala_array_dup5 (PinDef** self, int length);
void component_def_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst, gboolean colourBackground);
void graphic_render (Graphic* self, cairo_t* context);
void component_def_render_box (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, gboolean colourBackground, ComponentInst* componentInst);
void component_def_extra_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
GType flow_get_type (void) G_GNUC_CONST;
GType pin_def_label_type_get_type (void) G_GNUC_CONST;
static void component_def_real_extra_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
void component_def_extra_validate (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
static void component_def_real_extra_validate (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
void component_def_add_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
static void component_def_real_add_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
void component_def_get_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
static void component_def_real_get_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
void component_def_load_properties (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
static void component_def_real_load_properties (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
void component_def_save_properties (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
static void component_def_real_save_properties (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
void component_def_configure_inst (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
static void component_def_real_configure_inst (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
void component_def_compile_component (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
static void component_def_real_compile_component (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
void component_def_create_information (ComponentDef* self, CircuitInformation* circuitInformation);
static void component_def_real_create_information (ComponentDef* self, CircuitInformation* circuitInformation);
void circuit_information_count_component (CircuitInformation* self, ComponentDef* componentDef);
ComponentDef* component_def_construct (GType object_type);
static void component_def_finalize (ComponentDef* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark component_def_load_error_quark (void) {
	return g_quark_from_static_string ("component_def_load_error-quark");
}


/**
 * Loads a component definition from a file.
 */
static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gpointer _pin_def_ref0 (gpointer self) {
	return self ? pin_def_ref (self) : NULL;
}


static void _vala_array_add32 (PinDef*** array, int* length, int* size, PinDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PinDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PinDef** _vala_array_dup5 (PinDef** self, int length) {
	PinDef** result;
	int i;
	result = g_new0 (PinDef*, length + 1);
	for (i = 0; i < length; i++) {
		PinDef* _tmp0_ = NULL;
		_tmp0_ = _pin_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error) {
	const gchar* _tmp0_ = NULL;
	FILE* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	xmlDoc* xmldoc = NULL;
	xmlNode* xmlroot = NULL;
	xmlNode* xmlnode = NULL;
	const gchar* _tmp4_ = NULL;
	xmlDoc* _tmp5_ = NULL;
	xmlDoc* _tmp6_ = NULL;
	xmlDoc* _tmp11_ = NULL;
	xmlNode* _tmp12_ = NULL;
	xmlNode* _tmp13_ = NULL;
	PinDef** pinDefs = NULL;
	PinDef** _tmp63_ = NULL;
	gint pinDefs_length1 = 0;
	gint _pinDefs_size_ = 0;
	xmlDoc* _tmp261_ = NULL;
	PinDef** _tmp262_ = NULL;
	gint _tmp262__length1 = 0;
	PinDef** _tmp263_ = NULL;
	gint _tmp263__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (infoFilename != NULL);
	_tmp0_ = infoFilename;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		FILE* _tmp1_ = NULL;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "Defining component later\n");
		return;
	}
	_tmp2_ = stdout;
	_tmp3_ = infoFilename;
	fprintf (_tmp2_, "Loading component info \"%s\"\n", _tmp3_);
	_tmp4_ = infoFilename;
	_tmp5_ = xmlParseFile (_tmp4_);
	xmldoc = _tmp5_;
	_tmp6_ = xmldoc;
	if (_tmp6_ == NULL) {
		FILE* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = infoFilename;
		fprintf (_tmp7_, "Error loading info xml file \"%s\".\n", _tmp8_);
		_tmp9_ = stdout;
		fprintf (_tmp9_, "File inaccessible.\n");
		_tmp10_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_FILE, "File inaccessible");
		_inner_error_ = _tmp10_;
		if (((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = xmldoc;
	_tmp12_ = xmlDocGetRootElement (_tmp11_);
	xmlroot = _tmp12_;
	_tmp13_ = xmlroot;
	if (_tmp13_ == NULL) {
		FILE* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		FILE* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		_tmp14_ = stdout;
		_tmp15_ = infoFilename;
		fprintf (_tmp14_, "Error loading info xml file \"%s\".\n", _tmp15_);
		_tmp16_ = stdout;
		fprintf (_tmp16_, "File is empty.\n");
		_tmp17_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_FILE, "File empty");
		_inner_error_ = _tmp17_;
		if (((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, TYPE_CUSTOM_COMPONENT_DEF)) {
		xmlNode* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp18_ = xmlroot;
		_tmp19_ = _tmp18_->name;
		if (g_strcmp0 (_tmp19_, "custom_component") != 0) {
			FILE* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			FILE* _tmp22_ = NULL;
			xmlNode* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			xmlNode* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			GError* _tmp31_ = NULL;
			GError* _tmp32_ = NULL;
			_tmp20_ = stdout;
			_tmp21_ = infoFilename;
			fprintf (_tmp20_, "Error loading info xml file \"%s\".\n", _tmp21_);
			_tmp22_ = stdout;
			_tmp23_ = xmlroot;
			_tmp24_ = _tmp23_->name;
			fprintf (_tmp22_, "Wanted \"custom_component\" info, but got \"%s\"\n", _tmp24_);
			_tmp25_ = xmlroot;
			_tmp26_ = _tmp25_->name;
			_tmp27_ = g_strconcat ("Wanted \"custom_component\" info, but got \"", _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp28_, "\"", NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_error_new_literal (CUSTOM_COMPONENT_DEF_LOAD_ERROR, CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM, _tmp30_);
			_tmp32_ = _tmp31_;
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			_inner_error_ = _tmp32_;
			if (((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (self, TYPE_PLUGIN_COMPONENT_DEF)) {
			xmlNode* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			_tmp33_ = xmlroot;
			_tmp34_ = _tmp33_->name;
			if (g_strcmp0 (_tmp34_, "plugin_component") != 0) {
				FILE* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				FILE* _tmp37_ = NULL;
				xmlNode* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				xmlNode* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				GError* _tmp46_ = NULL;
				GError* _tmp47_ = NULL;
				_tmp35_ = stdout;
				_tmp36_ = infoFilename;
				fprintf (_tmp35_, "Error loading info xml file \"%s\".\n", _tmp36_);
				_tmp37_ = stdout;
				_tmp38_ = xmlroot;
				_tmp39_ = _tmp38_->name;
				fprintf (_tmp37_, "Wanted \"plugin_component\" info, but got \"%s\"\n", _tmp39_);
				_tmp40_ = xmlroot;
				_tmp41_ = _tmp40_->name;
				_tmp42_ = g_strconcat ("Wanted \"plugin_component\" info, but got \"", _tmp41_, NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN, _tmp45_);
				_tmp47_ = _tmp46_;
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				_inner_error_ = _tmp47_;
				if (((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			xmlNode* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			_tmp48_ = xmlroot;
			_tmp49_ = _tmp48_->name;
			if (g_strcmp0 (_tmp49_, "component") != 0) {
				FILE* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				FILE* _tmp52_ = NULL;
				xmlNode* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				xmlNode* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				gchar* _tmp57_ = NULL;
				gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_ = NULL;
				GError* _tmp61_ = NULL;
				GError* _tmp62_ = NULL;
				_tmp50_ = stdout;
				_tmp51_ = infoFilename;
				fprintf (_tmp50_, "Error loading info xml file \"%s\".\n", _tmp51_);
				_tmp52_ = stdout;
				_tmp53_ = xmlroot;
				_tmp54_ = _tmp53_->name;
				fprintf (_tmp52_, "Wanted \"component\" info, but got \"%s\"\n", _tmp54_);
				_tmp55_ = xmlroot;
				_tmp56_ = _tmp55_->name;
				_tmp57_ = g_strconcat ("Wanted \"component\" info, but got \"", _tmp56_, NULL);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strconcat (_tmp58_, "\"", NULL);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT, _tmp60_);
				_tmp62_ = _tmp61_;
				_g_free0 (_tmp60_);
				_g_free0 (_tmp58_);
				_inner_error_ = _tmp62_;
				if (((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	_tmp63_ = g_new0 (PinDef*, 0 + 1);
	pinDefs = _tmp63_;
	pinDefs_length1 = 0;
	_pinDefs_size_ = pinDefs_length1;
	{
		xmlNode* _tmp64_ = NULL;
		xmlNode* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		_tmp64_ = xmlroot;
		_tmp65_ = _tmp64_->children;
		xmlnode = _tmp65_;
		_tmp66_ = TRUE;
		while (TRUE) {
			xmlNode* _tmp69_ = NULL;
			xmlNode* _tmp70_ = NULL;
			xmlElementType _tmp71_ = 0;
			xmlNode* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			const gchar* _tmp74_ = NULL;
			GQuark _tmp76_ = 0U;
			static GQuark _tmp75_label0 = 0;
			static GQuark _tmp75_label1 = 0;
			static GQuark _tmp75_label2 = 0;
			static GQuark _tmp75_label3 = 0;
			static GQuark _tmp75_label4 = 0;
			static GQuark _tmp75_label5 = 0;
			static GQuark _tmp75_label6 = 0;
			static GQuark _tmp75_label7 = 0;
			static GQuark _tmp75_label8 = 0;
			static GQuark _tmp75_label9 = 0;
			if (!_tmp66_) {
				xmlNode* _tmp67_ = NULL;
				xmlNode* _tmp68_ = NULL;
				_tmp67_ = xmlnode;
				_tmp68_ = _tmp67_->next;
				xmlnode = _tmp68_;
			}
			_tmp66_ = FALSE;
			_tmp69_ = xmlnode;
			if (!(_tmp69_ != NULL)) {
				break;
			}
			_tmp70_ = xmlnode;
			_tmp71_ = _tmp70_->type;
			if (_tmp71_ != XML_ELEMENT_NODE) {
				continue;
			}
			_tmp72_ = xmlnode;
			_tmp73_ = _tmp72_->name;
			_tmp74_ = _tmp73_;
			_tmp76_ = (NULL == _tmp74_) ? 0 : g_quark_from_string (_tmp74_);
			if (_tmp76_ == ((0 != _tmp75_label0) ? _tmp75_label0 : (_tmp75_label0 = g_quark_from_static_string ("metadata")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp77_ = NULL;
								xmlNode* _tmp78_ = NULL;
								_tmp77_ = xmlnode;
								_tmp78_ = _tmp77_->children;
								xmldata = _tmp78_;
								{
									gboolean _tmp79_ = FALSE;
									_tmp79_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp82_ = NULL;
										xmlNode* _tmp83_ = NULL;
										xmlElementType _tmp84_ = 0;
										xmlNode* _tmp85_ = NULL;
										const gchar* _tmp86_ = NULL;
										const gchar* _tmp87_ = NULL;
										GQuark _tmp89_ = 0U;
										static GQuark _tmp88_label0 = 0;
										if (!_tmp79_) {
											xmlNode* _tmp80_ = NULL;
											xmlNode* _tmp81_ = NULL;
											_tmp80_ = xmldata;
											_tmp81_ = _tmp80_->next;
											xmldata = _tmp81_;
										}
										_tmp79_ = FALSE;
										_tmp82_ = xmldata;
										if (!(_tmp82_ != NULL)) {
											break;
										}
										_tmp83_ = xmldata;
										_tmp84_ = _tmp83_->type;
										if (_tmp84_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp85_ = xmldata;
										_tmp86_ = _tmp85_->name;
										_tmp87_ = _tmp86_;
										_tmp89_ = (NULL == _tmp87_) ? 0 : g_quark_from_string (_tmp87_);
										if (_tmp89_ == ((0 != _tmp88_label0) ? _tmp88_label0 : (_tmp88_label0 = g_quark_from_static_string ("version")))) {
											switch (0) {
												default:
												{
													{
														{
															xmlAttr* xmlattr = NULL;
															xmlNode* _tmp90_ = NULL;
															xmlAttr* _tmp91_ = NULL;
															_tmp90_ = xmldata;
															_tmp91_ = _tmp90_->properties;
															xmlattr = _tmp91_;
															{
																gboolean _tmp92_ = FALSE;
																_tmp92_ = TRUE;
																while (TRUE) {
																	xmlAttr* _tmp95_ = NULL;
																	xmlAttr* _tmp96_ = NULL;
																	const gchar* _tmp97_ = NULL;
																	const gchar* _tmp98_ = NULL;
																	GQuark _tmp100_ = 0U;
																	static GQuark _tmp99_label0 = 0;
																	if (!_tmp92_) {
																		xmlAttr* _tmp93_ = NULL;
																		xmlAttr* _tmp94_ = NULL;
																		_tmp93_ = xmlattr;
																		_tmp94_ = _tmp93_->next;
																		xmlattr = _tmp94_;
																	}
																	_tmp92_ = FALSE;
																	_tmp95_ = xmlattr;
																	if (!(_tmp95_ != NULL)) {
																		break;
																	}
																	_tmp96_ = xmlattr;
																	_tmp97_ = _tmp96_->name;
																	_tmp98_ = _tmp97_;
																	_tmp100_ = (NULL == _tmp98_) ? 0 : g_quark_from_string (_tmp98_);
																	if (_tmp100_ == ((0 != _tmp99_label0) ? _tmp99_label0 : (_tmp99_label0 = g_quark_from_static_string ("smartsim")))) {
																		switch (0) {
																			default:
																			{
																				xmlAttr* _tmp101_ = NULL;
																				xmlNode* _tmp102_ = NULL;
																				const gchar* _tmp103_ = NULL;
																				VersionComparison _tmp104_ = 0;
																				_tmp101_ = xmlattr;
																				_tmp102_ = _tmp101_->children;
																				_tmp103_ = _tmp102_->content;
																				_tmp104_ = core_compare_versions (_tmp103_, CORE_shortVersionString);
																				if (_tmp104_ == VERSION_COMPARISON_GREATER) {
																					const gchar* _tmp105_ = NULL;
																					gchar* _tmp106_ = NULL;
																					gchar* _tmp107_ = NULL;
																					gchar* _tmp108_ = NULL;
																					gchar* _tmp109_ = NULL;
																					gboolean _tmp110_ = FALSE;
																					gboolean _tmp111_ = FALSE;
																					_tmp105_ = infoFilename;
																					_tmp106_ = g_strconcat ("Component File: \"", _tmp105_, NULL);
																					_tmp107_ = _tmp106_;
																					_tmp108_ = g_strconcat (_tmp107_, "\"", NULL);
																					_tmp109_ = _tmp108_;
																					_tmp110_ = core_version_ignored (_tmp109_);
																					_tmp111_ = _tmp110_ == FALSE;
																					_g_free0 (_tmp109_);
																					_g_free0 (_tmp107_);
																					if (_tmp111_) {
																						GError* _tmp112_ = NULL;
																						_tmp112_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_CANCEL, "SmartSim version of component is higher than running version.");
																						_inner_error_ = _tmp112_;
																						if (((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
																							g_propagate_error (error, _inner_error_);
																							pinDefs = (_vala_array_free (pinDefs, pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
																							return;
																						} else {
																							pinDefs = (_vala_array_free (pinDefs, pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																							g_clear_error (&_inner_error_);
																							return;
																						}
																					}
																				}
																				break;
																			}
																		}
																	}
																}
															}
														}
													}
													break;
												}
											}
										}
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp76_ == ((0 != _tmp75_label1) ? _tmp75_label1 : (_tmp75_label1 = g_quark_from_static_string ("name")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp113_ = NULL;
								xmlNode* _tmp114_ = NULL;
								_tmp113_ = xmlnode;
								_tmp114_ = _tmp113_->children;
								xmldata = _tmp114_;
								{
									gboolean _tmp115_ = FALSE;
									_tmp115_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp118_ = NULL;
										xmlNode* _tmp119_ = NULL;
										xmlElementType _tmp120_ = 0;
										xmlNode* _tmp121_ = NULL;
										const gchar* _tmp122_ = NULL;
										gchar* _tmp123_ = NULL;
										if (!_tmp115_) {
											xmlNode* _tmp116_ = NULL;
											xmlNode* _tmp117_ = NULL;
											_tmp116_ = xmldata;
											_tmp117_ = _tmp116_->next;
											xmldata = _tmp117_;
										}
										_tmp115_ = FALSE;
										_tmp118_ = xmldata;
										if (!(_tmp118_ != NULL)) {
											break;
										}
										_tmp119_ = xmlnode;
										_tmp120_ = _tmp119_->type;
										if (_tmp120_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp121_ = xmldata;
										_tmp122_ = _tmp121_->content;
										_tmp123_ = g_strdup (_tmp122_);
										_g_free0 (self->name);
										self->name = _tmp123_;
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp76_ == ((0 != _tmp75_label2) ? _tmp75_label2 : (_tmp75_label2 = g_quark_from_static_string ("description")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp124_ = NULL;
								xmlNode* _tmp125_ = NULL;
								_tmp124_ = xmlnode;
								_tmp125_ = _tmp124_->children;
								xmldata = _tmp125_;
								{
									gboolean _tmp126_ = FALSE;
									_tmp126_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp129_ = NULL;
										xmlNode* _tmp130_ = NULL;
										xmlElementType _tmp131_ = 0;
										xmlNode* _tmp132_ = NULL;
										const gchar* _tmp133_ = NULL;
										gchar* _tmp134_ = NULL;
										if (!_tmp126_) {
											xmlNode* _tmp127_ = NULL;
											xmlNode* _tmp128_ = NULL;
											_tmp127_ = xmldata;
											_tmp128_ = _tmp127_->next;
											xmldata = _tmp128_;
										}
										_tmp126_ = FALSE;
										_tmp129_ = xmldata;
										if (!(_tmp129_ != NULL)) {
											break;
										}
										_tmp130_ = xmlnode;
										_tmp131_ = _tmp130_->type;
										if (_tmp131_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp132_ = xmldata;
										_tmp133_ = _tmp132_->content;
										_tmp134_ = g_strdup (_tmp133_);
										_g_free0 (self->description);
										self->description = _tmp134_;
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp76_ == ((0 != _tmp75_label3) ? _tmp75_label3 : (_tmp75_label3 = g_quark_from_static_string ("icon")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp135_ = NULL;
								xmlNode* _tmp136_ = NULL;
								_tmp135_ = xmlnode;
								_tmp136_ = _tmp135_->children;
								xmldata = _tmp136_;
								{
									gboolean _tmp137_ = FALSE;
									_tmp137_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp140_ = NULL;
										xmlNode* _tmp141_ = NULL;
										xmlElementType _tmp142_ = 0;
										xmlNode* _tmp143_ = NULL;
										const gchar* _tmp144_ = NULL;
										gchar* _tmp145_ = NULL;
										if (!_tmp137_) {
											xmlNode* _tmp138_ = NULL;
											xmlNode* _tmp139_ = NULL;
											_tmp138_ = xmldata;
											_tmp139_ = _tmp138_->next;
											xmldata = _tmp139_;
										}
										_tmp137_ = FALSE;
										_tmp140_ = xmldata;
										if (!(_tmp140_ != NULL)) {
											break;
										}
										_tmp141_ = xmlnode;
										_tmp142_ = _tmp141_->type;
										if (_tmp142_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp143_ = xmldata;
										_tmp144_ = _tmp143_->content;
										_tmp145_ = g_strdup (_tmp144_);
										_g_free0 (self->iconFilename);
										self->iconFilename = _tmp145_;
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp76_ == ((0 != _tmp75_label4) ? _tmp75_label4 : (_tmp75_label4 = g_quark_from_static_string ("graphic")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp146_ = NULL;
								xmlNode* _tmp147_ = NULL;
								_tmp146_ = xmlnode;
								_tmp147_ = _tmp146_->children;
								xmldata = _tmp147_;
								{
									gboolean _tmp148_ = FALSE;
									_tmp148_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp151_ = NULL;
										xmlNode* _tmp152_ = NULL;
										xmlElementType _tmp153_ = 0;
										xmlNode* _tmp154_ = NULL;
										const gchar* _tmp155_ = NULL;
										gchar* _tmp156_ = NULL;
										if (!_tmp148_) {
											xmlNode* _tmp149_ = NULL;
											xmlNode* _tmp150_ = NULL;
											_tmp149_ = xmldata;
											_tmp150_ = _tmp149_->next;
											xmldata = _tmp150_;
										}
										_tmp148_ = FALSE;
										_tmp151_ = xmldata;
										if (!(_tmp151_ != NULL)) {
											break;
										}
										_tmp152_ = xmlnode;
										_tmp153_ = _tmp152_->type;
										if (_tmp153_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp154_ = xmldata;
										_tmp155_ = _tmp154_->content;
										_tmp156_ = g_strdup (_tmp155_);
										_g_free0 (self->graphicReferenceFilename);
										self->graphicReferenceFilename = _tmp156_;
										{
											Graphic* _tmp157_ = NULL;
											xmlNode* _tmp158_ = NULL;
											const gchar* _tmp159_ = NULL;
											const gchar* _tmp160_ = NULL;
											gchar* _tmp161_ = NULL;
											gchar* _tmp162_ = NULL;
											gchar* _tmp163_ = NULL;
											gchar* _tmp164_ = NULL;
											Graphic* _tmp165_ = NULL;
											Graphic* _tmp166_ = NULL;
											Graphic* _tmp167_ = NULL;
											_tmp158_ = xmldata;
											_tmp159_ = _tmp158_->content;
											_tmp160_ = infoFilename;
											_tmp161_ = g_path_get_dirname (_tmp160_);
											_tmp162_ = _tmp161_;
											_tmp163_ = core_absolute_filename (_tmp159_, _tmp162_);
											_tmp164_ = _tmp163_;
											_tmp165_ = graphic_new_from_file (_tmp164_, &_inner_error_);
											_tmp166_ = _tmp165_;
											_g_free0 (_tmp164_);
											_g_free0 (_tmp162_);
											_tmp157_ = _tmp166_;
											if (_inner_error_ != NULL) {
												goto __catch3_g_error;
											}
											_tmp167_ = _tmp157_;
											_tmp157_ = NULL;
											_graphic_unref0 (self->graphic);
											self->graphic = _tmp167_;
											_graphic_unref0 (_tmp157_);
										}
										goto __finally3;
										__catch3_g_error:
										{
											g_clear_error (&_inner_error_);
											_inner_error_ = NULL;
											{
												Graphic* _tmp168_ = NULL;
												xmlNode* _tmp169_ = NULL;
												const gchar* _tmp170_ = NULL;
												gchar* _tmp171_ = NULL;
												gchar* _tmp172_ = NULL;
												Graphic* _tmp173_ = NULL;
												Graphic* _tmp174_ = NULL;
												Graphic* _tmp175_ = NULL;
												_tmp169_ = xmldata;
												_tmp170_ = _tmp169_->content;
												_tmp171_ = g_strconcat (PACKAGE_DATADIR "components/graphics/", _tmp170_, NULL);
												_tmp172_ = _tmp171_;
												_tmp173_ = graphic_new_from_file (_tmp172_, &_inner_error_);
												_tmp174_ = _tmp173_;
												_g_free0 (_tmp172_);
												_tmp168_ = _tmp174_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == GRAPHIC_LOAD_ERROR) {
														goto __catch4_graphic_load_error;
													}
													pinDefs = (_vala_array_free (pinDefs, pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return;
												}
												_tmp175_ = _tmp168_;
												_tmp168_ = NULL;
												_graphic_unref0 (self->graphic);
												self->graphic = _tmp175_;
												_graphic_unref0 (_tmp168_);
											}
											goto __finally4;
											__catch4_graphic_load_error:
											{
												GError* _error_ = NULL;
												FILE* _tmp176_ = NULL;
												xmlNode* _tmp177_ = NULL;
												const gchar* _tmp178_ = NULL;
												gchar* _tmp179_ = NULL;
												gchar* _tmp180_ = NULL;
												gchar* _tmp181_ = NULL;
												gchar* _tmp182_ = NULL;
												_error_ = _inner_error_;
												_inner_error_ = NULL;
												_tmp176_ = stdout;
												_tmp177_ = xmldata;
												_tmp178_ = _tmp177_->content;
												_tmp179_ = g_strconcat ("Cannot load graphic \"", _tmp178_, NULL);
												_tmp180_ = _tmp179_;
												_tmp181_ = g_strconcat (_tmp180_, "\"\n", NULL);
												_tmp182_ = _tmp181_;
												fprintf (_tmp176_, "%s", _tmp182_);
												_g_free0 (_tmp182_);
												_g_free0 (_tmp180_);
												_g_error_free0 (_error_);
											}
											__finally4:
											if (_inner_error_ != NULL) {
												pinDefs = (_vala_array_free (pinDefs, pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return;
											}
										}
										__finally3:
										if (_inner_error_ != NULL) {
											if (((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
												g_propagate_error (error, _inner_error_);
												pinDefs = (_vala_array_free (pinDefs, pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
												return;
											} else {
												pinDefs = (_vala_array_free (pinDefs, pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return;
											}
										}
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp76_ == ((0 != _tmp75_label5) ? _tmp75_label5 : (_tmp75_label5 = g_quark_from_static_string ("label")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp183_ = NULL;
								xmlNode* _tmp184_ = NULL;
								_tmp183_ = xmlnode;
								_tmp184_ = _tmp183_->children;
								xmldata = _tmp184_;
								{
									gboolean _tmp185_ = FALSE;
									_tmp185_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp188_ = NULL;
										xmlNode* _tmp189_ = NULL;
										xmlElementType _tmp190_ = 0;
										xmlNode* _tmp191_ = NULL;
										const gchar* _tmp192_ = NULL;
										gchar* _tmp193_ = NULL;
										if (!_tmp185_) {
											xmlNode* _tmp186_ = NULL;
											xmlNode* _tmp187_ = NULL;
											_tmp186_ = xmldata;
											_tmp187_ = _tmp186_->next;
											xmldata = _tmp187_;
										}
										_tmp185_ = FALSE;
										_tmp188_ = xmldata;
										if (!(_tmp188_ != NULL)) {
											break;
										}
										_tmp189_ = xmlnode;
										_tmp190_ = _tmp189_->type;
										if (_tmp190_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp191_ = xmldata;
										_tmp192_ = _tmp191_->content;
										_tmp193_ = g_strdup (_tmp192_);
										_g_free0 (self->label);
										self->label = _tmp193_;
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp76_ == ((0 != _tmp75_label6) ? _tmp75_label6 : (_tmp75_label6 = g_quark_from_static_string ("bound")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlAttr* xmlattr = NULL;
								xmlNode* _tmp194_ = NULL;
								xmlAttr* _tmp195_ = NULL;
								_tmp194_ = xmlnode;
								_tmp195_ = _tmp194_->properties;
								xmlattr = _tmp195_;
								{
									gboolean _tmp196_ = FALSE;
									_tmp196_ = TRUE;
									while (TRUE) {
										xmlAttr* _tmp199_ = NULL;
										xmlAttr* _tmp200_ = NULL;
										const gchar* _tmp201_ = NULL;
										const gchar* _tmp202_ = NULL;
										GQuark _tmp204_ = 0U;
										static GQuark _tmp203_label0 = 0;
										static GQuark _tmp203_label1 = 0;
										static GQuark _tmp203_label2 = 0;
										static GQuark _tmp203_label3 = 0;
										static GQuark _tmp203_label4 = 0;
										if (!_tmp196_) {
											xmlAttr* _tmp197_ = NULL;
											xmlAttr* _tmp198_ = NULL;
											_tmp197_ = xmlattr;
											_tmp198_ = _tmp197_->next;
											xmlattr = _tmp198_;
										}
										_tmp196_ = FALSE;
										_tmp199_ = xmlattr;
										if (!(_tmp199_ != NULL)) {
											break;
										}
										_tmp200_ = xmlattr;
										_tmp201_ = _tmp200_->name;
										_tmp202_ = _tmp201_;
										_tmp204_ = (NULL == _tmp202_) ? 0 : g_quark_from_string (_tmp202_);
										if (_tmp204_ == ((0 != _tmp203_label0) ? _tmp203_label0 : (_tmp203_label0 = g_quark_from_static_string ("right")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp205_ = NULL;
													xmlNode* _tmp206_ = NULL;
													const gchar* _tmp207_ = NULL;
													gint _tmp208_ = 0;
													_tmp205_ = xmlattr;
													_tmp206_ = _tmp205_->children;
													_tmp207_ = _tmp206_->content;
													_tmp208_ = atoi (_tmp207_);
													self->rightBound = _tmp208_;
													break;
												}
											}
										} else if (_tmp204_ == ((0 != _tmp203_label1) ? _tmp203_label1 : (_tmp203_label1 = g_quark_from_static_string ("down")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp209_ = NULL;
													xmlNode* _tmp210_ = NULL;
													const gchar* _tmp211_ = NULL;
													gint _tmp212_ = 0;
													_tmp209_ = xmlattr;
													_tmp210_ = _tmp209_->children;
													_tmp211_ = _tmp210_->content;
													_tmp212_ = atoi (_tmp211_);
													self->downBound = _tmp212_;
													break;
												}
											}
										} else if (_tmp204_ == ((0 != _tmp203_label2) ? _tmp203_label2 : (_tmp203_label2 = g_quark_from_static_string ("left")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp213_ = NULL;
													xmlNode* _tmp214_ = NULL;
													const gchar* _tmp215_ = NULL;
													gint _tmp216_ = 0;
													_tmp213_ = xmlattr;
													_tmp214_ = _tmp213_->children;
													_tmp215_ = _tmp214_->content;
													_tmp216_ = atoi (_tmp215_);
													self->leftBound = _tmp216_;
													break;
												}
											}
										} else if (_tmp204_ == ((0 != _tmp203_label3) ? _tmp203_label3 : (_tmp203_label3 = g_quark_from_static_string ("up")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp217_ = NULL;
													xmlNode* _tmp218_ = NULL;
													const gchar* _tmp219_ = NULL;
													gint _tmp220_ = 0;
													_tmp217_ = xmlattr;
													_tmp218_ = _tmp217_->children;
													_tmp219_ = _tmp218_->content;
													_tmp220_ = atoi (_tmp219_);
													self->upBound = _tmp220_;
													break;
												}
											}
										} else if (_tmp204_ == ((0 != _tmp203_label4) ? _tmp203_label4 : (_tmp203_label4 = g_quark_from_static_string ("drawbox")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp221_ = NULL;
													xmlNode* _tmp222_ = NULL;
													const gchar* _tmp223_ = NULL;
													gboolean _tmp224_ = FALSE;
													_tmp221_ = xmlattr;
													_tmp222_ = _tmp221_->children;
													_tmp223_ = _tmp222_->content;
													_tmp224_ = bool_parse (_tmp223_);
													self->drawBox = _tmp224_;
													break;
												}
											}
										}
									}
								}
							}
						}
						break;
					}
				}
			} else if ((_tmp76_ == ((0 != _tmp75_label7) ? _tmp75_label7 : (_tmp75_label7 = g_quark_from_static_string ("color")))) || (_tmp76_ == ((0 != _tmp75_label8) ? _tmp75_label8 : (_tmp75_label8 = g_quark_from_static_string ("colour"))))) {
				switch (0) {
					default:
					{
						{
							{
								xmlAttr* xmlattr = NULL;
								xmlNode* _tmp225_ = NULL;
								xmlAttr* _tmp226_ = NULL;
								_tmp225_ = xmlnode;
								_tmp226_ = _tmp225_->properties;
								xmlattr = _tmp226_;
								{
									gboolean _tmp227_ = FALSE;
									_tmp227_ = TRUE;
									while (TRUE) {
										xmlAttr* _tmp230_ = NULL;
										xmlAttr* _tmp231_ = NULL;
										const gchar* _tmp232_ = NULL;
										const gchar* _tmp233_ = NULL;
										GQuark _tmp235_ = 0U;
										static GQuark _tmp234_label0 = 0;
										static GQuark _tmp234_label1 = 0;
										static GQuark _tmp234_label2 = 0;
										static GQuark _tmp234_label3 = 0;
										if (!_tmp227_) {
											xmlAttr* _tmp228_ = NULL;
											xmlAttr* _tmp229_ = NULL;
											_tmp228_ = xmlattr;
											_tmp229_ = _tmp228_->next;
											xmlattr = _tmp229_;
										}
										_tmp227_ = FALSE;
										_tmp230_ = xmlattr;
										if (!(_tmp230_ != NULL)) {
											break;
										}
										_tmp231_ = xmlattr;
										_tmp232_ = _tmp231_->name;
										_tmp233_ = _tmp232_;
										_tmp235_ = (NULL == _tmp233_) ? 0 : g_quark_from_string (_tmp233_);
										if (_tmp235_ == ((0 != _tmp234_label0) ? _tmp234_label0 : (_tmp234_label0 = g_quark_from_static_string ("a")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp236_ = NULL;
													xmlNode* _tmp237_ = NULL;
													const gchar* _tmp238_ = NULL;
													gint _tmp239_ = 0;
													gint _tmp240_ = 0;
													_tmp236_ = xmlattr;
													_tmp237_ = _tmp236_->children;
													_tmp238_ = _tmp237_->content;
													_tmp239_ = atoi (_tmp238_);
													self->backgroundAlpha = _tmp239_;
													_tmp240_ = self->backgroundAlpha;
													self->backgroundAlphaF = ((gdouble) _tmp240_) / 255.0;
													break;
												}
											}
										} else if (_tmp235_ == ((0 != _tmp234_label1) ? _tmp234_label1 : (_tmp234_label1 = g_quark_from_static_string ("r")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp241_ = NULL;
													xmlNode* _tmp242_ = NULL;
													const gchar* _tmp243_ = NULL;
													gint _tmp244_ = 0;
													gint _tmp245_ = 0;
													_tmp241_ = xmlattr;
													_tmp242_ = _tmp241_->children;
													_tmp243_ = _tmp242_->content;
													_tmp244_ = atoi (_tmp243_);
													self->backgroundRed = _tmp244_;
													_tmp245_ = self->backgroundRed;
													self->backgroundRedF = ((gdouble) _tmp245_) / 255.0;
													break;
												}
											}
										} else if (_tmp235_ == ((0 != _tmp234_label2) ? _tmp234_label2 : (_tmp234_label2 = g_quark_from_static_string ("g")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp246_ = NULL;
													xmlNode* _tmp247_ = NULL;
													const gchar* _tmp248_ = NULL;
													gint _tmp249_ = 0;
													gint _tmp250_ = 0;
													_tmp246_ = xmlattr;
													_tmp247_ = _tmp246_->children;
													_tmp248_ = _tmp247_->content;
													_tmp249_ = atoi (_tmp248_);
													self->backgroundGreen = _tmp249_;
													_tmp250_ = self->backgroundGreen;
													self->backgroundGreenF = ((gdouble) _tmp250_) / 255.0;
													break;
												}
											}
										} else if (_tmp235_ == ((0 != _tmp234_label3) ? _tmp234_label3 : (_tmp234_label3 = g_quark_from_static_string ("b")))) {
											switch (0) {
												default:
												{
													xmlAttr* _tmp251_ = NULL;
													xmlNode* _tmp252_ = NULL;
													const gchar* _tmp253_ = NULL;
													gint _tmp254_ = 0;
													gint _tmp255_ = 0;
													_tmp251_ = xmlattr;
													_tmp252_ = _tmp251_->children;
													_tmp253_ = _tmp252_->content;
													_tmp254_ = atoi (_tmp253_);
													self->backgroundBlue = _tmp254_;
													_tmp255_ = self->backgroundBlue;
													self->backgroundBlueF = ((gdouble) _tmp255_) / 255.0;
													break;
												}
											}
										}
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp76_ == ((0 != _tmp75_label9) ? _tmp75_label9 : (_tmp75_label9 = g_quark_from_static_string ("pin")))) {
				switch (0) {
					default:
					{
						{
							PinDef* pinDef = NULL;
							xmlNode* _tmp256_ = NULL;
							PinDef* _tmp257_ = NULL;
							PinDef** _tmp258_ = NULL;
							gint _tmp258__length1 = 0;
							PinDef* _tmp259_ = NULL;
							PinDef* _tmp260_ = NULL;
							_tmp256_ = xmlnode;
							_tmp257_ = pin_def_new_load (_tmp256_);
							pinDef = _tmp257_;
							_tmp258_ = pinDefs;
							_tmp258__length1 = pinDefs_length1;
							_tmp259_ = pinDef;
							_tmp260_ = _pin_def_ref0 (_tmp259_);
							_vala_array_add32 (&pinDefs, &pinDefs_length1, &_pinDefs_size_, _tmp260_);
							_pin_def_unref0 (pinDef);
						}
						break;
					}
				}
			}
		}
	}
	_tmp261_ = xmldoc;
	xmlFreeDoc (_tmp261_);
	_tmp262_ = pinDefs;
	_tmp262__length1 = pinDefs_length1;
	_tmp263_ = (_tmp262_ != NULL) ? _vala_array_dup5 (_tmp262_, _tmp262__length1) : ((gpointer) _tmp262_);
	_tmp263__length1 = _tmp262__length1;
	self->pinDefs = (_vala_array_free (self->pinDefs, self->pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
	self->pinDefs = _tmp263_;
	self->pinDefs_length1 = _tmp263__length1;
	pinDefs = (_vala_array_free (pinDefs, pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
	return;
}


/**
 * Render the component's image, excluding pins. Either renders the
 * graphic or box diagram.
 */
void component_def_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst, gboolean colourBackground) {
	Graphic* _tmp0_ = NULL;
	cairo_t* _tmp17_ = NULL;
	Direction _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	ComponentInst* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->graphic;
	if (_tmp0_ != NULL) {
		cairo_matrix_t oldMatrix = {0};
		cairo_t* _tmp1_ = NULL;
		cairo_matrix_t _tmp2_ = {0};
		gdouble angle = 0.0;
		Direction _tmp3_ = 0;
		cairo_t* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gboolean _tmp6_ = FALSE;
		Graphic* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		cairo_t* _tmp10_ = NULL;
		cairo_matrix_t _tmp11_ = {0};
		_tmp1_ = context;
		cairo_get_matrix (_tmp1_, &_tmp2_);
		oldMatrix = _tmp2_;
		angle = (gdouble) 0;
		_tmp3_ = direction;
		switch (_tmp3_) {
			case DIRECTION_RIGHT:
			{
				angle = (gdouble) 0;
				break;
			}
			case DIRECTION_DOWN:
			{
				angle = G_PI * 0.5;
				break;
			}
			case DIRECTION_LEFT:
			{
				angle = G_PI;
				break;
			}
			case DIRECTION_UP:
			{
				angle = G_PI * 1.5;
				break;
			}
			default:
			break;
		}
		_tmp4_ = context;
		_tmp5_ = angle;
		cairo_rotate (_tmp4_, _tmp5_);
		_tmp6_ = flipped;
		if (_tmp6_) {
			cairo_t* _tmp7_ = NULL;
			_tmp7_ = context;
			cairo_scale (_tmp7_, 1.0, -1.0);
		}
		_tmp8_ = self->graphic;
		_tmp9_ = context;
		graphic_render (_tmp8_, _tmp9_);
		_tmp10_ = context;
		_tmp11_ = oldMatrix;
		cairo_set_matrix (_tmp10_, &_tmp11_);
	} else {
		cairo_t* _tmp12_ = NULL;
		Direction _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		ComponentInst* _tmp16_ = NULL;
		_tmp12_ = context;
		_tmp13_ = direction;
		_tmp14_ = flipped;
		_tmp15_ = colourBackground;
		_tmp16_ = componentInst;
		component_def_render_box (self, _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
	}
	_tmp17_ = context;
	_tmp18_ = direction;
	_tmp19_ = flipped;
	_tmp20_ = componentInst;
	component_def_extra_render (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
}


/**
 * Renders the box diagram. Used when there is no graphic.
 */
void component_def_render_box (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, gboolean colourBackground, ComponentInst* componentInst) {
	cairo_matrix_t oldMatrix = {0};
	cairo_matrix_t oldMatrix2 = {0};
	cairo_text_extents_t textExtents = {0};
	gint rightBound = 0;
	gint downBound = 0;
	gint leftBound = 0;
	gint upBound = 0;
	ComponentInst* _tmp0_ = NULL;
	cairo_t* _tmp13_ = NULL;
	cairo_matrix_t _tmp14_ = {0};
	cairo_t* _tmp15_ = NULL;
	gdouble angle = 0.0;
	Direction _tmp16_ = 0;
	cairo_t* _tmp17_ = NULL;
	gdouble _tmp18_ = 0.0;
	gboolean _tmp19_ = FALSE;
	cairo_t* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	cairo_t* _tmp66_ = NULL;
	cairo_matrix_t _tmp67_ = {0};
	cairo_t* _tmp68_ = NULL;
	cairo_matrix_t _tmp69_ = {0};
	cairo_t* _tmp70_ = NULL;
	cairo_t* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	cairo_text_extents_t _tmp73_ = {0};
	cairo_t* _tmp74_ = NULL;
	cairo_text_extents_t _tmp75_ = {0};
	gdouble _tmp76_ = 0.0;
	cairo_text_extents_t _tmp77_ = {0};
	gdouble _tmp78_ = 0.0;
	cairo_t* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	cairo_t* _tmp81_ = NULL;
	cairo_matrix_t _tmp82_ = {0};
	cairo_t* _tmp83_ = NULL;
	cairo_t* _tmp185_ = NULL;
	cairo_matrix_t _tmp186_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = componentInst;
	if (_tmp0_ == NULL) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp1_ = self->rightBound;
		rightBound = _tmp1_;
		_tmp2_ = self->downBound;
		downBound = _tmp2_;
		_tmp3_ = self->leftBound;
		leftBound = _tmp3_;
		_tmp4_ = self->upBound;
		upBound = _tmp4_;
	} else {
		ComponentInst* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		ComponentInst* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		ComponentInst* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		ComponentInst* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp5_ = componentInst;
		_tmp6_ = _tmp5_->rightBound;
		rightBound = _tmp6_;
		_tmp7_ = componentInst;
		_tmp8_ = _tmp7_->downBound;
		downBound = _tmp8_;
		_tmp9_ = componentInst;
		_tmp10_ = _tmp9_->leftBound;
		leftBound = _tmp10_;
		_tmp11_ = componentInst;
		_tmp12_ = _tmp11_->upBound;
		upBound = _tmp12_;
	}
	_tmp13_ = context;
	cairo_get_matrix (_tmp13_, &_tmp14_);
	oldMatrix = _tmp14_;
	_tmp15_ = context;
	cairo_set_source_rgba (_tmp15_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	angle = (gdouble) 0;
	_tmp16_ = direction;
	switch (_tmp16_) {
		case DIRECTION_RIGHT:
		{
			angle = (gdouble) 0;
			break;
		}
		case DIRECTION_DOWN:
		{
			angle = G_PI * 0.5;
			break;
		}
		case DIRECTION_LEFT:
		{
			angle = G_PI;
			break;
		}
		case DIRECTION_UP:
		{
			angle = G_PI * 1.5;
			break;
		}
		default:
		break;
	}
	_tmp17_ = context;
	_tmp18_ = angle;
	cairo_rotate (_tmp17_, _tmp18_);
	_tmp19_ = flipped;
	if (_tmp19_) {
		cairo_t* _tmp20_ = NULL;
		_tmp20_ = context;
		cairo_scale (_tmp20_, 1.0, -1.0);
	}
	_tmp21_ = context;
	cairo_set_line_width (_tmp21_, (gdouble) 2);
	_tmp22_ = self->drawBox;
	if (_tmp22_) {
		gboolean _tmp23_ = FALSE;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		_tmp24_ = leftBound;
		_tmp25_ = rightBound;
		if ((_tmp24_ - _tmp25_) == 0) {
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			_tmp26_ = upBound;
			_tmp27_ = downBound;
			_tmp23_ = (_tmp26_ - _tmp27_) == 0;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			cairo_t* _tmp28_ = NULL;
			cairo_line_cap_t oldLineCap = 0;
			cairo_t* _tmp29_ = NULL;
			cairo_line_cap_t _tmp30_ = 0;
			cairo_t* _tmp31_ = NULL;
			cairo_t* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			cairo_t* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			cairo_t* _tmp38_ = NULL;
			cairo_t* _tmp39_ = NULL;
			cairo_line_cap_t _tmp40_ = 0;
			cairo_t* _tmp41_ = NULL;
			_tmp28_ = context;
			cairo_set_line_width (_tmp28_, (gdouble) 5);
			_tmp29_ = context;
			_tmp30_ = cairo_get_line_cap (_tmp29_);
			oldLineCap = _tmp30_;
			_tmp31_ = context;
			cairo_set_line_cap (_tmp31_, CAIRO_LINE_CAP_ROUND);
			_tmp32_ = context;
			_tmp33_ = rightBound;
			_tmp34_ = downBound;
			cairo_move_to (_tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_);
			_tmp35_ = context;
			_tmp36_ = rightBound;
			_tmp37_ = downBound;
			cairo_line_to (_tmp35_, (gdouble) _tmp36_, (gdouble) _tmp37_);
			_tmp38_ = context;
			cairo_stroke (_tmp38_);
			_tmp39_ = context;
			_tmp40_ = oldLineCap;
			cairo_set_line_cap (_tmp39_, _tmp40_);
			_tmp41_ = context;
			cairo_stroke (_tmp41_);
		} else {
			gboolean _tmp42_ = FALSE;
			cairo_t* _tmp57_ = NULL;
			cairo_t* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
			gint _tmp64_ = 0;
			cairo_t* _tmp65_ = NULL;
			_tmp42_ = colourBackground;
			if (_tmp42_) {
				cairo_t* _tmp43_ = NULL;
				gdouble _tmp44_ = 0.0;
				gdouble _tmp45_ = 0.0;
				gdouble _tmp46_ = 0.0;
				gdouble _tmp47_ = 0.0;
				cairo_t* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				cairo_t* _tmp55_ = NULL;
				cairo_t* _tmp56_ = NULL;
				_tmp43_ = context;
				_tmp44_ = self->backgroundRedF;
				_tmp45_ = self->backgroundGreenF;
				_tmp46_ = self->backgroundBlueF;
				_tmp47_ = self->backgroundAlphaF;
				cairo_set_source_rgba (_tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
				_tmp48_ = context;
				_tmp49_ = leftBound;
				_tmp50_ = upBound;
				_tmp51_ = rightBound;
				_tmp52_ = leftBound;
				_tmp53_ = downBound;
				_tmp54_ = upBound;
				cairo_rectangle (_tmp48_, (gdouble) _tmp49_, (gdouble) _tmp50_, (gdouble) (_tmp51_ - _tmp52_), (gdouble) (_tmp53_ - _tmp54_));
				_tmp55_ = context;
				cairo_fill (_tmp55_);
				_tmp56_ = context;
				cairo_stroke (_tmp56_);
			}
			_tmp57_ = context;
			cairo_set_source_rgba (_tmp57_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
			_tmp58_ = context;
			_tmp59_ = leftBound;
			_tmp60_ = upBound;
			_tmp61_ = rightBound;
			_tmp62_ = leftBound;
			_tmp63_ = downBound;
			_tmp64_ = upBound;
			cairo_rectangle (_tmp58_, (gdouble) _tmp59_, (gdouble) _tmp60_, (gdouble) (_tmp61_ - _tmp62_), (gdouble) (_tmp63_ - _tmp64_));
			_tmp65_ = context;
			cairo_stroke (_tmp65_);
		}
	}
	_tmp66_ = context;
	cairo_get_matrix (_tmp66_, &_tmp67_);
	oldMatrix2 = _tmp67_;
	_tmp68_ = context;
	_tmp69_ = oldMatrix;
	cairo_set_matrix (_tmp68_, &_tmp69_);
	_tmp70_ = context;
	cairo_set_font_size (_tmp70_, (gdouble) 16);
	_tmp71_ = context;
	_tmp72_ = self->label;
	cairo_text_extents (_tmp71_, _tmp72_, &_tmp73_);
	textExtents = _tmp73_;
	_tmp74_ = context;
	_tmp75_ = textExtents;
	_tmp76_ = _tmp75_.width;
	_tmp77_ = textExtents;
	_tmp78_ = _tmp77_.height;
	cairo_move_to (_tmp74_, (-_tmp76_) / 2, (+_tmp78_) / 2);
	_tmp79_ = context;
	_tmp80_ = self->label;
	cairo_show_text (_tmp79_, _tmp80_);
	_tmp81_ = context;
	_tmp82_ = oldMatrix2;
	cairo_set_matrix (_tmp81_, &_tmp82_);
	_tmp83_ = context;
	cairo_set_line_width (_tmp83_, (gdouble) 1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp84_ = FALSE;
			_tmp84_ = TRUE;
			while (TRUE) {
				gint _tmp86_ = 0;
				PinDef** _tmp87_ = NULL;
				gint _tmp87__length1 = 0;
				ComponentInst* _tmp88_ = NULL;
				PinDef* pinDef = NULL;
				PinDef** _tmp97_ = NULL;
				gint _tmp97__length1 = 0;
				gint _tmp98_ = 0;
				PinDef* _tmp99_ = NULL;
				PinDef* _tmp100_ = NULL;
				PinDef* _tmp101_ = NULL;
				PinDefLabelType _tmp102_ = 0;
				if (!_tmp84_) {
					gint _tmp85_ = 0;
					_tmp85_ = i;
					i = _tmp85_ + 1;
				}
				_tmp84_ = FALSE;
				_tmp86_ = i;
				_tmp87_ = self->pinDefs;
				_tmp87__length1 = self->pinDefs_length1;
				if (!(_tmp86_ < _tmp87__length1)) {
					break;
				}
				_tmp88_ = componentInst;
				if (_tmp88_ != NULL) {
					gint _tmp89_ = 0;
					ComponentInst* _tmp90_ = NULL;
					PinInst** _tmp91_ = NULL;
					gint _tmp91__length1 = 0;
					ComponentInst* _tmp92_ = NULL;
					PinInst** _tmp93_ = NULL;
					gint _tmp93__length1 = 0;
					gint _tmp94_ = 0;
					PinInst* _tmp95_ = NULL;
					gboolean _tmp96_ = FALSE;
					_tmp89_ = i;
					_tmp90_ = componentInst;
					_tmp91_ = _tmp90_->pinInsts;
					_tmp91__length1 = _tmp90_->pinInsts_length1;
					if (_tmp89_ >= _tmp91__length1) {
						break;
					}
					_tmp92_ = componentInst;
					_tmp93_ = _tmp92_->pinInsts;
					_tmp93__length1 = _tmp92_->pinInsts_length1;
					_tmp94_ = i;
					_tmp95_ = _tmp93_[_tmp94_];
					_tmp96_ = _tmp95_->show;
					if (!_tmp96_) {
						continue;
					}
				}
				_tmp97_ = self->pinDefs;
				_tmp97__length1 = self->pinDefs_length1;
				_tmp98_ = i;
				_tmp99_ = _tmp97_[_tmp98_];
				_tmp100_ = _pin_def_ref0 (_tmp99_);
				pinDef = _tmp100_;
				_tmp101_ = pinDef;
				_tmp102_ = _tmp101_->labelType;
				switch (_tmp102_) {
					case PIN_DEF_LABEL_TYPE_TEXT:
					case PIN_DEF_LABEL_TYPE_TEXTBAR:
					{
						cairo_t* _tmp103_ = NULL;
						cairo_matrix_t _tmp104_ = {0};
						ComponentInst* _tmp105_ = NULL;
						gboolean _tmp122_ = FALSE;
						cairo_t* _tmp124_ = NULL;
						gdouble _tmp125_ = 0.0;
						cairo_t* _tmp126_ = NULL;
						cairo_t* _tmp127_ = NULL;
						PinDef* _tmp128_ = NULL;
						const gchar* _tmp129_ = NULL;
						cairo_text_extents_t _tmp130_ = {0};
						cairo_t* _tmp131_ = NULL;
						cairo_text_extents_t _tmp132_ = {0};
						gdouble _tmp133_ = 0.0;
						cairo_text_extents_t _tmp134_ = {0};
						gdouble _tmp135_ = 0.0;
						cairo_t* _tmp136_ = NULL;
						PinDef* _tmp137_ = NULL;
						const gchar* _tmp138_ = NULL;
						PinDef* _tmp139_ = NULL;
						PinDefLabelType _tmp140_ = 0;
						cairo_t* _tmp152_ = NULL;
						cairo_matrix_t _tmp153_ = {0};
						_tmp103_ = context;
						cairo_get_matrix (_tmp103_, &_tmp104_);
						oldMatrix2 = _tmp104_;
						_tmp105_ = componentInst;
						if (_tmp105_ == NULL) {
							cairo_t* _tmp106_ = NULL;
							PinDef* _tmp107_ = NULL;
							gint _tmp108_ = 0;
							PinDef* _tmp109_ = NULL;
							gint _tmp110_ = 0;
							_tmp106_ = context;
							_tmp107_ = pinDef;
							_tmp108_ = _tmp107_->xLabel;
							_tmp109_ = pinDef;
							_tmp110_ = _tmp109_->yLabel;
							cairo_translate (_tmp106_, (gdouble) _tmp108_, (gdouble) _tmp110_);
						} else {
							cairo_t* _tmp111_ = NULL;
							ComponentInst* _tmp112_ = NULL;
							PinInst** _tmp113_ = NULL;
							gint _tmp113__length1 = 0;
							gint _tmp114_ = 0;
							PinInst* _tmp115_ = NULL;
							gint _tmp116_ = 0;
							ComponentInst* _tmp117_ = NULL;
							PinInst** _tmp118_ = NULL;
							gint _tmp118__length1 = 0;
							gint _tmp119_ = 0;
							PinInst* _tmp120_ = NULL;
							gint _tmp121_ = 0;
							_tmp111_ = context;
							_tmp112_ = componentInst;
							_tmp113_ = _tmp112_->pinInsts;
							_tmp113__length1 = _tmp112_->pinInsts_length1;
							_tmp114_ = i;
							_tmp115_ = _tmp113_[_tmp114_];
							_tmp116_ = _tmp115_->xLabel;
							_tmp117_ = componentInst;
							_tmp118_ = _tmp117_->pinInsts;
							_tmp118__length1 = _tmp117_->pinInsts_length1;
							_tmp119_ = i;
							_tmp120_ = _tmp118_[_tmp119_];
							_tmp121_ = _tmp120_->yLabel;
							cairo_translate (_tmp111_, (gdouble) _tmp116_, (gdouble) _tmp121_);
						}
						_tmp122_ = flipped;
						if (_tmp122_) {
							cairo_t* _tmp123_ = NULL;
							_tmp123_ = context;
							cairo_scale (_tmp123_, 1.0, -1.0);
						}
						_tmp124_ = context;
						_tmp125_ = angle;
						cairo_rotate (_tmp124_, -_tmp125_);
						_tmp126_ = context;
						cairo_set_font_size (_tmp126_, (gdouble) 8);
						_tmp127_ = context;
						_tmp128_ = pinDef;
						_tmp129_ = _tmp128_->label;
						cairo_text_extents (_tmp127_, _tmp129_, &_tmp130_);
						textExtents = _tmp130_;
						_tmp131_ = context;
						_tmp132_ = textExtents;
						_tmp133_ = _tmp132_.width;
						_tmp134_ = textExtents;
						_tmp135_ = _tmp134_.height;
						cairo_move_to (_tmp131_, (-_tmp133_) / 2, (+_tmp135_) / 2);
						_tmp136_ = context;
						_tmp137_ = pinDef;
						_tmp138_ = _tmp137_->label;
						cairo_show_text (_tmp136_, _tmp138_);
						_tmp139_ = pinDef;
						_tmp140_ = _tmp139_->labelType;
						if (_tmp140_ == PIN_DEF_LABEL_TYPE_TEXTBAR) {
							cairo_t* _tmp141_ = NULL;
							cairo_text_extents_t _tmp142_ = {0};
							gdouble _tmp143_ = 0.0;
							cairo_text_extents_t _tmp144_ = {0};
							gdouble _tmp145_ = 0.0;
							cairo_t* _tmp146_ = NULL;
							cairo_text_extents_t _tmp147_ = {0};
							gdouble _tmp148_ = 0.0;
							cairo_text_extents_t _tmp149_ = {0};
							gdouble _tmp150_ = 0.0;
							cairo_t* _tmp151_ = NULL;
							_tmp141_ = context;
							_tmp142_ = textExtents;
							_tmp143_ = _tmp142_.width;
							_tmp144_ = textExtents;
							_tmp145_ = _tmp144_.height;
							cairo_move_to (_tmp141_, (-_tmp143_) / 2, (-1) - (_tmp145_ / 2));
							_tmp146_ = context;
							_tmp147_ = textExtents;
							_tmp148_ = _tmp147_.width;
							_tmp149_ = textExtents;
							_tmp150_ = _tmp149_.height;
							cairo_line_to (_tmp146_, _tmp148_ / 2, (-1) - (_tmp150_ / 2));
							_tmp151_ = context;
							cairo_stroke (_tmp151_);
						}
						_tmp152_ = context;
						_tmp153_ = oldMatrix2;
						cairo_set_matrix (_tmp152_, &_tmp153_);
						break;
					}
					case PIN_DEF_LABEL_TYPE_CLOCK:
					{
						cairo_t* _tmp154_ = NULL;
						cairo_matrix_t _tmp155_ = {0};
						ComponentInst* _tmp156_ = NULL;
						gdouble angle2 = 0.0;
						PinDef* _tmp175_ = NULL;
						Direction _tmp176_ = 0;
						cairo_t* _tmp177_ = NULL;
						gdouble _tmp178_ = 0.0;
						cairo_t* _tmp179_ = NULL;
						cairo_t* _tmp180_ = NULL;
						cairo_t* _tmp181_ = NULL;
						cairo_t* _tmp182_ = NULL;
						cairo_t* _tmp183_ = NULL;
						cairo_matrix_t _tmp184_ = {0};
						_tmp154_ = context;
						cairo_get_matrix (_tmp154_, &_tmp155_);
						oldMatrix2 = _tmp155_;
						_tmp156_ = componentInst;
						if (_tmp156_ == NULL) {
							cairo_t* _tmp157_ = NULL;
							PinDef* _tmp158_ = NULL;
							gint _tmp159_ = 0;
							PinDef* _tmp160_ = NULL;
							gint _tmp161_ = 0;
							_tmp157_ = context;
							_tmp158_ = pinDef;
							_tmp159_ = _tmp158_->x;
							_tmp160_ = pinDef;
							_tmp161_ = _tmp160_->y;
							cairo_translate (_tmp157_, (gdouble) _tmp159_, (gdouble) _tmp161_);
						} else {
							cairo_t* _tmp162_ = NULL;
							ComponentInst* _tmp163_ = NULL;
							PinInst** _tmp164_ = NULL;
							gint _tmp164__length1 = 0;
							gint _tmp165_ = 0;
							PinInst* _tmp166_ = NULL;
							gint* _tmp167_ = NULL;
							gint _tmp167__length1 = 0;
							gint _tmp168_ = 0;
							ComponentInst* _tmp169_ = NULL;
							PinInst** _tmp170_ = NULL;
							gint _tmp170__length1 = 0;
							gint _tmp171_ = 0;
							PinInst* _tmp172_ = NULL;
							gint* _tmp173_ = NULL;
							gint _tmp173__length1 = 0;
							gint _tmp174_ = 0;
							_tmp162_ = context;
							_tmp163_ = componentInst;
							_tmp164_ = _tmp163_->pinInsts;
							_tmp164__length1 = _tmp163_->pinInsts_length1;
							_tmp165_ = i;
							_tmp166_ = _tmp164_[_tmp165_];
							_tmp167_ = _tmp166_->x;
							_tmp167__length1 = _tmp166_->x_length1;
							_tmp168_ = _tmp167_[0];
							_tmp169_ = componentInst;
							_tmp170_ = _tmp169_->pinInsts;
							_tmp170__length1 = _tmp169_->pinInsts_length1;
							_tmp171_ = i;
							_tmp172_ = _tmp170_[_tmp171_];
							_tmp173_ = _tmp172_->y;
							_tmp173__length1 = _tmp172_->y_length1;
							_tmp174_ = _tmp173_[0];
							cairo_translate (_tmp162_, (gdouble) _tmp168_, (gdouble) _tmp174_);
						}
						angle2 = (gdouble) 0;
						_tmp175_ = pinDef;
						_tmp176_ = _tmp175_->direction;
						switch (_tmp176_) {
							case DIRECTION_RIGHT:
							{
								angle2 = (gdouble) 0;
								break;
							}
							case DIRECTION_DOWN:
							{
								angle2 = G_PI * 0.5;
								break;
							}
							case DIRECTION_LEFT:
							{
								angle2 = G_PI;
								break;
							}
							case DIRECTION_UP:
							{
								angle2 = G_PI * 1.5;
								break;
							}
							default:
							break;
						}
						_tmp177_ = context;
						_tmp178_ = angle2;
						cairo_rotate (_tmp177_, _tmp178_);
						_tmp179_ = context;
						cairo_move_to (_tmp179_, (gdouble) 0, (gdouble) (-6));
						_tmp180_ = context;
						cairo_line_to (_tmp180_, (gdouble) (-9), (gdouble) 0);
						_tmp181_ = context;
						cairo_line_to (_tmp181_, (gdouble) 0, (gdouble) 6);
						_tmp182_ = context;
						cairo_stroke (_tmp182_);
						_tmp183_ = context;
						_tmp184_ = oldMatrix2;
						cairo_set_matrix (_tmp183_, &_tmp184_);
						break;
					}
					default:
					break;
				}
				_pin_def_unref0 (pinDef);
			}
		}
	}
	_tmp185_ = context;
	_tmp186_ = oldMatrix;
	cairo_set_matrix (_tmp185_, &_tmp186_);
}


/**
 * Some ComponentDefs do extra rendering.
 */
static void component_def_real_extra_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst) {
	g_return_if_fail (context != NULL);
}


void component_def_extra_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->extra_render (self, context, direction, flipped, componentInst);
}


/**
 * Some ComponentDefs do extra validation. CURRENTLY UNUSED.
 */
static void component_def_real_extra_validate (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst) {
	g_return_if_fail (project != NULL);
}


void component_def_extra_validate (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->extra_validate (self, project, componentChain, componentChain_length1, componentInst);
}


/**
 * Some ComponentInsts need to hold extra information which they
 * cannot process. This helps create a PropertySet for a 
 * PropertiesQuery.
 */
static void component_def_real_add_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty) {
	g_return_if_fail (queryProperty != NULL);
	g_return_if_fail (configurationProperty != NULL);
}


void component_def_add_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->add_properties (self, queryProperty, configurationProperty);
}


/**
 * Some ComponentInsts need to hold extra information which they
 * cannot process. This is used to extract the user input from a 
 * PropertiesQuery stored in a PropertySet into another PropertySet.
 */
static void component_def_real_get_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty) {
	PropertySet* _vala_configurationProperty = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PropertySet* _tmp3_ = NULL;
	g_return_if_fail (queryProperty != NULL);
	_tmp0_ = self->name;
	_tmp1_ = g_strconcat (_tmp0_, " configuration", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = property_set_new (_tmp2_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp3_;
	_g_free0 (_tmp2_);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


void component_def_get_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->get_properties (self, queryProperty, configurationProperty);
}


/**
 * Some ComponentInsts need to hold extra information which they
 * cannot process. This loads properties from a file using libxml.
 */
static void component_def_real_load_properties (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty) {
	PropertySet* _vala_configurationProperty = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PropertySet* _tmp3_ = NULL;
	_tmp0_ = self->name;
	_tmp1_ = g_strconcat (_tmp0_, " configuration", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = property_set_new (_tmp2_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp3_;
	_g_free0 (_tmp2_);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


void component_def_load_properties (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->load_properties (self, xmlnode, configurationProperty);
}


/**
 * Some ComponentInsts need to hold extra information which they
 * cannot process. This saves properties to a file using libxml.
 */
static void component_def_real_save_properties (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty) {
	g_return_if_fail (xmlWriter != NULL);
	g_return_if_fail (configurationProperty != NULL);
}


void component_def_save_properties (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->save_properties (self, xmlWriter, configurationProperty);
}


static void component_def_real_configure_inst (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad) {
	g_return_if_fail (componentInst != NULL);
}


void component_def_configure_inst (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->configure_inst (self, componentInst, firstLoad);
}


/**
 * Low level compilation. Handled differently for each ComponentDef
 * sub class.
 */
static void component_def_real_compile_component (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	g_critical ("Type `%s' does not implement abstract method `component_def_compile_component'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void component_def_compile_component (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->compile_component (self, compiledCircuit, componentInst, connections, connections_length1, ancestry, ancestry_length1);
}


static void component_def_real_create_information (ComponentDef* self, CircuitInformation* circuitInformation) {
	CircuitInformation* _tmp0_ = NULL;
	g_return_if_fail (circuitInformation != NULL);
	_tmp0_ = circuitInformation;
	circuit_information_count_component (_tmp0_, self);
}


void component_def_create_information (ComponentDef* self, CircuitInformation* circuitInformation) {
	g_return_if_fail (self != NULL);
	COMPONENT_DEF_GET_CLASS (self)->create_information (self, circuitInformation);
}


ComponentDef* component_def_construct (GType object_type) {
	ComponentDef* self = NULL;
	self = (ComponentDef*) g_type_create_instance (object_type);
	return self;
}


static void value_component_def_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_component_def_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		component_def_unref (value->data[0].v_pointer);
	}
}


static void value_component_def_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = component_def_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_component_def_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_component_def_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ComponentDef* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = component_def_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_component_def_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ComponentDef** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = component_def_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecComponentDef* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_COMPONENT_DEF), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_component_def (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPONENT_DEF), NULL);
	return value->data[0].v_pointer;
}


void value_set_component_def (GValue* value, gpointer v_object) {
	ComponentDef* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPONENT_DEF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPONENT_DEF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		component_def_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		component_def_unref (old);
	}
}


void value_take_component_def (GValue* value, gpointer v_object) {
	ComponentDef* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPONENT_DEF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPONENT_DEF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		component_def_unref (old);
	}
}


static void component_def_class_init (ComponentDefClass * klass) {
	component_def_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_DEF_CLASS (klass)->finalize = component_def_finalize;
	COMPONENT_DEF_CLASS (klass)->extra_render = component_def_real_extra_render;
	COMPONENT_DEF_CLASS (klass)->extra_validate = component_def_real_extra_validate;
	COMPONENT_DEF_CLASS (klass)->add_properties = component_def_real_add_properties;
	COMPONENT_DEF_CLASS (klass)->get_properties = component_def_real_get_properties;
	COMPONENT_DEF_CLASS (klass)->load_properties = component_def_real_load_properties;
	COMPONENT_DEF_CLASS (klass)->save_properties = component_def_real_save_properties;
	COMPONENT_DEF_CLASS (klass)->configure_inst = component_def_real_configure_inst;
	COMPONENT_DEF_CLASS (klass)->compile_component = component_def_real_compile_component;
	COMPONENT_DEF_CLASS (klass)->create_information = component_def_real_create_information;
}


static void component_def_instance_init (ComponentDef * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self->graphicReferenceFilename = NULL;
	_tmp0_ = g_strdup ("");
	self->name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->description = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->iconFilename = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->label = _tmp3_;
	self->backgroundAlpha = 0;
	self->backgroundRed = 255;
	self->backgroundGreen = 255;
	self->backgroundBlue = 255;
	self->backgroundAlphaF = (gdouble) 0;
	self->backgroundRedF = (gdouble) 1;
	self->backgroundGreenF = (gdouble) 1;
	self->backgroundBlueF = (gdouble) 1;
	self->drawBox = TRUE;
	_tmp4_ = g_strdup ("");
	self->filename = _tmp4_;
	self->ref_count = 1;
}


static void component_def_finalize (ComponentDef* obj) {
	ComponentDef * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPONENT_DEF, ComponentDef);
	_graphic_unref0 (self->graphic);
	_g_free0 (self->graphicReferenceFilename);
	_g_free0 (self->name);
	_g_free0 (self->description);
	_g_free0 (self->iconFilename);
	_g_free0 (self->label);
	self->pinDefs = (_vala_array_free (self->pinDefs, self->pinDefs_length1, (GDestroyNotify) pin_def_unref), NULL);
	_g_free0 (self->filename);
}


/**
 * Definition of a component
 * 
 * Used to describe a component's appearance, compile ComponentStates,
 * and handle special properties held by ComponentInsts.
 */
GType component_def_get_type (void) {
	static volatile gsize component_def_type_id__volatile = 0;
	if (g_once_init_enter (&component_def_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_component_def_init, value_component_def_free_value, value_component_def_copy_value, value_component_def_peek_pointer, "p", value_component_def_collect_value, "p", value_component_def_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ComponentDefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) component_def_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentDef), 0, (GInstanceInitFunc) component_def_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType component_def_type_id;
		component_def_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ComponentDef", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&component_def_type_id__volatile, component_def_type_id);
	}
	return component_def_type_id__volatile;
}


gpointer component_def_ref (gpointer instance) {
	ComponentDef* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void component_def_unref (gpointer instance) {
	ComponentDef* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		COMPONENT_DEF_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



