/* def-clock.c generated by valac 0.24.0, the Vala compiler
 * generated from def-clock.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentdef/def-clock.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <stdio.h>


#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;

#define TYPE_CLOCK_COMPONENT_DEF (clock_component_def_get_type ())
#define CLOCK_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_COMPONENT_DEF, ClockComponentDef))
#define CLOCK_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_COMPONENT_DEF, ClockComponentDefClass))
#define IS_CLOCK_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_COMPONENT_DEF))
#define IS_CLOCK_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_COMPONENT_DEF))
#define CLOCK_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_COMPONENT_DEF, ClockComponentDefClass))

typedef struct _ClockComponentDef ClockComponentDef;
typedef struct _ClockComponentDefClass ClockComponentDefClass;
typedef struct _ClockComponentDefPrivate ClockComponentDefPrivate;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))

#define TYPE_PROPERTY_ITEM_INT (property_item_int_get_type ())
#define PROPERTY_ITEM_INT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_INT, PropertyItemInt))
#define PROPERTY_ITEM_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_INT, PropertyItemIntClass))
#define IS_PROPERTY_ITEM_INT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_INT))
#define IS_PROPERTY_ITEM_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_INT))
#define PROPERTY_ITEM_INT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_INT, PropertyItemIntClass))

typedef struct _PropertyItemInt PropertyItemInt;
typedef struct _PropertyItemIntClass PropertyItemIntClass;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _PinInstPrivate PinInstPrivate;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;

#define TYPE_CLOCK_COMPONENT_STATE (clock_component_state_get_type ())
#define CLOCK_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_COMPONENT_STATE, ClockComponentState))
#define CLOCK_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_COMPONENT_STATE, ClockComponentStateClass))
#define IS_CLOCK_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_COMPONENT_STATE))
#define IS_CLOCK_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_COMPONENT_STATE))
#define CLOCK_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_COMPONENT_STATE, ClockComponentStateClass))

typedef struct _ClockComponentState ClockComponentState;
typedef struct _ClockComponentStateClass ClockComponentStateClass;
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _ClockComponentDef {
	ComponentDef parent_instance;
	ClockComponentDefPrivate * priv;
};

struct _ClockComponentDefClass {
	ComponentDefClass parent_class;
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
typedef enum  {
	PROPERTY_ITEM_ERROR_ITEM_NOT_FOUND
} PropertyItemError;
#define PROPERTY_ITEM_ERROR property_item_error_quark ()
struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};


static gpointer clock_component_def_parent_class = NULL;

gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
GType clock_component_def_get_type (void) G_GNUC_CONST;
enum  {
	CLOCK_COMPONENT_DEF_DUMMY_PROPERTY
};
#define CLOCK_COMPONENT_DEF_infoFilename PACKAGE_DATADIR "components/info/clock.xml"
GQuark component_def_load_error_quark (void);
ClockComponentDef* clock_component_def_new (GError** error);
ClockComponentDef* clock_component_def_construct (GType object_type, GError** error);
ComponentDef* component_def_construct (GType object_type);
GQuark custom_component_def_load_error_quark (void);
GQuark plugin_component_def_load_error_quark (void);
void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error);
static void clock_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty);
GQuark property_item_error_quark (void);
gint property_item_int_get_data_throw (PropertySet* propertySet, const gchar* name, GError** error);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
PropertyItemInt* property_item_int_new (const gchar* name, const gchar* description, gint data, gint min, gint max);
PropertyItemInt* property_item_int_construct (GType object_type, const gchar* name, const gchar* description, gint data, gint min, gint max);
GType property_item_int_get_type (void) G_GNUC_CONST;
static void clock_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
gint property_item_int_get_data (PropertySet* propertySet, const gchar* name);
static void clock_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty);
static void clock_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
static void clock_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
Connection* connection_new_fake (void);
Connection* connection_construct_fake (GType object_type);
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
WireInst* connection_get_wireInst (Connection* self);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
ClockComponentState* clock_component_state_new (Connection* outputWire, gint onFor, gint offFor, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
ClockComponentState* clock_component_state_construct (GType object_type, Connection* outputWire, gint onFor, gint offFor, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
GType clock_component_state_get_type (void) G_GNUC_CONST;
void compiled_circuit_add_component (CompiledCircuit* self, ComponentState* componentState);


ClockComponentDef* clock_component_def_construct (GType object_type, GError** error) {
	ClockComponentDef* self = NULL;
	GError * _inner_error_ = NULL;
	self = (ClockComponentDef*) component_def_construct (object_type);
	{
		component_def_load_from_file ((ComponentDef*) self, CLOCK_COMPONENT_DEF_infoFilename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		FILE* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Failed to load built in component \"%s\"\n", CLOCK_COMPONENT_DEF_infoFilename);
		_tmp1_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_LOAD, "Failed to load \"" CLOCK_COMPONENT_DEF_infoFilename "\"\n");
		_inner_error_ = _tmp1_;
		goto __finally13;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


ClockComponentDef* clock_component_def_new (GError** error) {
	return clock_component_def_construct (TYPE_CLOCK_COMPONENT_DEF, error);
}


static void clock_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty) {
	ClockComponentDef * self;
	gint onFor = 0;
	gint offFor = 0;
	PropertySet* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	PropertyItemInt* _tmp6_ = NULL;
	PropertyItemInt* _tmp7_ = NULL;
	PropertySet* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	PropertyItemInt* _tmp14_ = NULL;
	PropertyItemInt* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ClockComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	g_return_if_fail (configurationProperty != NULL);
	{
		gint _tmp0_ = 0;
		PropertySet* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = configurationProperty;
		_tmp2_ = property_item_int_get_data_throw (_tmp1_, "On For", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		onFor = _tmp0_;
	}
	goto __finally14;
	__catch14_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		onFor = 25;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = queryProperty;
	_tmp4_ = onFor;
	_tmp5_ = G_MAXINT;
	_tmp6_ = property_item_int_new ("On For", "Duration which clock is on.", _tmp4_, 1, _tmp5_);
	_tmp7_ = _tmp6_;
	property_set_add_item (_tmp3_, (PropertyItem*) _tmp7_);
	_property_item_unref0 (_tmp7_);
	{
		gint _tmp8_ = 0;
		PropertySet* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp9_ = configurationProperty;
		_tmp10_ = property_item_int_get_data_throw (_tmp9_, "Off For", &_inner_error_);
		_tmp8_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		offFor = _tmp8_;
	}
	goto __finally15;
	__catch15_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		offFor = 25;
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = queryProperty;
	_tmp12_ = offFor;
	_tmp13_ = G_MAXINT;
	_tmp14_ = property_item_int_new ("Off For", "Duration which clock is off.", _tmp12_, 1, _tmp13_);
	_tmp15_ = _tmp14_;
	property_set_add_item (_tmp11_, (PropertyItem*) _tmp15_);
	_property_item_unref0 (_tmp15_);
}


static void clock_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty) {
	ClockComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	gint onFor = 0;
	gint offFor = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PropertySet* _tmp3_ = NULL;
	PropertySet* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	PropertyItemInt* _tmp7_ = NULL;
	PropertyItemInt* _tmp8_ = NULL;
	PropertySet* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	PropertyItemInt* _tmp12_ = NULL;
	PropertyItemInt* _tmp13_ = NULL;
	self = (ClockComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	_tmp0_ = ((ComponentDef*) self)->name;
	_tmp1_ = g_strconcat (_tmp0_, " configuration", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = property_set_new (_tmp2_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = queryProperty;
	_tmp5_ = property_item_int_get_data (_tmp4_, "On For");
	onFor = _tmp5_;
	_tmp6_ = G_MAXINT;
	_tmp7_ = property_item_int_new ("On For", "", onFor, 1, _tmp6_);
	_tmp8_ = _tmp7_;
	property_set_add_item (_vala_configurationProperty, (PropertyItem*) _tmp8_);
	_property_item_unref0 (_tmp8_);
	_tmp9_ = queryProperty;
	_tmp10_ = property_item_int_get_data (_tmp9_, "Off For");
	offFor = _tmp10_;
	_tmp11_ = G_MAXINT;
	_tmp12_ = property_item_int_new ("Off For", "", offFor, 1, _tmp11_);
	_tmp13_ = _tmp12_;
	property_set_add_item (_vala_configurationProperty, (PropertyItem*) _tmp13_);
	_property_item_unref0 (_tmp13_);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void clock_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty) {
	ClockComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	gint onFor = 0;
	gint offFor = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PropertySet* _tmp3_ = NULL;
	PropertySet* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	PropertyItemInt* _tmp26_ = NULL;
	PropertyItemInt* _tmp27_ = NULL;
	PropertySet* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	PropertyItemInt* _tmp31_ = NULL;
	PropertyItemInt* _tmp32_ = NULL;
	self = (ClockComponentDef*) base;
	onFor = 25;
	offFor = 25;
	_tmp0_ = ((ComponentDef*) self)->name;
	_tmp1_ = g_strconcat (_tmp0_, " configuration", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = property_set_new (_tmp2_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp3_;
	_g_free0 (_tmp2_);
	{
		xmlAttr* xmlattr = NULL;
		xmlNode* _tmp4_ = NULL;
		xmlAttr* _tmp5_ = NULL;
		_tmp4_ = xmlnode;
		_tmp5_ = _tmp4_->properties;
		xmlattr = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp9_ = NULL;
				xmlAttr* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GQuark _tmp14_ = 0U;
				static GQuark _tmp13_label0 = 0;
				static GQuark _tmp13_label1 = 0;
				if (!_tmp6_) {
					xmlAttr* _tmp7_ = NULL;
					xmlAttr* _tmp8_ = NULL;
					_tmp7_ = xmlattr;
					_tmp8_ = _tmp7_->next;
					xmlattr = _tmp8_;
				}
				_tmp6_ = FALSE;
				_tmp9_ = xmlattr;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = xmlattr;
				_tmp11_ = _tmp10_->name;
				_tmp12_ = _tmp11_;
				_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
				if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("on")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp15_ = NULL;
							xmlNode* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							_tmp15_ = xmlattr;
							_tmp16_ = _tmp15_->children;
							_tmp17_ = _tmp16_->content;
							_tmp18_ = atoi (_tmp17_);
							onFor = _tmp18_;
							break;
						}
					}
				} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("off")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp19_ = NULL;
							xmlNode* _tmp20_ = NULL;
							const gchar* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							_tmp19_ = xmlattr;
							_tmp20_ = _tmp19_->children;
							_tmp21_ = _tmp20_->content;
							_tmp22_ = atoi (_tmp21_);
							offFor = _tmp22_;
							break;
						}
					}
				}
			}
		}
	}
	_tmp23_ = _vala_configurationProperty;
	_tmp24_ = onFor;
	_tmp25_ = G_MAXINT;
	_tmp26_ = property_item_int_new ("On For", "", _tmp24_, 1, _tmp25_);
	_tmp27_ = _tmp26_;
	property_set_add_item (_tmp23_, (PropertyItem*) _tmp27_);
	_property_item_unref0 (_tmp27_);
	_tmp28_ = _vala_configurationProperty;
	_tmp29_ = offFor;
	_tmp30_ = G_MAXINT;
	_tmp31_ = property_item_int_new ("Off For", "", _tmp29_, 1, _tmp30_);
	_tmp32_ = _tmp31_;
	property_set_add_item (_tmp28_, (PropertyItem*) _tmp32_);
	_property_item_unref0 (_tmp32_);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void clock_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty) {
	ClockComponentDef * self;
	gint onFor = 0;
	gint offFor = 0;
	xmlTextWriter* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	xmlTextWriter* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ClockComponentDef*) base;
	g_return_if_fail (xmlWriter != NULL);
	g_return_if_fail (configurationProperty != NULL);
	{
		gint _tmp0_ = 0;
		PropertySet* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = configurationProperty;
		_tmp2_ = property_item_int_get_data_throw (_tmp1_, "On For", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		onFor = _tmp0_;
	}
	goto __finally16;
	__catch16_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		onFor = 25;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint _tmp3_ = 0;
		PropertySet* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = configurationProperty;
		_tmp5_ = property_item_int_get_data_throw (_tmp4_, "Off For", &_inner_error_);
		_tmp3_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
		offFor = _tmp3_;
	}
	goto __finally17;
	__catch17_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		offFor = 25;
	}
	__finally17:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = xmlWriter;
	_tmp7_ = onFor;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	xmlTextWriterWriteAttribute (_tmp6_, (xmlChar*) "on", (xmlChar*) _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = xmlWriter;
	_tmp11_ = offFor;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	xmlTextWriterWriteAttribute (_tmp10_, (xmlChar*) "off", (xmlChar*) _tmp13_);
	_g_free0 (_tmp13_);
}


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static void clock_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	ClockComponentDef * self;
	Connection* outputWire = NULL;
	Connection* _tmp0_ = NULL;
	gint onFor = 0;
	gint offFor = 0;
	Connection** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	ComponentState* componentState = NULL;
	Connection* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	ComponentInst** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	ComponentInst* _tmp27_ = NULL;
	ClockComponentState* _tmp28_ = NULL;
	CompiledCircuit* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ClockComponentDef*) base;
	g_return_if_fail (compiledCircuit != NULL);
	_tmp0_ = connection_new_fake ();
	outputWire = _tmp0_;
	_tmp1_ = connections;
	_tmp1__length1 = connections_length1;
	{
		Connection** connection_collection = NULL;
		gint connection_collection_length1 = 0;
		gint _connection_collection_size_ = 0;
		gint connection_it = 0;
		connection_collection = _tmp1_;
		connection_collection_length1 = _tmp1__length1;
		for (connection_it = 0; connection_it < _tmp1__length1; connection_it = connection_it + 1) {
			Connection* _tmp2_ = NULL;
			Connection* connection = NULL;
			_tmp2_ = _connection_ref0 (connection_collection[connection_it]);
			connection = _tmp2_;
			{
				Connection* _tmp3_ = NULL;
				WireInst* _tmp4_ = NULL;
				WireInst* _tmp5_ = NULL;
				ComponentInst* _tmp6_ = NULL;
				PinInst** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				PinInst* _tmp8_ = NULL;
				WireInst** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				WireInst* _tmp10_ = NULL;
				_tmp3_ = connection;
				_tmp4_ = connection_get_wireInst (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = componentInst;
				_tmp7_ = _tmp6_->pinInsts;
				_tmp7__length1 = _tmp6_->pinInsts_length1;
				_tmp8_ = _tmp7_[0];
				_tmp9_ = _tmp8_->wireInsts;
				_tmp9__length1 = _tmp8_->wireInsts_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp5_ == _tmp10_) {
					Connection* _tmp11_ = NULL;
					Connection* _tmp12_ = NULL;
					_tmp11_ = connection;
					_tmp12_ = _connection_ref0 (_tmp11_);
					_connection_unref0 (outputWire);
					outputWire = _tmp12_;
				}
				_connection_unref0 (connection);
			}
		}
	}
	{
		gint _tmp13_ = 0;
		ComponentInst* _tmp14_ = NULL;
		PropertySet* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp14_ = componentInst;
		_tmp15_ = _tmp14_->configuration;
		_tmp16_ = property_item_int_get_data_throw (_tmp15_, "On For", &_inner_error_);
		_tmp13_ = _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		onFor = _tmp13_;
	}
	goto __finally18;
	__catch18_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		onFor = 25;
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_connection_unref0 (outputWire);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint _tmp17_ = 0;
		ComponentInst* _tmp18_ = NULL;
		PropertySet* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		_tmp18_ = componentInst;
		_tmp19_ = _tmp18_->configuration;
		_tmp20_ = property_item_int_get_data_throw (_tmp19_, "Off For", &_inner_error_);
		_tmp17_ = _tmp20_;
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		offFor = _tmp17_;
	}
	goto __finally19;
	__catch19_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		offFor = 25;
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_connection_unref0 (outputWire);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp21_ = onFor;
	if (_tmp21_ < 1) {
		onFor = 1;
	}
	_tmp22_ = offFor;
	if (_tmp22_ < 1) {
		offFor = 1;
	}
	_tmp23_ = outputWire;
	_tmp24_ = onFor;
	_tmp25_ = offFor;
	_tmp26_ = ancestry;
	_tmp26__length1 = ancestry_length1;
	_tmp27_ = componentInst;
	_tmp28_ = clock_component_state_new (_tmp23_, _tmp24_, _tmp25_, _tmp26_, _tmp26__length1, _tmp27_);
	componentState = (ComponentState*) _tmp28_;
	_tmp29_ = compiledCircuit;
	compiled_circuit_add_component (_tmp29_, componentState);
	_component_state_unref0 (componentState);
	_connection_unref0 (outputWire);
}


static void clock_component_def_class_init (ClockComponentDefClass * klass) {
	clock_component_def_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_DEF_CLASS (klass)->add_properties = clock_component_def_real_add_properties;
	COMPONENT_DEF_CLASS (klass)->get_properties = clock_component_def_real_get_properties;
	COMPONENT_DEF_CLASS (klass)->load_properties = clock_component_def_real_load_properties;
	COMPONENT_DEF_CLASS (klass)->save_properties = clock_component_def_real_save_properties;
	COMPONENT_DEF_CLASS (klass)->compile_component = clock_component_def_real_compile_component;
}


static void clock_component_def_instance_init (ClockComponentDef * self) {
}


GType clock_component_def_get_type (void) {
	static volatile gsize clock_component_def_type_id__volatile = 0;
	if (g_once_init_enter (&clock_component_def_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClockComponentDefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clock_component_def_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClockComponentDef), 0, (GInstanceInitFunc) clock_component_def_instance_init, NULL };
		GType clock_component_def_type_id;
		clock_component_def_type_id = g_type_register_static (TYPE_COMPONENT_DEF, "ClockComponentDef", &g_define_type_info, 0);
		g_once_init_leave (&clock_component_def_type_id__volatile, clock_component_def_type_id);
	}
	return clock_component_def_type_id__volatile;
}



