/* def-constant.c generated by valac 0.24.0, the Vala compiler
 * generated from def-constant.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentdef/def-constant.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <stdio.h>


#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;

#define TYPE_CONSTANT_COMPONENT_DEF (constant_component_def_get_type ())
#define CONSTANT_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSTANT_COMPONENT_DEF, ConstantComponentDef))
#define CONSTANT_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSTANT_COMPONENT_DEF, ConstantComponentDefClass))
#define IS_CONSTANT_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSTANT_COMPONENT_DEF))
#define IS_CONSTANT_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSTANT_COMPONENT_DEF))
#define CONSTANT_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSTANT_COMPONENT_DEF, ConstantComponentDefClass))

typedef struct _ConstantComponentDef ConstantComponentDef;
typedef struct _ConstantComponentDefClass ConstantComponentDefClass;
typedef struct _ConstantComponentDefPrivate ConstantComponentDefPrivate;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROPERTY_ITEM_SELECTION (property_item_selection_get_type ())
#define PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection))
#define PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))
#define IS_PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_SELECTION))
#define IS_PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_SELECTION))
#define PROPERTY_ITEM_SELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))

typedef struct _PropertyItemSelection PropertyItemSelection;
typedef struct _PropertyItemSelectionClass PropertyItemSelectionClass;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _PinInstPrivate PinInstPrivate;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;

#define TYPE_CONSTANT_COMPONENT_STATE (constant_component_state_get_type ())
#define CONSTANT_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSTANT_COMPONENT_STATE, ConstantComponentState))
#define CONSTANT_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSTANT_COMPONENT_STATE, ConstantComponentStateClass))
#define IS_CONSTANT_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSTANT_COMPONENT_STATE))
#define IS_CONSTANT_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSTANT_COMPONENT_STATE))
#define CONSTANT_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSTANT_COMPONENT_STATE, ConstantComponentStateClass))

typedef struct _ConstantComponentState ConstantComponentState;
typedef struct _ConstantComponentStateClass ConstantComponentStateClass;
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _ConstantComponentDef {
	ComponentDef parent_instance;
	ConstantComponentDefPrivate * priv;
};

struct _ConstantComponentDefClass {
	ComponentDefClass parent_class;
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
typedef enum  {
	PROPERTY_ITEM_ERROR_ITEM_NOT_FOUND
} PropertyItemError;
#define PROPERTY_ITEM_ERROR property_item_error_quark ()
struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};


static gpointer constant_component_def_parent_class = NULL;

gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
GType constant_component_def_get_type (void) G_GNUC_CONST;
enum  {
	CONSTANT_COMPONENT_DEF_DUMMY_PROPERTY
};
#define CONSTANT_COMPONENT_DEF_infoFilename PACKAGE_DATADIR "components/info/constant.xml"
GQuark component_def_load_error_quark (void);
ConstantComponentDef* constant_component_def_new (GError** error);
ConstantComponentDef* constant_component_def_construct (GType object_type, GError** error);
ComponentDef* component_def_construct (GType object_type);
GQuark custom_component_def_load_error_quark (void);
GQuark plugin_component_def_load_error_quark (void);
void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error);
static void constant_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty);
GQuark property_item_error_quark (void);
gchar* property_item_selection_get_data_throw (PropertySet* propertySet, const gchar* name, GError** error);
GType property_item_selection_get_type (void) G_GNUC_CONST;
PropertyItemSelection* property_item_selection_new (const gchar* name, const gchar* description);
PropertyItemSelection* property_item_selection_construct (GType object_type, const gchar* name, const gchar* description);
void property_item_selection_add_option (PropertyItemSelection* self, const gchar* value, const gchar* text);
gint property_item_selection_set_option (PropertyItemSelection* self, const gchar* value);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
static void constant_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
static void constant_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty);
static void constant_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
static void constant_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
Connection* connection_new_fake (void);
Connection* connection_construct_fake (GType object_type);
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
WireInst* connection_get_wireInst (Connection* self);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
ConstantComponentState* constant_component_state_new (Connection* outputWire, gboolean constantValue, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
ConstantComponentState* constant_component_state_construct (GType object_type, Connection* outputWire, gboolean constantValue, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
GType constant_component_state_get_type (void) G_GNUC_CONST;
void compiled_circuit_add_component (CompiledCircuit* self, ComponentState* componentState);
static void constant_component_def_real_extra_render (ComponentDef* base, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);


ConstantComponentDef* constant_component_def_construct (GType object_type, GError** error) {
	ConstantComponentDef* self = NULL;
	GError * _inner_error_ = NULL;
	self = (ConstantComponentDef*) component_def_construct (object_type);
	{
		component_def_load_from_file ((ComponentDef*) self, CONSTANT_COMPONENT_DEF_infoFilename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		FILE* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Failed to load built in component \"%s\"\n", CONSTANT_COMPONENT_DEF_infoFilename);
		_tmp1_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_LOAD, "Failed to load \"" CONSTANT_COMPONENT_DEF_infoFilename "\"\n");
		_inner_error_ = _tmp1_;
		goto __finally20;
	}
	__finally20:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


ConstantComponentDef* constant_component_def_new (GError** error) {
	return constant_component_def_construct (TYPE_CONSTANT_COMPONENT_DEF, error);
}


static void constant_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty) {
	ConstantComponentDef * self;
	gchar* constantString = NULL;
	PropertyItemSelection* selection = NULL;
	PropertyItemSelection* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	PropertySet* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ConstantComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	g_return_if_fail (configurationProperty != NULL);
	{
		gchar* _tmp0_ = NULL;
		PropertySet* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = configurationProperty;
		_tmp2_ = property_item_selection_get_data_throw (_tmp1_, "Value", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (constantString);
		constantString = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally21;
	__catch21_g_error:
	{
		gchar* _tmp4_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp4_ = g_strdup ("0");
		_g_free0 (constantString);
		constantString = _tmp4_;
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (constantString);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = property_item_selection_new ("Value", "The constant value to output");
	selection = _tmp5_;
	property_item_selection_add_option (selection, "0", "0 (False)");
	property_item_selection_add_option (selection, "1", "1 (True)");
	_tmp6_ = constantString;
	property_item_selection_set_option (selection, _tmp6_);
	_tmp7_ = queryProperty;
	property_set_add_item (_tmp7_, (PropertyItem*) selection);
	_property_item_unref0 (selection);
	_g_free0 (constantString);
}


static void constant_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty) {
	ConstantComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	gchar* constantString = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	PropertySet* _tmp8_ = NULL;
	PropertyItemSelection* selection = NULL;
	PropertyItemSelection* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ConstantComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	{
		gchar* _tmp0_ = NULL;
		PropertySet* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = queryProperty;
		_tmp2_ = property_item_selection_get_data_throw (_tmp1_, "Value", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (constantString);
		constantString = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		gchar* _tmp4_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp4_ = g_strdup ("0");
		_g_free0 (constantString);
		constantString = _tmp4_;
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_free0 (constantString);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = ((ComponentDef*) self)->name;
	_tmp6_ = g_strconcat (_tmp5_, " configuration", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = property_set_new (_tmp7_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = property_item_selection_new ("Value", "");
	selection = _tmp9_;
	property_item_selection_add_option (selection, "0", "0 (False)");
	property_item_selection_add_option (selection, "1", "1 (True)");
	_tmp10_ = constantString;
	property_item_selection_set_option (selection, _tmp10_);
	property_set_add_item (_vala_configurationProperty, (PropertyItem*) selection);
	_property_item_unref0 (selection);
	_g_free0 (constantString);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void constant_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty) {
	ConstantComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	gchar* constantString = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	PropertySet* _tmp4_ = NULL;
	PropertyItemSelection* selection = NULL;
	PropertyItemSelection* _tmp20_ = NULL;
	PropertyItemSelection* _tmp21_ = NULL;
	PropertyItemSelection* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GQuark _tmp26_ = 0U;
	static GQuark _tmp25_label0 = 0;
	static GQuark _tmp25_label1 = 0;
	static GQuark _tmp25_label2 = 0;
	static GQuark _tmp25_label3 = 0;
	PropertySet* _tmp29_ = NULL;
	PropertyItemSelection* _tmp30_ = NULL;
	self = (ConstantComponentDef*) base;
	_tmp0_ = g_strdup ("0");
	constantString = _tmp0_;
	_tmp1_ = ((ComponentDef*) self)->name;
	_tmp2_ = g_strconcat (_tmp1_, " configuration", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = property_set_new (_tmp3_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp4_;
	_g_free0 (_tmp3_);
	{
		xmlAttr* xmlattr = NULL;
		xmlNode* _tmp5_ = NULL;
		xmlAttr* _tmp6_ = NULL;
		_tmp5_ = xmlnode;
		_tmp6_ = _tmp5_->properties;
		xmlattr = _tmp6_;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp10_ = NULL;
				xmlAttr* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				GQuark _tmp15_ = 0U;
				static GQuark _tmp14_label0 = 0;
				if (!_tmp7_) {
					xmlAttr* _tmp8_ = NULL;
					xmlAttr* _tmp9_ = NULL;
					_tmp8_ = xmlattr;
					_tmp9_ = _tmp8_->next;
					xmlattr = _tmp9_;
				}
				_tmp7_ = FALSE;
				_tmp10_ = xmlattr;
				if (!(_tmp10_ != NULL)) {
					break;
				}
				_tmp11_ = xmlattr;
				_tmp12_ = _tmp11_->name;
				_tmp13_ = _tmp12_;
				_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("value")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp16_ = NULL;
							xmlNode* _tmp17_ = NULL;
							const gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							_tmp16_ = xmlattr;
							_tmp17_ = _tmp16_->children;
							_tmp18_ = _tmp17_->content;
							_tmp19_ = g_strdup (_tmp18_);
							_g_free0 (constantString);
							constantString = _tmp19_;
							break;
						}
					}
				}
			}
		}
	}
	_tmp20_ = property_item_selection_new ("Value", "");
	selection = _tmp20_;
	_tmp21_ = selection;
	property_item_selection_add_option (_tmp21_, "0", "0 (False)");
	_tmp22_ = selection;
	property_item_selection_add_option (_tmp22_, "1", "1 (True)");
	_tmp23_ = constantString;
	_tmp24_ = _tmp23_;
	_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
	if ((_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("0")))) || (_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("0 (False)"))))) {
		switch (0) {
			default:
			{
				PropertyItemSelection* _tmp27_ = NULL;
				_tmp27_ = selection;
				property_item_selection_set_option (_tmp27_, "0");
				break;
			}
		}
	} else if ((_tmp26_ == ((0 != _tmp25_label2) ? _tmp25_label2 : (_tmp25_label2 = g_quark_from_static_string ("1")))) || (_tmp26_ == ((0 != _tmp25_label3) ? _tmp25_label3 : (_tmp25_label3 = g_quark_from_static_string ("1 (True)"))))) {
		switch (0) {
			default:
			{
				PropertyItemSelection* _tmp28_ = NULL;
				_tmp28_ = selection;
				property_item_selection_set_option (_tmp28_, "1");
				break;
			}
		}
	}
	_tmp29_ = _vala_configurationProperty;
	_tmp30_ = selection;
	property_set_add_item (_tmp29_, (PropertyItem*) _tmp30_);
	_property_item_unref0 (selection);
	_g_free0 (constantString);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void constant_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty) {
	ConstantComponentDef * self;
	gchar* constantString = NULL;
	xmlTextWriter* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ConstantComponentDef*) base;
	g_return_if_fail (xmlWriter != NULL);
	g_return_if_fail (configurationProperty != NULL);
	{
		gchar* _tmp0_ = NULL;
		PropertySet* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = configurationProperty;
		_tmp2_ = property_item_selection_get_data_throw (_tmp1_, "Value", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch23_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (constantString);
		constantString = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally23;
	__catch23_g_error:
	{
		gchar* _tmp4_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp4_ = g_strdup ("0");
		_g_free0 (constantString);
		constantString = _tmp4_;
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_free0 (constantString);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = xmlWriter;
	_tmp6_ = constantString;
	xmlTextWriterWriteAttribute (_tmp5_, (xmlChar*) "value", (xmlChar*) _tmp6_);
	_g_free0 (constantString);
}


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static void constant_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	ConstantComponentDef * self;
	Connection* outputWire = NULL;
	Connection* _tmp0_ = NULL;
	gchar* constantString = NULL;
	gboolean constantValue = FALSE;
	Connection** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp19_ = NULL;
	ComponentState* componentState = NULL;
	Connection* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	ComponentInst** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	ComponentInst* _tmp23_ = NULL;
	ConstantComponentState* _tmp24_ = NULL;
	CompiledCircuit* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ConstantComponentDef*) base;
	g_return_if_fail (compiledCircuit != NULL);
	_tmp0_ = connection_new_fake ();
	outputWire = _tmp0_;
	constantValue = FALSE;
	_tmp1_ = connections;
	_tmp1__length1 = connections_length1;
	{
		Connection** connection_collection = NULL;
		gint connection_collection_length1 = 0;
		gint _connection_collection_size_ = 0;
		gint connection_it = 0;
		connection_collection = _tmp1_;
		connection_collection_length1 = _tmp1__length1;
		for (connection_it = 0; connection_it < _tmp1__length1; connection_it = connection_it + 1) {
			Connection* _tmp2_ = NULL;
			Connection* connection = NULL;
			_tmp2_ = _connection_ref0 (connection_collection[connection_it]);
			connection = _tmp2_;
			{
				Connection* _tmp3_ = NULL;
				WireInst* _tmp4_ = NULL;
				WireInst* _tmp5_ = NULL;
				ComponentInst* _tmp6_ = NULL;
				PinInst** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				PinInst* _tmp8_ = NULL;
				WireInst** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				WireInst* _tmp10_ = NULL;
				_tmp3_ = connection;
				_tmp4_ = connection_get_wireInst (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = componentInst;
				_tmp7_ = _tmp6_->pinInsts;
				_tmp7__length1 = _tmp6_->pinInsts_length1;
				_tmp8_ = _tmp7_[0];
				_tmp9_ = _tmp8_->wireInsts;
				_tmp9__length1 = _tmp8_->wireInsts_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp5_ == _tmp10_) {
					Connection* _tmp11_ = NULL;
					Connection* _tmp12_ = NULL;
					_tmp11_ = connection;
					_tmp12_ = _connection_ref0 (_tmp11_);
					_connection_unref0 (outputWire);
					outputWire = _tmp12_;
				}
				_connection_unref0 (connection);
			}
		}
	}
	{
		gchar* _tmp13_ = NULL;
		ComponentInst* _tmp14_ = NULL;
		PropertySet* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp14_ = componentInst;
		_tmp15_ = _tmp14_->configuration;
		_tmp16_ = property_item_selection_get_data_throw (_tmp15_, "Value", &_inner_error_);
		_tmp13_ = _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		_tmp17_ = _tmp13_;
		_tmp13_ = NULL;
		_g_free0 (constantString);
		constantString = _tmp17_;
		_g_free0 (_tmp13_);
	}
	goto __finally24;
	__catch24_g_error:
	{
		gchar* _tmp18_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp18_ = g_strdup ("0");
		_g_free0 (constantString);
		constantString = _tmp18_;
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_free0 (constantString);
		_connection_unref0 (outputWire);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp19_ = constantString;
	if (g_strcmp0 (_tmp19_, "1") == 0) {
		constantValue = TRUE;
	}
	_tmp20_ = outputWire;
	_tmp21_ = constantValue;
	_tmp22_ = ancestry;
	_tmp22__length1 = ancestry_length1;
	_tmp23_ = componentInst;
	_tmp24_ = constant_component_state_new (_tmp20_, _tmp21_, _tmp22_, _tmp22__length1, _tmp23_);
	componentState = (ComponentState*) _tmp24_;
	_tmp25_ = compiledCircuit;
	compiled_circuit_add_component (_tmp25_, componentState);
	_component_state_unref0 (componentState);
	_g_free0 (constantString);
	_connection_unref0 (outputWire);
}


static void constant_component_def_real_extra_render (ComponentDef* base, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst) {
	ConstantComponentDef * self;
	gchar* constantString = NULL;
	gchar* text = NULL;
	ComponentInst* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	const gchar* _tmp8_ = NULL;
	cairo_text_extents_t textExtents = {0};
	cairo_t* _tmp11_ = NULL;
	cairo_t* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	cairo_text_extents_t _tmp14_ = {0};
	cairo_t* _tmp15_ = NULL;
	cairo_text_extents_t _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	cairo_text_extents_t _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	cairo_t* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ConstantComponentDef*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = componentInst;
	if (_tmp0_ == NULL) {
		_g_free0 (text);
		_g_free0 (constantString);
		return;
	}
	_tmp1_ = context;
	cairo_set_source_rgb (_tmp1_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	{
		gchar* _tmp2_ = NULL;
		ComponentInst* _tmp3_ = NULL;
		PropertySet* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp3_ = componentInst;
		_tmp4_ = _tmp3_->configuration;
		_tmp5_ = property_item_selection_get_data_throw (_tmp4_, "Value", &_inner_error_);
		_tmp2_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		_tmp6_ = _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (constantString);
		constantString = _tmp6_;
		_g_free0 (_tmp2_);
	}
	goto __finally25;
	__catch25_g_error:
	{
		gchar* _tmp7_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp7_ = g_strdup ("0");
		_g_free0 (constantString);
		constantString = _tmp7_;
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		_g_free0 (constantString);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = constantString;
	if (g_strcmp0 (_tmp8_, "1") == 0) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup ("1");
		_g_free0 (text);
		text = _tmp9_;
	} else {
		gchar* _tmp10_ = NULL;
		_tmp10_ = g_strdup ("0");
		_g_free0 (text);
		text = _tmp10_;
	}
	_tmp11_ = context;
	cairo_set_font_size (_tmp11_, (gdouble) 16);
	_tmp12_ = context;
	_tmp13_ = text;
	cairo_text_extents (_tmp12_, _tmp13_, &_tmp14_);
	textExtents = _tmp14_;
	_tmp15_ = context;
	_tmp16_ = textExtents;
	_tmp17_ = _tmp16_.width;
	_tmp18_ = textExtents;
	_tmp19_ = _tmp18_.height;
	cairo_move_to (_tmp15_, (-_tmp17_) / 2, (+_tmp19_) / 2);
	_tmp20_ = context;
	_tmp21_ = text;
	cairo_show_text (_tmp20_, _tmp21_);
	_g_free0 (text);
	_g_free0 (constantString);
}


static void constant_component_def_class_init (ConstantComponentDefClass * klass) {
	constant_component_def_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_DEF_CLASS (klass)->add_properties = constant_component_def_real_add_properties;
	COMPONENT_DEF_CLASS (klass)->get_properties = constant_component_def_real_get_properties;
	COMPONENT_DEF_CLASS (klass)->load_properties = constant_component_def_real_load_properties;
	COMPONENT_DEF_CLASS (klass)->save_properties = constant_component_def_real_save_properties;
	COMPONENT_DEF_CLASS (klass)->compile_component = constant_component_def_real_compile_component;
	COMPONENT_DEF_CLASS (klass)->extra_render = constant_component_def_real_extra_render;
}


static void constant_component_def_instance_init (ConstantComponentDef * self) {
}


GType constant_component_def_get_type (void) {
	static volatile gsize constant_component_def_type_id__volatile = 0;
	if (g_once_init_enter (&constant_component_def_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConstantComponentDefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) constant_component_def_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConstantComponentDef), 0, (GInstanceInitFunc) constant_component_def_instance_init, NULL };
		GType constant_component_def_type_id;
		constant_component_def_type_id = g_type_register_static (TYPE_COMPONENT_DEF, "ConstantComponentDef", &g_define_type_info, 0);
		g_once_init_leave (&constant_component_def_type_id__volatile, constant_component_def_type_id);
	}
	return constant_component_def_type_id__volatile;
}



