/* def-custom.c generated by valac 0.24.0, the Vala compiler
 * generated from def-custom.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentdef/def-custom.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <libxml/parser.h>
#include <config.h>


#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
typedef struct _CustomComponentDefPrivate CustomComponentDefPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;

#define TYPE_ANNOTATION (annotation_get_type ())
#define ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANNOTATION, Annotation))
#define ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANNOTATION, AnnotationClass))
#define IS_ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANNOTATION))
#define IS_ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANNOTATION))
#define ANNOTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANNOTATION, AnnotationClass))

typedef struct _Annotation Annotation;
typedef struct _AnnotationClass AnnotationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
typedef struct _WireInstPrivate WireInstPrivate;

#define WIRE_INST_TYPE_REGISTERED_COMPONENT (wire_inst_registered_component_get_type ())

#define WIRE_INST_TYPE_MARKER (wire_inst_marker_get_type ())
typedef struct _WireInstMarker WireInstMarker;
typedef struct _WireInstRegisteredComponent WireInstRegisteredComponent;

#define TYPE_PATH (path_get_type ())
#define PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH, Path))
#define PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH, PathClass))
#define IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH))
#define IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH))
#define PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH, PathClass))

typedef struct _Path Path;
typedef struct _PathClass PathClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define WIRE_INST_TYPE_PRESET_SIGNAL (wire_inst_preset_signal_get_type ())
typedef struct _PathPrivate PathPrivate;

#define PATH_TYPE_LINE (path_line_get_type ())
typedef struct _PathLine PathLine;
#define _path_unref0(var) ((var == NULL) ? NULL : (var = (path_unref (var), NULL)))
typedef struct _TagPrivate TagPrivate;

#define TYPE_FLOW (flow_get_type ())
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))
typedef struct _AnnotationPrivate AnnotationPrivate;
#define _annotation_unref0(var) ((var == NULL) ? NULL : (var = (annotation_unref (var), NULL)))
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
#define _pin_inst_unref0(var) ((var == NULL) ? NULL : (var = (pin_inst_unref (var), NULL)))
#define _tag_unref0(var) ((var == NULL) ? NULL : (var = (tag_unref (var), NULL)))
#define _xmlFreeTextWriter0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextWriter (var), NULL)))

#define TYPE_WIRE_STATE (wire_state_get_type ())
#define WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_STATE, WireState))
#define WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_STATE, WireStateClass))
#define IS_WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_STATE))
#define IS_WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_STATE))
#define WIRE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_STATE, WireStateClass))

typedef struct _WireState WireState;
typedef struct _WireStateClass WireStateClass;
#define _wire_state_unref0(var) ((var == NULL) ? NULL : (var = (wire_state_unref (var), NULL)))

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

/**
 * CustomComponentDef load from file errors.
 */
typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _CustomComponentDef {
	ComponentDef parent_instance;
	CustomComponentDefPrivate * priv;
	ComponentInst** componentInsts;
	gint componentInsts_length1;
	WireInst** wireInsts;
	gint wireInsts_length1;
	Annotation** annotations;
	gint annotations_length1;
	ComponentDef** immediateDependencies;
	gint immediateDependencies_length1;
};

struct _CustomComponentDefClass {
	ComponentDefClass parent_class;
};

struct _CustomComponentDefPrivate {
	Project* project;
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
struct _WireInstMarker {
	gint x;
	gint y;
	gboolean display;
};

struct _WireInstRegisteredComponent {
	ComponentInst* componentInst;
	WireInstMarker marker;
};

typedef enum  {
	WIRE_INST_PRESET_SIGNAL_DEFAULT,
	WIRE_INST_PRESET_SIGNAL_FALSE,
	WIRE_INST_PRESET_SIGNAL_TRUE
} WireInstPresetSignal;

struct _WireInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireInstPrivate * priv;
	WireInstRegisteredComponent* registeredComponents;
	gint registeredComponents_length1;
	gint myID;
	gboolean selected;
	WireInstMarker* markers;
	gint markers_length1;
	Path** paths;
	gint paths_length1;
	Tag* interfaceTag;
	WireInstPresetSignal presetSignal;
};

struct _WireInstClass {
	GTypeClass parent_class;
	void (*finalize) (WireInst *self);
};

struct _PathLine {
	gint x1;
	gint y1;
	gint x2;
	gint y2;
	Direction dir;
};

struct _Path {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PathPrivate * priv;
	PathLine* lines;
	gint lines_length1;
	gint last;
	gint xLast;
	gint yLast;
	gint xLineStart;
	gint yLineStart;
	Direction dirLast;
};

struct _PathClass {
	GTypeClass parent_class;
	void (*finalize) (Path *self);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

struct _Tag {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagPrivate * priv;
	gchar* text;
	gint xTag;
	gint yTag;
	gint xWire;
	gint yWire;
	gint pinid;
	Flow flow;
	Direction direction;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
};

struct _TagClass {
	GTypeClass parent_class;
	void (*finalize) (Tag *self);
};

struct _Annotation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AnnotationPrivate * priv;
	gint xPosition;
	gint yPosition;
	gchar* _text;
	gdouble _fontSize;
	gint width;
	gint height;
	gboolean selected;
};

struct _AnnotationClass {
	GTypeClass parent_class;
	void (*finalize) (Annotation *self);
};

struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

typedef enum  {
	COMPONENT_INST_LOAD_ERROR_INVALID,
	COMPONENT_INST_LOAD_ERROR_MISSING_DEF
} ComponentInstLoadError;
#define COMPONENT_INST_LOAD_ERROR component_inst_load_error_quark ()
typedef enum  {
	ANNOTATION_LOAD_ERROR_EMPTY
} AnnotationLoadError;
#define ANNOTATION_LOAD_ERROR annotation_load_error_quark ()

static gpointer custom_component_def_parent_class = NULL;

GQuark custom_component_def_load_error_quark (void);
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
gpointer annotation_ref (gpointer instance);
void annotation_unref (gpointer instance);
GParamSpec* param_spec_annotation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_annotation (GValue* value, gpointer v_object);
void value_take_annotation (GValue* value, gpointer v_object);
gpointer value_get_annotation (const GValue* value);
GType annotation_get_type (void) G_GNUC_CONST;
#define CUSTOM_COMPONENT_DEF_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefPrivate))
enum  {
	CUSTOM_COMPONENT_DEF_DUMMY_PROPERTY
};
CustomComponentDef* custom_component_def_new (Project* project);
CustomComponentDef* custom_component_def_construct (GType object_type, Project* project);
ComponentDef* component_def_construct (GType object_type);
GQuark component_def_load_error_quark (void);
CustomComponentDef* custom_component_def_new_from_file (const gchar* infoFilename, Project* project, GError** error);
CustomComponentDef* custom_component_def_construct_from_file (GType object_type, const gchar* infoFilename, Project* project, GError** error);
GQuark plugin_component_def_load_error_quark (void);
void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error);
ComponentDef* project_resolve_def_name (Project* self, const gchar* name);
gint custom_component_def_load (CustomComponentDef* self, const gchar* infoFilename, GError** error);
void custom_component_def_get_design_bounds (CustomComponentDef* self, gint* right, gint* down, gint* left, gint* up);
void component_inst_absolute_bounds (ComponentInst* self, gint* right, gint* down, gint* left, gint* up);
GType wire_inst_registered_component_get_type (void) G_GNUC_CONST;
GType wire_inst_marker_get_type (void) G_GNUC_CONST;
WireInstMarker* wire_inst_marker_dup (const WireInstMarker* self);
void wire_inst_marker_free (WireInstMarker* self);
WireInstRegisteredComponent* wire_inst_registered_component_dup (const WireInstRegisteredComponent* self);
void wire_inst_registered_component_free (WireInstRegisteredComponent* self);
gpointer path_ref (gpointer instance);
void path_unref (gpointer instance);
GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_path (GValue* value, gpointer v_object);
void value_take_path (GValue* value, gpointer v_object);
gpointer value_get_path (const GValue* value);
GType path_get_type (void) G_GNUC_CONST;
gpointer tag_ref (gpointer instance);
void tag_unref (gpointer instance);
GParamSpec* param_spec_tag (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag (GValue* value, gpointer v_object);
void value_take_tag (GValue* value, gpointer v_object);
gpointer value_get_tag (const GValue* value);
GType tag_get_type (void) G_GNUC_CONST;
GType wire_inst_preset_signal_get_type (void) G_GNUC_CONST;
GType path_line_get_type (void) G_GNUC_CONST;
PathLine* path_line_dup (const PathLine* self);
void path_line_free (PathLine* self);
GType flow_get_type (void) G_GNUC_CONST;
void custom_component_def_render_insts (CustomComponentDef* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
void annotation_render (Annotation* self, cairo_t* context, gboolean showHints);
void component_inst_render (ComponentInst* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
void wire_inst_render (WireInst* self, cairo_t* context, gboolean showHints, gboolean showErrors);
ComponentInst* custom_component_def_add_componentInst (CustomComponentDef* self, ComponentDef* componentDef, gint x, gint y, Direction direction);
ComponentInst* component_inst_new (ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped);
ComponentInst* component_inst_construct (GType object_type, ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped);
static ComponentInst** _vala_array_dup6 (ComponentInst** self, int length);
static void _vala_array_add33 (ComponentInst*** array, int* length, int* size, ComponentInst* value);
static ComponentInst** _vala_array_dup7 (ComponentInst** self, int length);
void custom_component_def_add_annotation (CustomComponentDef* self, gint x, gint y, const gchar* text, gdouble fontSize);
Annotation* annotation_new (gint x, gint y, const gchar* text, gdouble fontSize);
Annotation* annotation_construct (GType object_type, gint x, gint y, const gchar* text, gdouble fontSize);
static Annotation** _vala_array_dup8 (Annotation** self, int length);
static void _vala_array_add34 (Annotation*** array, int* length, int* size, Annotation* value);
static Annotation** _vala_array_dup9 (Annotation** self, int length);
WireInst* custom_component_def_add_wire (CustomComponentDef* self);
WireInst* wire_inst_new (void);
WireInst* wire_inst_construct (GType object_type);
static WireInst** _vala_array_dup10 (WireInst** self, int length);
static void _vala_array_add35 (WireInst*** array, int* length, int* size, WireInst* value);
static WireInst** _vala_array_dup11 (WireInst** self, int length);
void custom_component_def_delete_selected_components (CustomComponentDef* self);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
void component_inst_detatch_all (ComponentInst* self);
static void _vala_array_add36 (ComponentInst*** array, int* length, int* size, ComponentInst* value);
static ComponentInst** _vala_array_dup12 (ComponentInst** self, int length);
void custom_component_def_delete_selected_wires (CustomComponentDef* self);
void wire_inst_disconnect_components (WireInst* self);
static void _vala_array_add37 (WireInst*** array, int* length, int* size, WireInst* value);
static WireInst** _vala_array_dup13 (WireInst** self, int length);
void custom_component_def_delete_selected_annotations (CustomComponentDef* self);
static void _vala_array_add38 (Annotation*** array, int* length, int* size, Annotation* value);
static Annotation** _vala_array_dup14 (Annotation** self, int length);
void custom_component_def_update_ids (CustomComponentDef* self);
CustomComponentDef** custom_component_def_validate_dependencies (CustomComponentDef* self, CustomComponentDef** componentChain, int componentChain_length1, int* result_length1);
gint custom_component_def_validate_pins (CustomComponentDef* self);
gint pin_inst_validate_connections (PinInst* self);
gint custom_component_def_validate_interfaces (CustomComponentDef* self);
Tag* custom_component_def_resolve_tag_id (CustomComponentDef* self, gint tagID);
gint custom_component_def_validate_overlaps (CustomComponentDef* self);
WireInst* wire_inst_new_load (xmlNode* xmlnode);
WireInst* wire_inst_construct_load (GType object_type, xmlNode* xmlnode);
static void _vala_array_add39 (WireInst*** array, int* length, int* size, WireInst* value);
GQuark component_inst_load_error_quark (void);
ComponentInst* component_inst_new_load (xmlNode* xmlnode, Project* project, WireInst** newWireInsts, int newWireInsts_length1, GError** error);
ComponentInst* component_inst_construct_load (GType object_type, xmlNode* xmlnode, Project* project, WireInst** newWireInsts, int newWireInsts_length1, GError** error);
static void _vala_array_add40 (ComponentInst*** array, int* length, int* size, ComponentInst* value);
GQuark annotation_load_error_quark (void);
Annotation* annotation_new_load (xmlNode* xmlnode, GError** error);
Annotation* annotation_construct_load (GType object_type, xmlNode* xmlnode, GError** error);
static void _vala_array_add41 (Annotation*** array, int* length, int* size, Annotation* value);
static WireInst** _vala_array_dup15 (WireInst** self, int length);
static ComponentInst** _vala_array_dup16 (ComponentInst** self, int length);
static Annotation** _vala_array_dup17 (Annotation** self, int length);
gint custom_component_def_save (CustomComponentDef* self, const gchar* fileName);
#define CORE_shortVersionString PACKAGE_VERSION
void pin_def_save (PinDef* self, xmlTextWriter* xmlWriter, gint id);
void wire_inst_save (WireInst* self, xmlTextWriter* xmlWriter);
void component_inst_save (ComponentInst* self, xmlTextWriter* xmlWriter);
void annotation_save (Annotation* self, xmlTextWriter* xmlWriter);
static void custom_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
gpointer wire_state_ref (gpointer instance);
void wire_state_unref (gpointer instance);
GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_state (GValue* value, gpointer v_object);
void value_take_wire_state (GValue* value, gpointer v_object);
gpointer value_get_wire_state (const GValue* value);
GType wire_state_get_type (void) G_GNUC_CONST;
static void _vala_array_add42 (ComponentInst*** array, int* length, int* size, ComponentInst* value);
static void _vala_array_add43 (ComponentInst*** array, int* length, int* size, ComponentInst* value);
WireState* compiled_circuit_compile_wire (CompiledCircuit* self, WireInst* wireInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
static void _vala_array_add44 (WireState*** array, int* length, int* size, WireState* value);
void component_inst_compile_component (ComponentInst* self, CompiledCircuit* compiledCircuit, WireState** localWireStates, int localWireStates_length1, ComponentInst** ancestry, int ancestry_length1);
ComponentInst* custom_component_def_find_inst (CustomComponentDef* self, gint x, gint y);
gint component_inst_find (ComponentInst* self, gint x, gint y);
gint custom_component_def_new_tag_id (CustomComponentDef* self);
gint custom_component_def_count_tags (CustomComponentDef* self);
static void custom_component_def_real_create_information (ComponentDef* base, CircuitInformation* circuitInformation);
void circuit_information_count_component (CircuitInformation* self, ComponentDef* componentDef);
void component_def_create_information (ComponentDef* self, CircuitInformation* circuitInformation);
void custom_component_def_update_immediate_dependencies (CustomComponentDef* self, gboolean includePlugins);
GType plugin_component_def_get_type (void) G_GNUC_CONST;
static gboolean _vala_component_def_array_contains (ComponentDef** stack, int stack_length, ComponentDef* needle);
static void _vala_array_add45 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
static ComponentDef** _vala_array_dup18 (ComponentDef** self, int length);
void custom_component_def_remove_immediate_dependency (CustomComponentDef* self, ComponentDef* removeComponent);
static void _vala_array_add46 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
static ComponentDef** _vala_array_dup19 (ComponentDef** self, int length);
static void custom_component_def_finalize (ComponentDef* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark custom_component_def_load_error_quark (void) {
	return g_quark_from_static_string ("custom_component_def_load_error-quark");
}


/**
 * Creates a new custom component, associated with //project//.
 */
CustomComponentDef* custom_component_def_construct (GType object_type, Project* project) {
	CustomComponentDef* self = NULL;
	Project* _tmp0_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	self = (CustomComponentDef*) component_def_construct (object_type);
	_tmp0_ = project;
	self->priv->project = _tmp0_;
	return self;
}


CustomComponentDef* custom_component_def_new (Project* project) {
	return custom_component_def_construct (TYPE_CUSTOM_COMPONENT_DEF, project);
}


/**
 * Loads a CustomComponentDef from a file using libxml.
 */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


CustomComponentDef* custom_component_def_construct_from_file (GType object_type, const gchar* infoFilename, Project* project, GError** error) {
	CustomComponentDef* self = NULL;
	Project* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	ComponentDef* _tmp8_ = NULL;
	ComponentDef* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	Project* _tmp18_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (infoFilename != NULL, NULL);
	g_return_val_if_fail (project != NULL, NULL);
	self = (CustomComponentDef*) component_def_construct (object_type);
	{
		const gchar* _tmp0_ = NULL;
		_tmp0_ = infoFilename;
		component_def_load_from_file ((ComponentDef*) self, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch26_component_def_load_error;
			}
			if (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR) {
				goto __catch26_custom_component_def_load_error;
			}
			if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
				goto __catch26_plugin_component_def_load_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally26;
	__catch26_component_def_load_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		_g_error_free0 (_error_);
		goto __finally26;
	}
	goto __finally26;
	__catch26_custom_component_def_load_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_inner_error_ = _tmp4_;
		_g_error_free0 (_error_);
		goto __finally26;
	}
	goto __finally26;
	__catch26_plugin_component_def_load_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = g_error_new_literal (CUSTOM_COMPONENT_DEF_LOAD_ERROR, CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM, "Got Plugin.");
		_inner_error_ = _tmp5_;
		_g_error_free0 (_error_);
		goto __finally26;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = project;
	_tmp7_ = ((ComponentDef*) self)->name;
	_tmp8_ = project_resolve_def_name (_tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_ != NULL;
	_component_def_unref0 (_tmp9_);
	if (_tmp10_) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		_tmp11_ = ((ComponentDef*) self)->name;
		_tmp12_ = g_strconcat ("A component with the name \"", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "\" already exists. Rename the component which is already open using th" \
"e customiser dialog, accessible via the component menu.", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_error_new_literal (CUSTOM_COMPONENT_DEF_LOAD_ERROR, CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_inner_error_ = _tmp17_;
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = project;
	self->priv->project = _tmp18_;
	{
		const gchar* _tmp19_ = NULL;
		_tmp19_ = infoFilename;
		custom_component_def_load (self, _tmp19_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR) {
				goto __catch27_custom_component_def_load_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally27;
	__catch27_custom_component_def_load_error:
	{
		GError* _error_ = NULL;
		GError* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = _error_;
		_tmp21_ = _g_error_copy0 (_tmp20_);
		_inner_error_ = _tmp21_;
		_g_error_free0 (_error_);
		goto __finally27;
	}
	__finally27:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = infoFilename;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (((ComponentDef*) self)->filename);
	((ComponentDef*) self)->filename = _tmp23_;
	return self;
}


CustomComponentDef* custom_component_def_new_from_file (const gchar* infoFilename, Project* project, GError** error) {
	return custom_component_def_construct_from_file (TYPE_CUSTOM_COMPONENT_DEF, infoFilename, project, error);
}


static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


static gpointer _path_ref0 (gpointer self) {
	return self ? path_ref (self) : NULL;
}


static gpointer _annotation_ref0 (gpointer self) {
	return self ? annotation_ref (self) : NULL;
}


void custom_component_def_get_design_bounds (CustomComponentDef* self, gint* right, gint* down, gint* left, gint* up) {
	gint _vala_right = 0;
	gint _vala_down = 0;
	gint _vala_left = 0;
	gint _vala_up = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	ComponentInst** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	WireInst** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	Annotation** _tmp118_ = NULL;
	gint _tmp118__length1 = 0;
	gboolean _tmp144_ = FALSE;
	gint _tmp145_ = 0;
	gint _tmp146_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = G_MININT;
	_vala_right = _tmp0_;
	_tmp1_ = G_MININT;
	_vala_down = _tmp1_;
	_tmp2_ = G_MAXINT;
	_vala_left = _tmp2_;
	_tmp3_ = G_MAXINT;
	_vala_up = _tmp3_;
	_tmp4_ = self->componentInsts;
	_tmp4__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp4_;
		componentInst_collection_length1 = _tmp4__length1;
		for (componentInst_it = 0; componentInst_it < _tmp4__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp5_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp5_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp5_;
			{
				gint currentRight = 0;
				gint currentDown = 0;
				gint currentLeft = 0;
				gint currentUp = 0;
				ComponentInst* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				_tmp6_ = componentInst;
				component_inst_absolute_bounds (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
				currentRight = _tmp7_;
				currentDown = _tmp8_;
				currentLeft = _tmp9_;
				currentUp = _tmp10_;
				_tmp11_ = currentRight;
				_tmp12_ = _vala_right;
				if (_tmp11_ > _tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = currentRight;
					_vala_right = _tmp13_;
				}
				_tmp14_ = currentDown;
				_tmp15_ = _vala_down;
				if (_tmp14_ > _tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = currentDown;
					_vala_down = _tmp16_;
				}
				_tmp17_ = currentLeft;
				_tmp18_ = _vala_left;
				if (_tmp17_ < _tmp18_) {
					gint _tmp19_ = 0;
					_tmp19_ = currentLeft;
					_vala_left = _tmp19_;
				}
				_tmp20_ = currentUp;
				_tmp21_ = _vala_up;
				if (_tmp20_ < _tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = currentUp;
					_vala_up = _tmp22_;
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	_tmp23_ = self->wireInsts;
	_tmp23__length1 = self->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp23_;
		wireInst_collection_length1 = _tmp23__length1;
		for (wireInst_it = 0; wireInst_it < _tmp23__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp24_ = NULL;
			WireInst* wireInst = NULL;
			_tmp24_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp24_;
			{
				WireInst* _tmp25_ = NULL;
				Path** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				WireInst* _tmp88_ = NULL;
				Tag* _tmp89_ = NULL;
				_tmp25_ = wireInst;
				_tmp26_ = _tmp25_->paths;
				_tmp26__length1 = _tmp25_->paths_length1;
				{
					Path** path_collection = NULL;
					gint path_collection_length1 = 0;
					gint _path_collection_size_ = 0;
					gint path_it = 0;
					path_collection = _tmp26_;
					path_collection_length1 = _tmp26__length1;
					for (path_it = 0; path_it < _tmp26__length1; path_it = path_it + 1) {
						Path* _tmp27_ = NULL;
						Path* path = NULL;
						_tmp27_ = _path_ref0 (path_collection[path_it]);
						path = _tmp27_;
						{
							Path* _tmp28_ = NULL;
							PathLine* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							Path* _tmp30_ = NULL;
							PathLine* _tmp31_ = NULL;
							gint _tmp31__length1 = 0;
							PathLine _tmp32_ = {0};
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							Path* _tmp39_ = NULL;
							PathLine* _tmp40_ = NULL;
							gint _tmp40__length1 = 0;
							PathLine _tmp41_ = {0};
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							Path* _tmp48_ = NULL;
							PathLine* _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							PathLine _tmp50_ = {0};
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							Path* _tmp57_ = NULL;
							PathLine* _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							PathLine _tmp59_ = {0};
							gint _tmp60_ = 0;
							gint _tmp61_ = 0;
							Path* _tmp66_ = NULL;
							PathLine* _tmp67_ = NULL;
							gint _tmp67__length1 = 0;
							_tmp28_ = path;
							_tmp29_ = _tmp28_->lines;
							_tmp29__length1 = _tmp28_->lines_length1;
							if (_tmp29__length1 == 0) {
								_path_unref0 (path);
								continue;
							}
							_tmp30_ = path;
							_tmp31_ = _tmp30_->lines;
							_tmp31__length1 = _tmp30_->lines_length1;
							_tmp32_ = _tmp31_[0];
							_tmp33_ = _tmp32_.x1;
							_tmp34_ = _vala_right;
							if (_tmp33_ > _tmp34_) {
								Path* _tmp35_ = NULL;
								PathLine* _tmp36_ = NULL;
								gint _tmp36__length1 = 0;
								PathLine _tmp37_ = {0};
								gint _tmp38_ = 0;
								_tmp35_ = path;
								_tmp36_ = _tmp35_->lines;
								_tmp36__length1 = _tmp35_->lines_length1;
								_tmp37_ = _tmp36_[0];
								_tmp38_ = _tmp37_.x1;
								_vala_right = _tmp38_;
							}
							_tmp39_ = path;
							_tmp40_ = _tmp39_->lines;
							_tmp40__length1 = _tmp39_->lines_length1;
							_tmp41_ = _tmp40_[0];
							_tmp42_ = _tmp41_.y1;
							_tmp43_ = _vala_down;
							if (_tmp42_ > _tmp43_) {
								Path* _tmp44_ = NULL;
								PathLine* _tmp45_ = NULL;
								gint _tmp45__length1 = 0;
								PathLine _tmp46_ = {0};
								gint _tmp47_ = 0;
								_tmp44_ = path;
								_tmp45_ = _tmp44_->lines;
								_tmp45__length1 = _tmp44_->lines_length1;
								_tmp46_ = _tmp45_[0];
								_tmp47_ = _tmp46_.y1;
								_vala_down = _tmp47_;
							}
							_tmp48_ = path;
							_tmp49_ = _tmp48_->lines;
							_tmp49__length1 = _tmp48_->lines_length1;
							_tmp50_ = _tmp49_[0];
							_tmp51_ = _tmp50_.x1;
							_tmp52_ = _vala_left;
							if (_tmp51_ < _tmp52_) {
								Path* _tmp53_ = NULL;
								PathLine* _tmp54_ = NULL;
								gint _tmp54__length1 = 0;
								PathLine _tmp55_ = {0};
								gint _tmp56_ = 0;
								_tmp53_ = path;
								_tmp54_ = _tmp53_->lines;
								_tmp54__length1 = _tmp53_->lines_length1;
								_tmp55_ = _tmp54_[0];
								_tmp56_ = _tmp55_.x1;
								_vala_left = _tmp56_;
							}
							_tmp57_ = path;
							_tmp58_ = _tmp57_->lines;
							_tmp58__length1 = _tmp57_->lines_length1;
							_tmp59_ = _tmp58_[0];
							_tmp60_ = _tmp59_.y1;
							_tmp61_ = _vala_up;
							if (_tmp60_ < _tmp61_) {
								Path* _tmp62_ = NULL;
								PathLine* _tmp63_ = NULL;
								gint _tmp63__length1 = 0;
								PathLine _tmp64_ = {0};
								gint _tmp65_ = 0;
								_tmp62_ = path;
								_tmp63_ = _tmp62_->lines;
								_tmp63__length1 = _tmp62_->lines_length1;
								_tmp64_ = _tmp63_[0];
								_tmp65_ = _tmp64_.y1;
								_vala_up = _tmp65_;
							}
							_tmp66_ = path;
							_tmp67_ = _tmp66_->lines;
							_tmp67__length1 = _tmp66_->lines_length1;
							{
								PathLine* line_collection = NULL;
								gint line_collection_length1 = 0;
								gint _line_collection_size_ = 0;
								gint line_it = 0;
								line_collection = _tmp67_;
								line_collection_length1 = _tmp67__length1;
								for (line_it = 0; line_it < _tmp67__length1; line_it = line_it + 1) {
									PathLine line = {0};
									line = line_collection[line_it];
									{
										PathLine _tmp68_ = {0};
										gint _tmp69_ = 0;
										gint _tmp70_ = 0;
										PathLine _tmp73_ = {0};
										gint _tmp74_ = 0;
										gint _tmp75_ = 0;
										PathLine _tmp78_ = {0};
										gint _tmp79_ = 0;
										gint _tmp80_ = 0;
										PathLine _tmp83_ = {0};
										gint _tmp84_ = 0;
										gint _tmp85_ = 0;
										_tmp68_ = line;
										_tmp69_ = _tmp68_.x2;
										_tmp70_ = _vala_right;
										if (_tmp69_ > _tmp70_) {
											PathLine _tmp71_ = {0};
											gint _tmp72_ = 0;
											_tmp71_ = line;
											_tmp72_ = _tmp71_.x2;
											_vala_right = _tmp72_;
										}
										_tmp73_ = line;
										_tmp74_ = _tmp73_.y2;
										_tmp75_ = _vala_down;
										if (_tmp74_ > _tmp75_) {
											PathLine _tmp76_ = {0};
											gint _tmp77_ = 0;
											_tmp76_ = line;
											_tmp77_ = _tmp76_.y2;
											_vala_down = _tmp77_;
										}
										_tmp78_ = line;
										_tmp79_ = _tmp78_.x2;
										_tmp80_ = _vala_left;
										if (_tmp79_ < _tmp80_) {
											PathLine _tmp81_ = {0};
											gint _tmp82_ = 0;
											_tmp81_ = line;
											_tmp82_ = _tmp81_.x2;
											_vala_left = _tmp82_;
										}
										_tmp83_ = line;
										_tmp84_ = _tmp83_.y2;
										_tmp85_ = _vala_up;
										if (_tmp84_ < _tmp85_) {
											PathLine _tmp86_ = {0};
											gint _tmp87_ = 0;
											_tmp86_ = line;
											_tmp87_ = _tmp86_.y2;
											_vala_up = _tmp87_;
										}
									}
								}
							}
							_path_unref0 (path);
						}
					}
				}
				_tmp88_ = wireInst;
				_tmp89_ = _tmp88_->interfaceTag;
				if (_tmp89_ != NULL) {
					WireInst* _tmp90_ = NULL;
					Tag* _tmp91_ = NULL;
					gint _tmp92_ = 0;
					gint _tmp93_ = 0;
					WireInst* _tmp97_ = NULL;
					Tag* _tmp98_ = NULL;
					gint _tmp99_ = 0;
					gint _tmp100_ = 0;
					WireInst* _tmp104_ = NULL;
					Tag* _tmp105_ = NULL;
					gint _tmp106_ = 0;
					gint _tmp107_ = 0;
					WireInst* _tmp111_ = NULL;
					Tag* _tmp112_ = NULL;
					gint _tmp113_ = 0;
					gint _tmp114_ = 0;
					_tmp90_ = wireInst;
					_tmp91_ = _tmp90_->interfaceTag;
					_tmp92_ = _tmp91_->rightBound;
					_tmp93_ = _vala_right;
					if (_tmp92_ > _tmp93_) {
						WireInst* _tmp94_ = NULL;
						Tag* _tmp95_ = NULL;
						gint _tmp96_ = 0;
						_tmp94_ = wireInst;
						_tmp95_ = _tmp94_->interfaceTag;
						_tmp96_ = _tmp95_->rightBound;
						_vala_right = _tmp96_;
					}
					_tmp97_ = wireInst;
					_tmp98_ = _tmp97_->interfaceTag;
					_tmp99_ = _tmp98_->downBound;
					_tmp100_ = _vala_down;
					if (_tmp99_ > _tmp100_) {
						WireInst* _tmp101_ = NULL;
						Tag* _tmp102_ = NULL;
						gint _tmp103_ = 0;
						_tmp101_ = wireInst;
						_tmp102_ = _tmp101_->interfaceTag;
						_tmp103_ = _tmp102_->downBound;
						_vala_down = _tmp103_;
					}
					_tmp104_ = wireInst;
					_tmp105_ = _tmp104_->interfaceTag;
					_tmp106_ = _tmp105_->leftBound;
					_tmp107_ = _vala_left;
					if (_tmp106_ < _tmp107_) {
						WireInst* _tmp108_ = NULL;
						Tag* _tmp109_ = NULL;
						gint _tmp110_ = 0;
						_tmp108_ = wireInst;
						_tmp109_ = _tmp108_->interfaceTag;
						_tmp110_ = _tmp109_->leftBound;
						_vala_left = _tmp110_;
					}
					_tmp111_ = wireInst;
					_tmp112_ = _tmp111_->interfaceTag;
					_tmp113_ = _tmp112_->upBound;
					_tmp114_ = _vala_up;
					if (_tmp113_ < _tmp114_) {
						WireInst* _tmp115_ = NULL;
						Tag* _tmp116_ = NULL;
						gint _tmp117_ = 0;
						_tmp115_ = wireInst;
						_tmp116_ = _tmp115_->interfaceTag;
						_tmp117_ = _tmp116_->upBound;
						_vala_up = _tmp117_;
					}
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	_tmp118_ = self->annotations;
	_tmp118__length1 = self->annotations_length1;
	{
		Annotation** annotation_collection = NULL;
		gint annotation_collection_length1 = 0;
		gint _annotation_collection_size_ = 0;
		gint annotation_it = 0;
		annotation_collection = _tmp118_;
		annotation_collection_length1 = _tmp118__length1;
		for (annotation_it = 0; annotation_it < _tmp118__length1; annotation_it = annotation_it + 1) {
			Annotation* _tmp119_ = NULL;
			Annotation* annotation = NULL;
			_tmp119_ = _annotation_ref0 (annotation_collection[annotation_it]);
			annotation = _tmp119_;
			{
				gint currentRight = 0;
				Annotation* _tmp120_ = NULL;
				gint _tmp121_ = 0;
				Annotation* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gint currentDown = 0;
				Annotation* _tmp124_ = NULL;
				gint _tmp125_ = 0;
				Annotation* _tmp126_ = NULL;
				gint _tmp127_ = 0;
				gint currentLeft = 0;
				Annotation* _tmp128_ = NULL;
				gint _tmp129_ = 0;
				gint currentUp = 0;
				Annotation* _tmp130_ = NULL;
				gint _tmp131_ = 0;
				gint _tmp132_ = 0;
				gint _tmp133_ = 0;
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				gint _tmp138_ = 0;
				gint _tmp139_ = 0;
				gint _tmp141_ = 0;
				gint _tmp142_ = 0;
				_tmp120_ = annotation;
				_tmp121_ = _tmp120_->xPosition;
				_tmp122_ = annotation;
				_tmp123_ = _tmp122_->width;
				currentRight = _tmp121_ + _tmp123_;
				_tmp124_ = annotation;
				_tmp125_ = _tmp124_->yPosition;
				_tmp126_ = annotation;
				_tmp127_ = _tmp126_->height;
				currentDown = _tmp125_ + _tmp127_;
				_tmp128_ = annotation;
				_tmp129_ = _tmp128_->xPosition;
				currentLeft = _tmp129_;
				_tmp130_ = annotation;
				_tmp131_ = _tmp130_->yPosition;
				currentUp = _tmp131_;
				_tmp132_ = currentRight;
				_tmp133_ = _vala_right;
				if (_tmp132_ > _tmp133_) {
					gint _tmp134_ = 0;
					_tmp134_ = currentRight;
					_vala_right = _tmp134_;
				}
				_tmp135_ = currentDown;
				_tmp136_ = _vala_down;
				if (_tmp135_ > _tmp136_) {
					gint _tmp137_ = 0;
					_tmp137_ = currentDown;
					_vala_down = _tmp137_;
				}
				_tmp138_ = currentLeft;
				_tmp139_ = _vala_left;
				if (_tmp138_ < _tmp139_) {
					gint _tmp140_ = 0;
					_tmp140_ = currentLeft;
					_vala_left = _tmp140_;
				}
				_tmp141_ = currentUp;
				_tmp142_ = _vala_up;
				if (_tmp141_ < _tmp142_) {
					gint _tmp143_ = 0;
					_tmp143_ = currentUp;
					_vala_up = _tmp143_;
				}
				_annotation_unref0 (annotation);
			}
		}
	}
	_tmp145_ = _vala_right;
	_tmp146_ = _vala_left;
	if (_tmp145_ < _tmp146_) {
		_tmp144_ = TRUE;
	} else {
		gint _tmp147_ = 0;
		gint _tmp148_ = 0;
		_tmp147_ = _vala_down;
		_tmp148_ = _vala_up;
		_tmp144_ = _tmp147_ < _tmp148_;
	}
	if (_tmp144_) {
		_vala_right = 0;
		_vala_down = 0;
		_vala_left = 0;
		_vala_up = 0;
	}
	if (right) {
		*right = _vala_right;
	}
	if (down) {
		*down = _vala_down;
	}
	if (left) {
		*left = _vala_left;
	}
	if (up) {
		*up = _vala_up;
	}
}


/**
 * Renders the design of the circuitry.
 * If //showHints// is true, design-aiding elements will be
 * displayed.
 * If //showErrors// is true, errors will be highlighted.
 */
void custom_component_def_render_insts (CustomComponentDef* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds) {
	Annotation** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ComponentInst** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	WireInst** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->annotations;
	_tmp0__length1 = self->annotations_length1;
	{
		Annotation** annotation_collection = NULL;
		gint annotation_collection_length1 = 0;
		gint _annotation_collection_size_ = 0;
		gint annotation_it = 0;
		annotation_collection = _tmp0_;
		annotation_collection_length1 = _tmp0__length1;
		for (annotation_it = 0; annotation_it < _tmp0__length1; annotation_it = annotation_it + 1) {
			Annotation* _tmp1_ = NULL;
			Annotation* annotation = NULL;
			_tmp1_ = _annotation_ref0 (annotation_collection[annotation_it]);
			annotation = _tmp1_;
			{
				Annotation* _tmp2_ = NULL;
				cairo_t* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp2_ = annotation;
				_tmp3_ = context;
				_tmp4_ = showHints;
				annotation_render (_tmp2_, _tmp3_, _tmp4_);
				_annotation_unref0 (annotation);
			}
		}
	}
	_tmp5_ = self->componentInsts;
	_tmp5__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp5_;
		componentInst_collection_length1 = _tmp5__length1;
		for (componentInst_it = 0; componentInst_it < _tmp5__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp6_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp6_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp6_;
			{
				ComponentInst* _tmp7_ = NULL;
				cairo_t* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				_tmp7_ = componentInst;
				_tmp8_ = context;
				_tmp9_ = showHints;
				_tmp10_ = showErrors;
				_tmp11_ = colourBackgrounds;
				component_inst_render (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
				_component_inst_unref0 (componentInst);
			}
		}
	}
	_tmp12_ = self->wireInsts;
	_tmp12__length1 = self->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp12_;
		wireInst_collection_length1 = _tmp12__length1;
		for (wireInst_it = 0; wireInst_it < _tmp12__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp13_ = NULL;
			WireInst* wireInst = NULL;
			_tmp13_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp13_;
			{
				WireInst* _tmp14_ = NULL;
				cairo_t* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				_tmp14_ = wireInst;
				_tmp15_ = context;
				_tmp16_ = showHints;
				wire_inst_render (_tmp14_, _tmp15_, _tmp16_, FALSE);
				_wire_inst_unref0 (wireInst);
			}
		}
	}
}


/**
 * Add a new ComponentInst of type //componentDef//, at
 * (//x//, //y//), facing //direction// to the design.
 */
static ComponentInst** _vala_array_dup6 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add33 (ComponentInst*** array, int* length, int* size, ComponentInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static ComponentInst** _vala_array_dup7 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


ComponentInst* custom_component_def_add_componentInst (CustomComponentDef* self, ComponentDef* componentDef, gint x, gint y, Direction direction) {
	ComponentInst* result = NULL;
	ComponentInst* componentInst = NULL;
	ComponentDef* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Direction _tmp3_ = 0;
	ComponentInst* _tmp4_ = NULL;
	ComponentInst** newComponentInsts = NULL;
	ComponentInst** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	ComponentInst** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint newComponentInsts_length1 = 0;
	gint _newComponentInsts_size_ = 0;
	ComponentInst** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	ComponentInst* _tmp8_ = NULL;
	ComponentInst** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	ComponentInst** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	FILE* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (componentDef != NULL, NULL);
	_tmp0_ = componentDef;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = direction;
	_tmp4_ = component_inst_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_, FALSE);
	componentInst = _tmp4_;
	_tmp5_ = self->componentInsts;
	_tmp5__length1 = self->componentInsts_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup6 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	newComponentInsts = _tmp6_;
	newComponentInsts_length1 = _tmp6__length1;
	_newComponentInsts_size_ = newComponentInsts_length1;
	_tmp7_ = newComponentInsts;
	_tmp7__length1 = newComponentInsts_length1;
	_tmp8_ = _component_inst_ref0 (componentInst);
	_vala_array_add33 (&newComponentInsts, &newComponentInsts_length1, &_newComponentInsts_size_, _tmp8_);
	_tmp9_ = newComponentInsts;
	_tmp9__length1 = newComponentInsts_length1;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup7 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	self->componentInsts = (_vala_array_free (self->componentInsts, self->componentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
	self->componentInsts = _tmp10_;
	self->componentInsts_length1 = _tmp10__length1;
	_tmp11_ = stdout;
	fprintf (_tmp11_, "Added component\n");
	result = componentInst;
	newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
	return result;
}


/**
 * Add a new Annotation at (//x//, //y//), with text //text// of
 * font size //fontSize// to the design.
 */
static Annotation** _vala_array_dup8 (Annotation** self, int length) {
	Annotation** result;
	int i;
	result = g_new0 (Annotation*, length + 1);
	for (i = 0; i < length; i++) {
		Annotation* _tmp0_ = NULL;
		_tmp0_ = _annotation_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add34 (Annotation*** array, int* length, int* size, Annotation* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Annotation*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Annotation** _vala_array_dup9 (Annotation** self, int length) {
	Annotation** result;
	int i;
	result = g_new0 (Annotation*, length + 1);
	for (i = 0; i < length; i++) {
		Annotation* _tmp0_ = NULL;
		_tmp0_ = _annotation_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void custom_component_def_add_annotation (CustomComponentDef* self, gint x, gint y, const gchar* text, gdouble fontSize) {
	Annotation* annotation = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	Annotation* _tmp4_ = NULL;
	Annotation** newAnnotations = NULL;
	Annotation** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	Annotation** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint newAnnotations_length1 = 0;
	gint _newAnnotations_size_ = 0;
	Annotation** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	Annotation* _tmp8_ = NULL;
	Annotation** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	Annotation** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	FILE* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = text;
	_tmp3_ = fontSize;
	_tmp4_ = annotation_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	annotation = _tmp4_;
	_tmp5_ = self->annotations;
	_tmp5__length1 = self->annotations_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup8 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	newAnnotations = _tmp6_;
	newAnnotations_length1 = _tmp6__length1;
	_newAnnotations_size_ = newAnnotations_length1;
	_tmp7_ = newAnnotations;
	_tmp7__length1 = newAnnotations_length1;
	_tmp8_ = _annotation_ref0 (annotation);
	_vala_array_add34 (&newAnnotations, &newAnnotations_length1, &_newAnnotations_size_, _tmp8_);
	_tmp9_ = newAnnotations;
	_tmp9__length1 = newAnnotations_length1;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup9 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) annotation_unref), NULL);
	self->annotations = _tmp10_;
	self->annotations_length1 = _tmp10__length1;
	_tmp11_ = stdout;
	fprintf (_tmp11_, "Added annotation\n");
	newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
	_annotation_unref0 (annotation);
}


/**
 * Adds a new wire to the design and returns it.
 */
static WireInst** _vala_array_dup10 (WireInst** self, int length) {
	WireInst** result;
	int i;
	result = g_new0 (WireInst*, length + 1);
	for (i = 0; i < length; i++) {
		WireInst* _tmp0_ = NULL;
		_tmp0_ = _wire_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add35 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireInst** _vala_array_dup11 (WireInst** self, int length) {
	WireInst** result;
	int i;
	result = g_new0 (WireInst*, length + 1);
	for (i = 0; i < length; i++) {
		WireInst* _tmp0_ = NULL;
		_tmp0_ = _wire_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


WireInst* custom_component_def_add_wire (CustomComponentDef* self) {
	WireInst* result = NULL;
	WireInst* wireInst = NULL;
	WireInst* _tmp0_ = NULL;
	WireInst** newWireInsts = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	WireInst** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint newWireInsts_length1 = 0;
	gint _newWireInsts_size_ = 0;
	WireInst** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	WireInst* _tmp4_ = NULL;
	WireInst** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	WireInst** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	FILE* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = wire_inst_new ();
	wireInst = _tmp0_;
	_tmp1_ = self->wireInsts;
	_tmp1__length1 = self->wireInsts_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup10 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	newWireInsts = _tmp2_;
	newWireInsts_length1 = _tmp2__length1;
	_newWireInsts_size_ = newWireInsts_length1;
	_tmp3_ = newWireInsts;
	_tmp3__length1 = newWireInsts_length1;
	_tmp4_ = _wire_inst_ref0 (wireInst);
	_vala_array_add35 (&newWireInsts, &newWireInsts_length1, &_newWireInsts_size_, _tmp4_);
	_tmp5_ = newWireInsts;
	_tmp5__length1 = newWireInsts_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup11 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	self->wireInsts = (_vala_array_free (self->wireInsts, self->wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	self->wireInsts = _tmp6_;
	self->wireInsts_length1 = _tmp6__length1;
	_tmp7_ = stdout;
	fprintf (_tmp7_, "Added wire\n");
	result = wireInst;
	newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	return result;
}


/**
 * Deletes any selected components.
 */
static void _vala_array_add36 (ComponentInst*** array, int* length, int* size, ComponentInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static ComponentInst** _vala_array_dup12 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void custom_component_def_delete_selected_components (CustomComponentDef* self) {
	ComponentInst** newComponentInsts = NULL;
	ComponentInst** _tmp0_ = NULL;
	gint newComponentInsts_length1 = 0;
	gint _newComponentInsts_size_ = 0;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ComponentInst** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	ComponentInst** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (ComponentInst*, 0 + 1);
	newComponentInsts = _tmp0_;
	newComponentInsts_length1 = 0;
	_newComponentInsts_size_ = newComponentInsts_length1;
	_tmp1_ = self->componentInsts;
	_tmp1__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = componentInst;
				_tmp4_ = _tmp3_->selected;
				if (_tmp4_) {
					ComponentInst* _tmp5_ = NULL;
					FILE* _tmp6_ = NULL;
					_tmp5_ = componentInst;
					component_inst_detatch_all (_tmp5_);
					_tmp6_ = stdout;
					fprintf (_tmp6_, "Component deleted\n");
				} else {
					ComponentInst** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					ComponentInst* _tmp8_ = NULL;
					ComponentInst* _tmp9_ = NULL;
					_tmp7_ = newComponentInsts;
					_tmp7__length1 = newComponentInsts_length1;
					_tmp8_ = componentInst;
					_tmp9_ = _component_inst_ref0 (_tmp8_);
					_vala_array_add36 (&newComponentInsts, &newComponentInsts_length1, &_newComponentInsts_size_, _tmp9_);
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	_tmp10_ = newComponentInsts;
	_tmp10__length1 = newComponentInsts_length1;
	_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup12 (_tmp10_, _tmp10__length1) : ((gpointer) _tmp10_);
	_tmp11__length1 = _tmp10__length1;
	self->componentInsts = (_vala_array_free (self->componentInsts, self->componentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
	self->componentInsts = _tmp11_;
	self->componentInsts_length1 = _tmp11__length1;
	newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
}


/**
 * Deletes any selected wires.
 */
static void _vala_array_add37 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireInst** _vala_array_dup13 (WireInst** self, int length) {
	WireInst** result;
	int i;
	result = g_new0 (WireInst*, length + 1);
	for (i = 0; i < length; i++) {
		WireInst* _tmp0_ = NULL;
		_tmp0_ = _wire_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void custom_component_def_delete_selected_wires (CustomComponentDef* self) {
	WireInst** newWireInsts = NULL;
	WireInst** _tmp0_ = NULL;
	gint newWireInsts_length1 = 0;
	gint _newWireInsts_size_ = 0;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	WireInst** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	WireInst** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (WireInst*, 0 + 1);
	newWireInsts = _tmp0_;
	newWireInsts_length1 = 0;
	_newWireInsts_size_ = newWireInsts_length1;
	_tmp1_ = self->wireInsts;
	_tmp1__length1 = self->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				WireInst* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = wireInst;
				_tmp4_ = _tmp3_->selected;
				if (_tmp4_) {
					WireInst* _tmp5_ = NULL;
					FILE* _tmp6_ = NULL;
					_tmp5_ = wireInst;
					wire_inst_disconnect_components (_tmp5_);
					_tmp6_ = stdout;
					fprintf (_tmp6_, "Wire deleted\n");
				} else {
					WireInst** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					WireInst* _tmp8_ = NULL;
					WireInst* _tmp9_ = NULL;
					_tmp7_ = newWireInsts;
					_tmp7__length1 = newWireInsts_length1;
					_tmp8_ = wireInst;
					_tmp9_ = _wire_inst_ref0 (_tmp8_);
					_vala_array_add37 (&newWireInsts, &newWireInsts_length1, &_newWireInsts_size_, _tmp9_);
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	_tmp10_ = newWireInsts;
	_tmp10__length1 = newWireInsts_length1;
	_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup13 (_tmp10_, _tmp10__length1) : ((gpointer) _tmp10_);
	_tmp11__length1 = _tmp10__length1;
	self->wireInsts = (_vala_array_free (self->wireInsts, self->wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	self->wireInsts = _tmp11_;
	self->wireInsts_length1 = _tmp11__length1;
	newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
}


/**
 * Deletes any selected annotations.
 */
static void _vala_array_add38 (Annotation*** array, int* length, int* size, Annotation* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Annotation*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Annotation** _vala_array_dup14 (Annotation** self, int length) {
	Annotation** result;
	int i;
	result = g_new0 (Annotation*, length + 1);
	for (i = 0; i < length; i++) {
		Annotation* _tmp0_ = NULL;
		_tmp0_ = _annotation_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void custom_component_def_delete_selected_annotations (CustomComponentDef* self) {
	Annotation** newAnnotations = NULL;
	Annotation** _tmp0_ = NULL;
	gint newAnnotations_length1 = 0;
	gint _newAnnotations_size_ = 0;
	Annotation** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	Annotation** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	Annotation** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (Annotation*, 0 + 1);
	newAnnotations = _tmp0_;
	newAnnotations_length1 = 0;
	_newAnnotations_size_ = newAnnotations_length1;
	_tmp1_ = self->annotations;
	_tmp1__length1 = self->annotations_length1;
	{
		Annotation** annotation_collection = NULL;
		gint annotation_collection_length1 = 0;
		gint _annotation_collection_size_ = 0;
		gint annotation_it = 0;
		annotation_collection = _tmp1_;
		annotation_collection_length1 = _tmp1__length1;
		for (annotation_it = 0; annotation_it < _tmp1__length1; annotation_it = annotation_it + 1) {
			Annotation* _tmp2_ = NULL;
			Annotation* annotation = NULL;
			_tmp2_ = _annotation_ref0 (annotation_collection[annotation_it]);
			annotation = _tmp2_;
			{
				Annotation* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = annotation;
				_tmp4_ = _tmp3_->selected;
				if (_tmp4_) {
					FILE* _tmp5_ = NULL;
					_tmp5_ = stdout;
					fprintf (_tmp5_, "Annotation deleted\n");
				} else {
					Annotation** _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					Annotation* _tmp7_ = NULL;
					Annotation* _tmp8_ = NULL;
					_tmp6_ = newAnnotations;
					_tmp6__length1 = newAnnotations_length1;
					_tmp7_ = annotation;
					_tmp8_ = _annotation_ref0 (_tmp7_);
					_vala_array_add38 (&newAnnotations, &newAnnotations_length1, &_newAnnotations_size_, _tmp8_);
				}
				_annotation_unref0 (annotation);
			}
		}
	}
	_tmp9_ = newAnnotations;
	_tmp9__length1 = newAnnotations_length1;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup14 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) annotation_unref), NULL);
	self->annotations = _tmp10_;
	self->annotations_length1 = _tmp10__length1;
	newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
}


/**
 * Assigns new unique IDs to components and wires.
 */
void custom_component_def_update_ids (CustomComponentDef* self) {
	FILE* _tmp0_ = NULL;
	FILE* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Updating Component IDs\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				ComponentInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				ComponentInst** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				ComponentInst* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->componentInsts;
				_tmp4__length1 = self->componentInsts_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->componentInsts;
				_tmp5__length1 = self->componentInsts_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = i;
				_tmp7_->myID = _tmp8_;
			}
		}
	}
	_tmp9_ = stdout;
	fprintf (_tmp9_, "Updating Wire IDs\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_ = 0;
				WireInst** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				WireInst** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				WireInst* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				if (!_tmp10_) {
					gint _tmp11_ = 0;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = self->wireInsts;
				_tmp13__length1 = self->wireInsts_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = self->wireInsts;
				_tmp14__length1 = self->wireInsts_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = i;
				_tmp16_->myID = _tmp17_;
			}
		}
	}
}


/**
 * Recursive function to check for any cyclic dependencies. Returns
 * an ancestry up to the point of failure if there is a cyclic
 * dependency, else returns null.
 */
static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


CustomComponentDef** custom_component_def_validate_dependencies (CustomComponentDef* self, CustomComponentDef** componentChain, int componentChain_length1, int* result_length1) {
	CustomComponentDef** result = NULL;
	CustomComponentDef** newComponentChain = NULL;
	CustomComponentDef** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	CustomComponentDef** _tmp1_ = NULL;
	gint newComponentChain_length1 = 0;
	gint _newComponentChain_size_ = 0;
	CustomComponentDef** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	CustomComponentDef** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	CustomComponentDef* _tmp15_ = NULL;
	CustomComponentDef* _tmp16_ = NULL;
	CustomComponentDef** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	ComponentInst** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	CustomComponentDef** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = componentChain;
	_tmp0__length1 = componentChain_length1;
	_tmp1_ = g_new0 (CustomComponentDef*, (_tmp0__length1 + 1) + 1);
	newComponentChain = _tmp1_;
	newComponentChain_length1 = _tmp0__length1 + 1;
	_newComponentChain_size_ = newComponentChain_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				CustomComponentDef** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				CustomComponentDef** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				CustomComponentDef** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				CustomComponentDef* _tmp10_ = NULL;
				CustomComponentDef* _tmp11_ = NULL;
				CustomComponentDef* _tmp12_ = NULL;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = componentChain;
				_tmp5__length1 = componentChain_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = newComponentChain;
				_tmp6__length1 = newComponentChain_length1;
				_tmp7_ = i;
				_tmp8_ = componentChain;
				_tmp8__length1 = componentChain_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = _component_def_ref0 (_tmp10_);
				_component_def_unref0 (_tmp6_[_tmp7_]);
				_tmp6_[_tmp7_] = _tmp11_;
				_tmp12_ = _tmp6_[_tmp7_];
			}
		}
	}
	_tmp13_ = newComponentChain;
	_tmp13__length1 = newComponentChain_length1;
	_tmp14_ = newComponentChain;
	_tmp14__length1 = newComponentChain_length1;
	_tmp15_ = _component_def_ref0 (self);
	_component_def_unref0 (_tmp13_[_tmp14__length1 - 1]);
	_tmp13_[_tmp14__length1 - 1] = _tmp15_;
	_tmp16_ = _tmp13_[_tmp14__length1 - 1];
	_tmp17_ = componentChain;
	_tmp17__length1 = componentChain_length1;
	{
		CustomComponentDef** chainPart_collection = NULL;
		gint chainPart_collection_length1 = 0;
		gint _chainPart_collection_size_ = 0;
		gint chainPart_it = 0;
		chainPart_collection = _tmp17_;
		chainPart_collection_length1 = _tmp17__length1;
		for (chainPart_it = 0; chainPart_it < _tmp17__length1; chainPart_it = chainPart_it + 1) {
			CustomComponentDef* _tmp18_ = NULL;
			CustomComponentDef* chainPart = NULL;
			_tmp18_ = _component_def_ref0 (chainPart_collection[chainPart_it]);
			chainPart = _tmp18_;
			{
				CustomComponentDef* _tmp19_ = NULL;
				_tmp19_ = chainPart;
				if (_tmp19_ == self) {
					CustomComponentDef** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					_tmp20_ = newComponentChain;
					_tmp20__length1 = newComponentChain_length1;
					if (result_length1) {
						*result_length1 = _tmp20__length1;
					}
					result = _tmp20_;
					_component_def_unref0 (chainPart);
					return result;
				}
				_component_def_unref0 (chainPart);
			}
		}
	}
	_tmp21_ = self->componentInsts;
	_tmp21__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp21_;
		componentInst_collection_length1 = _tmp21__length1;
		for (componentInst_it = 0; componentInst_it < _tmp21__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp22_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp22_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp22_;
			{
				ComponentInst* _tmp23_ = NULL;
				ComponentDef* _tmp24_ = NULL;
				_tmp23_ = componentInst;
				_tmp24_ = _tmp23_->componentDef;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, TYPE_CUSTOM_COMPONENT_DEF)) {
					CustomComponentDef** _result_ = NULL;
					gint _result__length1 = 0;
					gint __result__size_ = 0;
					ComponentInst* _tmp25_ = NULL;
					ComponentDef* _tmp26_ = NULL;
					CustomComponentDef** _tmp27_ = NULL;
					gint _tmp27__length1 = 0;
					gint _tmp28_ = 0;
					CustomComponentDef** _tmp29_ = NULL;
					CustomComponentDef** _tmp30_ = NULL;
					gint _tmp30__length1 = 0;
					_tmp25_ = componentInst;
					_tmp26_ = _tmp25_->componentDef;
					_tmp27_ = newComponentChain;
					_tmp27__length1 = newComponentChain_length1;
					_tmp29_ = custom_component_def_validate_dependencies (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, TYPE_CUSTOM_COMPONENT_DEF) ? ((CustomComponentDef*) _tmp26_) : NULL, _tmp27_, _tmp27__length1, &_tmp28_);
					_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) component_def_unref), NULL);
					_result_ = _tmp29_;
					_result__length1 = _tmp28_;
					__result__size_ = _result__length1;
					_tmp30_ = _result_;
					_tmp30__length1 = _result__length1;
					if (_tmp30_ != NULL) {
						CustomComponentDef** _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						_tmp31_ = _result_;
						_tmp31__length1 = _result__length1;
						if (result_length1) {
							*result_length1 = _tmp31__length1;
						}
						result = _tmp31_;
						_component_inst_unref0 (componentInst);
						newComponentChain = (_vala_array_free (newComponentChain, newComponentChain_length1, (GDestroyNotify) component_def_unref), NULL);
						return result;
					}
					_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) component_def_unref), NULL);
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	_tmp32_ = NULL;
	_tmp32__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	newComponentChain = (_vala_array_free (newComponentChain, newComponentChain_length1, (GDestroyNotify) component_def_unref), NULL);
	return result;
}


/**
 * Checks that all ComponentInsts are adequately connected to wires.
 * Returns the number of erroneous components.
 */
static gpointer _pin_inst_ref0 (gpointer self) {
	return self ? pin_inst_ref (self) : NULL;
}


gint custom_component_def_validate_pins (CustomComponentDef* self) {
	gint result = 0;
	gint errorCount = 0;
	ComponentInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	errorCount = 0;
	_tmp0_ = self->componentInsts;
	_tmp0__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp0_;
		componentInst_collection_length1 = _tmp0__length1;
		for (componentInst_it = 0; componentInst_it < _tmp0__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp1_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp1_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp1_;
			{
				ComponentInst* _tmp2_ = NULL;
				PinInst** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				_tmp2_ = componentInst;
				_tmp3_ = _tmp2_->pinInsts;
				_tmp3__length1 = _tmp2_->pinInsts_length1;
				{
					PinInst** pinInst_collection = NULL;
					gint pinInst_collection_length1 = 0;
					gint _pinInst_collection_size_ = 0;
					gint pinInst_it = 0;
					pinInst_collection = _tmp3_;
					pinInst_collection_length1 = _tmp3__length1;
					for (pinInst_it = 0; pinInst_it < _tmp3__length1; pinInst_it = pinInst_it + 1) {
						PinInst* _tmp4_ = NULL;
						PinInst* pinInst = NULL;
						_tmp4_ = _pin_inst_ref0 (pinInst_collection[pinInst_it]);
						pinInst = _tmp4_;
						{
							PinInst* _tmp5_ = NULL;
							gint _tmp6_ = 0;
							_tmp5_ = pinInst;
							_tmp6_ = pin_inst_validate_connections (_tmp5_);
							if (_tmp6_ == 1) {
								ComponentInst* _tmp7_ = NULL;
								gint _tmp8_ = 0;
								_tmp7_ = componentInst;
								_tmp7_->errorMark = TRUE;
								_tmp8_ = errorCount;
								errorCount = _tmp8_ + 1;
								_pin_inst_unref0 (pinInst);
								break;
							}
							_pin_inst_unref0 (pinInst);
						}
					}
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	result = errorCount;
	return result;
}


/**
 * Checks that all pins map to an interface tag. Return 0 on success
 * or 1 on failure.
 */
gint custom_component_def_validate_interfaces (CustomComponentDef* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				PinDef** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp4_ = 0;
				Tag* _tmp5_ = NULL;
				Tag* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = ((ComponentDef*) self)->pinDefs;
				_tmp3__length1 = ((ComponentDef*) self)->pinDefs_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = custom_component_def_resolve_tag_id (self, _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = _tmp6_ == NULL;
				_tag_unref0 (_tmp6_);
				if (_tmp7_) {
					result = 1;
					return result;
				}
			}
		}
	}
	result = 0;
	return result;
}


/**
 * Check for any components sharing the same centre. Return the
 * number of erroneous components.
 */
gint custom_component_def_validate_overlaps (CustomComponentDef* self) {
	gint result = 0;
	gint errorCount = 0;
	g_return_val_if_fail (self != NULL, 0);
	errorCount = 0;
	{
		gint i1 = 0;
		i1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				ComponentInst** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				ComponentInst* componentInst1 = NULL;
				ComponentInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				ComponentInst* _tmp6_ = NULL;
				ComponentInst* _tmp7_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i1;
					i1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i1;
				_tmp3_ = self->componentInsts;
				_tmp3__length1 = self->componentInsts_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->componentInsts;
				_tmp4__length1 = self->componentInsts_length1;
				_tmp5_ = i1;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _component_inst_ref0 (_tmp6_);
				componentInst1 = _tmp7_;
				{
					gint i2 = 0;
					gint _tmp8_ = 0;
					_tmp8_ = i1;
					i2 = _tmp8_ + 1;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_ = 0;
							ComponentInst** _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							ComponentInst* componentInst2 = NULL;
							ComponentInst** _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp14_ = 0;
							ComponentInst* _tmp15_ = NULL;
							ComponentInst* _tmp16_ = NULL;
							gboolean _tmp17_ = FALSE;
							ComponentInst* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							ComponentInst* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = i2;
								i2 = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = i2;
							_tmp12_ = self->componentInsts;
							_tmp12__length1 = self->componentInsts_length1;
							if (!(_tmp11_ < _tmp12__length1)) {
								break;
							}
							_tmp13_ = self->componentInsts;
							_tmp13__length1 = self->componentInsts_length1;
							_tmp14_ = i2;
							_tmp15_ = _tmp13_[_tmp14_];
							_tmp16_ = _component_inst_ref0 (_tmp15_);
							componentInst2 = _tmp16_;
							_tmp18_ = componentInst1;
							_tmp19_ = _tmp18_->xPosition;
							_tmp20_ = componentInst2;
							_tmp21_ = _tmp20_->xPosition;
							if (_tmp19_ == _tmp21_) {
								ComponentInst* _tmp22_ = NULL;
								gint _tmp23_ = 0;
								ComponentInst* _tmp24_ = NULL;
								gint _tmp25_ = 0;
								_tmp22_ = componentInst1;
								_tmp23_ = _tmp22_->yPosition;
								_tmp24_ = componentInst2;
								_tmp25_ = _tmp24_->yPosition;
								_tmp17_ = _tmp23_ == _tmp25_;
							} else {
								_tmp17_ = FALSE;
							}
							if (_tmp17_) {
								FILE* _tmp26_ = NULL;
								ComponentInst* _tmp27_ = NULL;
								ComponentInst* _tmp28_ = NULL;
								gint _tmp29_ = 0;
								_tmp26_ = stdout;
								fprintf (_tmp26_, "Found overlaping components!\n");
								_tmp27_ = componentInst1;
								_tmp27_->errorMark = TRUE;
								_tmp28_ = componentInst2;
								_tmp28_->errorMark = TRUE;
								_tmp29_ = errorCount;
								errorCount = _tmp29_ + 1;
							}
							_component_inst_unref0 (componentInst2);
						}
					}
				}
				_component_inst_unref0 (componentInst1);
			}
		}
	}
	result = errorCount;
	return result;
}


/**
 * Loads a component from the file //infoFilename//, using libxml.
 */
static void _vala_array_add39 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add40 (ComponentInst*** array, int* length, int* size, ComponentInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add41 (Annotation*** array, int* length, int* size, Annotation* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Annotation*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireInst** _vala_array_dup15 (WireInst** self, int length) {
	WireInst** result;
	int i;
	result = g_new0 (WireInst*, length + 1);
	for (i = 0; i < length; i++) {
		WireInst* _tmp0_ = NULL;
		_tmp0_ = _wire_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static ComponentInst** _vala_array_dup16 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Annotation** _vala_array_dup17 (Annotation** self, int length) {
	Annotation** result;
	int i;
	result = g_new0 (Annotation*, length + 1);
	for (i = 0; i < length; i++) {
		Annotation* _tmp0_ = NULL;
		_tmp0_ = _annotation_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint custom_component_def_load (CustomComponentDef* self, const gchar* infoFilename, GError** error) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	FILE* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	xmlDoc* xmldoc = NULL;
	xmlNode* xmlroot = NULL;
	xmlNode* xmlnode = NULL;
	const gchar* _tmp4_ = NULL;
	xmlDoc* _tmp5_ = NULL;
	xmlDoc* _tmp6_ = NULL;
	xmlDoc* _tmp10_ = NULL;
	xmlNode* _tmp11_ = NULL;
	xmlNode* _tmp12_ = NULL;
	xmlNode* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	ComponentInst** newComponentInsts = NULL;
	ComponentInst** _tmp23_ = NULL;
	gint newComponentInsts_length1 = 0;
	gint _newComponentInsts_size_ = 0;
	WireInst** newWireInsts = NULL;
	WireInst** _tmp24_ = NULL;
	gint newWireInsts_length1 = 0;
	gint _newWireInsts_size_ = 0;
	Annotation** newAnnotations = NULL;
	Annotation** _tmp25_ = NULL;
	gint newAnnotations_length1 = 0;
	gint _newAnnotations_size_ = 0;
	xmlDoc* _tmp75_ = NULL;
	WireInst** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	WireInst** _tmp77_ = NULL;
	gint _tmp77__length1 = 0;
	ComponentInst** _tmp78_ = NULL;
	gint _tmp78__length1 = 0;
	ComponentInst** _tmp79_ = NULL;
	gint _tmp79__length1 = 0;
	Annotation** _tmp80_ = NULL;
	gint _tmp80__length1 = 0;
	Annotation** _tmp81_ = NULL;
	gint _tmp81__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (infoFilename != NULL, 0);
	_tmp0_ = infoFilename;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		FILE* _tmp1_ = NULL;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "Defining component later\n");
		result = 0;
		return result;
	}
	_tmp2_ = stdout;
	_tmp3_ = infoFilename;
	fprintf (_tmp2_, "Loading custom component specific data from \"%s\"\n", _tmp3_);
	_tmp4_ = infoFilename;
	_tmp5_ = xmlParseFile (_tmp4_);
	xmldoc = _tmp5_;
	_tmp6_ = xmldoc;
	if (_tmp6_ == NULL) {
		FILE* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = infoFilename;
		fprintf (_tmp7_, "Error loading info xml file \"%s\".\n", _tmp8_);
		_tmp9_ = stdout;
		fprintf (_tmp9_, "File inaccessible.\n");
		result = 1;
		return result;
	}
	_tmp10_ = xmldoc;
	_tmp11_ = xmlDocGetRootElement (_tmp10_);
	xmlroot = _tmp11_;
	_tmp12_ = xmlroot;
	if (_tmp12_ == NULL) {
		FILE* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = infoFilename;
		fprintf (_tmp13_, "Error loading info xml file \"%s\".\n", _tmp14_);
		_tmp15_ = stdout;
		fprintf (_tmp15_, "File is empty.\n");
		result = 1;
		return result;
	}
	_tmp16_ = xmlroot;
	_tmp17_ = _tmp16_->name;
	if (g_strcmp0 (_tmp17_, "custom_component") != 0) {
		FILE* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		FILE* _tmp20_ = NULL;
		xmlNode* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp18_ = stdout;
		_tmp19_ = infoFilename;
		fprintf (_tmp18_, "Error loading info xml file \"%s\".\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = xmlroot;
		_tmp22_ = _tmp21_->name;
		fprintf (_tmp20_, "Wanted \"custom_component\" info, but got \"%s\"\n", _tmp22_);
		result = 1;
		return result;
	}
	_tmp23_ = g_new0 (ComponentInst*, 0 + 1);
	newComponentInsts = _tmp23_;
	newComponentInsts_length1 = 0;
	_newComponentInsts_size_ = newComponentInsts_length1;
	_tmp24_ = g_new0 (WireInst*, 0 + 1);
	newWireInsts = _tmp24_;
	newWireInsts_length1 = 0;
	_newWireInsts_size_ = newWireInsts_length1;
	_tmp25_ = g_new0 (Annotation*, 0 + 1);
	newAnnotations = _tmp25_;
	newAnnotations_length1 = 0;
	_newAnnotations_size_ = newAnnotations_length1;
	{
		xmlNode* _tmp26_ = NULL;
		xmlNode* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		_tmp26_ = xmlroot;
		_tmp27_ = _tmp26_->children;
		xmlnode = _tmp27_;
		_tmp28_ = TRUE;
		while (TRUE) {
			xmlNode* _tmp31_ = NULL;
			xmlNode* _tmp32_ = NULL;
			xmlElementType _tmp33_ = 0;
			xmlNode* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			GQuark _tmp38_ = 0U;
			static GQuark _tmp37_label0 = 0;
			static GQuark _tmp37_label1 = 0;
			static GQuark _tmp37_label2 = 0;
			if (!_tmp28_) {
				xmlNode* _tmp29_ = NULL;
				xmlNode* _tmp30_ = NULL;
				_tmp29_ = xmlnode;
				_tmp30_ = _tmp29_->next;
				xmlnode = _tmp30_;
			}
			_tmp28_ = FALSE;
			_tmp31_ = xmlnode;
			if (!(_tmp31_ != NULL)) {
				break;
			}
			_tmp32_ = xmlnode;
			_tmp33_ = _tmp32_->type;
			if (_tmp33_ != XML_ELEMENT_NODE) {
				continue;
			}
			_tmp34_ = xmlnode;
			_tmp35_ = _tmp34_->name;
			_tmp36_ = _tmp35_;
			_tmp38_ = (NULL == _tmp36_) ? 0 : g_quark_from_string (_tmp36_);
			if (_tmp38_ == ((0 != _tmp37_label0) ? _tmp37_label0 : (_tmp37_label0 = g_quark_from_static_string ("wire")))) {
				switch (0) {
					default:
					{
						{
							WireInst* newWireInst = NULL;
							xmlNode* _tmp39_ = NULL;
							WireInst* _tmp40_ = NULL;
							WireInst** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							WireInst* _tmp42_ = NULL;
							WireInst* _tmp43_ = NULL;
							_tmp39_ = xmlnode;
							_tmp40_ = wire_inst_new_load (_tmp39_);
							newWireInst = _tmp40_;
							_tmp41_ = newWireInsts;
							_tmp41__length1 = newWireInsts_length1;
							_tmp42_ = newWireInst;
							_tmp43_ = _wire_inst_ref0 (_tmp42_);
							_vala_array_add39 (&newWireInsts, &newWireInsts_length1, &_newWireInsts_size_, _tmp43_);
							_wire_inst_unref0 (newWireInst);
						}
						break;
					}
				}
			} else if (_tmp38_ == ((0 != _tmp37_label1) ? _tmp37_label1 : (_tmp37_label1 = g_quark_from_static_string ("component")))) {
				switch (0) {
					default:
					{
						{
							ComponentInst* newComponentInst = NULL;
							{
								ComponentInst* _tmp44_ = NULL;
								xmlNode* _tmp45_ = NULL;
								Project* _tmp46_ = NULL;
								WireInst** _tmp47_ = NULL;
								gint _tmp47__length1 = 0;
								ComponentInst* _tmp48_ = NULL;
								ComponentInst* _tmp49_ = NULL;
								ComponentInst** _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								ComponentInst* _tmp51_ = NULL;
								ComponentInst* _tmp52_ = NULL;
								_tmp45_ = xmlnode;
								_tmp46_ = self->priv->project;
								_tmp47_ = newWireInsts;
								_tmp47__length1 = newWireInsts_length1;
								_tmp48_ = component_inst_new_load (_tmp45_, _tmp46_, _tmp47_, _tmp47__length1, &_inner_error_);
								_tmp44_ = _tmp48_;
								if (_inner_error_ != NULL) {
									if (g_error_matches (_inner_error_, COMPONENT_INST_LOAD_ERROR, COMPONENT_INST_LOAD_ERROR_INVALID)) {
										goto __catch28_component_inst_load_error_invalid;
									}
									if (g_error_matches (_inner_error_, COMPONENT_INST_LOAD_ERROR, COMPONENT_INST_LOAD_ERROR_MISSING_DEF)) {
										goto __catch28_component_inst_load_error_missing_def;
									}
									_component_inst_unref0 (newComponentInst);
									newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
									newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
									newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
								_tmp49_ = _tmp44_;
								_tmp44_ = NULL;
								_component_inst_unref0 (newComponentInst);
								newComponentInst = _tmp49_;
								_tmp50_ = newComponentInsts;
								_tmp50__length1 = newComponentInsts_length1;
								_tmp51_ = newComponentInst;
								_tmp52_ = _component_inst_ref0 (_tmp51_);
								_vala_array_add40 (&newComponentInsts, &newComponentInsts_length1, &_newComponentInsts_size_, _tmp52_);
								_component_inst_unref0 (_tmp44_);
							}
							goto __finally28;
							__catch28_component_inst_load_error_invalid:
							{
								GError* _error_ = NULL;
								FILE* _tmp53_ = NULL;
								GError* _tmp54_ = NULL;
								const gchar* _tmp55_ = NULL;
								GError* _tmp56_ = NULL;
								const gchar* _tmp57_ = NULL;
								GError* _tmp58_ = NULL;
								_error_ = _inner_error_;
								_inner_error_ = NULL;
								_tmp53_ = stderr;
								_tmp54_ = _error_;
								_tmp55_ = _tmp54_->message;
								fprintf (_tmp53_, "Error adding new component: %s\n", _tmp55_);
								_tmp56_ = _error_;
								_tmp57_ = _tmp56_->message;
								_tmp58_ = g_error_new_literal (CUSTOM_COMPONENT_DEF_LOAD_ERROR, CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID, _tmp57_);
								_inner_error_ = _tmp58_;
								_g_error_free0 (_error_);
								goto __finally28;
							}
							goto __finally28;
							__catch28_component_inst_load_error_missing_def:
							{
								GError* _error_ = NULL;
								FILE* _tmp59_ = NULL;
								GError* _tmp60_ = NULL;
								const gchar* _tmp61_ = NULL;
								GError* _tmp62_ = NULL;
								const gchar* _tmp63_ = NULL;
								GError* _tmp64_ = NULL;
								_error_ = _inner_error_;
								_inner_error_ = NULL;
								_tmp59_ = stderr;
								_tmp60_ = _error_;
								_tmp61_ = _tmp60_->message;
								fprintf (_tmp59_, "Error adding new component: %s\n", _tmp61_);
								_tmp62_ = _error_;
								_tmp63_ = _tmp62_->message;
								_tmp64_ = g_error_new_literal (CUSTOM_COMPONENT_DEF_LOAD_ERROR, CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY, _tmp63_);
								_inner_error_ = _tmp64_;
								_g_error_free0 (_error_);
								goto __finally28;
							}
							__finally28:
							if (_inner_error_ != NULL) {
								if ((_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_component_inst_unref0 (newComponentInst);
									newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
									newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
									newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
									return 0;
								} else {
									_component_inst_unref0 (newComponentInst);
									newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
									newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
									newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							_component_inst_unref0 (newComponentInst);
						}
						break;
					}
				}
			} else if (_tmp38_ == ((0 != _tmp37_label2) ? _tmp37_label2 : (_tmp37_label2 = g_quark_from_static_string ("annotation")))) {
				switch (0) {
					default:
					{
						{
							Annotation* newAnnotation = NULL;
							{
								Annotation* _tmp65_ = NULL;
								xmlNode* _tmp66_ = NULL;
								Annotation* _tmp67_ = NULL;
								Annotation* _tmp68_ = NULL;
								Annotation** _tmp69_ = NULL;
								gint _tmp69__length1 = 0;
								Annotation* _tmp70_ = NULL;
								Annotation* _tmp71_ = NULL;
								_tmp66_ = xmlnode;
								_tmp67_ = annotation_new_load (_tmp66_, &_inner_error_);
								_tmp65_ = _tmp67_;
								if (_inner_error_ != NULL) {
									if (g_error_matches (_inner_error_, ANNOTATION_LOAD_ERROR, ANNOTATION_LOAD_ERROR_EMPTY)) {
										goto __catch29_annotation_load_error_empty;
									}
									_annotation_unref0 (newAnnotation);
									newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
									newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
									newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
								_tmp68_ = _tmp65_;
								_tmp65_ = NULL;
								_annotation_unref0 (newAnnotation);
								newAnnotation = _tmp68_;
								_tmp69_ = newAnnotations;
								_tmp69__length1 = newAnnotations_length1;
								_tmp70_ = newAnnotation;
								_tmp71_ = _annotation_ref0 (_tmp70_);
								_vala_array_add41 (&newAnnotations, &newAnnotations_length1, &_newAnnotations_size_, _tmp71_);
								_annotation_unref0 (_tmp65_);
							}
							goto __finally29;
							__catch29_annotation_load_error_empty:
							{
								GError* _error_ = NULL;
								FILE* _tmp72_ = NULL;
								GError* _tmp73_ = NULL;
								const gchar* _tmp74_ = NULL;
								_error_ = _inner_error_;
								_inner_error_ = NULL;
								_tmp72_ = stderr;
								_tmp73_ = _error_;
								_tmp74_ = _tmp73_->message;
								fprintf (_tmp72_, "Error adding new annotation: %s\n", _tmp74_);
								_g_error_free0 (_error_);
							}
							__finally29:
							if (_inner_error_ != NULL) {
								if ((_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_annotation_unref0 (newAnnotation);
									newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
									newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
									newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
									return 0;
								} else {
									_annotation_unref0 (newAnnotation);
									newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
									newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
									newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							_annotation_unref0 (newAnnotation);
						}
						break;
					}
				}
			}
		}
	}
	_tmp75_ = xmldoc;
	xmlFreeDoc (_tmp75_);
	_tmp76_ = newWireInsts;
	_tmp76__length1 = newWireInsts_length1;
	_tmp77_ = (_tmp76_ != NULL) ? _vala_array_dup15 (_tmp76_, _tmp76__length1) : ((gpointer) _tmp76_);
	_tmp77__length1 = _tmp76__length1;
	self->wireInsts = (_vala_array_free (self->wireInsts, self->wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	self->wireInsts = _tmp77_;
	self->wireInsts_length1 = _tmp77__length1;
	_tmp78_ = newComponentInsts;
	_tmp78__length1 = newComponentInsts_length1;
	_tmp79_ = (_tmp78_ != NULL) ? _vala_array_dup16 (_tmp78_, _tmp78__length1) : ((gpointer) _tmp78_);
	_tmp79__length1 = _tmp78__length1;
	self->componentInsts = (_vala_array_free (self->componentInsts, self->componentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
	self->componentInsts = _tmp79_;
	self->componentInsts_length1 = _tmp79__length1;
	_tmp80_ = newAnnotations;
	_tmp80__length1 = newAnnotations_length1;
	_tmp81_ = (_tmp80_ != NULL) ? _vala_array_dup17 (_tmp80_, _tmp80__length1) : ((gpointer) _tmp80_);
	_tmp81__length1 = _tmp80__length1;
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) annotation_unref), NULL);
	self->annotations = _tmp81_;
	self->annotations_length1 = _tmp81__length1;
	result = 0;
	newAnnotations = (_vala_array_free (newAnnotations, newAnnotations_length1, (GDestroyNotify) annotation_unref), NULL);
	newWireInsts = (_vala_array_free (newWireInsts, newWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	newComponentInsts = (_vala_array_free (newComponentInsts, newComponentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
	return result;
}


/**
 * Saves the ComponentInst to the file //fileName//, using libxml.
 */
gint custom_component_def_save (CustomComponentDef* self, const gchar* fileName) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlTextWriter* xmlWriter = NULL;
	const gchar* _tmp3_ = NULL;
	xmlTextWriter* _tmp4_ = NULL;
	xmlTextWriter* _tmp5_ = NULL;
	xmlTextWriter* _tmp6_ = NULL;
	xmlTextWriter* _tmp7_ = NULL;
	xmlTextWriter* _tmp8_ = NULL;
	FILE* _tmp9_ = NULL;
	xmlTextWriter* _tmp10_ = NULL;
	xmlTextWriter* _tmp11_ = NULL;
	xmlTextWriter* _tmp12_ = NULL;
	xmlTextWriter* _tmp13_ = NULL;
	xmlTextWriter* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	xmlTextWriter* _tmp18_ = NULL;
	xmlTextWriter* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	xmlTextWriter* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	xmlTextWriter* _tmp26_ = NULL;
	xmlTextWriter* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	xmlTextWriter* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	xmlTextWriter* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	xmlTextWriter* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	xmlTextWriter* _tmp43_ = NULL;
	xmlTextWriter* _tmp44_ = NULL;
	xmlTextWriter* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	xmlTextWriter* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	xmlTextWriter* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	xmlTextWriter* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	xmlTextWriter* _tmp61_ = NULL;
	FILE* _tmp62_ = NULL;
	FILE* _tmp72_ = NULL;
	FILE* _tmp81_ = NULL;
	FILE* _tmp90_ = NULL;
	xmlTextWriter* _tmp99_ = NULL;
	xmlTextWriter* _tmp100_ = NULL;
	xmlTextWriter* _tmp101_ = NULL;
	FILE* _tmp102_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (fileName != NULL, 0);
	_tmp0_ = stdout;
	_tmp1_ = ((ComponentDef*) self)->name;
	_tmp2_ = fileName;
	fprintf (_tmp0_, "Saving Component \"%s\" to \"%s\"\n", _tmp1_, _tmp2_);
	custom_component_def_update_ids (self);
	_tmp3_ = fileName;
	_tmp4_ = xmlNewTextWriterFilename (_tmp3_, FALSE);
	xmlWriter = _tmp4_;
	_tmp5_ = xmlWriter;
	xmlTextWriterSetIndent (_tmp5_, TRUE);
	_tmp6_ = xmlWriter;
	xmlTextWriterSetIndentString (_tmp6_, (xmlChar*) "\t");
	_tmp7_ = xmlWriter;
	xmlTextWriterStartDocument (_tmp7_, NULL, NULL, NULL);
	_tmp8_ = xmlWriter;
	xmlTextWriterStartElement (_tmp8_, (xmlChar*) "custom_component");
	_tmp9_ = stdout;
	fprintf (_tmp9_, "Saving description data...\n");
	_tmp10_ = xmlWriter;
	xmlTextWriterStartElement (_tmp10_, (xmlChar*) "metadata");
	_tmp11_ = xmlWriter;
	xmlTextWriterStartElement (_tmp11_, (xmlChar*) "version");
	_tmp12_ = xmlWriter;
	xmlTextWriterWriteAttribute (_tmp12_, (xmlChar*) "smartsim", (xmlChar*) CORE_shortVersionString);
	_tmp13_ = xmlWriter;
	xmlTextWriterEndElement (_tmp13_);
	_tmp14_ = xmlWriter;
	xmlTextWriterEndElement (_tmp14_);
	_tmp16_ = ((ComponentDef*) self)->name;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_ = NULL;
		_tmp17_ = ((ComponentDef*) self)->name;
		_tmp15_ = _tmp17_;
	} else {
		_tmp15_ = "Untitled";
	}
	_tmp18_ = xmlWriter;
	xmlTextWriterWriteElement (_tmp18_, (xmlChar*) "name", (xmlChar*) _tmp15_);
	_tmp19_ = xmlWriter;
	_tmp20_ = ((ComponentDef*) self)->description;
	xmlTextWriterWriteElement (_tmp19_, (xmlChar*) "description", (xmlChar*) _tmp20_);
	_tmp21_ = xmlWriter;
	_tmp22_ = ((ComponentDef*) self)->label;
	xmlTextWriterWriteElement (_tmp21_, (xmlChar*) "label", (xmlChar*) _tmp22_);
	_tmp23_ = ((ComponentDef*) self)->graphicReferenceFilename;
	if (_tmp23_ != NULL) {
		xmlTextWriter* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_tmp24_ = xmlWriter;
		_tmp25_ = ((ComponentDef*) self)->graphicReferenceFilename;
		xmlTextWriterWriteElement (_tmp24_, (xmlChar*) "graphic", (xmlChar*) _tmp25_);
	}
	_tmp26_ = xmlWriter;
	xmlTextWriterStartElement (_tmp26_, (xmlChar*) "bound");
	_tmp27_ = xmlWriter;
	_tmp28_ = ((ComponentDef*) self)->rightBound;
	_tmp29_ = g_strdup_printf ("%i", _tmp28_);
	_tmp30_ = _tmp29_;
	xmlTextWriterWriteAttribute (_tmp27_, (xmlChar*) "right", (xmlChar*) _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = xmlWriter;
	_tmp32_ = ((ComponentDef*) self)->downBound;
	_tmp33_ = g_strdup_printf ("%i", _tmp32_);
	_tmp34_ = _tmp33_;
	xmlTextWriterWriteAttribute (_tmp31_, (xmlChar*) "down", (xmlChar*) _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = xmlWriter;
	_tmp36_ = ((ComponentDef*) self)->leftBound;
	_tmp37_ = g_strdup_printf ("%i", _tmp36_);
	_tmp38_ = _tmp37_;
	xmlTextWriterWriteAttribute (_tmp35_, (xmlChar*) "left", (xmlChar*) _tmp38_);
	_g_free0 (_tmp38_);
	_tmp39_ = xmlWriter;
	_tmp40_ = ((ComponentDef*) self)->upBound;
	_tmp41_ = g_strdup_printf ("%i", _tmp40_);
	_tmp42_ = _tmp41_;
	xmlTextWriterWriteAttribute (_tmp39_, (xmlChar*) "up", (xmlChar*) _tmp42_);
	_g_free0 (_tmp42_);
	_tmp43_ = xmlWriter;
	xmlTextWriterEndElement (_tmp43_);
	_tmp44_ = xmlWriter;
	xmlTextWriterStartElement (_tmp44_, (xmlChar*) "colour");
	_tmp45_ = xmlWriter;
	_tmp46_ = ((ComponentDef*) self)->backgroundAlpha;
	_tmp47_ = g_strdup_printf ("%i", _tmp46_);
	_tmp48_ = _tmp47_;
	xmlTextWriterWriteAttribute (_tmp45_, (xmlChar*) "a", (xmlChar*) _tmp48_);
	_g_free0 (_tmp48_);
	_tmp49_ = xmlWriter;
	_tmp50_ = ((ComponentDef*) self)->backgroundRed;
	_tmp51_ = g_strdup_printf ("%i", _tmp50_);
	_tmp52_ = _tmp51_;
	xmlTextWriterWriteAttribute (_tmp49_, (xmlChar*) "r", (xmlChar*) _tmp52_);
	_g_free0 (_tmp52_);
	_tmp53_ = xmlWriter;
	_tmp54_ = ((ComponentDef*) self)->backgroundGreen;
	_tmp55_ = g_strdup_printf ("%i", _tmp54_);
	_tmp56_ = _tmp55_;
	xmlTextWriterWriteAttribute (_tmp53_, (xmlChar*) "g", (xmlChar*) _tmp56_);
	_g_free0 (_tmp56_);
	_tmp57_ = xmlWriter;
	_tmp58_ = ((ComponentDef*) self)->backgroundBlue;
	_tmp59_ = g_strdup_printf ("%i", _tmp58_);
	_tmp60_ = _tmp59_;
	xmlTextWriterWriteAttribute (_tmp57_, (xmlChar*) "b", (xmlChar*) _tmp60_);
	_g_free0 (_tmp60_);
	_tmp61_ = xmlWriter;
	xmlTextWriterEndElement (_tmp61_);
	_tmp62_ = stdout;
	fprintf (_tmp62_, "Saving pin data...\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				gint _tmp65_ = 0;
				PinDef** _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				PinDef** _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gint _tmp68_ = 0;
				PinDef* _tmp69_ = NULL;
				xmlTextWriter* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				if (!_tmp63_) {
					gint _tmp64_ = 0;
					_tmp64_ = i;
					i = _tmp64_ + 1;
				}
				_tmp63_ = FALSE;
				_tmp65_ = i;
				_tmp66_ = ((ComponentDef*) self)->pinDefs;
				_tmp66__length1 = ((ComponentDef*) self)->pinDefs_length1;
				if (!(_tmp65_ < _tmp66__length1)) {
					break;
				}
				_tmp67_ = ((ComponentDef*) self)->pinDefs;
				_tmp67__length1 = ((ComponentDef*) self)->pinDefs_length1;
				_tmp68_ = i;
				_tmp69_ = _tmp67_[_tmp68_];
				_tmp70_ = xmlWriter;
				_tmp71_ = i;
				pin_def_save (_tmp69_, _tmp70_, _tmp71_);
			}
		}
	}
	_tmp72_ = stdout;
	fprintf (_tmp72_, "Saving wire data...\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp73_ = FALSE;
			_tmp73_ = TRUE;
			while (TRUE) {
				gint _tmp75_ = 0;
				WireInst** _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				WireInst** _tmp77_ = NULL;
				gint _tmp77__length1 = 0;
				gint _tmp78_ = 0;
				WireInst* _tmp79_ = NULL;
				xmlTextWriter* _tmp80_ = NULL;
				if (!_tmp73_) {
					gint _tmp74_ = 0;
					_tmp74_ = i;
					i = _tmp74_ + 1;
				}
				_tmp73_ = FALSE;
				_tmp75_ = i;
				_tmp76_ = self->wireInsts;
				_tmp76__length1 = self->wireInsts_length1;
				if (!(_tmp75_ < _tmp76__length1)) {
					break;
				}
				_tmp77_ = self->wireInsts;
				_tmp77__length1 = self->wireInsts_length1;
				_tmp78_ = i;
				_tmp79_ = _tmp77_[_tmp78_];
				_tmp80_ = xmlWriter;
				wire_inst_save (_tmp79_, _tmp80_);
			}
		}
	}
	_tmp81_ = stdout;
	fprintf (_tmp81_, "Saving component data...\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp82_ = FALSE;
			_tmp82_ = TRUE;
			while (TRUE) {
				gint _tmp84_ = 0;
				ComponentInst** _tmp85_ = NULL;
				gint _tmp85__length1 = 0;
				ComponentInst** _tmp86_ = NULL;
				gint _tmp86__length1 = 0;
				gint _tmp87_ = 0;
				ComponentInst* _tmp88_ = NULL;
				xmlTextWriter* _tmp89_ = NULL;
				if (!_tmp82_) {
					gint _tmp83_ = 0;
					_tmp83_ = i;
					i = _tmp83_ + 1;
				}
				_tmp82_ = FALSE;
				_tmp84_ = i;
				_tmp85_ = self->componentInsts;
				_tmp85__length1 = self->componentInsts_length1;
				if (!(_tmp84_ < _tmp85__length1)) {
					break;
				}
				_tmp86_ = self->componentInsts;
				_tmp86__length1 = self->componentInsts_length1;
				_tmp87_ = i;
				_tmp88_ = _tmp86_[_tmp87_];
				_tmp89_ = xmlWriter;
				component_inst_save (_tmp88_, _tmp89_);
			}
		}
	}
	_tmp90_ = stdout;
	fprintf (_tmp90_, "Saving annotation data...\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp91_ = FALSE;
			_tmp91_ = TRUE;
			while (TRUE) {
				gint _tmp93_ = 0;
				Annotation** _tmp94_ = NULL;
				gint _tmp94__length1 = 0;
				Annotation** _tmp95_ = NULL;
				gint _tmp95__length1 = 0;
				gint _tmp96_ = 0;
				Annotation* _tmp97_ = NULL;
				xmlTextWriter* _tmp98_ = NULL;
				if (!_tmp91_) {
					gint _tmp92_ = 0;
					_tmp92_ = i;
					i = _tmp92_ + 1;
				}
				_tmp91_ = FALSE;
				_tmp93_ = i;
				_tmp94_ = self->annotations;
				_tmp94__length1 = self->annotations_length1;
				if (!(_tmp93_ < _tmp94__length1)) {
					break;
				}
				_tmp95_ = self->annotations;
				_tmp95__length1 = self->annotations_length1;
				_tmp96_ = i;
				_tmp97_ = _tmp95_[_tmp96_];
				_tmp98_ = xmlWriter;
				annotation_save (_tmp97_, _tmp98_);
			}
		}
	}
	_tmp99_ = xmlWriter;
	xmlTextWriterEndElement (_tmp99_);
	_tmp100_ = xmlWriter;
	xmlTextWriterEndDocument (_tmp100_);
	_tmp101_ = xmlWriter;
	xmlTextWriterFlush (_tmp101_);
	_tmp102_ = stdout;
	fprintf (_tmp102_, "Saving complete...\n");
	result = 0;
	_xmlFreeTextWriter0 (xmlWriter);
	return result;
}


/**
 * Recursive method to compile custom components. Compiles to
 * //compiledCircuit//. Compile the //componentInst// representing
 * the custom component. The high level connections are stored in
 * //connections//. The sub-components are part of the ancestry
 * //ancestry//.
 */
static void _vala_array_add42 (ComponentInst*** array, int* length, int* size, ComponentInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add43 (ComponentInst*** array, int* length, int* size, ComponentInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _wire_state_ref0 (gpointer self) {
	return self ? wire_state_ref (self) : NULL;
}


static void _vala_array_add44 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void custom_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	CustomComponentDef * self;
	WireState** localWireStates = NULL;
	WireState** _tmp0_ = NULL;
	gint localWireStates_length1 = 0;
	gint _localWireStates_size_ = 0;
	ComponentInst** newAncestry = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint newAncestry_length1 = 0;
	gint _newAncestry_size_ = 0;
	ComponentInst* _tmp2_ = NULL;
	WireInst** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	ComponentInst** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	self = (CustomComponentDef*) base;
	g_return_if_fail (compiledCircuit != NULL);
	_tmp0_ = g_new0 (WireState*, 0 + 1);
	localWireStates = _tmp0_;
	localWireStates_length1 = 0;
	_localWireStates_size_ = localWireStates_length1;
	_tmp1_ = g_new0 (ComponentInst*, 0 + 1);
	newAncestry = _tmp1_;
	newAncestry_length1 = 0;
	_newAncestry_size_ = newAncestry_length1;
	_tmp2_ = componentInst;
	if (_tmp2_ != NULL) {
		ComponentInst** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ComponentInst** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		ComponentInst* _tmp9_ = NULL;
		ComponentInst* _tmp10_ = NULL;
		_tmp3_ = ancestry;
		_tmp3__length1 = ancestry_length1;
		{
			ComponentInst** prevComponentInst_collection = NULL;
			gint prevComponentInst_collection_length1 = 0;
			gint _prevComponentInst_collection_size_ = 0;
			gint prevComponentInst_it = 0;
			prevComponentInst_collection = _tmp3_;
			prevComponentInst_collection_length1 = _tmp3__length1;
			for (prevComponentInst_it = 0; prevComponentInst_it < _tmp3__length1; prevComponentInst_it = prevComponentInst_it + 1) {
				ComponentInst* _tmp4_ = NULL;
				ComponentInst* prevComponentInst = NULL;
				_tmp4_ = _component_inst_ref0 (prevComponentInst_collection[prevComponentInst_it]);
				prevComponentInst = _tmp4_;
				{
					ComponentInst** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					ComponentInst* _tmp6_ = NULL;
					ComponentInst* _tmp7_ = NULL;
					_tmp5_ = newAncestry;
					_tmp5__length1 = newAncestry_length1;
					_tmp6_ = prevComponentInst;
					_tmp7_ = _component_inst_ref0 (_tmp6_);
					_vala_array_add42 (&newAncestry, &newAncestry_length1, &_newAncestry_size_, _tmp7_);
					_component_inst_unref0 (prevComponentInst);
				}
			}
		}
		_tmp8_ = newAncestry;
		_tmp8__length1 = newAncestry_length1;
		_tmp9_ = componentInst;
		_tmp10_ = _component_inst_ref0 (_tmp9_);
		_vala_array_add43 (&newAncestry, &newAncestry_length1, &_newAncestry_size_, _tmp10_);
	}
	_tmp11_ = self->wireInsts;
	_tmp11__length1 = self->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp11_;
		wireInst_collection_length1 = _tmp11__length1;
		for (wireInst_it = 0; wireInst_it < _tmp11__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp12_ = NULL;
			WireInst* wireInst = NULL;
			_tmp12_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp12_;
			{
				WireState* wireState = NULL;
				CompiledCircuit* _tmp13_ = NULL;
				WireInst* _tmp14_ = NULL;
				Connection** _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				ComponentInst** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				WireState* _tmp17_ = NULL;
				WireState** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				WireState* _tmp19_ = NULL;
				WireState* _tmp20_ = NULL;
				_tmp13_ = compiledCircuit;
				_tmp14_ = wireInst;
				_tmp15_ = connections;
				_tmp15__length1 = connections_length1;
				_tmp16_ = newAncestry;
				_tmp16__length1 = newAncestry_length1;
				_tmp17_ = compiled_circuit_compile_wire (_tmp13_, _tmp14_, _tmp15_, _tmp15__length1, _tmp16_, _tmp16__length1);
				wireState = _tmp17_;
				_tmp18_ = localWireStates;
				_tmp18__length1 = localWireStates_length1;
				_tmp19_ = wireState;
				_tmp20_ = _wire_state_ref0 (_tmp19_);
				_vala_array_add44 (&localWireStates, &localWireStates_length1, &_localWireStates_size_, _tmp20_);
				_wire_state_unref0 (wireState);
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	_tmp21_ = self->componentInsts;
	_tmp21__length1 = self->componentInsts_length1;
	{
		ComponentInst** childComponentInst_collection = NULL;
		gint childComponentInst_collection_length1 = 0;
		gint _childComponentInst_collection_size_ = 0;
		gint childComponentInst_it = 0;
		childComponentInst_collection = _tmp21_;
		childComponentInst_collection_length1 = _tmp21__length1;
		for (childComponentInst_it = 0; childComponentInst_it < _tmp21__length1; childComponentInst_it = childComponentInst_it + 1) {
			ComponentInst* _tmp22_ = NULL;
			ComponentInst* childComponentInst = NULL;
			_tmp22_ = _component_inst_ref0 (childComponentInst_collection[childComponentInst_it]);
			childComponentInst = _tmp22_;
			{
				ComponentInst* _tmp23_ = NULL;
				CompiledCircuit* _tmp24_ = NULL;
				WireState** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				ComponentInst** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				_tmp23_ = childComponentInst;
				_tmp24_ = compiledCircuit;
				_tmp25_ = localWireStates;
				_tmp25__length1 = localWireStates_length1;
				_tmp26_ = newAncestry;
				_tmp26__length1 = newAncestry_length1;
				component_inst_compile_component (_tmp23_, _tmp24_, _tmp25_, _tmp25__length1, _tmp26_, _tmp26__length1);
				_component_inst_unref0 (childComponentInst);
			}
		}
	}
	newAncestry = (_vala_array_free (newAncestry, newAncestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	localWireStates = (_vala_array_free (localWireStates, localWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
}


/**
 * Returns the ComponentInst at (//x//, //y//). Returns null if
 * there isn't one.
 */
ComponentInst* custom_component_def_find_inst (CustomComponentDef* self, gint x, gint y) {
	ComponentInst* result = NULL;
	ComponentInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->componentInsts;
	_tmp0__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp0_;
		componentInst_collection_length1 = _tmp0__length1;
		for (componentInst_it = 0; componentInst_it < _tmp0__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp1_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp1_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp1_;
			{
				ComponentInst* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp2_ = componentInst;
				_tmp3_ = x;
				_tmp4_ = y;
				_tmp5_ = component_inst_find (_tmp2_, _tmp3_, _tmp4_);
				if (_tmp5_ == 1) {
					result = componentInst;
					return result;
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * Returns the interface tag with the given ID. Returns null if
 * there isn't one.
 */
static gpointer _tag_ref0 (gpointer self) {
	return self ? tag_ref (self) : NULL;
}


Tag* custom_component_def_resolve_tag_id (CustomComponentDef* self, gint tagID) {
	Tag* result = NULL;
	WireInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->wireInsts;
	_tmp0__length1 = self->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp0_;
		wireInst_collection_length1 = _tmp0__length1;
		for (wireInst_it = 0; wireInst_it < _tmp0__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp1_ = NULL;
			WireInst* wireInst = NULL;
			_tmp1_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp1_;
			{
				WireInst* _tmp2_ = NULL;
				Tag* _tmp3_ = NULL;
				_tmp2_ = wireInst;
				_tmp3_ = _tmp2_->interfaceTag;
				if (_tmp3_ != NULL) {
					WireInst* _tmp4_ = NULL;
					Tag* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					_tmp4_ = wireInst;
					_tmp5_ = _tmp4_->interfaceTag;
					_tmp6_ = _tmp5_->pinid;
					_tmp7_ = tagID;
					if (_tmp6_ == _tmp7_) {
						WireInst* _tmp8_ = NULL;
						Tag* _tmp9_ = NULL;
						Tag* _tmp10_ = NULL;
						_tmp8_ = wireInst;
						_tmp9_ = _tmp8_->interfaceTag;
						_tmp10_ = _tag_ref0 (_tmp9_);
						result = _tmp10_;
						_wire_inst_unref0 (wireInst);
						return result;
					}
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * Returns the lowest unused interface tag ID in the design.
 */
gint custom_component_def_new_tag_id (CustomComponentDef* self) {
	gint result = 0;
	gint tagID = 0;
	gboolean keepGoing = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	tagID = 0;
	keepGoing = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		WireInst** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp0_ = keepGoing;
		if (!_tmp0_) {
			break;
		}
		keepGoing = FALSE;
		_tmp1_ = self->wireInsts;
		_tmp1__length1 = self->wireInsts_length1;
		{
			WireInst** wireInst_collection = NULL;
			gint wireInst_collection_length1 = 0;
			gint _wireInst_collection_size_ = 0;
			gint wireInst_it = 0;
			wireInst_collection = _tmp1_;
			wireInst_collection_length1 = _tmp1__length1;
			for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
				WireInst* _tmp2_ = NULL;
				WireInst* wireInst = NULL;
				_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
				wireInst = _tmp2_;
				{
					WireInst* _tmp3_ = NULL;
					Tag* _tmp4_ = NULL;
					_tmp3_ = wireInst;
					_tmp4_ = _tmp3_->interfaceTag;
					if (_tmp4_ != NULL) {
						WireInst* _tmp5_ = NULL;
						Tag* _tmp6_ = NULL;
						gint _tmp7_ = 0;
						gint _tmp8_ = 0;
						_tmp5_ = wireInst;
						_tmp6_ = _tmp5_->interfaceTag;
						_tmp7_ = _tmp6_->pinid;
						_tmp8_ = tagID;
						if (_tmp7_ == _tmp8_) {
							gint _tmp9_ = 0;
							keepGoing = TRUE;
							_tmp9_ = tagID;
							tagID = _tmp9_ + 1;
						}
					}
					_wire_inst_unref0 (wireInst);
				}
			}
		}
	}
	result = tagID;
	return result;
}


/**
 * Return the number of interface tags.
 */
gint custom_component_def_count_tags (CustomComponentDef* self) {
	gint result = 0;
	gint tagCount = 0;
	WireInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	tagCount = 0;
	_tmp0_ = self->wireInsts;
	_tmp0__length1 = self->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp0_;
		wireInst_collection_length1 = _tmp0__length1;
		for (wireInst_it = 0; wireInst_it < _tmp0__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp1_ = NULL;
			WireInst* wireInst = NULL;
			_tmp1_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp1_;
			{
				WireInst* _tmp2_ = NULL;
				Tag* _tmp3_ = NULL;
				_tmp2_ = wireInst;
				_tmp3_ = _tmp2_->interfaceTag;
				if (_tmp3_ != NULL) {
					gint _tmp4_ = 0;
					_tmp4_ = tagCount;
					tagCount = _tmp4_ + 1;
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	result = tagCount;
	return result;
}


static void custom_component_def_real_create_information (ComponentDef* base, CircuitInformation* circuitInformation) {
	CustomComponentDef * self;
	CircuitInformation* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (CustomComponentDef*) base;
	g_return_if_fail (circuitInformation != NULL);
	_tmp0_ = circuitInformation;
	circuit_information_count_component (_tmp0_, (ComponentDef*) self);
	_tmp1_ = self->componentInsts;
	_tmp1__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				ComponentDef* _tmp4_ = NULL;
				CircuitInformation* _tmp5_ = NULL;
				_tmp3_ = componentInst;
				_tmp4_ = _tmp3_->componentDef;
				_tmp5_ = circuitInformation;
				component_def_create_information (_tmp4_, _tmp5_);
				_component_inst_unref0 (componentInst);
			}
		}
	}
}


static gboolean _vala_component_def_array_contains (ComponentDef** stack, int stack_length, ComponentDef* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add45 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static ComponentDef** _vala_array_dup18 (ComponentDef** self, int length) {
	ComponentDef** result;
	int i;
	result = g_new0 (ComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void custom_component_def_update_immediate_dependencies (CustomComponentDef* self, gboolean includePlugins) {
	ComponentDef** newImmediateDependencies = NULL;
	ComponentDef** _tmp0_ = NULL;
	gint newImmediateDependencies_length1 = 0;
	gint _newImmediateDependencies_size_ = 0;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ComponentDef** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	ComponentDef** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (ComponentDef*, 0 + 1);
	newImmediateDependencies = _tmp0_;
	newImmediateDependencies_length1 = 0;
	_newImmediateDependencies_size_ = newImmediateDependencies_length1;
	_tmp1_ = self->componentInsts;
	_tmp1__length1 = self->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				ComponentInst* _tmp4_ = NULL;
				ComponentDef* _tmp5_ = NULL;
				_tmp4_ = componentInst;
				_tmp5_ = _tmp4_->componentDef;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_CUSTOM_COMPONENT_DEF)) {
					_tmp3_ = TRUE;
				} else {
					gboolean _tmp6_ = FALSE;
					gboolean _tmp7_ = FALSE;
					_tmp7_ = includePlugins;
					if (_tmp7_ == TRUE) {
						ComponentInst* _tmp8_ = NULL;
						ComponentDef* _tmp9_ = NULL;
						_tmp8_ = componentInst;
						_tmp9_ = _tmp8_->componentDef;
						_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_PLUGIN_COMPONENT_DEF);
					} else {
						_tmp6_ = FALSE;
					}
					_tmp3_ = _tmp6_;
				}
				if (_tmp3_) {
					ComponentDef* componentDef = NULL;
					ComponentInst* _tmp10_ = NULL;
					ComponentDef* _tmp11_ = NULL;
					ComponentDef* _tmp12_ = NULL;
					ComponentDef* _tmp13_ = NULL;
					ComponentDef** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					_tmp10_ = componentInst;
					_tmp11_ = _tmp10_->componentDef;
					_tmp12_ = _component_def_ref0 (_tmp11_);
					componentDef = _tmp12_;
					_tmp13_ = componentDef;
					_tmp14_ = self->immediateDependencies;
					_tmp14__length1 = self->immediateDependencies_length1;
					if (!_vala_component_def_array_contains (_tmp14_, _tmp14__length1, _tmp13_)) {
						ComponentDef** _tmp15_ = NULL;
						gint _tmp15__length1 = 0;
						ComponentDef* _tmp16_ = NULL;
						ComponentDef* _tmp17_ = NULL;
						_tmp15_ = newImmediateDependencies;
						_tmp15__length1 = newImmediateDependencies_length1;
						_tmp16_ = componentDef;
						_tmp17_ = _component_def_ref0 (_tmp16_);
						_vala_array_add45 (&newImmediateDependencies, &newImmediateDependencies_length1, &_newImmediateDependencies_size_, _tmp17_);
					}
					_component_def_unref0 (componentDef);
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	_tmp18_ = newImmediateDependencies;
	_tmp18__length1 = newImmediateDependencies_length1;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup18 (_tmp18_, _tmp18__length1) : ((gpointer) _tmp18_);
	_tmp19__length1 = _tmp18__length1;
	self->immediateDependencies = (_vala_array_free (self->immediateDependencies, self->immediateDependencies_length1, (GDestroyNotify) component_def_unref), NULL);
	self->immediateDependencies = _tmp19_;
	self->immediateDependencies_length1 = _tmp19__length1;
	newImmediateDependencies = (_vala_array_free (newImmediateDependencies, newImmediateDependencies_length1, (GDestroyNotify) component_def_unref), NULL);
}


static void _vala_array_add46 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static ComponentDef** _vala_array_dup19 (ComponentDef** self, int length) {
	ComponentDef** result;
	int i;
	result = g_new0 (ComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void custom_component_def_remove_immediate_dependency (CustomComponentDef* self, ComponentDef* removeComponent) {
	ComponentDef** newImmediateDependencies = NULL;
	ComponentDef** _tmp0_ = NULL;
	gint newImmediateDependencies_length1 = 0;
	gint _newImmediateDependencies_size_ = 0;
	ComponentDef** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ComponentDef** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	ComponentDef** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (removeComponent != NULL);
	_tmp0_ = g_new0 (ComponentDef*, 0 + 1);
	newImmediateDependencies = _tmp0_;
	newImmediateDependencies_length1 = 0;
	_newImmediateDependencies_size_ = newImmediateDependencies_length1;
	_tmp1_ = self->immediateDependencies;
	_tmp1__length1 = self->immediateDependencies_length1;
	{
		ComponentDef** componentDef_collection = NULL;
		gint componentDef_collection_length1 = 0;
		gint _componentDef_collection_size_ = 0;
		gint componentDef_it = 0;
		componentDef_collection = _tmp1_;
		componentDef_collection_length1 = _tmp1__length1;
		for (componentDef_it = 0; componentDef_it < _tmp1__length1; componentDef_it = componentDef_it + 1) {
			ComponentDef* _tmp2_ = NULL;
			ComponentDef* componentDef = NULL;
			_tmp2_ = _component_def_ref0 (componentDef_collection[componentDef_it]);
			componentDef = _tmp2_;
			{
				ComponentDef* _tmp3_ = NULL;
				ComponentDef* _tmp4_ = NULL;
				_tmp3_ = componentDef;
				_tmp4_ = removeComponent;
				if (_tmp3_ != _tmp4_) {
					ComponentDef** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					ComponentDef* _tmp6_ = NULL;
					ComponentDef* _tmp7_ = NULL;
					_tmp5_ = newImmediateDependencies;
					_tmp5__length1 = newImmediateDependencies_length1;
					_tmp6_ = componentDef;
					_tmp7_ = _component_def_ref0 (_tmp6_);
					_vala_array_add46 (&newImmediateDependencies, &newImmediateDependencies_length1, &_newImmediateDependencies_size_, _tmp7_);
				}
				_component_def_unref0 (componentDef);
			}
		}
	}
	_tmp8_ = newImmediateDependencies;
	_tmp8__length1 = newImmediateDependencies_length1;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup19 (_tmp8_, _tmp8__length1) : ((gpointer) _tmp8_);
	_tmp9__length1 = _tmp8__length1;
	self->immediateDependencies = (_vala_array_free (self->immediateDependencies, self->immediateDependencies_length1, (GDestroyNotify) component_def_unref), NULL);
	self->immediateDependencies = _tmp9_;
	self->immediateDependencies_length1 = _tmp9__length1;
	newImmediateDependencies = (_vala_array_free (newImmediateDependencies, newImmediateDependencies_length1, (GDestroyNotify) component_def_unref), NULL);
}


static void custom_component_def_class_init (CustomComponentDefClass * klass) {
	custom_component_def_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_DEF_CLASS (klass)->finalize = custom_component_def_finalize;
	g_type_class_add_private (klass, sizeof (CustomComponentDefPrivate));
	COMPONENT_DEF_CLASS (klass)->compile_component = custom_component_def_real_compile_component;
	COMPONENT_DEF_CLASS (klass)->create_information = custom_component_def_real_create_information;
}


static void custom_component_def_instance_init (CustomComponentDef * self) {
	self->priv = CUSTOM_COMPONENT_DEF_GET_PRIVATE (self);
}


static void custom_component_def_finalize (ComponentDef* obj) {
	CustomComponentDef * self;
	FILE* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Custom Component Destroyed\n");
	self->componentInsts = (_vala_array_free (self->componentInsts, self->componentInsts_length1, (GDestroyNotify) component_inst_unref), NULL);
	self->wireInsts = (_vala_array_free (self->wireInsts, self->wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) annotation_unref), NULL);
	self->immediateDependencies = (_vala_array_free (self->immediateDependencies, self->immediateDependencies_length1, (GDestroyNotify) component_def_unref), NULL);
	COMPONENT_DEF_CLASS (custom_component_def_parent_class)->finalize (obj);
}


/**
 * Definition of a custom component.
 * 
 * A CustomComponentDef is the design and specification of
 * a user defined component, which can be included in another component.
 */
GType custom_component_def_get_type (void) {
	static volatile gsize custom_component_def_type_id__volatile = 0;
	if (g_once_init_enter (&custom_component_def_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CustomComponentDefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) custom_component_def_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CustomComponentDef), 0, (GInstanceInitFunc) custom_component_def_instance_init, NULL };
		GType custom_component_def_type_id;
		custom_component_def_type_id = g_type_register_static (TYPE_COMPONENT_DEF, "CustomComponentDef", &g_define_type_info, 0);
		g_once_init_leave (&custom_component_def_type_id__volatile, custom_component_def_type_id);
	}
	return custom_component_def_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



