/* def-memory.c generated by valac 0.24.0, the Vala compiler
 * generated from def-memory.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentdef/def-memory.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <stdio.h>


#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;

#define TYPE_MEMORY_COMPONENT_DEF (memory_component_def_get_type ())
#define MEMORY_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEMORY_COMPONENT_DEF, MemoryComponentDef))
#define MEMORY_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEMORY_COMPONENT_DEF, MemoryComponentDefClass))
#define IS_MEMORY_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEMORY_COMPONENT_DEF))
#define IS_MEMORY_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEMORY_COMPONENT_DEF))
#define MEMORY_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEMORY_COMPONENT_DEF, MemoryComponentDefClass))

typedef struct _MemoryComponentDef MemoryComponentDef;
typedef struct _MemoryComponentDefClass MemoryComponentDefClass;
typedef struct _MemoryComponentDefPrivate MemoryComponentDefPrivate;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROPERTY_ITEM_SELECTION (property_item_selection_get_type ())
#define PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection))
#define PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))
#define IS_PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_SELECTION))
#define IS_PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_SELECTION))
#define PROPERTY_ITEM_SELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))

typedef struct _PropertyItemSelection PropertyItemSelection;
typedef struct _PropertyItemSelectionClass PropertyItemSelectionClass;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))

#define TYPE_PROPERTY_ITEM_FILE (property_item_file_get_type ())
#define PROPERTY_ITEM_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_FILE, PropertyItemFile))
#define PROPERTY_ITEM_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_FILE, PropertyItemFileClass))
#define IS_PROPERTY_ITEM_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_FILE))
#define IS_PROPERTY_ITEM_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_FILE))
#define PROPERTY_ITEM_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_FILE, PropertyItemFileClass))

typedef struct _PropertyItemFile PropertyItemFile;
typedef struct _PropertyItemFileClass PropertyItemFileClass;
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _PinInstPrivate PinInstPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
typedef struct _PinDefPrivate PinDefPrivate;

#define TYPE_FLOW (flow_get_type ())

#define PIN_DEF_TYPE_LABEL_TYPE (pin_def_label_type_get_type ())
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;

#define TYPE_MEMORY_COMPONENT_STATE (memory_component_state_get_type ())
#define MEMORY_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEMORY_COMPONENT_STATE, MemoryComponentState))
#define MEMORY_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEMORY_COMPONENT_STATE, MemoryComponentStateClass))
#define IS_MEMORY_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEMORY_COMPONENT_STATE))
#define IS_MEMORY_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEMORY_COMPONENT_STATE))
#define MEMORY_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEMORY_COMPONENT_STATE, MemoryComponentStateClass))

typedef struct _MemoryComponentState MemoryComponentState;
typedef struct _MemoryComponentStateClass MemoryComponentStateClass;
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _MemoryComponentDef {
	ComponentDef parent_instance;
	MemoryComponentDefPrivate * priv;
};

struct _MemoryComponentDefClass {
	ComponentDefClass parent_class;
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
typedef enum  {
	PROPERTY_ITEM_ERROR_ITEM_NOT_FOUND
} PropertyItemError;
#define PROPERTY_ITEM_ERROR property_item_error_quark ()
struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

typedef enum  {
	PIN_DEF_LABEL_TYPE_NONE,
	PIN_DEF_LABEL_TYPE_TEXT,
	PIN_DEF_LABEL_TYPE_TEXTBAR,
	PIN_DEF_LABEL_TYPE_CLOCK
} PinDefLabelType;

struct _PinDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinDefPrivate * priv;
	gint x;
	gint y;
	gint xLabel;
	gint yLabel;
	gint xConnect;
	gint yConnect;
	Direction direction;
	gint length;
	gboolean array;
	Flow flow;
	gint defaultArraySize;
	gint idealSpace;
	gfloat minSpace;
	gchar* label;
	gboolean required;
	gboolean userArrayResize;
	gboolean showDefault;
	PinDefLabelType labelType;
};

struct _PinDefClass {
	GTypeClass parent_class;
	void (*finalize) (PinDef *self);
};

typedef enum  {
	COMPONENT_STATE_ERROR_COMPILE
} ComponentStateError;
#define COMPONENT_STATE_ERROR component_state_error_quark ()

static gpointer memory_component_def_parent_class = NULL;

gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
GType memory_component_def_get_type (void) G_GNUC_CONST;
enum  {
	MEMORY_COMPONENT_DEF_DUMMY_PROPERTY
};
#define MEMORY_COMPONENT_DEF_infoFilename PACKAGE_DATADIR "components/info/memory.xml"
GQuark component_def_load_error_quark (void);
MemoryComponentDef* memory_component_def_new (GError** error);
MemoryComponentDef* memory_component_def_construct (GType object_type, GError** error);
ComponentDef* component_def_construct (GType object_type);
GQuark custom_component_def_load_error_quark (void);
GQuark plugin_component_def_load_error_quark (void);
void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error);
static void memory_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty);
GQuark property_item_error_quark (void);
gchar* property_item_selection_get_data_throw (PropertySet* propertySet, const gchar* name, GError** error);
GType property_item_selection_get_type (void) G_GNUC_CONST;
PropertyItemSelection* property_item_selection_new (const gchar* name, const gchar* description);
PropertyItemSelection* property_item_selection_construct (GType object_type, const gchar* name, const gchar* description);
void property_item_selection_add_option (PropertyItemSelection* self, const gchar* value, const gchar* text);
gint property_item_selection_set_option (PropertyItemSelection* self, const gchar* value);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
gchar* property_item_file_get_filename_throw (PropertySet* propertySet, const gchar* name, GError** error);
PropertyItemFile* property_item_file_new (const gchar* name, const gchar* description, const gchar* filename);
PropertyItemFile* property_item_file_construct (GType object_type, const gchar* name, const gchar* description, const gchar* filename);
GType property_item_file_get_type (void) G_GNUC_CONST;
static void memory_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
gchar* property_item_file_get_filename (PropertySet* propertySet, const gchar* name);
static void memory_component_def_real_configure_inst (ComponentDef* base, ComponentInst* componentInst, gboolean firstLoad);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
GType flow_get_type (void) G_GNUC_CONST;
GType pin_def_label_type_get_type (void) G_GNUC_CONST;
gboolean pin_inst_disconnect (PinInst* self, ComponentInst* componentInst);
void component_inst_detatch_all (ComponentInst* self);
void pin_inst_update_position (PinInst* self);
static void memory_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty);
static void memory_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
static void memory_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
Connection* connection_new_fake (void);
Connection* connection_construct_fake (GType object_type);
WireInst* connection_get_wireInst (Connection* self);
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
GType memory_component_state_get_type (void) G_GNUC_CONST;
GQuark component_state_error_quark (void);
MemoryComponentState* memory_component_state_new (Connection** addressWires, int addressWires_length1, Connection** dataWires, int dataWires_length1, Connection* selectWire, Connection* readEnableWire, Connection* writeEnableWire, Connection* clockWire, gboolean readWrite, const gchar* readFilename, const gchar* writeFilename, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
MemoryComponentState* memory_component_state_construct (GType object_type, Connection** addressWires, int addressWires_length1, Connection** dataWires, int dataWires_length1, Connection* selectWire, Connection* readEnableWire, Connection* writeEnableWire, Connection* clockWire, gboolean readWrite, const gchar* readFilename, const gchar* writeFilename, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
void compiled_circuit_add_component (CompiledCircuit* self, ComponentState* componentState);
void compiled_circuit_appendError (CompiledCircuit* self, const gchar* errorString);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


MemoryComponentDef* memory_component_def_construct (GType object_type, GError** error) {
	MemoryComponentDef* self = NULL;
	GError * _inner_error_ = NULL;
	self = (MemoryComponentDef*) component_def_construct (object_type);
	{
		component_def_load_from_file ((ComponentDef*) self, MEMORY_COMPONENT_DEF_infoFilename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		FILE* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Failed to load built in component \"%s\"\n", MEMORY_COMPONENT_DEF_infoFilename);
		_tmp1_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_LOAD, "Failed to load \"" MEMORY_COMPONENT_DEF_infoFilename "\"\n");
		_inner_error_ = _tmp1_;
		goto __finally30;
	}
	__finally30:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


MemoryComponentDef* memory_component_def_new (GError** error) {
	return memory_component_def_construct (TYPE_MEMORY_COMPONENT_DEF, error);
}


static void memory_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty) {
	MemoryComponentDef * self;
	gchar* chipType = NULL;
	gchar* readFile = NULL;
	gchar* writeFile = NULL;
	PropertyItemSelection* chipTypeSelection = NULL;
	PropertyItemSelection* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	PropertySet* _tmp7_ = NULL;
	PropertySet* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	PropertyItemFile* _tmp15_ = NULL;
	PropertyItemFile* _tmp16_ = NULL;
	PropertySet* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	PropertyItemFile* _tmp24_ = NULL;
	PropertyItemFile* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	self = (MemoryComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	g_return_if_fail (configurationProperty != NULL);
	{
		gchar* _tmp0_ = NULL;
		PropertySet* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = configurationProperty;
		_tmp2_ = property_item_selection_get_data_throw (_tmp1_, "Chip Type", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch31_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (chipType);
		chipType = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally31;
	__catch31_g_error:
	{
		gchar* _tmp4_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp4_ = g_strdup ("RAM, Chip Select, Read Enable, Write Enable, Write Clock");
		_g_free0 (chipType);
		chipType = _tmp4_;
	}
	__finally31:
	if (_inner_error_ != NULL) {
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = property_item_selection_new ("Chip Type", "Chip interface options and capabilities");
	chipTypeSelection = _tmp5_;
	property_item_selection_add_option (chipTypeSelection, "RAM, Chip Select, Read Enable, Write Enable, Write Clock", NULL);
	property_item_selection_add_option (chipTypeSelection, "ROM, Chip Select", NULL);
	_tmp6_ = chipType;
	property_item_selection_set_option (chipTypeSelection, _tmp6_);
	_tmp7_ = queryProperty;
	property_set_add_item (_tmp7_, (PropertyItem*) chipTypeSelection);
	{
		gchar* _tmp8_ = NULL;
		PropertySet* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = configurationProperty;
		_tmp10_ = property_item_file_get_filename_throw (_tmp9_, "Read File", &_inner_error_);
		_tmp8_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch32_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (readFile);
		readFile = _tmp11_;
		_g_free0 (_tmp8_);
	}
	goto __finally32;
	__catch32_g_error:
	{
		gchar* _tmp12_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp12_ = g_strdup ("");
		_g_free0 (readFile);
		readFile = _tmp12_;
	}
	__finally32:
	if (_inner_error_ != NULL) {
		_property_item_unref0 (chipTypeSelection);
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = queryProperty;
	_tmp14_ = readFile;
	_tmp15_ = property_item_file_new ("Read File", "Optional file to load initial memory from.", _tmp14_);
	_tmp16_ = _tmp15_;
	property_set_add_item (_tmp13_, (PropertyItem*) _tmp16_);
	_property_item_unref0 (_tmp16_);
	{
		gchar* _tmp17_ = NULL;
		PropertySet* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp18_ = configurationProperty;
		_tmp19_ = property_item_file_get_filename_throw (_tmp18_, "Write File", &_inner_error_);
		_tmp17_ = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch33_g_error;
		}
		_tmp20_ = _tmp17_;
		_tmp17_ = NULL;
		_g_free0 (writeFile);
		writeFile = _tmp20_;
		_g_free0 (_tmp17_);
	}
	goto __finally33;
	__catch33_g_error:
	{
		gchar* _tmp21_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp21_ = g_strdup ("");
		_g_free0 (writeFile);
		writeFile = _tmp21_;
	}
	__finally33:
	if (_inner_error_ != NULL) {
		_property_item_unref0 (chipTypeSelection);
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp22_ = queryProperty;
	_tmp23_ = writeFile;
	_tmp24_ = property_item_file_new ("Write File", "Optional file to save memory to.", _tmp23_);
	_tmp25_ = _tmp24_;
	property_set_add_item (_tmp22_, (PropertyItem*) _tmp25_);
	_property_item_unref0 (_tmp25_);
	_property_item_unref0 (chipTypeSelection);
	_g_free0 (writeFile);
	_g_free0 (readFile);
	_g_free0 (chipType);
}


static void memory_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty) {
	MemoryComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	gchar* chipType = NULL;
	gchar* readFile = NULL;
	gchar* writeFile = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PropertySet* _tmp3_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	PropertySet* _tmp12_ = NULL;
	PropertyItemSelection* selection = NULL;
	PropertyItemSelection* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	PropertySet* _tmp15_ = NULL;
	PropertySet* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	PropertySet* _tmp18_ = NULL;
	PropertyItemFile* _tmp19_ = NULL;
	PropertyItemFile* _tmp20_ = NULL;
	PropertySet* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	PropertySet* _tmp23_ = NULL;
	PropertyItemFile* _tmp24_ = NULL;
	PropertyItemFile* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	self = (MemoryComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	_tmp0_ = ((ComponentDef*) self)->name;
	_tmp1_ = g_strconcat (_tmp0_, " configuration", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = property_set_new (_tmp2_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp3_;
	_g_free0 (_tmp2_);
	{
		gchar* _tmp4_ = NULL;
		PropertySet* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp5_ = queryProperty;
		_tmp6_ = property_item_selection_get_data_throw (_tmp5_, "Chip Type", &_inner_error_);
		_tmp4_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch34_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (chipType);
		chipType = _tmp7_;
		_g_free0 (_tmp4_);
	}
	goto __finally34;
	__catch34_g_error:
	{
		gchar* _tmp8_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp8_ = g_strdup ("RAM, Chip Select, Read Enable, Write Enable, Write Clock");
		_g_free0 (chipType);
		chipType = _tmp8_;
	}
	__finally34:
	if (_inner_error_ != NULL) {
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = ((ComponentDef*) self)->name;
	_tmp10_ = g_strconcat (_tmp9_, " configuration", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = property_set_new (_tmp11_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp13_ = property_item_selection_new ("Chip Type", "");
	selection = _tmp13_;
	property_item_selection_add_option (selection, "RAM, Chip Select, Read Enable, Write Enable, Write Clock", NULL);
	property_item_selection_add_option (selection, "ROM, Chip Select", NULL);
	_tmp14_ = chipType;
	property_item_selection_set_option (selection, _tmp14_);
	_tmp15_ = _vala_configurationProperty;
	property_set_add_item (_tmp15_, (PropertyItem*) selection);
	_tmp16_ = queryProperty;
	_tmp17_ = property_item_file_get_filename (_tmp16_, "Read File");
	_g_free0 (readFile);
	readFile = _tmp17_;
	_tmp18_ = _vala_configurationProperty;
	_tmp19_ = property_item_file_new ("Read File", "", readFile);
	_tmp20_ = _tmp19_;
	property_set_add_item (_tmp18_, (PropertyItem*) _tmp20_);
	_property_item_unref0 (_tmp20_);
	_tmp21_ = queryProperty;
	_tmp22_ = property_item_file_get_filename (_tmp21_, "Write File");
	_g_free0 (writeFile);
	writeFile = _tmp22_;
	_tmp23_ = _vala_configurationProperty;
	_tmp24_ = property_item_file_new ("Write File", "", writeFile);
	_tmp25_ = _tmp24_;
	property_set_add_item (_tmp23_, (PropertyItem*) _tmp25_);
	_property_item_unref0 (_tmp25_);
	_property_item_unref0 (selection);
	_g_free0 (writeFile);
	_g_free0 (readFile);
	_g_free0 (chipType);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void memory_component_def_real_configure_inst (ComponentDef* base, ComponentInst* componentInst, gboolean firstLoad) {
	MemoryComponentDef * self;
	gchar* chipType = NULL;
	gchar* _tmp0_ = NULL;
	gint addressBound = 0;
	ComponentInst* _tmp7_ = NULL;
	PinInst** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	PinInst* _tmp9_ = NULL;
	PinDef* _tmp10_ = NULL;
	gfloat _tmp11_ = 0.0F;
	ComponentInst* _tmp12_ = NULL;
	PinInst** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	PinInst* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint dataBound = 0;
	ComponentInst* _tmp16_ = NULL;
	PinInst** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	PinInst* _tmp18_ = NULL;
	PinDef* _tmp19_ = NULL;
	gfloat _tmp20_ = 0.0F;
	ComponentInst* _tmp21_ = NULL;
	PinInst** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	PinInst* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint newBound = 0;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GQuark _tmp33_ = 0U;
	static GQuark _tmp32_label0 = 0;
	static GQuark _tmp32_label1 = 0;
	gboolean _tmp64_ = FALSE;
	ComponentInst* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	ComponentInst* _tmp70_ = NULL;
	gint _tmp71_ = 0;
	ComponentInst* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	ComponentInst* _tmp74_ = NULL;
	PinInst** _tmp75_ = NULL;
	gint _tmp75__length1 = 0;
	PinInst* _tmp76_ = NULL;
	gint* _tmp77_ = NULL;
	gint _tmp77__length1 = 0;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	ComponentInst* _tmp80_ = NULL;
	PinInst** _tmp81_ = NULL;
	gint _tmp81__length1 = 0;
	PinInst* _tmp82_ = NULL;
	ComponentInst* _tmp83_ = NULL;
	PinInst** _tmp84_ = NULL;
	gint _tmp84__length1 = 0;
	PinInst* _tmp85_ = NULL;
	gint* _tmp86_ = NULL;
	gint _tmp86__length1 = 0;
	gint _tmp87_ = 0;
	gint _tmp88_ = 0;
	ComponentInst* _tmp89_ = NULL;
	PinInst** _tmp90_ = NULL;
	gint _tmp90__length1 = 0;
	PinInst* _tmp91_ = NULL;
	ComponentInst* _tmp92_ = NULL;
	PinInst** _tmp93_ = NULL;
	gint _tmp93__length1 = 0;
	PinInst* _tmp94_ = NULL;
	gint* _tmp95_ = NULL;
	gint _tmp95__length1 = 0;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	ComponentInst* _tmp98_ = NULL;
	PinInst** _tmp99_ = NULL;
	gint _tmp99__length1 = 0;
	PinInst* _tmp100_ = NULL;
	ComponentInst* _tmp101_ = NULL;
	PinInst** _tmp102_ = NULL;
	gint _tmp102__length1 = 0;
	PinInst* _tmp103_ = NULL;
	gint* _tmp104_ = NULL;
	gint _tmp104__length1 = 0;
	gint _tmp105_ = 0;
	gint _tmp106_ = 0;
	ComponentInst* _tmp107_ = NULL;
	PinInst** _tmp108_ = NULL;
	gint _tmp108__length1 = 0;
	PinInst* _tmp109_ = NULL;
	GError * _inner_error_ = NULL;
	self = (MemoryComponentDef*) base;
	g_return_if_fail (componentInst != NULL);
	_tmp0_ = g_strdup ("RAM, Chip Select, Read Enable, Write Enable, Write Clock");
	chipType = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		ComponentInst* _tmp2_ = NULL;
		PropertySet* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = componentInst;
		_tmp3_ = _tmp2_->configuration;
		_tmp4_ = property_item_selection_get_data_throw (_tmp3_, "Chip Type", &_inner_error_);
		_tmp1_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch35_g_error;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (chipType);
		chipType = _tmp5_;
		_g_free0 (_tmp1_);
	}
	goto __finally35;
	__catch35_g_error:
	{
		gchar* _tmp6_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp6_ = g_strdup ("RAM, Chip Select, Read Enable, Write Enable, Write Clock");
		_g_free0 (chipType);
		chipType = _tmp6_;
	}
	__finally35:
	if (_inner_error_ != NULL) {
		_g_free0 (chipType);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = componentInst;
	_tmp8_ = _tmp7_->pinInsts;
	_tmp8__length1 = _tmp7_->pinInsts_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = _tmp9_->pinDef;
	_tmp11_ = _tmp10_->minSpace;
	_tmp12_ = componentInst;
	_tmp13_ = _tmp12_->pinInsts;
	_tmp13__length1 = _tmp12_->pinInsts_length1;
	_tmp14_ = _tmp13_[0];
	_tmp15_ = _tmp14_->arraySize;
	addressBound = (((gint) _tmp11_) * (1 + _tmp15_)) / 2;
	_tmp16_ = componentInst;
	_tmp17_ = _tmp16_->pinInsts;
	_tmp17__length1 = _tmp16_->pinInsts_length1;
	_tmp18_ = _tmp17_[1];
	_tmp19_ = _tmp18_->pinDef;
	_tmp20_ = _tmp19_->minSpace;
	_tmp21_ = componentInst;
	_tmp22_ = _tmp21_->pinInsts;
	_tmp22__length1 = _tmp21_->pinInsts_length1;
	_tmp23_ = _tmp22_[1];
	_tmp24_ = _tmp23_->arraySize;
	dataBound = (((gint) _tmp20_) * (1 + _tmp24_)) / 2;
	_tmp26_ = addressBound;
	_tmp27_ = dataBound;
	if (_tmp26_ > _tmp27_) {
		gint _tmp28_ = 0;
		_tmp28_ = addressBound;
		_tmp25_ = _tmp28_;
	} else {
		gint _tmp29_ = 0;
		_tmp29_ = dataBound;
		_tmp25_ = _tmp29_;
	}
	newBound = _tmp25_;
	_tmp30_ = chipType;
	_tmp31_ = _tmp30_;
	_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
	if (_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("RAM, Chip Select, Read Enable, Write Enable, Write Clock")))) {
		switch (0) {
			default:
			{
				ComponentInst* _tmp34_ = NULL;
				PinInst** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				PinInst* _tmp36_ = NULL;
				ComponentInst* _tmp37_ = NULL;
				PinInst** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				PinInst* _tmp39_ = NULL;
				ComponentInst* _tmp40_ = NULL;
				PinInst** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				PinInst* _tmp42_ = NULL;
				_tmp34_ = componentInst;
				_tmp35_ = _tmp34_->pinInsts;
				_tmp35__length1 = _tmp34_->pinInsts_length1;
				_tmp36_ = _tmp35_[3];
				_tmp36_->show = TRUE;
				_tmp37_ = componentInst;
				_tmp38_ = _tmp37_->pinInsts;
				_tmp38__length1 = _tmp37_->pinInsts_length1;
				_tmp39_ = _tmp38_[4];
				_tmp39_->show = TRUE;
				_tmp40_ = componentInst;
				_tmp41_ = _tmp40_->pinInsts;
				_tmp41__length1 = _tmp40_->pinInsts_length1;
				_tmp42_ = _tmp41_[5];
				_tmp42_->show = TRUE;
				break;
			}
		}
	} else if (_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("ROM, Chip Select")))) {
		switch (0) {
			default:
			{
				ComponentInst* _tmp43_ = NULL;
				PinInst** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				PinInst* _tmp45_ = NULL;
				ComponentInst* _tmp46_ = NULL;
				PinInst** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				PinInst* _tmp48_ = NULL;
				ComponentInst* _tmp49_ = NULL;
				PinInst** _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				PinInst* _tmp51_ = NULL;
				ComponentInst* _tmp52_ = NULL;
				PinInst** _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				PinInst* _tmp54_ = NULL;
				ComponentInst* _tmp55_ = NULL;
				ComponentInst* _tmp56_ = NULL;
				PinInst** _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
				PinInst* _tmp58_ = NULL;
				ComponentInst* _tmp59_ = NULL;
				ComponentInst* _tmp60_ = NULL;
				PinInst** _tmp61_ = NULL;
				gint _tmp61__length1 = 0;
				PinInst* _tmp62_ = NULL;
				ComponentInst* _tmp63_ = NULL;
				_tmp43_ = componentInst;
				_tmp44_ = _tmp43_->pinInsts;
				_tmp44__length1 = _tmp43_->pinInsts_length1;
				_tmp45_ = _tmp44_[3];
				_tmp45_->show = FALSE;
				_tmp46_ = componentInst;
				_tmp47_ = _tmp46_->pinInsts;
				_tmp47__length1 = _tmp46_->pinInsts_length1;
				_tmp48_ = _tmp47_[4];
				_tmp48_->show = FALSE;
				_tmp49_ = componentInst;
				_tmp50_ = _tmp49_->pinInsts;
				_tmp50__length1 = _tmp49_->pinInsts_length1;
				_tmp51_ = _tmp50_[5];
				_tmp51_->show = FALSE;
				_tmp52_ = componentInst;
				_tmp53_ = _tmp52_->pinInsts;
				_tmp53__length1 = _tmp52_->pinInsts_length1;
				_tmp54_ = _tmp53_[3];
				_tmp55_ = componentInst;
				pin_inst_disconnect (_tmp54_, _tmp55_);
				_tmp56_ = componentInst;
				_tmp57_ = _tmp56_->pinInsts;
				_tmp57__length1 = _tmp56_->pinInsts_length1;
				_tmp58_ = _tmp57_[4];
				_tmp59_ = componentInst;
				pin_inst_disconnect (_tmp58_, _tmp59_);
				_tmp60_ = componentInst;
				_tmp61_ = _tmp60_->pinInsts;
				_tmp61__length1 = _tmp60_->pinInsts_length1;
				_tmp62_ = _tmp61_[5];
				_tmp63_ = componentInst;
				pin_inst_disconnect (_tmp62_, _tmp63_);
				break;
			}
		}
	}
	_tmp65_ = componentInst;
	_tmp66_ = _tmp65_->downBound;
	_tmp67_ = newBound;
	if (_tmp66_ != _tmp67_) {
		gboolean _tmp68_ = FALSE;
		_tmp68_ = firstLoad;
		_tmp64_ = !_tmp68_;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		ComponentInst* _tmp69_ = NULL;
		_tmp69_ = componentInst;
		component_inst_detatch_all (_tmp69_);
	}
	_tmp70_ = componentInst;
	_tmp71_ = newBound;
	_tmp70_->downBound = _tmp71_;
	_tmp72_ = componentInst;
	_tmp73_ = newBound;
	_tmp72_->upBound = -_tmp73_;
	_tmp74_ = componentInst;
	_tmp75_ = _tmp74_->pinInsts;
	_tmp75__length1 = _tmp74_->pinInsts_length1;
	_tmp76_ = _tmp75_[2];
	_tmp77_ = _tmp76_->y;
	_tmp77__length1 = _tmp76_->y_length1;
	_tmp78_ = newBound;
	_tmp77_[0] = -_tmp78_;
	_tmp79_ = _tmp77_[0];
	_tmp80_ = componentInst;
	_tmp81_ = _tmp80_->pinInsts;
	_tmp81__length1 = _tmp80_->pinInsts_length1;
	_tmp82_ = _tmp81_[2];
	pin_inst_update_position (_tmp82_);
	_tmp83_ = componentInst;
	_tmp84_ = _tmp83_->pinInsts;
	_tmp84__length1 = _tmp83_->pinInsts_length1;
	_tmp85_ = _tmp84_[3];
	_tmp86_ = _tmp85_->y;
	_tmp86__length1 = _tmp85_->y_length1;
	_tmp87_ = newBound;
	_tmp86_[0] = _tmp87_;
	_tmp88_ = _tmp86_[0];
	_tmp89_ = componentInst;
	_tmp90_ = _tmp89_->pinInsts;
	_tmp90__length1 = _tmp89_->pinInsts_length1;
	_tmp91_ = _tmp90_[3];
	pin_inst_update_position (_tmp91_);
	_tmp92_ = componentInst;
	_tmp93_ = _tmp92_->pinInsts;
	_tmp93__length1 = _tmp92_->pinInsts_length1;
	_tmp94_ = _tmp93_[4];
	_tmp95_ = _tmp94_->y;
	_tmp95__length1 = _tmp94_->y_length1;
	_tmp96_ = newBound;
	_tmp95_[0] = _tmp96_;
	_tmp97_ = _tmp95_[0];
	_tmp98_ = componentInst;
	_tmp99_ = _tmp98_->pinInsts;
	_tmp99__length1 = _tmp98_->pinInsts_length1;
	_tmp100_ = _tmp99_[4];
	pin_inst_update_position (_tmp100_);
	_tmp101_ = componentInst;
	_tmp102_ = _tmp101_->pinInsts;
	_tmp102__length1 = _tmp101_->pinInsts_length1;
	_tmp103_ = _tmp102_[5];
	_tmp104_ = _tmp103_->y;
	_tmp104__length1 = _tmp103_->y_length1;
	_tmp105_ = newBound;
	_tmp104_[0] = _tmp105_;
	_tmp106_ = _tmp104_[0];
	_tmp107_ = componentInst;
	_tmp108_ = _tmp107_->pinInsts;
	_tmp108__length1 = _tmp107_->pinInsts_length1;
	_tmp109_ = _tmp108_[5];
	pin_inst_update_position (_tmp109_);
	_g_free0 (chipType);
}


static void memory_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty) {
	MemoryComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	gchar* chipTypeAttr = NULL;
	gchar* _tmp0_ = NULL;
	gchar* readFile = NULL;
	gchar* _tmp1_ = NULL;
	gchar* writeFile = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PropertySet* _tmp6_ = NULL;
	PropertyItemSelection* selection = NULL;
	PropertyItemSelection* _tmp30_ = NULL;
	PropertyItemSelection* _tmp31_ = NULL;
	PropertyItemSelection* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GQuark _tmp36_ = 0U;
	static GQuark _tmp35_label0 = 0;
	static GQuark _tmp35_label1 = 0;
	PropertySet* _tmp39_ = NULL;
	PropertyItemSelection* _tmp40_ = NULL;
	PropertySet* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	PropertyItemFile* _tmp43_ = NULL;
	PropertyItemFile* _tmp44_ = NULL;
	PropertySet* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	PropertyItemFile* _tmp47_ = NULL;
	PropertyItemFile* _tmp48_ = NULL;
	self = (MemoryComponentDef*) base;
	_tmp0_ = g_strdup ("");
	chipTypeAttr = _tmp0_;
	_tmp1_ = g_strdup ("");
	readFile = _tmp1_;
	_tmp2_ = g_strdup ("");
	writeFile = _tmp2_;
	_tmp3_ = ((ComponentDef*) self)->name;
	_tmp4_ = g_strconcat (_tmp3_, " configuration", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = property_set_new (_tmp5_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp6_;
	_g_free0 (_tmp5_);
	{
		xmlAttr* xmlattr = NULL;
		xmlNode* _tmp7_ = NULL;
		xmlAttr* _tmp8_ = NULL;
		_tmp7_ = xmlnode;
		_tmp8_ = _tmp7_->properties;
		xmlattr = _tmp8_;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp12_ = NULL;
				xmlAttr* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				GQuark _tmp17_ = 0U;
				static GQuark _tmp16_label0 = 0;
				static GQuark _tmp16_label1 = 0;
				static GQuark _tmp16_label2 = 0;
				if (!_tmp9_) {
					xmlAttr* _tmp10_ = NULL;
					xmlAttr* _tmp11_ = NULL;
					_tmp10_ = xmlattr;
					_tmp11_ = _tmp10_->next;
					xmlattr = _tmp11_;
				}
				_tmp9_ = FALSE;
				_tmp12_ = xmlattr;
				if (!(_tmp12_ != NULL)) {
					break;
				}
				_tmp13_ = xmlattr;
				_tmp14_ = _tmp13_->name;
				_tmp15_ = _tmp14_;
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("type")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp18_ = NULL;
							xmlNode* _tmp19_ = NULL;
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							_tmp18_ = xmlattr;
							_tmp19_ = _tmp18_->children;
							_tmp20_ = _tmp19_->content;
							_tmp21_ = g_strdup (_tmp20_);
							_g_free0 (chipTypeAttr);
							chipTypeAttr = _tmp21_;
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("read")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp22_ = NULL;
							xmlNode* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
							gchar* _tmp25_ = NULL;
							_tmp22_ = xmlattr;
							_tmp23_ = _tmp22_->children;
							_tmp24_ = _tmp23_->content;
							_tmp25_ = g_strdup (_tmp24_);
							_g_free0 (readFile);
							readFile = _tmp25_;
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label2) ? _tmp16_label2 : (_tmp16_label2 = g_quark_from_static_string ("write")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp26_ = NULL;
							xmlNode* _tmp27_ = NULL;
							const gchar* _tmp28_ = NULL;
							gchar* _tmp29_ = NULL;
							_tmp26_ = xmlattr;
							_tmp27_ = _tmp26_->children;
							_tmp28_ = _tmp27_->content;
							_tmp29_ = g_strdup (_tmp28_);
							_g_free0 (writeFile);
							writeFile = _tmp29_;
							break;
						}
					}
				}
			}
		}
	}
	_tmp30_ = property_item_selection_new ("Chip Type", "");
	selection = _tmp30_;
	_tmp31_ = selection;
	property_item_selection_add_option (_tmp31_, "RAM, Chip Select, Read Enable, Write Enable, Write Clock", NULL);
	_tmp32_ = selection;
	property_item_selection_add_option (_tmp32_, "ROM, Chip Select", NULL);
	_tmp33_ = chipTypeAttr;
	_tmp34_ = _tmp33_;
	_tmp36_ = (NULL == _tmp34_) ? 0 : g_quark_from_string (_tmp34_);
	if (_tmp36_ == ((0 != _tmp35_label0) ? _tmp35_label0 : (_tmp35_label0 = g_quark_from_static_string ("RAM-CS-RE-WE-CLK")))) {
		switch (0) {
			default:
			{
				PropertyItemSelection* _tmp37_ = NULL;
				_tmp37_ = selection;
				property_item_selection_set_option (_tmp37_, "RAM, Chip Select, Read Enable, Write Enable, Write Clock");
				break;
			}
		}
	} else if (_tmp36_ == ((0 != _tmp35_label1) ? _tmp35_label1 : (_tmp35_label1 = g_quark_from_static_string ("ROM-CS")))) {
		switch (0) {
			default:
			{
				PropertyItemSelection* _tmp38_ = NULL;
				_tmp38_ = selection;
				property_item_selection_set_option (_tmp38_, "ROM, Chip Select");
				break;
			}
		}
	}
	_tmp39_ = _vala_configurationProperty;
	_tmp40_ = selection;
	property_set_add_item (_tmp39_, (PropertyItem*) _tmp40_);
	_tmp41_ = _vala_configurationProperty;
	_tmp42_ = readFile;
	_tmp43_ = property_item_file_new ("Read File", "", _tmp42_);
	_tmp44_ = _tmp43_;
	property_set_add_item (_tmp41_, (PropertyItem*) _tmp44_);
	_property_item_unref0 (_tmp44_);
	_tmp45_ = _vala_configurationProperty;
	_tmp46_ = writeFile;
	_tmp47_ = property_item_file_new ("Write File", "", _tmp46_);
	_tmp48_ = _tmp47_;
	property_set_add_item (_tmp45_, (PropertyItem*) _tmp48_);
	_property_item_unref0 (_tmp48_);
	_property_item_unref0 (selection);
	_g_free0 (writeFile);
	_g_free0 (readFile);
	_g_free0 (chipTypeAttr);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void memory_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty) {
	MemoryComponentDef * self;
	gchar* chipType = NULL;
	gchar* chipTypeAttr = NULL;
	gchar* readFile = NULL;
	gchar* writeFile = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	xmlTextWriter* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	PropertySet* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	PropertySet* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	self = (MemoryComponentDef*) base;
	g_return_if_fail (xmlWriter != NULL);
	g_return_if_fail (configurationProperty != NULL);
	{
		gchar* _tmp0_ = NULL;
		PropertySet* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = configurationProperty;
		_tmp2_ = property_item_selection_get_data_throw (_tmp1_, "Chip Type", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch36_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (chipType);
		chipType = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally36;
	__catch36_g_error:
	{
		gchar* _tmp4_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp4_ = g_strdup ("RAM, Chip Select, Read Enable, Write Enable, Write Clock");
		_g_free0 (chipType);
		chipType = _tmp4_;
	}
	__finally36:
	if (_inner_error_ != NULL) {
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipTypeAttr);
		_g_free0 (chipType);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = chipType;
	_tmp6_ = _tmp5_;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("ROM, Chip Select")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_ = NULL;
				_tmp9_ = g_strdup ("ROM-CS");
				_g_free0 (chipTypeAttr);
				chipTypeAttr = _tmp9_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp10_ = NULL;
				_tmp10_ = g_strdup ("RAM-CS-RE-WE-CLK");
				_g_free0 (chipTypeAttr);
				chipTypeAttr = _tmp10_;
				break;
			}
		}
	}
	_tmp11_ = xmlWriter;
	_tmp12_ = chipTypeAttr;
	xmlTextWriterWriteAttribute (_tmp11_, (xmlChar*) "type", (xmlChar*) _tmp12_);
	_tmp13_ = configurationProperty;
	_tmp14_ = property_item_file_get_filename (_tmp13_, "Read File");
	_g_free0 (readFile);
	readFile = _tmp14_;
	_tmp15_ = configurationProperty;
	_tmp16_ = property_item_file_get_filename (_tmp15_, "Write File");
	_g_free0 (writeFile);
	writeFile = _tmp16_;
	_tmp17_ = readFile;
	if (g_strcmp0 (_tmp17_, "") != 0) {
		xmlTextWriter* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp18_ = xmlWriter;
		_tmp19_ = readFile;
		xmlTextWriterWriteAttribute (_tmp18_, (xmlChar*) "read", (xmlChar*) _tmp19_);
	}
	_tmp20_ = writeFile;
	if (g_strcmp0 (_tmp20_, "") != 0) {
		xmlTextWriter* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp21_ = xmlWriter;
		_tmp22_ = writeFile;
		xmlTextWriterWriteAttribute (_tmp21_, (xmlChar*) "write", (xmlChar*) _tmp22_);
	}
	_g_free0 (writeFile);
	_g_free0 (readFile);
	_g_free0 (chipTypeAttr);
	_g_free0 (chipType);
}


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


static void memory_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	MemoryComponentDef * self;
	Connection** addressWires = NULL;
	ComponentInst* _tmp0_ = NULL;
	PinInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PinInst* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Connection** _tmp4_ = NULL;
	gint addressWires_length1 = 0;
	gint _addressWires_size_ = 0;
	Connection** dataWires = NULL;
	ComponentInst* _tmp5_ = NULL;
	PinInst** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	PinInst* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Connection** _tmp9_ = NULL;
	gint dataWires_length1 = 0;
	gint _dataWires_size_ = 0;
	Connection* selectWire = NULL;
	Connection* _tmp10_ = NULL;
	Connection* readEnableWire = NULL;
	Connection* _tmp11_ = NULL;
	Connection* writeEnableWire = NULL;
	Connection* _tmp12_ = NULL;
	Connection* clockWire = NULL;
	Connection* _tmp13_ = NULL;
	gchar* chipType = NULL;
	gchar* readFile = NULL;
	gchar* writeFile = NULL;
	gboolean readWrite = FALSE;
	Connection** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp120_ = NULL;
	const gchar* _tmp121_ = NULL;
	GQuark _tmp123_ = 0U;
	static GQuark _tmp122_label0 = 0;
	ComponentState* componentState = NULL;
	GError * _inner_error_ = NULL;
	self = (MemoryComponentDef*) base;
	g_return_if_fail (compiledCircuit != NULL);
	_tmp0_ = componentInst;
	_tmp1_ = _tmp0_->pinInsts;
	_tmp1__length1 = _tmp0_->pinInsts_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = _tmp2_->arraySize;
	_tmp4_ = g_new0 (Connection*, _tmp3_ + 1);
	addressWires = _tmp4_;
	addressWires_length1 = _tmp3_;
	_addressWires_size_ = addressWires_length1;
	_tmp5_ = componentInst;
	_tmp6_ = _tmp5_->pinInsts;
	_tmp6__length1 = _tmp5_->pinInsts_length1;
	_tmp7_ = _tmp6_[1];
	_tmp8_ = _tmp7_->arraySize;
	_tmp9_ = g_new0 (Connection*, _tmp8_ + 1);
	dataWires = _tmp9_;
	dataWires_length1 = _tmp8_;
	_dataWires_size_ = dataWires_length1;
	_tmp10_ = connection_new_fake ();
	selectWire = _tmp10_;
	_tmp11_ = connection_new_fake ();
	readEnableWire = _tmp11_;
	_tmp12_ = connection_new_fake ();
	writeEnableWire = _tmp12_;
	_tmp13_ = connection_new_fake ();
	clockWire = _tmp13_;
	_tmp14_ = connections;
	_tmp14__length1 = connections_length1;
	{
		Connection** connection_collection = NULL;
		gint connection_collection_length1 = 0;
		gint _connection_collection_size_ = 0;
		gint connection_it = 0;
		connection_collection = _tmp14_;
		connection_collection_length1 = _tmp14__length1;
		for (connection_it = 0; connection_it < _tmp14__length1; connection_it = connection_it + 1) {
			Connection* _tmp15_ = NULL;
			Connection* connection = NULL;
			_tmp15_ = _connection_ref0 (connection_collection[connection_it]);
			connection = _tmp15_;
			{
				Connection* _tmp62_ = NULL;
				WireInst* _tmp63_ = NULL;
				WireInst* _tmp64_ = NULL;
				ComponentInst* _tmp65_ = NULL;
				PinInst** _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				PinInst* _tmp67_ = NULL;
				WireInst** _tmp68_ = NULL;
				gint _tmp68__length1 = 0;
				WireInst* _tmp69_ = NULL;
				Connection* _tmp72_ = NULL;
				WireInst* _tmp73_ = NULL;
				WireInst* _tmp74_ = NULL;
				ComponentInst* _tmp75_ = NULL;
				PinInst** _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				PinInst* _tmp77_ = NULL;
				WireInst** _tmp78_ = NULL;
				gint _tmp78__length1 = 0;
				WireInst* _tmp79_ = NULL;
				Connection* _tmp82_ = NULL;
				WireInst* _tmp83_ = NULL;
				WireInst* _tmp84_ = NULL;
				ComponentInst* _tmp85_ = NULL;
				PinInst** _tmp86_ = NULL;
				gint _tmp86__length1 = 0;
				PinInst* _tmp87_ = NULL;
				WireInst** _tmp88_ = NULL;
				gint _tmp88__length1 = 0;
				WireInst* _tmp89_ = NULL;
				Connection* _tmp92_ = NULL;
				WireInst* _tmp93_ = NULL;
				WireInst* _tmp94_ = NULL;
				ComponentInst* _tmp95_ = NULL;
				PinInst** _tmp96_ = NULL;
				gint _tmp96__length1 = 0;
				PinInst* _tmp97_ = NULL;
				WireInst** _tmp98_ = NULL;
				gint _tmp98__length1 = 0;
				WireInst* _tmp99_ = NULL;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp18_ = 0;
							ComponentInst* _tmp19_ = NULL;
							PinInst** _tmp20_ = NULL;
							gint _tmp20__length1 = 0;
							PinInst* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							WireInst* wireInst = NULL;
							ComponentInst* _tmp23_ = NULL;
							PinInst** _tmp24_ = NULL;
							gint _tmp24__length1 = 0;
							PinInst* _tmp25_ = NULL;
							WireInst** _tmp26_ = NULL;
							gint _tmp26__length1 = 0;
							gint _tmp27_ = 0;
							WireInst* _tmp28_ = NULL;
							WireInst* _tmp29_ = NULL;
							Connection* _tmp30_ = NULL;
							WireInst* _tmp31_ = NULL;
							WireInst* _tmp32_ = NULL;
							WireInst* _tmp33_ = NULL;
							if (!_tmp16_) {
								gint _tmp17_ = 0;
								_tmp17_ = i;
								i = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp18_ = i;
							_tmp19_ = componentInst;
							_tmp20_ = _tmp19_->pinInsts;
							_tmp20__length1 = _tmp19_->pinInsts_length1;
							_tmp21_ = _tmp20_[0];
							_tmp22_ = _tmp21_->arraySize;
							if (!(_tmp18_ < _tmp22_)) {
								break;
							}
							_tmp23_ = componentInst;
							_tmp24_ = _tmp23_->pinInsts;
							_tmp24__length1 = _tmp23_->pinInsts_length1;
							_tmp25_ = _tmp24_[0];
							_tmp26_ = _tmp25_->wireInsts;
							_tmp26__length1 = _tmp25_->wireInsts_length1;
							_tmp27_ = i;
							_tmp28_ = _tmp26_[_tmp27_];
							_tmp29_ = _wire_inst_ref0 (_tmp28_);
							wireInst = _tmp29_;
							_tmp30_ = connection;
							_tmp31_ = connection_get_wireInst (_tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = wireInst;
							if (_tmp32_ == _tmp33_) {
								Connection** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								gint _tmp35_ = 0;
								Connection* _tmp36_ = NULL;
								Connection* _tmp37_ = NULL;
								Connection* _tmp38_ = NULL;
								_tmp34_ = addressWires;
								_tmp34__length1 = addressWires_length1;
								_tmp35_ = i;
								_tmp36_ = connection;
								_tmp37_ = _connection_ref0 (_tmp36_);
								_connection_unref0 (_tmp34_[_tmp35_]);
								_tmp34_[_tmp35_] = _tmp37_;
								_tmp38_ = _tmp34_[_tmp35_];
							}
							_wire_inst_unref0 (wireInst);
						}
					}
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp39_ = FALSE;
						_tmp39_ = TRUE;
						while (TRUE) {
							gint _tmp41_ = 0;
							ComponentInst* _tmp42_ = NULL;
							PinInst** _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							PinInst* _tmp44_ = NULL;
							gint _tmp45_ = 0;
							WireInst* wireInst = NULL;
							ComponentInst* _tmp46_ = NULL;
							PinInst** _tmp47_ = NULL;
							gint _tmp47__length1 = 0;
							PinInst* _tmp48_ = NULL;
							WireInst** _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							gint _tmp50_ = 0;
							WireInst* _tmp51_ = NULL;
							WireInst* _tmp52_ = NULL;
							Connection* _tmp53_ = NULL;
							WireInst* _tmp54_ = NULL;
							WireInst* _tmp55_ = NULL;
							WireInst* _tmp56_ = NULL;
							if (!_tmp39_) {
								gint _tmp40_ = 0;
								_tmp40_ = i;
								i = _tmp40_ + 1;
							}
							_tmp39_ = FALSE;
							_tmp41_ = i;
							_tmp42_ = componentInst;
							_tmp43_ = _tmp42_->pinInsts;
							_tmp43__length1 = _tmp42_->pinInsts_length1;
							_tmp44_ = _tmp43_[1];
							_tmp45_ = _tmp44_->arraySize;
							if (!(_tmp41_ < _tmp45_)) {
								break;
							}
							_tmp46_ = componentInst;
							_tmp47_ = _tmp46_->pinInsts;
							_tmp47__length1 = _tmp46_->pinInsts_length1;
							_tmp48_ = _tmp47_[1];
							_tmp49_ = _tmp48_->wireInsts;
							_tmp49__length1 = _tmp48_->wireInsts_length1;
							_tmp50_ = i;
							_tmp51_ = _tmp49_[_tmp50_];
							_tmp52_ = _wire_inst_ref0 (_tmp51_);
							wireInst = _tmp52_;
							_tmp53_ = connection;
							_tmp54_ = connection_get_wireInst (_tmp53_);
							_tmp55_ = _tmp54_;
							_tmp56_ = wireInst;
							if (_tmp55_ == _tmp56_) {
								Connection** _tmp57_ = NULL;
								gint _tmp57__length1 = 0;
								gint _tmp58_ = 0;
								Connection* _tmp59_ = NULL;
								Connection* _tmp60_ = NULL;
								Connection* _tmp61_ = NULL;
								_tmp57_ = dataWires;
								_tmp57__length1 = dataWires_length1;
								_tmp58_ = i;
								_tmp59_ = connection;
								_tmp60_ = _connection_ref0 (_tmp59_);
								_connection_unref0 (_tmp57_[_tmp58_]);
								_tmp57_[_tmp58_] = _tmp60_;
								_tmp61_ = _tmp57_[_tmp58_];
							}
							_wire_inst_unref0 (wireInst);
						}
					}
				}
				_tmp62_ = connection;
				_tmp63_ = connection_get_wireInst (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = componentInst;
				_tmp66_ = _tmp65_->pinInsts;
				_tmp66__length1 = _tmp65_->pinInsts_length1;
				_tmp67_ = _tmp66_[2];
				_tmp68_ = _tmp67_->wireInsts;
				_tmp68__length1 = _tmp67_->wireInsts_length1;
				_tmp69_ = _tmp68_[0];
				if (_tmp64_ == _tmp69_) {
					Connection* _tmp70_ = NULL;
					Connection* _tmp71_ = NULL;
					_tmp70_ = connection;
					_tmp71_ = _connection_ref0 (_tmp70_);
					_connection_unref0 (selectWire);
					selectWire = _tmp71_;
				}
				_tmp72_ = connection;
				_tmp73_ = connection_get_wireInst (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = componentInst;
				_tmp76_ = _tmp75_->pinInsts;
				_tmp76__length1 = _tmp75_->pinInsts_length1;
				_tmp77_ = _tmp76_[3];
				_tmp78_ = _tmp77_->wireInsts;
				_tmp78__length1 = _tmp77_->wireInsts_length1;
				_tmp79_ = _tmp78_[0];
				if (_tmp74_ == _tmp79_) {
					Connection* _tmp80_ = NULL;
					Connection* _tmp81_ = NULL;
					_tmp80_ = connection;
					_tmp81_ = _connection_ref0 (_tmp80_);
					_connection_unref0 (readEnableWire);
					readEnableWire = _tmp81_;
				}
				_tmp82_ = connection;
				_tmp83_ = connection_get_wireInst (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = componentInst;
				_tmp86_ = _tmp85_->pinInsts;
				_tmp86__length1 = _tmp85_->pinInsts_length1;
				_tmp87_ = _tmp86_[4];
				_tmp88_ = _tmp87_->wireInsts;
				_tmp88__length1 = _tmp87_->wireInsts_length1;
				_tmp89_ = _tmp88_[0];
				if (_tmp84_ == _tmp89_) {
					Connection* _tmp90_ = NULL;
					Connection* _tmp91_ = NULL;
					_tmp90_ = connection;
					_tmp91_ = _connection_ref0 (_tmp90_);
					_connection_unref0 (writeEnableWire);
					writeEnableWire = _tmp91_;
				}
				_tmp92_ = connection;
				_tmp93_ = connection_get_wireInst (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = componentInst;
				_tmp96_ = _tmp95_->pinInsts;
				_tmp96__length1 = _tmp95_->pinInsts_length1;
				_tmp97_ = _tmp96_[5];
				_tmp98_ = _tmp97_->wireInsts;
				_tmp98__length1 = _tmp97_->wireInsts_length1;
				_tmp99_ = _tmp98_[0];
				if (_tmp94_ == _tmp99_) {
					Connection* _tmp100_ = NULL;
					Connection* _tmp101_ = NULL;
					_tmp100_ = connection;
					_tmp101_ = _connection_ref0 (_tmp100_);
					_connection_unref0 (clockWire);
					clockWire = _tmp101_;
				}
				_connection_unref0 (connection);
			}
		}
	}
	{
		gchar* _tmp102_ = NULL;
		ComponentInst* _tmp103_ = NULL;
		PropertySet* _tmp104_ = NULL;
		gchar* _tmp105_ = NULL;
		gchar* _tmp106_ = NULL;
		_tmp103_ = componentInst;
		_tmp104_ = _tmp103_->configuration;
		_tmp105_ = property_item_selection_get_data_throw (_tmp104_, "Chip Type", &_inner_error_);
		_tmp102_ = _tmp105_;
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
		_tmp106_ = _tmp102_;
		_tmp102_ = NULL;
		_g_free0 (chipType);
		chipType = _tmp106_;
		_g_free0 (_tmp102_);
	}
	goto __finally37;
	__catch37_g_error:
	{
		gchar* _tmp107_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp107_ = g_strdup ("RAM, Chip Select, Read Enable, Write Enable, Write Clock");
		_g_free0 (chipType);
		chipType = _tmp107_;
	}
	__finally37:
	if (_inner_error_ != NULL) {
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		_connection_unref0 (clockWire);
		_connection_unref0 (writeEnableWire);
		_connection_unref0 (readEnableWire);
		_connection_unref0 (selectWire);
		dataWires = (_vala_array_free (dataWires, dataWires_length1, (GDestroyNotify) connection_unref), NULL);
		addressWires = (_vala_array_free (addressWires, addressWires_length1, (GDestroyNotify) connection_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp108_ = NULL;
		ComponentInst* _tmp109_ = NULL;
		PropertySet* _tmp110_ = NULL;
		gchar* _tmp111_ = NULL;
		gchar* _tmp112_ = NULL;
		_tmp109_ = componentInst;
		_tmp110_ = _tmp109_->configuration;
		_tmp111_ = property_item_file_get_filename_throw (_tmp110_, "Read File", &_inner_error_);
		_tmp108_ = _tmp111_;
		if (_inner_error_ != NULL) {
			goto __catch38_g_error;
		}
		_tmp112_ = _tmp108_;
		_tmp108_ = NULL;
		_g_free0 (readFile);
		readFile = _tmp112_;
		_g_free0 (_tmp108_);
	}
	goto __finally38;
	__catch38_g_error:
	{
		gchar* _tmp113_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp113_ = g_strdup ("");
		_g_free0 (readFile);
		readFile = _tmp113_;
	}
	__finally38:
	if (_inner_error_ != NULL) {
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		_connection_unref0 (clockWire);
		_connection_unref0 (writeEnableWire);
		_connection_unref0 (readEnableWire);
		_connection_unref0 (selectWire);
		dataWires = (_vala_array_free (dataWires, dataWires_length1, (GDestroyNotify) connection_unref), NULL);
		addressWires = (_vala_array_free (addressWires, addressWires_length1, (GDestroyNotify) connection_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp114_ = NULL;
		ComponentInst* _tmp115_ = NULL;
		PropertySet* _tmp116_ = NULL;
		gchar* _tmp117_ = NULL;
		gchar* _tmp118_ = NULL;
		_tmp115_ = componentInst;
		_tmp116_ = _tmp115_->configuration;
		_tmp117_ = property_item_file_get_filename_throw (_tmp116_, "Write File", &_inner_error_);
		_tmp114_ = _tmp117_;
		if (_inner_error_ != NULL) {
			goto __catch39_g_error;
		}
		_tmp118_ = _tmp114_;
		_tmp114_ = NULL;
		_g_free0 (writeFile);
		writeFile = _tmp118_;
		_g_free0 (_tmp114_);
	}
	goto __finally39;
	__catch39_g_error:
	{
		gchar* _tmp119_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp119_ = g_strdup ("");
		_g_free0 (writeFile);
		writeFile = _tmp119_;
	}
	__finally39:
	if (_inner_error_ != NULL) {
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		_connection_unref0 (clockWire);
		_connection_unref0 (writeEnableWire);
		_connection_unref0 (readEnableWire);
		_connection_unref0 (selectWire);
		dataWires = (_vala_array_free (dataWires, dataWires_length1, (GDestroyNotify) connection_unref), NULL);
		addressWires = (_vala_array_free (addressWires, addressWires_length1, (GDestroyNotify) connection_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp120_ = chipType;
	_tmp121_ = _tmp120_;
	_tmp123_ = (NULL == _tmp121_) ? 0 : g_quark_from_string (_tmp121_);
	if (_tmp123_ == ((0 != _tmp122_label0) ? _tmp122_label0 : (_tmp122_label0 = g_quark_from_static_string ("ROM, Chip Select")))) {
		switch (0) {
			default:
			{
				readWrite = FALSE;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				readWrite = TRUE;
				break;
			}
		}
	}
	componentState = NULL;
	{
		MemoryComponentState* _tmp124_ = NULL;
		Connection** _tmp125_ = NULL;
		gint _tmp125__length1 = 0;
		Connection** _tmp126_ = NULL;
		gint _tmp126__length1 = 0;
		Connection* _tmp127_ = NULL;
		Connection* _tmp128_ = NULL;
		Connection* _tmp129_ = NULL;
		Connection* _tmp130_ = NULL;
		gboolean _tmp131_ = FALSE;
		const gchar* _tmp132_ = NULL;
		const gchar* _tmp133_ = NULL;
		ComponentInst** _tmp134_ = NULL;
		gint _tmp134__length1 = 0;
		ComponentInst* _tmp135_ = NULL;
		MemoryComponentState* _tmp136_ = NULL;
		MemoryComponentState* _tmp137_ = NULL;
		CompiledCircuit* _tmp138_ = NULL;
		ComponentState* _tmp139_ = NULL;
		_tmp125_ = addressWires;
		_tmp125__length1 = addressWires_length1;
		_tmp126_ = dataWires;
		_tmp126__length1 = dataWires_length1;
		_tmp127_ = selectWire;
		_tmp128_ = readEnableWire;
		_tmp129_ = writeEnableWire;
		_tmp130_ = clockWire;
		_tmp131_ = readWrite;
		_tmp132_ = readFile;
		_tmp133_ = writeFile;
		_tmp134_ = ancestry;
		_tmp134__length1 = ancestry_length1;
		_tmp135_ = componentInst;
		_tmp136_ = memory_component_state_new (_tmp125_, _tmp125__length1, _tmp126_, _tmp126__length1, _tmp127_, _tmp128_, _tmp129_, _tmp130_, _tmp131_, _tmp132_, _tmp133_, _tmp134_, _tmp134__length1, _tmp135_, &_inner_error_);
		_tmp124_ = _tmp136_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
				goto __catch40_component_state_error;
			}
			_component_state_unref0 (componentState);
			_g_free0 (writeFile);
			_g_free0 (readFile);
			_g_free0 (chipType);
			_connection_unref0 (clockWire);
			_connection_unref0 (writeEnableWire);
			_connection_unref0 (readEnableWire);
			_connection_unref0 (selectWire);
			dataWires = (_vala_array_free (dataWires, dataWires_length1, (GDestroyNotify) connection_unref), NULL);
			addressWires = (_vala_array_free (addressWires, addressWires_length1, (GDestroyNotify) connection_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp137_ = _tmp124_;
		_tmp124_ = NULL;
		_component_state_unref0 (componentState);
		componentState = (ComponentState*) _tmp137_;
		_tmp138_ = compiledCircuit;
		_tmp139_ = componentState;
		compiled_circuit_add_component (_tmp138_, _tmp139_);
		_component_state_unref0 (_tmp124_);
	}
	goto __finally40;
	__catch40_component_state_error:
	{
		GError* _error_ = NULL;
		CompiledCircuit* _tmp140_ = NULL;
		GError* _tmp141_ = NULL;
		const gchar* _tmp142_ = NULL;
		ComponentInst* _tmp143_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp140_ = compiledCircuit;
		_tmp141_ = _error_;
		_tmp142_ = _tmp141_->message;
		compiled_circuit_appendError (_tmp140_, _tmp142_);
		_tmp143_ = componentInst;
		_tmp143_->errorMark = TRUE;
		_g_error_free0 (_error_);
	}
	__finally40:
	if (_inner_error_ != NULL) {
		_component_state_unref0 (componentState);
		_g_free0 (writeFile);
		_g_free0 (readFile);
		_g_free0 (chipType);
		_connection_unref0 (clockWire);
		_connection_unref0 (writeEnableWire);
		_connection_unref0 (readEnableWire);
		_connection_unref0 (selectWire);
		dataWires = (_vala_array_free (dataWires, dataWires_length1, (GDestroyNotify) connection_unref), NULL);
		addressWires = (_vala_array_free (addressWires, addressWires_length1, (GDestroyNotify) connection_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_component_state_unref0 (componentState);
	_g_free0 (writeFile);
	_g_free0 (readFile);
	_g_free0 (chipType);
	_connection_unref0 (clockWire);
	_connection_unref0 (writeEnableWire);
	_connection_unref0 (readEnableWire);
	_connection_unref0 (selectWire);
	dataWires = (_vala_array_free (dataWires, dataWires_length1, (GDestroyNotify) connection_unref), NULL);
	addressWires = (_vala_array_free (addressWires, addressWires_length1, (GDestroyNotify) connection_unref), NULL);
}


static void memory_component_def_class_init (MemoryComponentDefClass * klass) {
	memory_component_def_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_DEF_CLASS (klass)->add_properties = memory_component_def_real_add_properties;
	COMPONENT_DEF_CLASS (klass)->get_properties = memory_component_def_real_get_properties;
	COMPONENT_DEF_CLASS (klass)->configure_inst = memory_component_def_real_configure_inst;
	COMPONENT_DEF_CLASS (klass)->load_properties = memory_component_def_real_load_properties;
	COMPONENT_DEF_CLASS (klass)->save_properties = memory_component_def_real_save_properties;
	COMPONENT_DEF_CLASS (klass)->compile_component = memory_component_def_real_compile_component;
}


static void memory_component_def_instance_init (MemoryComponentDef * self) {
}


GType memory_component_def_get_type (void) {
	static volatile gsize memory_component_def_type_id__volatile = 0;
	if (g_once_init_enter (&memory_component_def_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MemoryComponentDefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) memory_component_def_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MemoryComponentDef), 0, (GInstanceInitFunc) memory_component_def_instance_init, NULL };
		GType memory_component_def_type_id;
		memory_component_def_type_id = g_type_register_static (TYPE_COMPONENT_DEF, "MemoryComponentDef", &g_define_type_info, 0);
		g_once_init_leave (&memory_component_def_type_id__volatile, memory_component_def_type_id);
	}
	return memory_component_def_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



