/* def-multiplexer.c generated by valac 0.24.0, the Vala compiler
 * generated from def-multiplexer.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentdef/def-multiplexer.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <stdio.h>


#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;

#define TYPE_MULTIPLEXER_COMPONENT_DEF (multiplexer_component_def_get_type ())
#define MULTIPLEXER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTIPLEXER_COMPONENT_DEF, MultiplexerComponentDef))
#define MULTIPLEXER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTIPLEXER_COMPONENT_DEF, MultiplexerComponentDefClass))
#define IS_MULTIPLEXER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTIPLEXER_COMPONENT_DEF))
#define IS_MULTIPLEXER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTIPLEXER_COMPONENT_DEF))
#define MULTIPLEXER_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTIPLEXER_COMPONENT_DEF, MultiplexerComponentDefClass))

typedef struct _MultiplexerComponentDef MultiplexerComponentDef;
typedef struct _MultiplexerComponentDefClass MultiplexerComponentDefClass;
typedef struct _MultiplexerComponentDefPrivate MultiplexerComponentDefPrivate;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _PinInstPrivate PinInstPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;

#define TYPE_MULTIPLEXER_COMPONENT_STATE (multiplexer_component_state_get_type ())
#define MULTIPLEXER_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTIPLEXER_COMPONENT_STATE, MultiplexerComponentState))
#define MULTIPLEXER_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTIPLEXER_COMPONENT_STATE, MultiplexerComponentStateClass))
#define IS_MULTIPLEXER_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTIPLEXER_COMPONENT_STATE))
#define IS_MULTIPLEXER_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTIPLEXER_COMPONENT_STATE))
#define MULTIPLEXER_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTIPLEXER_COMPONENT_STATE, MultiplexerComponentStateClass))

typedef struct _MultiplexerComponentState MultiplexerComponentState;
typedef struct _MultiplexerComponentStateClass MultiplexerComponentStateClass;
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))
#define _pin_inst_unref0(var) ((var == NULL) ? NULL : (var = (pin_inst_unref (var), NULL)))
typedef struct _PinDefPrivate PinDefPrivate;

#define TYPE_FLOW (flow_get_type ())

#define PIN_DEF_TYPE_LABEL_TYPE (pin_def_label_type_get_type ())

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _MultiplexerComponentDef {
	ComponentDef parent_instance;
	MultiplexerComponentDefPrivate * priv;
};

struct _MultiplexerComponentDefClass {
	ComponentDefClass parent_class;
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

typedef enum  {
	PIN_DEF_LABEL_TYPE_NONE,
	PIN_DEF_LABEL_TYPE_TEXT,
	PIN_DEF_LABEL_TYPE_TEXTBAR,
	PIN_DEF_LABEL_TYPE_CLOCK
} PinDefLabelType;

struct _PinDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinDefPrivate * priv;
	gint x;
	gint y;
	gint xLabel;
	gint yLabel;
	gint xConnect;
	gint yConnect;
	Direction direction;
	gint length;
	gboolean array;
	Flow flow;
	gint defaultArraySize;
	gint idealSpace;
	gfloat minSpace;
	gchar* label;
	gboolean required;
	gboolean userArrayResize;
	gboolean showDefault;
	PinDefLabelType labelType;
};

struct _PinDefClass {
	GTypeClass parent_class;
	void (*finalize) (PinDef *self);
};


static gpointer multiplexer_component_def_parent_class = NULL;

gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
GType multiplexer_component_def_get_type (void) G_GNUC_CONST;
enum  {
	MULTIPLEXER_COMPONENT_DEF_DUMMY_PROPERTY
};
#define MULTIPLEXER_COMPONENT_DEF_infoFilename PACKAGE_DATADIR "components/info/multiplexer.xml"
GQuark component_def_load_error_quark (void);
MultiplexerComponentDef* multiplexer_component_def_new (GError** error);
MultiplexerComponentDef* multiplexer_component_def_construct (GType object_type, GError** error);
ComponentDef* component_def_construct (GType object_type);
GQuark custom_component_def_load_error_quark (void);
GQuark plugin_component_def_load_error_quark (void);
void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error);
static void multiplexer_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
Connection* connection_new_fake (void);
Connection* connection_construct_fake (GType object_type);
WireInst* connection_get_wireInst (Connection* self);
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
MultiplexerComponentState* multiplexer_component_state_new (Connection** selectWires, int selectWires_length1, Connection** dataWires, int dataWires_length1, Connection* outputWire, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
MultiplexerComponentState* multiplexer_component_state_construct (GType object_type, Connection** selectWires, int selectWires_length1, Connection** dataWires, int dataWires_length1, Connection* outputWire, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
GType multiplexer_component_state_get_type (void) G_GNUC_CONST;
void compiled_circuit_add_component (CompiledCircuit* self, ComponentState* componentState);
static void multiplexer_component_def_real_configure_inst (ComponentDef* base, ComponentInst* componentInst, gboolean firstLoad);
void component_inst_detatch_all (ComponentInst* self);
PinInst* pin_inst_new (PinDef* pinDef, gint arraySize);
PinInst* pin_inst_construct (GType object_type, PinDef* pinDef, gint arraySize);
GType flow_get_type (void) G_GNUC_CONST;
GType pin_def_label_type_get_type (void) G_GNUC_CONST;
static void multiplexer_component_def_real_extra_render (ComponentDef* base, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


MultiplexerComponentDef* multiplexer_component_def_construct (GType object_type, GError** error) {
	MultiplexerComponentDef* self = NULL;
	GError * _inner_error_ = NULL;
	self = (MultiplexerComponentDef*) component_def_construct (object_type);
	{
		component_def_load_from_file ((ComponentDef*) self, MULTIPLEXER_COMPONENT_DEF_infoFilename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch41_g_error;
		}
	}
	goto __finally41;
	__catch41_g_error:
	{
		FILE* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Failed to load built in component \"%s\"\n", MULTIPLEXER_COMPONENT_DEF_infoFilename);
		_tmp1_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_LOAD, "Failed to load \"" MULTIPLEXER_COMPONENT_DEF_infoFilename "\"\n");
		_inner_error_ = _tmp1_;
		goto __finally41;
	}
	__finally41:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


MultiplexerComponentDef* multiplexer_component_def_new (GError** error) {
	return multiplexer_component_def_construct (TYPE_MULTIPLEXER_COMPONENT_DEF, error);
}


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


static void multiplexer_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	MultiplexerComponentDef * self;
	Connection** selectWires = NULL;
	ComponentInst* _tmp0_ = NULL;
	PinInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PinInst* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Connection** _tmp4_ = NULL;
	gint selectWires_length1 = 0;
	gint _selectWires_size_ = 0;
	Connection** dataWires = NULL;
	ComponentInst* _tmp5_ = NULL;
	PinInst** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	PinInst* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Connection** _tmp9_ = NULL;
	gint dataWires_length1 = 0;
	gint _dataWires_size_ = 0;
	Connection* outputWire = NULL;
	Connection* _tmp10_ = NULL;
	Connection** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	ComponentState* componentState = NULL;
	Connection** _tmp69_ = NULL;
	gint _tmp69__length1 = 0;
	Connection** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	Connection* _tmp71_ = NULL;
	ComponentInst** _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	ComponentInst* _tmp73_ = NULL;
	MultiplexerComponentState* _tmp74_ = NULL;
	CompiledCircuit* _tmp75_ = NULL;
	self = (MultiplexerComponentDef*) base;
	g_return_if_fail (compiledCircuit != NULL);
	_tmp0_ = componentInst;
	_tmp1_ = _tmp0_->pinInsts;
	_tmp1__length1 = _tmp0_->pinInsts_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = _tmp2_->arraySize;
	_tmp4_ = g_new0 (Connection*, _tmp3_ + 1);
	selectWires = _tmp4_;
	selectWires_length1 = _tmp3_;
	_selectWires_size_ = selectWires_length1;
	_tmp5_ = componentInst;
	_tmp6_ = _tmp5_->pinInsts;
	_tmp6__length1 = _tmp5_->pinInsts_length1;
	_tmp7_ = _tmp6_[1];
	_tmp8_ = _tmp7_->arraySize;
	_tmp9_ = g_new0 (Connection*, _tmp8_ + 1);
	dataWires = _tmp9_;
	dataWires_length1 = _tmp8_;
	_dataWires_size_ = dataWires_length1;
	_tmp10_ = connection_new_fake ();
	outputWire = _tmp10_;
	_tmp11_ = connections;
	_tmp11__length1 = connections_length1;
	{
		Connection** connection_collection = NULL;
		gint connection_collection_length1 = 0;
		gint _connection_collection_size_ = 0;
		gint connection_it = 0;
		connection_collection = _tmp11_;
		connection_collection_length1 = _tmp11__length1;
		for (connection_it = 0; connection_it < _tmp11__length1; connection_it = connection_it + 1) {
			Connection* _tmp12_ = NULL;
			Connection* connection = NULL;
			_tmp12_ = _connection_ref0 (connection_collection[connection_it]);
			connection = _tmp12_;
			{
				Connection* _tmp59_ = NULL;
				WireInst* _tmp60_ = NULL;
				WireInst* _tmp61_ = NULL;
				ComponentInst* _tmp62_ = NULL;
				PinInst** _tmp63_ = NULL;
				gint _tmp63__length1 = 0;
				PinInst* _tmp64_ = NULL;
				WireInst** _tmp65_ = NULL;
				gint _tmp65__length1 = 0;
				WireInst* _tmp66_ = NULL;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gint _tmp15_ = 0;
							ComponentInst* _tmp16_ = NULL;
							PinInst** _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							PinInst* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							WireInst* wireInst = NULL;
							ComponentInst* _tmp20_ = NULL;
							PinInst** _tmp21_ = NULL;
							gint _tmp21__length1 = 0;
							PinInst* _tmp22_ = NULL;
							WireInst** _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							WireInst* _tmp25_ = NULL;
							WireInst* _tmp26_ = NULL;
							Connection* _tmp27_ = NULL;
							WireInst* _tmp28_ = NULL;
							WireInst* _tmp29_ = NULL;
							WireInst* _tmp30_ = NULL;
							if (!_tmp13_) {
								gint _tmp14_ = 0;
								_tmp14_ = i;
								i = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = i;
							_tmp16_ = componentInst;
							_tmp17_ = _tmp16_->pinInsts;
							_tmp17__length1 = _tmp16_->pinInsts_length1;
							_tmp18_ = _tmp17_[0];
							_tmp19_ = _tmp18_->arraySize;
							if (!(_tmp15_ < _tmp19_)) {
								break;
							}
							_tmp20_ = componentInst;
							_tmp21_ = _tmp20_->pinInsts;
							_tmp21__length1 = _tmp20_->pinInsts_length1;
							_tmp22_ = _tmp21_[0];
							_tmp23_ = _tmp22_->wireInsts;
							_tmp23__length1 = _tmp22_->wireInsts_length1;
							_tmp24_ = i;
							_tmp25_ = _tmp23_[_tmp24_];
							_tmp26_ = _wire_inst_ref0 (_tmp25_);
							wireInst = _tmp26_;
							_tmp27_ = connection;
							_tmp28_ = connection_get_wireInst (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = wireInst;
							if (_tmp29_ == _tmp30_) {
								Connection** _tmp31_ = NULL;
								gint _tmp31__length1 = 0;
								gint _tmp32_ = 0;
								Connection* _tmp33_ = NULL;
								Connection* _tmp34_ = NULL;
								Connection* _tmp35_ = NULL;
								_tmp31_ = selectWires;
								_tmp31__length1 = selectWires_length1;
								_tmp32_ = i;
								_tmp33_ = connection;
								_tmp34_ = _connection_ref0 (_tmp33_);
								_connection_unref0 (_tmp31_[_tmp32_]);
								_tmp31_[_tmp32_] = _tmp34_;
								_tmp35_ = _tmp31_[_tmp32_];
							}
							_wire_inst_unref0 (wireInst);
						}
					}
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp36_ = FALSE;
						_tmp36_ = TRUE;
						while (TRUE) {
							gint _tmp38_ = 0;
							ComponentInst* _tmp39_ = NULL;
							PinInst** _tmp40_ = NULL;
							gint _tmp40__length1 = 0;
							PinInst* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							WireInst* wireInst = NULL;
							ComponentInst* _tmp43_ = NULL;
							PinInst** _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							PinInst* _tmp45_ = NULL;
							WireInst** _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp47_ = 0;
							WireInst* _tmp48_ = NULL;
							WireInst* _tmp49_ = NULL;
							Connection* _tmp50_ = NULL;
							WireInst* _tmp51_ = NULL;
							WireInst* _tmp52_ = NULL;
							WireInst* _tmp53_ = NULL;
							if (!_tmp36_) {
								gint _tmp37_ = 0;
								_tmp37_ = i;
								i = _tmp37_ + 1;
							}
							_tmp36_ = FALSE;
							_tmp38_ = i;
							_tmp39_ = componentInst;
							_tmp40_ = _tmp39_->pinInsts;
							_tmp40__length1 = _tmp39_->pinInsts_length1;
							_tmp41_ = _tmp40_[1];
							_tmp42_ = _tmp41_->arraySize;
							if (!(_tmp38_ < _tmp42_)) {
								break;
							}
							_tmp43_ = componentInst;
							_tmp44_ = _tmp43_->pinInsts;
							_tmp44__length1 = _tmp43_->pinInsts_length1;
							_tmp45_ = _tmp44_[1];
							_tmp46_ = _tmp45_->wireInsts;
							_tmp46__length1 = _tmp45_->wireInsts_length1;
							_tmp47_ = i;
							_tmp48_ = _tmp46_[_tmp47_];
							_tmp49_ = _wire_inst_ref0 (_tmp48_);
							wireInst = _tmp49_;
							_tmp50_ = connection;
							_tmp51_ = connection_get_wireInst (_tmp50_);
							_tmp52_ = _tmp51_;
							_tmp53_ = wireInst;
							if (_tmp52_ == _tmp53_) {
								Connection** _tmp54_ = NULL;
								gint _tmp54__length1 = 0;
								gint _tmp55_ = 0;
								Connection* _tmp56_ = NULL;
								Connection* _tmp57_ = NULL;
								Connection* _tmp58_ = NULL;
								_tmp54_ = dataWires;
								_tmp54__length1 = dataWires_length1;
								_tmp55_ = i;
								_tmp56_ = connection;
								_tmp57_ = _connection_ref0 (_tmp56_);
								_connection_unref0 (_tmp54_[_tmp55_]);
								_tmp54_[_tmp55_] = _tmp57_;
								_tmp58_ = _tmp54_[_tmp55_];
							}
							_wire_inst_unref0 (wireInst);
						}
					}
				}
				_tmp59_ = connection;
				_tmp60_ = connection_get_wireInst (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = componentInst;
				_tmp63_ = _tmp62_->pinInsts;
				_tmp63__length1 = _tmp62_->pinInsts_length1;
				_tmp64_ = _tmp63_[2];
				_tmp65_ = _tmp64_->wireInsts;
				_tmp65__length1 = _tmp64_->wireInsts_length1;
				_tmp66_ = _tmp65_[0];
				if (_tmp61_ == _tmp66_) {
					Connection* _tmp67_ = NULL;
					Connection* _tmp68_ = NULL;
					_tmp67_ = connection;
					_tmp68_ = _connection_ref0 (_tmp67_);
					_connection_unref0 (outputWire);
					outputWire = _tmp68_;
				}
				_connection_unref0 (connection);
			}
		}
	}
	_tmp69_ = selectWires;
	_tmp69__length1 = selectWires_length1;
	_tmp70_ = dataWires;
	_tmp70__length1 = dataWires_length1;
	_tmp71_ = outputWire;
	_tmp72_ = ancestry;
	_tmp72__length1 = ancestry_length1;
	_tmp73_ = componentInst;
	_tmp74_ = multiplexer_component_state_new (_tmp69_, _tmp69__length1, _tmp70_, _tmp70__length1, _tmp71_, _tmp72_, _tmp72__length1, _tmp73_);
	componentState = (ComponentState*) _tmp74_;
	_tmp75_ = compiledCircuit;
	compiled_circuit_add_component (_tmp75_, componentState);
	_component_state_unref0 (componentState);
	_connection_unref0 (outputWire);
	dataWires = (_vala_array_free (dataWires, dataWires_length1, (GDestroyNotify) connection_unref), NULL);
	selectWires = (_vala_array_free (selectWires, selectWires_length1, (GDestroyNotify) connection_unref), NULL);
}


static void multiplexer_component_def_real_configure_inst (ComponentDef* base, ComponentInst* componentInst, gboolean firstLoad) {
	MultiplexerComponentDef * self;
	gint selectWires = 0;
	ComponentInst* _tmp0_ = NULL;
	PinInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PinInst* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint dataWires = 0;
	gint _tmp4_ = 0;
	gboolean changedWires = FALSE;
	gint _tmp5_ = 0;
	ComponentInst* _tmp6_ = NULL;
	PinInst** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	PinInst* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	self = (MultiplexerComponentDef*) base;
	g_return_if_fail (componentInst != NULL);
	_tmp0_ = componentInst;
	_tmp1_ = _tmp0_->pinInsts;
	_tmp1__length1 = _tmp0_->pinInsts_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = _tmp2_->arraySize;
	selectWires = _tmp3_;
	_tmp4_ = selectWires;
	dataWires = 1 << _tmp4_;
	changedWires = FALSE;
	_tmp5_ = dataWires;
	_tmp6_ = componentInst;
	_tmp7_ = _tmp6_->pinInsts;
	_tmp7__length1 = _tmp6_->pinInsts_length1;
	_tmp8_ = _tmp7_[1];
	_tmp9_ = _tmp8_->arraySize;
	if (_tmp5_ != _tmp9_) {
		ComponentInst* _tmp10_ = NULL;
		ComponentInst* _tmp11_ = NULL;
		PinInst** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		PinDef** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		PinDef* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		PinInst* _tmp16_ = NULL;
		PinInst* _tmp17_ = NULL;
		_tmp10_ = componentInst;
		component_inst_detatch_all (_tmp10_);
		_tmp11_ = componentInst;
		_tmp12_ = _tmp11_->pinInsts;
		_tmp12__length1 = _tmp11_->pinInsts_length1;
		_tmp13_ = ((ComponentDef*) self)->pinDefs;
		_tmp13__length1 = ((ComponentDef*) self)->pinDefs_length1;
		_tmp14_ = _tmp13_[1];
		_tmp15_ = dataWires;
		_tmp16_ = pin_inst_new (_tmp14_, _tmp15_);
		_pin_inst_unref0 (_tmp12_[1]);
		_tmp12_[1] = _tmp16_;
		_tmp17_ = _tmp12_[1];
		changedWires = TRUE;
	}
	_tmp19_ = changedWires;
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = firstLoad;
		_tmp18_ = _tmp20_;
	}
	if (_tmp18_) {
		ComponentInst* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		PinDef** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		PinDef* _tmp24_ = NULL;
		gfloat _tmp25_ = 0.0F;
		ComponentInst* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		PinDef** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		PinDef* _tmp29_ = NULL;
		gfloat _tmp30_ = 0.0F;
		ComponentInst* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		PinDef** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		PinDef* _tmp34_ = NULL;
		gfloat _tmp35_ = 0.0F;
		ComponentInst* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		PinDef** _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		PinDef* _tmp39_ = NULL;
		gfloat _tmp40_ = 0.0F;
		ComponentInst* _tmp95_ = NULL;
		PinInst** _tmp96_ = NULL;
		gint _tmp96__length1 = 0;
		PinInst* _tmp97_ = NULL;
		gint* _tmp98_ = NULL;
		gint _tmp98__length1 = 0;
		ComponentInst* _tmp99_ = NULL;
		gint _tmp100_ = 0;
		gint _tmp101_ = 0;
		ComponentInst* _tmp102_ = NULL;
		PinInst** _tmp103_ = NULL;
		gint _tmp103__length1 = 0;
		PinInst* _tmp104_ = NULL;
		gint* _tmp105_ = NULL;
		gint _tmp105__length1 = 0;
		ComponentInst* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		PinDef** _tmp108_ = NULL;
		gint _tmp108__length1 = 0;
		PinDef* _tmp109_ = NULL;
		gint _tmp110_ = 0;
		gint _tmp111_ = 0;
		_tmp21_ = componentInst;
		_tmp22_ = dataWires;
		_tmp23_ = ((ComponentDef*) self)->pinDefs;
		_tmp23__length1 = ((ComponentDef*) self)->pinDefs_length1;
		_tmp24_ = _tmp23_[1];
		_tmp25_ = _tmp24_->minSpace;
		_tmp21_->downBound = 15 + (((_tmp22_ - 1) * ((gint) _tmp25_)) / 2);
		_tmp26_ = componentInst;
		_tmp27_ = selectWires;
		_tmp28_ = ((ComponentDef*) self)->pinDefs;
		_tmp28__length1 = ((ComponentDef*) self)->pinDefs_length1;
		_tmp29_ = _tmp28_[0];
		_tmp30_ = _tmp29_->minSpace;
		_tmp26_->rightBound = 10 + (((_tmp27_ - 1) * ((gint) _tmp30_)) / 2);
		_tmp31_ = componentInst;
		_tmp32_ = dataWires;
		_tmp33_ = ((ComponentDef*) self)->pinDefs;
		_tmp33__length1 = ((ComponentDef*) self)->pinDefs_length1;
		_tmp34_ = _tmp33_[1];
		_tmp35_ = _tmp34_->minSpace;
		_tmp31_->upBound = (-15) - (((_tmp32_ - 1) * ((gint) _tmp35_)) / 2);
		_tmp36_ = componentInst;
		_tmp37_ = selectWires;
		_tmp38_ = ((ComponentDef*) self)->pinDefs;
		_tmp38__length1 = ((ComponentDef*) self)->pinDefs_length1;
		_tmp39_ = _tmp38_[0];
		_tmp40_ = _tmp39_->minSpace;
		_tmp36_->leftBound = (-10) - (((_tmp37_ - 1) * ((gint) _tmp40_)) / 2);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp41_ = FALSE;
				_tmp41_ = TRUE;
				while (TRUE) {
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					ComponentInst* _tmp45_ = NULL;
					PinInst** _tmp46_ = NULL;
					gint _tmp46__length1 = 0;
					PinInst* _tmp47_ = NULL;
					gint* _tmp48_ = NULL;
					gint _tmp48__length1 = 0;
					gint _tmp49_ = 0;
					ComponentInst* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					PinDef** _tmp53_ = NULL;
					gint _tmp53__length1 = 0;
					PinDef* _tmp54_ = NULL;
					gfloat _tmp55_ = 0.0F;
					gint _tmp56_ = 0;
					ComponentInst* _tmp57_ = NULL;
					PinInst** _tmp58_ = NULL;
					gint _tmp58__length1 = 0;
					PinInst* _tmp59_ = NULL;
					gint* _tmp60_ = NULL;
					gint _tmp60__length1 = 0;
					gint _tmp61_ = 0;
					ComponentInst* _tmp62_ = NULL;
					gint _tmp63_ = 0;
					gint _tmp64_ = 0;
					PinDef** _tmp65_ = NULL;
					gint _tmp65__length1 = 0;
					PinDef* _tmp66_ = NULL;
					gfloat _tmp67_ = 0.0F;
					PinDef** _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					PinDef* _tmp69_ = NULL;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					if (!_tmp41_) {
						gint _tmp42_ = 0;
						_tmp42_ = i;
						i = _tmp42_ + 1;
					}
					_tmp41_ = FALSE;
					_tmp43_ = i;
					_tmp44_ = selectWires;
					if (!(_tmp43_ < _tmp44_)) {
						break;
					}
					_tmp45_ = componentInst;
					_tmp46_ = _tmp45_->pinInsts;
					_tmp46__length1 = _tmp45_->pinInsts_length1;
					_tmp47_ = _tmp46_[0];
					_tmp48_ = _tmp47_->y;
					_tmp48__length1 = _tmp47_->y_length1;
					_tmp49_ = i;
					_tmp50_ = componentInst;
					_tmp51_ = _tmp50_->upBound;
					_tmp52_ = i;
					_tmp53_ = ((ComponentDef*) self)->pinDefs;
					_tmp53__length1 = ((ComponentDef*) self)->pinDefs_length1;
					_tmp54_ = _tmp53_[0];
					_tmp55_ = _tmp54_->minSpace;
					_tmp48_[_tmp49_] = (_tmp51_ + ((_tmp52_ * ((gint) _tmp55_)) / 2)) + 5;
					_tmp56_ = _tmp48_[_tmp49_];
					_tmp57_ = componentInst;
					_tmp58_ = _tmp57_->pinInsts;
					_tmp58__length1 = _tmp57_->pinInsts_length1;
					_tmp59_ = _tmp58_[0];
					_tmp60_ = _tmp59_->yConnect;
					_tmp60__length1 = _tmp59_->yConnect_length1;
					_tmp61_ = i;
					_tmp62_ = componentInst;
					_tmp63_ = _tmp62_->upBound;
					_tmp64_ = i;
					_tmp65_ = ((ComponentDef*) self)->pinDefs;
					_tmp65__length1 = ((ComponentDef*) self)->pinDefs_length1;
					_tmp66_ = _tmp65_[0];
					_tmp67_ = _tmp66_->minSpace;
					_tmp68_ = ((ComponentDef*) self)->pinDefs;
					_tmp68__length1 = ((ComponentDef*) self)->pinDefs_length1;
					_tmp69_ = _tmp68_[0];
					_tmp70_ = _tmp69_->length;
					_tmp60_[_tmp61_] = ((_tmp63_ + ((_tmp64_ * ((gint) _tmp67_)) / 2)) + 5) - _tmp70_;
					_tmp71_ = _tmp60_[_tmp61_];
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp72_ = FALSE;
				_tmp72_ = TRUE;
				while (TRUE) {
					gint _tmp74_ = 0;
					gint _tmp75_ = 0;
					ComponentInst* _tmp76_ = NULL;
					PinInst** _tmp77_ = NULL;
					gint _tmp77__length1 = 0;
					PinInst* _tmp78_ = NULL;
					gint* _tmp79_ = NULL;
					gint _tmp79__length1 = 0;
					gint _tmp80_ = 0;
					ComponentInst* _tmp81_ = NULL;
					gint _tmp82_ = 0;
					gint _tmp83_ = 0;
					ComponentInst* _tmp84_ = NULL;
					PinInst** _tmp85_ = NULL;
					gint _tmp85__length1 = 0;
					PinInst* _tmp86_ = NULL;
					gint* _tmp87_ = NULL;
					gint _tmp87__length1 = 0;
					gint _tmp88_ = 0;
					ComponentInst* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					PinDef** _tmp91_ = NULL;
					gint _tmp91__length1 = 0;
					PinDef* _tmp92_ = NULL;
					gint _tmp93_ = 0;
					gint _tmp94_ = 0;
					if (!_tmp72_) {
						gint _tmp73_ = 0;
						_tmp73_ = i;
						i = _tmp73_ + 1;
					}
					_tmp72_ = FALSE;
					_tmp74_ = i;
					_tmp75_ = dataWires;
					if (!(_tmp74_ < _tmp75_)) {
						break;
					}
					_tmp76_ = componentInst;
					_tmp77_ = _tmp76_->pinInsts;
					_tmp77__length1 = _tmp76_->pinInsts_length1;
					_tmp78_ = _tmp77_[1];
					_tmp79_ = _tmp78_->x;
					_tmp79__length1 = _tmp78_->x_length1;
					_tmp80_ = i;
					_tmp81_ = componentInst;
					_tmp82_ = _tmp81_->leftBound;
					_tmp79_[_tmp80_] = _tmp82_;
					_tmp83_ = _tmp79_[_tmp80_];
					_tmp84_ = componentInst;
					_tmp85_ = _tmp84_->pinInsts;
					_tmp85__length1 = _tmp84_->pinInsts_length1;
					_tmp86_ = _tmp85_[1];
					_tmp87_ = _tmp86_->xConnect;
					_tmp87__length1 = _tmp86_->xConnect_length1;
					_tmp88_ = i;
					_tmp89_ = componentInst;
					_tmp90_ = _tmp89_->leftBound;
					_tmp91_ = ((ComponentDef*) self)->pinDefs;
					_tmp91__length1 = ((ComponentDef*) self)->pinDefs_length1;
					_tmp92_ = _tmp91_[0];
					_tmp93_ = _tmp92_->length;
					_tmp87_[_tmp88_] = _tmp90_ - _tmp93_;
					_tmp94_ = _tmp87_[_tmp88_];
				}
			}
		}
		_tmp95_ = componentInst;
		_tmp96_ = _tmp95_->pinInsts;
		_tmp96__length1 = _tmp95_->pinInsts_length1;
		_tmp97_ = _tmp96_[2];
		_tmp98_ = _tmp97_->x;
		_tmp98__length1 = _tmp97_->x_length1;
		_tmp99_ = componentInst;
		_tmp100_ = _tmp99_->rightBound;
		_tmp98_[0] = _tmp100_;
		_tmp101_ = _tmp98_[0];
		_tmp102_ = componentInst;
		_tmp103_ = _tmp102_->pinInsts;
		_tmp103__length1 = _tmp102_->pinInsts_length1;
		_tmp104_ = _tmp103_[2];
		_tmp105_ = _tmp104_->xConnect;
		_tmp105__length1 = _tmp104_->xConnect_length1;
		_tmp106_ = componentInst;
		_tmp107_ = _tmp106_->rightBound;
		_tmp108_ = ((ComponentDef*) self)->pinDefs;
		_tmp108__length1 = ((ComponentDef*) self)->pinDefs_length1;
		_tmp109_ = _tmp108_[0];
		_tmp110_ = _tmp109_->length;
		_tmp105_[0] = _tmp107_ + _tmp110_;
		_tmp111_ = _tmp105_[0];
	}
}


static void multiplexer_component_def_real_extra_render (ComponentDef* base, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst) {
	MultiplexerComponentDef * self;
	cairo_matrix_t oldMatrix = {0};
	ComponentInst* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_matrix_t _tmp2_ = {0};
	gdouble angle = 0.0;
	Direction _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gboolean _tmp6_ = FALSE;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	ComponentInst* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	ComponentInst* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	cairo_t* _tmp15_ = NULL;
	ComponentInst* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	ComponentInst* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ComponentInst* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	cairo_t* _tmp22_ = NULL;
	ComponentInst* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	ComponentInst* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ComponentInst* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_t* _tmp29_ = NULL;
	ComponentInst* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	ComponentInst* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	cairo_matrix_t _tmp38_ = {0};
	self = (MultiplexerComponentDef*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = componentInst;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = context;
	cairo_get_matrix (_tmp1_, &_tmp2_);
	oldMatrix = _tmp2_;
	angle = (gdouble) 0;
	_tmp3_ = direction;
	switch (_tmp3_) {
		case DIRECTION_RIGHT:
		{
			angle = (gdouble) 0;
			break;
		}
		case DIRECTION_DOWN:
		{
			angle = G_PI * 0.5;
			break;
		}
		case DIRECTION_LEFT:
		{
			angle = G_PI;
			break;
		}
		case DIRECTION_UP:
		{
			angle = G_PI * 1.5;
			break;
		}
		default:
		break;
	}
	_tmp4_ = context;
	_tmp5_ = angle;
	cairo_rotate (_tmp4_, _tmp5_);
	_tmp6_ = flipped;
	if (_tmp6_) {
		cairo_t* _tmp7_ = NULL;
		_tmp7_ = context;
		cairo_scale (_tmp7_, 1.0, -1.0);
	}
	_tmp8_ = context;
	cairo_set_source_rgb (_tmp8_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp9_ = context;
	cairo_set_line_width (_tmp9_, (gdouble) 2);
	_tmp10_ = context;
	_tmp11_ = componentInst;
	_tmp12_ = _tmp11_->leftBound;
	_tmp13_ = componentInst;
	_tmp14_ = _tmp13_->upBound;
	cairo_move_to (_tmp10_, (gdouble) _tmp12_, (gdouble) _tmp14_);
	_tmp15_ = context;
	_tmp16_ = componentInst;
	_tmp17_ = _tmp16_->rightBound;
	_tmp18_ = componentInst;
	_tmp19_ = _tmp18_->upBound;
	_tmp20_ = componentInst;
	_tmp21_ = _tmp20_->rightBound;
	cairo_line_to (_tmp15_, (gdouble) _tmp17_, (gdouble) (_tmp19_ + _tmp21_));
	_tmp22_ = context;
	_tmp23_ = componentInst;
	_tmp24_ = _tmp23_->rightBound;
	_tmp25_ = componentInst;
	_tmp26_ = _tmp25_->downBound;
	_tmp27_ = componentInst;
	_tmp28_ = _tmp27_->rightBound;
	cairo_line_to (_tmp22_, (gdouble) _tmp24_, (gdouble) (_tmp26_ - _tmp28_));
	_tmp29_ = context;
	_tmp30_ = componentInst;
	_tmp31_ = _tmp30_->leftBound;
	_tmp32_ = componentInst;
	_tmp33_ = _tmp32_->downBound;
	cairo_line_to (_tmp29_, (gdouble) _tmp31_, (gdouble) _tmp33_);
	_tmp34_ = context;
	cairo_close_path (_tmp34_);
	_tmp35_ = context;
	cairo_stroke (_tmp35_);
	_tmp36_ = context;
	cairo_set_line_width (_tmp36_, (gdouble) 1);
	_tmp37_ = context;
	_tmp38_ = oldMatrix;
	cairo_set_matrix (_tmp37_, &_tmp38_);
}


static void multiplexer_component_def_class_init (MultiplexerComponentDefClass * klass) {
	multiplexer_component_def_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_DEF_CLASS (klass)->compile_component = multiplexer_component_def_real_compile_component;
	COMPONENT_DEF_CLASS (klass)->configure_inst = multiplexer_component_def_real_configure_inst;
	COMPONENT_DEF_CLASS (klass)->extra_render = multiplexer_component_def_real_extra_render;
}


static void multiplexer_component_def_instance_init (MultiplexerComponentDef * self) {
}


GType multiplexer_component_def_get_type (void) {
	static volatile gsize multiplexer_component_def_type_id__volatile = 0;
	if (g_once_init_enter (&multiplexer_component_def_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultiplexerComponentDefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiplexer_component_def_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiplexerComponentDef), 0, (GInstanceInitFunc) multiplexer_component_def_instance_init, NULL };
		GType multiplexer_component_def_type_id;
		multiplexer_component_def_type_id = g_type_register_static (TYPE_COMPONENT_DEF, "MultiplexerComponentDef", &g_define_type_info, 0);
		g_once_init_leave (&multiplexer_component_def_type_id__volatile, multiplexer_component_def_type_id);
	}
	return multiplexer_component_def_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



