/* componentinst.c generated by valac 0.24.0, the Vala compiler
 * generated from componentinst.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentinst.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
typedef struct _PinDefPrivate PinDefPrivate;

#define TYPE_FLOW (flow_get_type ())

#define PIN_DEF_TYPE_LABEL_TYPE (pin_def_label_type_get_type ())
#define _pin_inst_unref0(var) ((var == NULL) ? NULL : (var = (pin_inst_unref (var), NULL)))
#define _pin_def_unref0(var) ((var == NULL) ? NULL : (var = (pin_def_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
typedef struct _PinInstPrivate PinInstPrivate;
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
typedef struct _WireInstPrivate WireInstPrivate;

#define WIRE_INST_TYPE_REGISTERED_COMPONENT (wire_inst_registered_component_get_type ())

#define WIRE_INST_TYPE_MARKER (wire_inst_marker_get_type ())
typedef struct _WireInstMarker WireInstMarker;
typedef struct _WireInstRegisteredComponent WireInstRegisteredComponent;

#define TYPE_PATH (path_get_type ())
#define PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH, Path))
#define PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH, PathClass))
#define IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH))
#define IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH))
#define PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH, PathClass))

typedef struct _Path Path;
typedef struct _PathClass PathClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define WIRE_INST_TYPE_PRESET_SIGNAL (wire_inst_preset_signal_get_type ())

#define TYPE_WIRE_STATE (wire_state_get_type ())
#define WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_STATE, WireState))
#define WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_STATE, WireStateClass))
#define IS_WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_STATE))
#define IS_WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_STATE))
#define WIRE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_STATE, WireStateClass))

typedef struct _WireState WireState;
typedef struct _WireStateClass WireStateClass;
typedef struct _WireStatePrivate WireStatePrivate;
#define _wire_state_unref0(var) ((var == NULL) ? NULL : (var = (wire_state_unref (var), NULL)))
typedef struct _ParamSpecComponentInst ParamSpecComponentInst;

/**
 * ComponentInst load from file errors.
 */
typedef enum  {
	COMPONENT_INST_LOAD_ERROR_INVALID,
	COMPONENT_INST_LOAD_ERROR_MISSING_DEF
} ComponentInstLoadError;
#define COMPONENT_INST_LOAD_ERROR component_inst_load_error_quark ()
typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

typedef enum  {
	PIN_DEF_LABEL_TYPE_NONE,
	PIN_DEF_LABEL_TYPE_TEXT,
	PIN_DEF_LABEL_TYPE_TEXTBAR,
	PIN_DEF_LABEL_TYPE_CLOCK
} PinDefLabelType;

struct _PinDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinDefPrivate * priv;
	gint x;
	gint y;
	gint xLabel;
	gint yLabel;
	gint xConnect;
	gint yConnect;
	Direction direction;
	gint length;
	gboolean array;
	Flow flow;
	gint defaultArraySize;
	gint idealSpace;
	gfloat minSpace;
	gchar* label;
	gboolean required;
	gboolean userArrayResize;
	gboolean showDefault;
	PinDefLabelType labelType;
};

struct _PinDefClass {
	GTypeClass parent_class;
	void (*finalize) (PinDef *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};

struct _WireInstMarker {
	gint x;
	gint y;
	gboolean display;
};

struct _WireInstRegisteredComponent {
	ComponentInst* componentInst;
	WireInstMarker marker;
};

typedef enum  {
	WIRE_INST_PRESET_SIGNAL_DEFAULT,
	WIRE_INST_PRESET_SIGNAL_FALSE,
	WIRE_INST_PRESET_SIGNAL_TRUE
} WireInstPresetSignal;

struct _WireInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireInstPrivate * priv;
	WireInstRegisteredComponent* registeredComponents;
	gint registeredComponents_length1;
	gint myID;
	gboolean selected;
	WireInstMarker* markers;
	gint markers_length1;
	Path** paths;
	gint paths_length1;
	Tag* interfaceTag;
	WireInstPresetSignal presetSignal;
};

struct _WireInstClass {
	GTypeClass parent_class;
	void (*finalize) (WireInst *self);
};

struct _WireState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireStatePrivate * priv;
	gint renderQueueID;
	gint processQueueID;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	gboolean display;
	gboolean errorMark;
	WireInst* wireInst;
	gint users;
	gint previousUsers;
};

struct _WireStateClass {
	GTypeClass parent_class;
	void (*finalize) (WireState *self);
};

struct _ParamSpecComponentInst {
	GParamSpec parent_instance;
};


static gpointer component_inst_parent_class = NULL;

GQuark component_inst_load_error_quark (void);
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
enum  {
	COMPONENT_INST_DUMMY_PROPERTY
};
ComponentInst* component_inst_new (ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped);
ComponentInst* component_inst_construct (GType object_type, ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped);
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
GType flow_get_type (void) G_GNUC_CONST;
GType pin_def_label_type_get_type (void) G_GNUC_CONST;
PinInst* pin_inst_new (PinDef* pinDef, gint arraySize);
PinInst* pin_inst_construct (GType object_type, PinDef* pinDef, gint arraySize);
static void _vala_array_add47 (PinInst*** array, int* length, int* size, PinInst* value);
static PinInst** _vala_array_dup41 (PinInst** self, int length);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
void component_def_configure_inst (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
ComponentInst* component_inst_new_load (xmlNode* xmlnode, Project* project, WireInst** newWireInsts, int newWireInsts_length1, GError** error);
ComponentInst* component_inst_construct_load (GType object_type, xmlNode* xmlnode, Project* project, WireInst** newWireInsts, int newWireInsts_length1, GError** error);
ComponentDef* project_resolve_def_name (Project* self, const gchar* name);
static void _vala_array_add48 (PinInst*** array, int* length, int* size, PinInst* value);
static PinInst** _vala_array_dup42 (PinInst** self, int length);
void component_def_load_properties (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
gint pin_inst_append (PinInst* self);
static WireInst* component_inst_resolve_wire_id (ComponentInst* self, WireInst** anyWireInsts, int anyWireInsts_length1, gint wireid);
void component_inst_absolute_position (ComponentInst* self, gint xRelative, gint yRelative, gint* xRaw, gint* yRaw);
void wire_inst_register_component (WireInst* self, ComponentInst* newComponentInst, gint x, gint y);
void component_inst_absolute_bounds (ComponentInst* self, gint* right, gint* down, gint* left, gint* up);
GType wire_inst_registered_component_get_type (void) G_GNUC_CONST;
GType wire_inst_marker_get_type (void) G_GNUC_CONST;
WireInstMarker* wire_inst_marker_dup (const WireInstMarker* self);
void wire_inst_marker_free (WireInstMarker* self);
WireInstRegisteredComponent* wire_inst_registered_component_dup (const WireInstRegisteredComponent* self);
void wire_inst_registered_component_free (WireInstRegisteredComponent* self);
gpointer path_ref (gpointer instance);
void path_unref (gpointer instance);
GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_path (GValue* value, gpointer v_object);
void value_take_path (GValue* value, gpointer v_object);
gpointer value_get_path (const GValue* value);
GType path_get_type (void) G_GNUC_CONST;
gpointer tag_ref (gpointer instance);
void tag_unref (gpointer instance);
GParamSpec* param_spec_tag (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag (GValue* value, gpointer v_object);
void value_take_tag (GValue* value, gpointer v_object);
gpointer value_get_tag (const GValue* value);
GType tag_get_type (void) G_GNUC_CONST;
GType wire_inst_preset_signal_get_type (void) G_GNUC_CONST;
void component_inst_relative_position (ComponentInst* self, gint xRaw, gint yRaw, gint* xRelative, gint* yRelative);
void component_inst_try_invert (ComponentInst* self, gint x, gint y);
void pin_inst_try_invert (PinInst* self, gint x, gint y);
void component_inst_try_select (ComponentInst* self, gint x, gint y, gboolean toggle);
void component_inst_change_wire (ComponentInst* self, WireInst* replaceWhat, WireInst* replaceWith);
void component_inst_detatch_all (ComponentInst* self);
void wire_inst_unregister_component (WireInst* self, ComponentInst* oldComponentInst);
void component_inst_disconnect_wire (ComponentInst* self, WireInst* wireInst, gboolean callWire);
gboolean component_inst_try_connect (ComponentInst* self, gint x, gint y, WireInst* wireInst);
gboolean pin_inst_try_connect (PinInst* self, gint x, gint y, WireInst* wireInst, ComponentInst* componentInst);
gboolean component_inst_try_disconnect (ComponentInst* self, gint x, gint y);
gboolean pin_inst_try_disconnect (PinInst* self, gint x, gint y, ComponentInst* componentInst);
void component_inst_move (ComponentInst* self, gint x, gint y, gboolean ignoreSelect);
void component_inst_flip (ComponentInst* self, gboolean ignoreSelect);
void component_inst_orientate (ComponentInst* self, Direction direction, gboolean ignoreSelect);
gint component_inst_find (ComponentInst* self, gint x, gint y);
gpointer wire_state_ref (gpointer instance);
void wire_state_unref (gpointer instance);
GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_state (GValue* value, gpointer v_object);
void value_take_wire_state (GValue* value, gpointer v_object);
gpointer value_get_wire_state (const GValue* value);
GType wire_state_get_type (void) G_GNUC_CONST;
void component_inst_compile_component (ComponentInst* self, CompiledCircuit* compiledCircuit, WireState** localWireStates, int localWireStates_length1, ComponentInst** ancestry, int ancestry_length1);
Connection* connection_new_fake (void);
Connection* connection_construct_fake (GType object_type);
static void _vala_array_add49 (Connection*** array, int* length, int* size, Connection* value);
Connection* connection_new (WireState* wireState, gboolean invert);
Connection* connection_construct (GType object_type, WireState* wireState, gboolean invert);
static void _vala_array_add50 (Connection*** array, int* length, int* size, Connection* value);
void component_def_compile_component (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
void component_inst_save (ComponentInst* self, xmlTextWriter* xmlWriter);
void component_def_save_properties (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
void component_inst_render (ComponentInst* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
void component_def_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst, gboolean colourBackground);
void pin_inst_render (PinInst* self, cairo_t* context, gboolean showHints);
static void component_inst_finalize (ComponentInst* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark component_inst_load_error_quark (void) {
	return g_quark_from_static_string ("component_inst_load_error-quark");
}


/**
 * Creates a new component instance of a //componentDef// with
 * details passed.
 */
static gpointer _pin_def_ref0 (gpointer self) {
	return self ? pin_def_ref (self) : NULL;
}


static gpointer _pin_inst_ref0 (gpointer self) {
	return self ? pin_inst_ref (self) : NULL;
}


static void _vala_array_add47 (PinInst*** array, int* length, int* size, PinInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PinInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PinInst** _vala_array_dup41 (PinInst** self, int length) {
	PinInst** result;
	int i;
	result = g_new0 (PinInst*, length + 1);
	for (i = 0; i < length; i++) {
		PinInst* _tmp0_ = NULL;
		_tmp0_ = _pin_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


ComponentInst* component_inst_construct (GType object_type, ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped) {
	ComponentInst* self = NULL;
	ComponentDef* _tmp0_ = NULL;
	ComponentDef* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ComponentDef* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	ComponentDef* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	ComponentDef* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	Direction _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	PinInst** newPinInsts = NULL;
	PinInst** _tmp13_ = NULL;
	gint newPinInsts_length1 = 0;
	gint _newPinInsts_size_ = 0;
	ComponentDef* _tmp14_ = NULL;
	PinDef** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	PinInst** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	PinInst** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	ComponentDef* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	PropertySet* _tmp34_ = NULL;
	ComponentDef* _tmp35_ = NULL;
	g_return_val_if_fail (componentDef != NULL, NULL);
	self = (ComponentInst*) g_type_create_instance (object_type);
	_tmp0_ = componentDef;
	self->componentDef = _tmp0_;
	_tmp1_ = componentDef;
	_tmp2_ = _tmp1_->rightBound;
	self->rightBound = _tmp2_;
	_tmp3_ = componentDef;
	_tmp4_ = _tmp3_->downBound;
	self->downBound = _tmp4_;
	_tmp5_ = componentDef;
	_tmp6_ = _tmp5_->leftBound;
	self->leftBound = _tmp6_;
	_tmp7_ = componentDef;
	_tmp8_ = _tmp7_->upBound;
	self->upBound = _tmp8_;
	_tmp9_ = xPosition;
	self->xPosition = _tmp9_;
	_tmp10_ = yPosition;
	self->yPosition = _tmp10_;
	_tmp11_ = direction;
	self->direction = _tmp11_;
	_tmp12_ = flipped;
	self->flipped = _tmp12_;
	_tmp13_ = g_new0 (PinInst*, 0 + 1);
	newPinInsts = _tmp13_;
	newPinInsts_length1 = 0;
	_newPinInsts_size_ = newPinInsts_length1;
	_tmp14_ = componentDef;
	_tmp15_ = _tmp14_->pinDefs;
	_tmp15__length1 = _tmp14_->pinDefs_length1;
	{
		PinDef** pinDef_collection = NULL;
		gint pinDef_collection_length1 = 0;
		gint _pinDef_collection_size_ = 0;
		gint pinDef_it = 0;
		pinDef_collection = _tmp15_;
		pinDef_collection_length1 = _tmp15__length1;
		for (pinDef_it = 0; pinDef_it < _tmp15__length1; pinDef_it = pinDef_it + 1) {
			PinDef* _tmp16_ = NULL;
			PinDef* pinDef = NULL;
			_tmp16_ = _pin_def_ref0 (pinDef_collection[pinDef_it]);
			pinDef = _tmp16_;
			{
				PinInst* newPinInst = NULL;
				PinDef* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				PinInst** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				PinInst* _tmp26_ = NULL;
				PinInst* _tmp27_ = NULL;
				_tmp17_ = pinDef;
				_tmp18_ = _tmp17_->array;
				if (_tmp18_) {
					PinDef* _tmp19_ = NULL;
					PinDef* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					PinInst* _tmp22_ = NULL;
					_tmp19_ = pinDef;
					_tmp20_ = pinDef;
					_tmp21_ = _tmp20_->defaultArraySize;
					_tmp22_ = pin_inst_new (_tmp19_, _tmp21_);
					_pin_inst_unref0 (newPinInst);
					newPinInst = _tmp22_;
				} else {
					PinDef* _tmp23_ = NULL;
					PinInst* _tmp24_ = NULL;
					_tmp23_ = pinDef;
					_tmp24_ = pin_inst_new (_tmp23_, 1);
					_pin_inst_unref0 (newPinInst);
					newPinInst = _tmp24_;
				}
				_tmp25_ = newPinInsts;
				_tmp25__length1 = newPinInsts_length1;
				_tmp26_ = newPinInst;
				_tmp27_ = _pin_inst_ref0 (_tmp26_);
				_vala_array_add47 (&newPinInsts, &newPinInsts_length1, &_newPinInsts_size_, _tmp27_);
				_pin_inst_unref0 (newPinInst);
				_pin_def_unref0 (pinDef);
			}
		}
	}
	_tmp28_ = newPinInsts;
	_tmp28__length1 = newPinInsts_length1;
	_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup41 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
	_tmp29__length1 = _tmp28__length1;
	self->pinInsts = (_vala_array_free (self->pinInsts, self->pinInsts_length1, (GDestroyNotify) pin_inst_unref), NULL);
	self->pinInsts = _tmp29_;
	self->pinInsts_length1 = _tmp29__length1;
	_tmp30_ = componentDef;
	_tmp31_ = _tmp30_->name;
	_tmp32_ = g_strconcat (_tmp31_, " configuration", NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = property_set_new (_tmp33_, "");
	_property_item_unref0 (self->configuration);
	self->configuration = _tmp34_;
	_g_free0 (_tmp33_);
	_tmp35_ = componentDef;
	component_def_configure_inst (_tmp35_, self, TRUE);
	newPinInsts = (_vala_array_free (newPinInsts, newPinInsts_length1, (GDestroyNotify) pin_inst_unref), NULL);
	return self;
}


ComponentInst* component_inst_new (ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped) {
	return component_inst_construct (TYPE_COMPONENT_INST, componentDef, xPosition, yPosition, direction, flipped);
}


/**
 * Load a component instance from a file using libxml.
 */
static void _vala_array_add48 (PinInst*** array, int* length, int* size, PinInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PinInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PinInst** _vala_array_dup42 (PinInst** self, int length) {
	PinInst** result;
	int i;
	result = g_new0 (PinInst*, length + 1);
	for (i = 0; i < length; i++) {
		PinInst* _tmp0_ = NULL;
		_tmp0_ = _pin_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


ComponentInst* component_inst_construct_load (GType object_type, xmlNode* xmlnode, Project* project, WireInst** newWireInsts, int newWireInsts_length1, GError** error) {
	ComponentInst* self = NULL;
	gchar* defName = NULL;
	gchar* _tmp0_ = NULL;
	ComponentDef* temp = NULL;
	Project* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	ComponentDef* _tmp39_ = NULL;
	ComponentDef* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	ComponentDef* _tmp42_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	self = (ComponentInst*) g_type_create_instance (object_type);
	self->myID = -1;
	_tmp0_ = g_strdup ("");
	defName = _tmp0_;
	self->componentDef = NULL;
	self->xPosition = 0;
	self->yPosition = 0;
	self->direction = DIRECTION_RIGHT;
	self->flipped = FALSE;
	{
		xmlAttr* xmlattr = NULL;
		xmlNode* _tmp1_ = NULL;
		xmlAttr* _tmp2_ = NULL;
		_tmp1_ = xmlnode;
		_tmp2_ = _tmp1_->properties;
		xmlattr = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp6_ = NULL;
				xmlAttr* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				GQuark _tmp11_ = 0U;
				static GQuark _tmp10_label0 = 0;
				static GQuark _tmp10_label1 = 0;
				static GQuark _tmp10_label2 = 0;
				static GQuark _tmp10_label3 = 0;
				static GQuark _tmp10_label4 = 0;
				static GQuark _tmp10_label5 = 0;
				if (!_tmp3_) {
					xmlAttr* _tmp4_ = NULL;
					xmlAttr* _tmp5_ = NULL;
					_tmp4_ = xmlattr;
					_tmp5_ = _tmp4_->next;
					xmlattr = _tmp5_;
				}
				_tmp3_ = FALSE;
				_tmp6_ = xmlattr;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = xmlattr;
				_tmp8_ = _tmp7_->name;
				_tmp9_ = _tmp8_;
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("id")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp12_ = NULL;
							xmlNode* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							gint _tmp15_ = 0;
							_tmp12_ = xmlattr;
							_tmp13_ = _tmp12_->children;
							_tmp14_ = _tmp13_->content;
							_tmp15_ = atoi (_tmp14_);
							self->myID = _tmp15_;
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("def")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp16_ = NULL;
							xmlNode* _tmp17_ = NULL;
							const gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							_tmp16_ = xmlattr;
							_tmp17_ = _tmp16_->children;
							_tmp18_ = _tmp17_->content;
							_tmp19_ = g_strdup (_tmp18_);
							_g_free0 (defName);
							defName = _tmp19_;
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("x")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp20_ = NULL;
							xmlNode* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							_tmp20_ = xmlattr;
							_tmp21_ = _tmp20_->children;
							_tmp22_ = _tmp21_->content;
							_tmp23_ = atoi (_tmp22_);
							self->xPosition = _tmp23_;
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("y")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp24_ = NULL;
							xmlNode* _tmp25_ = NULL;
							const gchar* _tmp26_ = NULL;
							gint _tmp27_ = 0;
							_tmp24_ = xmlattr;
							_tmp25_ = _tmp24_->children;
							_tmp26_ = _tmp25_->content;
							_tmp27_ = atoi (_tmp26_);
							self->yPosition = _tmp27_;
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label4) ? _tmp10_label4 : (_tmp10_label4 = g_quark_from_static_string ("direction")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp28_ = NULL;
							xmlNode* _tmp29_ = NULL;
							const gchar* _tmp30_ = NULL;
							const gchar* _tmp31_ = NULL;
							GQuark _tmp33_ = 0U;
							static GQuark _tmp32_label0 = 0;
							static GQuark _tmp32_label1 = 0;
							static GQuark _tmp32_label2 = 0;
							static GQuark _tmp32_label3 = 0;
							_tmp28_ = xmlattr;
							_tmp29_ = _tmp28_->children;
							_tmp30_ = _tmp29_->content;
							_tmp31_ = _tmp30_;
							_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
							if (_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("right")))) {
								switch (0) {
									default:
									{
										self->direction = DIRECTION_RIGHT;
										break;
									}
								}
							} else if (_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("down")))) {
								switch (0) {
									default:
									{
										self->direction = DIRECTION_DOWN;
										break;
									}
								}
							} else if (_tmp33_ == ((0 != _tmp32_label2) ? _tmp32_label2 : (_tmp32_label2 = g_quark_from_static_string ("left")))) {
								switch (0) {
									default:
									{
										self->direction = DIRECTION_LEFT;
										break;
									}
								}
							} else if (_tmp33_ == ((0 != _tmp32_label3) ? _tmp32_label3 : (_tmp32_label3 = g_quark_from_static_string ("up")))) {
								switch (0) {
									default:
									{
										self->direction = DIRECTION_UP;
										break;
									}
								}
							}
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label5) ? _tmp10_label5 : (_tmp10_label5 = g_quark_from_static_string ("flip")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp34_ = NULL;
							xmlNode* _tmp35_ = NULL;
							const gchar* _tmp36_ = NULL;
							_tmp34_ = xmlattr;
							_tmp35_ = _tmp34_->children;
							_tmp36_ = _tmp35_->content;
							if (g_strcmp0 (_tmp36_, "true") == 0) {
								self->flipped = TRUE;
							}
							break;
						}
					}
				}
			}
		}
	}
	_tmp37_ = project;
	_tmp38_ = defName;
	_tmp39_ = project_resolve_def_name (_tmp37_, _tmp38_);
	temp = G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_COMPONENT_DEF, ComponentDef);
	_tmp40_ = temp;
	self->componentDef = _tmp40_;
	_tmp42_ = self->componentDef;
	if (_tmp42_ != NULL) {
		gint _tmp43_ = 0;
		_tmp43_ = self->myID;
		_tmp41_ = _tmp43_ != (-1);
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		PinInst** newPinInsts = NULL;
		PinInst** _tmp44_ = NULL;
		gint newPinInsts_length1 = 0;
		gint _newPinInsts_size_ = 0;
		ComponentDef* _tmp45_ = NULL;
		PinDef** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		PinInst** _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		PinInst** _tmp60_ = NULL;
		gint _tmp60__length1 = 0;
		ComponentDef* _tmp61_ = NULL;
		xmlNode* _tmp62_ = NULL;
		PropertySet* _tmp63_ = NULL;
		ComponentDef* _tmp253_ = NULL;
		gint _tmp254_ = 0;
		ComponentDef* _tmp255_ = NULL;
		gint _tmp256_ = 0;
		ComponentDef* _tmp257_ = NULL;
		gint _tmp258_ = 0;
		ComponentDef* _tmp259_ = NULL;
		gint _tmp260_ = 0;
		ComponentDef* _tmp261_ = NULL;
		_tmp44_ = g_new0 (PinInst*, 0 + 1);
		newPinInsts = _tmp44_;
		newPinInsts_length1 = 0;
		_newPinInsts_size_ = newPinInsts_length1;
		_tmp45_ = self->componentDef;
		_tmp46_ = _tmp45_->pinDefs;
		_tmp46__length1 = _tmp45_->pinDefs_length1;
		{
			PinDef** pinDef_collection = NULL;
			gint pinDef_collection_length1 = 0;
			gint _pinDef_collection_size_ = 0;
			gint pinDef_it = 0;
			pinDef_collection = _tmp46_;
			pinDef_collection_length1 = _tmp46__length1;
			for (pinDef_it = 0; pinDef_it < _tmp46__length1; pinDef_it = pinDef_it + 1) {
				PinDef* _tmp47_ = NULL;
				PinDef* pinDef = NULL;
				_tmp47_ = _pin_def_ref0 (pinDef_collection[pinDef_it]);
				pinDef = _tmp47_;
				{
					PinInst* newPinInst = NULL;
					PinDef* _tmp48_ = NULL;
					gboolean _tmp49_ = FALSE;
					PinInst** _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					PinInst* _tmp57_ = NULL;
					PinInst* _tmp58_ = NULL;
					_tmp48_ = pinDef;
					_tmp49_ = _tmp48_->array;
					if (_tmp49_) {
						PinDef* _tmp50_ = NULL;
						PinDef* _tmp51_ = NULL;
						gint _tmp52_ = 0;
						PinInst* _tmp53_ = NULL;
						_tmp50_ = pinDef;
						_tmp51_ = pinDef;
						_tmp52_ = _tmp51_->defaultArraySize;
						_tmp53_ = pin_inst_new (_tmp50_, _tmp52_);
						_pin_inst_unref0 (newPinInst);
						newPinInst = _tmp53_;
					} else {
						PinDef* _tmp54_ = NULL;
						PinInst* _tmp55_ = NULL;
						_tmp54_ = pinDef;
						_tmp55_ = pin_inst_new (_tmp54_, 1);
						_pin_inst_unref0 (newPinInst);
						newPinInst = _tmp55_;
					}
					_tmp56_ = newPinInsts;
					_tmp56__length1 = newPinInsts_length1;
					_tmp57_ = newPinInst;
					_tmp58_ = _pin_inst_ref0 (_tmp57_);
					_vala_array_add48 (&newPinInsts, &newPinInsts_length1, &_newPinInsts_size_, _tmp58_);
					_pin_inst_unref0 (newPinInst);
					_pin_def_unref0 (pinDef);
				}
			}
		}
		_tmp59_ = newPinInsts;
		_tmp59__length1 = newPinInsts_length1;
		_tmp60_ = (_tmp59_ != NULL) ? _vala_array_dup42 (_tmp59_, _tmp59__length1) : ((gpointer) _tmp59_);
		_tmp60__length1 = _tmp59__length1;
		self->pinInsts = (_vala_array_free (self->pinInsts, self->pinInsts_length1, (GDestroyNotify) pin_inst_unref), NULL);
		self->pinInsts = _tmp60_;
		self->pinInsts_length1 = _tmp60__length1;
		_tmp61_ = self->componentDef;
		_tmp62_ = xmlnode;
		component_def_load_properties (_tmp61_, _tmp62_, &_tmp63_);
		_property_item_unref0 (self->configuration);
		self->configuration = _tmp63_;
		{
			xmlNode* xmlnodeComponent = NULL;
			xmlNode* _tmp64_ = NULL;
			xmlNode* _tmp65_ = NULL;
			_tmp64_ = xmlnode;
			_tmp65_ = _tmp64_->children;
			xmlnodeComponent = _tmp65_;
			{
				gboolean _tmp66_ = FALSE;
				_tmp66_ = TRUE;
				while (TRUE) {
					xmlNode* _tmp69_ = NULL;
					xmlNode* _tmp70_ = NULL;
					xmlElementType _tmp71_ = 0;
					xmlNode* _tmp72_ = NULL;
					const gchar* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					GQuark _tmp76_ = 0U;
					static GQuark _tmp75_label0 = 0;
					if (!_tmp66_) {
						xmlNode* _tmp67_ = NULL;
						xmlNode* _tmp68_ = NULL;
						_tmp67_ = xmlnodeComponent;
						_tmp68_ = _tmp67_->next;
						xmlnodeComponent = _tmp68_;
					}
					_tmp66_ = FALSE;
					_tmp69_ = xmlnodeComponent;
					if (!(_tmp69_ != NULL)) {
						break;
					}
					_tmp70_ = xmlnodeComponent;
					_tmp71_ = _tmp70_->type;
					if (_tmp71_ != XML_ELEMENT_NODE) {
						continue;
					}
					_tmp72_ = xmlnodeComponent;
					_tmp73_ = _tmp72_->name;
					_tmp74_ = _tmp73_;
					_tmp76_ = (NULL == _tmp74_) ? 0 : g_quark_from_string (_tmp74_);
					if (_tmp76_ == ((0 != _tmp75_label0) ? _tmp75_label0 : (_tmp75_label0 = g_quark_from_static_string ("connection")))) {
						switch (0) {
							default:
							{
								{
									gchar* flow = NULL;
									gchar* _tmp77_ = NULL;
									gint pinid = 0;
									gint wireid = 0;
									gboolean isConnected = FALSE;
									gboolean invert = FALSE;
									gboolean _tmp107_ = FALSE;
									gint _tmp108_ = 0;
									_tmp77_ = g_strdup ("");
									flow = _tmp77_;
									pinid = -1;
									wireid = 0;
									isConnected = FALSE;
									invert = FALSE;
									{
										xmlAttr* xmlattr = NULL;
										xmlNode* _tmp78_ = NULL;
										xmlAttr* _tmp79_ = NULL;
										_tmp78_ = xmlnodeComponent;
										_tmp79_ = _tmp78_->properties;
										xmlattr = _tmp79_;
										{
											gboolean _tmp80_ = FALSE;
											_tmp80_ = TRUE;
											while (TRUE) {
												xmlAttr* _tmp83_ = NULL;
												xmlAttr* _tmp84_ = NULL;
												const gchar* _tmp85_ = NULL;
												const gchar* _tmp86_ = NULL;
												GQuark _tmp88_ = 0U;
												static GQuark _tmp87_label0 = 0;
												static GQuark _tmp87_label1 = 0;
												static GQuark _tmp87_label2 = 0;
												static GQuark _tmp87_label3 = 0;
												if (!_tmp80_) {
													xmlAttr* _tmp81_ = NULL;
													xmlAttr* _tmp82_ = NULL;
													_tmp81_ = xmlattr;
													_tmp82_ = _tmp81_->next;
													xmlattr = _tmp82_;
												}
												_tmp80_ = FALSE;
												_tmp83_ = xmlattr;
												if (!(_tmp83_ != NULL)) {
													break;
												}
												_tmp84_ = xmlattr;
												_tmp85_ = _tmp84_->name;
												_tmp86_ = _tmp85_;
												_tmp88_ = (NULL == _tmp86_) ? 0 : g_quark_from_string (_tmp86_);
												if (_tmp88_ == ((0 != _tmp87_label0) ? _tmp87_label0 : (_tmp87_label0 = g_quark_from_static_string ("flow")))) {
													switch (0) {
														default:
														{
															xmlAttr* _tmp89_ = NULL;
															xmlNode* _tmp90_ = NULL;
															const gchar* _tmp91_ = NULL;
															gchar* _tmp92_ = NULL;
															_tmp89_ = xmlattr;
															_tmp90_ = _tmp89_->children;
															_tmp91_ = _tmp90_->content;
															_tmp92_ = g_strdup (_tmp91_);
															_g_free0 (flow);
															flow = _tmp92_;
															break;
														}
													}
												} else if (_tmp88_ == ((0 != _tmp87_label1) ? _tmp87_label1 : (_tmp87_label1 = g_quark_from_static_string ("pinid")))) {
													switch (0) {
														default:
														{
															xmlAttr* _tmp93_ = NULL;
															xmlNode* _tmp94_ = NULL;
															const gchar* _tmp95_ = NULL;
															gint _tmp96_ = 0;
															_tmp93_ = xmlattr;
															_tmp94_ = _tmp93_->children;
															_tmp95_ = _tmp94_->content;
															_tmp96_ = atoi (_tmp95_);
															pinid = _tmp96_;
															break;
														}
													}
												} else if (_tmp88_ == ((0 != _tmp87_label2) ? _tmp87_label2 : (_tmp87_label2 = g_quark_from_static_string ("wireid")))) {
													switch (0) {
														default:
														{
															xmlAttr* _tmp97_ = NULL;
															xmlNode* _tmp98_ = NULL;
															const gchar* _tmp99_ = NULL;
															_tmp97_ = xmlattr;
															_tmp98_ = _tmp97_->children;
															_tmp99_ = _tmp98_->content;
															if (g_strcmp0 (_tmp99_, "null") != 0) {
																xmlAttr* _tmp100_ = NULL;
																xmlNode* _tmp101_ = NULL;
																const gchar* _tmp102_ = NULL;
																gint _tmp103_ = 0;
																_tmp100_ = xmlattr;
																_tmp101_ = _tmp100_->children;
																_tmp102_ = _tmp101_->content;
																_tmp103_ = atoi (_tmp102_);
																wireid = _tmp103_;
																isConnected = TRUE;
															}
															break;
														}
													}
												} else if (_tmp88_ == ((0 != _tmp87_label3) ? _tmp87_label3 : (_tmp87_label3 = g_quark_from_static_string ("invert")))) {
													switch (0) {
														default:
														{
															xmlAttr* _tmp104_ = NULL;
															xmlNode* _tmp105_ = NULL;
															const gchar* _tmp106_ = NULL;
															_tmp104_ = xmlattr;
															_tmp105_ = _tmp104_->children;
															_tmp106_ = _tmp105_->content;
															if (g_strcmp0 (_tmp106_, "true") == 0) {
																invert = TRUE;
															}
															break;
														}
													}
												}
											}
										}
									}
									_tmp108_ = pinid;
									if (_tmp108_ >= 0) {
										gint _tmp109_ = 0;
										ComponentDef* _tmp110_ = NULL;
										PinDef** _tmp111_ = NULL;
										gint _tmp111__length1 = 0;
										_tmp109_ = pinid;
										_tmp110_ = self->componentDef;
										_tmp111_ = _tmp110_->pinDefs;
										_tmp111__length1 = _tmp110_->pinDefs_length1;
										_tmp107_ = _tmp109_ < _tmp111__length1;
									} else {
										_tmp107_ = FALSE;
									}
									if (_tmp107_) {
										ComponentDef* _tmp112_ = NULL;
										PinDef** _tmp113_ = NULL;
										gint _tmp113__length1 = 0;
										gint _tmp114_ = 0;
										PinDef* _tmp115_ = NULL;
										gboolean _tmp116_ = FALSE;
										_tmp112_ = self->componentDef;
										_tmp113_ = _tmp112_->pinDefs;
										_tmp113__length1 = _tmp112_->pinDefs_length1;
										_tmp114_ = pinid;
										_tmp115_ = _tmp113_[_tmp114_];
										_tmp116_ = _tmp115_->array;
										if (_tmp116_) {
											PinInst** _tmp117_ = NULL;
											gint _tmp117__length1 = 0;
											gint _tmp118_ = 0;
											ComponentDef* _tmp119_ = NULL;
											PinDef** _tmp120_ = NULL;
											gint _tmp120__length1 = 0;
											gint _tmp121_ = 0;
											PinDef* _tmp122_ = NULL;
											PinInst* _tmp123_ = NULL;
											PinInst* _tmp124_ = NULL;
											_tmp117_ = self->pinInsts;
											_tmp117__length1 = self->pinInsts_length1;
											_tmp118_ = pinid;
											_tmp119_ = self->componentDef;
											_tmp120_ = _tmp119_->pinDefs;
											_tmp120__length1 = _tmp119_->pinDefs_length1;
											_tmp121_ = pinid;
											_tmp122_ = _tmp120_[_tmp121_];
											_tmp123_ = pin_inst_new (_tmp122_, 0);
											_pin_inst_unref0 (_tmp117_[_tmp118_]);
											_tmp117_[_tmp118_] = _tmp123_;
											_tmp124_ = _tmp117_[_tmp118_];
											{
												xmlNode* xmlnodeConnection = NULL;
												xmlNode* _tmp125_ = NULL;
												xmlNode* _tmp126_ = NULL;
												_tmp125_ = xmlnodeComponent;
												_tmp126_ = _tmp125_->children;
												xmlnodeConnection = _tmp126_;
												{
													gboolean _tmp127_ = FALSE;
													_tmp127_ = TRUE;
													while (TRUE) {
														xmlNode* _tmp130_ = NULL;
														xmlNode* _tmp131_ = NULL;
														xmlElementType _tmp132_ = 0;
														xmlNode* _tmp133_ = NULL;
														const gchar* _tmp134_ = NULL;
														const gchar* _tmp135_ = NULL;
														GQuark _tmp137_ = 0U;
														static GQuark _tmp136_label0 = 0;
														if (!_tmp127_) {
															xmlNode* _tmp128_ = NULL;
															xmlNode* _tmp129_ = NULL;
															_tmp128_ = xmlnodeConnection;
															_tmp129_ = _tmp128_->next;
															xmlnodeConnection = _tmp129_;
														}
														_tmp127_ = FALSE;
														_tmp130_ = xmlnodeConnection;
														if (!(_tmp130_ != NULL)) {
															break;
														}
														_tmp131_ = xmlnodeConnection;
														_tmp132_ = _tmp131_->type;
														if (_tmp132_ != XML_ELEMENT_NODE) {
															continue;
														}
														_tmp133_ = xmlnodeConnection;
														_tmp134_ = _tmp133_->name;
														_tmp135_ = _tmp134_;
														_tmp137_ = (NULL == _tmp135_) ? 0 : g_quark_from_string (_tmp135_);
														if (_tmp137_ == ((0 != _tmp136_label0) ? _tmp136_label0 : (_tmp136_label0 = g_quark_from_static_string ("subpin")))) {
															switch (0) {
																default:
																{
																	{
																		gint i = 0;
																		PinInst** _tmp159_ = NULL;
																		gint _tmp159__length1 = 0;
																		gint _tmp160_ = 0;
																		PinInst* _tmp161_ = NULL;
																		gint _tmp162_ = 0;
																		gboolean _tmp163_ = FALSE;
																		PinInst** _tmp178_ = NULL;
																		gint _tmp178__length1 = 0;
																		gint _tmp179_ = 0;
																		PinInst* _tmp180_ = NULL;
																		gboolean* _tmp181_ = NULL;
																		gint _tmp181__length1 = 0;
																		gint _tmp182_ = 0;
																		gboolean _tmp183_ = FALSE;
																		gboolean _tmp184_ = FALSE;
																		wireid = 0;
																		invert = FALSE;
																		isConnected = FALSE;
																		{
																			xmlAttr* xmlattr = NULL;
																			xmlNode* _tmp138_ = NULL;
																			xmlAttr* _tmp139_ = NULL;
																			_tmp138_ = xmlnodeConnection;
																			_tmp139_ = _tmp138_->properties;
																			xmlattr = _tmp139_;
																			{
																				gboolean _tmp140_ = FALSE;
																				_tmp140_ = TRUE;
																				while (TRUE) {
																					xmlAttr* _tmp143_ = NULL;
																					xmlAttr* _tmp144_ = NULL;
																					const gchar* _tmp145_ = NULL;
																					const gchar* _tmp146_ = NULL;
																					GQuark _tmp148_ = 0U;
																					static GQuark _tmp147_label0 = 0;
																					static GQuark _tmp147_label1 = 0;
																					if (!_tmp140_) {
																						xmlAttr* _tmp141_ = NULL;
																						xmlAttr* _tmp142_ = NULL;
																						_tmp141_ = xmlattr;
																						_tmp142_ = _tmp141_->next;
																						xmlattr = _tmp142_;
																					}
																					_tmp140_ = FALSE;
																					_tmp143_ = xmlattr;
																					if (!(_tmp143_ != NULL)) {
																						break;
																					}
																					_tmp144_ = xmlattr;
																					_tmp145_ = _tmp144_->name;
																					_tmp146_ = _tmp145_;
																					_tmp148_ = (NULL == _tmp146_) ? 0 : g_quark_from_string (_tmp146_);
																					if (_tmp148_ == ((0 != _tmp147_label0) ? _tmp147_label0 : (_tmp147_label0 = g_quark_from_static_string ("wireid")))) {
																						switch (0) {
																							default:
																							{
																								xmlAttr* _tmp149_ = NULL;
																								xmlNode* _tmp150_ = NULL;
																								const gchar* _tmp151_ = NULL;
																								_tmp149_ = xmlattr;
																								_tmp150_ = _tmp149_->children;
																								_tmp151_ = _tmp150_->content;
																								if (g_strcmp0 (_tmp151_, "null") != 0) {
																									xmlAttr* _tmp152_ = NULL;
																									xmlNode* _tmp153_ = NULL;
																									const gchar* _tmp154_ = NULL;
																									gint _tmp155_ = 0;
																									_tmp152_ = xmlattr;
																									_tmp153_ = _tmp152_->children;
																									_tmp154_ = _tmp153_->content;
																									_tmp155_ = atoi (_tmp154_);
																									wireid = _tmp155_;
																									isConnected = TRUE;
																								}
																								break;
																							}
																						}
																					} else if (_tmp148_ == ((0 != _tmp147_label1) ? _tmp147_label1 : (_tmp147_label1 = g_quark_from_static_string ("invert")))) {
																						switch (0) {
																							default:
																							{
																								xmlAttr* _tmp156_ = NULL;
																								xmlNode* _tmp157_ = NULL;
																								const gchar* _tmp158_ = NULL;
																								_tmp156_ = xmlattr;
																								_tmp157_ = _tmp156_->children;
																								_tmp158_ = _tmp157_->content;
																								if (g_strcmp0 (_tmp158_, "true") == 0) {
																									invert = TRUE;
																								}
																								break;
																							}
																						}
																					}
																				}
																			}
																		}
																		_tmp159_ = self->pinInsts;
																		_tmp159__length1 = self->pinInsts_length1;
																		_tmp160_ = pinid;
																		_tmp161_ = _tmp159_[_tmp160_];
																		_tmp162_ = pin_inst_append (_tmp161_);
																		i = _tmp162_;
																		_tmp163_ = isConnected;
																		if (_tmp163_) {
																			WireInst* wireInst = NULL;
																			WireInst** _tmp164_ = NULL;
																			gint _tmp164__length1 = 0;
																			gint _tmp165_ = 0;
																			WireInst* _tmp166_ = NULL;
																			WireInst* _tmp167_ = NULL;
																			_tmp164_ = newWireInsts;
																			_tmp164__length1 = newWireInsts_length1;
																			_tmp165_ = wireid;
																			_tmp166_ = component_inst_resolve_wire_id (self, _tmp164_, _tmp164__length1, _tmp165_);
																			wireInst = _tmp166_;
																			_tmp167_ = wireInst;
																			if (_tmp167_ != NULL) {
																				PinInst** _tmp168_ = NULL;
																				gint _tmp168__length1 = 0;
																				gint _tmp169_ = 0;
																				PinInst* _tmp170_ = NULL;
																				WireInst** _tmp171_ = NULL;
																				gint _tmp171__length1 = 0;
																				gint _tmp172_ = 0;
																				WireInst* _tmp173_ = NULL;
																				WireInst* _tmp174_ = NULL;
																				WireInst* _tmp175_ = NULL;
																				_tmp168_ = self->pinInsts;
																				_tmp168__length1 = self->pinInsts_length1;
																				_tmp169_ = pinid;
																				_tmp170_ = _tmp168_[_tmp169_];
																				_tmp171_ = _tmp170_->wireInsts;
																				_tmp171__length1 = _tmp170_->wireInsts_length1;
																				_tmp172_ = i;
																				_tmp173_ = wireInst;
																				_tmp174_ = _wire_inst_ref0 (_tmp173_);
																				_wire_inst_unref0 (_tmp171_[_tmp172_]);
																				_tmp171_[_tmp172_] = _tmp174_;
																				_tmp175_ = _tmp171_[_tmp172_];
																			} else {
																				FILE* _tmp176_ = NULL;
																				gint _tmp177_ = 0;
																				_tmp176_ = stderr;
																				_tmp177_ = wireid;
																				fprintf (_tmp176_, "Error: Missing wire %i\n", _tmp177_);
																			}
																			_wire_inst_unref0 (wireInst);
																		}
																		_tmp178_ = self->pinInsts;
																		_tmp178__length1 = self->pinInsts_length1;
																		_tmp179_ = pinid;
																		_tmp180_ = _tmp178_[_tmp179_];
																		_tmp181_ = _tmp180_->invert;
																		_tmp181__length1 = _tmp180_->invert_length1;
																		_tmp182_ = i;
																		_tmp183_ = invert;
																		_tmp181_[_tmp182_] = _tmp183_;
																		_tmp184_ = _tmp181_[_tmp182_];
																	}
																	break;
																}
															}
														}
													}
												}
											}
											{
												gint i = 0;
												i = 0;
												{
													gboolean _tmp185_ = FALSE;
													_tmp185_ = TRUE;
													while (TRUE) {
														gint _tmp187_ = 0;
														PinInst** _tmp188_ = NULL;
														gint _tmp188__length1 = 0;
														gint _tmp189_ = 0;
														PinInst* _tmp190_ = NULL;
														gint _tmp191_ = 0;
														WireInst* wireInst = NULL;
														PinInst** _tmp192_ = NULL;
														gint _tmp192__length1 = 0;
														gint _tmp193_ = 0;
														PinInst* _tmp194_ = NULL;
														WireInst** _tmp195_ = NULL;
														gint _tmp195__length1 = 0;
														gint _tmp196_ = 0;
														WireInst* _tmp197_ = NULL;
														WireInst* _tmp198_ = NULL;
														WireInst* _tmp199_ = NULL;
														if (!_tmp185_) {
															gint _tmp186_ = 0;
															_tmp186_ = i;
															i = _tmp186_ + 1;
														}
														_tmp185_ = FALSE;
														_tmp187_ = i;
														_tmp188_ = self->pinInsts;
														_tmp188__length1 = self->pinInsts_length1;
														_tmp189_ = pinid;
														_tmp190_ = _tmp188_[_tmp189_];
														_tmp191_ = _tmp190_->arraySize;
														if (!(_tmp187_ < _tmp191_)) {
															break;
														}
														_tmp192_ = self->pinInsts;
														_tmp192__length1 = self->pinInsts_length1;
														_tmp193_ = pinid;
														_tmp194_ = _tmp192_[_tmp193_];
														_tmp195_ = _tmp194_->wireInsts;
														_tmp195__length1 = _tmp194_->wireInsts_length1;
														_tmp196_ = i;
														_tmp197_ = _tmp195_[_tmp196_];
														_tmp198_ = _wire_inst_ref0 (_tmp197_);
														wireInst = _tmp198_;
														_tmp199_ = wireInst;
														if (_tmp199_ != NULL) {
															gint xAbsolute = 0;
															gint yAbsolute = 0;
															PinInst** _tmp200_ = NULL;
															gint _tmp200__length1 = 0;
															gint _tmp201_ = 0;
															PinInst* _tmp202_ = NULL;
															gint* _tmp203_ = NULL;
															gint _tmp203__length1 = 0;
															gint _tmp204_ = 0;
															gint _tmp205_ = 0;
															PinInst** _tmp206_ = NULL;
															gint _tmp206__length1 = 0;
															gint _tmp207_ = 0;
															PinInst* _tmp208_ = NULL;
															gint* _tmp209_ = NULL;
															gint _tmp209__length1 = 0;
															gint _tmp210_ = 0;
															gint _tmp211_ = 0;
															gint _tmp212_ = 0;
															gint _tmp213_ = 0;
															WireInst* _tmp214_ = NULL;
															gint _tmp215_ = 0;
															gint _tmp216_ = 0;
															_tmp200_ = self->pinInsts;
															_tmp200__length1 = self->pinInsts_length1;
															_tmp201_ = pinid;
															_tmp202_ = _tmp200_[_tmp201_];
															_tmp203_ = _tmp202_->xConnect;
															_tmp203__length1 = _tmp202_->xConnect_length1;
															_tmp204_ = i;
															_tmp205_ = _tmp203_[_tmp204_];
															_tmp206_ = self->pinInsts;
															_tmp206__length1 = self->pinInsts_length1;
															_tmp207_ = pinid;
															_tmp208_ = _tmp206_[_tmp207_];
															_tmp209_ = _tmp208_->yConnect;
															_tmp209__length1 = _tmp208_->yConnect_length1;
															_tmp210_ = i;
															_tmp211_ = _tmp209_[_tmp210_];
															component_inst_absolute_position (self, _tmp205_, _tmp211_, &_tmp212_, &_tmp213_);
															xAbsolute = _tmp212_;
															yAbsolute = _tmp213_;
															_tmp214_ = wireInst;
															_tmp215_ = xAbsolute;
															_tmp216_ = yAbsolute;
															wire_inst_register_component (_tmp214_, self, _tmp215_, _tmp216_);
														}
														_wire_inst_unref0 (wireInst);
													}
												}
											}
										} else {
											gboolean _tmp217_ = FALSE;
											PinInst** _tmp246_ = NULL;
											gint _tmp246__length1 = 0;
											gint _tmp247_ = 0;
											PinInst* _tmp248_ = NULL;
											gboolean* _tmp249_ = NULL;
											gint _tmp249__length1 = 0;
											gboolean _tmp250_ = FALSE;
											gboolean _tmp251_ = FALSE;
											_tmp217_ = isConnected;
											if (_tmp217_) {
												WireInst* wireInst = NULL;
												WireInst** _tmp218_ = NULL;
												gint _tmp218__length1 = 0;
												gint _tmp219_ = 0;
												WireInst* _tmp220_ = NULL;
												WireInst* _tmp221_ = NULL;
												_tmp218_ = newWireInsts;
												_tmp218__length1 = newWireInsts_length1;
												_tmp219_ = wireid;
												_tmp220_ = component_inst_resolve_wire_id (self, _tmp218_, _tmp218__length1, _tmp219_);
												wireInst = _tmp220_;
												_tmp221_ = wireInst;
												if (_tmp221_ != NULL) {
													PinInst** _tmp222_ = NULL;
													gint _tmp222__length1 = 0;
													gint _tmp223_ = 0;
													PinInst* _tmp224_ = NULL;
													WireInst** _tmp225_ = NULL;
													gint _tmp225__length1 = 0;
													WireInst* _tmp226_ = NULL;
													WireInst* _tmp227_ = NULL;
													WireInst* _tmp228_ = NULL;
													gint xAbsolute = 0;
													gint yAbsolute = 0;
													PinInst** _tmp229_ = NULL;
													gint _tmp229__length1 = 0;
													gint _tmp230_ = 0;
													PinInst* _tmp231_ = NULL;
													gint* _tmp232_ = NULL;
													gint _tmp232__length1 = 0;
													gint _tmp233_ = 0;
													PinInst** _tmp234_ = NULL;
													gint _tmp234__length1 = 0;
													gint _tmp235_ = 0;
													PinInst* _tmp236_ = NULL;
													gint* _tmp237_ = NULL;
													gint _tmp237__length1 = 0;
													gint _tmp238_ = 0;
													gint _tmp239_ = 0;
													gint _tmp240_ = 0;
													WireInst* _tmp241_ = NULL;
													gint _tmp242_ = 0;
													gint _tmp243_ = 0;
													_tmp222_ = self->pinInsts;
													_tmp222__length1 = self->pinInsts_length1;
													_tmp223_ = pinid;
													_tmp224_ = _tmp222_[_tmp223_];
													_tmp225_ = _tmp224_->wireInsts;
													_tmp225__length1 = _tmp224_->wireInsts_length1;
													_tmp226_ = wireInst;
													_tmp227_ = _wire_inst_ref0 (_tmp226_);
													_wire_inst_unref0 (_tmp225_[0]);
													_tmp225_[0] = _tmp227_;
													_tmp228_ = _tmp225_[0];
													_tmp229_ = self->pinInsts;
													_tmp229__length1 = self->pinInsts_length1;
													_tmp230_ = pinid;
													_tmp231_ = _tmp229_[_tmp230_];
													_tmp232_ = _tmp231_->xConnect;
													_tmp232__length1 = _tmp231_->xConnect_length1;
													_tmp233_ = _tmp232_[0];
													_tmp234_ = self->pinInsts;
													_tmp234__length1 = self->pinInsts_length1;
													_tmp235_ = pinid;
													_tmp236_ = _tmp234_[_tmp235_];
													_tmp237_ = _tmp236_->yConnect;
													_tmp237__length1 = _tmp236_->yConnect_length1;
													_tmp238_ = _tmp237_[0];
													component_inst_absolute_position (self, _tmp233_, _tmp238_, &_tmp239_, &_tmp240_);
													xAbsolute = _tmp239_;
													yAbsolute = _tmp240_;
													_tmp241_ = wireInst;
													_tmp242_ = xAbsolute;
													_tmp243_ = yAbsolute;
													wire_inst_register_component (_tmp241_, self, _tmp242_, _tmp243_);
												} else {
													FILE* _tmp244_ = NULL;
													gint _tmp245_ = 0;
													_tmp244_ = stderr;
													_tmp245_ = wireid;
													fprintf (_tmp244_, "Error: Missing wire %i\n", _tmp245_);
												}
												_wire_inst_unref0 (wireInst);
											}
											_tmp246_ = self->pinInsts;
											_tmp246__length1 = self->pinInsts_length1;
											_tmp247_ = pinid;
											_tmp248_ = _tmp246_[_tmp247_];
											_tmp249_ = _tmp248_->invert;
											_tmp249__length1 = _tmp248_->invert_length1;
											_tmp250_ = invert;
											_tmp249_[0] = _tmp250_;
											_tmp251_ = _tmp249_[0];
										}
									} else {
										FILE* _tmp252_ = NULL;
										_tmp252_ = stderr;
										fprintf (_tmp252_, "Error: Pin is not within range or is not set\n");
									}
									_g_free0 (flow);
								}
								break;
							}
						}
					}
				}
			}
		}
		_tmp253_ = self->componentDef;
		_tmp254_ = _tmp253_->rightBound;
		self->rightBound = _tmp254_;
		_tmp255_ = self->componentDef;
		_tmp256_ = _tmp255_->downBound;
		self->downBound = _tmp256_;
		_tmp257_ = self->componentDef;
		_tmp258_ = _tmp257_->leftBound;
		self->leftBound = _tmp258_;
		_tmp259_ = self->componentDef;
		_tmp260_ = _tmp259_->upBound;
		self->upBound = _tmp260_;
		_tmp261_ = self->componentDef;
		component_def_configure_inst (_tmp261_, self, TRUE);
		newPinInsts = (_vala_array_free (newPinInsts, newPinInsts_length1, (GDestroyNotify) pin_inst_unref), NULL);
	} else {
		ComponentDef* _tmp262_ = NULL;
		_tmp262_ = self->componentDef;
		if (_tmp262_ == NULL) {
			const gchar* _tmp263_ = NULL;
			gchar* _tmp264_ = NULL;
			gchar* _tmp265_ = NULL;
			gchar* _tmp266_ = NULL;
			gchar* _tmp267_ = NULL;
			GError* _tmp268_ = NULL;
			GError* _tmp269_ = NULL;
			_tmp263_ = defName;
			_tmp264_ = g_strconcat ("Failed to load due to a missing sub component: \"", _tmp263_, NULL);
			_tmp265_ = _tmp264_;
			_tmp266_ = g_strconcat (_tmp265_, "\"", NULL);
			_tmp267_ = _tmp266_;
			_tmp268_ = g_error_new_literal (COMPONENT_INST_LOAD_ERROR, COMPONENT_INST_LOAD_ERROR_MISSING_DEF, _tmp267_);
			_tmp269_ = _tmp268_;
			_g_free0 (_tmp267_);
			_g_free0 (_tmp265_);
			_inner_error_ = _tmp269_;
			if ((_inner_error_->domain == COMPONENT_INST_LOAD_ERROR) || (_inner_error_->domain == COMPONENT_INST_LOAD_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_component_def_unref0 (temp);
				_g_free0 (defName);
				_component_inst_unref0 (self);
				return NULL;
			} else {
				_component_def_unref0 (temp);
				_g_free0 (defName);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			GError* _tmp270_ = NULL;
			_tmp270_ = g_error_new_literal (COMPONENT_INST_LOAD_ERROR, COMPONENT_INST_LOAD_ERROR_INVALID, "Missing critical data on component XML tag. Must have valid id attribu" \
"te.");
			_inner_error_ = _tmp270_;
			if ((_inner_error_->domain == COMPONENT_INST_LOAD_ERROR) || (_inner_error_->domain == COMPONENT_INST_LOAD_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_component_def_unref0 (temp);
				_g_free0 (defName);
				_component_inst_unref0 (self);
				return NULL;
			} else {
				_component_def_unref0 (temp);
				_g_free0 (defName);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_component_def_unref0 (temp);
	_g_free0 (defName);
	return self;
}


ComponentInst* component_inst_new_load (xmlNode* xmlnode, Project* project, WireInst** newWireInsts, int newWireInsts_length1, GError** error) {
	return component_inst_construct_load (TYPE_COMPONENT_INST, xmlnode, project, newWireInsts, newWireInsts_length1, error);
}


void component_inst_absolute_bounds (ComponentInst* self, gint* right, gint* down, gint* left, gint* up) {
	gint _vala_right = 0;
	gint _vala_down = 0;
	gint _vala_left = 0;
	gint _vala_up = 0;
	gint rightBound = 0;
	gint _tmp0_ = 0;
	gint leftBound = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gint downBound = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gint upBound = 0;
	Direction _tmp10_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rightBound;
	rightBound = _tmp0_;
	_tmp1_ = self->leftBound;
	leftBound = _tmp1_;
	_tmp3_ = self->flipped;
	if (_tmp3_) {
		gint _tmp4_ = 0;
		_tmp4_ = self->upBound;
		_tmp2_ = _tmp4_;
	} else {
		gint _tmp5_ = 0;
		_tmp5_ = self->downBound;
		_tmp2_ = _tmp5_;
	}
	downBound = _tmp2_;
	_tmp7_ = self->flipped;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		_tmp8_ = self->downBound;
		_tmp6_ = _tmp8_;
	} else {
		gint _tmp9_ = 0;
		_tmp9_ = self->upBound;
		_tmp6_ = _tmp9_;
	}
	upBound = _tmp6_;
	_tmp10_ = self->direction;
	switch (_tmp10_) {
		case DIRECTION_RIGHT:
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp11_ = rightBound;
			_vala_right = _tmp11_;
			_tmp12_ = downBound;
			_vala_down = _tmp12_;
			_tmp13_ = leftBound;
			_vala_left = _tmp13_;
			_tmp14_ = upBound;
			_vala_up = _tmp14_;
			break;
		}
		case DIRECTION_DOWN:
		{
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			_tmp15_ = rightBound;
			_vala_down = _tmp15_;
			_tmp16_ = downBound;
			_vala_left = -_tmp16_;
			_tmp17_ = leftBound;
			_vala_up = _tmp17_;
			_tmp18_ = upBound;
			_vala_right = -_tmp18_;
			break;
		}
		case DIRECTION_LEFT:
		{
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			_tmp19_ = rightBound;
			_vala_left = -_tmp19_;
			_tmp20_ = downBound;
			_vala_up = -_tmp20_;
			_tmp21_ = leftBound;
			_vala_right = -_tmp21_;
			_tmp22_ = upBound;
			_vala_down = -_tmp22_;
			break;
		}
		case DIRECTION_UP:
		{
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			_tmp23_ = rightBound;
			_vala_up = -_tmp23_;
			_tmp24_ = downBound;
			_vala_right = _tmp24_;
			_tmp25_ = leftBound;
			_vala_down = -_tmp25_;
			_tmp26_ = upBound;
			_vala_left = _tmp26_;
			break;
		}
		default:
		{
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			_tmp27_ = rightBound;
			_vala_right = _tmp27_;
			_tmp28_ = downBound;
			_vala_down = _tmp28_;
			_tmp29_ = leftBound;
			_vala_left = _tmp29_;
			_tmp30_ = upBound;
			_vala_up = _tmp30_;
			break;
		}
	}
	_tmp31_ = _vala_right;
	_tmp32_ = self->xPosition;
	_vala_right = _tmp31_ + _tmp32_;
	_tmp33_ = _vala_down;
	_tmp34_ = self->yPosition;
	_vala_down = _tmp33_ + _tmp34_;
	_tmp35_ = _vala_left;
	_tmp36_ = self->xPosition;
	_vala_left = _tmp35_ + _tmp36_;
	_tmp37_ = _vala_up;
	_tmp38_ = self->yPosition;
	_vala_up = _tmp37_ + _tmp38_;
	if (right) {
		*right = _vala_right;
	}
	if (down) {
		*down = _vala_down;
	}
	if (left) {
		*left = _vala_left;
	}
	if (up) {
		*up = _vala_up;
	}
}


/**
 * Finds a WireInst within an array of WireInsts with a given ID.
 */
static WireInst* component_inst_resolve_wire_id (ComponentInst* self, WireInst** anyWireInsts, int anyWireInsts_length1, gint wireid) {
	WireInst* result = NULL;
	WireInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = anyWireInsts;
	_tmp0__length1 = anyWireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp0_;
		wireInst_collection_length1 = _tmp0__length1;
		for (wireInst_it = 0; wireInst_it < _tmp0__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp1_ = NULL;
			WireInst* wireInst = NULL;
			_tmp1_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp1_;
			{
				WireInst* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				_tmp2_ = wireInst;
				_tmp3_ = _tmp2_->myID;
				_tmp4_ = wireid;
				if (_tmp3_ == _tmp4_) {
					result = wireInst;
					return result;
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * Converts an absolute position within the circuit design to a
 * position which is relative to the instance.
 */
void component_inst_relative_position (ComponentInst* self, gint xRaw, gint yRaw, gint* xRelative, gint* yRelative) {
	gint _vala_xRelative = 0;
	gint _vala_yRelative = 0;
	gint xHalfRelative = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint yHalfRelative = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Direction _tmp4_ = 0;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = xRaw;
	_tmp1_ = self->xPosition;
	xHalfRelative = _tmp0_ - _tmp1_;
	_tmp2_ = yRaw;
	_tmp3_ = self->yPosition;
	yHalfRelative = _tmp2_ - _tmp3_;
	_tmp4_ = self->direction;
	switch (_tmp4_) {
		case DIRECTION_RIGHT:
		{
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			_tmp5_ = xHalfRelative;
			_vala_xRelative = _tmp5_;
			_tmp6_ = yHalfRelative;
			_vala_yRelative = _tmp6_;
			break;
		}
		case DIRECTION_DOWN:
		{
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			_tmp7_ = yHalfRelative;
			_vala_xRelative = _tmp7_;
			_tmp8_ = xHalfRelative;
			_vala_yRelative = -_tmp8_;
			break;
		}
		case DIRECTION_LEFT:
		{
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			_tmp9_ = xHalfRelative;
			_vala_xRelative = -_tmp9_;
			_tmp10_ = yHalfRelative;
			_vala_yRelative = -_tmp10_;
			break;
		}
		case DIRECTION_UP:
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp11_ = yHalfRelative;
			_vala_xRelative = -_tmp11_;
			_tmp12_ = xHalfRelative;
			_vala_yRelative = _tmp12_;
			break;
		}
		default:
		{
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp13_ = xHalfRelative;
			_vala_xRelative = _tmp13_;
			_tmp14_ = yHalfRelative;
			_vala_yRelative = _tmp14_;
			break;
		}
	}
	_tmp15_ = self->flipped;
	if (_tmp15_) {
		gint _tmp16_ = 0;
		_tmp16_ = _vala_yRelative;
		_vala_yRelative = -_tmp16_;
	}
	if (xRelative) {
		*xRelative = _vala_xRelative;
	}
	if (yRelative) {
		*yRelative = _vala_yRelative;
	}
}


/**
 * Converts a position which is relative to the instance to an
 * absolute position within the circuit design.
 */
void component_inst_absolute_position (ComponentInst* self, gint xRelative, gint yRelative, gint* xRaw, gint* yRaw) {
	gint _vala_xRaw = 0;
	gint _vala_yRaw = 0;
	gint xHalfRelative = 0;
	gint yHalfRelative = 0;
	gboolean _tmp0_ = FALSE;
	Direction _tmp2_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->flipped;
	if (_tmp0_) {
		gint _tmp1_ = 0;
		_tmp1_ = yRelative;
		yRelative = -_tmp1_;
	}
	_tmp2_ = self->direction;
	switch (_tmp2_) {
		case DIRECTION_RIGHT:
		{
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			_tmp3_ = xRelative;
			xHalfRelative = _tmp3_;
			_tmp4_ = yRelative;
			yHalfRelative = _tmp4_;
			break;
		}
		case DIRECTION_DOWN:
		{
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			_tmp5_ = yRelative;
			xHalfRelative = -_tmp5_;
			_tmp6_ = xRelative;
			yHalfRelative = _tmp6_;
			break;
		}
		case DIRECTION_LEFT:
		{
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			_tmp7_ = xRelative;
			xHalfRelative = -_tmp7_;
			_tmp8_ = yRelative;
			yHalfRelative = -_tmp8_;
			break;
		}
		case DIRECTION_UP:
		{
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			_tmp9_ = yRelative;
			xHalfRelative = _tmp9_;
			_tmp10_ = xRelative;
			yHalfRelative = -_tmp10_;
			break;
		}
		default:
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp11_ = xRelative;
			xHalfRelative = _tmp11_;
			_tmp12_ = yRelative;
			yHalfRelative = _tmp12_;
			break;
		}
	}
	_tmp13_ = xHalfRelative;
	_tmp14_ = self->xPosition;
	_vala_xRaw = _tmp13_ + _tmp14_;
	_tmp15_ = yHalfRelative;
	_tmp16_ = self->yPosition;
	_vala_yRaw = _tmp15_ + _tmp16_;
	if (xRaw) {
		*xRaw = _vala_xRaw;
	}
	if (yRaw) {
		*yRaw = _vala_yRaw;
	}
}


/**
 * If a pin end is at (//x//, //y//) then toggle its invert.
 */
void component_inst_try_invert (ComponentInst* self, gint x, gint y) {
	gint xRelative = 0;
	gint yRelative = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	PinInst** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	component_inst_relative_position (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
	xRelative = _tmp2_;
	yRelative = _tmp3_;
	_tmp4_ = self->pinInsts;
	_tmp4__length1 = self->pinInsts_length1;
	{
		PinInst** pinInst_collection = NULL;
		gint pinInst_collection_length1 = 0;
		gint _pinInst_collection_size_ = 0;
		gint pinInst_it = 0;
		pinInst_collection = _tmp4_;
		pinInst_collection_length1 = _tmp4__length1;
		for (pinInst_it = 0; pinInst_it < _tmp4__length1; pinInst_it = pinInst_it + 1) {
			PinInst* _tmp5_ = NULL;
			PinInst* pinInst = NULL;
			_tmp5_ = _pin_inst_ref0 (pinInst_collection[pinInst_it]);
			pinInst = _tmp5_;
			{
				PinInst* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				_tmp6_ = pinInst;
				_tmp7_ = xRelative;
				_tmp8_ = yRelative;
				pin_inst_try_invert (_tmp6_, _tmp7_, _tmp8_);
				_pin_inst_unref0 (pinInst);
			}
		}
	}
}


/**
 * Selects if the ComponentInst is on the point (//x//, //y//), else
 * it deselects.
 * If //toggle// is true, it toggles if on (//x//, //y//) instead.
 */
void component_inst_try_select (ComponentInst* self, gint x, gint y, gboolean toggle) {
	gint xRelative = 0;
	gint yRelative = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean affect = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	component_inst_relative_position (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
	xRelative = _tmp2_;
	yRelative = _tmp3_;
	_tmp7_ = xRelative;
	_tmp8_ = self->leftBound;
	if (_tmp7_ >= _tmp8_) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp9_ = xRelative;
		_tmp10_ = self->rightBound;
		_tmp6_ = _tmp9_ <= _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp11_ = yRelative;
		_tmp12_ = self->upBound;
		_tmp5_ = _tmp11_ >= _tmp12_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp13_ = yRelative;
		_tmp14_ = self->downBound;
		_tmp4_ = _tmp13_ <= _tmp14_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		affect = TRUE;
	} else {
		affect = FALSE;
	}
	_tmp15_ = toggle;
	if (_tmp15_) {
		gboolean _tmp16_ = FALSE;
		_tmp16_ = affect;
		if (_tmp16_) {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			_tmp18_ = self->selected;
			if (_tmp18_) {
				_tmp17_ = FALSE;
			} else {
				_tmp17_ = TRUE;
			}
			self->selected = _tmp17_;
		}
	} else {
		gboolean _tmp19_ = FALSE;
		_tmp19_ = affect;
		if (_tmp19_) {
			self->selected = TRUE;
		} else {
			self->selected = FALSE;
		}
	}
}


/**
 * Changes any pin connections which reference the wire
 * //replaceWhat// to reference //replaceWith//.
 */
void component_inst_change_wire (ComponentInst* self, WireInst* replaceWhat, WireInst* replaceWith) {
	FILE* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (replaceWhat != NULL);
	g_return_if_fail (replaceWith != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Reconnecting component\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				PinInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->pinInsts;
				_tmp4__length1 = self->pinInsts_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					gint i2 = 0;
					i2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							PinInst** _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							PinInst* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							WireInst* _tmp12_ = NULL;
							PinInst** _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp14_ = 0;
							PinInst* _tmp15_ = NULL;
							WireInst** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp17_ = 0;
							WireInst* _tmp18_ = NULL;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = i2;
								i2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = i2;
							_tmp8_ = self->pinInsts;
							_tmp8__length1 = self->pinInsts_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_->arraySize;
							if (!(_tmp7_ < _tmp11_)) {
								break;
							}
							_tmp12_ = replaceWhat;
							_tmp13_ = self->pinInsts;
							_tmp13__length1 = self->pinInsts_length1;
							_tmp14_ = i;
							_tmp15_ = _tmp13_[_tmp14_];
							_tmp16_ = _tmp15_->wireInsts;
							_tmp16__length1 = _tmp15_->wireInsts_length1;
							_tmp17_ = i2;
							_tmp18_ = _tmp16_[_tmp17_];
							if (_tmp12_ == _tmp18_) {
								PinInst** _tmp19_ = NULL;
								gint _tmp19__length1 = 0;
								gint _tmp20_ = 0;
								PinInst* _tmp21_ = NULL;
								WireInst** _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp23_ = 0;
								WireInst* _tmp24_ = NULL;
								WireInst* _tmp25_ = NULL;
								WireInst* _tmp26_ = NULL;
								FILE* _tmp27_ = NULL;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								_tmp19_ = self->pinInsts;
								_tmp19__length1 = self->pinInsts_length1;
								_tmp20_ = i;
								_tmp21_ = _tmp19_[_tmp20_];
								_tmp22_ = _tmp21_->wireInsts;
								_tmp22__length1 = _tmp21_->wireInsts_length1;
								_tmp23_ = i2;
								_tmp24_ = replaceWith;
								_tmp25_ = _wire_inst_ref0 (_tmp24_);
								_wire_inst_unref0 (_tmp22_[_tmp23_]);
								_tmp22_[_tmp23_] = _tmp25_;
								_tmp26_ = _tmp22_[_tmp23_];
								_tmp27_ = stdout;
								_tmp28_ = i;
								_tmp29_ = i2;
								fprintf (_tmp27_, "Component connection changed: %i, %i\n", _tmp28_, _tmp29_);
							}
						}
					}
				}
			}
		}
	}
}


/**
 * Disconnects the component from all wires.
 */
void component_inst_detatch_all (ComponentInst* self) {
	FILE* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Disconnecting component completely\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				PinInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->pinInsts;
				_tmp4__length1 = self->pinInsts_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					gint i2 = 0;
					i2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							PinInst** _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							PinInst* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							PinInst** _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp13_ = 0;
							PinInst* _tmp14_ = NULL;
							WireInst** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp16_ = 0;
							WireInst* _tmp17_ = NULL;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = i2;
								i2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = i2;
							_tmp8_ = self->pinInsts;
							_tmp8__length1 = self->pinInsts_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_->arraySize;
							if (!(_tmp7_ < _tmp11_)) {
								break;
							}
							_tmp12_ = self->pinInsts;
							_tmp12__length1 = self->pinInsts_length1;
							_tmp13_ = i;
							_tmp14_ = _tmp12_[_tmp13_];
							_tmp15_ = _tmp14_->wireInsts;
							_tmp15__length1 = _tmp14_->wireInsts_length1;
							_tmp16_ = i2;
							_tmp17_ = _tmp15_[_tmp16_];
							if (_tmp17_ != NULL) {
								PinInst** _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp19_ = 0;
								PinInst* _tmp20_ = NULL;
								WireInst** _tmp21_ = NULL;
								gint _tmp21__length1 = 0;
								gint _tmp22_ = 0;
								WireInst* _tmp23_ = NULL;
								PinInst** _tmp24_ = NULL;
								gint _tmp24__length1 = 0;
								gint _tmp25_ = 0;
								PinInst* _tmp26_ = NULL;
								WireInst** _tmp27_ = NULL;
								gint _tmp27__length1 = 0;
								gint _tmp28_ = 0;
								WireInst* _tmp29_ = NULL;
								FILE* _tmp30_ = NULL;
								gint _tmp31_ = 0;
								_tmp18_ = self->pinInsts;
								_tmp18__length1 = self->pinInsts_length1;
								_tmp19_ = i;
								_tmp20_ = _tmp18_[_tmp19_];
								_tmp21_ = _tmp20_->wireInsts;
								_tmp21__length1 = _tmp20_->wireInsts_length1;
								_tmp22_ = i2;
								_tmp23_ = _tmp21_[_tmp22_];
								wire_inst_unregister_component (_tmp23_, self);
								_tmp24_ = self->pinInsts;
								_tmp24__length1 = self->pinInsts_length1;
								_tmp25_ = i;
								_tmp26_ = _tmp24_[_tmp25_];
								_tmp27_ = _tmp26_->wireInsts;
								_tmp27__length1 = _tmp26_->wireInsts_length1;
								_tmp28_ = i2;
								_wire_inst_unref0 (_tmp27_[_tmp28_]);
								_tmp27_[_tmp28_] = NULL;
								_tmp29_ = _tmp27_[_tmp28_];
								_tmp30_ = stdout;
								_tmp31_ = i;
								fprintf (_tmp30_, "Component input disconnected: %i\n", _tmp31_);
							}
						}
					}
				}
			}
		}
	}
}


/**
 * Disconnects from a specified wire. If //callWire// is false, the
 * wire will not be told to unregister the component (for when the
 * wire triggers the disconnection).
 */
void component_inst_disconnect_wire (ComponentInst* self, WireInst* wireInst, gboolean callWire) {
	FILE* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wireInst != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Disconnecting component\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				PinInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->pinInsts;
				_tmp4__length1 = self->pinInsts_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					gint i2 = 0;
					i2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							PinInst** _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							PinInst* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							WireInst* _tmp12_ = NULL;
							PinInst** _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp14_ = 0;
							PinInst* _tmp15_ = NULL;
							WireInst** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp17_ = 0;
							WireInst* _tmp18_ = NULL;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = i2;
								i2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = i2;
							_tmp8_ = self->pinInsts;
							_tmp8__length1 = self->pinInsts_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_->arraySize;
							if (!(_tmp7_ < _tmp11_)) {
								break;
							}
							_tmp12_ = wireInst;
							_tmp13_ = self->pinInsts;
							_tmp13__length1 = self->pinInsts_length1;
							_tmp14_ = i;
							_tmp15_ = _tmp13_[_tmp14_];
							_tmp16_ = _tmp15_->wireInsts;
							_tmp16__length1 = _tmp15_->wireInsts_length1;
							_tmp17_ = i2;
							_tmp18_ = _tmp16_[_tmp17_];
							if (_tmp12_ == _tmp18_) {
								gboolean _tmp19_ = FALSE;
								PinInst** _tmp26_ = NULL;
								gint _tmp26__length1 = 0;
								gint _tmp27_ = 0;
								PinInst* _tmp28_ = NULL;
								WireInst** _tmp29_ = NULL;
								gint _tmp29__length1 = 0;
								gint _tmp30_ = 0;
								WireInst* _tmp31_ = NULL;
								FILE* _tmp32_ = NULL;
								gint _tmp33_ = 0;
								_tmp19_ = callWire;
								if (_tmp19_) {
									PinInst** _tmp20_ = NULL;
									gint _tmp20__length1 = 0;
									gint _tmp21_ = 0;
									PinInst* _tmp22_ = NULL;
									WireInst** _tmp23_ = NULL;
									gint _tmp23__length1 = 0;
									gint _tmp24_ = 0;
									WireInst* _tmp25_ = NULL;
									_tmp20_ = self->pinInsts;
									_tmp20__length1 = self->pinInsts_length1;
									_tmp21_ = i;
									_tmp22_ = _tmp20_[_tmp21_];
									_tmp23_ = _tmp22_->wireInsts;
									_tmp23__length1 = _tmp22_->wireInsts_length1;
									_tmp24_ = i2;
									_tmp25_ = _tmp23_[_tmp24_];
									wire_inst_unregister_component (_tmp25_, self);
								}
								_tmp26_ = self->pinInsts;
								_tmp26__length1 = self->pinInsts_length1;
								_tmp27_ = i;
								_tmp28_ = _tmp26_[_tmp27_];
								_tmp29_ = _tmp28_->wireInsts;
								_tmp29__length1 = _tmp28_->wireInsts_length1;
								_tmp30_ = i2;
								_wire_inst_unref0 (_tmp29_[_tmp30_]);
								_tmp29_[_tmp30_] = NULL;
								_tmp31_ = _tmp29_[_tmp30_];
								_tmp32_ = stdout;
								_tmp33_ = i;
								fprintf (_tmp32_, "Component input disconnected: %i\n", _tmp33_);
							}
						}
					}
				}
			}
		}
	}
}


/**
 * If a pin end is at (//x//, //y//) connect it to //wireInst//.
 */
gboolean component_inst_try_connect (ComponentInst* self, gint x, gint y, WireInst* wireInst) {
	gboolean result = FALSE;
	gint xRelative = 0;
	gint yRelative = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wireInst != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	component_inst_relative_position (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
	xRelative = _tmp2_;
	yRelative = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				PinInst** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				PinInst* pinInst = NULL;
				PinInst** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				PinInst* _tmp10_ = NULL;
				PinInst* _tmp11_ = NULL;
				PinInst* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->pinInsts;
				_tmp7__length1 = self->pinInsts_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->pinInsts;
				_tmp8__length1 = self->pinInsts_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = _pin_inst_ref0 (_tmp10_);
				pinInst = _tmp11_;
				_tmp12_ = pinInst;
				_tmp13_ = _tmp12_->show;
				if (_tmp13_) {
					PinInst* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					WireInst* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					_tmp14_ = pinInst;
					_tmp15_ = xRelative;
					_tmp16_ = yRelative;
					_tmp17_ = wireInst;
					_tmp18_ = pin_inst_try_connect (_tmp14_, _tmp15_, _tmp16_, _tmp17_, self);
					if (_tmp18_) {
						result = TRUE;
						_pin_inst_unref0 (pinInst);
						return result;
					}
				}
				_pin_inst_unref0 (pinInst);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * If a pin end is at (//x//, //y//) disconnect it from
 * //wireInst//.
 */
gboolean component_inst_try_disconnect (ComponentInst* self, gint x, gint y) {
	gboolean result = FALSE;
	gint xRelative = 0;
	gint yRelative = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	component_inst_relative_position (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
	xRelative = _tmp2_;
	yRelative = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				PinInst** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				PinInst* pinInst = NULL;
				PinInst** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				PinInst* _tmp10_ = NULL;
				PinInst* _tmp11_ = NULL;
				PinInst* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->pinInsts;
				_tmp7__length1 = self->pinInsts_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->pinInsts;
				_tmp8__length1 = self->pinInsts_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = _pin_inst_ref0 (_tmp10_);
				pinInst = _tmp11_;
				_tmp12_ = pinInst;
				_tmp13_ = xRelative;
				_tmp14_ = yRelative;
				_tmp15_ = pin_inst_try_disconnect (_tmp12_, _tmp13_, _tmp14_, self);
				if (_tmp15_) {
					result = TRUE;
					_pin_inst_unref0 (pinInst);
					return result;
				}
				_pin_inst_unref0 (pinInst);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * Translates the component instance //x// right, //y// down.
 * If //ignoreSelect// is true, it will move without being selected.
 */
void component_inst_move (ComponentInst* self, gint x, gint y, gboolean ignoreSelect) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = ignoreSelect;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->selected;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		component_inst_detatch_all (self);
		_tmp3_ = self->xPosition;
		_tmp4_ = x;
		self->xPosition = _tmp3_ + _tmp4_;
		_tmp5_ = self->yPosition;
		_tmp6_ = y;
		self->yPosition = _tmp5_ + _tmp6_;
	}
}


/**
 * Flips the component along its length. (Top flipped with bottom
 * when direction is right).
 * If //ignoreSelect// is true, it will flip without being selected.
 */
void component_inst_flip (ComponentInst* self, gboolean ignoreSelect) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = ignoreSelect;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->selected;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->flipped;
		if (_tmp4_) {
			_tmp3_ = FALSE;
		} else {
			_tmp3_ = TRUE;
		}
		self->flipped = _tmp3_;
		component_inst_detatch_all (self);
	}
}


/**
 * Changes the rotation of the component.
 * If //ignoreSelect// is true, it will rotate without being
 * selected.
 */
void component_inst_orientate (ComponentInst* self, Direction direction, gboolean ignoreSelect) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = ignoreSelect;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->selected;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		Direction _tmp3_ = 0;
		_tmp3_ = direction;
		self->direction = _tmp3_;
		component_inst_detatch_all (self);
	}
}


/**
 * Return 1 if the component instance is at (//x//, //y//).
 */
gint component_inst_find (ComponentInst* self, gint x, gint y) {
	gint result = 0;
	gint xRelative = 0;
	gint yRelative = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	component_inst_relative_position (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
	xRelative = _tmp2_;
	yRelative = _tmp3_;
	_tmp7_ = xRelative;
	_tmp8_ = self->leftBound;
	if (_tmp7_ >= _tmp8_) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp9_ = xRelative;
		_tmp10_ = self->rightBound;
		_tmp6_ = _tmp9_ <= _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp11_ = yRelative;
		_tmp12_ = self->upBound;
		_tmp5_ = _tmp11_ >= _tmp12_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp13_ = yRelative;
		_tmp14_ = self->downBound;
		_tmp4_ = _tmp13_ <= _tmp14_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}


/**
 * Compiles a component instance by creating and passing connections
 * to //componentDef//'s compile method.
 */
static void _vala_array_add49 (Connection*** array, int* length, int* size, Connection* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Connection*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _wire_state_ref0 (gpointer self) {
	return self ? wire_state_ref (self) : NULL;
}


static void _vala_array_add50 (Connection*** array, int* length, int* size, Connection* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Connection*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void component_inst_compile_component (ComponentInst* self, CompiledCircuit* compiledCircuit, WireState** localWireStates, int localWireStates_length1, ComponentInst** ancestry, int ancestry_length1) {
	Connection** connections = NULL;
	Connection** _tmp0_ = NULL;
	gint connections_length1 = 0;
	gint _connections_size_ = 0;
	PinInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ComponentDef* _tmp28_ = NULL;
	CompiledCircuit* _tmp29_ = NULL;
	Connection** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	ComponentInst** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (compiledCircuit != NULL);
	_tmp0_ = g_new0 (Connection*, 0 + 1);
	connections = _tmp0_;
	connections_length1 = 0;
	_connections_size_ = connections_length1;
	_tmp1_ = self->pinInsts;
	_tmp1__length1 = self->pinInsts_length1;
	{
		PinInst** pinInst_collection = NULL;
		gint pinInst_collection_length1 = 0;
		gint _pinInst_collection_size_ = 0;
		gint pinInst_it = 0;
		pinInst_collection = _tmp1_;
		pinInst_collection_length1 = _tmp1__length1;
		for (pinInst_it = 0; pinInst_it < _tmp1__length1; pinInst_it = pinInst_it + 1) {
			PinInst* _tmp2_ = NULL;
			PinInst* pinInst = NULL;
			_tmp2_ = _pin_inst_ref0 (pinInst_collection[pinInst_it]);
			pinInst = _tmp2_;
			{
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_ = 0;
							PinInst* _tmp6_ = NULL;
							gint _tmp7_ = 0;
							WireInst* wireInst = NULL;
							PinInst* _tmp8_ = NULL;
							WireInst** _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp10_ = 0;
							WireInst* _tmp11_ = NULL;
							WireInst* _tmp12_ = NULL;
							WireInst* _tmp13_ = NULL;
							WireState** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							if (!_tmp3_) {
								gint _tmp4_ = 0;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = i;
							_tmp6_ = pinInst;
							_tmp7_ = _tmp6_->arraySize;
							if (!(_tmp5_ < _tmp7_)) {
								break;
							}
							_tmp8_ = pinInst;
							_tmp9_ = _tmp8_->wireInsts;
							_tmp9__length1 = _tmp8_->wireInsts_length1;
							_tmp10_ = i;
							_tmp11_ = _tmp9_[_tmp10_];
							_tmp12_ = _wire_inst_ref0 (_tmp11_);
							wireInst = _tmp12_;
							_tmp13_ = wireInst;
							if (_tmp13_ == NULL) {
								Connection** _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								Connection* _tmp15_ = NULL;
								_tmp14_ = connections;
								_tmp14__length1 = connections_length1;
								_tmp15_ = connection_new_fake ();
								_vala_array_add49 (&connections, &connections_length1, &_connections_size_, _tmp15_);
								_wire_inst_unref0 (wireInst);
								continue;
							}
							_tmp16_ = localWireStates;
							_tmp16__length1 = localWireStates_length1;
							{
								WireState** wireState_collection = NULL;
								gint wireState_collection_length1 = 0;
								gint _wireState_collection_size_ = 0;
								gint wireState_it = 0;
								wireState_collection = _tmp16_;
								wireState_collection_length1 = _tmp16__length1;
								for (wireState_it = 0; wireState_it < _tmp16__length1; wireState_it = wireState_it + 1) {
									WireState* _tmp17_ = NULL;
									WireState* wireState = NULL;
									_tmp17_ = _wire_state_ref0 (wireState_collection[wireState_it]);
									wireState = _tmp17_;
									{
										WireState* _tmp18_ = NULL;
										WireInst* _tmp19_ = NULL;
										WireInst* _tmp20_ = NULL;
										_tmp18_ = wireState;
										_tmp19_ = _tmp18_->wireInst;
										_tmp20_ = wireInst;
										if (_tmp19_ == _tmp20_) {
											Connection** _tmp21_ = NULL;
											gint _tmp21__length1 = 0;
											WireState* _tmp22_ = NULL;
											PinInst* _tmp23_ = NULL;
											gboolean* _tmp24_ = NULL;
											gint _tmp24__length1 = 0;
											gint _tmp25_ = 0;
											gboolean _tmp26_ = FALSE;
											Connection* _tmp27_ = NULL;
											_tmp21_ = connections;
											_tmp21__length1 = connections_length1;
											_tmp22_ = wireState;
											_tmp23_ = pinInst;
											_tmp24_ = _tmp23_->invert;
											_tmp24__length1 = _tmp23_->invert_length1;
											_tmp25_ = i;
											_tmp26_ = _tmp24_[_tmp25_];
											_tmp27_ = connection_new (_tmp22_, _tmp26_);
											_vala_array_add50 (&connections, &connections_length1, &_connections_size_, _tmp27_);
										}
										_wire_state_unref0 (wireState);
									}
								}
							}
							_wire_inst_unref0 (wireInst);
						}
					}
				}
				_pin_inst_unref0 (pinInst);
			}
		}
	}
	_tmp28_ = self->componentDef;
	_tmp29_ = compiledCircuit;
	_tmp30_ = connections;
	_tmp30__length1 = connections_length1;
	_tmp31_ = ancestry;
	_tmp31__length1 = ancestry_length1;
	component_def_compile_component (_tmp28_, _tmp29_, self, _tmp30_, _tmp30__length1, _tmp31_, _tmp31__length1);
	connections = (_vala_array_free (connections, connections_length1, (GDestroyNotify) connection_unref), NULL);
}


/**
 * Saves all information about the component instance to an xml
 * document using libxml.
 */
void component_inst_save (ComponentInst* self, xmlTextWriter* xmlWriter) {
	xmlTextWriter* _tmp0_ = NULL;
	xmlTextWriter* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	xmlTextWriter* _tmp5_ = NULL;
	ComponentDef* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	xmlTextWriter* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	xmlTextWriter* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* tmpString = NULL;
	Direction _tmp16_ = 0;
	xmlTextWriter* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	xmlTextWriter* _tmp26_ = NULL;
	ComponentDef* _tmp27_ = NULL;
	xmlTextWriter* _tmp28_ = NULL;
	PropertySet* _tmp29_ = NULL;
	xmlTextWriter* _tmp94_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (xmlWriter != NULL);
	_tmp0_ = xmlWriter;
	xmlTextWriterStartElement (_tmp0_, (xmlChar*) "component");
	_tmp1_ = xmlWriter;
	_tmp2_ = self->myID;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	xmlTextWriterWriteAttribute (_tmp1_, (xmlChar*) "id", (xmlChar*) _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = xmlWriter;
	_tmp6_ = self->componentDef;
	_tmp7_ = _tmp6_->name;
	xmlTextWriterWriteAttribute (_tmp5_, (xmlChar*) "def", (xmlChar*) _tmp7_);
	_tmp8_ = xmlWriter;
	_tmp9_ = self->xPosition;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	_tmp11_ = _tmp10_;
	xmlTextWriterWriteAttribute (_tmp8_, (xmlChar*) "x", (xmlChar*) _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = xmlWriter;
	_tmp13_ = self->yPosition;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	xmlTextWriterWriteAttribute (_tmp12_, (xmlChar*) "y", (xmlChar*) _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = self->direction;
	switch (_tmp16_) {
		case DIRECTION_RIGHT:
		{
			gchar* _tmp17_ = NULL;
			_tmp17_ = g_strdup ("right");
			_g_free0 (tmpString);
			tmpString = _tmp17_;
			break;
		}
		case DIRECTION_DOWN:
		{
			gchar* _tmp18_ = NULL;
			_tmp18_ = g_strdup ("down");
			_g_free0 (tmpString);
			tmpString = _tmp18_;
			break;
		}
		case DIRECTION_LEFT:
		{
			gchar* _tmp19_ = NULL;
			_tmp19_ = g_strdup ("left");
			_g_free0 (tmpString);
			tmpString = _tmp19_;
			break;
		}
		case DIRECTION_UP:
		{
			gchar* _tmp20_ = NULL;
			_tmp20_ = g_strdup ("up");
			_g_free0 (tmpString);
			tmpString = _tmp20_;
			break;
		}
		default:
		{
			gchar* _tmp21_ = NULL;
			_tmp21_ = g_strdup ("right");
			_g_free0 (tmpString);
			tmpString = _tmp21_;
			break;
		}
	}
	_tmp22_ = xmlWriter;
	_tmp23_ = tmpString;
	xmlTextWriterWriteAttribute (_tmp22_, (xmlChar*) "direction", (xmlChar*) _tmp23_);
	_tmp25_ = self->flipped;
	if (_tmp25_) {
		_tmp24_ = "true";
	} else {
		_tmp24_ = "false";
	}
	_tmp26_ = xmlWriter;
	xmlTextWriterWriteAttribute (_tmp26_, (xmlChar*) "flip", (xmlChar*) _tmp24_);
	_tmp27_ = self->componentDef;
	_tmp28_ = xmlWriter;
	_tmp29_ = self->configuration;
	component_def_save_properties (_tmp27_, _tmp28_, _tmp29_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_ = 0;
				PinInst** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				PinInst* pinInst = NULL;
				PinInst** _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
				gint _tmp35_ = 0;
				PinInst* _tmp36_ = NULL;
				PinInst* _tmp37_ = NULL;
				xmlTextWriter* _tmp38_ = NULL;
				PinInst* _tmp39_ = NULL;
				PinDef* _tmp40_ = NULL;
				Flow _tmp41_ = 0;
				xmlTextWriter* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				PinInst* _tmp48_ = NULL;
				PinDef* _tmp49_ = NULL;
				gboolean _tmp50_ = FALSE;
				xmlTextWriter* _tmp93_ = NULL;
				if (!_tmp30_) {
					gint _tmp31_ = 0;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = self->pinInsts;
				_tmp33__length1 = self->pinInsts_length1;
				if (!(_tmp32_ < _tmp33__length1)) {
					break;
				}
				_tmp34_ = self->pinInsts;
				_tmp34__length1 = self->pinInsts_length1;
				_tmp35_ = i;
				_tmp36_ = _tmp34_[_tmp35_];
				_tmp37_ = _pin_inst_ref0 (_tmp36_);
				pinInst = _tmp37_;
				_tmp38_ = xmlWriter;
				xmlTextWriterStartElement (_tmp38_, (xmlChar*) "connection");
				_tmp39_ = pinInst;
				_tmp40_ = _tmp39_->pinDef;
				_tmp41_ = _tmp40_->flow;
				switch (_tmp41_) {
					case FLOW_IN:
					{
						xmlTextWriter* _tmp42_ = NULL;
						_tmp42_ = xmlWriter;
						xmlTextWriterWriteAttribute (_tmp42_, (xmlChar*) "flow", (xmlChar*) "in");
						break;
					}
					case FLOW_OUT:
					{
						xmlTextWriter* _tmp43_ = NULL;
						_tmp43_ = xmlWriter;
						xmlTextWriterWriteAttribute (_tmp43_, (xmlChar*) "flow", (xmlChar*) "out");
						break;
					}
					default:
					break;
				}
				_tmp44_ = xmlWriter;
				_tmp45_ = i;
				_tmp46_ = g_strdup_printf ("%i", _tmp45_);
				_tmp47_ = _tmp46_;
				xmlTextWriterWriteAttribute (_tmp44_, (xmlChar*) "pinid", (xmlChar*) _tmp47_);
				_g_free0 (_tmp47_);
				_tmp48_ = pinInst;
				_tmp49_ = _tmp48_->pinDef;
				_tmp50_ = _tmp49_->array;
				if (_tmp50_) {
					{
						gint i2 = 0;
						i2 = 0;
						{
							gboolean _tmp51_ = FALSE;
							_tmp51_ = TRUE;
							while (TRUE) {
								gint _tmp53_ = 0;
								PinInst* _tmp54_ = NULL;
								gint _tmp55_ = 0;
								xmlTextWriter* _tmp56_ = NULL;
								PinInst* _tmp57_ = NULL;
								WireInst** _tmp58_ = NULL;
								gint _tmp58__length1 = 0;
								gint _tmp59_ = 0;
								WireInst* _tmp60_ = NULL;
								const gchar* _tmp70_ = NULL;
								PinInst* _tmp71_ = NULL;
								gboolean* _tmp72_ = NULL;
								gint _tmp72__length1 = 0;
								gint _tmp73_ = 0;
								gboolean _tmp74_ = FALSE;
								xmlTextWriter* _tmp75_ = NULL;
								xmlTextWriter* _tmp76_ = NULL;
								if (!_tmp51_) {
									gint _tmp52_ = 0;
									_tmp52_ = i2;
									i2 = _tmp52_ + 1;
								}
								_tmp51_ = FALSE;
								_tmp53_ = i2;
								_tmp54_ = pinInst;
								_tmp55_ = _tmp54_->arraySize;
								if (!(_tmp53_ < _tmp55_)) {
									break;
								}
								_tmp56_ = xmlWriter;
								xmlTextWriterStartElement (_tmp56_, (xmlChar*) "subpin");
								_tmp57_ = pinInst;
								_tmp58_ = _tmp57_->wireInsts;
								_tmp58__length1 = _tmp57_->wireInsts_length1;
								_tmp59_ = i2;
								_tmp60_ = _tmp58_[_tmp59_];
								if (_tmp60_ != NULL) {
									xmlTextWriter* _tmp61_ = NULL;
									PinInst* _tmp62_ = NULL;
									WireInst** _tmp63_ = NULL;
									gint _tmp63__length1 = 0;
									gint _tmp64_ = 0;
									WireInst* _tmp65_ = NULL;
									gint _tmp66_ = 0;
									gchar* _tmp67_ = NULL;
									gchar* _tmp68_ = NULL;
									_tmp61_ = xmlWriter;
									_tmp62_ = pinInst;
									_tmp63_ = _tmp62_->wireInsts;
									_tmp63__length1 = _tmp62_->wireInsts_length1;
									_tmp64_ = i2;
									_tmp65_ = _tmp63_[_tmp64_];
									_tmp66_ = _tmp65_->myID;
									_tmp67_ = g_strdup_printf ("%i", _tmp66_);
									_tmp68_ = _tmp67_;
									xmlTextWriterWriteAttribute (_tmp61_, (xmlChar*) "wireid", (xmlChar*) _tmp68_);
									_g_free0 (_tmp68_);
								} else {
									xmlTextWriter* _tmp69_ = NULL;
									_tmp69_ = xmlWriter;
									xmlTextWriterWriteAttribute (_tmp69_, (xmlChar*) "wireid", (xmlChar*) "null");
								}
								_tmp71_ = pinInst;
								_tmp72_ = _tmp71_->invert;
								_tmp72__length1 = _tmp71_->invert_length1;
								_tmp73_ = i2;
								_tmp74_ = _tmp72_[_tmp73_];
								if (_tmp74_) {
									_tmp70_ = "true";
								} else {
									_tmp70_ = "false";
								}
								_tmp75_ = xmlWriter;
								xmlTextWriterWriteAttribute (_tmp75_, (xmlChar*) "invert", (xmlChar*) _tmp70_);
								_tmp76_ = xmlWriter;
								xmlTextWriterEndElement (_tmp76_);
							}
						}
					}
				} else {
					PinInst* _tmp77_ = NULL;
					WireInst** _tmp78_ = NULL;
					gint _tmp78__length1 = 0;
					WireInst* _tmp79_ = NULL;
					const gchar* _tmp88_ = NULL;
					PinInst* _tmp89_ = NULL;
					gboolean* _tmp90_ = NULL;
					gint _tmp90__length1 = 0;
					gboolean _tmp91_ = FALSE;
					xmlTextWriter* _tmp92_ = NULL;
					_tmp77_ = pinInst;
					_tmp78_ = _tmp77_->wireInsts;
					_tmp78__length1 = _tmp77_->wireInsts_length1;
					_tmp79_ = _tmp78_[0];
					if (_tmp79_ != NULL) {
						xmlTextWriter* _tmp80_ = NULL;
						PinInst* _tmp81_ = NULL;
						WireInst** _tmp82_ = NULL;
						gint _tmp82__length1 = 0;
						WireInst* _tmp83_ = NULL;
						gint _tmp84_ = 0;
						gchar* _tmp85_ = NULL;
						gchar* _tmp86_ = NULL;
						_tmp80_ = xmlWriter;
						_tmp81_ = pinInst;
						_tmp82_ = _tmp81_->wireInsts;
						_tmp82__length1 = _tmp81_->wireInsts_length1;
						_tmp83_ = _tmp82_[0];
						_tmp84_ = _tmp83_->myID;
						_tmp85_ = g_strdup_printf ("%i", _tmp84_);
						_tmp86_ = _tmp85_;
						xmlTextWriterWriteAttribute (_tmp80_, (xmlChar*) "wireid", (xmlChar*) _tmp86_);
						_g_free0 (_tmp86_);
					} else {
						xmlTextWriter* _tmp87_ = NULL;
						_tmp87_ = xmlWriter;
						xmlTextWriterWriteAttribute (_tmp87_, (xmlChar*) "wireid", (xmlChar*) "null");
					}
					_tmp89_ = pinInst;
					_tmp90_ = _tmp89_->invert;
					_tmp90__length1 = _tmp89_->invert_length1;
					_tmp91_ = _tmp90_[0];
					if (_tmp91_) {
						_tmp88_ = "true";
					} else {
						_tmp88_ = "false";
					}
					_tmp92_ = xmlWriter;
					xmlTextWriterWriteAttribute (_tmp92_, (xmlChar*) "invert", (xmlChar*) _tmp88_);
				}
				_tmp93_ = xmlWriter;
				xmlTextWriterEndElement (_tmp93_);
				_pin_inst_unref0 (pinInst);
			}
		}
	}
	_tmp94_ = xmlWriter;
	xmlTextWriterEndElement (_tmp94_);
	_g_free0 (tmpString);
}


/**
 * Renders the instance as part of a design by calling 
 * //componentDef//'s and each PinInst in //pinInsts//' render
 * method.
 * If //showHints// is true, selection is shown as blue, and
 * disconnected pins show as red.
 * If //showErrors// is true and instance is erroneous, it
 * highlights the instance in red.
 */
void component_inst_render (ComponentInst* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds) {
	cairo_matrix_t oldMatrix = {0};
	cairo_t* _tmp0_ = NULL;
	cairo_matrix_t _tmp1_ = {0};
	cairo_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	ComponentDef* _tmp5_ = NULL;
	cairo_t* _tmp6_ = NULL;
	Direction _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gdouble angle = 0.0;
	Direction _tmp10_ = 0;
	cairo_t* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	gboolean _tmp13_ = FALSE;
	PinInst** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	cairo_t* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	cairo_t* _tmp89_ = NULL;
	cairo_matrix_t _tmp90_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	cairo_get_matrix (_tmp0_, &_tmp1_);
	oldMatrix = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = self->xPosition;
	_tmp4_ = self->yPosition;
	cairo_translate (_tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
	_tmp5_ = self->componentDef;
	_tmp6_ = context;
	_tmp7_ = self->direction;
	_tmp8_ = self->flipped;
	_tmp9_ = colourBackgrounds;
	component_def_render (_tmp5_, _tmp6_, _tmp7_, _tmp8_, self, _tmp9_);
	angle = (gdouble) 0;
	_tmp10_ = self->direction;
	switch (_tmp10_) {
		case DIRECTION_RIGHT:
		{
			angle = (gdouble) 0;
			break;
		}
		case DIRECTION_DOWN:
		{
			angle = G_PI * 0.5;
			break;
		}
		case DIRECTION_LEFT:
		{
			angle = G_PI;
			break;
		}
		case DIRECTION_UP:
		{
			angle = G_PI * 1.5;
			break;
		}
		default:
		break;
	}
	_tmp11_ = context;
	_tmp12_ = angle;
	cairo_rotate (_tmp11_, _tmp12_);
	_tmp13_ = self->flipped;
	if (_tmp13_) {
		cairo_t* _tmp14_ = NULL;
		_tmp14_ = context;
		cairo_scale (_tmp14_, 1.0, -1.0);
	}
	_tmp15_ = self->pinInsts;
	_tmp15__length1 = self->pinInsts_length1;
	{
		PinInst** pinInst_collection = NULL;
		gint pinInst_collection_length1 = 0;
		gint _pinInst_collection_size_ = 0;
		gint pinInst_it = 0;
		pinInst_collection = _tmp15_;
		pinInst_collection_length1 = _tmp15__length1;
		for (pinInst_it = 0; pinInst_it < _tmp15__length1; pinInst_it = pinInst_it + 1) {
			PinInst* _tmp16_ = NULL;
			PinInst* pinInst = NULL;
			_tmp16_ = _pin_inst_ref0 (pinInst_collection[pinInst_it]);
			pinInst = _tmp16_;
			{
				PinInst* _tmp17_ = NULL;
				cairo_t* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				cairo_t* _tmp20_ = NULL;
				PinInst* _tmp21_ = NULL;
				PinDef* _tmp22_ = NULL;
				Direction _tmp23_ = 0;
				_tmp17_ = pinInst;
				_tmp18_ = context;
				_tmp19_ = showHints;
				pin_inst_render (_tmp17_, _tmp18_, _tmp19_);
				_tmp20_ = context;
				cairo_set_source_rgb (_tmp20_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
				_tmp21_ = pinInst;
				_tmp22_ = _tmp21_->pinDef;
				_tmp23_ = _tmp22_->direction;
				switch (_tmp23_) {
					case DIRECTION_LEFT:
					case DIRECTION_RIGHT:
					{
						gboolean _tmp24_ = FALSE;
						PinInst* _tmp25_ = NULL;
						gint _tmp26_ = 0;
						gint _tmp27_ = 0;
						_tmp25_ = pinInst;
						_tmp26_ = _tmp25_->yMin;
						_tmp27_ = self->upBound;
						if (_tmp26_ <= _tmp27_) {
							_tmp24_ = TRUE;
						} else {
							PinInst* _tmp28_ = NULL;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							_tmp28_ = pinInst;
							_tmp29_ = _tmp28_->yMax;
							_tmp30_ = self->downBound;
							_tmp24_ = _tmp29_ >= _tmp30_;
						}
						if (_tmp24_) {
							cairo_t* _tmp31_ = NULL;
							PinInst* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							PinInst* _tmp34_ = NULL;
							gint _tmp35_ = 0;
							cairo_t* _tmp36_ = NULL;
							PinInst* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							PinInst* _tmp39_ = NULL;
							gint _tmp40_ = 0;
							cairo_t* _tmp41_ = NULL;
							_tmp31_ = context;
							_tmp32_ = pinInst;
							_tmp33_ = _tmp32_->xMin;
							_tmp34_ = pinInst;
							_tmp35_ = _tmp34_->yMin;
							cairo_move_to (_tmp31_, (gdouble) _tmp33_, (gdouble) _tmp35_);
							_tmp36_ = context;
							_tmp37_ = pinInst;
							_tmp38_ = _tmp37_->xMin;
							_tmp39_ = pinInst;
							_tmp40_ = _tmp39_->yMax;
							cairo_line_to (_tmp36_, (gdouble) _tmp38_, (gdouble) _tmp40_);
							_tmp41_ = context;
							cairo_stroke (_tmp41_);
						}
						break;
					}
					case DIRECTION_UP:
					case DIRECTION_DOWN:
					{
						gboolean _tmp42_ = FALSE;
						PinInst* _tmp43_ = NULL;
						gint _tmp44_ = 0;
						gint _tmp45_ = 0;
						_tmp43_ = pinInst;
						_tmp44_ = _tmp43_->xMin;
						_tmp45_ = self->leftBound;
						if (_tmp44_ <= _tmp45_) {
							_tmp42_ = TRUE;
						} else {
							PinInst* _tmp46_ = NULL;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							_tmp46_ = pinInst;
							_tmp47_ = _tmp46_->xMax;
							_tmp48_ = self->rightBound;
							_tmp42_ = _tmp47_ >= _tmp48_;
						}
						if (_tmp42_) {
							cairo_t* _tmp49_ = NULL;
							PinInst* _tmp50_ = NULL;
							gint _tmp51_ = 0;
							PinInst* _tmp52_ = NULL;
							gint _tmp53_ = 0;
							cairo_t* _tmp54_ = NULL;
							PinInst* _tmp55_ = NULL;
							gint _tmp56_ = 0;
							PinInst* _tmp57_ = NULL;
							gint _tmp58_ = 0;
							cairo_t* _tmp59_ = NULL;
							_tmp49_ = context;
							_tmp50_ = pinInst;
							_tmp51_ = _tmp50_->xMin;
							_tmp52_ = pinInst;
							_tmp53_ = _tmp52_->yMin;
							cairo_move_to (_tmp49_, (gdouble) _tmp51_, (gdouble) _tmp53_);
							_tmp54_ = context;
							_tmp55_ = pinInst;
							_tmp56_ = _tmp55_->xMax;
							_tmp57_ = pinInst;
							_tmp58_ = _tmp57_->yMin;
							cairo_line_to (_tmp54_, (gdouble) _tmp56_, (gdouble) _tmp58_);
							_tmp59_ = context;
							cairo_stroke (_tmp59_);
						}
						break;
					}
					default:
					break;
				}
				_pin_inst_unref0 (pinInst);
			}
		}
	}
	_tmp60_ = context;
	cairo_set_source_rgb (_tmp60_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp62_ = self->selected;
	if (_tmp62_) {
		gboolean _tmp63_ = FALSE;
		_tmp63_ = showHints;
		_tmp61_ = _tmp63_;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		cairo_t* _tmp64_ = NULL;
		cairo_t* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		cairo_t* _tmp72_ = NULL;
		cairo_t* _tmp73_ = NULL;
		cairo_t* _tmp74_ = NULL;
		_tmp64_ = context;
		cairo_set_source_rgba (_tmp64_, (gdouble) 0, (gdouble) 0, (gdouble) 1, 0.25);
		_tmp65_ = context;
		_tmp66_ = self->leftBound;
		_tmp67_ = self->upBound;
		_tmp68_ = self->rightBound;
		_tmp69_ = self->leftBound;
		_tmp70_ = self->downBound;
		_tmp71_ = self->upBound;
		cairo_rectangle (_tmp65_, (gdouble) _tmp66_, (gdouble) _tmp67_, (gdouble) (_tmp68_ - _tmp69_), (gdouble) (_tmp70_ - _tmp71_));
		_tmp72_ = context;
		cairo_fill (_tmp72_);
		_tmp73_ = context;
		cairo_stroke (_tmp73_);
		_tmp74_ = context;
		cairo_set_source_rgba (_tmp74_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	}
	_tmp76_ = self->errorMark;
	if (_tmp76_) {
		gboolean _tmp77_ = FALSE;
		_tmp77_ = showErrors;
		_tmp75_ = _tmp77_;
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		cairo_t* _tmp78_ = NULL;
		cairo_t* _tmp79_ = NULL;
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		gint _tmp84_ = 0;
		gint _tmp85_ = 0;
		cairo_t* _tmp86_ = NULL;
		cairo_t* _tmp87_ = NULL;
		cairo_t* _tmp88_ = NULL;
		_tmp78_ = context;
		cairo_set_source_rgba (_tmp78_, (gdouble) 1, (gdouble) 0, (gdouble) 0, 0.25);
		_tmp79_ = context;
		_tmp80_ = self->leftBound;
		_tmp81_ = self->upBound;
		_tmp82_ = self->rightBound;
		_tmp83_ = self->leftBound;
		_tmp84_ = self->downBound;
		_tmp85_ = self->upBound;
		cairo_rectangle (_tmp79_, (gdouble) _tmp80_, (gdouble) _tmp81_, (gdouble) (_tmp82_ - _tmp83_), (gdouble) (_tmp84_ - _tmp85_));
		_tmp86_ = context;
		cairo_fill (_tmp86_);
		_tmp87_ = context;
		cairo_stroke (_tmp87_);
		_tmp88_ = context;
		cairo_set_source_rgba (_tmp88_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	}
	_tmp89_ = context;
	_tmp90_ = oldMatrix;
	cairo_set_matrix (_tmp89_, &_tmp90_);
}


static void value_component_inst_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_component_inst_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		component_inst_unref (value->data[0].v_pointer);
	}
}


static void value_component_inst_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = component_inst_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_component_inst_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_component_inst_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ComponentInst* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = component_inst_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_component_inst_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ComponentInst** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = component_inst_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecComponentInst* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_COMPONENT_INST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_component_inst (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPONENT_INST), NULL);
	return value->data[0].v_pointer;
}


void value_set_component_inst (GValue* value, gpointer v_object) {
	ComponentInst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPONENT_INST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPONENT_INST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		component_inst_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		component_inst_unref (old);
	}
}


void value_take_component_inst (GValue* value, gpointer v_object) {
	ComponentInst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPONENT_INST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPONENT_INST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		component_inst_unref (old);
	}
}


static void component_inst_class_init (ComponentInstClass * klass) {
	component_inst_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_INST_CLASS (klass)->finalize = component_inst_finalize;
}


static void component_inst_instance_init (ComponentInst * self) {
	self->flipped = FALSE;
	self->selected = FALSE;
	self->errorMark = FALSE;
	self->ref_count = 1;
}


static void component_inst_finalize (ComponentInst* obj) {
	ComponentInst * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPONENT_INST, ComponentInst);
	_property_item_unref0 (self->configuration);
	self->pinInsts = (_vala_array_free (self->pinInsts, self->pinInsts_length1, (GDestroyNotify) pin_inst_unref), NULL);
}


/**
 * An instance of a component in a design.
 * 
 * Holds information about an instance of a component in a design.
 */
GType component_inst_get_type (void) {
	static volatile gsize component_inst_type_id__volatile = 0;
	if (g_once_init_enter (&component_inst_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_component_inst_init, value_component_inst_free_value, value_component_inst_copy_value, value_component_inst_peek_pointer, "p", value_component_inst_collect_value, "p", value_component_inst_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ComponentInstClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) component_inst_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentInst), 0, (GInstanceInitFunc) component_inst_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType component_inst_type_id;
		component_inst_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ComponentInst", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&component_inst_type_id__volatile, component_inst_type_id);
	}
	return component_inst_type_id__volatile;
}


gpointer component_inst_ref (gpointer instance) {
	ComponentInst* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void component_inst_unref (gpointer instance) {
	ComponentInst* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		COMPONENT_INST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



