/* state-basic-ss-display.c generated by valac 0.24.0, the Vala compiler
 * generated from state-basic-ss-display.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentstate/state-basic-ss-display.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;
typedef struct _ComponentStatePrivate ComponentStatePrivate;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE (basic_ss_display_component_state_get_type ())
#define BASIC_SS_DISPLAY_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE, BasicSsDisplayComponentState))
#define BASIC_SS_DISPLAY_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE, BasicSsDisplayComponentStateClass))
#define IS_BASIC_SS_DISPLAY_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE))
#define IS_BASIC_SS_DISPLAY_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE))
#define BASIC_SS_DISPLAY_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE, BasicSsDisplayComponentStateClass))

typedef struct _BasicSsDisplayComponentState BasicSsDisplayComponentState;
typedef struct _BasicSsDisplayComponentStateClass BasicSsDisplayComponentStateClass;
typedef struct _BasicSsDisplayComponentStatePrivate BasicSsDisplayComponentStatePrivate;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _CompiledCircuitPrivate CompiledCircuitPrivate;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_UPDATE_QUEUE (update_queue_get_type ())
#define UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPDATE_QUEUE, UpdateQueue))
#define UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UPDATE_QUEUE, UpdateQueueClass))
#define IS_UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPDATE_QUEUE))
#define IS_UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UPDATE_QUEUE))
#define UPDATE_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UPDATE_QUEUE, UpdateQueueClass))

typedef struct _UpdateQueue UpdateQueue;
typedef struct _UpdateQueueClass UpdateQueueClass;

#define TYPE_WIRE_STATE (wire_state_get_type ())
#define WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_STATE, WireState))
#define WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_STATE, WireStateClass))
#define IS_WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_STATE))
#define IS_WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_STATE))
#define WIRE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_STATE, WireStateClass))

typedef struct _WireState WireState;
typedef struct _WireStateClass WireStateClass;

struct _ComponentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentStatePrivate * priv;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	ComponentInst* componentInst;
	gint renderQueueID;
	gint processQueueID;
	gboolean display;
};

struct _ComponentStateClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentState *self);
	void (*update) (ComponentState* self);
	void (*click) (ComponentState* self);
	void (*render) (ComponentState* self, cairo_t* context);
	gboolean (*get_alwaysUpdate) (ComponentState* self);
};

struct _BasicSsDisplayComponentState {
	ComponentState parent_instance;
	BasicSsDisplayComponentStatePrivate * priv;
};

struct _BasicSsDisplayComponentStateClass {
	ComponentStateClass parent_class;
};

struct _BasicSsDisplayComponentStatePrivate {
	gboolean aLight;
	gboolean bLight;
	gboolean cLight;
	gboolean dLight;
	gboolean eLight;
	gboolean fLight;
	gboolean gLight;
	gboolean pointLight;
	gint8 input;
	Connection* input1Wire;
	Connection* input2Wire;
	Connection* input4Wire;
	Connection* input8Wire;
	Connection* inputPWire;
	gboolean displayPoint;
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _CompiledCircuit {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompiledCircuitPrivate * priv;
	CustomComponentDef* rootComponent;
	Project* project;
	UpdateQueue* renderWireStates;
	UpdateQueue* renderComponentStates;
	UpdateQueue* processWireStates;
	UpdateQueue* processComponentStates;
	CustomComponentDef* viewedComponent;
	gint iterationCount;
};

struct _CompiledCircuitClass {
	GTypeClass parent_class;
	void (*finalize) (CompiledCircuit *self);
};


static gpointer basic_ss_display_component_state_parent_class = NULL;

gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
GType basic_ss_display_component_state_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
#define BASIC_SS_DISPLAY_COMPONENT_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE, BasicSsDisplayComponentStatePrivate))
enum  {
	BASIC_SS_DISPLAY_COMPONENT_STATE_DUMMY_PROPERTY
};
BasicSsDisplayComponentState* basic_ss_display_component_state_new (Connection* input1Wire, Connection* input2Wire, Connection* input4Wire, Connection* input8Wire, Connection* inputPWire, gboolean displayPoint, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
BasicSsDisplayComponentState* basic_ss_display_component_state_construct (GType object_type, Connection* input1Wire, Connection* input2Wire, Connection* input4Wire, Connection* input8Wire, Connection* inputPWire, gboolean displayPoint, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst);
ComponentState* component_state_construct (GType object_type);
void connection_set_affects (Connection* self, ComponentState* componentState);
static ComponentInst** _vala_array_dup22 (ComponentInst** self, int length);
static void basic_ss_display_component_state_real_render (ComponentState* base, cairo_t* context);
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
static void basic_ss_display_component_state_real_update (ComponentState* base);
gboolean connection_get_signalState (Connection* self);
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer update_queue_ref (gpointer instance);
void update_queue_unref (gpointer instance);
GParamSpec* param_spec_update_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_update_queue (GValue* value, gpointer v_object);
void value_take_update_queue (GValue* value, gpointer v_object);
gpointer value_get_update_queue (const GValue* value);
GType update_queue_get_type (void) G_GNUC_CONST;
gpointer wire_state_ref (gpointer instance);
void wire_state_unref (gpointer instance);
GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_state (GValue* value, gpointer v_object);
void value_take_wire_state (GValue* value, gpointer v_object);
gpointer value_get_wire_state (const GValue* value);
GType wire_state_get_type (void) G_GNUC_CONST;
void update_queue_add_element (UpdateQueue* self, gint elementNumber);
static void basic_ss_display_component_state_finalize (ComponentState* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


static ComponentInst** _vala_array_dup22 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


BasicSsDisplayComponentState* basic_ss_display_component_state_construct (GType object_type, Connection* input1Wire, Connection* input2Wire, Connection* input4Wire, Connection* input8Wire, Connection* inputPWire, gboolean displayPoint, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst) {
	BasicSsDisplayComponentState* self = NULL;
	Connection* _tmp0_ = NULL;
	Connection* _tmp1_ = NULL;
	Connection* _tmp2_ = NULL;
	Connection* _tmp3_ = NULL;
	Connection* _tmp4_ = NULL;
	Connection* _tmp5_ = NULL;
	Connection* _tmp6_ = NULL;
	Connection* _tmp7_ = NULL;
	Connection* _tmp8_ = NULL;
	Connection* _tmp9_ = NULL;
	Connection* _tmp10_ = NULL;
	Connection* _tmp11_ = NULL;
	Connection* _tmp12_ = NULL;
	Connection* _tmp13_ = NULL;
	Connection* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	ComponentInst** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	ComponentInst** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	ComponentInst* _tmp18_ = NULL;
	ComponentInst* _tmp19_ = NULL;
	g_return_val_if_fail (input1Wire != NULL, NULL);
	g_return_val_if_fail (input2Wire != NULL, NULL);
	g_return_val_if_fail (input4Wire != NULL, NULL);
	g_return_val_if_fail (input8Wire != NULL, NULL);
	g_return_val_if_fail (inputPWire != NULL, NULL);
	g_return_val_if_fail (componentInst != NULL, NULL);
	self = (BasicSsDisplayComponentState*) component_state_construct (object_type);
	_tmp0_ = input1Wire;
	_tmp1_ = _connection_ref0 (_tmp0_);
	_connection_unref0 (self->priv->input1Wire);
	self->priv->input1Wire = _tmp1_;
	_tmp2_ = input1Wire;
	connection_set_affects (_tmp2_, (ComponentState*) self);
	_tmp3_ = input2Wire;
	_tmp4_ = _connection_ref0 (_tmp3_);
	_connection_unref0 (self->priv->input2Wire);
	self->priv->input2Wire = _tmp4_;
	_tmp5_ = input2Wire;
	connection_set_affects (_tmp5_, (ComponentState*) self);
	_tmp6_ = input4Wire;
	_tmp7_ = _connection_ref0 (_tmp6_);
	_connection_unref0 (self->priv->input4Wire);
	self->priv->input4Wire = _tmp7_;
	_tmp8_ = input4Wire;
	connection_set_affects (_tmp8_, (ComponentState*) self);
	_tmp9_ = input8Wire;
	_tmp10_ = _connection_ref0 (_tmp9_);
	_connection_unref0 (self->priv->input8Wire);
	self->priv->input8Wire = _tmp10_;
	_tmp11_ = input8Wire;
	connection_set_affects (_tmp11_, (ComponentState*) self);
	_tmp12_ = inputPWire;
	_tmp13_ = _connection_ref0 (_tmp12_);
	_connection_unref0 (self->priv->inputPWire);
	self->priv->inputPWire = _tmp13_;
	_tmp14_ = inputPWire;
	connection_set_affects (_tmp14_, (ComponentState*) self);
	_tmp15_ = displayPoint;
	self->priv->displayPoint = _tmp15_;
	self->priv->input = (gint8) (-1);
	_tmp16_ = ancestry;
	_tmp16__length1 = ancestry_length1;
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup22 (_tmp16_, _tmp16__length1) : ((gpointer) _tmp16_);
	_tmp17__length1 = _tmp16__length1;
	((ComponentState*) self)->ancestry = (_vala_array_free (((ComponentState*) self)->ancestry, ((ComponentState*) self)->ancestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	((ComponentState*) self)->ancestry = _tmp17_;
	((ComponentState*) self)->ancestry_length1 = _tmp17__length1;
	_tmp18_ = componentInst;
	_tmp19_ = _component_inst_ref0 (_tmp18_);
	_component_inst_unref0 (((ComponentState*) self)->componentInst);
	((ComponentState*) self)->componentInst = _tmp19_;
	return self;
}


BasicSsDisplayComponentState* basic_ss_display_component_state_new (Connection* input1Wire, Connection* input2Wire, Connection* input4Wire, Connection* input8Wire, Connection* inputPWire, gboolean displayPoint, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst) {
	return basic_ss_display_component_state_construct (TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE, input1Wire, input2Wire, input4Wire, input8Wire, inputPWire, displayPoint, ancestry, ancestry_length1, componentInst);
}


static void basic_ss_display_component_state_real_render (ComponentState* base, cairo_t* context) {
	BasicSsDisplayComponentState * self;
	cairo_matrix_t oldMatrix = {0};
	cairo_t* _tmp0_ = NULL;
	cairo_matrix_t _tmp1_ = {0};
	gdouble oldLineWidth = 0.0;
	cairo_t* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	cairo_t* _tmp4_ = NULL;
	ComponentInst* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	ComponentInst* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gdouble angle = 0.0;
	ComponentInst* _tmp9_ = NULL;
	Direction _tmp10_ = 0;
	cairo_t* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	ComponentInst* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	ComponentInst* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ComponentInst* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	ComponentInst* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	ComponentInst* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	ComponentInst* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	cairo_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	gint8 _tmp30_ = 0;
	cairo_t* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	cairo_t* _tmp39_ = NULL;
	cairo_t* _tmp40_ = NULL;
	cairo_t* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	cairo_t* _tmp45_ = NULL;
	cairo_t* _tmp46_ = NULL;
	cairo_t* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	cairo_t* _tmp51_ = NULL;
	cairo_t* _tmp52_ = NULL;
	cairo_t* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	cairo_t* _tmp57_ = NULL;
	cairo_t* _tmp58_ = NULL;
	cairo_t* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	cairo_t* _tmp63_ = NULL;
	cairo_t* _tmp64_ = NULL;
	cairo_t* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	cairo_t* _tmp69_ = NULL;
	cairo_t* _tmp70_ = NULL;
	cairo_t* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	cairo_t* _tmp75_ = NULL;
	cairo_t* _tmp76_ = NULL;
	cairo_t* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	cairo_t* _tmp91_ = NULL;
	gdouble _tmp92_ = 0.0;
	cairo_t* _tmp93_ = NULL;
	cairo_matrix_t _tmp94_ = {0};
	self = (BasicSsDisplayComponentState*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	cairo_get_matrix (_tmp0_, &_tmp1_);
	oldMatrix = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = cairo_get_line_width (_tmp2_);
	oldLineWidth = _tmp3_;
	_tmp4_ = context;
	_tmp5_ = ((ComponentState*) self)->componentInst;
	_tmp6_ = _tmp5_->xPosition;
	_tmp7_ = ((ComponentState*) self)->componentInst;
	_tmp8_ = _tmp7_->yPosition;
	cairo_translate (_tmp4_, (gdouble) _tmp6_, (gdouble) _tmp8_);
	_tmp9_ = ((ComponentState*) self)->componentInst;
	_tmp10_ = _tmp9_->direction;
	switch (_tmp10_) {
		case DIRECTION_DOWN:
		{
			angle = G_PI * 0.5;
			break;
		}
		case DIRECTION_UP:
		{
			angle = G_PI * 1.5;
			break;
		}
		default:
		{
			angle = (gdouble) 0;
			break;
		}
	}
	_tmp11_ = context;
	_tmp12_ = angle;
	cairo_rotate (_tmp11_, _tmp12_);
	_tmp13_ = context;
	cairo_set_line_width (_tmp13_, (gdouble) 1);
	_tmp14_ = context;
	cairo_set_source_rgb (_tmp14_, 1.0, 1.0, 1.0);
	_tmp15_ = context;
	_tmp16_ = ((ComponentState*) self)->componentInst;
	_tmp17_ = _tmp16_->leftBound;
	_tmp18_ = ((ComponentState*) self)->componentInst;
	_tmp19_ = _tmp18_->upBound;
	_tmp20_ = ((ComponentState*) self)->componentInst;
	_tmp21_ = _tmp20_->rightBound;
	_tmp22_ = ((ComponentState*) self)->componentInst;
	_tmp23_ = _tmp22_->leftBound;
	_tmp24_ = ((ComponentState*) self)->componentInst;
	_tmp25_ = _tmp24_->downBound;
	_tmp26_ = ((ComponentState*) self)->componentInst;
	_tmp27_ = _tmp26_->upBound;
	cairo_rectangle (_tmp15_, (gdouble) _tmp17_, (gdouble) (_tmp19_ + 1), (gdouble) (_tmp21_ - _tmp23_), (gdouble) ((_tmp25_ - _tmp27_) - 2));
	_tmp28_ = context;
	cairo_fill (_tmp28_);
	_tmp29_ = context;
	cairo_stroke (_tmp29_);
	_tmp30_ = self->priv->input;
	if (((gint) _tmp30_) == (-1)) {
		cairo_t* _tmp31_ = NULL;
		gdouble _tmp32_ = 0.0;
		cairo_t* _tmp33_ = NULL;
		cairo_matrix_t _tmp34_ = {0};
		_tmp31_ = context;
		_tmp32_ = oldLineWidth;
		cairo_set_line_width (_tmp31_, _tmp32_);
		_tmp33_ = context;
		_tmp34_ = oldMatrix;
		cairo_set_matrix (_tmp33_, &_tmp34_);
		return;
	}
	_tmp35_ = context;
	cairo_set_line_width (_tmp35_, (gdouble) 5);
	_tmp36_ = self->priv->aLight;
	if (_tmp36_) {
		cairo_t* _tmp37_ = NULL;
		_tmp37_ = context;
		cairo_set_source_rgb (_tmp37_, 0.5, 0.0, 0.0);
	} else {
		cairo_t* _tmp38_ = NULL;
		_tmp38_ = context;
		cairo_set_source_rgb (_tmp38_, 0.9, 0.9, 0.9);
	}
	_tmp39_ = context;
	cairo_move_to (_tmp39_, (gdouble) (-12), (gdouble) (-30));
	_tmp40_ = context;
	cairo_line_to (_tmp40_, (gdouble) 12, (gdouble) (-30));
	_tmp41_ = context;
	cairo_stroke (_tmp41_);
	_tmp42_ = self->priv->bLight;
	if (_tmp42_) {
		cairo_t* _tmp43_ = NULL;
		_tmp43_ = context;
		cairo_set_source_rgb (_tmp43_, 0.5, 0.0, 0.0);
	} else {
		cairo_t* _tmp44_ = NULL;
		_tmp44_ = context;
		cairo_set_source_rgb (_tmp44_, 0.9, 0.9, 0.9);
	}
	_tmp45_ = context;
	cairo_move_to (_tmp45_, (gdouble) 15, (gdouble) (-27));
	_tmp46_ = context;
	cairo_line_to (_tmp46_, (gdouble) 15, (gdouble) (-3));
	_tmp47_ = context;
	cairo_stroke (_tmp47_);
	_tmp48_ = self->priv->cLight;
	if (_tmp48_) {
		cairo_t* _tmp49_ = NULL;
		_tmp49_ = context;
		cairo_set_source_rgb (_tmp49_, 0.5, 0.0, 0.0);
	} else {
		cairo_t* _tmp50_ = NULL;
		_tmp50_ = context;
		cairo_set_source_rgb (_tmp50_, 0.9, 0.9, 0.9);
	}
	_tmp51_ = context;
	cairo_move_to (_tmp51_, (gdouble) 15, (gdouble) 3);
	_tmp52_ = context;
	cairo_line_to (_tmp52_, (gdouble) 15, (gdouble) 27);
	_tmp53_ = context;
	cairo_stroke (_tmp53_);
	_tmp54_ = self->priv->dLight;
	if (_tmp54_) {
		cairo_t* _tmp55_ = NULL;
		_tmp55_ = context;
		cairo_set_source_rgb (_tmp55_, 0.5, 0.0, 0.0);
	} else {
		cairo_t* _tmp56_ = NULL;
		_tmp56_ = context;
		cairo_set_source_rgb (_tmp56_, 0.9, 0.9, 0.9);
	}
	_tmp57_ = context;
	cairo_move_to (_tmp57_, (gdouble) 12, (gdouble) 30);
	_tmp58_ = context;
	cairo_line_to (_tmp58_, (gdouble) (-12), (gdouble) 30);
	_tmp59_ = context;
	cairo_stroke (_tmp59_);
	_tmp60_ = self->priv->eLight;
	if (_tmp60_) {
		cairo_t* _tmp61_ = NULL;
		_tmp61_ = context;
		cairo_set_source_rgb (_tmp61_, 0.5, 0.0, 0.0);
	} else {
		cairo_t* _tmp62_ = NULL;
		_tmp62_ = context;
		cairo_set_source_rgb (_tmp62_, 0.9, 0.9, 0.9);
	}
	_tmp63_ = context;
	cairo_move_to (_tmp63_, (gdouble) (-15), (gdouble) 27);
	_tmp64_ = context;
	cairo_line_to (_tmp64_, (gdouble) (-15), (gdouble) 3);
	_tmp65_ = context;
	cairo_stroke (_tmp65_);
	_tmp66_ = self->priv->fLight;
	if (_tmp66_) {
		cairo_t* _tmp67_ = NULL;
		_tmp67_ = context;
		cairo_set_source_rgb (_tmp67_, 0.5, 0.0, 0.0);
	} else {
		cairo_t* _tmp68_ = NULL;
		_tmp68_ = context;
		cairo_set_source_rgb (_tmp68_, 0.9, 0.9, 0.9);
	}
	_tmp69_ = context;
	cairo_move_to (_tmp69_, (gdouble) (-15), (gdouble) (-3));
	_tmp70_ = context;
	cairo_line_to (_tmp70_, (gdouble) (-15), (gdouble) (-27));
	_tmp71_ = context;
	cairo_stroke (_tmp71_);
	_tmp72_ = self->priv->gLight;
	if (_tmp72_) {
		cairo_t* _tmp73_ = NULL;
		_tmp73_ = context;
		cairo_set_source_rgb (_tmp73_, 0.5, 0.0, 0.0);
	} else {
		cairo_t* _tmp74_ = NULL;
		_tmp74_ = context;
		cairo_set_source_rgb (_tmp74_, 0.9, 0.9, 0.9);
	}
	_tmp75_ = context;
	cairo_move_to (_tmp75_, (gdouble) 12, (gdouble) 0);
	_tmp76_ = context;
	cairo_line_to (_tmp76_, (gdouble) (-12), (gdouble) 0);
	_tmp77_ = context;
	cairo_stroke (_tmp77_);
	_tmp78_ = self->priv->displayPoint;
	if (_tmp78_) {
		gboolean _tmp79_ = FALSE;
		cairo_line_cap_t oldLineCap = 0;
		cairo_t* _tmp82_ = NULL;
		cairo_line_cap_t _tmp83_ = 0;
		cairo_t* _tmp84_ = NULL;
		cairo_t* _tmp85_ = NULL;
		cairo_t* _tmp86_ = NULL;
		cairo_t* _tmp87_ = NULL;
		cairo_t* _tmp88_ = NULL;
		cairo_t* _tmp89_ = NULL;
		cairo_line_cap_t _tmp90_ = 0;
		_tmp79_ = self->priv->pointLight;
		if (_tmp79_) {
			cairo_t* _tmp80_ = NULL;
			_tmp80_ = context;
			cairo_set_source_rgb (_tmp80_, 0.5, 0.0, 0.0);
		} else {
			cairo_t* _tmp81_ = NULL;
			_tmp81_ = context;
			cairo_set_source_rgb (_tmp81_, 0.9, 0.9, 0.9);
		}
		_tmp82_ = context;
		_tmp83_ = cairo_get_line_cap (_tmp82_);
		oldLineCap = _tmp83_;
		_tmp84_ = context;
		cairo_set_line_cap (_tmp84_, CAIRO_LINE_CAP_ROUND);
		_tmp85_ = context;
		cairo_set_line_width (_tmp85_, (gdouble) 8);
		_tmp86_ = context;
		cairo_move_to (_tmp86_, 22.5, 27.5);
		_tmp87_ = context;
		cairo_line_to (_tmp87_, 22.5, 27.5);
		_tmp88_ = context;
		cairo_stroke (_tmp88_);
		_tmp89_ = context;
		_tmp90_ = oldLineCap;
		cairo_set_line_cap (_tmp89_, _tmp90_);
	}
	_tmp91_ = context;
	_tmp92_ = oldLineWidth;
	cairo_set_line_width (_tmp91_, _tmp92_);
	_tmp93_ = context;
	_tmp94_ = oldMatrix;
	cairo_set_matrix (_tmp93_, &_tmp94_);
}


static void basic_ss_display_component_state_real_update (ComponentState* base) {
	BasicSsDisplayComponentState * self;
	gint8 newInput = 0;
	gint _tmp0_ = 0;
	Connection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	Connection* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint8 _tmp8_ = 0;
	gint _tmp9_ = 0;
	Connection* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gint8 _tmp13_ = 0;
	gint _tmp14_ = 0;
	Connection* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gint8 _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	gint8 _tmp25_ = 0;
	gint8 _tmp26_ = 0;
	Connection* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	self = (BasicSsDisplayComponentState*) base;
	_tmp1_ = self->priv->input1Wire;
	_tmp2_ = connection_get_signalState (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	newInput = (gint8) _tmp0_;
	_tmp5_ = self->priv->input2Wire;
	_tmp6_ = connection_get_signalState (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp4_ = 2;
	} else {
		_tmp4_ = 0;
	}
	_tmp8_ = newInput;
	newInput = (gint8) (_tmp8_ + _tmp4_);
	_tmp10_ = self->priv->input4Wire;
	_tmp11_ = connection_get_signalState (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		_tmp9_ = 4;
	} else {
		_tmp9_ = 0;
	}
	_tmp13_ = newInput;
	newInput = (gint8) (_tmp13_ + _tmp9_);
	_tmp15_ = self->priv->input8Wire;
	_tmp16_ = connection_get_signalState (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		_tmp14_ = 8;
	} else {
		_tmp14_ = 0;
	}
	_tmp18_ = newInput;
	newInput = (gint8) (_tmp18_ + _tmp14_);
	_tmp19_ = ((ComponentState*) self)->display;
	if (_tmp19_) {
		gint8 _tmp20_ = 0;
		gint8 _tmp21_ = 0;
		_tmp20_ = self->priv->input;
		_tmp21_ = newInput;
		if (_tmp20_ != _tmp21_) {
			CompiledCircuit* _tmp22_ = NULL;
			UpdateQueue* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			_tmp22_ = ((ComponentState*) self)->compiledCircuit;
			_tmp23_ = _tmp22_->renderComponentStates;
			_tmp24_ = ((ComponentState*) self)->renderQueueID;
			update_queue_add_element (_tmp23_, _tmp24_);
		}
	}
	_tmp25_ = newInput;
	self->priv->input = _tmp25_;
	_tmp26_ = self->priv->input;
	switch (_tmp26_) {
		case 0:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = FALSE;
			break;
		}
		case 1:
		{
			self->priv->aLight = FALSE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = FALSE;
			self->priv->eLight = FALSE;
			self->priv->fLight = FALSE;
			self->priv->gLight = FALSE;
			break;
		}
		case 2:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = TRUE;
			self->priv->cLight = FALSE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = FALSE;
			self->priv->gLight = TRUE;
			break;
		}
		case 3:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = FALSE;
			self->priv->fLight = FALSE;
			self->priv->gLight = TRUE;
			break;
		}
		case 4:
		{
			self->priv->aLight = FALSE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = FALSE;
			self->priv->eLight = FALSE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 5:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = FALSE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = FALSE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 6:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = FALSE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 7:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = FALSE;
			self->priv->eLight = FALSE;
			self->priv->fLight = FALSE;
			self->priv->gLight = FALSE;
			break;
		}
		case 8:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 9:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = FALSE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 10:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = FALSE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 11:
		{
			self->priv->aLight = FALSE;
			self->priv->bLight = FALSE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 12:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = FALSE;
			self->priv->cLight = FALSE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = FALSE;
			break;
		}
		case 13:
		{
			self->priv->aLight = FALSE;
			self->priv->bLight = TRUE;
			self->priv->cLight = TRUE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = FALSE;
			self->priv->gLight = TRUE;
			break;
		}
		case 14:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = FALSE;
			self->priv->cLight = FALSE;
			self->priv->dLight = TRUE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		case 15:
		{
			self->priv->aLight = TRUE;
			self->priv->bLight = FALSE;
			self->priv->cLight = FALSE;
			self->priv->dLight = FALSE;
			self->priv->eLight = TRUE;
			self->priv->fLight = TRUE;
			self->priv->gLight = TRUE;
			break;
		}
		default:
		break;
	}
	_tmp27_ = self->priv->inputPWire;
	_tmp28_ = connection_get_signalState (_tmp27_);
	_tmp29_ = _tmp28_;
	self->priv->pointLight = _tmp29_;
}


static void basic_ss_display_component_state_class_init (BasicSsDisplayComponentStateClass * klass) {
	basic_ss_display_component_state_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_STATE_CLASS (klass)->finalize = basic_ss_display_component_state_finalize;
	g_type_class_add_private (klass, sizeof (BasicSsDisplayComponentStatePrivate));
	COMPONENT_STATE_CLASS (klass)->render = basic_ss_display_component_state_real_render;
	COMPONENT_STATE_CLASS (klass)->update = basic_ss_display_component_state_real_update;
}


static void basic_ss_display_component_state_instance_init (BasicSsDisplayComponentState * self) {
	self->priv = BASIC_SS_DISPLAY_COMPONENT_STATE_GET_PRIVATE (self);
}


static void basic_ss_display_component_state_finalize (ComponentState* obj) {
	BasicSsDisplayComponentState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASIC_SS_DISPLAY_COMPONENT_STATE, BasicSsDisplayComponentState);
	_connection_unref0 (self->priv->input1Wire);
	_connection_unref0 (self->priv->input2Wire);
	_connection_unref0 (self->priv->input4Wire);
	_connection_unref0 (self->priv->input8Wire);
	_connection_unref0 (self->priv->inputPWire);
	COMPONENT_STATE_CLASS (basic_ss_display_component_state_parent_class)->finalize (obj);
}


GType basic_ss_display_component_state_get_type (void) {
	static volatile gsize basic_ss_display_component_state_type_id__volatile = 0;
	if (g_once_init_enter (&basic_ss_display_component_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BasicSsDisplayComponentStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_ss_display_component_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicSsDisplayComponentState), 0, (GInstanceInitFunc) basic_ss_display_component_state_instance_init, NULL };
		GType basic_ss_display_component_state_type_id;
		basic_ss_display_component_state_type_id = g_type_register_static (TYPE_COMPONENT_STATE, "BasicSsDisplayComponentState", &g_define_type_info, 0);
		g_once_init_leave (&basic_ss_display_component_state_type_id__volatile, basic_ss_display_component_state_type_id);
	}
	return basic_ss_display_component_state_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



