/* state-memory.c generated by valac 0.24.0, the Vala compiler
 * generated from state-memory.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: componentstate/state-memory.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <glib/gstdio.h>


#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;
typedef struct _ComponentStatePrivate ComponentStatePrivate;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_MEMORY_COMPONENT_STATE (memory_component_state_get_type ())
#define MEMORY_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEMORY_COMPONENT_STATE, MemoryComponentState))
#define MEMORY_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEMORY_COMPONENT_STATE, MemoryComponentStateClass))
#define IS_MEMORY_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEMORY_COMPONENT_STATE))
#define IS_MEMORY_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEMORY_COMPONENT_STATE))
#define MEMORY_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEMORY_COMPONENT_STATE, MemoryComponentStateClass))

typedef struct _MemoryComponentState MemoryComponentState;
typedef struct _MemoryComponentStateClass MemoryComponentStateClass;
typedef struct _MemoryComponentStatePrivate MemoryComponentStatePrivate;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define MEMORY_COMPONENT_STATE_TYPE_MEMORY_TYPE (memory_component_state_memory_type_get_type ())
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

struct _ComponentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentStatePrivate * priv;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	ComponentInst* componentInst;
	gint renderQueueID;
	gint processQueueID;
	gboolean display;
};

struct _ComponentStateClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentState *self);
	void (*update) (ComponentState* self);
	void (*click) (ComponentState* self);
	void (*render) (ComponentState* self, cairo_t* context);
	gboolean (*get_alwaysUpdate) (ComponentState* self);
};

struct _MemoryComponentState {
	ComponentState parent_instance;
	MemoryComponentStatePrivate * priv;
};

struct _MemoryComponentStateClass {
	ComponentStateClass parent_class;
};

typedef enum  {
	MEMORY_COMPONENT_STATE_MEMORY_TYPE_RAM_CS_RE_WE,
	MEMORY_COMPONENT_STATE_MEMORY_TYPE_ROM_CS
} MemoryComponentStateMemoryType;

struct _MemoryComponentStatePrivate {
	Connection** addressWires;
	gint addressWires_length1;
	gint _addressWires_size_;
	Connection** dataWires;
	gint dataWires_length1;
	gint _dataWires_size_;
	Connection* selectWire;
	Connection* readEnableWire;
	Connection* writeEnableWire;
	Connection* clockWire;
	MemoryComponentStateMemoryType memoryType;
	guint width;
	guint64 memorySize;
	guint64 memorySizeBytes;
	guint64 addresses;
	gchar* memory;
	gboolean previousClockSignal;
	gchar* readFilename;
	gchar* writeFilename;
};

typedef enum  {
	COMPONENT_STATE_ERROR_COMPILE
} ComponentStateError;
#define COMPONENT_STATE_ERROR component_state_error_quark ()

static gpointer memory_component_state_parent_class = NULL;

gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
GType memory_component_state_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
static GType memory_component_state_memory_type_get_type (void) G_GNUC_UNUSED;
#define MEMORY_COMPONENT_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEMORY_COMPONENT_STATE, MemoryComponentStatePrivate))
enum  {
	MEMORY_COMPONENT_STATE_DUMMY_PROPERTY
};
static void memory_component_state_write_file (MemoryComponentState* self);
GQuark component_state_error_quark (void);
MemoryComponentState* memory_component_state_new (Connection** addressWires, int addressWires_length1, Connection** dataWires, int dataWires_length1, Connection* selectWire, Connection* readEnableWire, Connection* writeEnableWire, Connection* clockWire, gboolean readWrite, const gchar* readFilename, const gchar* writeFilename, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
MemoryComponentState* memory_component_state_construct (GType object_type, Connection** addressWires, int addressWires_length1, Connection** dataWires, int dataWires_length1, Connection* selectWire, Connection* readEnableWire, Connection* writeEnableWire, Connection* clockWire, gboolean readWrite, const gchar* readFilename, const gchar* writeFilename, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
ComponentState* component_state_construct (GType object_type);
static Connection** _vala_array_dup26 (Connection** self, int length);
void connection_set_affects (Connection* self, ComponentState* componentState);
static Connection** _vala_array_dup27 (Connection** self, int length);
static gint memory_component_state_allocate_memory (MemoryComponentState* self);
static void memory_component_state_read_file (MemoryComponentState* self);
static ComponentInst** _vala_array_dup28 (ComponentInst** self, int length);
static gboolean memory_component_state_get_memory (MemoryComponentState* self, guint address, guint bit);
static void memory_component_state_set_memory (MemoryComponentState* self, guint address, guint bit, gboolean bitValue);
static void memory_component_state_real_update (ComponentState* base);
gboolean connection_get_signalState (Connection* self);
void connection_set_signalState (Connection* self, gboolean value);
void connection_disable_signal (Connection* self);
static void memory_component_state_finalize (ComponentState* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType memory_component_state_memory_type_get_type (void) {
	static volatile gsize memory_component_state_memory_type_type_id__volatile = 0;
	if (g_once_init_enter (&memory_component_state_memory_type_type_id__volatile)) {
		static const GEnumValue values[] = {{MEMORY_COMPONENT_STATE_MEMORY_TYPE_RAM_CS_RE_WE, "MEMORY_COMPONENT_STATE_MEMORY_TYPE_RAM_CS_RE_WE", "ram-cs-re-we"}, {MEMORY_COMPONENT_STATE_MEMORY_TYPE_ROM_CS, "MEMORY_COMPONENT_STATE_MEMORY_TYPE_ROM_CS", "rom-cs"}, {0, NULL, NULL}};
		GType memory_component_state_memory_type_type_id;
		memory_component_state_memory_type_type_id = g_enum_register_static ("MemoryComponentStateMemoryType", values);
		g_once_init_leave (&memory_component_state_memory_type_type_id__volatile, memory_component_state_memory_type_type_id);
	}
	return memory_component_state_memory_type_type_id__volatile;
}


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static Connection** _vala_array_dup26 (Connection** self, int length) {
	Connection** result;
	int i;
	result = g_new0 (Connection*, length + 1);
	for (i = 0; i < length; i++) {
		Connection* _tmp0_ = NULL;
		_tmp0_ = _connection_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Connection** _vala_array_dup27 (Connection** self, int length) {
	Connection** result;
	int i;
	result = g_new0 (Connection*, length + 1);
	for (i = 0; i < length; i++) {
		Connection* _tmp0_ = NULL;
		_tmp0_ = _connection_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


static ComponentInst** _vala_array_dup28 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


MemoryComponentState* memory_component_state_construct (GType object_type, Connection** addressWires, int addressWires_length1, Connection** dataWires, int dataWires_length1, Connection* selectWire, Connection* readEnableWire, Connection* writeEnableWire, Connection* clockWire, gboolean readWrite, const gchar* readFilename, const gchar* writeFilename, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error) {
	MemoryComponentState* self = NULL;
	Connection** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Connection** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	Connection** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Connection** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	Connection** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	Connection** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	Connection* _tmp10_ = NULL;
	Connection* _tmp11_ = NULL;
	Connection* _tmp12_ = NULL;
	Connection* _tmp13_ = NULL;
	Connection* _tmp14_ = NULL;
	Connection* _tmp15_ = NULL;
	Connection* _tmp16_ = NULL;
	Connection* _tmp17_ = NULL;
	Connection* _tmp18_ = NULL;
	Connection* _tmp19_ = NULL;
	Connection* _tmp20_ = NULL;
	Connection* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	Connection** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	Connection** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	Connection** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	Connection** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	gfloat _tmp40_ = 0.0F;
	gfloat _tmp41_ = 0.0F;
	Connection** _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	Connection** _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	guint64 _tmp45_ = 0ULL;
	guint _tmp46_ = 0U;
	guint64 _tmp47_ = 0ULL;
	gint allocationResult = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	ComponentInst** _tmp75_ = NULL;
	gint _tmp75__length1 = 0;
	ComponentInst** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	ComponentInst* _tmp77_ = NULL;
	ComponentInst* _tmp78_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (selectWire != NULL, NULL);
	g_return_val_if_fail (readEnableWire != NULL, NULL);
	g_return_val_if_fail (writeEnableWire != NULL, NULL);
	g_return_val_if_fail (clockWire != NULL, NULL);
	g_return_val_if_fail (readFilename != NULL, NULL);
	g_return_val_if_fail (writeFilename != NULL, NULL);
	g_return_val_if_fail (componentInst != NULL, NULL);
	self = (MemoryComponentState*) component_state_construct (object_type);
	_tmp0_ = addressWires;
	_tmp0__length1 = addressWires_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup26 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->addressWires = (_vala_array_free (self->priv->addressWires, self->priv->addressWires_length1, (GDestroyNotify) connection_unref), NULL);
	self->priv->addressWires = _tmp1_;
	self->priv->addressWires_length1 = _tmp1__length1;
	self->priv->_addressWires_size_ = self->priv->addressWires_length1;
	_tmp2_ = addressWires;
	_tmp2__length1 = addressWires_length1;
	{
		Connection** addressWire_collection = NULL;
		gint addressWire_collection_length1 = 0;
		gint _addressWire_collection_size_ = 0;
		gint addressWire_it = 0;
		addressWire_collection = _tmp2_;
		addressWire_collection_length1 = _tmp2__length1;
		for (addressWire_it = 0; addressWire_it < _tmp2__length1; addressWire_it = addressWire_it + 1) {
			Connection* _tmp3_ = NULL;
			Connection* addressWire = NULL;
			_tmp3_ = _connection_ref0 (addressWire_collection[addressWire_it]);
			addressWire = _tmp3_;
			{
				Connection* _tmp4_ = NULL;
				_tmp4_ = addressWire;
				connection_set_affects (_tmp4_, (ComponentState*) self);
				_connection_unref0 (addressWire);
			}
		}
	}
	_tmp5_ = dataWires;
	_tmp5__length1 = dataWires_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup27 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	self->priv->dataWires = (_vala_array_free (self->priv->dataWires, self->priv->dataWires_length1, (GDestroyNotify) connection_unref), NULL);
	self->priv->dataWires = _tmp6_;
	self->priv->dataWires_length1 = _tmp6__length1;
	self->priv->_dataWires_size_ = self->priv->dataWires_length1;
	_tmp7_ = dataWires;
	_tmp7__length1 = dataWires_length1;
	{
		Connection** dataWire_collection = NULL;
		gint dataWire_collection_length1 = 0;
		gint _dataWire_collection_size_ = 0;
		gint dataWire_it = 0;
		dataWire_collection = _tmp7_;
		dataWire_collection_length1 = _tmp7__length1;
		for (dataWire_it = 0; dataWire_it < _tmp7__length1; dataWire_it = dataWire_it + 1) {
			Connection* _tmp8_ = NULL;
			Connection* dataWire = NULL;
			_tmp8_ = _connection_ref0 (dataWire_collection[dataWire_it]);
			dataWire = _tmp8_;
			{
				Connection* _tmp9_ = NULL;
				_tmp9_ = dataWire;
				connection_set_affects (_tmp9_, (ComponentState*) self);
				_connection_unref0 (dataWire);
			}
		}
	}
	_tmp10_ = selectWire;
	_tmp11_ = _connection_ref0 (_tmp10_);
	_connection_unref0 (self->priv->selectWire);
	self->priv->selectWire = _tmp11_;
	_tmp12_ = selectWire;
	connection_set_affects (_tmp12_, (ComponentState*) self);
	_tmp13_ = readEnableWire;
	_tmp14_ = _connection_ref0 (_tmp13_);
	_connection_unref0 (self->priv->readEnableWire);
	self->priv->readEnableWire = _tmp14_;
	_tmp15_ = readEnableWire;
	connection_set_affects (_tmp15_, (ComponentState*) self);
	_tmp16_ = writeEnableWire;
	_tmp17_ = _connection_ref0 (_tmp16_);
	_connection_unref0 (self->priv->writeEnableWire);
	self->priv->writeEnableWire = _tmp17_;
	_tmp18_ = writeEnableWire;
	connection_set_affects (_tmp18_, (ComponentState*) self);
	_tmp19_ = clockWire;
	_tmp20_ = _connection_ref0 (_tmp19_);
	_connection_unref0 (self->priv->clockWire);
	self->priv->clockWire = _tmp20_;
	_tmp21_ = clockWire;
	connection_set_affects (_tmp21_, (ComponentState*) self);
	_tmp22_ = readFilename;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (self->priv->readFilename);
	self->priv->readFilename = _tmp23_;
	_tmp24_ = writeFilename;
	_tmp25_ = g_strdup (_tmp24_);
	_g_free0 (self->priv->writeFilename);
	self->priv->writeFilename = _tmp25_;
	_tmp26_ = readWrite;
	if (_tmp26_) {
		self->priv->memoryType = MEMORY_COMPONENT_STATE_MEMORY_TYPE_RAM_CS_RE_WE;
	} else {
		self->priv->memoryType = MEMORY_COMPONENT_STATE_MEMORY_TYPE_ROM_CS;
	}
	_tmp27_ = addressWires;
	_tmp27__length1 = addressWires_length1;
	if (_tmp27__length1 >= 64) {
		GError* _tmp28_ = NULL;
		_tmp28_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, "Memory chips with 64 or more address wires are not supported.");
		_inner_error_ = _tmp28_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_state_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp29_ = addressWires;
	_tmp29__length1 = addressWires_length1;
	if (((gulong) _tmp29__length1) >= (sizeof (guint) * 8)) {
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
		GError* _tmp37_ = NULL;
		_tmp30_ = g_strdup_printf ("%lu", ((gulong) sizeof (guint)) * 8);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat ("Memory chips with ", _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp33_, " or more address wires are not supported on this host system.", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_state_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp38_ = addressWires;
	_tmp38__length1 = addressWires_length1;
	_tmp39_ = dataWires;
	_tmp39__length1 = dataWires_length1;
	_tmp40_ = logf ((gfloat) _tmp39__length1);
	_tmp41_ = logf (8.0f);
	if (((gdouble) (((gfloat) _tmp38__length1) + ((gfloat) (_tmp40_ / _tmp41_)))) >= 61.0) {
		GError* _tmp42_ = NULL;
		_tmp42_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, "Memory chips which store 2^64 or more bits are not supported.");
		_inner_error_ = _tmp42_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_state_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp43_ = addressWires;
	_tmp43__length1 = addressWires_length1;
	self->priv->addresses = ((guint64) 1) << _tmp43__length1;
	_tmp44_ = dataWires;
	_tmp44__length1 = dataWires_length1;
	self->priv->width = (guint) _tmp44__length1;
	_tmp45_ = self->priv->addresses;
	_tmp46_ = self->priv->width;
	self->priv->memorySize = _tmp45_ * ((guint64) _tmp46_);
	_tmp47_ = self->priv->memorySize;
	self->priv->memorySizeBytes = (_tmp47_ + ((guint64) 7)) / ((guint64) 8);
	_tmp48_ = memory_component_state_allocate_memory (self);
	allocationResult = _tmp48_;
	_tmp49_ = allocationResult;
	switch (_tmp49_) {
		case 1:
		{
			guint64 _tmp50_ = 0ULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			GError* _tmp57_ = NULL;
			GError* _tmp58_ = NULL;
			_tmp50_ = self->priv->memorySizeBytes;
			_tmp51_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strconcat ("The host system does not have enough free memory to emulate this memor" \
"y chip of size ", _tmp52_, NULL);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strconcat (_tmp54_, " bytes.", NULL);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, _tmp56_);
			_tmp58_ = _tmp57_;
			_g_free0 (_tmp56_);
			_g_free0 (_tmp54_);
			_g_free0 (_tmp52_);
			_inner_error_ = _tmp58_;
			if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_component_state_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		case 2:
		{
			gulong _tmp59_ = 0UL;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			guint64 _tmp66_ = 0ULL;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			GError* _tmp73_ = NULL;
			GError* _tmp74_ = NULL;
			_tmp59_ = G_MAXSIZE;
			_tmp60_ = g_strdup_printf ("%lu", _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = g_strconcat ("The host system does not support memory chips of size greater than ", _tmp61_, NULL);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strconcat (_tmp63_, " bytes. Required ", NULL);
			_tmp65_ = _tmp64_;
			_tmp66_ = self->priv->memorySizeBytes;
			_tmp67_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strconcat (_tmp65_, _tmp68_, NULL);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strconcat (_tmp70_, " bytes.", NULL);
			_tmp72_ = _tmp71_;
			_tmp73_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, _tmp72_);
			_tmp74_ = _tmp73_;
			_g_free0 (_tmp72_);
			_g_free0 (_tmp70_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp65_);
			_g_free0 (_tmp63_);
			_g_free0 (_tmp61_);
			_inner_error_ = _tmp74_;
			if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_component_state_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		default:
		break;
	}
	memory_component_state_read_file (self);
	_tmp75_ = ancestry;
	_tmp75__length1 = ancestry_length1;
	_tmp76_ = (_tmp75_ != NULL) ? _vala_array_dup28 (_tmp75_, _tmp75__length1) : ((gpointer) _tmp75_);
	_tmp76__length1 = _tmp75__length1;
	((ComponentState*) self)->ancestry = (_vala_array_free (((ComponentState*) self)->ancestry, ((ComponentState*) self)->ancestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	((ComponentState*) self)->ancestry = _tmp76_;
	((ComponentState*) self)->ancestry_length1 = _tmp76__length1;
	_tmp77_ = componentInst;
	_tmp78_ = _component_inst_ref0 (_tmp77_);
	_component_inst_unref0 (((ComponentState*) self)->componentInst);
	((ComponentState*) self)->componentInst = _tmp78_;
	return self;
}


MemoryComponentState* memory_component_state_new (Connection** addressWires, int addressWires_length1, Connection** dataWires, int dataWires_length1, Connection* selectWire, Connection* readEnableWire, Connection* writeEnableWire, Connection* clockWire, gboolean readWrite, const gchar* readFilename, const gchar* writeFilename, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error) {
	return memory_component_state_construct (TYPE_MEMORY_COMPONENT_STATE, addressWires, addressWires_length1, dataWires, dataWires_length1, selectWire, readEnableWire, writeEnableWire, clockWire, readWrite, readFilename, writeFilename, ancestry, ancestry_length1, componentInst, error);
}


static void memory_component_state_read_file (MemoryComponentState* self) {
	const gchar* _tmp0_ = NULL;
	FILE* readFile = NULL;
	const gchar* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->readFilename;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		return;
	}
	_tmp1_ = self->priv->readFilename;
	_tmp2_ = g_fopen (_tmp1_, "r");
	readFile = _tmp2_;
	_tmp3_ = readFile;
	if (_tmp3_ == NULL) {
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = self->priv->readFilename;
		fprintf (_tmp4_, "Could not load initial memory from file \"%s\".\n", _tmp5_);
		_fclose0 (readFile);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				guint64 _tmp9_ = 0ULL;
				gint byte = 0;
				FILE* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = self->priv->memorySizeBytes;
				if (!(((guint64) _tmp8_) < _tmp9_)) {
					break;
				}
				_tmp10_ = readFile;
				_tmp11_ = fgetc (_tmp10_);
				byte = _tmp11_;
				_tmp12_ = byte;
				if (_tmp12_ != (-1)) {
					gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gchar _tmp16_ = '\0';
					_tmp13_ = self->priv->memory;
					_tmp14_ = i;
					_tmp15_ = byte;
					_tmp13_[_tmp14_] = (gchar) _tmp15_;
					_tmp16_ = _tmp13_[_tmp14_];
				} else {
					break;
				}
			}
		}
	}
	_fclose0 (readFile);
}


static void memory_component_state_write_file (MemoryComponentState* self) {
	const gchar* _tmp0_ = NULL;
	FILE* writeFile = NULL;
	const gchar* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->writeFilename;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		return;
	}
	_tmp1_ = self->priv->writeFilename;
	_tmp2_ = g_fopen (_tmp1_, "w");
	writeFile = _tmp2_;
	_tmp3_ = writeFile;
	if (_tmp3_ == NULL) {
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = self->priv->writeFilename;
		fprintf (_tmp4_, "Could not save final memory to file \"%s\".\n", _tmp5_);
		_fclose0 (writeFile);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				guint64 _tmp9_ = 0ULL;
				FILE* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gchar _tmp13_ = '\0';
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = self->priv->memorySizeBytes;
				if (!(((guint64) _tmp8_) < _tmp9_)) {
					break;
				}
				_tmp10_ = writeFile;
				_tmp11_ = self->priv->memory;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				fputc (_tmp13_, _tmp10_);
			}
		}
	}
	_fclose0 (writeFile);
}


/**
 * Allocates memory. Returns non 0 on failure.
 */
static gint memory_component_state_allocate_memory (MemoryComponentState* self) {
	gint result = 0;
	guint64 _tmp0_ = 0ULL;
	gulong _tmp1_ = 0UL;
	guint64 _tmp9_ = 0ULL;
	void* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->memorySizeBytes;
	_tmp1_ = G_MAXSIZE;
	if (_tmp0_ > ((guint64) _tmp1_)) {
		FILE* _tmp2_ = NULL;
		guint64 _tmp3_ = 0ULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gulong _tmp6_ = 0UL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = self->priv->memorySizeBytes;
		_tmp4_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = G_MAXSIZE;
		_tmp7_ = g_strdup_printf ("%lu", _tmp6_);
		_tmp8_ = _tmp7_;
		fprintf (_tmp2_, "The memory block cannot be allocated (%s in %s).\n", _tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		result = 2;
		return result;
	}
	_tmp9_ = self->priv->memorySizeBytes;
	_tmp10_ = g_try_malloc0 ((gsize) _tmp9_);
	self->priv->memory = _tmp10_;
	_tmp11_ = self->priv->memory;
	if (_tmp11_ == NULL) {
		FILE* _tmp12_ = NULL;
		guint64 _tmp13_ = 0ULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = self->priv->memorySizeBytes;
		_tmp14_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp13_);
		_tmp15_ = _tmp14_;
		fprintf (_tmp12_, "There is not enough free host memory to create this memory block (%s)." \
"\n", _tmp15_);
		_g_free0 (_tmp15_);
		result = 1;
		return result;
	} else {
		result = 0;
		return result;
	}
}


/**
 * Returns the bit value of the specified bit of the word at the
 * given address.
 */
static gboolean memory_component_state_get_memory (MemoryComponentState* self, guint address, guint bit) {
	gboolean result = FALSE;
	guint memoryLocation = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint byteNumber = 0U;
	guint _tmp4_ = 0U;
	guint bitNumber = 0U;
	guint _tmp5_ = 0U;
	gchar byte = '\0';
	gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar _tmp8_ = '\0';
	gchar _tmp9_ = '\0';
	guint _tmp10_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = address;
	_tmp1_ = self->priv->width;
	_tmp2_ = self->priv->width;
	_tmp3_ = bit;
	memoryLocation = (_tmp0_ * _tmp1_) + ((_tmp2_ - _tmp3_) - 1);
	_tmp4_ = memoryLocation;
	byteNumber = _tmp4_ / 8;
	_tmp5_ = memoryLocation;
	bitNumber = 7 - (_tmp5_ % 8);
	_tmp6_ = self->priv->memory;
	_tmp7_ = byteNumber;
	_tmp8_ = _tmp6_[_tmp7_];
	byte = _tmp8_;
	_tmp9_ = byte;
	_tmp10_ = bitNumber;
	if (((_tmp9_ >> _tmp10_) & 1) == ((guint) 1)) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
 * Sets the bit value of the specified bit of the word at the given
 * address to //bitValue//.
 */
static void memory_component_state_set_memory (MemoryComponentState* self, guint address, guint bit, gboolean bitValue) {
	guint memoryLocation = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint byteNumber = 0U;
	guint _tmp4_ = 0U;
	guint bitNumber = 0U;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = address;
	_tmp1_ = self->priv->width;
	_tmp2_ = self->priv->width;
	_tmp3_ = bit;
	memoryLocation = (_tmp0_ * _tmp1_) + ((_tmp2_ - _tmp3_) - 1);
	_tmp4_ = memoryLocation;
	byteNumber = _tmp4_ / 8;
	_tmp5_ = memoryLocation;
	bitNumber = 7 - (_tmp5_ % 8);
	_tmp6_ = bitValue;
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		gchar _tmp10_ = '\0';
		_tmp7_ = self->priv->memory;
		_tmp8_ = byteNumber;
		_tmp9_ = bitNumber;
		_tmp7_[_tmp8_] |= (gchar) (1 << _tmp9_);
		_tmp10_ = _tmp7_[_tmp8_];
	} else {
		gchar* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
		gchar _tmp14_ = '\0';
		_tmp11_ = self->priv->memory;
		_tmp12_ = byteNumber;
		_tmp13_ = bitNumber;
		_tmp11_[_tmp12_] &= ~((gchar) (1 << _tmp13_));
		_tmp14_ = _tmp11_[_tmp12_];
	}
}


static void memory_component_state_real_update (ComponentState* base) {
	MemoryComponentState * self;
	guint address = 0U;
	gchar* _tmp0_ = NULL;
	Connection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp49_ = FALSE;
	Connection* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
	Connection* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	self = (MemoryComponentState*) base;
	address = (guint) 0;
	_tmp0_ = self->priv->memory;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->selectWire;
	_tmp2_ = connection_get_signalState (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Connection* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp34_ = FALSE;
		Connection* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gint _tmp6_ = 0;
					Connection** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					Connection** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					Connection* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					if (!_tmp4_) {
						gint _tmp5_ = 0;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = i;
					_tmp7_ = self->priv->addressWires;
					_tmp7__length1 = self->priv->addressWires_length1;
					if (!(_tmp6_ < _tmp7__length1)) {
						break;
					}
					_tmp8_ = self->priv->addressWires;
					_tmp8__length1 = self->priv->addressWires_length1;
					_tmp9_ = i;
					_tmp10_ = _tmp8_[_tmp9_];
					_tmp11_ = connection_get_signalState (_tmp10_);
					_tmp12_ = _tmp11_;
					if (_tmp12_) {
						guint _tmp13_ = 0U;
						gint _tmp14_ = 0;
						_tmp13_ = address;
						_tmp14_ = i;
						address = _tmp13_ + (1 << _tmp14_);
					}
				}
			}
		}
		_tmp15_ = self->priv->writeEnableWire;
		_tmp16_ = connection_get_signalState (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_) {
			gboolean _tmp18_ = FALSE;
			Connection* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			_tmp19_ = self->priv->clockWire;
			_tmp20_ = connection_get_signalState (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				gboolean _tmp22_ = FALSE;
				_tmp22_ = self->priv->previousClockSignal;
				_tmp18_ = !_tmp22_;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				{
					guint i = 0U;
					i = (guint) 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							guint _tmp25_ = 0U;
							guint _tmp26_ = 0U;
							guint _tmp27_ = 0U;
							guint _tmp28_ = 0U;
							Connection** _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							guint _tmp30_ = 0U;
							Connection* _tmp31_ = NULL;
							gboolean _tmp32_ = FALSE;
							gboolean _tmp33_ = FALSE;
							if (!_tmp23_) {
								guint _tmp24_ = 0U;
								_tmp24_ = i;
								i = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = i;
							_tmp26_ = self->priv->width;
							if (!(_tmp25_ < _tmp26_)) {
								break;
							}
							_tmp27_ = address;
							_tmp28_ = i;
							_tmp29_ = self->priv->dataWires;
							_tmp29__length1 = self->priv->dataWires_length1;
							_tmp30_ = i;
							_tmp31_ = _tmp29_[_tmp30_];
							_tmp32_ = connection_get_signalState (_tmp31_);
							_tmp33_ = _tmp32_;
							memory_component_state_set_memory (self, _tmp27_, _tmp28_, _tmp33_);
						}
					}
				}
			}
		}
		_tmp35_ = self->priv->readEnableWire;
		_tmp36_ = connection_get_signalState (_tmp35_);
		_tmp37_ = _tmp36_;
		if (_tmp37_) {
			_tmp34_ = TRUE;
		} else {
			MemoryComponentStateMemoryType _tmp38_ = 0;
			_tmp38_ = self->priv->memoryType;
			_tmp34_ = _tmp38_ == MEMORY_COMPONENT_STATE_MEMORY_TYPE_ROM_CS;
		}
		if (_tmp34_) {
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp39_ = FALSE;
					_tmp39_ = TRUE;
					while (TRUE) {
						guint _tmp41_ = 0U;
						guint _tmp42_ = 0U;
						Connection** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
						guint _tmp44_ = 0U;
						Connection* _tmp45_ = NULL;
						guint _tmp46_ = 0U;
						guint _tmp47_ = 0U;
						gboolean _tmp48_ = FALSE;
						if (!_tmp39_) {
							guint _tmp40_ = 0U;
							_tmp40_ = i;
							i = _tmp40_ + 1;
						}
						_tmp39_ = FALSE;
						_tmp41_ = i;
						_tmp42_ = self->priv->width;
						if (!(_tmp41_ < _tmp42_)) {
							break;
						}
						_tmp43_ = self->priv->dataWires;
						_tmp43__length1 = self->priv->dataWires_length1;
						_tmp44_ = i;
						_tmp45_ = _tmp43_[_tmp44_];
						_tmp46_ = address;
						_tmp47_ = i;
						_tmp48_ = memory_component_state_get_memory (self, _tmp46_, _tmp47_);
						connection_set_signalState (_tmp45_, _tmp48_);
					}
				}
			}
		}
	}
	_tmp50_ = self->priv->selectWire;
	_tmp51_ = connection_get_signalState (_tmp50_);
	_tmp52_ = _tmp51_;
	if (!_tmp52_) {
		_tmp49_ = TRUE;
	} else {
		gboolean _tmp53_ = FALSE;
		Connection* _tmp54_ = NULL;
		gboolean _tmp55_ = FALSE;
		gboolean _tmp56_ = FALSE;
		_tmp54_ = self->priv->readEnableWire;
		_tmp55_ = connection_get_signalState (_tmp54_);
		_tmp56_ = _tmp55_;
		if (!_tmp56_) {
			MemoryComponentStateMemoryType _tmp57_ = 0;
			_tmp57_ = self->priv->memoryType;
			_tmp53_ = _tmp57_ == MEMORY_COMPONENT_STATE_MEMORY_TYPE_RAM_CS_RE_WE;
		} else {
			_tmp53_ = FALSE;
		}
		_tmp49_ = _tmp53_;
	}
	if (_tmp49_) {
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp58_ = FALSE;
				_tmp58_ = TRUE;
				while (TRUE) {
					guint _tmp60_ = 0U;
					guint _tmp61_ = 0U;
					Connection** _tmp62_ = NULL;
					gint _tmp62__length1 = 0;
					guint _tmp63_ = 0U;
					Connection* _tmp64_ = NULL;
					if (!_tmp58_) {
						guint _tmp59_ = 0U;
						_tmp59_ = i;
						i = _tmp59_ + 1;
					}
					_tmp58_ = FALSE;
					_tmp60_ = i;
					_tmp61_ = self->priv->width;
					if (!(_tmp60_ < _tmp61_)) {
						break;
					}
					_tmp62_ = self->priv->dataWires;
					_tmp62__length1 = self->priv->dataWires_length1;
					_tmp63_ = i;
					_tmp64_ = _tmp62_[_tmp63_];
					connection_disable_signal (_tmp64_);
				}
			}
		}
	}
	_tmp65_ = self->priv->clockWire;
	_tmp66_ = connection_get_signalState (_tmp65_);
	_tmp67_ = _tmp66_;
	self->priv->previousClockSignal = _tmp67_;
}


static void memory_component_state_class_init (MemoryComponentStateClass * klass) {
	memory_component_state_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_STATE_CLASS (klass)->finalize = memory_component_state_finalize;
	g_type_class_add_private (klass, sizeof (MemoryComponentStatePrivate));
	COMPONENT_STATE_CLASS (klass)->update = memory_component_state_real_update;
}


static void memory_component_state_instance_init (MemoryComponentState * self) {
	self->priv = MEMORY_COMPONENT_STATE_GET_PRIVATE (self);
}


static void memory_component_state_finalize (ComponentState* obj) {
	MemoryComponentState * self;
	gchar* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEMORY_COMPONENT_STATE, MemoryComponentState);
	memory_component_state_write_file (self);
	_tmp0_ = self->priv->memory;
	g_free (_tmp0_);
	self->priv->addressWires = (_vala_array_free (self->priv->addressWires, self->priv->addressWires_length1, (GDestroyNotify) connection_unref), NULL);
	self->priv->dataWires = (_vala_array_free (self->priv->dataWires, self->priv->dataWires_length1, (GDestroyNotify) connection_unref), NULL);
	_connection_unref0 (self->priv->selectWire);
	_connection_unref0 (self->priv->readEnableWire);
	_connection_unref0 (self->priv->writeEnableWire);
	_connection_unref0 (self->priv->clockWire);
	_g_free0 (self->priv->readFilename);
	_g_free0 (self->priv->writeFilename);
	COMPONENT_STATE_CLASS (memory_component_state_parent_class)->finalize (obj);
}


GType memory_component_state_get_type (void) {
	static volatile gsize memory_component_state_type_id__volatile = 0;
	if (g_once_init_enter (&memory_component_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MemoryComponentStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) memory_component_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MemoryComponentState), 0, (GInstanceInitFunc) memory_component_state_instance_init, NULL };
		GType memory_component_state_type_id;
		memory_component_state_type_id = g_type_register_static (TYPE_COMPONENT_STATE, "MemoryComponentState", &g_define_type_info, 0);
		g_once_init_leave (&memory_component_state_type_id__volatile, memory_component_state_type_id);
	}
	return memory_component_state_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



