/* customiser.c generated by valac 0.24.0, the Vala compiler
 * generated from customiser.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: customiser.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CUSTOMISER (customiser_get_type ())
#define CUSTOMISER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOMISER, Customiser))
#define CUSTOMISER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOMISER, CustomiserClass))
#define IS_CUSTOMISER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOMISER))
#define IS_CUSTOMISER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOMISER))
#define CUSTOMISER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOMISER, CustomiserClass))

typedef struct _Customiser Customiser;
typedef struct _CustomiserClass CustomiserClass;
typedef struct _CustomiserPrivate CustomiserPrivate;

#define CUSTOMISER_TYPE_MOUSE_MODE (customiser_mouse_mode_get_type ())

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_DESIGNER_WINDOW (designer_window_get_type ())
#define DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER_WINDOW, DesignerWindow))
#define DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER_WINDOW, DesignerWindowClass))
#define IS_DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER_WINDOW))
#define IS_DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER_WINDOW))
#define DESIGNER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER_WINDOW, DesignerWindowClass))

typedef struct _DesignerWindow DesignerWindow;
typedef struct _DesignerWindowClass DesignerWindowClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _project_unref0(var) ((var == NULL) ? NULL : (var = (project_unref (var), NULL)))
#define _pin_def_unref0(var) ((var == NULL) ? NULL : (var = (pin_def_unref (var), NULL)))
#define _tag_unref0(var) ((var == NULL) ? NULL : (var = (tag_unref (var), NULL)))
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;
typedef struct _TagPrivate TagPrivate;

#define TYPE_FLOW (flow_get_type ())

#define PIN_DEF_TYPE_LABEL_TYPE (pin_def_label_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PinDefPrivate PinDefPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _DesignerWindowPrivate DesignerWindowPrivate;
typedef struct _ParamSpecCustomiser ParamSpecCustomiser;

struct _Customiser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CustomiserPrivate * priv;
	gint gridSize;
	gfloat zoom;
};

struct _CustomiserClass {
	GTypeClass parent_class;
	void (*finalize) (Customiser *self);
};

typedef enum  {
	CUSTOMISER_MOUSE_MODE_SCROLL,
	CUSTOMISER_MOUSE_MODE_ZOOM,
	CUSTOMISER_MOUSE_MODE_PIN
} CustomiserMouseMode;

struct _CustomiserPrivate {
	GtkDialog* dialog;
	GtkBox* layoutHBox;
	GtkBox* layoutVBox;
	GtkRadioToolButton* hiddenRadioToolButton;
	GtkToolbar* toolbar;
	GtkRadioToolButton* toolScroll;
	GtkImage* toolScrollImage;
	GtkRadioToolButton* toolZoom;
	GtkImage* toolZoomImage;
	GtkSeparatorToolItem* toolSeparator1;
	GtkRadioToolButton* toolPin;
	GtkImage* toolPinImage;
	GtkEventBox* controller;
	GtkDrawingArea* display;
	GtkBox* controlsVBox;
	GtkBox* nameHBox;
	GtkEntry* nameEntry;
	GtkLabel* nameLabel;
	GtkBox* descriptionHBox;
	GtkEntry* descriptionEntry;
	GtkLabel* descriptionLabel;
	GtkBox* labelHBox;
	GtkEntry* labelEntry;
	GtkLabel* labelLabel;
	GtkBox* pinHBox;
	GtkSpinButton* pinSpinButton;
	GtkLabel* pinLabel;
	GtkLabel* tagNameLabel;
	GtkCheckButton* requiredCheck;
	GtkBox* labelTypeVBox;
	GtkLabel* labelTypeLabel;
	GtkRadioButton* labelTypeNoneRadio;
	GtkRadioButton* labelTypeTextRadio;
	GtkRadioButton* labelTypeTextBarRadio;
	GtkRadioButton* labelTypeClockRadio;
	GtkBox* pinLabelHBox;
	GtkEntry* pinLabelEntry;
	GtkLabel* pinLabelLabel;
	GtkLabel* boundsLabel;
	GtkGrid* boundsGrid;
	GtkLabel* rightBoundLabel;
	GtkSpinButton* rightBoundSpinButton;
	GtkLabel* downBoundLabel;
	GtkSpinButton* downBoundSpinButton;
	GtkLabel* leftBoundLabel;
	GtkSpinButton* leftBoundSpinButton;
	GtkLabel* upBoundLabel;
	GtkSpinButton* upBoundSpinButton;
	GtkButton* colourButton;
	GtkButton* closeButton;
	cairo_surface_t* gridCache;
	gint xView;
	gint yView;
	CustomiserMouseMode mouseMode;
	CustomComponentDef* customComponentDef;
	DesignerWindow* parent;
	Project* project;
	gint selectedPinID;
	PinDef* selectedPin;
	gint xMouseStart;
	gint yMouseStart;
	Tag* tag;
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

struct _Tag {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagPrivate * priv;
	gchar* text;
	gint xTag;
	gint yTag;
	gint xWire;
	gint yWire;
	gint pinid;
	Flow flow;
	Direction direction;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
};

struct _TagClass {
	GTypeClass parent_class;
	void (*finalize) (Tag *self);
};

typedef enum  {
	PIN_DEF_LABEL_TYPE_NONE,
	PIN_DEF_LABEL_TYPE_TEXT,
	PIN_DEF_LABEL_TYPE_TEXTBAR,
	PIN_DEF_LABEL_TYPE_CLOCK
} PinDefLabelType;

struct _PinDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinDefPrivate * priv;
	gint x;
	gint y;
	gint xLabel;
	gint yLabel;
	gint xConnect;
	gint yConnect;
	Direction direction;
	gint length;
	gboolean array;
	Flow flow;
	gint defaultArraySize;
	gint idealSpace;
	gfloat minSpace;
	gchar* label;
	gboolean required;
	gboolean userArrayResize;
	gboolean showDefault;
	PinDefLabelType labelType;
};

struct _PinDefClass {
	GTypeClass parent_class;
	void (*finalize) (PinDef *self);
};

struct _DesignerWindow {
	GtkWindow parent_instance;
	DesignerWindowPrivate * priv;
	gint myID;
	gchar* componentFileName;
	gint gridSize;
	gfloat zoom;
	gboolean showGrid;
	gboolean liveScrollUpdate;
	gboolean shadowComponent;
};

struct _DesignerWindowClass {
	GtkWindowClass parent_class;
};

struct _ParamSpecCustomiser {
	GParamSpec parent_instance;
};


static gpointer customiser_parent_class = NULL;

gpointer customiser_ref (gpointer instance);
void customiser_unref (gpointer instance);
GParamSpec* param_spec_customiser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_customiser (GValue* value, gpointer v_object);
void value_take_customiser (GValue* value, gpointer v_object);
gpointer value_get_customiser (const GValue* value);
GType customiser_get_type (void) G_GNUC_CONST;
static GType customiser_mouse_mode_get_type (void) G_GNUC_UNUSED;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
GType designer_window_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
gpointer tag_ref (gpointer instance);
void tag_unref (gpointer instance);
GParamSpec* param_spec_tag (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag (GValue* value, gpointer v_object);
void value_take_tag (GValue* value, gpointer v_object);
gpointer value_get_tag (const GValue* value);
GType tag_get_type (void) G_GNUC_CONST;
#define CUSTOMISER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CUSTOMISER, CustomiserPrivate))
enum  {
	CUSTOMISER_DUMMY_PROPERTY
};
Customiser* customiser_new (DesignerWindow* parent, CustomComponentDef* customComponentDef, Project* project);
Customiser* customiser_construct (GType object_type, DesignerWindow* parent, CustomComponentDef* customComponentDef, Project* project);
gint custom_component_def_count_tags (CustomComponentDef* self);
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
Tag* custom_component_def_resolve_tag_id (CustomComponentDef* self, gint tagID);
GType flow_get_type (void) G_GNUC_CONST;
GType pin_def_label_type_get_type (void) G_GNUC_CONST;
PinDef* pin_def_new (gint x, gint y, Direction direction, Flow flow, gint length, gboolean array, gint defaultArraySize, gint idealSpace, gfloat minSpace, const gchar* label, PinDefLabelType labelType, gboolean required, gboolean userArrayResize, gboolean showDefault);
PinDef* pin_def_construct (GType object_type, gint x, gint y, Direction direction, Flow flow, gint length, gboolean array, gint defaultArraySize, gint idealSpace, gfloat minSpace, const gchar* label, PinDefLabelType labelType, gboolean required, gboolean userArrayResize, gboolean showDefault);
gint custom_component_def_validate_interfaces (CustomComponentDef* self);
void basic_dialog_warning (GtkWindow* window, const gchar* text);
static void customiser_populate (Customiser* self);
void customiser_update_selection (Customiser* self);
static void __lambda57_ (Customiser* self);
static void ___lambda57__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda58_ (Customiser* self);
static void ___lambda58__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda59_ (Customiser* self);
static void ___lambda59__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static gboolean customiser_mouse_down (Customiser* self, GdkEventButton* event);
static gboolean _customiser_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean customiser_mouse_up (Customiser* self, GdkEventButton* event);
static gboolean _customiser_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda60_ (Customiser* self, cairo_t* context);
gboolean customiser_render_def (Customiser* self, cairo_t* passedDisplayContext);
static gboolean ___lambda60__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static gboolean __lambda61_ (Customiser* self);
static gboolean ___lambda61__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static void __lambda62_ (Customiser* self);
static void ___lambda62__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _customiser_update_selection_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void ___lambda63_ (Customiser* self);
static void ____lambda63__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
void customiser_update_label_type (Customiser* self);
static void _customiser_update_label_type_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void ___lambda64_ (Customiser* self);
static void ____lambda64__gtk_editable_changed (GtkEditable* _sender, gpointer self);
void customiser_update_bounds (Customiser* self);
static void _customiser_update_bounds_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void __lambda65_ (Customiser* self);
void customiser_set_colour (Customiser* self);
static void ___lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self);
void customiser_response_handler (Customiser* self, gint response_id);
static void _customiser_response_handler_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void pin_def_set_position (PinDef* self, gint x, gint y, gint length, Direction direction);
void customiser_update_values (Customiser* self);
void customiser_run (Customiser* self);
ComponentDef* project_resolve_def_name (Project* self, const gchar* name);
void basic_dialog_error (GtkWindow* window, const gchar* text);
void component_def_render (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst, gboolean colourBackground);
void pin_def_render (PinDef* self, cairo_t* context, gboolean invert);
static void customiser_finalize (Customiser* obj);


/**
 * Actions to perform when the mouse button is released.
 */
static GType customiser_mouse_mode_get_type (void) {
	static volatile gsize customiser_mouse_mode_type_id__volatile = 0;
	if (g_once_init_enter (&customiser_mouse_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{CUSTOMISER_MOUSE_MODE_SCROLL, "CUSTOMISER_MOUSE_MODE_SCROLL", "scroll"}, {CUSTOMISER_MOUSE_MODE_ZOOM, "CUSTOMISER_MOUSE_MODE_ZOOM", "zoom"}, {CUSTOMISER_MOUSE_MODE_PIN, "CUSTOMISER_MOUSE_MODE_PIN", "pin"}, {0, NULL, NULL}};
		GType customiser_mouse_mode_type_id;
		customiser_mouse_mode_type_id = g_enum_register_static ("CustomiserMouseMode", values);
		g_once_init_leave (&customiser_mouse_mode_type_id__volatile, customiser_mouse_mode_type_id);
	}
	return customiser_mouse_mode_type_id__volatile;
}


/**
 * Start the customiser, setting the caller DesignerWindow, target 
 * custom component and its project.
 */
static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _project_ref0 (gpointer self) {
	return self ? project_ref (self) : NULL;
}


Customiser* customiser_construct (GType object_type, DesignerWindow* parent, CustomComponentDef* customComponentDef, Project* project) {
	Customiser* self = NULL;
	CustomComponentDef* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	DesignerWindow* _tmp2_ = NULL;
	DesignerWindow* _tmp3_ = NULL;
	Project* _tmp4_ = NULL;
	Project* _tmp5_ = NULL;
	gint tagCount = 0;
	CustomComponentDef* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	CustomComponentDef* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	CustomComponentDef* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	g_return_val_if_fail (customComponentDef != NULL, NULL);
	g_return_val_if_fail (project != NULL, NULL);
	self = (Customiser*) g_type_create_instance (object_type);
	_tmp0_ = customComponentDef;
	_tmp1_ = _component_def_ref0 (_tmp0_);
	_component_def_unref0 (self->priv->customComponentDef);
	self->priv->customComponentDef = _tmp1_;
	_tmp2_ = parent;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp3_;
	_tmp4_ = project;
	_tmp5_ = _project_ref0 (_tmp4_);
	_project_unref0 (self->priv->project);
	self->priv->project = _tmp5_;
	_tmp6_ = customComponentDef;
	_tmp7_ = custom_component_def_count_tags (_tmp6_);
	tagCount = _tmp7_;
	_tmp8_ = customComponentDef;
	_tmp9_ = tagCount;
	_tmp10_ = _tmp9_;
	((ComponentDef*) _tmp8_)->pinDefs = g_renew (PinDef*, ((ComponentDef*) _tmp8_)->pinDefs, _tmp9_);
	(_tmp10_ > ((ComponentDef*) _tmp8_)->pinDefs_length1) ? memset (((ComponentDef*) _tmp8_)->pinDefs + ((ComponentDef*) _tmp8_)->pinDefs_length1, 0, sizeof (PinDef*) * (_tmp10_ - ((ComponentDef*) _tmp8_)->pinDefs_length1)) : NULL;
	((ComponentDef*) _tmp8_)->pinDefs_length1 = _tmp10_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				CustomComponentDef* _tmp15_ = NULL;
				PinDef** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				PinDef* _tmp18_ = NULL;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = tagCount;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = customComponentDef;
				_tmp16_ = ((ComponentDef*) _tmp15_)->pinDefs;
				_tmp16__length1 = ((ComponentDef*) _tmp15_)->pinDefs_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				if (_tmp18_ == NULL) {
					Tag* resolvedTag = NULL;
					CustomComponentDef* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					Tag* _tmp21_ = NULL;
					Tag* _tmp22_ = NULL;
					_tmp19_ = customComponentDef;
					_tmp20_ = i;
					_tmp21_ = custom_component_def_resolve_tag_id (_tmp19_, _tmp20_);
					resolvedTag = _tmp21_;
					_tmp22_ = resolvedTag;
					if (_tmp22_ != NULL) {
						CustomComponentDef* _tmp23_ = NULL;
						PinDef** _tmp24_ = NULL;
						gint _tmp24__length1 = 0;
						gint _tmp25_ = 0;
						Tag* _tmp26_ = NULL;
						Flow _tmp27_ = 0;
						PinDef* _tmp28_ = NULL;
						PinDef* _tmp29_ = NULL;
						_tmp23_ = customComponentDef;
						_tmp24_ = ((ComponentDef*) _tmp23_)->pinDefs;
						_tmp24__length1 = ((ComponentDef*) _tmp23_)->pinDefs_length1;
						_tmp25_ = i;
						_tmp26_ = resolvedTag;
						_tmp27_ = _tmp26_->flow;
						_tmp28_ = pin_def_new (0, 0, DIRECTION_RIGHT, _tmp27_, 0, FALSE, 1, 0, (gfloat) 0, "", PIN_DEF_LABEL_TYPE_NONE, TRUE, TRUE, TRUE);
						_pin_def_unref0 (_tmp24_[_tmp25_]);
						_tmp24_[_tmp25_] = _tmp28_;
						_tmp29_ = _tmp24_[_tmp25_];
					} else {
						CustomComponentDef* _tmp30_ = NULL;
						PinDef** _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						gint _tmp32_ = 0;
						PinDef* _tmp33_ = NULL;
						PinDef* _tmp34_ = NULL;
						_tmp30_ = customComponentDef;
						_tmp31_ = ((ComponentDef*) _tmp30_)->pinDefs;
						_tmp31__length1 = ((ComponentDef*) _tmp30_)->pinDefs_length1;
						_tmp32_ = i;
						_tmp33_ = pin_def_new (0, 0, DIRECTION_RIGHT, FLOW_NONE, 0, FALSE, 1, 0, (gfloat) 0, "", PIN_DEF_LABEL_TYPE_NONE, TRUE, TRUE, TRUE);
						_pin_def_unref0 (_tmp31_[_tmp32_]);
						_tmp31_[_tmp32_] = _tmp33_;
						_tmp34_ = _tmp31_[_tmp32_];
					}
					_tag_unref0 (resolvedTag);
				}
			}
		}
	}
	_tmp35_ = customComponentDef;
	_tmp36_ = custom_component_def_validate_interfaces (_tmp35_);
	if (_tmp36_ != 0) {
		basic_dialog_warning (NULL, "Warning:\n" \
"Could not associate all pins with interface tags. Make sure that all t" \
"ags have unique and sequential IDs starting with 0. You can cycle thro" \
"ugh the pins to check the associations.\n");
	}
	customiser_populate (self);
	customiser_update_selection (self);
	return self;
}


Customiser* customiser_new (DesignerWindow* parent, CustomComponentDef* customComponentDef, Project* project) {
	return customiser_construct (TYPE_CUSTOMISER, parent, customComponentDef, project);
}


/**
 * Create a new Gtk Dialog and populate it with widgets
 */
static void __lambda57_ (Customiser* self) {
	self->priv->mouseMode = CUSTOMISER_MOUSE_MODE_SCROLL;
}


static void ___lambda57__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda57_ ((Customiser*) self);
}


static void __lambda58_ (Customiser* self) {
	self->priv->mouseMode = CUSTOMISER_MOUSE_MODE_ZOOM;
}


static void ___lambda58__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda58_ ((Customiser*) self);
}


static void __lambda59_ (Customiser* self) {
	self->priv->mouseMode = CUSTOMISER_MOUSE_MODE_PIN;
}


static void ___lambda59__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda59_ ((Customiser*) self);
}


static gboolean _customiser_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = customiser_mouse_down ((Customiser*) self, event);
	return result;
}


static gboolean _customiser_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = customiser_mouse_up ((Customiser*) self, event);
	return result;
}


static gboolean __lambda60_ (Customiser* self, cairo_t* context) {
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	customiser_render_def (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda60__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = __lambda60_ ((Customiser*) self, cr);
	return result;
}


static gboolean __lambda61_ (Customiser* self) {
	gboolean result = FALSE;
	_cairo_surface_destroy0 (self->priv->gridCache);
	self->priv->gridCache = NULL;
	customiser_render_def (self, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda61__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = __lambda61_ ((Customiser*) self);
	return result;
}


static void __lambda62_ (Customiser* self) {
	CustomComponentDef* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = self->priv->customComponentDef;
	_tmp1_ = self->priv->labelEntry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (((ComponentDef*) _tmp0_)->label);
	((ComponentDef*) _tmp0_)->label = _tmp4_;
	customiser_render_def (self, NULL);
}


static void ___lambda62__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda62_ ((Customiser*) self);
}


static gpointer _pin_def_ref0 (gpointer self) {
	return self ? pin_def_ref (self) : NULL;
}


static void _customiser_update_selection_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	customiser_update_selection ((Customiser*) self);
}


static void ___lambda63_ (Customiser* self) {
	PinDef* _tmp0_ = NULL;
	_tmp0_ = self->priv->selectedPin;
	if (_tmp0_ != NULL) {
		PinDef* _tmp1_ = NULL;
		GtkCheckButton* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp1_ = self->priv->selectedPin;
		_tmp2_ = self->priv->requiredCheck;
		_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_->required = _tmp4_;
	}
}


static void ____lambda63__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	___lambda63_ ((Customiser*) self);
}


static void _customiser_update_label_type_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	customiser_update_label_type ((Customiser*) self);
}


static void ___lambda64_ (Customiser* self) {
	PinDef* _tmp0_ = NULL;
	_tmp0_ = self->priv->selectedPin;
	if (_tmp0_ != NULL) {
		PinDef* _tmp1_ = NULL;
		GtkEntry* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = self->priv->selectedPin;
		_tmp2_ = self->priv->pinLabelEntry;
		_tmp3_ = gtk_entry_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_tmp1_->label);
		_tmp1_->label = _tmp5_;
		customiser_render_def (self, NULL);
	}
}


static void ____lambda64__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	___lambda64_ ((Customiser*) self);
}


static void _customiser_update_bounds_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	customiser_update_bounds ((Customiser*) self);
}


static void __lambda65_ (Customiser* self) {
	customiser_set_colour (self);
}


static void ___lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda65_ ((Customiser*) self);
}


static void _customiser_response_handler_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	customiser_response_handler ((Customiser*) self, response_id);
}


static void customiser_populate (Customiser* self) {
	DesignerWindow* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkBox* content = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkRadioToolButton* _tmp13_ = NULL;
	GtkToolbar* _tmp14_ = NULL;
	GtkToolbar* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkToolbar* _tmp17_ = NULL;
	GtkImage* _tmp18_ = NULL;
	GtkRadioToolButton* _tmp19_ = NULL;
	GtkRadioToolButton* _tmp20_ = NULL;
	GtkRadioToolButton* _tmp21_ = NULL;
	GtkRadioToolButton* _tmp22_ = NULL;
	GtkImage* _tmp23_ = NULL;
	GtkToolbar* _tmp24_ = NULL;
	GtkRadioToolButton* _tmp25_ = NULL;
	GtkRadioToolButton* _tmp26_ = NULL;
	GtkRadioToolButton* _tmp27_ = NULL;
	GtkImage* _tmp28_ = NULL;
	GtkRadioToolButton* _tmp29_ = NULL;
	GtkRadioToolButton* _tmp30_ = NULL;
	GtkRadioToolButton* _tmp31_ = NULL;
	GtkRadioToolButton* _tmp32_ = NULL;
	GtkImage* _tmp33_ = NULL;
	GtkToolbar* _tmp34_ = NULL;
	GtkRadioToolButton* _tmp35_ = NULL;
	GtkRadioToolButton* _tmp36_ = NULL;
	GtkRadioToolButton* _tmp37_ = NULL;
	GtkSeparatorToolItem* _tmp38_ = NULL;
	GtkToolbar* _tmp39_ = NULL;
	GtkSeparatorToolItem* _tmp40_ = NULL;
	GtkImage* _tmp41_ = NULL;
	GtkRadioToolButton* _tmp42_ = NULL;
	GtkRadioToolButton* _tmp43_ = NULL;
	GtkRadioToolButton* _tmp44_ = NULL;
	GtkRadioToolButton* _tmp45_ = NULL;
	GtkImage* _tmp46_ = NULL;
	GtkToolbar* _tmp47_ = NULL;
	GtkRadioToolButton* _tmp48_ = NULL;
	GtkRadioToolButton* _tmp49_ = NULL;
	GtkRadioToolButton* _tmp50_ = NULL;
	GtkRadioToolButton* _tmp51_ = NULL;
	GtkEventBox* _tmp52_ = NULL;
	GtkBox* _tmp53_ = NULL;
	GtkEventBox* _tmp54_ = NULL;
	GtkEventBox* _tmp55_ = NULL;
	GtkEventBox* _tmp56_ = NULL;
	GtkDrawingArea* _tmp57_ = NULL;
	GtkEventBox* _tmp58_ = NULL;
	GtkDrawingArea* _tmp59_ = NULL;
	GtkDrawingArea* _tmp60_ = NULL;
	GtkDrawingArea* _tmp61_ = NULL;
	GtkBox* _tmp62_ = NULL;
	GtkBox* _tmp63_ = NULL;
	GtkBox* _tmp64_ = NULL;
	GtkBox* _tmp65_ = NULL;
	GtkBox* _tmp66_ = NULL;
	GtkBox* _tmp67_ = NULL;
	GtkLabel* _tmp68_ = NULL;
	GtkBox* _tmp69_ = NULL;
	GtkLabel* _tmp70_ = NULL;
	GtkEntry* _tmp71_ = NULL;
	GtkEntry* _tmp72_ = NULL;
	CustomComponentDef* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GtkBox* _tmp75_ = NULL;
	GtkEntry* _tmp76_ = NULL;
	GtkBox* _tmp77_ = NULL;
	GtkBox* _tmp78_ = NULL;
	GtkBox* _tmp79_ = NULL;
	GtkLabel* _tmp80_ = NULL;
	GtkBox* _tmp81_ = NULL;
	GtkLabel* _tmp82_ = NULL;
	GtkEntry* _tmp83_ = NULL;
	GtkEntry* _tmp84_ = NULL;
	CustomComponentDef* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	GtkBox* _tmp87_ = NULL;
	GtkEntry* _tmp88_ = NULL;
	GtkBox* _tmp89_ = NULL;
	GtkBox* _tmp90_ = NULL;
	GtkBox* _tmp91_ = NULL;
	GtkLabel* _tmp92_ = NULL;
	GtkBox* _tmp93_ = NULL;
	GtkLabel* _tmp94_ = NULL;
	GtkEntry* _tmp95_ = NULL;
	GtkEntry* _tmp96_ = NULL;
	CustomComponentDef* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	GtkEntry* _tmp99_ = NULL;
	GtkBox* _tmp100_ = NULL;
	GtkEntry* _tmp101_ = NULL;
	CustomComponentDef* _tmp102_ = NULL;
	PinDef** _tmp103_ = NULL;
	gint _tmp103__length1 = 0;
	GtkLabel* _tmp179_ = NULL;
	GtkBox* _tmp180_ = NULL;
	GtkLabel* _tmp181_ = NULL;
	GtkGrid* _tmp182_ = NULL;
	GtkBox* _tmp183_ = NULL;
	GtkGrid* _tmp184_ = NULL;
	GtkLabel* _tmp185_ = NULL;
	GtkGrid* _tmp186_ = NULL;
	GtkLabel* _tmp187_ = NULL;
	gint _tmp188_ = 0;
	GtkSpinButton* _tmp189_ = NULL;
	GtkSpinButton* _tmp190_ = NULL;
	CustomComponentDef* _tmp191_ = NULL;
	gint _tmp192_ = 0;
	GtkSpinButton* _tmp193_ = NULL;
	GtkGrid* _tmp194_ = NULL;
	GtkSpinButton* _tmp195_ = NULL;
	GtkLabel* _tmp196_ = NULL;
	GtkGrid* _tmp197_ = NULL;
	GtkLabel* _tmp198_ = NULL;
	gint _tmp199_ = 0;
	GtkSpinButton* _tmp200_ = NULL;
	GtkSpinButton* _tmp201_ = NULL;
	CustomComponentDef* _tmp202_ = NULL;
	gint _tmp203_ = 0;
	GtkSpinButton* _tmp204_ = NULL;
	GtkGrid* _tmp205_ = NULL;
	GtkSpinButton* _tmp206_ = NULL;
	GtkLabel* _tmp207_ = NULL;
	GtkGrid* _tmp208_ = NULL;
	GtkLabel* _tmp209_ = NULL;
	gint _tmp210_ = 0;
	GtkSpinButton* _tmp211_ = NULL;
	GtkSpinButton* _tmp212_ = NULL;
	CustomComponentDef* _tmp213_ = NULL;
	gint _tmp214_ = 0;
	GtkSpinButton* _tmp215_ = NULL;
	GtkGrid* _tmp216_ = NULL;
	GtkSpinButton* _tmp217_ = NULL;
	GtkLabel* _tmp218_ = NULL;
	GtkGrid* _tmp219_ = NULL;
	GtkLabel* _tmp220_ = NULL;
	gint _tmp221_ = 0;
	GtkSpinButton* _tmp222_ = NULL;
	GtkSpinButton* _tmp223_ = NULL;
	CustomComponentDef* _tmp224_ = NULL;
	gint _tmp225_ = 0;
	GtkSpinButton* _tmp226_ = NULL;
	GtkGrid* _tmp227_ = NULL;
	GtkSpinButton* _tmp228_ = NULL;
	GtkButton* _tmp229_ = NULL;
	GtkButton* _tmp230_ = NULL;
	GtkBox* _tmp231_ = NULL;
	GtkButton* _tmp232_ = NULL;
	GtkDialog* _tmp233_ = NULL;
	GtkButton* _tmp234_ = NULL;
	GtkDialog* _tmp235_ = NULL;
	GtkButton* _tmp236_ = NULL;
	GtkDialog* _tmp237_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parent;
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons ("Customise Component", (GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp1_;
	_tmp2_ = self->priv->dialog;
	_tmp3_ = (GtkBox*) gtk_dialog_get_content_area (_tmp2_);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp3_) : NULL);
	content = _tmp4_;
	_tmp5_ = self->priv->dialog;
	gtk_window_set_default_size ((GtkWindow*) _tmp5_, 600, 200);
	_tmp6_ = self->priv->dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp6_, (guint) 1);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->layoutHBox);
	self->priv->layoutHBox = _tmp7_;
	_tmp8_ = content;
	_tmp9_ = self->priv->layoutHBox;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 1);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->layoutVBox);
	self->priv->layoutVBox = _tmp10_;
	_tmp11_ = self->priv->layoutHBox;
	_tmp12_ = self->priv->layoutVBox;
	gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, TRUE, TRUE, (guint) 1);
	_tmp13_ = (GtkRadioToolButton*) gtk_radio_tool_button_new (NULL);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->hiddenRadioToolButton);
	self->priv->hiddenRadioToolButton = _tmp13_;
	_tmp14_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp14_;
	_tmp15_ = self->priv->toolbar;
	g_object_set (_tmp15_, "toolbar-style", GTK_TOOLBAR_ICONS, NULL);
	_tmp16_ = self->priv->layoutVBox;
	_tmp17_ = self->priv->toolbar;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, TRUE, (guint) 0);
	_tmp18_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/scroll.png");
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->toolScrollImage);
	self->priv->toolScrollImage = _tmp18_;
	_tmp19_ = self->priv->hiddenRadioToolButton;
	_tmp20_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->toolScroll);
	self->priv->toolScroll = _tmp20_;
	_tmp21_ = self->priv->toolScroll;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp21_, "Scroll");
	_tmp22_ = self->priv->toolScroll;
	_tmp23_ = self->priv->toolScrollImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->toolbar;
	_tmp25_ = self->priv->toolScroll;
	gtk_toolbar_insert (_tmp24_, (GtkToolItem*) _tmp25_, -1);
	_tmp26_ = self->priv->toolScroll;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp26_, "Scroll: Move your view of the component with click and drag.");
	_tmp27_ = self->priv->toolScroll;
	g_signal_connect ((GtkToolButton*) _tmp27_, "clicked", (GCallback) ___lambda57__gtk_tool_button_clicked, self);
	_tmp28_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/zoom.png");
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->toolZoomImage);
	self->priv->toolZoomImage = _tmp28_;
	_tmp29_ = self->priv->hiddenRadioToolButton;
	_tmp30_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->toolZoom);
	self->priv->toolZoom = _tmp30_;
	_tmp31_ = self->priv->toolZoom;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp31_, "Zoom");
	_tmp32_ = self->priv->toolZoom;
	_tmp33_ = self->priv->toolZoomImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->toolbar;
	_tmp35_ = self->priv->toolZoom;
	gtk_toolbar_insert (_tmp34_, (GtkToolItem*) _tmp35_, -1);
	_tmp36_ = self->priv->toolZoom;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp36_, "Zoom: Drag downward to zoom in or upward to zoom out.");
	_tmp37_ = self->priv->toolZoom;
	g_signal_connect ((GtkToolButton*) _tmp37_, "clicked", (GCallback) ___lambda58__gtk_tool_button_clicked, self);
	_tmp38_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->toolSeparator1);
	self->priv->toolSeparator1 = _tmp38_;
	_tmp39_ = self->priv->toolbar;
	_tmp40_ = self->priv->toolSeparator1;
	gtk_toolbar_insert (_tmp39_, (GtkToolItem*) _tmp40_, -1);
	_tmp41_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/pin.png");
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->toolPinImage);
	self->priv->toolPinImage = _tmp41_;
	_tmp42_ = self->priv->hiddenRadioToolButton;
	_tmp43_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp42_);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->toolPin);
	self->priv->toolPin = _tmp43_;
	_tmp44_ = self->priv->toolPin;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp44_, "Pin");
	_tmp45_ = self->priv->toolPin;
	_tmp46_ = self->priv->toolPinImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->toolbar;
	_tmp48_ = self->priv->toolPin;
	gtk_toolbar_insert (_tmp47_, (GtkToolItem*) _tmp48_, -1);
	_tmp49_ = self->priv->toolPin;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp49_, "Pin: Click outside the component to position a pin.");
	_tmp50_ = self->priv->toolPin;
	g_signal_connect ((GtkToolButton*) _tmp50_, "clicked", (GCallback) ___lambda59__gtk_tool_button_clicked, self);
	_tmp51_ = self->priv->toolPin;
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) _tmp51_, TRUE);
	_tmp52_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp52_;
	_tmp53_ = self->priv->layoutVBox;
	_tmp54_ = self->priv->controller;
	gtk_box_pack_start (_tmp53_, (GtkWidget*) _tmp54_, TRUE, TRUE, (guint) 1);
	_tmp55_ = self->priv->controller;
	g_signal_connect ((GtkWidget*) _tmp55_, "button-press-event", (GCallback) _customiser_mouse_down_gtk_widget_button_press_event, self);
	_tmp56_ = self->priv->controller;
	g_signal_connect ((GtkWidget*) _tmp56_, "button-release-event", (GCallback) _customiser_mouse_up_gtk_widget_button_release_event, self);
	_tmp57_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp57_;
	_tmp58_ = self->priv->controller;
	_tmp59_ = self->priv->display;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = self->priv->display;
	g_signal_connect ((GtkWidget*) _tmp60_, "draw", (GCallback) ___lambda60__gtk_widget_draw, self);
	_tmp61_ = self->priv->display;
	g_signal_connect ((GtkWidget*) _tmp61_, "configure-event", (GCallback) ___lambda61__gtk_widget_configure_event, self);
	_tmp62_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (self->priv->controlsVBox);
	self->priv->controlsVBox = _tmp62_;
	_tmp63_ = self->priv->layoutHBox;
	_tmp64_ = self->priv->controlsVBox;
	gtk_box_pack_start (_tmp63_, (GtkWidget*) _tmp64_, FALSE, TRUE, (guint) 1);
	_tmp65_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->nameHBox);
	self->priv->nameHBox = _tmp65_;
	_tmp66_ = self->priv->controlsVBox;
	_tmp67_ = self->priv->nameHBox;
	gtk_box_pack_start (_tmp66_, (GtkWidget*) _tmp67_, FALSE, TRUE, (guint) 1);
	_tmp68_ = (GtkLabel*) gtk_label_new ("Name:");
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->nameLabel);
	self->priv->nameLabel = _tmp68_;
	_tmp69_ = self->priv->nameHBox;
	_tmp70_ = self->priv->nameLabel;
	gtk_box_pack_start (_tmp69_, (GtkWidget*) _tmp70_, FALSE, TRUE, (guint) 1);
	_tmp71_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->nameEntry);
	self->priv->nameEntry = _tmp71_;
	_tmp72_ = self->priv->nameEntry;
	_tmp73_ = self->priv->customComponentDef;
	_tmp74_ = ((ComponentDef*) _tmp73_)->name;
	gtk_entry_set_text (_tmp72_, _tmp74_);
	_tmp75_ = self->priv->nameHBox;
	_tmp76_ = self->priv->nameEntry;
	gtk_box_pack_start (_tmp75_, (GtkWidget*) _tmp76_, TRUE, TRUE, (guint) 1);
	_tmp77_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->descriptionHBox);
	self->priv->descriptionHBox = _tmp77_;
	_tmp78_ = self->priv->controlsVBox;
	_tmp79_ = self->priv->descriptionHBox;
	gtk_box_pack_start (_tmp78_, (GtkWidget*) _tmp79_, FALSE, TRUE, (guint) 1);
	_tmp80_ = (GtkLabel*) gtk_label_new ("Description:");
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (self->priv->descriptionLabel);
	self->priv->descriptionLabel = _tmp80_;
	_tmp81_ = self->priv->descriptionHBox;
	_tmp82_ = self->priv->descriptionLabel;
	gtk_box_pack_start (_tmp81_, (GtkWidget*) _tmp82_, FALSE, TRUE, (guint) 1);
	_tmp83_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp83_);
	_g_object_unref0 (self->priv->descriptionEntry);
	self->priv->descriptionEntry = _tmp83_;
	_tmp84_ = self->priv->descriptionEntry;
	_tmp85_ = self->priv->customComponentDef;
	_tmp86_ = ((ComponentDef*) _tmp85_)->description;
	gtk_entry_set_text (_tmp84_, _tmp86_);
	_tmp87_ = self->priv->descriptionHBox;
	_tmp88_ = self->priv->descriptionEntry;
	gtk_box_pack_start (_tmp87_, (GtkWidget*) _tmp88_, TRUE, TRUE, (guint) 1);
	_tmp89_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp89_);
	_g_object_unref0 (self->priv->labelHBox);
	self->priv->labelHBox = _tmp89_;
	_tmp90_ = self->priv->controlsVBox;
	_tmp91_ = self->priv->labelHBox;
	gtk_box_pack_start (_tmp90_, (GtkWidget*) _tmp91_, FALSE, TRUE, (guint) 1);
	_tmp92_ = (GtkLabel*) gtk_label_new ("Box Label:");
	g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->labelLabel);
	self->priv->labelLabel = _tmp92_;
	_tmp93_ = self->priv->labelHBox;
	_tmp94_ = self->priv->labelLabel;
	gtk_box_pack_start (_tmp93_, (GtkWidget*) _tmp94_, FALSE, TRUE, (guint) 1);
	_tmp95_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->labelEntry);
	self->priv->labelEntry = _tmp95_;
	_tmp96_ = self->priv->labelEntry;
	_tmp97_ = self->priv->customComponentDef;
	_tmp98_ = ((ComponentDef*) _tmp97_)->label;
	gtk_entry_set_text (_tmp96_, _tmp98_);
	_tmp99_ = self->priv->labelEntry;
	g_signal_connect ((GtkEditable*) _tmp99_, "changed", (GCallback) ___lambda62__gtk_editable_changed, self);
	_tmp100_ = self->priv->labelHBox;
	_tmp101_ = self->priv->labelEntry;
	gtk_box_pack_start (_tmp100_, (GtkWidget*) _tmp101_, TRUE, TRUE, (guint) 1);
	_tmp102_ = self->priv->customComponentDef;
	_tmp103_ = ((ComponentDef*) _tmp102_)->pinDefs;
	_tmp103__length1 = ((ComponentDef*) _tmp102_)->pinDefs_length1;
	if (_tmp103__length1 > 0) {
		CustomComponentDef* _tmp104_ = NULL;
		PinDef** _tmp105_ = NULL;
		gint _tmp105__length1 = 0;
		gint _tmp106_ = 0;
		PinDef* _tmp107_ = NULL;
		PinDef* _tmp108_ = NULL;
		CustomComponentDef* _tmp109_ = NULL;
		gint _tmp110_ = 0;
		Tag* _tmp111_ = NULL;
		GtkBox* _tmp112_ = NULL;
		GtkBox* _tmp113_ = NULL;
		GtkBox* _tmp114_ = NULL;
		GtkLabel* _tmp115_ = NULL;
		GtkBox* _tmp116_ = NULL;
		GtkLabel* _tmp117_ = NULL;
		CustomComponentDef* _tmp118_ = NULL;
		PinDef** _tmp119_ = NULL;
		gint _tmp119__length1 = 0;
		GtkSpinButton* _tmp120_ = NULL;
		GtkSpinButton* _tmp121_ = NULL;
		GtkSpinButton* _tmp122_ = NULL;
		GtkBox* _tmp123_ = NULL;
		GtkSpinButton* _tmp124_ = NULL;
		Tag* _tmp125_ = NULL;
		GtkBox* _tmp132_ = NULL;
		GtkLabel* _tmp133_ = NULL;
		GtkCheckButton* _tmp134_ = NULL;
		GtkCheckButton* _tmp135_ = NULL;
		PinDef* _tmp136_ = NULL;
		gboolean _tmp137_ = FALSE;
		GtkCheckButton* _tmp138_ = NULL;
		GtkBox* _tmp139_ = NULL;
		GtkCheckButton* _tmp140_ = NULL;
		GtkBox* _tmp141_ = NULL;
		GtkBox* _tmp142_ = NULL;
		GtkBox* _tmp143_ = NULL;
		GtkLabel* _tmp144_ = NULL;
		GtkBox* _tmp145_ = NULL;
		GtkLabel* _tmp146_ = NULL;
		GtkRadioButton* _tmp147_ = NULL;
		GtkRadioButton* _tmp148_ = NULL;
		GtkBox* _tmp149_ = NULL;
		GtkRadioButton* _tmp150_ = NULL;
		GtkRadioButton* _tmp151_ = NULL;
		GtkRadioButton* _tmp152_ = NULL;
		GtkRadioButton* _tmp153_ = NULL;
		GtkBox* _tmp154_ = NULL;
		GtkRadioButton* _tmp155_ = NULL;
		GtkRadioButton* _tmp156_ = NULL;
		GtkRadioButton* _tmp157_ = NULL;
		GtkRadioButton* _tmp158_ = NULL;
		GtkBox* _tmp159_ = NULL;
		GtkRadioButton* _tmp160_ = NULL;
		GtkRadioButton* _tmp161_ = NULL;
		GtkRadioButton* _tmp162_ = NULL;
		GtkRadioButton* _tmp163_ = NULL;
		GtkBox* _tmp164_ = NULL;
		GtkRadioButton* _tmp165_ = NULL;
		GtkBox* _tmp166_ = NULL;
		GtkBox* _tmp167_ = NULL;
		GtkBox* _tmp168_ = NULL;
		GtkLabel* _tmp169_ = NULL;
		GtkBox* _tmp170_ = NULL;
		GtkLabel* _tmp171_ = NULL;
		GtkEntry* _tmp172_ = NULL;
		GtkEntry* _tmp173_ = NULL;
		PinDef* _tmp174_ = NULL;
		const gchar* _tmp175_ = NULL;
		GtkEntry* _tmp176_ = NULL;
		GtkBox* _tmp177_ = NULL;
		GtkEntry* _tmp178_ = NULL;
		self->priv->selectedPinID = 0;
		_tmp104_ = self->priv->customComponentDef;
		_tmp105_ = ((ComponentDef*) _tmp104_)->pinDefs;
		_tmp105__length1 = ((ComponentDef*) _tmp104_)->pinDefs_length1;
		_tmp106_ = self->priv->selectedPinID;
		_tmp107_ = _tmp105_[_tmp106_];
		_tmp108_ = _pin_def_ref0 (_tmp107_);
		_pin_def_unref0 (self->priv->selectedPin);
		self->priv->selectedPin = _tmp108_;
		_tmp109_ = self->priv->customComponentDef;
		_tmp110_ = self->priv->selectedPinID;
		_tmp111_ = custom_component_def_resolve_tag_id (_tmp109_, _tmp110_);
		_tag_unref0 (self->priv->tag);
		self->priv->tag = _tmp111_;
		_tmp112_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
		g_object_ref_sink (_tmp112_);
		_g_object_unref0 (self->priv->pinHBox);
		self->priv->pinHBox = _tmp112_;
		_tmp113_ = self->priv->controlsVBox;
		_tmp114_ = self->priv->pinHBox;
		gtk_box_pack_start (_tmp113_, (GtkWidget*) _tmp114_, FALSE, TRUE, (guint) 1);
		_tmp115_ = (GtkLabel*) gtk_label_new ("Pin Select:");
		g_object_ref_sink (_tmp115_);
		_g_object_unref0 (self->priv->pinLabel);
		self->priv->pinLabel = _tmp115_;
		_tmp116_ = self->priv->pinHBox;
		_tmp117_ = self->priv->pinLabel;
		gtk_box_pack_start (_tmp116_, (GtkWidget*) _tmp117_, FALSE, TRUE, (guint) 1);
		_tmp118_ = self->priv->customComponentDef;
		_tmp119_ = ((ComponentDef*) _tmp118_)->pinDefs;
		_tmp119__length1 = ((ComponentDef*) _tmp118_)->pinDefs_length1;
		_tmp120_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) (_tmp119__length1 - 1), (gdouble) 1);
		g_object_ref_sink (_tmp120_);
		_g_object_unref0 (self->priv->pinSpinButton);
		self->priv->pinSpinButton = _tmp120_;
		_tmp121_ = self->priv->pinSpinButton;
		gtk_spin_button_set_value (_tmp121_, (gdouble) 0);
		_tmp122_ = self->priv->pinSpinButton;
		g_signal_connect ((GtkEditable*) _tmp122_, "changed", (GCallback) _customiser_update_selection_gtk_editable_changed, self);
		_tmp123_ = self->priv->pinHBox;
		_tmp124_ = self->priv->pinSpinButton;
		gtk_box_pack_start (_tmp123_, (GtkWidget*) _tmp124_, TRUE, TRUE, (guint) 1);
		_tmp125_ = self->priv->tag;
		if (_tmp125_ != NULL) {
			Tag* _tmp126_ = NULL;
			const gchar* _tmp127_ = NULL;
			gchar* _tmp128_ = NULL;
			gchar* _tmp129_ = NULL;
			GtkLabel* _tmp130_ = NULL;
			_tmp126_ = self->priv->tag;
			_tmp127_ = _tmp126_->text;
			_tmp128_ = g_strconcat ("Maps to: ", _tmp127_, NULL);
			_tmp129_ = _tmp128_;
			_tmp130_ = (GtkLabel*) gtk_label_new (_tmp129_);
			g_object_ref_sink (_tmp130_);
			_g_object_unref0 (self->priv->tagNameLabel);
			self->priv->tagNameLabel = _tmp130_;
			_g_free0 (_tmp129_);
		} else {
			GtkLabel* _tmp131_ = NULL;
			_tmp131_ = (GtkLabel*) gtk_label_new ("There is no matching tag!");
			g_object_ref_sink (_tmp131_);
			_g_object_unref0 (self->priv->tagNameLabel);
			self->priv->tagNameLabel = _tmp131_;
		}
		_tmp132_ = self->priv->controlsVBox;
		_tmp133_ = self->priv->tagNameLabel;
		gtk_box_pack_start (_tmp132_, (GtkWidget*) _tmp133_, FALSE, TRUE, (guint) 1);
		_tmp134_ = (GtkCheckButton*) gtk_check_button_new_with_label ("Connection Required");
		g_object_ref_sink (_tmp134_);
		_g_object_unref0 (self->priv->requiredCheck);
		self->priv->requiredCheck = _tmp134_;
		_tmp135_ = self->priv->requiredCheck;
		_tmp136_ = self->priv->selectedPin;
		_tmp137_ = _tmp136_->required;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp135_, _tmp137_);
		_tmp138_ = self->priv->requiredCheck;
		g_signal_connect ((GtkToggleButton*) _tmp138_, "toggled", (GCallback) ____lambda63__gtk_toggle_button_toggled, self);
		_tmp139_ = self->priv->controlsVBox;
		_tmp140_ = self->priv->requiredCheck;
		gtk_box_pack_start (_tmp139_, (GtkWidget*) _tmp140_, FALSE, TRUE, (guint) 1);
		_tmp141_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp141_);
		_g_object_unref0 (self->priv->labelTypeVBox);
		self->priv->labelTypeVBox = _tmp141_;
		_tmp142_ = self->priv->controlsVBox;
		_tmp143_ = self->priv->labelTypeVBox;
		gtk_box_pack_start (_tmp142_, (GtkWidget*) _tmp143_, FALSE, TRUE, (guint) 1);
		_tmp144_ = (GtkLabel*) gtk_label_new ("Pin labels can be text or a symbol:");
		g_object_ref_sink (_tmp144_);
		_g_object_unref0 (self->priv->labelTypeLabel);
		self->priv->labelTypeLabel = _tmp144_;
		_tmp145_ = self->priv->labelTypeVBox;
		_tmp146_ = self->priv->labelTypeLabel;
		gtk_box_pack_start (_tmp145_, (GtkWidget*) _tmp146_, FALSE, TRUE, (guint) 1);
		_tmp147_ = (GtkRadioButton*) gtk_radio_button_new_with_label (NULL, "No Label");
		g_object_ref_sink (_tmp147_);
		_g_object_unref0 (self->priv->labelTypeNoneRadio);
		self->priv->labelTypeNoneRadio = _tmp147_;
		_tmp148_ = self->priv->labelTypeNoneRadio;
		g_signal_connect ((GtkToggleButton*) _tmp148_, "toggled", (GCallback) _customiser_update_label_type_gtk_toggle_button_toggled, self);
		_tmp149_ = self->priv->labelTypeVBox;
		_tmp150_ = self->priv->labelTypeNoneRadio;
		gtk_box_pack_start (_tmp149_, (GtkWidget*) _tmp150_, FALSE, TRUE, (guint) 1);
		_tmp151_ = self->priv->labelTypeNoneRadio;
		_tmp152_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp151_, "Text");
		g_object_ref_sink (_tmp152_);
		_g_object_unref0 (self->priv->labelTypeTextRadio);
		self->priv->labelTypeTextRadio = _tmp152_;
		_tmp153_ = self->priv->labelTypeTextRadio;
		g_signal_connect ((GtkToggleButton*) _tmp153_, "toggled", (GCallback) _customiser_update_label_type_gtk_toggle_button_toggled, self);
		_tmp154_ = self->priv->labelTypeVBox;
		_tmp155_ = self->priv->labelTypeTextRadio;
		gtk_box_pack_start (_tmp154_, (GtkWidget*) _tmp155_, FALSE, TRUE, (guint) 1);
		_tmp156_ = self->priv->labelTypeNoneRadio;
		_tmp157_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp156_, "Text With Bar");
		g_object_ref_sink (_tmp157_);
		_g_object_unref0 (self->priv->labelTypeTextBarRadio);
		self->priv->labelTypeTextBarRadio = _tmp157_;
		_tmp158_ = self->priv->labelTypeTextBarRadio;
		g_signal_connect ((GtkToggleButton*) _tmp158_, "toggled", (GCallback) _customiser_update_label_type_gtk_toggle_button_toggled, self);
		_tmp159_ = self->priv->labelTypeVBox;
		_tmp160_ = self->priv->labelTypeTextBarRadio;
		gtk_box_pack_start (_tmp159_, (GtkWidget*) _tmp160_, FALSE, TRUE, (guint) 1);
		_tmp161_ = self->priv->labelTypeNoneRadio;
		_tmp162_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp161_, "Clock");
		g_object_ref_sink (_tmp162_);
		_g_object_unref0 (self->priv->labelTypeClockRadio);
		self->priv->labelTypeClockRadio = _tmp162_;
		_tmp163_ = self->priv->labelTypeClockRadio;
		g_signal_connect ((GtkToggleButton*) _tmp163_, "toggled", (GCallback) _customiser_update_label_type_gtk_toggle_button_toggled, self);
		_tmp164_ = self->priv->labelTypeVBox;
		_tmp165_ = self->priv->labelTypeClockRadio;
		gtk_box_pack_start (_tmp164_, (GtkWidget*) _tmp165_, FALSE, TRUE, (guint) 1);
		_tmp166_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
		g_object_ref_sink (_tmp166_);
		_g_object_unref0 (self->priv->pinLabelHBox);
		self->priv->pinLabelHBox = _tmp166_;
		_tmp167_ = self->priv->controlsVBox;
		_tmp168_ = self->priv->pinLabelHBox;
		gtk_box_pack_start (_tmp167_, (GtkWidget*) _tmp168_, FALSE, TRUE, (guint) 1);
		_tmp169_ = (GtkLabel*) gtk_label_new ("Pin Label:");
		g_object_ref_sink (_tmp169_);
		_g_object_unref0 (self->priv->pinLabelLabel);
		self->priv->pinLabelLabel = _tmp169_;
		_tmp170_ = self->priv->pinLabelHBox;
		_tmp171_ = self->priv->pinLabelLabel;
		gtk_box_pack_start (_tmp170_, (GtkWidget*) _tmp171_, FALSE, TRUE, (guint) 1);
		_tmp172_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp172_);
		_g_object_unref0 (self->priv->pinLabelEntry);
		self->priv->pinLabelEntry = _tmp172_;
		_tmp173_ = self->priv->pinLabelEntry;
		_tmp174_ = self->priv->selectedPin;
		_tmp175_ = _tmp174_->label;
		gtk_entry_set_text (_tmp173_, _tmp175_);
		_tmp176_ = self->priv->pinLabelEntry;
		g_signal_connect ((GtkEditable*) _tmp176_, "changed", (GCallback) ____lambda64__gtk_editable_changed, self);
		_tmp177_ = self->priv->pinLabelHBox;
		_tmp178_ = self->priv->pinLabelEntry;
		gtk_box_pack_start (_tmp177_, (GtkWidget*) _tmp178_, TRUE, TRUE, (guint) 1);
	}
	_tmp179_ = (GtkLabel*) gtk_label_new ("Bounds define the visual size:");
	g_object_ref_sink (_tmp179_);
	_g_object_unref0 (self->priv->boundsLabel);
	self->priv->boundsLabel = _tmp179_;
	_tmp180_ = self->priv->controlsVBox;
	_tmp181_ = self->priv->boundsLabel;
	gtk_box_pack_start (_tmp180_, (GtkWidget*) _tmp181_, FALSE, TRUE, (guint) 1);
	_tmp182_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp182_);
	_g_object_unref0 (self->priv->boundsGrid);
	self->priv->boundsGrid = _tmp182_;
	_tmp183_ = self->priv->controlsVBox;
	_tmp184_ = self->priv->boundsGrid;
	gtk_box_pack_start (_tmp183_, (GtkWidget*) _tmp184_, FALSE, TRUE, (guint) 1);
	_tmp185_ = (GtkLabel*) gtk_label_new ("Right:");
	g_object_ref_sink (_tmp185_);
	_g_object_unref0 (self->priv->rightBoundLabel);
	self->priv->rightBoundLabel = _tmp185_;
	_tmp186_ = self->priv->boundsGrid;
	_tmp187_ = self->priv->rightBoundLabel;
	gtk_grid_attach (_tmp186_, (GtkWidget*) _tmp187_, 0, 0, 1, 1);
	_tmp188_ = G_MAXINT;
	_tmp189_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) _tmp188_, (gdouble) 5);
	g_object_ref_sink (_tmp189_);
	_g_object_unref0 (self->priv->rightBoundSpinButton);
	self->priv->rightBoundSpinButton = _tmp189_;
	_tmp190_ = self->priv->rightBoundSpinButton;
	_tmp191_ = self->priv->customComponentDef;
	_tmp192_ = ((ComponentDef*) _tmp191_)->rightBound;
	gtk_spin_button_set_value (_tmp190_, (gdouble) _tmp192_);
	_tmp193_ = self->priv->rightBoundSpinButton;
	g_signal_connect (_tmp193_, "value-changed", (GCallback) _customiser_update_bounds_gtk_spin_button_value_changed, self);
	_tmp194_ = self->priv->boundsGrid;
	_tmp195_ = self->priv->rightBoundSpinButton;
	gtk_grid_attach (_tmp194_, (GtkWidget*) _tmp195_, 1, 0, 1, 1);
	_tmp196_ = (GtkLabel*) gtk_label_new ("Down:");
	g_object_ref_sink (_tmp196_);
	_g_object_unref0 (self->priv->downBoundLabel);
	self->priv->downBoundLabel = _tmp196_;
	_tmp197_ = self->priv->boundsGrid;
	_tmp198_ = self->priv->downBoundLabel;
	gtk_grid_attach (_tmp197_, (GtkWidget*) _tmp198_, 0, 1, 1, 1);
	_tmp199_ = G_MAXINT;
	_tmp200_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) _tmp199_, (gdouble) 5);
	g_object_ref_sink (_tmp200_);
	_g_object_unref0 (self->priv->downBoundSpinButton);
	self->priv->downBoundSpinButton = _tmp200_;
	_tmp201_ = self->priv->downBoundSpinButton;
	_tmp202_ = self->priv->customComponentDef;
	_tmp203_ = ((ComponentDef*) _tmp202_)->downBound;
	gtk_spin_button_set_value (_tmp201_, (gdouble) _tmp203_);
	_tmp204_ = self->priv->downBoundSpinButton;
	g_signal_connect (_tmp204_, "value-changed", (GCallback) _customiser_update_bounds_gtk_spin_button_value_changed, self);
	_tmp205_ = self->priv->boundsGrid;
	_tmp206_ = self->priv->downBoundSpinButton;
	gtk_grid_attach (_tmp205_, (GtkWidget*) _tmp206_, 1, 1, 1, 1);
	_tmp207_ = (GtkLabel*) gtk_label_new ("Left:");
	g_object_ref_sink (_tmp207_);
	_g_object_unref0 (self->priv->leftBoundLabel);
	self->priv->leftBoundLabel = _tmp207_;
	_tmp208_ = self->priv->boundsGrid;
	_tmp209_ = self->priv->leftBoundLabel;
	gtk_grid_attach (_tmp208_, (GtkWidget*) _tmp209_, 0, 2, 1, 1);
	_tmp210_ = G_MININT;
	_tmp211_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) _tmp210_, (gdouble) 0, (gdouble) 5);
	g_object_ref_sink (_tmp211_);
	_g_object_unref0 (self->priv->leftBoundSpinButton);
	self->priv->leftBoundSpinButton = _tmp211_;
	_tmp212_ = self->priv->leftBoundSpinButton;
	_tmp213_ = self->priv->customComponentDef;
	_tmp214_ = ((ComponentDef*) _tmp213_)->leftBound;
	gtk_spin_button_set_value (_tmp212_, (gdouble) _tmp214_);
	_tmp215_ = self->priv->leftBoundSpinButton;
	g_signal_connect (_tmp215_, "value-changed", (GCallback) _customiser_update_bounds_gtk_spin_button_value_changed, self);
	_tmp216_ = self->priv->boundsGrid;
	_tmp217_ = self->priv->leftBoundSpinButton;
	gtk_grid_attach (_tmp216_, (GtkWidget*) _tmp217_, 1, 2, 1, 1);
	_tmp218_ = (GtkLabel*) gtk_label_new ("Up:");
	g_object_ref_sink (_tmp218_);
	_g_object_unref0 (self->priv->upBoundLabel);
	self->priv->upBoundLabel = _tmp218_;
	_tmp219_ = self->priv->boundsGrid;
	_tmp220_ = self->priv->upBoundLabel;
	gtk_grid_attach (_tmp219_, (GtkWidget*) _tmp220_, 0, 3, 1, 1);
	_tmp221_ = G_MININT;
	_tmp222_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) _tmp221_, (gdouble) 0, (gdouble) 5);
	g_object_ref_sink (_tmp222_);
	_g_object_unref0 (self->priv->upBoundSpinButton);
	self->priv->upBoundSpinButton = _tmp222_;
	_tmp223_ = self->priv->upBoundSpinButton;
	_tmp224_ = self->priv->customComponentDef;
	_tmp225_ = ((ComponentDef*) _tmp224_)->upBound;
	gtk_spin_button_set_value (_tmp223_, (gdouble) _tmp225_);
	_tmp226_ = self->priv->upBoundSpinButton;
	g_signal_connect (_tmp226_, "value-changed", (GCallback) _customiser_update_bounds_gtk_spin_button_value_changed, self);
	_tmp227_ = self->priv->boundsGrid;
	_tmp228_ = self->priv->upBoundSpinButton;
	gtk_grid_attach (_tmp227_, (GtkWidget*) _tmp228_, 1, 3, 1, 1);
	_tmp229_ = (GtkButton*) gtk_button_new_with_label ("Background Colour");
	g_object_ref_sink (_tmp229_);
	_g_object_unref0 (self->priv->colourButton);
	self->priv->colourButton = _tmp229_;
	_tmp230_ = self->priv->colourButton;
	g_signal_connect (_tmp230_, "clicked", (GCallback) ___lambda65__gtk_button_clicked, self);
	_tmp231_ = self->priv->controlsVBox;
	_tmp232_ = self->priv->colourButton;
	gtk_box_pack_start (_tmp231_, (GtkWidget*) _tmp232_, FALSE, TRUE, (guint) 1);
	_tmp233_ = self->priv->dialog;
	g_signal_connect (_tmp233_, "response", (GCallback) _customiser_response_handler_gtk_dialog_response, self);
	_tmp234_ = (GtkButton*) gtk_button_new_with_label ("Close");
	g_object_ref_sink (_tmp234_);
	_g_object_unref0 (self->priv->closeButton);
	self->priv->closeButton = _tmp234_;
	_tmp235_ = self->priv->dialog;
	_tmp236_ = self->priv->closeButton;
	gtk_dialog_add_action_widget (_tmp235_, (GtkWidget*) _tmp236_, (gint) GTK_RESPONSE_CLOSE);
	_tmp237_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp237_);
	_g_object_unref0 (content);
}


/**
 * Signal handler for the Gtk.EventBox. Handles a mouse button down
 * event on the display area.
 */
static gboolean customiser_mouse_down (Customiser* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->x;
	self->priv->xMouseStart = (gint) _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->y;
	self->priv->yMouseStart = (gint) _tmp3_;
	result = FALSE;
	return result;
}


/**
 * Signal handler for the Gtk.EventBox. Handles a mouse button up
 * event on the display area. This is when an action is taken.
 */
static gboolean customiser_mouse_up (Customiser* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkAllocation areaAllocation = {0};
	GtkEventBox* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	gint width = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint height = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint xCentre = 0;
	gint _tmp6_ = 0;
	gint yCentre = 0;
	gint _tmp7_ = 0;
	gint xStart = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint yStart = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint xEnd = 0;
	GdkEventButton* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	gint yEnd = 0;
	GdkEventButton* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	gint _tmp17_ = 0;
	gint yDiff = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint halfGridSize = 0;
	gint _tmp20_ = 0;
	gint xBoardStart = 0;
	gint _tmp21_ = 0;
	gfloat _tmp22_ = 0.0F;
	gint _tmp23_ = 0;
	gint yBoardStart = 0;
	gint _tmp24_ = 0;
	gfloat _tmp25_ = 0.0F;
	gint _tmp26_ = 0;
	gint xBoardEnd = 0;
	gint _tmp27_ = 0;
	gfloat _tmp28_ = 0.0F;
	gint _tmp29_ = 0;
	gint yBoardEnd = 0;
	gint _tmp30_ = 0;
	gfloat _tmp31_ = 0.0F;
	gint _tmp32_ = 0;
	CustomiserMouseMode _tmp33_ = 0;
	FILE* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	gint xBoardDiff = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint yBoardDiff = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	gint yDiffAbs = 0;
	gint rightBound = 0;
	CustomComponentDef* _tmp79_ = NULL;
	gint _tmp80_ = 0;
	gint downBound = 0;
	CustomComponentDef* _tmp81_ = NULL;
	gint _tmp82_ = 0;
	gint leftBound = 0;
	CustomComponentDef* _tmp83_ = NULL;
	gint _tmp84_ = 0;
	gint upBound = 0;
	CustomComponentDef* _tmp85_ = NULL;
	gint _tmp86_ = 0;
	CustomiserMouseMode _tmp87_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->controller;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = width;
	xCentre = _tmp6_ / 2;
	_tmp7_ = height;
	yCentre = _tmp7_ / 2;
	_tmp8_ = self->priv->xMouseStart;
	_tmp9_ = xCentre;
	xStart = _tmp8_ - _tmp9_;
	_tmp10_ = self->priv->yMouseStart;
	_tmp11_ = yCentre;
	yStart = _tmp10_ - _tmp11_;
	_tmp12_ = event;
	_tmp13_ = _tmp12_->x;
	_tmp14_ = xCentre;
	xEnd = ((gint) _tmp13_) - _tmp14_;
	_tmp15_ = event;
	_tmp16_ = _tmp15_->y;
	_tmp17_ = yCentre;
	yEnd = ((gint) _tmp16_) - _tmp17_;
	_tmp18_ = yEnd;
	_tmp19_ = yStart;
	yDiff = _tmp18_ - _tmp19_;
	_tmp20_ = self->gridSize;
	halfGridSize = _tmp20_ / 2;
	_tmp21_ = xStart;
	_tmp22_ = self->zoom;
	_tmp23_ = self->priv->xView;
	xBoardStart = (gint) ((((gfloat) _tmp21_) / _tmp22_) + ((gfloat) _tmp23_));
	_tmp24_ = yStart;
	_tmp25_ = self->zoom;
	_tmp26_ = self->priv->yView;
	yBoardStart = (gint) ((((gfloat) _tmp24_) / _tmp25_) + ((gfloat) _tmp26_));
	_tmp27_ = xEnd;
	_tmp28_ = self->zoom;
	_tmp29_ = self->priv->xView;
	xBoardEnd = (gint) ((((gfloat) _tmp27_) / _tmp28_) + ((gfloat) _tmp29_));
	_tmp30_ = yEnd;
	_tmp31_ = self->zoom;
	_tmp32_ = self->priv->yView;
	yBoardEnd = (gint) ((((gfloat) _tmp30_) / _tmp31_) + ((gfloat) _tmp32_));
	_tmp33_ = self->priv->mouseMode;
	switch (_tmp33_) {
		case CUSTOMISER_MOUSE_MODE_SCROLL:
		case CUSTOMISER_MOUSE_MODE_ZOOM:
		{
			break;
		}
		case CUSTOMISER_MOUSE_MODE_PIN:
		{
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gint _tmp54_ = 0;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			gint _tmp59_ = 0;
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			_tmp35_ = xBoardStart;
			if (_tmp35_ > 0) {
				gint _tmp36_ = 0;
				_tmp36_ = halfGridSize;
				_tmp34_ = _tmp36_;
			} else {
				gint _tmp37_ = 0;
				_tmp37_ = halfGridSize;
				_tmp34_ = -_tmp37_;
			}
			_tmp38_ = xBoardStart;
			xBoardStart = _tmp38_ + _tmp34_;
			_tmp40_ = yBoardStart;
			if (_tmp40_ > 0) {
				gint _tmp41_ = 0;
				_tmp41_ = halfGridSize;
				_tmp39_ = _tmp41_;
			} else {
				gint _tmp42_ = 0;
				_tmp42_ = halfGridSize;
				_tmp39_ = -_tmp42_;
			}
			_tmp43_ = yBoardStart;
			yBoardStart = _tmp43_ + _tmp39_;
			_tmp44_ = xBoardStart;
			_tmp45_ = self->gridSize;
			_tmp46_ = self->gridSize;
			xBoardStart = (_tmp44_ / _tmp45_) * _tmp46_;
			_tmp47_ = yBoardStart;
			_tmp48_ = self->gridSize;
			_tmp49_ = self->gridSize;
			yBoardStart = (_tmp47_ / _tmp48_) * _tmp49_;
			_tmp51_ = xBoardEnd;
			if (_tmp51_ > 0) {
				gint _tmp52_ = 0;
				_tmp52_ = halfGridSize;
				_tmp50_ = _tmp52_;
			} else {
				gint _tmp53_ = 0;
				_tmp53_ = halfGridSize;
				_tmp50_ = -_tmp53_;
			}
			_tmp54_ = xBoardEnd;
			xBoardEnd = _tmp54_ + _tmp50_;
			_tmp56_ = yBoardEnd;
			if (_tmp56_ > 0) {
				gint _tmp57_ = 0;
				_tmp57_ = halfGridSize;
				_tmp55_ = _tmp57_;
			} else {
				gint _tmp58_ = 0;
				_tmp58_ = halfGridSize;
				_tmp55_ = -_tmp58_;
			}
			_tmp59_ = yBoardEnd;
			yBoardEnd = _tmp59_ + _tmp55_;
			_tmp60_ = xBoardEnd;
			_tmp61_ = self->gridSize;
			_tmp62_ = self->gridSize;
			xBoardEnd = (_tmp60_ / _tmp61_) * _tmp62_;
			_tmp63_ = yBoardEnd;
			_tmp64_ = self->gridSize;
			_tmp65_ = self->gridSize;
			yBoardEnd = (_tmp63_ / _tmp64_) * _tmp65_;
			break;
		}
		default:
		break;
	}
	_tmp66_ = stdout;
	_tmp67_ = xBoardStart;
	_tmp68_ = yBoardStart;
	_tmp69_ = xBoardEnd;
	_tmp70_ = yBoardEnd;
	fprintf (_tmp66_, "Customiser Interact @ %i, %i - %i, %i\n", _tmp67_, _tmp68_, _tmp69_, _tmp70_);
	_tmp71_ = xBoardEnd;
	_tmp72_ = xBoardStart;
	xBoardDiff = _tmp71_ - _tmp72_;
	_tmp73_ = yBoardEnd;
	_tmp74_ = yBoardStart;
	yBoardDiff = _tmp73_ - _tmp74_;
	_tmp76_ = yDiff;
	if (_tmp76_ > 0) {
		gint _tmp77_ = 0;
		_tmp77_ = yDiff;
		_tmp75_ = _tmp77_;
	} else {
		gint _tmp78_ = 0;
		_tmp78_ = yDiff;
		_tmp75_ = -_tmp78_;
	}
	yDiffAbs = _tmp75_;
	_tmp79_ = self->priv->customComponentDef;
	_tmp80_ = ((ComponentDef*) _tmp79_)->rightBound;
	rightBound = _tmp80_;
	_tmp81_ = self->priv->customComponentDef;
	_tmp82_ = ((ComponentDef*) _tmp81_)->downBound;
	downBound = _tmp82_;
	_tmp83_ = self->priv->customComponentDef;
	_tmp84_ = ((ComponentDef*) _tmp83_)->leftBound;
	leftBound = _tmp84_;
	_tmp85_ = self->priv->customComponentDef;
	_tmp86_ = ((ComponentDef*) _tmp85_)->upBound;
	upBound = _tmp86_;
	_tmp87_ = self->priv->mouseMode;
	switch (_tmp87_) {
		case CUSTOMISER_MOUSE_MODE_SCROLL:
		{
			gint _tmp88_ = 0;
			gint _tmp89_ = 0;
			gint _tmp90_ = 0;
			gint _tmp91_ = 0;
			_tmp88_ = self->priv->xView;
			_tmp89_ = xBoardDiff;
			self->priv->xView = _tmp88_ - _tmp89_;
			_tmp90_ = self->priv->yView;
			_tmp91_ = yBoardDiff;
			self->priv->yView = _tmp90_ - _tmp91_;
			_cairo_surface_destroy0 (self->priv->gridCache);
			self->priv->gridCache = NULL;
			break;
		}
		case CUSTOMISER_MOUSE_MODE_ZOOM:
		{
			gint _tmp92_ = 0;
			_tmp92_ = yDiff;
			if (_tmp92_ > 0) {
				gfloat _tmp93_ = 0.0F;
				gint _tmp94_ = 0;
				gint _tmp95_ = 0;
				_tmp93_ = self->zoom;
				_tmp94_ = yDiffAbs;
				_tmp95_ = height;
				self->zoom = _tmp93_ * (1.0f + (((gfloat) _tmp94_) / ((gfloat) _tmp95_)));
			} else {
				gfloat _tmp96_ = 0.0F;
				gint _tmp97_ = 0;
				gint _tmp98_ = 0;
				_tmp96_ = self->zoom;
				_tmp97_ = yDiffAbs;
				_tmp98_ = height;
				self->zoom = _tmp96_ / (1.0f + (((gfloat) _tmp97_) / ((gfloat) _tmp98_)));
			}
			_cairo_surface_destroy0 (self->priv->gridCache);
			self->priv->gridCache = NULL;
			break;
		}
		case CUSTOMISER_MOUSE_MODE_PIN:
		{
			PinDef* _tmp99_ = NULL;
			_tmp99_ = self->priv->selectedPin;
			if (_tmp99_ != NULL) {
				gboolean _tmp100_ = FALSE;
				gint _tmp101_ = 0;
				gint _tmp102_ = 0;
				gboolean _tmp119_ = FALSE;
				gint _tmp120_ = 0;
				gint _tmp121_ = 0;
				_tmp101_ = upBound;
				_tmp102_ = yBoardEnd;
				if (_tmp101_ <= _tmp102_) {
					gint _tmp103_ = 0;
					gint _tmp104_ = 0;
					_tmp103_ = yBoardEnd;
					_tmp104_ = downBound;
					_tmp100_ = _tmp103_ <= _tmp104_;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					gint _tmp105_ = 0;
					gint _tmp106_ = 0;
					gint _tmp112_ = 0;
					gint _tmp113_ = 0;
					_tmp105_ = xBoardEnd;
					_tmp106_ = leftBound;
					if (_tmp105_ < _tmp106_) {
						PinDef* _tmp107_ = NULL;
						gint _tmp108_ = 0;
						gint _tmp109_ = 0;
						gint _tmp110_ = 0;
						gint _tmp111_ = 0;
						_tmp107_ = self->priv->selectedPin;
						_tmp108_ = leftBound;
						_tmp109_ = yBoardEnd;
						_tmp110_ = leftBound;
						_tmp111_ = xBoardEnd;
						pin_def_set_position (_tmp107_, _tmp108_, _tmp109_, _tmp110_ - _tmp111_, DIRECTION_LEFT);
					}
					_tmp112_ = xBoardEnd;
					_tmp113_ = rightBound;
					if (_tmp112_ > _tmp113_) {
						PinDef* _tmp114_ = NULL;
						gint _tmp115_ = 0;
						gint _tmp116_ = 0;
						gint _tmp117_ = 0;
						gint _tmp118_ = 0;
						_tmp114_ = self->priv->selectedPin;
						_tmp115_ = rightBound;
						_tmp116_ = yBoardEnd;
						_tmp117_ = xBoardEnd;
						_tmp118_ = rightBound;
						pin_def_set_position (_tmp114_, _tmp115_, _tmp116_, _tmp117_ - _tmp118_, DIRECTION_RIGHT);
					}
				}
				_tmp120_ = leftBound;
				_tmp121_ = xBoardEnd;
				if (_tmp120_ <= _tmp121_) {
					gint _tmp122_ = 0;
					gint _tmp123_ = 0;
					_tmp122_ = xBoardEnd;
					_tmp123_ = rightBound;
					_tmp119_ = _tmp122_ <= _tmp123_;
				} else {
					_tmp119_ = FALSE;
				}
				if (_tmp119_) {
					gint _tmp124_ = 0;
					gint _tmp125_ = 0;
					gint _tmp131_ = 0;
					gint _tmp132_ = 0;
					_tmp124_ = yBoardEnd;
					_tmp125_ = upBound;
					if (_tmp124_ < _tmp125_) {
						PinDef* _tmp126_ = NULL;
						gint _tmp127_ = 0;
						gint _tmp128_ = 0;
						gint _tmp129_ = 0;
						gint _tmp130_ = 0;
						_tmp126_ = self->priv->selectedPin;
						_tmp127_ = xBoardEnd;
						_tmp128_ = upBound;
						_tmp129_ = upBound;
						_tmp130_ = yBoardEnd;
						pin_def_set_position (_tmp126_, _tmp127_, _tmp128_, _tmp129_ - _tmp130_, DIRECTION_UP);
					}
					_tmp131_ = yBoardEnd;
					_tmp132_ = downBound;
					if (_tmp131_ > _tmp132_) {
						PinDef* _tmp133_ = NULL;
						gint _tmp134_ = 0;
						gint _tmp135_ = 0;
						gint _tmp136_ = 0;
						gint _tmp137_ = 0;
						_tmp133_ = self->priv->selectedPin;
						_tmp134_ = xBoardEnd;
						_tmp135_ = downBound;
						_tmp136_ = yBoardEnd;
						_tmp137_ = downBound;
						pin_def_set_position (_tmp133_, _tmp134_, _tmp135_, _tmp136_ - _tmp137_, DIRECTION_DOWN);
					}
				}
			}
			break;
		}
		default:
		break;
	}
	customiser_update_values (self);
	customiser_render_def (self, NULL);
	result = FALSE;
	return result;
}


/**
 * Called when the Customiser should become modal.
 */
void customiser_run (Customiser* self) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_dialog_run (_tmp0_);
}


/**
 * Handles the response of the customiser dialog. (On close.)
 */
void customiser_response_handler (Customiser* self, gint response_id) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	customiser_update_values (self);
	_tmp0_ = self->priv->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


void customiser_set_colour (Customiser* self) {
	GtkColorChooserDialog* colorDialog = NULL;
	GtkDialog* _tmp0_ = NULL;
	GtkColorChooserDialog* _tmp1_ = NULL;
	GdkRGBA color = {0};
	GtkColorChooserDialog* _tmp2_ = NULL;
	CustomComponentDef* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	CustomComponentDef* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	CustomComponentDef* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	CustomComponentDef* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkColorChooserDialog* _tmp13_ = NULL;
	GdkRGBA _tmp14_ = {0};
	GtkColorChooserDialog* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GtkColorChooserDialog* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	_tmp1_ = (GtkColorChooserDialog*) gtk_color_chooser_dialog_new ("Component Background", (GtkWindow*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	colorDialog = _tmp1_;
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp2_ = colorDialog;
	gtk_color_chooser_set_use_alpha ((GtkColorChooser*) _tmp2_, TRUE);
	_tmp3_ = self->priv->customComponentDef;
	_tmp4_ = ((ComponentDef*) _tmp3_)->backgroundRed;
	color.red = ((gdouble) _tmp4_) / 255.0;
	_tmp5_ = self->priv->customComponentDef;
	_tmp6_ = ((ComponentDef*) _tmp5_)->backgroundGreen;
	color.green = ((gdouble) _tmp6_) / 255.0;
	_tmp7_ = self->priv->customComponentDef;
	_tmp8_ = ((ComponentDef*) _tmp7_)->backgroundBlue;
	color.blue = ((gdouble) _tmp8_) / 255.0;
	_tmp9_ = self->priv->customComponentDef;
	_tmp10_ = ((ComponentDef*) _tmp9_)->backgroundAlpha;
	if (_tmp10_ == 0) {
		color.alpha = 1.0;
	} else {
		CustomComponentDef* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp11_ = self->priv->customComponentDef;
		_tmp12_ = ((ComponentDef*) _tmp11_)->backgroundAlpha;
		color.alpha = ((gdouble) _tmp12_) / 255.0;
	}
	_tmp13_ = colorDialog;
	_tmp14_ = color;
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp13_, &_tmp14_);
	_tmp15_ = colorDialog;
	_tmp16_ = gtk_dialog_run ((GtkDialog*) _tmp15_);
	if (_tmp16_ == ((gint) GTK_RESPONSE_OK)) {
		GtkColorChooserDialog* _tmp17_ = NULL;
		GdkRGBA _tmp18_ = {0};
		CustomComponentDef* _tmp19_ = NULL;
		GdkRGBA _tmp20_ = {0};
		gdouble _tmp21_ = 0.0;
		CustomComponentDef* _tmp22_ = NULL;
		GdkRGBA _tmp23_ = {0};
		gdouble _tmp24_ = 0.0;
		CustomComponentDef* _tmp25_ = NULL;
		GdkRGBA _tmp26_ = {0};
		gdouble _tmp27_ = 0.0;
		CustomComponentDef* _tmp28_ = NULL;
		GdkRGBA _tmp29_ = {0};
		gdouble _tmp30_ = 0.0;
		CustomComponentDef* _tmp31_ = NULL;
		CustomComponentDef* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		CustomComponentDef* _tmp34_ = NULL;
		CustomComponentDef* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		CustomComponentDef* _tmp37_ = NULL;
		CustomComponentDef* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		CustomComponentDef* _tmp40_ = NULL;
		CustomComponentDef* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		_tmp17_ = colorDialog;
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp17_, &_tmp18_);
		color = _tmp18_;
		_tmp19_ = self->priv->customComponentDef;
		_tmp20_ = color;
		_tmp21_ = _tmp20_.red;
		((ComponentDef*) _tmp19_)->backgroundRed = (gint) (_tmp21_ * 255.0);
		_tmp22_ = self->priv->customComponentDef;
		_tmp23_ = color;
		_tmp24_ = _tmp23_.green;
		((ComponentDef*) _tmp22_)->backgroundGreen = (gint) (_tmp24_ * 255.0);
		_tmp25_ = self->priv->customComponentDef;
		_tmp26_ = color;
		_tmp27_ = _tmp26_.blue;
		((ComponentDef*) _tmp25_)->backgroundBlue = (gint) (_tmp27_ * 255.0);
		_tmp28_ = self->priv->customComponentDef;
		_tmp29_ = color;
		_tmp30_ = _tmp29_.alpha;
		((ComponentDef*) _tmp28_)->backgroundAlpha = (gint) (_tmp30_ * 255.0);
		_tmp31_ = self->priv->customComponentDef;
		_tmp32_ = self->priv->customComponentDef;
		_tmp33_ = ((ComponentDef*) _tmp32_)->backgroundAlpha;
		((ComponentDef*) _tmp31_)->backgroundAlphaF = ((gdouble) _tmp33_) / 255.0;
		_tmp34_ = self->priv->customComponentDef;
		_tmp35_ = self->priv->customComponentDef;
		_tmp36_ = ((ComponentDef*) _tmp35_)->backgroundRed;
		((ComponentDef*) _tmp34_)->backgroundRedF = ((gdouble) _tmp36_) / 255.0;
		_tmp37_ = self->priv->customComponentDef;
		_tmp38_ = self->priv->customComponentDef;
		_tmp39_ = ((ComponentDef*) _tmp38_)->backgroundGreen;
		((ComponentDef*) _tmp37_)->backgroundGreenF = ((gdouble) _tmp39_) / 255.0;
		_tmp40_ = self->priv->customComponentDef;
		_tmp41_ = self->priv->customComponentDef;
		_tmp42_ = ((ComponentDef*) _tmp41_)->backgroundBlue;
		((ComponentDef*) _tmp40_)->backgroundBlueF = ((gdouble) _tmp42_) / 255.0;
	}
	_tmp43_ = colorDialog;
	gtk_widget_destroy ((GtkWidget*) _tmp43_);
	customiser_render_def (self, NULL);
	_g_object_unref0 (colorDialog);
}


/**
 * Set generic information. Called when closing the dialog.
 */
void customiser_update_values (Customiser* self) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CustomComponentDef* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	CustomComponentDef* _tmp30_ = NULL;
	GtkEntry* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->nameEntry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->customComponentDef;
	_tmp4_ = ((ComponentDef*) _tmp3_)->name;
	if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
		Project* _tmp5_ = NULL;
		GtkEntry* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		ComponentDef* _tmp9_ = NULL;
		ComponentDef* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp5_ = self->priv->project;
		_tmp6_ = self->priv->nameEntry;
		_tmp7_ = gtk_entry_get_text (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = project_resolve_def_name (_tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ == NULL;
		_component_def_unref0 (_tmp10_);
		if (_tmp11_) {
			CustomComponentDef* _tmp12_ = NULL;
			GtkEntry* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			_tmp12_ = self->priv->customComponentDef;
			_tmp13_ = self->priv->nameEntry;
			_tmp14_ = gtk_entry_get_text (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (((ComponentDef*) _tmp12_)->name);
			((ComponentDef*) _tmp12_)->name = _tmp16_;
		} else {
			GtkEntry* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			CustomComponentDef* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			_tmp17_ = self->priv->nameEntry;
			_tmp18_ = gtk_entry_get_text (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat ("A component with the name \"", _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat (_tmp21_, "\" already exists. It may be a built-in component or a custom componen" \
"t. This component's name will remain \"", NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->customComponentDef;
			_tmp25_ = ((ComponentDef*) _tmp24_)->name;
			_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp27_, "\".", NULL);
			_tmp29_ = _tmp28_;
			basic_dialog_error (NULL, _tmp29_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
		}
	}
	_tmp30_ = self->priv->customComponentDef;
	_tmp31_ = self->priv->descriptionEntry;
	_tmp32_ = gtk_entry_get_text (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strdup (_tmp33_);
	_g_free0 (((ComponentDef*) _tmp30_)->description);
	((ComponentDef*) _tmp30_)->description = _tmp34_;
}


/**
 * Set, from radio buttons, what type of label a pin should use.
 */
void customiser_update_label_type (Customiser* self) {
	PinDef* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selectedPin;
	if (_tmp0_ != NULL) {
		GtkRadioButton* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->labelTypeNoneRadio;
		_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			PinDef* _tmp4_ = NULL;
			_tmp4_ = self->priv->selectedPin;
			_tmp4_->labelType = PIN_DEF_LABEL_TYPE_NONE;
		} else {
			GtkRadioButton* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			_tmp5_ = self->priv->labelTypeTextRadio;
			_tmp6_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_) {
				PinDef* _tmp8_ = NULL;
				_tmp8_ = self->priv->selectedPin;
				_tmp8_->labelType = PIN_DEF_LABEL_TYPE_TEXT;
			} else {
				GtkRadioButton* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				_tmp9_ = self->priv->labelTypeTextBarRadio;
				_tmp10_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_) {
					PinDef* _tmp12_ = NULL;
					_tmp12_ = self->priv->selectedPin;
					_tmp12_->labelType = PIN_DEF_LABEL_TYPE_TEXTBAR;
				} else {
					GtkRadioButton* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					_tmp13_ = self->priv->labelTypeClockRadio;
					_tmp14_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp13_);
					_tmp15_ = _tmp14_;
					if (_tmp15_) {
						PinDef* _tmp16_ = NULL;
						_tmp16_ = self->priv->selectedPin;
						_tmp16_->labelType = PIN_DEF_LABEL_TYPE_CLOCK;
					}
				}
			}
		}
		customiser_render_def (self, NULL);
	}
}


/**
 * Set, from spin buttons, what the bounds of the component are.
 */
void customiser_update_bounds (Customiser* self) {
	CustomComponentDef* _tmp0_ = NULL;
	GtkSpinButton* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	CustomComponentDef* _tmp3_ = NULL;
	GtkSpinButton* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	CustomComponentDef* _tmp6_ = NULL;
	GtkSpinButton* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	CustomComponentDef* _tmp9_ = NULL;
	GtkSpinButton* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->customComponentDef;
	_tmp1_ = self->priv->rightBoundSpinButton;
	_tmp2_ = gtk_spin_button_get_value_as_int (_tmp1_);
	((ComponentDef*) _tmp0_)->rightBound = _tmp2_;
	_tmp3_ = self->priv->customComponentDef;
	_tmp4_ = self->priv->downBoundSpinButton;
	_tmp5_ = gtk_spin_button_get_value_as_int (_tmp4_);
	((ComponentDef*) _tmp3_)->downBound = _tmp5_;
	_tmp6_ = self->priv->customComponentDef;
	_tmp7_ = self->priv->leftBoundSpinButton;
	_tmp8_ = gtk_spin_button_get_value_as_int (_tmp7_);
	((ComponentDef*) _tmp6_)->leftBound = _tmp8_;
	_tmp9_ = self->priv->customComponentDef;
	_tmp10_ = self->priv->upBoundSpinButton;
	_tmp11_ = gtk_spin_button_get_value_as_int (_tmp10_);
	((ComponentDef*) _tmp9_)->upBound = _tmp11_;
	customiser_render_def (self, NULL);
}


/**
 * Update widgets to show the information of the selected pin.
 */
void customiser_update_selection (Customiser* self) {
	CustomComponentDef* _tmp0_ = NULL;
	PinDef** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->customComponentDef;
	_tmp1_ = ((ComponentDef*) _tmp0_)->pinDefs;
	_tmp1__length1 = ((ComponentDef*) _tmp0_)->pinDefs_length1;
	if (_tmp1__length1 > 0) {
		GtkSpinButton* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		CustomComponentDef* _tmp4_ = NULL;
		PinDef** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		PinDef* _tmp7_ = NULL;
		PinDef* _tmp8_ = NULL;
		CustomComponentDef* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		Tag* _tmp11_ = NULL;
		PinDef* _tmp12_ = NULL;
		PinDefLabelType _tmp13_ = 0;
		Tag* _tmp18_ = NULL;
		GtkEntry* _tmp31_ = NULL;
		PinDef* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GtkCheckButton* _tmp34_ = NULL;
		PinDef* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		_tmp2_ = self->priv->pinSpinButton;
		_tmp3_ = gtk_spin_button_get_value_as_int (_tmp2_);
		self->priv->selectedPinID = _tmp3_;
		_tmp4_ = self->priv->customComponentDef;
		_tmp5_ = ((ComponentDef*) _tmp4_)->pinDefs;
		_tmp5__length1 = ((ComponentDef*) _tmp4_)->pinDefs_length1;
		_tmp6_ = self->priv->selectedPinID;
		_tmp7_ = _tmp5_[_tmp6_];
		_tmp8_ = _pin_def_ref0 (_tmp7_);
		_pin_def_unref0 (self->priv->selectedPin);
		self->priv->selectedPin = _tmp8_;
		_tmp9_ = self->priv->customComponentDef;
		_tmp10_ = self->priv->selectedPinID;
		_tmp11_ = custom_component_def_resolve_tag_id (_tmp9_, _tmp10_);
		_tag_unref0 (self->priv->tag);
		self->priv->tag = _tmp11_;
		_tmp12_ = self->priv->selectedPin;
		_tmp13_ = _tmp12_->labelType;
		switch (_tmp13_) {
			case PIN_DEF_LABEL_TYPE_NONE:
			{
				GtkRadioButton* _tmp14_ = NULL;
				_tmp14_ = self->priv->labelTypeNoneRadio;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, TRUE);
				break;
			}
			case PIN_DEF_LABEL_TYPE_TEXT:
			{
				GtkRadioButton* _tmp15_ = NULL;
				_tmp15_ = self->priv->labelTypeTextRadio;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp15_, TRUE);
				break;
			}
			case PIN_DEF_LABEL_TYPE_TEXTBAR:
			{
				GtkRadioButton* _tmp16_ = NULL;
				_tmp16_ = self->priv->labelTypeTextBarRadio;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp16_, TRUE);
				break;
			}
			case PIN_DEF_LABEL_TYPE_CLOCK:
			{
				GtkRadioButton* _tmp17_ = NULL;
				_tmp17_ = self->priv->labelTypeClockRadio;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp17_, TRUE);
				break;
			}
			default:
			break;
		}
		_tmp18_ = self->priv->tag;
		if (_tmp18_ != NULL) {
			GtkLabel* _tmp19_ = NULL;
			Tag* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			PinDef* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp19_ = self->priv->tagNameLabel;
			_tmp20_ = self->priv->tag;
			_tmp21_ = _tmp20_->text;
			_tmp22_ = g_strconcat ("Maps to: ", _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			gtk_label_set_label (_tmp19_, _tmp23_);
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->selectedPin;
			_tmp25_ = _tmp24_->label;
			if (g_strcmp0 (_tmp25_, "") == 0) {
				PinDef* _tmp26_ = NULL;
				Tag* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				_tmp26_ = self->priv->selectedPin;
				_tmp27_ = self->priv->tag;
				_tmp28_ = _tmp27_->text;
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (_tmp26_->label);
				_tmp26_->label = _tmp29_;
			}
		} else {
			GtkLabel* _tmp30_ = NULL;
			_tmp30_ = self->priv->tagNameLabel;
			gtk_label_set_label (_tmp30_, "There is no matching tag!");
		}
		_tmp31_ = self->priv->pinLabelEntry;
		_tmp32_ = self->priv->selectedPin;
		_tmp33_ = _tmp32_->label;
		gtk_entry_set_text (_tmp31_, _tmp33_);
		_tmp34_ = self->priv->requiredCheck;
		_tmp35_ = self->priv->selectedPin;
		_tmp36_ = _tmp35_->required;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp34_, _tmp36_);
	} else {
		_pin_def_unref0 (self->priv->selectedPin);
		self->priv->selectedPin = NULL;
	}
	customiser_render_def (self, NULL);
}


/**
 * Render the current box design.
 */
static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


gboolean customiser_render_def (Customiser* self, cairo_t* passedDisplayContext) {
	gboolean result = FALSE;
	cairo_t* displayContext = NULL;
	gint width = 0;
	gint height = 0;
	GtkAllocation areaAllocation = {0};
	GtkDrawingArea* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	cairo_t* _tmp6_ = NULL;
	cairo_surface_t* offScreenSurface = NULL;
	cairo_t* _tmp12_ = NULL;
	cairo_surface_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_surface_t* _tmp16_ = NULL;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	cairo_surface_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	DesignerWindow* _tmp23_ = NULL;
	cairo_t* _tmp104_ = NULL;
	gint _tmp105_ = 0;
	gint _tmp106_ = 0;
	cairo_t* _tmp107_ = NULL;
	gfloat _tmp108_ = 0.0F;
	gfloat _tmp109_ = 0.0F;
	cairo_t* _tmp110_ = NULL;
	gint _tmp111_ = 0;
	gint _tmp112_ = 0;
	cairo_t* _tmp113_ = NULL;
	CustomComponentDef* _tmp114_ = NULL;
	cairo_t* _tmp115_ = NULL;
	cairo_t* _tmp132_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = passedDisplayContext;
	if (_tmp6_ == NULL) {
		GtkDrawingArea* _tmp7_ = NULL;
		GdkWindow* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		_tmp7_ = self->priv->display;
		_tmp8_ = gtk_widget_get_window ((GtkWidget*) _tmp7_);
		_tmp9_ = gdk_cairo_create (_tmp8_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp9_;
	} else {
		cairo_t* _tmp10_ = NULL;
		cairo_t* _tmp11_ = NULL;
		_tmp10_ = passedDisplayContext;
		_tmp11_ = _cairo_reference0 (_tmp10_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp11_;
	}
	_tmp12_ = displayContext;
	_tmp13_ = cairo_get_target (_tmp12_);
	_tmp14_ = width;
	_tmp15_ = height;
	_tmp16_ = cairo_surface_create_similar (_tmp13_, CAIRO_CONTENT_COLOR, _tmp14_, _tmp15_);
	offScreenSurface = _tmp16_;
	_tmp17_ = offScreenSurface;
	_tmp18_ = cairo_create (_tmp17_);
	context = _tmp18_;
	_tmp19_ = displayContext;
	_tmp20_ = offScreenSurface;
	cairo_set_source_surface (_tmp19_, _tmp20_, (gdouble) 0, (gdouble) 0);
	_tmp21_ = context;
	cairo_set_line_width (_tmp21_, (gdouble) 1);
	_tmp23_ = self->priv->parent;
	if (_tmp23_ != NULL) {
		DesignerWindow* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		_tmp24_ = self->priv->parent;
		_tmp25_ = _tmp24_->showGrid;
		_tmp22_ = _tmp25_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		cairo_surface_t* _tmp26_ = NULL;
		cairo_t* _tmp99_ = NULL;
		cairo_surface_t* _tmp100_ = NULL;
		cairo_t* _tmp101_ = NULL;
		_tmp26_ = self->priv->gridCache;
		if (_tmp26_ == NULL) {
			cairo_t* _tmp27_ = NULL;
			cairo_surface_t* _tmp28_ = NULL;
			cairo_t* _tmp29_ = NULL;
			cairo_surface_t* _tmp30_ = NULL;
			cairo_content_t _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			cairo_surface_t* _tmp34_ = NULL;
			cairo_t* gridContext = NULL;
			cairo_surface_t* _tmp35_ = NULL;
			cairo_t* _tmp36_ = NULL;
			cairo_t* _tmp37_ = NULL;
			cairo_t* _tmp38_ = NULL;
			gfloat spacing = 0.0F;
			gfloat _tmp39_ = 0.0F;
			DesignerWindow* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gfloat y = 0.0F;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			gfloat _tmp48_ = 0.0F;
			gfloat _tmp49_ = 0.0F;
			gfloat x = 0.0F;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gfloat _tmp52_ = 0.0F;
			gfloat _tmp53_ = 0.0F;
			cairo_t* _tmp54_ = NULL;
			cairo_t* _tmp55_ = NULL;
			gfloat _tmp56_ = 0.0F;
			gdouble* _tmp57_ = NULL;
			gdouble* _tmp58_ = NULL;
			gint _tmp58__length1 = 0;
			gfloat _tmp71_ = 0.0F;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gfloat _tmp74_ = 0.0F;
			gfloat _tmp75_ = 0.0F;
			gint _tmp76_ = 0;
			gint _tmp77_ = 0;
			gfloat _tmp78_ = 0.0F;
			gfloat _tmp79_ = 0.0F;
			cairo_t* _tmp80_ = NULL;
			cairo_t* _tmp81_ = NULL;
			gfloat _tmp82_ = 0.0F;
			gdouble* _tmp83_ = NULL;
			gdouble* _tmp84_ = NULL;
			gint _tmp84__length1 = 0;
			cairo_t* _tmp97_ = NULL;
			cairo_t* _tmp98_ = NULL;
			_tmp27_ = context;
			_tmp28_ = cairo_get_target (_tmp27_);
			_tmp29_ = context;
			_tmp30_ = cairo_get_target (_tmp29_);
			_tmp31_ = cairo_surface_get_content (_tmp30_);
			_tmp32_ = width;
			_tmp33_ = height;
			_tmp34_ = cairo_surface_create_similar (_tmp28_, _tmp31_, _tmp32_, _tmp33_);
			_cairo_surface_destroy0 (self->priv->gridCache);
			self->priv->gridCache = _tmp34_;
			_tmp35_ = self->priv->gridCache;
			_tmp36_ = cairo_create (_tmp35_);
			gridContext = _tmp36_;
			_tmp37_ = gridContext;
			cairo_set_source_rgb (_tmp37_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
			_tmp38_ = gridContext;
			cairo_paint (_tmp38_);
			_tmp39_ = self->zoom;
			_tmp40_ = self->priv->parent;
			_tmp41_ = _tmp40_->gridSize;
			spacing = _tmp39_ * _tmp41_;
			while (TRUE) {
				gfloat _tmp42_ = 0.0F;
				gfloat _tmp43_ = 0.0F;
				DesignerWindow* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				_tmp42_ = spacing;
				if (!(_tmp42_ < ((gfloat) 2))) {
					break;
				}
				_tmp43_ = spacing;
				_tmp44_ = self->priv->parent;
				_tmp45_ = _tmp44_->gridSize;
				spacing = _tmp43_ * _tmp45_;
			}
			_tmp46_ = height;
			_tmp47_ = self->priv->yView;
			_tmp48_ = self->zoom;
			_tmp49_ = spacing;
			y = fmodf ((_tmp46_ / 2) - (((gfloat) _tmp47_) * _tmp48_), _tmp49_);
			_tmp50_ = width;
			_tmp51_ = self->priv->xView;
			_tmp52_ = self->zoom;
			_tmp53_ = spacing;
			x = fmodf ((_tmp50_ / 2) - (((gfloat) _tmp51_) * _tmp52_), _tmp53_);
			_tmp54_ = gridContext;
			cairo_set_source_rgba (_tmp54_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
			_tmp55_ = gridContext;
			_tmp56_ = spacing;
			_tmp57_ = g_new0 (gdouble, 2);
			_tmp57_[0] = 1.0;
			_tmp57_[1] = _tmp56_ - 1.0;
			_tmp58_ = _tmp57_;
			_tmp58__length1 = 2;
			cairo_set_dash (_tmp55_, _tmp58_, 2, (gdouble) 0);
			_tmp58_ = (g_free (_tmp58_), NULL);
			{
				gboolean _tmp59_ = FALSE;
				_tmp59_ = TRUE;
				while (TRUE) {
					gfloat _tmp62_ = 0.0F;
					gint _tmp63_ = 0;
					cairo_t* _tmp64_ = NULL;
					gfloat _tmp65_ = 0.0F;
					gfloat _tmp66_ = 0.0F;
					cairo_t* _tmp67_ = NULL;
					gint _tmp68_ = 0;
					gfloat _tmp69_ = 0.0F;
					cairo_t* _tmp70_ = NULL;
					if (!_tmp59_) {
						gfloat _tmp60_ = 0.0F;
						gfloat _tmp61_ = 0.0F;
						_tmp60_ = y;
						_tmp61_ = spacing;
						y = _tmp60_ + _tmp61_;
					}
					_tmp59_ = FALSE;
					_tmp62_ = y;
					_tmp63_ = height;
					if (!(_tmp62_ < ((gfloat) _tmp63_))) {
						break;
					}
					_tmp64_ = gridContext;
					_tmp65_ = x;
					_tmp66_ = y;
					cairo_move_to (_tmp64_, (gdouble) _tmp65_, (gdouble) _tmp66_);
					_tmp67_ = gridContext;
					_tmp68_ = width;
					_tmp69_ = y;
					cairo_line_to (_tmp67_, (gdouble) _tmp68_, (gdouble) _tmp69_);
					_tmp70_ = gridContext;
					cairo_stroke (_tmp70_);
				}
			}
			_tmp71_ = spacing;
			spacing = _tmp71_ * 4;
			_tmp72_ = height;
			_tmp73_ = self->priv->yView;
			_tmp74_ = self->zoom;
			_tmp75_ = spacing;
			y = fmodf ((_tmp72_ / 2) - (((gfloat) _tmp73_) * _tmp74_), _tmp75_);
			_tmp76_ = width;
			_tmp77_ = self->priv->xView;
			_tmp78_ = self->zoom;
			_tmp79_ = spacing;
			x = fmodf ((_tmp76_ / 2) - (((gfloat) _tmp77_) * _tmp78_), _tmp79_);
			_tmp80_ = gridContext;
			cairo_set_source_rgba (_tmp80_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 1.0);
			_tmp81_ = gridContext;
			_tmp82_ = spacing;
			_tmp83_ = g_new0 (gdouble, 2);
			_tmp83_[0] = 1.0;
			_tmp83_[1] = _tmp82_ - 1.0;
			_tmp84_ = _tmp83_;
			_tmp84__length1 = 2;
			cairo_set_dash (_tmp81_, _tmp84_, 2, (gdouble) 0);
			_tmp84_ = (g_free (_tmp84_), NULL);
			{
				gboolean _tmp85_ = FALSE;
				_tmp85_ = TRUE;
				while (TRUE) {
					gfloat _tmp88_ = 0.0F;
					gint _tmp89_ = 0;
					cairo_t* _tmp90_ = NULL;
					gfloat _tmp91_ = 0.0F;
					gfloat _tmp92_ = 0.0F;
					cairo_t* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gfloat _tmp95_ = 0.0F;
					cairo_t* _tmp96_ = NULL;
					if (!_tmp85_) {
						gfloat _tmp86_ = 0.0F;
						gfloat _tmp87_ = 0.0F;
						_tmp86_ = y;
						_tmp87_ = spacing;
						y = _tmp86_ + _tmp87_;
					}
					_tmp85_ = FALSE;
					_tmp88_ = y;
					_tmp89_ = height;
					if (!(_tmp88_ < ((gfloat) _tmp89_))) {
						break;
					}
					_tmp90_ = gridContext;
					_tmp91_ = x;
					_tmp92_ = y;
					cairo_move_to (_tmp90_, (gdouble) _tmp91_, (gdouble) _tmp92_);
					_tmp93_ = gridContext;
					_tmp94_ = width;
					_tmp95_ = y;
					cairo_line_to (_tmp93_, (gdouble) _tmp94_, (gdouble) _tmp95_);
					_tmp96_ = gridContext;
					cairo_stroke (_tmp96_);
				}
			}
			_tmp97_ = gridContext;
			cairo_set_dash (_tmp97_, NULL, 0, (gdouble) 0);
			_tmp98_ = gridContext;
			cairo_set_source_rgba (_tmp98_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
			_cairo_destroy0 (gridContext);
		}
		_tmp99_ = context;
		_tmp100_ = self->priv->gridCache;
		cairo_set_source_surface (_tmp99_, _tmp100_, (gdouble) 0, (gdouble) 0);
		_tmp101_ = context;
		cairo_paint (_tmp101_);
	} else {
		cairo_t* _tmp102_ = NULL;
		cairo_t* _tmp103_ = NULL;
		_tmp102_ = context;
		cairo_set_source_rgb (_tmp102_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp103_ = context;
		cairo_paint (_tmp103_);
	}
	_tmp104_ = context;
	_tmp105_ = width;
	_tmp106_ = height;
	cairo_translate (_tmp104_, (gdouble) (_tmp105_ / 2), (gdouble) (_tmp106_ / 2));
	_tmp107_ = context;
	_tmp108_ = self->zoom;
	_tmp109_ = self->zoom;
	cairo_scale (_tmp107_, (gdouble) _tmp108_, (gdouble) _tmp109_);
	_tmp110_ = context;
	_tmp111_ = self->priv->xView;
	_tmp112_ = self->priv->yView;
	cairo_translate (_tmp110_, (gdouble) (-_tmp111_), (gdouble) (-_tmp112_));
	_tmp113_ = context;
	cairo_set_source_rgb (_tmp113_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp114_ = self->priv->customComponentDef;
	_tmp115_ = context;
	component_def_render ((ComponentDef*) _tmp114_, _tmp115_, DIRECTION_RIGHT, FALSE, NULL, TRUE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp116_ = FALSE;
			_tmp116_ = TRUE;
			while (TRUE) {
				gint _tmp118_ = 0;
				CustomComponentDef* _tmp119_ = NULL;
				PinDef** _tmp120_ = NULL;
				gint _tmp120__length1 = 0;
				PinDef* pinDef = NULL;
				CustomComponentDef* _tmp121_ = NULL;
				PinDef** _tmp122_ = NULL;
				gint _tmp122__length1 = 0;
				gint _tmp123_ = 0;
				PinDef* _tmp124_ = NULL;
				PinDef* _tmp125_ = NULL;
				gint _tmp126_ = 0;
				gint _tmp127_ = 0;
				PinDef* _tmp130_ = NULL;
				cairo_t* _tmp131_ = NULL;
				if (!_tmp116_) {
					gint _tmp117_ = 0;
					_tmp117_ = i;
					i = _tmp117_ + 1;
				}
				_tmp116_ = FALSE;
				_tmp118_ = i;
				_tmp119_ = self->priv->customComponentDef;
				_tmp120_ = ((ComponentDef*) _tmp119_)->pinDefs;
				_tmp120__length1 = ((ComponentDef*) _tmp119_)->pinDefs_length1;
				if (!(_tmp118_ < _tmp120__length1)) {
					break;
				}
				_tmp121_ = self->priv->customComponentDef;
				_tmp122_ = ((ComponentDef*) _tmp121_)->pinDefs;
				_tmp122__length1 = ((ComponentDef*) _tmp121_)->pinDefs_length1;
				_tmp123_ = i;
				_tmp124_ = _tmp122_[_tmp123_];
				_tmp125_ = _pin_def_ref0 (_tmp124_);
				pinDef = _tmp125_;
				_tmp126_ = self->priv->selectedPinID;
				_tmp127_ = i;
				if (_tmp126_ == _tmp127_) {
					cairo_t* _tmp128_ = NULL;
					_tmp128_ = context;
					cairo_set_source_rgb (_tmp128_, (gdouble) 0, (gdouble) 0, (gdouble) 1);
				} else {
					cairo_t* _tmp129_ = NULL;
					_tmp129_ = context;
					cairo_set_source_rgb (_tmp129_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
				}
				_tmp130_ = pinDef;
				_tmp131_ = context;
				pin_def_render (_tmp130_, _tmp131_, FALSE);
				_pin_def_unref0 (pinDef);
			}
		}
	}
	_tmp132_ = displayContext;
	cairo_paint (_tmp132_);
	result = FALSE;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (offScreenSurface);
	_cairo_destroy0 (displayContext);
	return result;
}


static void value_customiser_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_customiser_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		customiser_unref (value->data[0].v_pointer);
	}
}


static void value_customiser_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = customiser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_customiser_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_customiser_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Customiser* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = customiser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_customiser_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Customiser** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = customiser_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_customiser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCustomiser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CUSTOMISER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_customiser (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CUSTOMISER), NULL);
	return value->data[0].v_pointer;
}


void value_set_customiser (GValue* value, gpointer v_object) {
	Customiser* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CUSTOMISER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CUSTOMISER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		customiser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		customiser_unref (old);
	}
}


void value_take_customiser (GValue* value, gpointer v_object) {
	Customiser* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CUSTOMISER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CUSTOMISER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		customiser_unref (old);
	}
}


static void customiser_class_init (CustomiserClass * klass) {
	customiser_parent_class = g_type_class_peek_parent (klass);
	CUSTOMISER_CLASS (klass)->finalize = customiser_finalize;
	g_type_class_add_private (klass, sizeof (CustomiserPrivate));
}


static void customiser_instance_init (Customiser * self) {
	self->priv = CUSTOMISER_GET_PRIVATE (self);
	self->gridSize = 5;
	self->priv->xView = 0;
	self->priv->yView = 0;
	self->zoom = (gfloat) 1;
	self->priv->mouseMode = CUSTOMISER_MOUSE_MODE_PIN;
	self->priv->selectedPinID = 0;
	self->ref_count = 1;
}


static void customiser_finalize (Customiser* obj) {
	Customiser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOMISER, Customiser);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->layoutHBox);
	_g_object_unref0 (self->priv->layoutVBox);
	_g_object_unref0 (self->priv->hiddenRadioToolButton);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->toolScroll);
	_g_object_unref0 (self->priv->toolScrollImage);
	_g_object_unref0 (self->priv->toolZoom);
	_g_object_unref0 (self->priv->toolZoomImage);
	_g_object_unref0 (self->priv->toolSeparator1);
	_g_object_unref0 (self->priv->toolPin);
	_g_object_unref0 (self->priv->toolPinImage);
	_g_object_unref0 (self->priv->controller);
	_g_object_unref0 (self->priv->display);
	_g_object_unref0 (self->priv->controlsVBox);
	_g_object_unref0 (self->priv->nameHBox);
	_g_object_unref0 (self->priv->nameEntry);
	_g_object_unref0 (self->priv->nameLabel);
	_g_object_unref0 (self->priv->descriptionHBox);
	_g_object_unref0 (self->priv->descriptionEntry);
	_g_object_unref0 (self->priv->descriptionLabel);
	_g_object_unref0 (self->priv->labelHBox);
	_g_object_unref0 (self->priv->labelEntry);
	_g_object_unref0 (self->priv->labelLabel);
	_g_object_unref0 (self->priv->pinHBox);
	_g_object_unref0 (self->priv->pinSpinButton);
	_g_object_unref0 (self->priv->pinLabel);
	_g_object_unref0 (self->priv->tagNameLabel);
	_g_object_unref0 (self->priv->requiredCheck);
	_g_object_unref0 (self->priv->labelTypeVBox);
	_g_object_unref0 (self->priv->labelTypeLabel);
	_g_object_unref0 (self->priv->labelTypeNoneRadio);
	_g_object_unref0 (self->priv->labelTypeTextRadio);
	_g_object_unref0 (self->priv->labelTypeTextBarRadio);
	_g_object_unref0 (self->priv->labelTypeClockRadio);
	_g_object_unref0 (self->priv->pinLabelHBox);
	_g_object_unref0 (self->priv->pinLabelEntry);
	_g_object_unref0 (self->priv->pinLabelLabel);
	_g_object_unref0 (self->priv->boundsLabel);
	_g_object_unref0 (self->priv->boundsGrid);
	_g_object_unref0 (self->priv->rightBoundLabel);
	_g_object_unref0 (self->priv->rightBoundSpinButton);
	_g_object_unref0 (self->priv->downBoundLabel);
	_g_object_unref0 (self->priv->downBoundSpinButton);
	_g_object_unref0 (self->priv->leftBoundLabel);
	_g_object_unref0 (self->priv->leftBoundSpinButton);
	_g_object_unref0 (self->priv->upBoundLabel);
	_g_object_unref0 (self->priv->upBoundSpinButton);
	_g_object_unref0 (self->priv->colourButton);
	_g_object_unref0 (self->priv->closeButton);
	_cairo_surface_destroy0 (self->priv->gridCache);
	_component_def_unref0 (self->priv->customComponentDef);
	_g_object_unref0 (self->priv->parent);
	_project_unref0 (self->priv->project);
	_pin_def_unref0 (self->priv->selectedPin);
	_tag_unref0 (self->priv->tag);
}


/**
 * User interface element used to customise a component.
 * 
 * Allows a user to design how a custom component can be used in another
 * component.
 * Used to edit names and descriptions, create a box design, and
 * configure pins.
 */
GType customiser_get_type (void) {
	static volatile gsize customiser_type_id__volatile = 0;
	if (g_once_init_enter (&customiser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_customiser_init, value_customiser_free_value, value_customiser_copy_value, value_customiser_peek_pointer, "p", value_customiser_collect_value, "p", value_customiser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CustomiserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) customiser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Customiser), 0, (GInstanceInitFunc) customiser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType customiser_type_id;
		customiser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Customiser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&customiser_type_id__volatile, customiser_type_id);
	}
	return customiser_type_id__volatile;
}


gpointer customiser_ref (gpointer instance) {
	Customiser* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void customiser_unref (gpointer instance) {
	Customiser* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CUSTOMISER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



