/* designer.c generated by valac 0.24.0, the Vala compiler
 * generated from designer.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: designer.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DESIGNER (designer_get_type ())
#define DESIGNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER, Designer))
#define DESIGNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER, DesignerClass))
#define IS_DESIGNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER))
#define IS_DESIGNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER))
#define DESIGNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER, DesignerClass))

typedef struct _Designer Designer;
typedef struct _DesignerClass DesignerClass;
typedef struct _DesignerPrivate DesignerPrivate;

#define TYPE_DESIGNER_WINDOW (designer_window_get_type ())
#define DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER_WINDOW, DesignerWindow))
#define DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER_WINDOW, DesignerWindowClass))
#define IS_DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER_WINDOW))
#define IS_DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER_WINDOW))
#define DESIGNER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER_WINDOW, DesignerWindowClass))

typedef struct _DesignerWindow DesignerWindow;
typedef struct _DesignerWindowClass DesignerWindowClass;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_PATH (path_get_type ())
#define PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH, Path))
#define PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH, PathClass))
#define IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH))
#define IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH))
#define PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH, PathClass))

typedef struct _Path Path;
typedef struct _PathClass PathClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
#define _path_unref0(var) ((var == NULL) ? NULL : (var = (path_unref (var), NULL)))

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

#define TYPE_DIRECTION (direction_get_type ())
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
typedef struct _CustomComponentDefPrivate CustomComponentDefPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;

#define TYPE_ANNOTATION (annotation_get_type ())
#define ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANNOTATION, Annotation))
#define ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANNOTATION, AnnotationClass))
#define IS_ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANNOTATION))
#define IS_ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANNOTATION))
#define ANNOTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANNOTATION, AnnotationClass))

typedef struct _Annotation Annotation;
typedef struct _AnnotationClass AnnotationClass;
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))

#define TYPE_FLOW (flow_get_type ())

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
typedef struct _WireInstPrivate WireInstPrivate;

#define WIRE_INST_TYPE_REGISTERED_COMPONENT (wire_inst_registered_component_get_type ())

#define WIRE_INST_TYPE_MARKER (wire_inst_marker_get_type ())
typedef struct _WireInstMarker WireInstMarker;
typedef struct _WireInstRegisteredComponent WireInstRegisteredComponent;

#define WIRE_INST_TYPE_PRESET_SIGNAL (wire_inst_preset_signal_get_type ())
typedef struct _TagPrivate TagPrivate;

#define TYPE_PROPERTY_ITEM_STRING (property_item_string_get_type ())
#define PROPERTY_ITEM_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_STRING, PropertyItemString))
#define PROPERTY_ITEM_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_STRING, PropertyItemStringClass))
#define IS_PROPERTY_ITEM_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_STRING))
#define IS_PROPERTY_ITEM_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_STRING))
#define PROPERTY_ITEM_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_STRING, PropertyItemStringClass))

typedef struct _PropertyItemString PropertyItemString;
typedef struct _PropertyItemStringClass PropertyItemStringClass;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))

#define TYPE_PROPERTY_ITEM_SELECTION (property_item_selection_get_type ())
#define PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection))
#define PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))
#define IS_PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_SELECTION))
#define IS_PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_SELECTION))
#define PROPERTY_ITEM_SELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))

typedef struct _PropertyItemSelection PropertyItemSelection;
typedef struct _PropertyItemSelectionClass PropertyItemSelectionClass;

#define TYPE_PROPERTY_ITEM_INT (property_item_int_get_type ())
#define PROPERTY_ITEM_INT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_INT, PropertyItemInt))
#define PROPERTY_ITEM_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_INT, PropertyItemIntClass))
#define IS_PROPERTY_ITEM_INT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_INT))
#define IS_PROPERTY_ITEM_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_INT))
#define PROPERTY_ITEM_INT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_INT, PropertyItemIntClass))

typedef struct _PropertyItemInt PropertyItemInt;
typedef struct _PropertyItemIntClass PropertyItemIntClass;

#define TYPE_PROPERTIES_QUERY (properties_query_get_type ())
#define PROPERTIES_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_QUERY, PropertiesQuery))
#define PROPERTIES_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTIES_QUERY, PropertiesQueryClass))
#define IS_PROPERTIES_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_QUERY))
#define IS_PROPERTIES_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTIES_QUERY))
#define PROPERTIES_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTIES_QUERY, PropertiesQueryClass))

typedef struct _PropertiesQuery PropertiesQuery;
typedef struct _PropertiesQueryClass PropertiesQueryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _tag_unref0(var) ((var == NULL) ? NULL : (var = (tag_unref (var), NULL)))
#define _properties_query_unref0(var) ((var == NULL) ? NULL : (var = (properties_query_unref (var), NULL)))
typedef struct _PathPrivate PathPrivate;

#define PATH_TYPE_LINE (path_line_get_type ())
typedef struct _PathLine PathLine;
typedef struct _PinInstPrivate PinInstPrivate;
#define _pin_inst_unref0(var) ((var == NULL) ? NULL : (var = (pin_inst_unref (var), NULL)))
typedef struct _PinDefPrivate PinDefPrivate;

#define PIN_DEF_TYPE_LABEL_TYPE (pin_def_label_type_get_type ())

#define TYPE_PROPERTY_ITEM_DOUBLE (property_item_double_get_type ())
#define PROPERTY_ITEM_DOUBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_DOUBLE, PropertyItemDouble))
#define PROPERTY_ITEM_DOUBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_DOUBLE, PropertyItemDoubleClass))
#define IS_PROPERTY_ITEM_DOUBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_DOUBLE))
#define IS_PROPERTY_ITEM_DOUBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_DOUBLE))
#define PROPERTY_ITEM_DOUBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_DOUBLE, PropertyItemDoubleClass))

typedef struct _PropertyItemDouble PropertyItemDouble;
typedef struct _PropertyItemDoubleClass PropertyItemDoubleClass;
#define _annotation_unref0(var) ((var == NULL) ? NULL : (var = (annotation_unref (var), NULL)))
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))

#define TYPE_CUSTOMISER (customiser_get_type ())
#define CUSTOMISER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOMISER, Customiser))
#define CUSTOMISER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOMISER, CustomiserClass))
#define IS_CUSTOMISER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOMISER))
#define IS_CUSTOMISER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOMISER))
#define CUSTOMISER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOMISER, CustomiserClass))

typedef struct _Customiser Customiser;
typedef struct _CustomiserClass CustomiserClass;
#define _customiser_unref0(var) ((var == NULL) ? NULL : (var = (customiser_unref (var), NULL)))
typedef struct _ParamSpecDesigner ParamSpecDesigner;

struct _Designer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DesignerPrivate * priv;
	DesignerWindow* window;
	CustomComponentDef* customComponentDef;
	gint myID;
	ComponentDef* insertComponentDef;
	ComponentDef* lastInsertCustomComponentDef;
	ComponentDef* lastInsertPluginComponentDef;
	ComponentInst* shadowComponentInst;
};

struct _DesignerClass {
	GTypeClass parent_class;
	void (*finalize) (Designer *self);
};

struct _DesignerPrivate {
	Project* project;
	gboolean _hasComponent;
	gboolean _hasInsert;
	gchar* _designerName;
	Path* currentPath;
	gboolean hasPath;
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _CustomComponentDef {
	ComponentDef parent_instance;
	CustomComponentDefPrivate * priv;
	ComponentInst** componentInsts;
	gint componentInsts_length1;
	WireInst** wireInsts;
	gint wireInsts_length1;
	Annotation** annotations;
	gint annotations_length1;
	ComponentDef** immediateDependencies;
	gint immediateDependencies_length1;
};

struct _CustomComponentDefClass {
	ComponentDefClass parent_class;
};

struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

struct _WireInstMarker {
	gint x;
	gint y;
	gboolean display;
};

struct _WireInstRegisteredComponent {
	ComponentInst* componentInst;
	WireInstMarker marker;
};

typedef enum  {
	WIRE_INST_PRESET_SIGNAL_DEFAULT,
	WIRE_INST_PRESET_SIGNAL_FALSE,
	WIRE_INST_PRESET_SIGNAL_TRUE
} WireInstPresetSignal;

struct _WireInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireInstPrivate * priv;
	WireInstRegisteredComponent* registeredComponents;
	gint registeredComponents_length1;
	gint myID;
	gboolean selected;
	WireInstMarker* markers;
	gint markers_length1;
	Path** paths;
	gint paths_length1;
	Tag* interfaceTag;
	WireInstPresetSignal presetSignal;
};

struct _WireInstClass {
	GTypeClass parent_class;
	void (*finalize) (WireInst *self);
};

struct _Tag {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagPrivate * priv;
	gchar* text;
	gint xTag;
	gint yTag;
	gint xWire;
	gint yWire;
	gint pinid;
	Flow flow;
	Direction direction;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
};

struct _TagClass {
	GTypeClass parent_class;
	void (*finalize) (Tag *self);
};

struct _PathLine {
	gint x1;
	gint y1;
	gint x2;
	gint y2;
	Direction dir;
};

struct _Path {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PathPrivate * priv;
	PathLine* lines;
	gint lines_length1;
	gint last;
	gint xLast;
	gint yLast;
	gint xLineStart;
	gint yLineStart;
	Direction dirLast;
};

struct _PathClass {
	GTypeClass parent_class;
	void (*finalize) (Path *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};

typedef enum  {
	PIN_DEF_LABEL_TYPE_NONE,
	PIN_DEF_LABEL_TYPE_TEXT,
	PIN_DEF_LABEL_TYPE_TEXTBAR,
	PIN_DEF_LABEL_TYPE_CLOCK
} PinDefLabelType;

struct _PinDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinDefPrivate * priv;
	gint x;
	gint y;
	gint xLabel;
	gint yLabel;
	gint xConnect;
	gint yConnect;
	Direction direction;
	gint length;
	gboolean array;
	Flow flow;
	gint defaultArraySize;
	gint idealSpace;
	gfloat minSpace;
	gchar* label;
	gboolean required;
	gboolean userArrayResize;
	gboolean showDefault;
	PinDefLabelType labelType;
};

struct _PinDefClass {
	GTypeClass parent_class;
	void (*finalize) (PinDef *self);
};

struct _ParamSpecDesigner {
	GParamSpec parent_instance;
};


static gpointer designer_parent_class = NULL;

gpointer designer_ref (gpointer instance);
void designer_unref (gpointer instance);
GParamSpec* param_spec_designer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_designer (GValue* value, gpointer v_object);
void value_take_designer (GValue* value, gpointer v_object);
gpointer value_get_designer (const GValue* value);
GType designer_get_type (void) G_GNUC_CONST;
GType designer_window_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer path_ref (gpointer instance);
void path_unref (gpointer instance);
GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_path (GValue* value, gpointer v_object);
void value_take_path (GValue* value, gpointer v_object);
gpointer value_get_path (const GValue* value);
GType path_get_type (void) G_GNUC_CONST;
#define DESIGNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DESIGNER, DesignerPrivate))
enum  {
	DESIGNER_DUMMY_PROPERTY
};
Designer* designer_new (DesignerWindow* viewerWindow, Project* parentProject);
Designer* designer_construct (GType object_type, DesignerWindow* viewerWindow, Project* parentProject);
void designer_set_name (Designer* self, const gchar* newName);
static void designer_set_designerName (Designer* self, const gchar* value);
void designer_set_component (Designer* self, CustomComponentDef* customComponentDef);
static void designer_set_hasComponent (Designer* self, gboolean value);
void designer_window_update_title (DesignerWindow* self);
void designer_set_insert_component (Designer* self, ComponentDef* insertComponentDef);
GType plugin_component_def_get_type (void) G_GNUC_CONST;
static void designer_set_hasInsert (Designer* self, gboolean value);
GType direction_get_type (void) G_GNUC_CONST;
ComponentInst* component_inst_new (ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped);
ComponentInst* component_inst_construct (GType object_type, ComponentDef* componentDef, gint xPosition, gint yPosition, Direction direction, gboolean flipped);
gboolean designer_set_insert_last_custom (Designer* self);
gboolean designer_set_insert_last_plugin (Designer* self);
void designer_add_componentInst (Designer* self, gint x, gint y, Direction direction, gboolean autoBind);
static gboolean designer_get_hasInsert (Designer* self);
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
gpointer annotation_ref (gpointer instance);
void annotation_unref (gpointer instance);
GParamSpec* param_spec_annotation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_annotation (GValue* value, gpointer v_object);
void value_take_annotation (GValue* value, gpointer v_object);
gpointer value_get_annotation (const GValue* value);
GType annotation_get_type (void) G_GNUC_CONST;
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
ComponentInst* custom_component_def_add_componentInst (CustomComponentDef* self, ComponentDef* componentDef, gint x, gint y, Direction direction);
void designer_auto_connect_component (Designer* self, ComponentInst* componentInst);
void designer_add_annotation (Designer* self, gint x, gint y, const gchar* text, gdouble fontSize);
void custom_component_def_add_annotation (CustomComponentDef* self, gint x, gint y, const gchar* text, gdouble fontSize);
void designer_draw_wire (Designer* self, gint x, gint y, gfloat diagonalThreshold, gboolean autoBind);
gint path_append (Path* self, gint x, gint y, gfloat diagonalThreshold);
WireInst* custom_component_def_add_wire (CustomComponentDef* self);
void wire_inst_import_path (WireInst* self, Path* path);
void designer_auto_connect_path (Designer* self, Path* path);
Path* path_new (gint xStart, gint yStart);
Path* path_construct (GType object_type, gint xStart, gint yStart);
void designer_forget_wire (Designer* self);
gint designer_bind_wire (Designer* self, gint x, gint y);
WireInst* wire_inst_new (void);
WireInst* wire_inst_construct (GType object_type);
Path* wire_inst_find (WireInst* self, gint x, gint y);
void wire_inst_merge (WireInst* self, WireInst* sourceWireInst);
static void _vala_array_add51 (WireInst*** array, int* length, int* size, WireInst* value);
gint wire_inst_count_find (WireInst* self, gint x, gint y);
void wire_inst_mark (WireInst* self, gint x, gint y);
static void _vala_array_add52 (WireInst*** array, int* length, int* size, WireInst* value);
static WireInst** _vala_array_dup43 (WireInst** self, int length);
gint designer_unbind_wire (Designer* self, gint x, gint y);
WireInst** wire_inst_unmerge (WireInst* self, gint x, gint y, int* result_length1);
static void _vala_array_add53 (WireInst*** array, int* length, int* size, WireInst* value);
static void _vala_array_add54 (WireInst*** array, int* length, int* size, WireInst* value);
static WireInst** _vala_array_dup44 (WireInst** self, int length);
void designer_tag_wire (Designer* self, gint x1, gint y1, gint x2, gint y2, gboolean oldDirection);
gint custom_component_def_new_tag_id (CustomComponentDef* self);
GType flow_get_type (void) G_GNUC_CONST;
gpointer tag_ref (gpointer instance);
void tag_unref (gpointer instance);
GParamSpec* param_spec_tag (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag (GValue* value, gpointer v_object);
void value_take_tag (GValue* value, gpointer v_object);
gpointer value_get_tag (const GValue* value);
GType tag_get_type (void) G_GNUC_CONST;
GType wire_inst_registered_component_get_type (void) G_GNUC_CONST;
GType wire_inst_marker_get_type (void) G_GNUC_CONST;
WireInstMarker* wire_inst_marker_dup (const WireInstMarker* self);
void wire_inst_marker_free (WireInstMarker* self);
WireInstRegisteredComponent* wire_inst_registered_component_dup (const WireInstRegisteredComponent* self);
void wire_inst_registered_component_free (WireInstRegisteredComponent* self);
GType wire_inst_preset_signal_get_type (void) G_GNUC_CONST;
Tag* wire_inst_set_tag (WireInst* self, gint x1, gint y1, gint x2, gint y2);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
PropertyItemString* property_item_string_new (const gchar* name, const gchar* description, const gchar* data);
PropertyItemString* property_item_string_construct (GType object_type, const gchar* name, const gchar* description, const gchar* data);
GType property_item_string_get_type (void) G_GNUC_CONST;
GType property_item_selection_get_type (void) G_GNUC_CONST;
PropertyItemSelection* property_item_selection_new (const gchar* name, const gchar* description);
PropertyItemSelection* property_item_selection_construct (GType object_type, const gchar* name, const gchar* description);
void property_item_selection_add_option (PropertyItemSelection* self, const gchar* value, const gchar* text);
gint property_item_selection_set_option (PropertyItemSelection* self, const gchar* value);
PropertyItemInt* property_item_int_new (const gchar* name, const gchar* description, gint data, gint min, gint max);
PropertyItemInt* property_item_int_construct (GType object_type, const gchar* name, const gchar* description, gint data, gint min, gint max);
GType property_item_int_get_type (void) G_GNUC_CONST;
gpointer properties_query_ref (gpointer instance);
void properties_query_unref (gpointer instance);
GParamSpec* param_spec_properties_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_properties_query (GValue* value, gpointer v_object);
void value_take_properties_query (GValue* value, gpointer v_object);
gpointer value_get_properties_query (const GValue* value);
GType properties_query_get_type (void) G_GNUC_CONST;
PropertiesQuery* properties_query_new (const gchar* title, GtkWindow* parent, PropertySet* propertySet);
PropertiesQuery* properties_query_construct (GType object_type, const gchar* title, GtkWindow* parent, PropertySet* propertySet);
gint properties_query_run (PropertiesQuery* self);
gchar* property_item_string_get_data (PropertySet* propertySet, const gchar* name);
gint property_item_int_get_data (PropertySet* propertySet, const gchar* name);
gchar* property_item_selection_get_data (PropertySet* propertySet, const gchar* name);
void designer_auto_connect_wire (Designer* self, WireInst* wireInst);
GType path_line_get_type (void) G_GNUC_CONST;
PathLine* path_line_dup (const PathLine* self);
void path_line_free (PathLine* self);
gint designer_connect_component (Designer* self, gint x, gint y);
void component_inst_absolute_position (ComponentInst* self, gint xRelative, gint yRelative, gint* xRaw, gint* yRaw);
gboolean pin_inst_try_connect (PinInst* self, gint x, gint y, WireInst* wireInst, ComponentInst* componentInst);
gboolean component_inst_try_connect (ComponentInst* self, gint x, gint y, WireInst* wireInst);
gint designer_disconnect_component (Designer* self, gint x, gint y);
gboolean component_inst_try_disconnect (ComponentInst* self, gint x, gint y);
void designer_invert_pin (Designer* self, gint x, gint y);
void component_inst_try_invert (ComponentInst* self, gint x, gint y);
gint designer_snap_pin (Designer* self, gint* x, gint* y, gint range);
void designer_adjust_components (Designer* self, gint x, gint y, gboolean autoBind);
gint component_inst_find (ComponentInst* self, gint x, gint y);
GType pin_def_label_type_get_type (void) G_GNUC_CONST;
void component_def_add_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
gboolean pin_inst_disconnect (PinInst* self, ComponentInst* componentInst);
PinInst* pin_inst_new (PinDef* pinDef, gint arraySize);
PinInst* pin_inst_construct (GType object_type, PinDef* pinDef, gint arraySize);
void component_def_get_properties (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
void component_def_configure_inst (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
void designer_adjust_annotations (Designer* self, gint x, gint y);
gint annotation_find (Annotation* self, gint x, gint y);
const gchar* annotation_get_text (Annotation* self);
gdouble annotation_get_fontSize (Annotation* self);
PropertyItemDouble* property_item_double_new (const gchar* name, const gchar* description, gdouble data, gdouble min, gdouble max);
PropertyItemDouble* property_item_double_construct (GType object_type, const gchar* name, const gchar* description, gdouble data, gdouble min, gdouble max);
GType property_item_double_get_type (void) G_GNUC_CONST;
gdouble property_item_double_get_data (PropertySet* propertySet, const gchar* name);
void annotation_set_text (Annotation* self, const gchar* value);
void annotation_set_fontSize (Annotation* self, gdouble value);
void designer_adjust_wires (Designer* self, gint x, gint y);
gchar* property_item_selection_get_option (PropertyItemSelection* self);
gint wire_inst_find_tag (WireInst* self, gint x, gint y);
void designer_select_components (Designer* self, gint x, gint y, gboolean toggle);
void component_inst_try_select (ComponentInst* self, gint x, gint y, gboolean toggle);
void designer_select_wires (Designer* self, gint x, gint y, gboolean toggle, gboolean includeTag);
void wire_inst_try_select (WireInst* self, gint x, gint y, gboolean toggle, gboolean includeTag);
void designer_select_annotations (Designer* self, gint x, gint y, gboolean toggle);
void annotation_try_select (Annotation* self, gint x, gint y, gboolean toggle);
void designer_move_components (Designer* self, gint x, gint y, gboolean ignoreSelect, gboolean autoBind);
void component_inst_move (ComponentInst* self, gint x, gint y, gboolean ignoreSelect);
void designer_move_wires (Designer* self, gint x, gint y, gboolean ignoreSelect, gboolean autoBind);
void wire_inst_move (WireInst* self, gint x, gint y, gboolean ignoreSelect);
void designer_move_annotations (Designer* self, gint x, gint y, gboolean ignoreSelect);
void annotation_move (Annotation* self, gint x, gint y, gboolean ignoreSelect);
void designer_flip_component (Designer* self, gboolean autoBind);
void component_inst_flip (ComponentInst* self, gboolean ignoreSelect);
void designer_orientate_component (Designer* self, Direction direction, gboolean autoBind);
void component_inst_orientate (ComponentInst* self, Direction direction, gboolean ignoreSelect);
void designer_delete_components (Designer* self, gint x, gint y);
void custom_component_def_delete_selected_components (CustomComponentDef* self);
void designer_delete_wires (Designer* self, gint x, gint y);
void custom_component_def_delete_selected_wires (CustomComponentDef* self);
gint path_find (Path* self, gint x, gint y);
void designer_delete_tags (Designer* self, gint x, gint y);
void designer_delete_annotations (Designer* self, gint x, gint y);
void custom_component_def_delete_selected_annotations (CustomComponentDef* self);
gint designer_save_component (Designer* self, const gchar* filename);
CustomComponentDef** custom_component_def_validate_dependencies (CustomComponentDef* self, CustomComponentDef** componentChain, int componentChain_length1, int* result_length1);
gint custom_component_def_save (CustomComponentDef* self, const gchar* fileName);
void designer_customise_component (Designer* self);
gpointer customiser_ref (gpointer instance);
void customiser_unref (gpointer instance);
GParamSpec* param_spec_customiser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_customiser (GValue* value, gpointer v_object);
void value_take_customiser (GValue* value, gpointer v_object);
gpointer value_get_customiser (const GValue* value);
GType customiser_get_type (void) G_GNUC_CONST;
Customiser* customiser_new (DesignerWindow* parent, CustomComponentDef* customComponentDef, Project* project);
Customiser* customiser_construct (GType object_type, DesignerWindow* parent, CustomComponentDef* customComponentDef, Project* project);
void customiser_run (Customiser* self);
void project_update_custom_menus (Project* self);
void designer_render (Designer* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
gboolean designer_get_hasComponent (Designer* self);
void custom_component_def_render_insts (CustomComponentDef* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
void path_render (Path* self, cairo_t* context);
const gchar* designer_get_designerName (Designer* self);
static void designer_finalize (Designer* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Create a Designer with the specified front-end DesignerWindow and
 * project.
 */
Designer* designer_construct (GType object_type, DesignerWindow* viewerWindow, Project* parentProject) {
	Designer* self = NULL;
	DesignerWindow* _tmp0_ = NULL;
	Project* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	g_return_val_if_fail (viewerWindow != NULL, NULL);
	g_return_val_if_fail (parentProject != NULL, NULL);
	self = (Designer*) g_type_create_instance (object_type);
	_tmp0_ = viewerWindow;
	self->window = _tmp0_;
	_tmp1_ = parentProject;
	self->priv->project = _tmp1_;
	_tmp2_ = stdout;
	fprintf (_tmp2_, "New Designer Created\n");
	return self;
}


Designer* designer_new (DesignerWindow* viewerWindow, Project* parentProject) {
	return designer_construct (TYPE_DESIGNER, viewerWindow, parentProject);
}


/**
 * Sets the name of the designer.
 */
void designer_set_name (Designer* self, const gchar* newName) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (newName != NULL);
	_tmp0_ = newName;
	designer_set_designerName (self, _tmp0_);
}


/**
 * Sets the component to design.
 */
void designer_set_component (Designer* self, CustomComponentDef* customComponentDef) {
	CustomComponentDef* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	DesignerWindow* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = customComponentDef;
	self->customComponentDef = _tmp0_;
	_tmp1_ = customComponentDef;
	if (_tmp1_ != NULL) {
		designer_set_hasComponent (self, TRUE);
	}
	_tmp2_ = self->window;
	designer_window_update_title (_tmp2_);
}


/**
 * Sets the component for insertion.
 */
void designer_set_insert_component (Designer* self, ComponentDef* insertComponentDef) {
	ComponentDef* _tmp0_ = NULL;
	ComponentDef* _tmp1_ = NULL;
	ComponentDef* _tmp5_ = NULL;
	ComponentInst* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (insertComponentDef != NULL);
	_tmp0_ = insertComponentDef;
	self->insertComponentDef = _tmp0_;
	_tmp1_ = insertComponentDef;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_CUSTOM_COMPONENT_DEF)) {
		ComponentDef* _tmp2_ = NULL;
		_tmp2_ = insertComponentDef;
		self->lastInsertCustomComponentDef = _tmp2_;
	} else {
		ComponentDef* _tmp3_ = NULL;
		_tmp3_ = insertComponentDef;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_PLUGIN_COMPONENT_DEF)) {
			ComponentDef* _tmp4_ = NULL;
			_tmp4_ = insertComponentDef;
			self->lastInsertPluginComponentDef = _tmp4_;
		}
	}
	designer_set_hasInsert (self, TRUE);
	_tmp5_ = insertComponentDef;
	_tmp6_ = component_inst_new (_tmp5_, 0, 0, DIRECTION_RIGHT, FALSE);
	_component_inst_unref0 (self->shadowComponentInst);
	self->shadowComponentInst = _tmp6_;
}


/**
 * Sets the component for insertion as the last custom component
 * which was selected for insertion.
 */
gboolean designer_set_insert_last_custom (Designer* self) {
	gboolean result = FALSE;
	ComponentDef* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->lastInsertCustomComponentDef;
	if (_tmp0_ != NULL) {
		ComponentDef* _tmp1_ = NULL;
		_tmp1_ = self->lastInsertCustomComponentDef;
		designer_set_insert_component (self, _tmp1_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
 * Sets the component for insertion as the last plugin component
 * which was selected for insertion.
 */
gboolean designer_set_insert_last_plugin (Designer* self) {
	gboolean result = FALSE;
	ComponentDef* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->lastInsertPluginComponentDef;
	if (_tmp0_ != NULL) {
		ComponentDef* _tmp1_ = NULL;
		_tmp1_ = self->lastInsertPluginComponentDef;
		designer_set_insert_component (self, _tmp1_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
 * Add a subcomponent to the design.
 */
static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


void designer_add_componentInst (Designer* self, gint x, gint y, Direction direction, gboolean autoBind) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = designer_get_hasInsert (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		CustomComponentDef* _tmp2_ = NULL;
		ComponentInst** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ComponentInst* componentInst = NULL;
		CustomComponentDef* _tmp12_ = NULL;
		ComponentDef* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		Direction _tmp16_ = 0;
		ComponentInst* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp2_ = self->customComponentDef;
		_tmp3_ = _tmp2_->componentInsts;
		_tmp3__length1 = _tmp2_->componentInsts_length1;
		{
			ComponentInst** componentInst_collection = NULL;
			gint componentInst_collection_length1 = 0;
			gint _componentInst_collection_size_ = 0;
			gint componentInst_it = 0;
			componentInst_collection = _tmp3_;
			componentInst_collection_length1 = _tmp3__length1;
			for (componentInst_it = 0; componentInst_it < _tmp3__length1; componentInst_it = componentInst_it + 1) {
				ComponentInst* _tmp4_ = NULL;
				ComponentInst* componentInst = NULL;
				_tmp4_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
				componentInst = _tmp4_;
				{
					gboolean _tmp5_ = FALSE;
					ComponentInst* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					_tmp6_ = componentInst;
					_tmp7_ = _tmp6_->xPosition;
					_tmp8_ = x;
					if (_tmp7_ == _tmp8_) {
						ComponentInst* _tmp9_ = NULL;
						gint _tmp10_ = 0;
						gint _tmp11_ = 0;
						_tmp9_ = componentInst;
						_tmp10_ = _tmp9_->yPosition;
						_tmp11_ = y;
						_tmp5_ = _tmp10_ == _tmp11_;
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						_component_inst_unref0 (componentInst);
						return;
					}
					_component_inst_unref0 (componentInst);
				}
			}
		}
		_tmp12_ = self->customComponentDef;
		_tmp13_ = self->insertComponentDef;
		_tmp14_ = x;
		_tmp15_ = y;
		_tmp16_ = direction;
		_tmp17_ = custom_component_def_add_componentInst (_tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
		componentInst = _tmp17_;
		_tmp18_ = autoBind;
		if (_tmp18_) {
			ComponentInst* _tmp19_ = NULL;
			_tmp19_ = componentInst;
			designer_auto_connect_component (self, _tmp19_);
		}
		_component_inst_unref0 (componentInst);
	}
}


/**
 * Add an annotation to the design.
 */
void designer_add_annotation (Designer* self, gint x, gint y, const gchar* text, gdouble fontSize) {
	CustomComponentDef* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = text;
	_tmp4_ = fontSize;
	custom_component_def_add_annotation (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
}


/**
 * Used to draw a wire. If there is no path being drawn, start one
 * at (//x//, //y//). If there is a path, add a point at
 * (//x//, //y//). Finishes and adds a wire when the last point is
 * already at (//x//, //y//).
 */
void designer_draw_wire (Designer* self, gint x, gint y, gfloat diagonalThreshold, gboolean autoBind) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hasPath;
	if (_tmp0_) {
		Path* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gfloat _tmp4_ = 0.0F;
		gint _tmp5_ = 0;
		_tmp1_ = self->priv->currentPath;
		_tmp2_ = x;
		_tmp3_ = y;
		_tmp4_ = diagonalThreshold;
		_tmp5_ = path_append (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
		switch (_tmp5_) {
			case 1:
			{
				WireInst* wireInst = NULL;
				CustomComponentDef* _tmp6_ = NULL;
				WireInst* _tmp7_ = NULL;
				WireInst* _tmp8_ = NULL;
				Path* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp6_ = self->customComponentDef;
				_tmp7_ = custom_component_def_add_wire (_tmp6_);
				wireInst = _tmp7_;
				_tmp8_ = wireInst;
				_tmp9_ = self->priv->currentPath;
				wire_inst_import_path (_tmp8_, _tmp9_);
				_tmp10_ = autoBind;
				if (_tmp10_) {
					Path* _tmp11_ = NULL;
					_tmp11_ = self->priv->currentPath;
					designer_auto_connect_path (self, _tmp11_);
				}
				self->priv->hasPath = FALSE;
				_wire_inst_unref0 (wireInst);
				break;
			}
			case 2:
			{
				self->priv->hasPath = FALSE;
				break;
			}
			default:
			break;
		}
	} else {
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		Path* _tmp14_ = NULL;
		self->priv->hasPath = TRUE;
		_tmp12_ = x;
		_tmp13_ = y;
		_tmp14_ = path_new (_tmp12_, _tmp13_);
		_path_unref0 (self->priv->currentPath);
		self->priv->currentPath = _tmp14_;
	}
}


void designer_forget_wire (Designer* self) {
	g_return_if_fail (self != NULL);
	self->priv->hasPath = FALSE;
}


/**
 * Combines two wires together to form one complex wire. Combines
 * any wires passing through (//x//, //y//).
 */
static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


static void _vala_array_add51 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add52 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireInst** _vala_array_dup43 (WireInst** self, int length) {
	WireInst** result;
	int i;
	result = g_new0 (WireInst*, length + 1);
	for (i = 0; i < length; i++) {
		WireInst* _tmp0_ = NULL;
		_tmp0_ = _wire_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint designer_bind_wire (Designer* self, gint x, gint y) {
	gint result = 0;
	WireInst** wireInsts = NULL;
	WireInst** _tmp0_ = NULL;
	gint wireInsts_length1 = 0;
	gint _wireInsts_size_ = 0;
	WireInst* compositeWireInst = NULL;
	WireInst* _tmp1_ = NULL;
	gboolean addComposite = FALSE;
	gint wiresAdded = 0;
	CustomComponentDef* _tmp2_ = NULL;
	WireInst** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	WireInst* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean _tmp24_ = FALSE;
	CustomComponentDef* _tmp28_ = NULL;
	WireInst** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	WireInst** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_new0 (WireInst*, 0 + 1);
	wireInsts = _tmp0_;
	wireInsts_length1 = 0;
	_wireInsts_size_ = wireInsts_length1;
	_tmp1_ = wire_inst_new ();
	compositeWireInst = _tmp1_;
	addComposite = FALSE;
	wiresAdded = 0;
	_tmp2_ = self->customComponentDef;
	_tmp3_ = _tmp2_->wireInsts;
	_tmp3__length1 = _tmp2_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp3_;
		wireInst_collection_length1 = _tmp3__length1;
		for (wireInst_it = 0; wireInst_it < _tmp3__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp4_ = NULL;
			WireInst* wireInst = NULL;
			_tmp4_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp4_;
			{
				WireInst* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				Path* _tmp8_ = NULL;
				Path* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp5_ = wireInst;
				_tmp6_ = x;
				_tmp7_ = y;
				_tmp8_ = wire_inst_find (_tmp5_, _tmp6_, _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_ != NULL;
				_path_unref0 (_tmp9_);
				if (_tmp10_) {
					gint _tmp11_ = 0;
					WireInst* _tmp12_ = NULL;
					WireInst* _tmp13_ = NULL;
					addComposite = TRUE;
					_tmp11_ = wiresAdded;
					wiresAdded = _tmp11_ + 1;
					_tmp12_ = compositeWireInst;
					_tmp13_ = wireInst;
					wire_inst_merge (_tmp12_, _tmp13_);
				} else {
					WireInst** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					WireInst* _tmp15_ = NULL;
					WireInst* _tmp16_ = NULL;
					_tmp14_ = wireInsts;
					_tmp14__length1 = wireInsts_length1;
					_tmp15_ = wireInst;
					_tmp16_ = _wire_inst_ref0 (_tmp15_);
					_vala_array_add51 (&wireInsts, &wireInsts_length1, &_wireInsts_size_, _tmp16_);
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	_tmp17_ = compositeWireInst;
	_tmp18_ = x;
	_tmp19_ = y;
	_tmp20_ = wire_inst_count_find (_tmp17_, _tmp18_, _tmp19_);
	if (_tmp20_ > 1) {
		WireInst* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp21_ = compositeWireInst;
		_tmp22_ = x;
		_tmp23_ = y;
		wire_inst_mark (_tmp21_, _tmp22_, _tmp23_);
	}
	_tmp24_ = addComposite;
	if (_tmp24_) {
		WireInst** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		WireInst* _tmp26_ = NULL;
		WireInst* _tmp27_ = NULL;
		_tmp25_ = wireInsts;
		_tmp25__length1 = wireInsts_length1;
		_tmp26_ = compositeWireInst;
		_tmp27_ = _wire_inst_ref0 (_tmp26_);
		_vala_array_add52 (&wireInsts, &wireInsts_length1, &_wireInsts_size_, _tmp27_);
	}
	_tmp28_ = self->customComponentDef;
	_tmp29_ = wireInsts;
	_tmp29__length1 = wireInsts_length1;
	_tmp30_ = (_tmp29_ != NULL) ? _vala_array_dup43 (_tmp29_, _tmp29__length1) : ((gpointer) _tmp29_);
	_tmp30__length1 = _tmp29__length1;
	_tmp28_->wireInsts = (_vala_array_free (_tmp28_->wireInsts, _tmp28_->wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	_tmp28_->wireInsts = _tmp30_;
	_tmp28_->wireInsts_length1 = _tmp30__length1;
	result = wiresAdded;
	_wire_inst_unref0 (compositeWireInst);
	wireInsts = (_vala_array_free (wireInsts, wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	return result;
}


/**
 * Splits a complex wire into two or more simpler wires at point
 * (//x//, //y//). This only seperates wires that were joined with
 * //bind_wire// - it does not break up paths.
 */
static void _vala_array_add53 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add54 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireInst** _vala_array_dup44 (WireInst** self, int length) {
	WireInst** result;
	int i;
	result = g_new0 (WireInst*, length + 1);
	for (i = 0; i < length; i++) {
		WireInst* _tmp0_ = NULL;
		_tmp0_ = _wire_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint designer_unbind_wire (Designer* self, gint x, gint y) {
	gint result = 0;
	WireInst** wireInsts = NULL;
	WireInst** _tmp0_ = NULL;
	gint wireInsts_length1 = 0;
	gint _wireInsts_size_ = 0;
	gint wiresUnbound = 0;
	CustomComponentDef* _tmp1_ = NULL;
	WireInst** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	CustomComponentDef* _tmp23_ = NULL;
	WireInst** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	WireInst** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_new0 (WireInst*, 0 + 1);
	wireInsts = _tmp0_;
	wireInsts_length1 = 0;
	_wireInsts_size_ = wireInsts_length1;
	wiresUnbound = 0;
	_tmp1_ = self->customComponentDef;
	_tmp2_ = _tmp1_->wireInsts;
	_tmp2__length1 = _tmp1_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp2_;
		wireInst_collection_length1 = _tmp2__length1;
		for (wireInst_it = 0; wireInst_it < _tmp2__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp3_ = NULL;
			WireInst* wireInst = NULL;
			_tmp3_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp3_;
			{
				WireInst* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Path* _tmp7_ = NULL;
				Path* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp4_ = wireInst;
				_tmp5_ = x;
				_tmp6_ = y;
				_tmp7_ = wire_inst_find (_tmp4_, _tmp5_, _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_ != NULL;
				_path_unref0 (_tmp8_);
				if (_tmp9_) {
					WireInst** addWireInsts = NULL;
					gint addWireInsts_length1 = 0;
					gint _addWireInsts_size_ = 0;
					WireInst* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					WireInst** _tmp14_ = NULL;
					WireInst** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp10_ = wireInst;
					_tmp11_ = x;
					_tmp12_ = y;
					_tmp14_ = wire_inst_unmerge (_tmp10_, _tmp11_, _tmp12_, &_tmp13_);
					addWireInsts = (_vala_array_free (addWireInsts, addWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
					addWireInsts = _tmp14_;
					addWireInsts_length1 = _tmp13_;
					_addWireInsts_size_ = addWireInsts_length1;
					_tmp15_ = addWireInsts;
					_tmp15__length1 = addWireInsts_length1;
					{
						WireInst** addWireInst_collection = NULL;
						gint addWireInst_collection_length1 = 0;
						gint _addWireInst_collection_size_ = 0;
						gint addWireInst_it = 0;
						addWireInst_collection = _tmp15_;
						addWireInst_collection_length1 = _tmp15__length1;
						for (addWireInst_it = 0; addWireInst_it < _tmp15__length1; addWireInst_it = addWireInst_it + 1) {
							WireInst* _tmp16_ = NULL;
							WireInst* addWireInst = NULL;
							_tmp16_ = _wire_inst_ref0 (addWireInst_collection[addWireInst_it]);
							addWireInst = _tmp16_;
							{
								WireInst** _tmp17_ = NULL;
								gint _tmp17__length1 = 0;
								WireInst* _tmp18_ = NULL;
								WireInst* _tmp19_ = NULL;
								_tmp17_ = wireInsts;
								_tmp17__length1 = wireInsts_length1;
								_tmp18_ = addWireInst;
								_tmp19_ = _wire_inst_ref0 (_tmp18_);
								_vala_array_add53 (&wireInsts, &wireInsts_length1, &_wireInsts_size_, _tmp19_);
								_wire_inst_unref0 (addWireInst);
							}
						}
					}
					addWireInsts = (_vala_array_free (addWireInsts, addWireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
				} else {
					WireInst** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					WireInst* _tmp21_ = NULL;
					WireInst* _tmp22_ = NULL;
					_tmp20_ = wireInsts;
					_tmp20__length1 = wireInsts_length1;
					_tmp21_ = wireInst;
					_tmp22_ = _wire_inst_ref0 (_tmp21_);
					_vala_array_add54 (&wireInsts, &wireInsts_length1, &_wireInsts_size_, _tmp22_);
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	_tmp23_ = self->customComponentDef;
	_tmp24_ = wireInsts;
	_tmp24__length1 = wireInsts_length1;
	_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup44 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
	_tmp25__length1 = _tmp24__length1;
	_tmp23_->wireInsts = (_vala_array_free (_tmp23_->wireInsts, _tmp23_->wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	_tmp23_->wireInsts = _tmp25_;
	_tmp23_->wireInsts_length1 = _tmp25__length1;
	result = wiresUnbound;
	wireInsts = (_vala_array_free (wireInsts, wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	return result;
}


/**
 * Creates an interface tag going from (//x1//, //y1//) to
 * (//x2//, //y2//) and prompts the user to configure it.
 * If both points are the same, it will remove a tag.
 */
static gpointer _tag_ref0 (gpointer self) {
	return self ? tag_ref (self) : NULL;
}


void designer_tag_wire (Designer* self, gint x1, gint y1, gint x2, gint y2, gboolean oldDirection) {
	CustomComponentDef* _tmp0_ = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->wireInsts;
	_tmp1__length1 = _tmp0_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				gchar* text = NULL;
				gchar* _tmp3_ = NULL;
				gint pinid = 0;
				CustomComponentDef* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				Flow flow = 0;
				Tag* oldTag = NULL;
				WireInst* _tmp6_ = NULL;
				Tag* _tmp7_ = NULL;
				Tag* _tmp8_ = NULL;
				Tag* _tmp9_ = NULL;
				Tag* tag = NULL;
				WireInst* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				Tag* _tmp22_ = NULL;
				Tag* _tmp23_ = NULL;
				_tmp3_ = g_strdup ("Tag");
				text = _tmp3_;
				_tmp4_ = self->customComponentDef;
				_tmp5_ = custom_component_def_new_tag_id (_tmp4_);
				pinid = _tmp5_;
				flow = FLOW_NONE;
				_tmp6_ = wireInst;
				_tmp7_ = _tmp6_->interfaceTag;
				_tmp8_ = _tag_ref0 (_tmp7_);
				oldTag = _tmp8_;
				_tmp9_ = oldTag;
				if (_tmp9_ != NULL) {
					Tag* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					Tag* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					Tag* _tmp15_ = NULL;
					Flow _tmp16_ = 0;
					_tmp10_ = oldTag;
					_tmp11_ = _tmp10_->text;
					_tmp12_ = g_strdup (_tmp11_);
					_g_free0 (text);
					text = _tmp12_;
					_tmp13_ = oldTag;
					_tmp14_ = _tmp13_->pinid;
					pinid = _tmp14_;
					_tmp15_ = oldTag;
					_tmp16_ = _tmp15_->flow;
					flow = _tmp16_;
				}
				_tmp17_ = wireInst;
				_tmp18_ = x1;
				_tmp19_ = y1;
				_tmp20_ = x2;
				_tmp21_ = y2;
				_tmp22_ = wire_inst_set_tag (_tmp17_, _tmp18_, _tmp19_, _tmp20_, _tmp21_);
				tag = _tmp22_;
				_tmp23_ = tag;
				if (_tmp23_ != NULL) {
					Tag* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					Tag* _tmp27_ = NULL;
					Tag* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					PropertySet* tagProperties = NULL;
					PropertySet* _tmp36_ = NULL;
					PropertySet* _tmp37_ = NULL;
					Tag* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					PropertyItemString* _tmp40_ = NULL;
					PropertyItemString* _tmp41_ = NULL;
					PropertySet* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					PropertyItemInt* _tmp56_ = NULL;
					PropertyItemInt* _tmp57_ = NULL;
					gboolean notValid = FALSE;
					_tmp24_ = tag;
					_tmp25_ = text;
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (_tmp24_->text);
					_tmp24_->text = _tmp26_;
					_tmp27_ = tag;
					_tmp28_ = tag;
					_tmp29_ = _tmp28_->pinid;
					_tmp27_->pinid = _tmp29_;
					_tmp31_ = oldDirection;
					if (_tmp31_) {
						Tag* _tmp32_ = NULL;
						_tmp32_ = oldTag;
						_tmp30_ = _tmp32_ != NULL;
					} else {
						_tmp30_ = FALSE;
					}
					if (_tmp30_) {
						Tag* _tmp33_ = NULL;
						Tag* _tmp34_ = NULL;
						Flow _tmp35_ = 0;
						_tmp33_ = tag;
						_tmp34_ = oldTag;
						_tmp35_ = _tmp34_->flow;
						_tmp33_->flow = _tmp35_;
					}
					_tmp36_ = property_set_new ("Interface Tag", "Interface reference and label query");
					tagProperties = _tmp36_;
					_tmp37_ = tagProperties;
					_tmp38_ = tag;
					_tmp39_ = _tmp38_->text;
					_tmp40_ = property_item_string_new ("Text", "Text to display.", _tmp39_);
					_tmp41_ = _tmp40_;
					property_set_add_item (_tmp37_, (PropertyItem*) _tmp41_);
					_property_item_unref0 (_tmp41_);
					{
						PropertyItemSelection* selection = NULL;
						PropertyItemSelection* _tmp42_ = NULL;
						PropertyItemSelection* _tmp43_ = NULL;
						PropertyItemSelection* _tmp44_ = NULL;
						PropertyItemSelection* _tmp45_ = NULL;
						Tag* _tmp46_ = NULL;
						Flow _tmp47_ = 0;
						PropertySet* _tmp51_ = NULL;
						PropertyItemSelection* _tmp52_ = NULL;
						_tmp42_ = property_item_selection_new ("Flow", "Type of pin (from this component's view).");
						selection = _tmp42_;
						_tmp43_ = selection;
						property_item_selection_add_option (_tmp43_, "Input", NULL);
						_tmp44_ = selection;
						property_item_selection_add_option (_tmp44_, "Output", NULL);
						_tmp45_ = selection;
						property_item_selection_add_option (_tmp45_, "Bidirectional", NULL);
						_tmp46_ = tag;
						_tmp47_ = _tmp46_->flow;
						switch (_tmp47_) {
							case FLOW_IN:
							{
								PropertyItemSelection* _tmp48_ = NULL;
								_tmp48_ = selection;
								property_item_selection_set_option (_tmp48_, "Input");
								break;
							}
							case FLOW_OUT:
							{
								PropertyItemSelection* _tmp49_ = NULL;
								_tmp49_ = selection;
								property_item_selection_set_option (_tmp49_, "Output");
								break;
							}
							case FLOW_BIDIRECTIONAL:
							{
								PropertyItemSelection* _tmp50_ = NULL;
								_tmp50_ = selection;
								property_item_selection_set_option (_tmp50_, "Bidirectional");
								break;
							}
							default:
							break;
						}
						_tmp51_ = tagProperties;
						_tmp52_ = selection;
						property_set_add_item (_tmp51_, (PropertyItem*) _tmp52_);
						_property_item_unref0 (selection);
					}
					_tmp53_ = tagProperties;
					_tmp54_ = pinid;
					_tmp55_ = G_MAXINT;
					_tmp56_ = property_item_int_new ("Pin ID", "ID of the pin which this tag represents a connection to. Each pin has " \
"its own unique ID.", _tmp54_, 0, _tmp55_);
					_tmp57_ = _tmp56_;
					property_set_add_item (_tmp53_, (PropertyItem*) _tmp57_);
					_property_item_unref0 (_tmp57_);
					notValid = TRUE;
					while (TRUE) {
						gboolean _tmp58_ = FALSE;
						PropertiesQuery* tagQuery = NULL;
						DesignerWindow* _tmp59_ = NULL;
						PropertySet* _tmp60_ = NULL;
						PropertiesQuery* _tmp61_ = NULL;
						PropertiesQuery* _tmp62_ = NULL;
						gint _tmp63_ = 0;
						_tmp58_ = notValid;
						if (!_tmp58_) {
							break;
						}
						notValid = FALSE;
						_tmp59_ = self->window;
						_tmp60_ = tagProperties;
						_tmp61_ = properties_query_new ("Interface Tag Properties", (GtkWindow*) _tmp59_, _tmp60_);
						tagQuery = _tmp61_;
						_tmp62_ = tagQuery;
						_tmp63_ = properties_query_run (_tmp62_);
						if (_tmp63_ == ((gint) GTK_RESPONSE_APPLY)) {
							gchar* option = NULL;
							PropertySet* _tmp64_ = NULL;
							gchar* _tmp65_ = NULL;
							PropertySet* _tmp66_ = NULL;
							gint _tmp67_ = 0;
							PropertySet* _tmp68_ = NULL;
							gchar* _tmp69_ = NULL;
							gint _tmp70_ = 0;
							const gchar* _tmp74_ = NULL;
							const gchar* _tmp75_ = NULL;
							GQuark _tmp77_ = 0U;
							static GQuark _tmp76_label0 = 0;
							static GQuark _tmp76_label1 = 0;
							static GQuark _tmp76_label2 = 0;
							Tag* _tmp81_ = NULL;
							gint _tmp82_ = 0;
							Tag* _tmp83_ = NULL;
							const gchar* _tmp84_ = NULL;
							gchar* _tmp85_ = NULL;
							_tmp64_ = tagProperties;
							_tmp65_ = property_item_string_get_data (_tmp64_, "Text");
							_g_free0 (text);
							text = _tmp65_;
							_tmp66_ = tagProperties;
							_tmp67_ = property_item_int_get_data (_tmp66_, "Pin ID");
							pinid = _tmp67_;
							_tmp68_ = tagProperties;
							_tmp69_ = property_item_selection_get_data (_tmp68_, "Flow");
							_g_free0 (option);
							option = _tmp69_;
							_tmp70_ = pinid;
							if (_tmp70_ < 0) {
								GtkMessageDialog* messageDialog = NULL;
								GtkMessageDialog* _tmp71_ = NULL;
								GtkMessageDialog* _tmp72_ = NULL;
								GtkMessageDialog* _tmp73_ = NULL;
								notValid = TRUE;
								_tmp71_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Pin ID must be greater than or equal to 0.\n");
								g_object_ref_sink (_tmp71_);
								messageDialog = _tmp71_;
								_tmp72_ = messageDialog;
								gtk_dialog_run ((GtkDialog*) _tmp72_);
								_tmp73_ = messageDialog;
								gtk_widget_destroy ((GtkWidget*) _tmp73_);
								_g_object_unref0 (messageDialog);
							}
							_tmp74_ = option;
							_tmp75_ = _tmp74_;
							_tmp77_ = (NULL == _tmp75_) ? 0 : g_quark_from_string (_tmp75_);
							if (_tmp77_ == ((0 != _tmp76_label0) ? _tmp76_label0 : (_tmp76_label0 = g_quark_from_static_string ("Input")))) {
								switch (0) {
									default:
									{
										Tag* _tmp78_ = NULL;
										_tmp78_ = tag;
										_tmp78_->flow = FLOW_IN;
										break;
									}
								}
							} else if (_tmp77_ == ((0 != _tmp76_label1) ? _tmp76_label1 : (_tmp76_label1 = g_quark_from_static_string ("Output")))) {
								switch (0) {
									default:
									{
										Tag* _tmp79_ = NULL;
										_tmp79_ = tag;
										_tmp79_->flow = FLOW_OUT;
										break;
									}
								}
							} else if (_tmp77_ == ((0 != _tmp76_label2) ? _tmp76_label2 : (_tmp76_label2 = g_quark_from_static_string ("Bidirectional")))) {
								switch (0) {
									default:
									{
										Tag* _tmp80_ = NULL;
										_tmp80_ = tag;
										_tmp80_->flow = FLOW_BIDIRECTIONAL;
										break;
									}
								}
							}
							_tmp81_ = tag;
							_tmp82_ = pinid;
							_tmp81_->pinid = _tmp82_;
							_tmp83_ = tag;
							_tmp84_ = text;
							_tmp85_ = g_strdup (_tmp84_);
							_g_free0 (_tmp83_->text);
							_tmp83_->text = _tmp85_;
							_g_free0 (option);
						} else {
							WireInst* _tmp86_ = NULL;
							Tag* _tmp87_ = NULL;
							Tag* _tmp88_ = NULL;
							_tmp86_ = wireInst;
							_tmp87_ = oldTag;
							_tmp88_ = _tag_ref0 (_tmp87_);
							_tag_unref0 (_tmp86_->interfaceTag);
							_tmp86_->interfaceTag = _tmp88_;
						}
						_properties_query_unref0 (tagQuery);
					}
					_property_item_unref0 (tagProperties);
					_tag_unref0 (tag);
					_tag_unref0 (oldTag);
					_g_free0 (text);
					_wire_inst_unref0 (wireInst);
					return;
				}
				_tag_unref0 (tag);
				_tag_unref0 (oldTag);
				_g_free0 (text);
				_wire_inst_unref0 (wireInst);
			}
		}
	}
}


static gpointer _path_ref0 (gpointer self) {
	return self ? path_ref (self) : NULL;
}


void designer_auto_connect_wire (Designer* self, WireInst* wireInst) {
	WireInst* _tmp0_ = NULL;
	Path** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wireInst != NULL);
	_tmp0_ = wireInst;
	_tmp1_ = _tmp0_->paths;
	_tmp1__length1 = _tmp0_->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp1_;
		path_collection_length1 = _tmp1__length1;
		for (path_it = 0; path_it < _tmp1__length1; path_it = path_it + 1) {
			Path* _tmp2_ = NULL;
			Path* path = NULL;
			_tmp2_ = _path_ref0 (path_collection[path_it]);
			path = _tmp2_;
			{
				Path* _tmp3_ = NULL;
				_tmp3_ = path;
				designer_auto_connect_path (self, _tmp3_);
				_path_unref0 (path);
			}
		}
	}
}


void designer_auto_connect_path (Designer* self, Path* path) {
	Path* _tmp0_ = NULL;
	PathLine* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PathLine _tmp2_ = {0};
	gint _tmp3_ = 0;
	Path* _tmp4_ = NULL;
	PathLine* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	PathLine _tmp6_ = {0};
	gint _tmp7_ = 0;
	Path* _tmp8_ = NULL;
	PathLine* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	PathLine _tmp10_ = {0};
	gint _tmp11_ = 0;
	Path* _tmp12_ = NULL;
	PathLine* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	PathLine _tmp14_ = {0};
	gint _tmp15_ = 0;
	Path* _tmp16_ = NULL;
	PathLine* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = _tmp0_->lines;
	_tmp1__length1 = _tmp0_->lines_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = _tmp2_.x1;
	_tmp4_ = path;
	_tmp5_ = _tmp4_->lines;
	_tmp5__length1 = _tmp4_->lines_length1;
	_tmp6_ = _tmp5_[0];
	_tmp7_ = _tmp6_.y1;
	designer_bind_wire (self, _tmp3_, _tmp7_);
	_tmp8_ = path;
	_tmp9_ = _tmp8_->lines;
	_tmp9__length1 = _tmp8_->lines_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = _tmp10_.x1;
	_tmp12_ = path;
	_tmp13_ = _tmp12_->lines;
	_tmp13__length1 = _tmp12_->lines_length1;
	_tmp14_ = _tmp13_[0];
	_tmp15_ = _tmp14_.y1;
	designer_connect_component (self, _tmp11_, _tmp15_);
	_tmp16_ = path;
	_tmp17_ = _tmp16_->lines;
	_tmp17__length1 = _tmp16_->lines_length1;
	{
		PathLine* line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp17_;
		line_collection_length1 = _tmp17__length1;
		for (line_it = 0; line_it < _tmp17__length1; line_it = line_it + 1) {
			PathLine line = {0};
			line = line_collection[line_it];
			{
				PathLine _tmp18_ = {0};
				gint _tmp19_ = 0;
				PathLine _tmp20_ = {0};
				gint _tmp21_ = 0;
				PathLine _tmp22_ = {0};
				gint _tmp23_ = 0;
				PathLine _tmp24_ = {0};
				gint _tmp25_ = 0;
				_tmp18_ = line;
				_tmp19_ = _tmp18_.x2;
				_tmp20_ = line;
				_tmp21_ = _tmp20_.y2;
				designer_bind_wire (self, _tmp19_, _tmp21_);
				_tmp22_ = line;
				_tmp23_ = _tmp22_.x2;
				_tmp24_ = line;
				_tmp25_ = _tmp24_.y2;
				designer_connect_component (self, _tmp23_, _tmp25_);
			}
		}
	}
}


static gpointer _pin_inst_ref0 (gpointer self) {
	return self ? pin_inst_ref (self) : NULL;
}


void designer_auto_connect_component (Designer* self, ComponentInst* componentInst) {
	ComponentInst* _tmp0_ = NULL;
	PinInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (componentInst != NULL);
	_tmp0_ = componentInst;
	_tmp1_ = _tmp0_->pinInsts;
	_tmp1__length1 = _tmp0_->pinInsts_length1;
	{
		PinInst** pinInst_collection = NULL;
		gint pinInst_collection_length1 = 0;
		gint _pinInst_collection_size_ = 0;
		gint pinInst_it = 0;
		pinInst_collection = _tmp1_;
		pinInst_collection_length1 = _tmp1__length1;
		for (pinInst_it = 0; pinInst_it < _tmp1__length1; pinInst_it = pinInst_it + 1) {
			PinInst* _tmp2_ = NULL;
			PinInst* pinInst = NULL;
			_tmp2_ = _pin_inst_ref0 (pinInst_collection[pinInst_it]);
			pinInst = _tmp2_;
			{
				PinInst* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = pinInst;
				_tmp4_ = _tmp3_->show;
				if (_tmp4_) {
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp5_ = FALSE;
							_tmp5_ = TRUE;
							while (TRUE) {
								gint _tmp7_ = 0;
								PinInst* _tmp8_ = NULL;
								gint _tmp9_ = 0;
								PinInst* _tmp10_ = NULL;
								WireInst** _tmp11_ = NULL;
								gint _tmp11__length1 = 0;
								gint _tmp12_ = 0;
								WireInst* _tmp13_ = NULL;
								if (!_tmp5_) {
									gint _tmp6_ = 0;
									_tmp6_ = i;
									i = _tmp6_ + 1;
								}
								_tmp5_ = FALSE;
								_tmp7_ = i;
								_tmp8_ = pinInst;
								_tmp9_ = _tmp8_->arraySize;
								if (!(_tmp7_ < _tmp9_)) {
									break;
								}
								_tmp10_ = pinInst;
								_tmp11_ = _tmp10_->wireInsts;
								_tmp11__length1 = _tmp10_->wireInsts_length1;
								_tmp12_ = i;
								_tmp13_ = _tmp11_[_tmp12_];
								if (_tmp13_ == NULL) {
									CustomComponentDef* _tmp14_ = NULL;
									WireInst** _tmp15_ = NULL;
									gint _tmp15__length1 = 0;
									_tmp14_ = self->customComponentDef;
									_tmp15_ = _tmp14_->wireInsts;
									_tmp15__length1 = _tmp14_->wireInsts_length1;
									{
										WireInst** wireInst_collection = NULL;
										gint wireInst_collection_length1 = 0;
										gint _wireInst_collection_size_ = 0;
										gint wireInst_it = 0;
										wireInst_collection = _tmp15_;
										wireInst_collection_length1 = _tmp15__length1;
										for (wireInst_it = 0; wireInst_it < _tmp15__length1; wireInst_it = wireInst_it + 1) {
											WireInst* _tmp16_ = NULL;
											WireInst* wireInst = NULL;
											_tmp16_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
											wireInst = _tmp16_;
											{
												gint xAbs = 0;
												gint yAbs = 0;
												ComponentInst* _tmp17_ = NULL;
												PinInst* _tmp18_ = NULL;
												gint* _tmp19_ = NULL;
												gint _tmp19__length1 = 0;
												gint _tmp20_ = 0;
												gint _tmp21_ = 0;
												PinInst* _tmp22_ = NULL;
												gint* _tmp23_ = NULL;
												gint _tmp23__length1 = 0;
												gint _tmp24_ = 0;
												gint _tmp25_ = 0;
												gint _tmp26_ = 0;
												gint _tmp27_ = 0;
												WireInst* _tmp28_ = NULL;
												gint _tmp29_ = 0;
												gint _tmp30_ = 0;
												Path* _tmp31_ = NULL;
												Path* _tmp32_ = NULL;
												gboolean _tmp33_ = FALSE;
												_tmp17_ = componentInst;
												_tmp18_ = pinInst;
												_tmp19_ = _tmp18_->xConnect;
												_tmp19__length1 = _tmp18_->xConnect_length1;
												_tmp20_ = i;
												_tmp21_ = _tmp19_[_tmp20_];
												_tmp22_ = pinInst;
												_tmp23_ = _tmp22_->yConnect;
												_tmp23__length1 = _tmp22_->yConnect_length1;
												_tmp24_ = i;
												_tmp25_ = _tmp23_[_tmp24_];
												component_inst_absolute_position (_tmp17_, _tmp21_, _tmp25_, &_tmp26_, &_tmp27_);
												xAbs = _tmp26_;
												yAbs = _tmp27_;
												_tmp28_ = wireInst;
												_tmp29_ = xAbs;
												_tmp30_ = yAbs;
												_tmp31_ = wire_inst_find (_tmp28_, _tmp29_, _tmp30_);
												_tmp32_ = _tmp31_;
												_tmp33_ = _tmp32_ != NULL;
												_path_unref0 (_tmp32_);
												if (_tmp33_) {
													PinInst* _tmp34_ = NULL;
													PinInst* _tmp35_ = NULL;
													gint* _tmp36_ = NULL;
													gint _tmp36__length1 = 0;
													gint _tmp37_ = 0;
													gint _tmp38_ = 0;
													PinInst* _tmp39_ = NULL;
													gint* _tmp40_ = NULL;
													gint _tmp40__length1 = 0;
													gint _tmp41_ = 0;
													gint _tmp42_ = 0;
													WireInst* _tmp43_ = NULL;
													ComponentInst* _tmp44_ = NULL;
													_tmp34_ = pinInst;
													_tmp35_ = pinInst;
													_tmp36_ = _tmp35_->xConnect;
													_tmp36__length1 = _tmp35_->xConnect_length1;
													_tmp37_ = i;
													_tmp38_ = _tmp36_[_tmp37_];
													_tmp39_ = pinInst;
													_tmp40_ = _tmp39_->yConnect;
													_tmp40__length1 = _tmp39_->yConnect_length1;
													_tmp41_ = i;
													_tmp42_ = _tmp40_[_tmp41_];
													_tmp43_ = wireInst;
													_tmp44_ = componentInst;
													pin_inst_try_connect (_tmp34_, _tmp38_, _tmp42_, _tmp43_, _tmp44_);
												}
												_wire_inst_unref0 (wireInst);
											}
										}
									}
								}
							}
						}
					}
				}
				_pin_inst_unref0 (pinInst);
			}
		}
	}
}


/**
 * Connects a wire with any pins at point (//x//, //y//).
 */
gint designer_connect_component (Designer* self, gint x, gint y) {
	gint result = 0;
	gint connectedComponents = 0;
	CustomComponentDef* _tmp0_ = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	connectedComponents = 0;
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->wireInsts;
	_tmp1__length1 = _tmp0_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				WireInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				Path* _tmp6_ = NULL;
				Path* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp3_ = wireInst;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = wire_inst_find (_tmp3_, _tmp4_, _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_ != NULL;
				_path_unref0 (_tmp7_);
				if (_tmp8_) {
					CustomComponentDef* _tmp9_ = NULL;
					ComponentInst** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					_tmp9_ = self->customComponentDef;
					_tmp10_ = _tmp9_->componentInsts;
					_tmp10__length1 = _tmp9_->componentInsts_length1;
					{
						ComponentInst** componentInst_collection = NULL;
						gint componentInst_collection_length1 = 0;
						gint _componentInst_collection_size_ = 0;
						gint componentInst_it = 0;
						componentInst_collection = _tmp10_;
						componentInst_collection_length1 = _tmp10__length1;
						for (componentInst_it = 0; componentInst_it < _tmp10__length1; componentInst_it = componentInst_it + 1) {
							ComponentInst* _tmp11_ = NULL;
							ComponentInst* componentInst = NULL;
							_tmp11_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
							componentInst = _tmp11_;
							{
								ComponentInst* _tmp12_ = NULL;
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
								WireInst* _tmp15_ = NULL;
								gboolean _tmp16_ = FALSE;
								_tmp12_ = componentInst;
								_tmp13_ = x;
								_tmp14_ = y;
								_tmp15_ = wireInst;
								_tmp16_ = component_inst_try_connect (_tmp12_, _tmp13_, _tmp14_, _tmp15_);
								if (_tmp16_) {
									gint _tmp17_ = 0;
									_tmp17_ = connectedComponents;
									connectedComponents = _tmp17_ + 1;
								}
								_component_inst_unref0 (componentInst);
							}
						}
					}
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	result = connectedComponents;
	return result;
}


/**
 * Disconnects any pins at point (//x//, //y//) from all wires.
 */
gint designer_disconnect_component (Designer* self, gint x, gint y) {
	gint result = 0;
	gint disconnectedComponents = 0;
	CustomComponentDef* _tmp0_ = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	disconnectedComponents = 0;
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->wireInsts;
	_tmp1__length1 = _tmp0_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				WireInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				Path* _tmp6_ = NULL;
				Path* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp3_ = wireInst;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = wire_inst_find (_tmp3_, _tmp4_, _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_ != NULL;
				_path_unref0 (_tmp7_);
				if (_tmp8_) {
					CustomComponentDef* _tmp9_ = NULL;
					ComponentInst** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					_tmp9_ = self->customComponentDef;
					_tmp10_ = _tmp9_->componentInsts;
					_tmp10__length1 = _tmp9_->componentInsts_length1;
					{
						ComponentInst** componentInst_collection = NULL;
						gint componentInst_collection_length1 = 0;
						gint _componentInst_collection_size_ = 0;
						gint componentInst_it = 0;
						componentInst_collection = _tmp10_;
						componentInst_collection_length1 = _tmp10__length1;
						for (componentInst_it = 0; componentInst_it < _tmp10__length1; componentInst_it = componentInst_it + 1) {
							ComponentInst* _tmp11_ = NULL;
							ComponentInst* componentInst = NULL;
							_tmp11_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
							componentInst = _tmp11_;
							{
								ComponentInst* _tmp12_ = NULL;
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
								gboolean _tmp15_ = FALSE;
								_tmp12_ = componentInst;
								_tmp13_ = x;
								_tmp14_ = y;
								_tmp15_ = component_inst_try_disconnect (_tmp12_, _tmp13_, _tmp14_);
								if (_tmp15_) {
									gint _tmp16_ = 0;
									_tmp16_ = disconnectedComponents;
									disconnectedComponents = _tmp16_ + 1;
								}
								_component_inst_unref0 (componentInst);
							}
						}
					}
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
	result = disconnectedComponents;
	return result;
}


/**
 * Invert any pins with their ends at point (//x//, //y//).
 */
void designer_invert_pin (Designer* self, gint x, gint y) {
	CustomComponentDef* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->componentInsts;
	_tmp1__length1 = _tmp0_->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp3_ = componentInst;
				_tmp4_ = x;
				_tmp5_ = y;
				component_inst_try_invert (_tmp3_, _tmp4_, _tmp5_);
				_component_inst_unref0 (componentInst);
			}
		}
	}
}


/**
 * Snap //x// and //y// to the nearest pin within a square range.
 */
gint designer_snap_pin (Designer* self, gint* x, gint* y, gint range) {
	gint result = 0;
	gboolean match = FALSE;
	gint xNew = 0;
	gint yNew = 0;
	gint winningDiff = 0;
	gint _tmp0_ = 0;
	CustomComponentDef* _tmp1_ = NULL;
	ComponentInst** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gboolean _tmp47_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	match = FALSE;
	xNew = 0;
	yNew = 0;
	_tmp0_ = range;
	winningDiff = (2 * _tmp0_) + 1;
	_tmp1_ = self->customComponentDef;
	_tmp2_ = _tmp1_->componentInsts;
	_tmp2__length1 = _tmp1_->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp2_;
		componentInst_collection_length1 = _tmp2__length1;
		for (componentInst_it = 0; componentInst_it < _tmp2__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp3_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp3_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp3_;
			{
				ComponentInst* _tmp4_ = NULL;
				PinInst** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				_tmp4_ = componentInst;
				_tmp5_ = _tmp4_->pinInsts;
				_tmp5__length1 = _tmp4_->pinInsts_length1;
				{
					PinInst** pinInst_collection = NULL;
					gint pinInst_collection_length1 = 0;
					gint _pinInst_collection_size_ = 0;
					gint pinInst_it = 0;
					pinInst_collection = _tmp5_;
					pinInst_collection_length1 = _tmp5__length1;
					for (pinInst_it = 0; pinInst_it < _tmp5__length1; pinInst_it = pinInst_it + 1) {
						PinInst* _tmp6_ = NULL;
						PinInst* pinInst = NULL;
						_tmp6_ = _pin_inst_ref0 (pinInst_collection[pinInst_it]);
						pinInst = _tmp6_;
						{
							{
								gint i = 0;
								i = 0;
								{
									gboolean _tmp7_ = FALSE;
									_tmp7_ = TRUE;
									while (TRUE) {
										gint _tmp9_ = 0;
										PinInst* _tmp10_ = NULL;
										gint _tmp11_ = 0;
										gint xPin = 0;
										gint yPin = 0;
										ComponentInst* _tmp12_ = NULL;
										PinInst* _tmp13_ = NULL;
										gint* _tmp14_ = NULL;
										gint _tmp14__length1 = 0;
										gint _tmp15_ = 0;
										gint _tmp16_ = 0;
										PinInst* _tmp17_ = NULL;
										gint* _tmp18_ = NULL;
										gint _tmp18__length1 = 0;
										gint _tmp19_ = 0;
										gint _tmp20_ = 0;
										gint _tmp21_ = 0;
										gint _tmp22_ = 0;
										gint xDiff = 0;
										gint _tmp23_ = 0;
										gint _tmp24_ = 0;
										gint yDiff = 0;
										gint _tmp25_ = 0;
										gint _tmp26_ = 0;
										gint _tmp27_ = 0;
										gint _tmp28_ = 0;
										gint xDiffAbs = 0;
										gint _tmp31_ = 0;
										gint _tmp32_ = 0;
										gint yDiffAbs = 0;
										gboolean _tmp35_ = FALSE;
										gint _tmp36_ = 0;
										gint _tmp37_ = 0;
										if (!_tmp7_) {
											gint _tmp8_ = 0;
											_tmp8_ = i;
											i = _tmp8_ + 1;
										}
										_tmp7_ = FALSE;
										_tmp9_ = i;
										_tmp10_ = pinInst;
										_tmp11_ = _tmp10_->arraySize;
										if (!(_tmp9_ < _tmp11_)) {
											break;
										}
										_tmp12_ = componentInst;
										_tmp13_ = pinInst;
										_tmp14_ = _tmp13_->xConnect;
										_tmp14__length1 = _tmp13_->xConnect_length1;
										_tmp15_ = i;
										_tmp16_ = _tmp14_[_tmp15_];
										_tmp17_ = pinInst;
										_tmp18_ = _tmp17_->yConnect;
										_tmp18__length1 = _tmp17_->yConnect_length1;
										_tmp19_ = i;
										_tmp20_ = _tmp18_[_tmp19_];
										component_inst_absolute_position (_tmp12_, _tmp16_, _tmp20_, &_tmp21_, &_tmp22_);
										xPin = _tmp21_;
										yPin = _tmp22_;
										_tmp23_ = *x;
										_tmp24_ = xPin;
										xDiff = _tmp23_ - _tmp24_;
										_tmp25_ = *y;
										_tmp26_ = yPin;
										yDiff = _tmp25_ - _tmp26_;
										_tmp28_ = xDiff;
										if (_tmp28_ > 0) {
											gint _tmp29_ = 0;
											_tmp29_ = xDiff;
											_tmp27_ = _tmp29_;
										} else {
											gint _tmp30_ = 0;
											_tmp30_ = xDiff;
											_tmp27_ = -_tmp30_;
										}
										xDiffAbs = _tmp27_;
										_tmp32_ = yDiff;
										if (_tmp32_ > 0) {
											gint _tmp33_ = 0;
											_tmp33_ = yDiff;
											_tmp31_ = _tmp33_;
										} else {
											gint _tmp34_ = 0;
											_tmp34_ = yDiff;
											_tmp31_ = -_tmp34_;
										}
										yDiffAbs = _tmp31_;
										_tmp36_ = xDiffAbs;
										_tmp37_ = range;
										if (_tmp36_ <= _tmp37_) {
											gint _tmp38_ = 0;
											gint _tmp39_ = 0;
											_tmp38_ = yDiffAbs;
											_tmp39_ = range;
											_tmp35_ = _tmp38_ <= _tmp39_;
										} else {
											_tmp35_ = FALSE;
										}
										if (_tmp35_) {
											gint diff = 0;
											gint _tmp40_ = 0;
											gint _tmp41_ = 0;
											gint _tmp42_ = 0;
											gint _tmp43_ = 0;
											_tmp40_ = xDiffAbs;
											_tmp41_ = yDiffAbs;
											diff = _tmp40_ + _tmp41_;
											_tmp42_ = diff;
											_tmp43_ = winningDiff;
											if (_tmp42_ < _tmp43_) {
												gint _tmp44_ = 0;
												gint _tmp45_ = 0;
												gint _tmp46_ = 0;
												match = TRUE;
												_tmp44_ = xPin;
												xNew = _tmp44_;
												_tmp45_ = yPin;
												yNew = _tmp45_;
												_tmp46_ = diff;
												winningDiff = _tmp46_;
											}
										}
									}
								}
							}
							_pin_inst_unref0 (pinInst);
						}
					}
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	_tmp47_ = match;
	if (_tmp47_) {
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		_tmp48_ = xNew;
		*x = _tmp48_;
		_tmp49_ = yNew;
		*y = _tmp49_;
		result = 0;
		return result;
	} else {
		result = 1;
		return result;
	}
}


/**
 * Change the properties of a component at (//x//, //y//), including
 * any pin array sizes and component specific properties.
 */
void designer_adjust_components (Designer* self, gint x, gint y, gboolean autoBind) {
	CustomComponentDef* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->componentInsts;
	_tmp1__length1 = _tmp0_->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				_tmp3_ = componentInst;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = component_inst_find (_tmp3_, _tmp4_, _tmp5_);
				if (_tmp6_ == 1) {
					PropertySet* componentProperties = NULL;
					ComponentInst* _tmp7_ = NULL;
					ComponentDef* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					PropertySet* _tmp12_ = NULL;
					PropertySet* _tmp13_ = NULL;
					ComponentInst* _tmp69_ = NULL;
					ComponentDef* _tmp70_ = NULL;
					PropertySet* _tmp71_ = NULL;
					ComponentInst* _tmp72_ = NULL;
					PropertySet* _tmp73_ = NULL;
					gchar* title = NULL;
					ComponentInst* _tmp74_ = NULL;
					ComponentDef* _tmp75_ = NULL;
					const gchar* _tmp76_ = NULL;
					gchar* _tmp77_ = NULL;
					PropertiesQuery* componentQuery = NULL;
					const gchar* _tmp78_ = NULL;
					DesignerWindow* _tmp79_ = NULL;
					PropertySet* _tmp80_ = NULL;
					PropertiesQuery* _tmp81_ = NULL;
					PropertiesQuery* _tmp82_ = NULL;
					gint _tmp83_ = 0;
					ComponentInst* _tmp156_ = NULL;
					ComponentDef* _tmp157_ = NULL;
					PropertySet* _tmp158_ = NULL;
					ComponentInst* _tmp159_ = NULL;
					PropertySet* _tmp160_ = NULL;
					ComponentInst* _tmp161_ = NULL;
					ComponentDef* _tmp162_ = NULL;
					ComponentInst* _tmp163_ = NULL;
					gboolean _tmp164_ = FALSE;
					_tmp7_ = componentInst;
					_tmp8_ = _tmp7_->componentDef;
					_tmp9_ = _tmp8_->name;
					_tmp10_ = g_strconcat (_tmp9_, " Component Instance", NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = property_set_new (_tmp11_, "Component Instance Properties");
					_tmp13_ = _tmp12_;
					_g_free0 (_tmp11_);
					componentProperties = _tmp13_;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp14_ = FALSE;
							_tmp14_ = TRUE;
							while (TRUE) {
								gint _tmp16_ = 0;
								ComponentInst* _tmp17_ = NULL;
								PinInst** _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gboolean _tmp19_ = FALSE;
								ComponentInst* _tmp20_ = NULL;
								PinInst** _tmp21_ = NULL;
								gint _tmp21__length1 = 0;
								gint _tmp22_ = 0;
								PinInst* _tmp23_ = NULL;
								PinDef* _tmp24_ = NULL;
								gboolean _tmp25_ = FALSE;
								if (!_tmp14_) {
									gint _tmp15_ = 0;
									_tmp15_ = i;
									i = _tmp15_ + 1;
								}
								_tmp14_ = FALSE;
								_tmp16_ = i;
								_tmp17_ = componentInst;
								_tmp18_ = _tmp17_->pinInsts;
								_tmp18__length1 = _tmp17_->pinInsts_length1;
								if (!(_tmp16_ < _tmp18__length1)) {
									break;
								}
								_tmp20_ = componentInst;
								_tmp21_ = _tmp20_->pinInsts;
								_tmp21__length1 = _tmp20_->pinInsts_length1;
								_tmp22_ = i;
								_tmp23_ = _tmp21_[_tmp22_];
								_tmp24_ = _tmp23_->pinDef;
								_tmp25_ = _tmp24_->array;
								if (_tmp25_) {
									ComponentInst* _tmp26_ = NULL;
									PinInst** _tmp27_ = NULL;
									gint _tmp27__length1 = 0;
									gint _tmp28_ = 0;
									PinInst* _tmp29_ = NULL;
									PinDef* _tmp30_ = NULL;
									gboolean _tmp31_ = FALSE;
									_tmp26_ = componentInst;
									_tmp27_ = _tmp26_->pinInsts;
									_tmp27__length1 = _tmp26_->pinInsts_length1;
									_tmp28_ = i;
									_tmp29_ = _tmp27_[_tmp28_];
									_tmp30_ = _tmp29_->pinDef;
									_tmp31_ = _tmp30_->userArrayResize;
									_tmp19_ = _tmp31_;
								} else {
									_tmp19_ = FALSE;
								}
								if (_tmp19_) {
									gchar* propertyName = NULL;
									gchar* _tmp32_ = NULL;
									ComponentInst* _tmp33_ = NULL;
									PinInst** _tmp34_ = NULL;
									gint _tmp34__length1 = 0;
									gint _tmp35_ = 0;
									PinInst* _tmp36_ = NULL;
									PinDef* _tmp37_ = NULL;
									Flow _tmp38_ = 0;
									const gchar* _tmp42_ = NULL;
									ComponentInst* _tmp43_ = NULL;
									PinInst** _tmp44_ = NULL;
									gint _tmp44__length1 = 0;
									gint _tmp45_ = 0;
									PinInst* _tmp46_ = NULL;
									PinDef* _tmp47_ = NULL;
									const gchar* _tmp48_ = NULL;
									gchar* _tmp49_ = NULL;
									gchar* _tmp50_ = NULL;
									gchar* _tmp51_ = NULL;
									gchar* _tmp52_ = NULL;
									gint _tmp53_ = 0;
									gchar* _tmp54_ = NULL;
									gchar* _tmp55_ = NULL;
									gchar* _tmp56_ = NULL;
									gchar* _tmp57_ = NULL;
									gchar* _tmp58_ = NULL;
									PropertySet* _tmp59_ = NULL;
									const gchar* _tmp60_ = NULL;
									ComponentInst* _tmp61_ = NULL;
									PinInst** _tmp62_ = NULL;
									gint _tmp62__length1 = 0;
									gint _tmp63_ = 0;
									PinInst* _tmp64_ = NULL;
									gint _tmp65_ = 0;
									gint _tmp66_ = 0;
									PropertyItemInt* _tmp67_ = NULL;
									PropertyItemInt* _tmp68_ = NULL;
									_tmp32_ = g_strdup ("");
									propertyName = _tmp32_;
									_tmp33_ = componentInst;
									_tmp34_ = _tmp33_->pinInsts;
									_tmp34__length1 = _tmp33_->pinInsts_length1;
									_tmp35_ = i;
									_tmp36_ = _tmp34_[_tmp35_];
									_tmp37_ = _tmp36_->pinDef;
									_tmp38_ = _tmp37_->flow;
									switch (_tmp38_) {
										case FLOW_IN:
										{
											gchar* _tmp39_ = NULL;
											_tmp39_ = g_strdup ("Input - ");
											_g_free0 (propertyName);
											propertyName = _tmp39_;
											break;
										}
										case FLOW_OUT:
										{
											gchar* _tmp40_ = NULL;
											_tmp40_ = g_strdup ("Output - ");
											_g_free0 (propertyName);
											propertyName = _tmp40_;
											break;
										}
										case FLOW_BIDIRECTIONAL:
										{
											gchar* _tmp41_ = NULL;
											_tmp41_ = g_strdup ("Bidirectional - ");
											_g_free0 (propertyName);
											propertyName = _tmp41_;
											break;
										}
										default:
										break;
									}
									_tmp42_ = propertyName;
									_tmp43_ = componentInst;
									_tmp44_ = _tmp43_->pinInsts;
									_tmp44__length1 = _tmp43_->pinInsts_length1;
									_tmp45_ = i;
									_tmp46_ = _tmp44_[_tmp45_];
									_tmp47_ = _tmp46_->pinDef;
									_tmp48_ = _tmp47_->label;
									_tmp49_ = g_strconcat ("Set width of \"", _tmp48_, NULL);
									_tmp50_ = _tmp49_;
									_tmp51_ = g_strconcat (_tmp50_, "\" / ID ", NULL);
									_tmp52_ = _tmp51_;
									_tmp53_ = i;
									_tmp54_ = g_strdup_printf ("%i", _tmp53_);
									_tmp55_ = _tmp54_;
									_tmp56_ = g_strconcat (_tmp52_, _tmp55_, NULL);
									_tmp57_ = _tmp56_;
									_tmp58_ = g_strconcat (_tmp42_, _tmp57_, NULL);
									_g_free0 (propertyName);
									propertyName = _tmp58_;
									_g_free0 (_tmp57_);
									_g_free0 (_tmp55_);
									_g_free0 (_tmp52_);
									_g_free0 (_tmp50_);
									_tmp59_ = componentProperties;
									_tmp60_ = propertyName;
									_tmp61_ = componentInst;
									_tmp62_ = _tmp61_->pinInsts;
									_tmp62__length1 = _tmp61_->pinInsts_length1;
									_tmp63_ = i;
									_tmp64_ = _tmp62_[_tmp63_];
									_tmp65_ = _tmp64_->arraySize;
									_tmp66_ = G_MAXINT;
									_tmp67_ = property_item_int_new (_tmp60_, "The number of pins that this component should use.", _tmp65_, 1, _tmp66_);
									_tmp68_ = _tmp67_;
									property_set_add_item (_tmp59_, (PropertyItem*) _tmp68_);
									_property_item_unref0 (_tmp68_);
									_g_free0 (propertyName);
								}
							}
						}
					}
					_tmp69_ = componentInst;
					_tmp70_ = _tmp69_->componentDef;
					_tmp71_ = componentProperties;
					_tmp72_ = componentInst;
					_tmp73_ = _tmp72_->configuration;
					component_def_add_properties (_tmp70_, _tmp71_, _tmp73_);
					_tmp74_ = componentInst;
					_tmp75_ = _tmp74_->componentDef;
					_tmp76_ = _tmp75_->name;
					_tmp77_ = g_strconcat (_tmp76_, " Component Properties", NULL);
					title = _tmp77_;
					_tmp78_ = title;
					_tmp79_ = self->window;
					_tmp80_ = componentProperties;
					_tmp81_ = properties_query_new (_tmp78_, (GtkWindow*) _tmp79_, _tmp80_);
					componentQuery = _tmp81_;
					_tmp82_ = componentQuery;
					_tmp83_ = properties_query_run (_tmp82_);
					if (_tmp83_ == ((gint) GTK_RESPONSE_APPLY)) {
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp84_ = FALSE;
								_tmp84_ = TRUE;
								while (TRUE) {
									gint _tmp86_ = 0;
									ComponentInst* _tmp87_ = NULL;
									PinInst** _tmp88_ = NULL;
									gint _tmp88__length1 = 0;
									gboolean _tmp89_ = FALSE;
									ComponentInst* _tmp90_ = NULL;
									PinInst** _tmp91_ = NULL;
									gint _tmp91__length1 = 0;
									gint _tmp92_ = 0;
									PinInst* _tmp93_ = NULL;
									PinDef* _tmp94_ = NULL;
									gboolean _tmp95_ = FALSE;
									if (!_tmp84_) {
										gint _tmp85_ = 0;
										_tmp85_ = i;
										i = _tmp85_ + 1;
									}
									_tmp84_ = FALSE;
									_tmp86_ = i;
									_tmp87_ = componentInst;
									_tmp88_ = _tmp87_->pinInsts;
									_tmp88__length1 = _tmp87_->pinInsts_length1;
									if (!(_tmp86_ < _tmp88__length1)) {
										break;
									}
									_tmp90_ = componentInst;
									_tmp91_ = _tmp90_->pinInsts;
									_tmp91__length1 = _tmp90_->pinInsts_length1;
									_tmp92_ = i;
									_tmp93_ = _tmp91_[_tmp92_];
									_tmp94_ = _tmp93_->pinDef;
									_tmp95_ = _tmp94_->array;
									if (_tmp95_) {
										ComponentInst* _tmp96_ = NULL;
										PinInst** _tmp97_ = NULL;
										gint _tmp97__length1 = 0;
										gint _tmp98_ = 0;
										PinInst* _tmp99_ = NULL;
										PinDef* _tmp100_ = NULL;
										gboolean _tmp101_ = FALSE;
										_tmp96_ = componentInst;
										_tmp97_ = _tmp96_->pinInsts;
										_tmp97__length1 = _tmp96_->pinInsts_length1;
										_tmp98_ = i;
										_tmp99_ = _tmp97_[_tmp98_];
										_tmp100_ = _tmp99_->pinDef;
										_tmp101_ = _tmp100_->userArrayResize;
										_tmp89_ = _tmp101_;
									} else {
										_tmp89_ = FALSE;
									}
									if (_tmp89_) {
										gint arraySize = 0;
										gchar* propertyName = NULL;
										gchar* _tmp102_ = NULL;
										ComponentInst* _tmp103_ = NULL;
										PinInst** _tmp104_ = NULL;
										gint _tmp104__length1 = 0;
										gint _tmp105_ = 0;
										PinInst* _tmp106_ = NULL;
										PinDef* _tmp107_ = NULL;
										Flow _tmp108_ = 0;
										const gchar* _tmp112_ = NULL;
										ComponentInst* _tmp113_ = NULL;
										PinInst** _tmp114_ = NULL;
										gint _tmp114__length1 = 0;
										gint _tmp115_ = 0;
										PinInst* _tmp116_ = NULL;
										PinDef* _tmp117_ = NULL;
										const gchar* _tmp118_ = NULL;
										gchar* _tmp119_ = NULL;
										gchar* _tmp120_ = NULL;
										gchar* _tmp121_ = NULL;
										gchar* _tmp122_ = NULL;
										gint _tmp123_ = 0;
										gchar* _tmp124_ = NULL;
										gchar* _tmp125_ = NULL;
										gchar* _tmp126_ = NULL;
										gchar* _tmp127_ = NULL;
										gchar* _tmp128_ = NULL;
										PropertySet* _tmp129_ = NULL;
										const gchar* _tmp130_ = NULL;
										gint _tmp131_ = 0;
										gboolean _tmp132_ = FALSE;
										gint _tmp133_ = 0;
										ComponentInst* _tmp134_ = NULL;
										PinInst** _tmp135_ = NULL;
										gint _tmp135__length1 = 0;
										gint _tmp136_ = 0;
										PinInst* _tmp137_ = NULL;
										gint _tmp138_ = 0;
										_tmp102_ = g_strdup ("");
										propertyName = _tmp102_;
										_tmp103_ = componentInst;
										_tmp104_ = _tmp103_->pinInsts;
										_tmp104__length1 = _tmp103_->pinInsts_length1;
										_tmp105_ = i;
										_tmp106_ = _tmp104_[_tmp105_];
										_tmp107_ = _tmp106_->pinDef;
										_tmp108_ = _tmp107_->flow;
										switch (_tmp108_) {
											case FLOW_IN:
											{
												gchar* _tmp109_ = NULL;
												_tmp109_ = g_strdup ("Input - ");
												_g_free0 (propertyName);
												propertyName = _tmp109_;
												break;
											}
											case FLOW_OUT:
											{
												gchar* _tmp110_ = NULL;
												_tmp110_ = g_strdup ("Output - ");
												_g_free0 (propertyName);
												propertyName = _tmp110_;
												break;
											}
											case FLOW_BIDIRECTIONAL:
											{
												gchar* _tmp111_ = NULL;
												_tmp111_ = g_strdup ("Bidirectional - ");
												_g_free0 (propertyName);
												propertyName = _tmp111_;
												break;
											}
											default:
											break;
										}
										_tmp112_ = propertyName;
										_tmp113_ = componentInst;
										_tmp114_ = _tmp113_->pinInsts;
										_tmp114__length1 = _tmp113_->pinInsts_length1;
										_tmp115_ = i;
										_tmp116_ = _tmp114_[_tmp115_];
										_tmp117_ = _tmp116_->pinDef;
										_tmp118_ = _tmp117_->label;
										_tmp119_ = g_strconcat ("Set width of \"", _tmp118_, NULL);
										_tmp120_ = _tmp119_;
										_tmp121_ = g_strconcat (_tmp120_, "\" / ID ", NULL);
										_tmp122_ = _tmp121_;
										_tmp123_ = i;
										_tmp124_ = g_strdup_printf ("%i", _tmp123_);
										_tmp125_ = _tmp124_;
										_tmp126_ = g_strconcat (_tmp122_, _tmp125_, NULL);
										_tmp127_ = _tmp126_;
										_tmp128_ = g_strconcat (_tmp112_, _tmp127_, NULL);
										_g_free0 (propertyName);
										propertyName = _tmp128_;
										_g_free0 (_tmp127_);
										_g_free0 (_tmp125_);
										_g_free0 (_tmp122_);
										_g_free0 (_tmp120_);
										_tmp129_ = componentProperties;
										_tmp130_ = propertyName;
										_tmp131_ = property_item_int_get_data (_tmp129_, _tmp130_);
										arraySize = _tmp131_;
										_tmp133_ = arraySize;
										_tmp134_ = componentInst;
										_tmp135_ = _tmp134_->pinInsts;
										_tmp135__length1 = _tmp134_->pinInsts_length1;
										_tmp136_ = i;
										_tmp137_ = _tmp135_[_tmp136_];
										_tmp138_ = _tmp137_->arraySize;
										if (_tmp133_ != _tmp138_) {
											gint _tmp139_ = 0;
											_tmp139_ = arraySize;
											_tmp132_ = _tmp139_ >= 1;
										} else {
											_tmp132_ = FALSE;
										}
										if (_tmp132_) {
											ComponentInst* _tmp140_ = NULL;
											PinInst** _tmp141_ = NULL;
											gint _tmp141__length1 = 0;
											gint _tmp142_ = 0;
											PinInst* _tmp143_ = NULL;
											ComponentInst* _tmp144_ = NULL;
											ComponentInst* _tmp145_ = NULL;
											PinInst** _tmp146_ = NULL;
											gint _tmp146__length1 = 0;
											gint _tmp147_ = 0;
											ComponentInst* _tmp148_ = NULL;
											ComponentDef* _tmp149_ = NULL;
											PinDef** _tmp150_ = NULL;
											gint _tmp150__length1 = 0;
											gint _tmp151_ = 0;
											PinDef* _tmp152_ = NULL;
											gint _tmp153_ = 0;
											PinInst* _tmp154_ = NULL;
											PinInst* _tmp155_ = NULL;
											_tmp140_ = componentInst;
											_tmp141_ = _tmp140_->pinInsts;
											_tmp141__length1 = _tmp140_->pinInsts_length1;
											_tmp142_ = i;
											_tmp143_ = _tmp141_[_tmp142_];
											_tmp144_ = componentInst;
											pin_inst_disconnect (_tmp143_, _tmp144_);
											_tmp145_ = componentInst;
											_tmp146_ = _tmp145_->pinInsts;
											_tmp146__length1 = _tmp145_->pinInsts_length1;
											_tmp147_ = i;
											_tmp148_ = componentInst;
											_tmp149_ = _tmp148_->componentDef;
											_tmp150_ = _tmp149_->pinDefs;
											_tmp150__length1 = _tmp149_->pinDefs_length1;
											_tmp151_ = i;
											_tmp152_ = _tmp150_[_tmp151_];
											_tmp153_ = arraySize;
											_tmp154_ = pin_inst_new (_tmp152_, _tmp153_);
											_pin_inst_unref0 (_tmp146_[_tmp147_]);
											_tmp146_[_tmp147_] = _tmp154_;
											_tmp155_ = _tmp146_[_tmp147_];
										}
										_g_free0 (propertyName);
									}
								}
							}
						}
					}
					_tmp156_ = componentInst;
					_tmp157_ = _tmp156_->componentDef;
					_tmp158_ = componentProperties;
					_tmp159_ = componentInst;
					component_def_get_properties (_tmp157_, _tmp158_, &_tmp160_);
					_property_item_unref0 (_tmp159_->configuration);
					_tmp159_->configuration = _tmp160_;
					_tmp161_ = componentInst;
					_tmp162_ = _tmp161_->componentDef;
					_tmp163_ = componentInst;
					component_def_configure_inst (_tmp162_, _tmp163_, FALSE);
					_tmp164_ = autoBind;
					if (_tmp164_) {
						ComponentInst* _tmp165_ = NULL;
						_tmp165_ = componentInst;
						designer_auto_connect_component (self, _tmp165_);
					}
					_properties_query_unref0 (componentQuery);
					_g_free0 (title);
					_property_item_unref0 (componentProperties);
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
}


/**
 * Change the text and font size of any annotation at
 * (//x//, //y//).
 */
static gpointer _annotation_ref0 (gpointer self) {
	return self ? annotation_ref (self) : NULL;
}


void designer_adjust_annotations (Designer* self, gint x, gint y) {
	CustomComponentDef* _tmp0_ = NULL;
	Annotation** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->annotations;
	_tmp1__length1 = _tmp0_->annotations_length1;
	{
		Annotation** annotation_collection = NULL;
		gint annotation_collection_length1 = 0;
		gint _annotation_collection_size_ = 0;
		gint annotation_it = 0;
		annotation_collection = _tmp1_;
		annotation_collection_length1 = _tmp1__length1;
		for (annotation_it = 0; annotation_it < _tmp1__length1; annotation_it = annotation_it + 1) {
			Annotation* _tmp2_ = NULL;
			Annotation* annotation = NULL;
			_tmp2_ = _annotation_ref0 (annotation_collection[annotation_it]);
			annotation = _tmp2_;
			{
				Annotation* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				_tmp3_ = annotation;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = annotation_find (_tmp3_, _tmp4_, _tmp5_);
				if (_tmp6_ == 1) {
					gchar* text = NULL;
					Annotation* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gdouble fontSize = 0.0;
					Annotation* _tmp11_ = NULL;
					gdouble _tmp12_ = 0.0;
					gdouble _tmp13_ = 0.0;
					PropertySet* annotationProperties = NULL;
					PropertySet* _tmp14_ = NULL;
					PropertySet* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					PropertyItemString* _tmp17_ = NULL;
					PropertyItemString* _tmp18_ = NULL;
					PropertySet* _tmp19_ = NULL;
					gdouble _tmp20_ = 0.0;
					PropertyItemDouble* _tmp21_ = NULL;
					PropertyItemDouble* _tmp22_ = NULL;
					PropertiesQuery* annotationQuery = NULL;
					DesignerWindow* _tmp23_ = NULL;
					PropertySet* _tmp24_ = NULL;
					PropertiesQuery* _tmp25_ = NULL;
					PropertiesQuery* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					_tmp7_ = annotation;
					_tmp8_ = annotation_get_text (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strdup (_tmp9_);
					text = _tmp10_;
					_tmp11_ = annotation;
					_tmp12_ = annotation_get_fontSize (_tmp11_);
					_tmp13_ = _tmp12_;
					fontSize = _tmp13_;
					_tmp14_ = property_set_new ("Annotation", "Annotation text query");
					annotationProperties = _tmp14_;
					_tmp15_ = annotationProperties;
					_tmp16_ = text;
					_tmp17_ = property_item_string_new ("Text", "Text to display.", _tmp16_);
					_tmp18_ = _tmp17_;
					property_set_add_item (_tmp15_, (PropertyItem*) _tmp18_);
					_property_item_unref0 (_tmp18_);
					_tmp19_ = annotationProperties;
					_tmp20_ = fontSize;
					_tmp21_ = property_item_double_new ("Font Size", "Font size with which to display text", _tmp20_, (gdouble) 0, (gdouble) 10000);
					_tmp22_ = _tmp21_;
					property_set_add_item (_tmp19_, (PropertyItem*) _tmp22_);
					_property_item_unref0 (_tmp22_);
					_tmp23_ = self->window;
					_tmp24_ = annotationProperties;
					_tmp25_ = properties_query_new ("Annotation Properties", (GtkWindow*) _tmp23_, _tmp24_);
					annotationQuery = _tmp25_;
					_tmp26_ = annotationQuery;
					_tmp27_ = properties_query_run (_tmp26_);
					if (_tmp27_ == ((gint) GTK_RESPONSE_APPLY)) {
						PropertySet* _tmp28_ = NULL;
						gchar* _tmp29_ = NULL;
						PropertySet* _tmp30_ = NULL;
						gdouble _tmp31_ = 0.0;
						Annotation* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						Annotation* _tmp34_ = NULL;
						gdouble _tmp35_ = 0.0;
						_tmp28_ = annotationProperties;
						_tmp29_ = property_item_string_get_data (_tmp28_, "Text");
						_g_free0 (text);
						text = _tmp29_;
						_tmp30_ = annotationProperties;
						_tmp31_ = property_item_double_get_data (_tmp30_, "Font Size");
						fontSize = _tmp31_;
						_tmp32_ = annotation;
						_tmp33_ = text;
						annotation_set_text (_tmp32_, _tmp33_);
						_tmp34_ = annotation;
						_tmp35_ = fontSize;
						annotation_set_fontSize (_tmp34_, _tmp35_);
					}
					_properties_query_unref0 (annotationQuery);
					_property_item_unref0 (annotationProperties);
					_g_free0 (text);
				}
				_annotation_unref0 (annotation);
			}
		}
	}
}


void designer_adjust_wires (Designer* self, gint x, gint y) {
	CustomComponentDef* _tmp0_ = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->wireInsts;
	_tmp1__length1 = _tmp0_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				WireInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				Path* _tmp6_ = NULL;
				Path* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				WireInst* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				_tmp3_ = wireInst;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = wire_inst_find (_tmp3_, _tmp4_, _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_ != NULL;
				_path_unref0 (_tmp7_);
				if (_tmp8_) {
					PropertySet* wireProperties = NULL;
					PropertySet* _tmp9_ = NULL;
					PropertyItemSelection* selection = NULL;
					PropertyItemSelection* _tmp10_ = NULL;
					PropertyItemSelection* _tmp11_ = NULL;
					PropertyItemSelection* _tmp12_ = NULL;
					PropertyItemSelection* _tmp13_ = NULL;
					WireInst* _tmp14_ = NULL;
					WireInstPresetSignal _tmp15_ = 0;
					PropertySet* _tmp19_ = NULL;
					PropertyItemSelection* _tmp20_ = NULL;
					PropertiesQuery* wireQuery = NULL;
					DesignerWindow* _tmp21_ = NULL;
					PropertySet* _tmp22_ = NULL;
					PropertiesQuery* _tmp23_ = NULL;
					PropertiesQuery* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					_tmp9_ = property_set_new ("Wire", "Wire Properties");
					wireProperties = _tmp9_;
					_tmp10_ = property_item_selection_new ("Initial Signal", "Wire's preset signal at the start of simulation");
					selection = _tmp10_;
					_tmp11_ = selection;
					property_item_selection_add_option (_tmp11_, "default", "Default");
					_tmp12_ = selection;
					property_item_selection_add_option (_tmp12_, "0", "0 (False)");
					_tmp13_ = selection;
					property_item_selection_add_option (_tmp13_, "1", "1 (True)");
					_tmp14_ = wireInst;
					_tmp15_ = _tmp14_->presetSignal;
					switch (_tmp15_) {
						case WIRE_INST_PRESET_SIGNAL_DEFAULT:
						{
							PropertyItemSelection* _tmp16_ = NULL;
							_tmp16_ = selection;
							property_item_selection_set_option (_tmp16_, "default");
							break;
						}
						case WIRE_INST_PRESET_SIGNAL_FALSE:
						{
							PropertyItemSelection* _tmp17_ = NULL;
							_tmp17_ = selection;
							property_item_selection_set_option (_tmp17_, "0");
							break;
						}
						case WIRE_INST_PRESET_SIGNAL_TRUE:
						{
							PropertyItemSelection* _tmp18_ = NULL;
							_tmp18_ = selection;
							property_item_selection_set_option (_tmp18_, "1");
							break;
						}
						default:
						break;
					}
					_tmp19_ = wireProperties;
					_tmp20_ = selection;
					property_set_add_item (_tmp19_, (PropertyItem*) _tmp20_);
					_tmp21_ = self->window;
					_tmp22_ = wireProperties;
					_tmp23_ = properties_query_new ("Wire Properties", (GtkWindow*) _tmp21_, _tmp22_);
					wireQuery = _tmp23_;
					_tmp24_ = wireQuery;
					_tmp25_ = properties_query_run (_tmp24_);
					if (_tmp25_ == ((gint) GTK_RESPONSE_APPLY)) {
						PropertyItemSelection* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						GQuark _tmp30_ = 0U;
						static GQuark _tmp29_label0 = 0;
						static GQuark _tmp29_label1 = 0;
						static GQuark _tmp29_label2 = 0;
						_tmp26_ = selection;
						_tmp27_ = property_item_selection_get_option (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
						g_free (_tmp28_);
						if (_tmp30_ == ((0 != _tmp29_label0) ? _tmp29_label0 : (_tmp29_label0 = g_quark_from_static_string ("default")))) {
							switch (0) {
								default:
								{
									WireInst* _tmp31_ = NULL;
									_tmp31_ = wireInst;
									_tmp31_->presetSignal = WIRE_INST_PRESET_SIGNAL_DEFAULT;
									break;
								}
							}
						} else if (_tmp30_ == ((0 != _tmp29_label1) ? _tmp29_label1 : (_tmp29_label1 = g_quark_from_static_string ("0")))) {
							switch (0) {
								default:
								{
									WireInst* _tmp32_ = NULL;
									_tmp32_ = wireInst;
									_tmp32_->presetSignal = WIRE_INST_PRESET_SIGNAL_FALSE;
									break;
								}
							}
						} else if (_tmp30_ == ((0 != _tmp29_label2) ? _tmp29_label2 : (_tmp29_label2 = g_quark_from_static_string ("1")))) {
							switch (0) {
								default:
								{
									WireInst* _tmp33_ = NULL;
									_tmp33_ = wireInst;
									_tmp33_->presetSignal = WIRE_INST_PRESET_SIGNAL_TRUE;
									break;
								}
							}
						}
					}
					_properties_query_unref0 (wireQuery);
					_property_item_unref0 (selection);
					_property_item_unref0 (wireProperties);
				}
				_tmp34_ = wireInst;
				_tmp35_ = x;
				_tmp36_ = y;
				_tmp37_ = wire_inst_find_tag (_tmp34_, _tmp35_, _tmp36_);
				if (_tmp37_ == 1) {
					WireInst* _tmp38_ = NULL;
					Tag* _tmp39_ = NULL;
					gint _tmp40_ = 0;
					WireInst* _tmp41_ = NULL;
					Tag* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					WireInst* _tmp44_ = NULL;
					Tag* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					WireInst* _tmp47_ = NULL;
					Tag* _tmp48_ = NULL;
					gint _tmp49_ = 0;
					_tmp38_ = wireInst;
					_tmp39_ = _tmp38_->interfaceTag;
					_tmp40_ = _tmp39_->xWire;
					_tmp41_ = wireInst;
					_tmp42_ = _tmp41_->interfaceTag;
					_tmp43_ = _tmp42_->yWire;
					_tmp44_ = wireInst;
					_tmp45_ = _tmp44_->interfaceTag;
					_tmp46_ = _tmp45_->xTag;
					_tmp47_ = wireInst;
					_tmp48_ = _tmp47_->interfaceTag;
					_tmp49_ = _tmp48_->yTag;
					designer_tag_wire (self, _tmp40_, _tmp43_, _tmp46_, _tmp49_, TRUE);
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
}


/**
 * Selects any components on the point (//x//, //y//), deselecting
 * others.
 * If //toggle// is true, it toggles if on (//x//, //y//) instead.
 */
void designer_select_components (Designer* self, gint x, gint y, gboolean toggle) {
	CustomComponentDef* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->componentInsts;
	_tmp1__length1 = _tmp0_->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				_tmp3_ = componentInst;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = toggle;
				component_inst_try_select (_tmp3_, _tmp4_, _tmp5_, _tmp6_);
				_component_inst_unref0 (componentInst);
			}
		}
	}
}


/**
 * Selects any wires passing through (//x//, //y//), deselecting
 * others.
 * If //toggle// is true, it toggles if on (//x//, //y//) instead.
 */
void designer_select_wires (Designer* self, gint x, gint y, gboolean toggle, gboolean includeTag) {
	CustomComponentDef* _tmp0_ = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->wireInsts;
	_tmp1__length1 = _tmp0_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				WireInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				_tmp3_ = wireInst;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = toggle;
				_tmp7_ = includeTag;
				wire_inst_try_select (_tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
				_wire_inst_unref0 (wireInst);
			}
		}
	}
}


/**
 * Selects any annotations on the point (//x//, //y//), deselecting
 * others.
 * If //toggle// is true, it toggles if on (//x//, //y//) instead.
 */
void designer_select_annotations (Designer* self, gint x, gint y, gboolean toggle) {
	CustomComponentDef* _tmp0_ = NULL;
	Annotation** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->annotations;
	_tmp1__length1 = _tmp0_->annotations_length1;
	{
		Annotation** annotation_collection = NULL;
		gint annotation_collection_length1 = 0;
		gint _annotation_collection_size_ = 0;
		gint annotation_it = 0;
		annotation_collection = _tmp1_;
		annotation_collection_length1 = _tmp1__length1;
		for (annotation_it = 0; annotation_it < _tmp1__length1; annotation_it = annotation_it + 1) {
			Annotation* _tmp2_ = NULL;
			Annotation* annotation = NULL;
			_tmp2_ = _annotation_ref0 (annotation_collection[annotation_it]);
			annotation = _tmp2_;
			{
				Annotation* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				_tmp3_ = annotation;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = toggle;
				annotation_try_select (_tmp3_, _tmp4_, _tmp5_, _tmp6_);
				_annotation_unref0 (annotation);
			}
		}
	}
}


/**
 * Translates any selected components by //x// horizontally, //y//
 * vertically. If //ignoreSelect// is true, all components move.
 */
void designer_move_components (Designer* self, gint x, gint y, gboolean ignoreSelect, gboolean autoBind) {
	CustomComponentDef* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->componentInsts;
	_tmp1__length1 = _tmp0_->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				ComponentInst* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp3_ = componentInst;
				_tmp4_ = x;
				_tmp5_ = y;
				component_inst_move (_tmp3_, _tmp4_, _tmp5_, FALSE);
				_tmp7_ = componentInst;
				_tmp8_ = _tmp7_->selected;
				if (_tmp8_) {
					gboolean _tmp9_ = FALSE;
					_tmp9_ = autoBind;
					_tmp6_ = _tmp9_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					ComponentInst* _tmp10_ = NULL;
					_tmp10_ = componentInst;
					designer_auto_connect_component (self, _tmp10_);
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
}


/**
 * Translates any selected wires by //x// horizontally, //y//
 * vertically. If //ignoreSelect// is true, all wires move.
 */
void designer_move_wires (Designer* self, gint x, gint y, gboolean ignoreSelect, gboolean autoBind) {
	CustomComponentDef* _tmp0_ = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->wireInsts;
	_tmp1__length1 = _tmp0_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				WireInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				WireInst* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp3_ = wireInst;
				_tmp4_ = x;
				_tmp5_ = y;
				wire_inst_move (_tmp3_, _tmp4_, _tmp5_, FALSE);
				_tmp7_ = wireInst;
				_tmp8_ = _tmp7_->selected;
				if (_tmp8_) {
					gboolean _tmp9_ = FALSE;
					_tmp9_ = autoBind;
					_tmp6_ = _tmp9_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					WireInst* _tmp10_ = NULL;
					_tmp10_ = wireInst;
					designer_auto_connect_wire (self, _tmp10_);
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
}


/**
 * Translates any selected annotations by //x// horizontally, //y//
 * vertically. If //ignoreSelect// is true, all annotations move.
 */
void designer_move_annotations (Designer* self, gint x, gint y, gboolean ignoreSelect) {
	CustomComponentDef* _tmp0_ = NULL;
	Annotation** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->annotations;
	_tmp1__length1 = _tmp0_->annotations_length1;
	{
		Annotation** annotation_collection = NULL;
		gint annotation_collection_length1 = 0;
		gint _annotation_collection_size_ = 0;
		gint annotation_it = 0;
		annotation_collection = _tmp1_;
		annotation_collection_length1 = _tmp1__length1;
		for (annotation_it = 0; annotation_it < _tmp1__length1; annotation_it = annotation_it + 1) {
			Annotation* _tmp2_ = NULL;
			Annotation* annotation = NULL;
			_tmp2_ = _annotation_ref0 (annotation_collection[annotation_it]);
			annotation = _tmp2_;
			{
				Annotation* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp3_ = annotation;
				_tmp4_ = x;
				_tmp5_ = y;
				annotation_move (_tmp3_, _tmp4_, _tmp5_, FALSE);
				_annotation_unref0 (annotation);
			}
		}
	}
}


/**
 * Flips any selected components.
 */
void designer_flip_component (Designer* self, gboolean autoBind) {
	CustomComponentDef* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->componentInsts;
	_tmp1__length1 = _tmp0_->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				ComponentInst* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				_tmp3_ = componentInst;
				component_inst_flip (_tmp3_, FALSE);
				_tmp5_ = componentInst;
				_tmp6_ = _tmp5_->selected;
				if (_tmp6_) {
					gboolean _tmp7_ = FALSE;
					_tmp7_ = autoBind;
					_tmp4_ = _tmp7_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					ComponentInst* _tmp8_ = NULL;
					_tmp8_ = componentInst;
					designer_auto_connect_component (self, _tmp8_);
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
}


/**
 * Changes the rotation of any selected components.
 */
void designer_orientate_component (Designer* self, Direction direction, gboolean autoBind) {
	CustomComponentDef* _tmp0_ = NULL;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->componentInsts;
	_tmp1__length1 = _tmp0_->componentInsts_length1;
	{
		ComponentInst** componentInst_collection = NULL;
		gint componentInst_collection_length1 = 0;
		gint _componentInst_collection_size_ = 0;
		gint componentInst_it = 0;
		componentInst_collection = _tmp1_;
		componentInst_collection_length1 = _tmp1__length1;
		for (componentInst_it = 0; componentInst_it < _tmp1__length1; componentInst_it = componentInst_it + 1) {
			ComponentInst* _tmp2_ = NULL;
			ComponentInst* componentInst = NULL;
			_tmp2_ = _component_inst_ref0 (componentInst_collection[componentInst_it]);
			componentInst = _tmp2_;
			{
				ComponentInst* _tmp3_ = NULL;
				Direction _tmp4_ = 0;
				gboolean _tmp5_ = FALSE;
				ComponentInst* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp3_ = componentInst;
				_tmp4_ = direction;
				component_inst_orientate (_tmp3_, _tmp4_, FALSE);
				_tmp6_ = componentInst;
				_tmp7_ = _tmp6_->selected;
				if (_tmp7_) {
					gboolean _tmp8_ = FALSE;
					_tmp8_ = autoBind;
					_tmp5_ = _tmp8_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					ComponentInst* _tmp9_ = NULL;
					_tmp9_ = componentInst;
					designer_auto_connect_component (self, _tmp9_);
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
}


/**
 * Deletes any components at (//x//, //y//).
 */
void designer_delete_components (Designer* self, gint x, gint y) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CustomComponentDef* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	designer_select_components (self, _tmp0_, _tmp1_, FALSE);
	_tmp2_ = self->customComponentDef;
	custom_component_def_delete_selected_components (_tmp2_);
}


/**
 * Deletes any wires passing through (//x//, //y//).
 */
void designer_delete_wires (Designer* self, gint x, gint y) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CustomComponentDef* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	designer_select_wires (self, _tmp0_, _tmp1_, FALSE, FALSE);
	_tmp2_ = self->customComponentDef;
	custom_component_def_delete_selected_wires (_tmp2_);
	_tmp3_ = self->priv->hasPath;
	if (_tmp3_) {
		Path* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp4_ = self->priv->currentPath;
		_tmp5_ = x;
		_tmp6_ = y;
		_tmp7_ = path_find (_tmp4_, _tmp5_, _tmp6_);
		if (_tmp7_ != 0) {
			self->priv->hasPath = FALSE;
		}
	}
}


/**
 * Deletes any tags at (//x//, //y//).
 */
void designer_delete_tags (Designer* self, gint x, gint y) {
	CustomComponentDef* _tmp0_ = NULL;
	WireInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->customComponentDef;
	_tmp1_ = _tmp0_->wireInsts;
	_tmp1__length1 = _tmp0_->wireInsts_length1;
	{
		WireInst** wireInst_collection = NULL;
		gint wireInst_collection_length1 = 0;
		gint _wireInst_collection_size_ = 0;
		gint wireInst_it = 0;
		wireInst_collection = _tmp1_;
		wireInst_collection_length1 = _tmp1__length1;
		for (wireInst_it = 0; wireInst_it < _tmp1__length1; wireInst_it = wireInst_it + 1) {
			WireInst* _tmp2_ = NULL;
			WireInst* wireInst = NULL;
			_tmp2_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
			wireInst = _tmp2_;
			{
				WireInst* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				_tmp3_ = wireInst;
				_tmp4_ = x;
				_tmp5_ = y;
				_tmp6_ = wire_inst_find_tag (_tmp3_, _tmp4_, _tmp5_);
				if (_tmp6_ == 1) {
					WireInst* _tmp7_ = NULL;
					_tmp7_ = wireInst;
					_tag_unref0 (_tmp7_->interfaceTag);
					_tmp7_->interfaceTag = NULL;
				}
				_wire_inst_unref0 (wireInst);
			}
		}
	}
}


/**
 * Deletes any annotations at (//x//, //y//).
 */
void designer_delete_annotations (Designer* self, gint x, gint y) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CustomComponentDef* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	designer_select_annotations (self, _tmp0_, _tmp1_, FALSE);
	_tmp2_ = self->customComponentDef;
	custom_component_def_delete_selected_annotations (_tmp2_);
}


/**
 * Saves the component being designed to the file specified by
 * //fileName//.
 */
static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


gint designer_save_component (Designer* self, const gchar* filename) {
	gint result = 0;
	CustomComponentDef** componentChain = NULL;
	gint componentChain_length1 = 0;
	gint _componentChain_size_ = 0;
	FILE* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	CustomComponentDef** _tmp2_ = NULL;
	CustomComponentDef** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	CustomComponentDef** _tmp5_ = NULL;
	CustomComponentDef** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (filename != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking circuit for cyclic dependences before saving.\n");
	_tmp1_ = self->customComponentDef;
	_tmp2_ = g_new0 (CustomComponentDef*, 0 + 1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 0;
	_tmp5_ = custom_component_def_validate_dependencies (_tmp1_, _tmp3_, 0, &_tmp4_);
	componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
	componentChain = _tmp5_;
	componentChain_length1 = _tmp4_;
	_componentChain_size_ = componentChain_length1;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) component_def_unref), NULL);
	_tmp6_ = componentChain;
	_tmp6__length1 = componentChain_length1;
	if (_tmp6_ != NULL) {
		gchar* errorMessage = NULL;
		gchar* _tmp7_ = NULL;
		FILE* _tmp8_ = NULL;
		CustomComponentDef** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		FILE* _tmp19_ = NULL;
		GtkMessageDialog* messageDialog = NULL;
		const gchar* _tmp20_ = NULL;
		GtkMessageDialog* _tmp21_ = NULL;
		GtkMessageDialog* _tmp22_ = NULL;
		GtkMessageDialog* _tmp23_ = NULL;
		_tmp7_ = g_strdup ("");
		errorMessage = _tmp7_;
		_tmp8_ = stdout;
		fprintf (_tmp8_, "Component Failed Cyclic Dependency Test\n");
		_tmp9_ = componentChain;
		_tmp9__length1 = componentChain_length1;
		{
			CustomComponentDef** customComponentDef_collection = NULL;
			gint customComponentDef_collection_length1 = 0;
			gint _customComponentDef_collection_size_ = 0;
			gint customComponentDef_it = 0;
			customComponentDef_collection = _tmp9_;
			customComponentDef_collection_length1 = _tmp9__length1;
			for (customComponentDef_it = 0; customComponentDef_it < _tmp9__length1; customComponentDef_it = customComponentDef_it + 1) {
				CustomComponentDef* _tmp10_ = NULL;
				CustomComponentDef* customComponentDef = NULL;
				_tmp10_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
				customComponentDef = _tmp10_;
				{
					const gchar* _tmp11_ = NULL;
					CustomComponentDef* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp11_ = errorMessage;
					_tmp12_ = customComponentDef;
					_tmp13_ = ((ComponentDef*) _tmp12_)->name;
					_tmp14_ = g_strconcat ("  ", _tmp13_, NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strconcat (_tmp11_, _tmp17_, NULL);
					_g_free0 (errorMessage);
					errorMessage = _tmp18_;
					_g_free0 (_tmp17_);
					_g_free0 (_tmp15_);
					_component_def_unref0 (customComponentDef);
				}
			}
		}
		_tmp19_ = stdout;
		fprintf (_tmp19_, "Circuit failed validation check.\n");
		_tmp20_ = errorMessage;
		_tmp21_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "You cannot save this circuit because it contains a cyclic dependency. " \
"This means that it contains something which contains itself. The faile" \
"d ancestry is shown:\n" \
"%s", _tmp20_);
		g_object_ref_sink (_tmp21_);
		messageDialog = _tmp21_;
		_tmp22_ = messageDialog;
		gtk_dialog_run ((GtkDialog*) _tmp22_);
		_tmp23_ = messageDialog;
		gtk_widget_destroy ((GtkWidget*) _tmp23_);
		_g_object_unref0 (messageDialog);
		_g_free0 (errorMessage);
	} else {
		CustomComponentDef* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		CustomComponentDef* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		_tmp24_ = self->customComponentDef;
		_tmp25_ = filename;
		custom_component_def_save (_tmp24_, _tmp25_);
		_tmp26_ = self->customComponentDef;
		_tmp27_ = filename;
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (((ComponentDef*) _tmp26_)->filename);
		((ComponentDef*) _tmp26_)->filename = _tmp28_;
	}
	result = 0;
	componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
	return result;
}


/**
 * Starts a Customiser to prepare the component being designed for
 * insertion and wiring in another component.
 */
void designer_customise_component (Designer* self) {
	Customiser* customiser = NULL;
	DesignerWindow* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	Project* _tmp2_ = NULL;
	Customiser* _tmp3_ = NULL;
	DesignerWindow* _tmp4_ = NULL;
	Project* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window;
	_tmp1_ = self->customComponentDef;
	_tmp2_ = self->priv->project;
	_tmp3_ = customiser_new (_tmp0_, _tmp1_, _tmp2_);
	customiser = _tmp3_;
	customiser_run (customiser);
	_tmp4_ = self->window;
	designer_window_update_title (_tmp4_);
	_tmp5_ = self->priv->project;
	project_update_custom_menus (_tmp5_);
	_customiser_unref0 (customiser);
}


/**
 * Renders the current component's design.
 */
void designer_render (Designer* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CustomComponentDef* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	cairo_t* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = designer_get_hasComponent (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		cairo_text_extents_t textExtents = {0};
		cairo_t* _tmp2_ = NULL;
		cairo_t* _tmp3_ = NULL;
		cairo_text_extents_t _tmp4_ = {0};
		cairo_t* _tmp5_ = NULL;
		cairo_text_extents_t _tmp6_ = {0};
		gdouble _tmp7_ = 0.0;
		cairo_text_extents_t _tmp8_ = {0};
		gdouble _tmp9_ = 0.0;
		cairo_t* _tmp10_ = NULL;
		cairo_t* _tmp11_ = NULL;
		cairo_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		_tmp2_ = context;
		cairo_set_font_size (_tmp2_, 12.0);
		_tmp3_ = context;
		cairo_text_extents (_tmp3_, "There is no component.", &_tmp4_);
		textExtents = _tmp4_;
		_tmp5_ = context;
		_tmp6_ = textExtents;
		_tmp7_ = _tmp6_.width;
		_tmp8_ = textExtents;
		_tmp9_ = _tmp8_.height;
		cairo_translate (_tmp5_, (-_tmp7_) / 2, (+_tmp9_) / 2);
		_tmp10_ = context;
		cairo_set_source_rgb (_tmp10_, 0.75, 0.75, 0.75);
		_tmp11_ = context;
		cairo_paint (_tmp11_);
		_tmp12_ = context;
		cairo_set_source_rgb (_tmp12_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
		_tmp13_ = context;
		cairo_show_text (_tmp13_, "There is no component.");
		_tmp14_ = context;
		cairo_stroke (_tmp14_);
		return;
	}
	_tmp15_ = self->customComponentDef;
	_tmp16_ = context;
	_tmp17_ = showHints;
	_tmp18_ = showErrors;
	_tmp19_ = colourBackgrounds;
	custom_component_def_render_insts (_tmp15_, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
	_tmp20_ = context;
	cairo_set_source_rgb (_tmp20_, 0.5, 0.5, 0.5);
	_tmp21_ = self->priv->hasPath;
	if (_tmp21_) {
		Path* _tmp22_ = NULL;
		cairo_t* _tmp23_ = NULL;
		_tmp22_ = self->priv->currentPath;
		_tmp23_ = context;
		path_render (_tmp22_, _tmp23_);
	}
}


gboolean designer_get_hasComponent (Designer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_hasComponent;
	result = _tmp0_;
	return result;
}


static void designer_set_hasComponent (Designer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hasComponent = _tmp0_;
}


static gboolean designer_get_hasInsert (Designer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_hasInsert;
	result = _tmp0_;
	return result;
}


static void designer_set_hasInsert (Designer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hasInsert = _tmp0_;
}


const gchar* designer_get_designerName (Designer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_designerName;
	result = _tmp0_;
	return result;
}


static void designer_set_designerName (Designer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_designerName);
	self->priv->_designerName = _tmp1_;
}


static void value_designer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_designer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		designer_unref (value->data[0].v_pointer);
	}
}


static void value_designer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = designer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_designer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_designer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Designer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = designer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_designer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Designer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = designer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_designer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDesigner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DESIGNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_designer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DESIGNER), NULL);
	return value->data[0].v_pointer;
}


void value_set_designer (GValue* value, gpointer v_object) {
	Designer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DESIGNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DESIGNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		designer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		designer_unref (old);
	}
}


void value_take_designer (GValue* value, gpointer v_object) {
	Designer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DESIGNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DESIGNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		designer_unref (old);
	}
}


static void designer_class_init (DesignerClass * klass) {
	designer_parent_class = g_type_class_peek_parent (klass);
	DESIGNER_CLASS (klass)->finalize = designer_finalize;
	g_type_class_add_private (klass, sizeof (DesignerPrivate));
}


static void designer_instance_init (Designer * self) {
	self->priv = DESIGNER_GET_PRIVATE (self);
	self->priv->_hasComponent = FALSE;
	self->priv->_hasInsert = FALSE;
	self->priv->hasPath = FALSE;
	self->ref_count = 1;
}


static void designer_finalize (Designer* obj) {
	Designer * self;
	FILE* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESIGNER, Designer);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Designer Destroyed\n");
	_g_free0 (self->priv->_designerName);
	_component_inst_unref0 (self->shadowComponentInst);
	_path_unref0 (self->priv->currentPath);
}


/**
 * Used to edit a custom component.
 */
GType designer_get_type (void) {
	static volatile gsize designer_type_id__volatile = 0;
	if (g_once_init_enter (&designer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_designer_init, value_designer_free_value, value_designer_copy_value, value_designer_peek_pointer, "p", value_designer_collect_value, "p", value_designer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DesignerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) designer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Designer), 0, (GInstanceInitFunc) designer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType designer_type_id;
		designer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Designer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&designer_type_id__volatile, designer_type_id);
	}
	return designer_type_id__volatile;
}


gpointer designer_ref (gpointer instance) {
	Designer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void designer_unref (gpointer instance) {
	Designer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DESIGNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



